/*
 * Copyright (C) 2009 Gnome Shell
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  General Public License
 * version 2.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2.0 for more details.
 *
 * You should have received a copy of the GNU  General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Taken from the Gnome Shell Project (src/)
 */

#ifndef __SHELL_GTK_EMBED_H__
#define __SHELL_GTK_EMBED_H__

#include <clutter/glx/clutter-glx.h>

#include "shell-embedded-window.h"

#define SHELL_TYPE_GTK_EMBED                 (shell_gtk_embed_get_type ())
#define SHELL_GTK_EMBED(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHELL_TYPE_GTK_EMBED, ShellGtkEmbed))
#define SHELL_GTK_EMBED_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), SHELL_TYPE_GTK_EMBED, ShellGtkEmbedClass))
#define SHELL_IS_GTK_EMBED(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHELL_TYPE_GTK_EMBED))
#define SHELL_IS_GTK_EMBED_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), SHELL_TYPE_GTK_EMBED))
#define SHELL_GTK_EMBED_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), SHELL_TYPE_GTK_EMBED, ShellGtkEmbedClass))

typedef struct _ShellGtkEmbed        ShellGtkEmbed;
typedef struct _ShellGtkEmbedClass   ShellGtkEmbedClass;

GType shell_gtk_embed_get_type (void) G_GNUC_CONST;
ClutterActor *shell_gtk_embed_new (ShellEmbeddedWindow *window);

#endif /* __SHELL_GTK_EMBED_H__ */
