// gpl v2
// (C) Neil Jagdish Patel <neil.patel@canonical.com>
#include <gtk/gtk.h>
#include <unity-misc/unity-misc.h>

static void
on_tray_icon_added (UnityTrayManager *manager,
                    ClutterActor     *icon,
                    ClutterActor     *stage)
{
  static gint x = -24;
  printf ("New icon\n");

  clutter_container_add_actor (CLUTTER_CONTAINER (stage), icon);
  clutter_actor_set_position (icon, x += 24, 0);
  clutter_actor_set_size (icon, 24, 24);
  clutter_actor_set_opacity (icon, 100);
  clutter_actor_show (icon);
}

static void
on_tray_icon_removed (UnityTrayManager *manager,
                      ClutterActor     *icon,
                      ClutterActor     *stage)
{
  printf ("Old icon\n");
}

static gboolean
_idle (ClutterActor *stage)
{
  UnityTrayManager *manager;

  manager = unity_tray_manager_new ();
  g_signal_connect (manager, "tray-icon-added",
                    G_CALLBACK (on_tray_icon_added), stage);
  g_signal_connect (manager, "tray-icon-removed",
                    G_CALLBACK (on_tray_icon_removed), stage);
  unity_tray_manager_manage_stage (manager, CLUTTER_STAGE (stage));

  return FALSE;
}

int
main (int argc, char *argv[])
{
  ClutterActor     *stage;
  //UnityTrayManager *manager;

  clutter_init (&argc, &argv);
  gtk_init (&argc, &argv);

  stage = clutter_stage_get_default ();
  clutter_actor_set_size (stage, 150, 24);

  g_idle_add ((GSourceFunc)_idle, stage);
  /*
  manager = unity_tray_manager_new ();
  g_signal_connect (manager, "tray-icon-added",
                    G_CALLBACK (on_tray_icon_added), stage);
  g_signal_connect (manager, "tray-icon-removed",
                    G_CALLBACK (on_tray_icon_removed), stage);
  unity_tray_manager_manage_stage (manager, CLUTTER_STAGE (stage));
  */

  clutter_actor_show (stage);

  gtk_main ();

  return 0;
}
