/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2009-2010 Canonical Services Ltd (www.canonical.com)
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <dbus/dbus-glib.h>
#include "authentication.h"

static DBusGConnection *bus = NULL;
static DBusGProxy *auth_proxy = NULL;

void
authentication_init (void)
{
	GError *error;

	/* Initialize connection to DBus if not done already */
	if (bus == NULL) {
		error = NULL;
		bus = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
		if (error) {
			g_warning ("Couldn't get session bus: %s", error->message);
			g_error_free (error);
			return;
		}
	}

	/* Initialize connection to authentication service */
	if (auth_proxy == NULL) {
		auth_proxy = dbus_g_proxy_new_for_name (bus, "com.ubuntuone.Authentication",
							"/", "com.ubuntuone.Authentication");
	}
}

void
authentication_set_callbacks (GCallback authorization_denied_cb,
			      GCallback no_credentials_cb,
			      GCallback new_credentials_cb,
			      GCallback oauth_error_cb,
			      gpointer user_data)
{
	authentication_init ();

	dbus_g_proxy_add_signal (auth_proxy, "AuthorizationDenied", G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (auth_proxy, "AuthorizationDenied",
				     G_CALLBACK (authorization_denied_cb),
				     user_data,
				     NULL);

	dbus_g_proxy_add_signal (auth_proxy, "NoCredentials", G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (auth_proxy, "NoCredentials",
				     G_CALLBACK (no_credentials_cb),
				     user_data,
				     NULL);
			
	dbus_g_proxy_add_signal (auth_proxy, "NewCredentials", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (auth_proxy, "NewCredentials",
				     G_CALLBACK (new_credentials_cb),
				     user_data,
				     NULL);

	dbus_g_proxy_add_signal (auth_proxy, "OAuthError", G_TYPE_STRING, G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (auth_proxy, "OAuthError",
				     G_CALLBACK (oauth_error_cb),
				     user_data,
				     NULL);
}

gboolean
authentication_login (void)
{
	gboolean success;
	GError *error = NULL;

	authentication_init ();

	success = dbus_g_proxy_call (auth_proxy, "login", &error,
				     G_TYPE_STRING, "https://ubuntuone.com",
				     G_TYPE_STRING, "ubuntuone",
				     G_TYPE_INVALID,
				     G_TYPE_INVALID);
	if (!success) {
		if (error != NULL) {
			g_warning ("DBus call error: %s", error->message);
			g_error_free (error);
		} else
			g_warning ("Failed calling login DBus method");
	}

	return success;
}

void
authentication_clear_tokens (void)
{
	gboolean success;
	GError *error = NULL;

	g_debug ("Clear_tokens");
	authentication_init ();

	success = dbus_g_proxy_call (auth_proxy, "clear_token", &error,
				     G_TYPE_STRING, "https://ubuntuone.com",
				     G_TYPE_STRING, "ubuntuone",
				     G_TYPE_INVALID,
				     G_TYPE_INVALID);
	if (!success) {
		if (error != NULL) {
			g_warning ("DBus call error: %s", error->message);
			g_error_free (error);
		} else
			g_warning ("Failed calling clear_token DBus method");
	}
}
