#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <selinux/selinux.h>
#include <selinux/get_context_list.h>

int main(int argc, char **argv) 
{
	security_context_t *list, usercon = NULL, cur_context = NULL;
	int ret, i;

	if (argc < 2 || argc > 3) {
		fprintf(stderr, "usage:  %s user [context]\n", argv[0]);
		return 1;
	}

	/* If selinux isn't available, bail out. */
	if( !is_selinux_enabled() ) {
	    fprintf( stderr,
        	"getconlist may be used only on a SELinux kernel.\n" );
	    return 1;
	}

	/* If a context wasn't passed, use the current context. */
	if (argc < 3) {
		if (getcon(&cur_context) < 0) {
			fprintf( stderr, "Couldn't get current context.\n" );
			return 2;
		}
	}
	else
		cur_context = argv[2];

	/* Get the list and print it */
	ret = get_ordered_context_list(argv[1], cur_context, &list);
	if(ret != -1) {
		for (i = 0; list[i]; i++)
			puts (list[i]);
		freeconary(list);
	}

	free(usercon);

	return 0;
}
