Summary: SELinux library and simple utilities
Name: libselinux
Version: 1.24
Release: 1
License: Public domain (uncopyrighted)
Group: System Environment/Libraries
Source: http://www.nsa.gov/selinux/archives/%{name}-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-buildroot

%description
Security-enhanced Linux is a patch of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

libselinux provides an API for SELinux applications to get and set
process and file security contexts and to obtain security policy
decisions.  Required for any applications that use the SELinux API.

%package devel
Summary: Header files and libraries used to build SELinux
Group: Development/Libraries
Requires: libselinux = %{version}

%description devel
The selinux-devel package contains the static libraries and header files
needed for developing SELinux applications. 

%prep
%setup -q

%build
make CFLAGS="%{optflags}"

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{_lib} 
mkdir -p ${RPM_BUILD_ROOT}/%{_libdir} 
mkdir -p ${RPM_BUILD_ROOT}%{_includedir} 
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
make DESTDIR="${RPM_BUILD_ROOT}" LIBDIR="${RPM_BUILD_ROOT}%{_libdir}" SHLIBDIR="${RPM_BUILD_ROOT}/%{_lib}" install

%clean
rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files devel
%defattr(-,root,root)
%{_libdir}/libselinux.a
%{_libdir}/libselinux.so
%dir %{_includedir}/selinux
%{_includedir}/selinux/
%{_mandir}/man3/*

%files
%defattr(-,root,root,0755)
/%{_lib}/libselinux.so.*
%{_sbindir}/*
%{_mandir}/man8/*

%changelog
