
# Introduction

[![Build Status](https://travis-ci.org/liblouis/liblouisutdml.svg?branch=master)](https://travis-ci.org/liblouis/liblouisutdml)

Liblouisutdml is an open-source library providing complete braille
transcription services for xml, html and text documents. It translates
into appropriate braille codes and formats according to its style
sheet and the specifications in the document. A command-line program,
`file2brl` which uses this library is also included. The latest
version of liblouis is required. Java bindings are built in to the
library.

The library is licensed under the GNU Lesser General Public License
(LGPL) version 3 or later. See the file COPYING.LIB.

The command line tools, are licensed under the GNU General Public
License version 3.0 or later. See the file COPYING.

# Documentation

For documentation, see `liblouisutdml.html` or `liblouisutdml.txt`.
These are in the docs directory. For an example of a configuration
file, see `liblouisutdml.ini` and `preferences.cfg`. For examples of
semantics-action files, see `dtbook.sem` and `nemeth.sem`. These files
are in the `lbu_files` subdirectory. For examples of translation
tables, see `en-us-g2.ctb`, `en-us-g1.ctb`, `chardefs.cti`,
`nemeth.ctb` and whatever other files they may include. These are all
in the `tables` directory of
[liblouis][].

# Installation

First obtain the latest version of [liblouis][] and compile it. Before
compiling, you should chose between 16- and 32-bit Unicode, as
described in the README file and the documentation. liblouisutdml
inherits this choice from liblouis.

After unpacking the distribution tarball for liblouisutdml go to the
directory it creates. After running `configure` run `make` and `make
install`. You will need root privileges for the installation step.

This will produce the liblouisutdml library and the program
`file2brl`. To compile the Java bindings go to the java subdirectory
and run `ant`.

Note that that the library and programs will not work properly unless
you have first installed the latest version of [liblouis][].

# Docker

There are docker images for [liblouisutdml](https://hub.docker.com/r/liblouis/liblouisutdml/) and [liblouis](https://hub.docker.com/r/liblouis/liblouis/). So to run
liblouisutdml from docker simply type the following command which will bring you into a shell where you can invoke `file2brl`:

``` console
$ docker run -it liblouis/liblouisutdml /bin/bash
root@74a8b1ad5e03:/usr/src/liblouisutdml# file2brl --help
Usage: file2brl [OPTION] [inputFile] [outputFile]
Translate an xml or a text file into an embosser-ready braille file.
This includes translation into grade two, if desired, mathematical 
codes, etc. It also includes formatting according to a built-in 
style sheet which can be modified by the user.

If inputFile is not specified or '-' input is taken from stdin. If outputFile
is not specified the output is sent to stdout.

  -h, --help          	  display this help and exit
  -v, --version       	  display version information and exit
  -f, --config-file       name a configuration file that specifies
                          how to do the translation
  -b, --backward      	  backward translation
  -r, --reformat      	  reformat a braille file
  -T, --text		  Treat as text even if xml
  -t, --html              html document, not xhtml
  -p, --poorly-formatted  translate a poorly formatted file
  -P, --paragraph-line    treat each block of text ending in a newline
                          as a paragraph. If there are two newline characters
                          a blank line will be inserted before the next paragraph
  -C, --config-setting    specify particular configuration settings
                          They override any settings that are specified in a
                          config file
  -w  --writeable-path    path for temp files and log file
  -l, --log-file          write errors to file2brl.log instead of stderr

Report bugs to <liblouis-liblouisxml@freelists.org>.
root@74a8b1ad5e03:/usr/src/liblouisutdml# 
```
[liblouis]: http://www.liblouis.org/

<!-- Local Variables: -->
<!-- mode: markdown -->
<!-- End: -->
