/***************************************************************************
 *   Copyright (C) 2010 by Joris Guisson                                   *
 *   joris.guisson@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef BT_SIGNALCATCHER_H
#define BT_SIGNALCATCHER_H

#ifndef Q_WS_WIN

#include <ktorrent_export.h>
#include <signal.h>
#include <setjmp.h>
#include <util/error.h>

namespace bt 
{
	/**
		Variable used to jump from the SIGBUS handler back to the place which triggered the SIGBUS.
	*/
	extern KTORRENT_EXPORT sigjmp_buf sigbus_env;

	/**
		Install the SIGBUS signal handler. 
	*/
	KTORRENT_EXPORT bool InstallBusHandler();
	
	/**
		Exception throw when a SIGBUS is caught.
	*/
	class KTORRENT_EXPORT BusError : public bt::Error
	{
	public:
		BusError(bool write_operation);
		virtual ~BusError();
		
		/// Wether or not the SIGBUS was triggered by a write operation
		bool write_operation;
	};
}

/// Before writing to memory mapped data, call this macro to ensure that SIGBUS signals are caught and properly dealt with
#define BUS_ERROR_WPROTECT() InstallBusHandler(); if (sigsetjmp(bt::sigbus_env, 1)) throw bt::BusError(true)
	
/// Before reading from memory mapped data, call this macro to ensure that SIGBUS signals are caught and properly dealt with
#define BUS_ERROR_RPROTECT() InstallBusHandler(); if (sigsetjmp(bt::sigbus_env, 1)) throw bt::BusError(false)

#endif

#endif // BT_SIGNALCATCHER_H
