package Font::TTF::PSNames;

=head1 NAME

Font::TTF::PSNames - Utilities for Postscript glyph name processing

=head1 METHODS

=cut

use strict;
use vars qw(%names %agl @EXPORT_OK);
use Exporter qw( import );
@EXPORT_OK = qw( parse lookup);

# Adobe Glyph List for New Fonts	
# from http://partners.adobe.com/asn/tech/type/aglfn13.txt

%names = (
    '0020' => 'space',
    '0021' => 'exclam',
    '0022' => 'quotedbl',
    '0023' => 'numbersign',
    '0024' => 'dollar',
    '0025' => 'percent',
    '0026' => 'ampersand',
    '0027' => 'quotesingle',
    '0028' => 'parenleft',
    '0029' => 'parenright',
    '002A' => 'asterisk',
    '002B' => 'plus',
    '002C' => 'comma',
    '002D' => 'hyphen',
    '002E' => 'period',
    '002F' => 'slash',
    '0030' => 'zero',
    '0031' => 'one',
    '0032' => 'two',
    '0033' => 'three',
    '0034' => 'four',
    '0035' => 'five',
    '0036' => 'six',
    '0037' => 'seven',
    '0038' => 'eight',
    '0039' => 'nine',
    '003A' => 'colon',
    '003B' => 'semicolon',
    '003C' => 'less',
    '003D' => 'equal',
    '003E' => 'greater',
    '003F' => 'question',
    '0040' => 'at',
    '0041' => 'A',
    '0042' => 'B',
    '0043' => 'C',
    '0044' => 'D',
    '0045' => 'E',
    '0046' => 'F',
    '0047' => 'G',
    '0048' => 'H',
    '0049' => 'I',
    '004A' => 'J',
    '004B' => 'K',
    '004C' => 'L',
    '004D' => 'M',
    '004E' => 'N',
    '004F' => 'O',
    '0050' => 'P',
    '0051' => 'Q',
    '0052' => 'R',
    '0053' => 'S',
    '0054' => 'T',
    '0055' => 'U',
    '0056' => 'V',
    '0057' => 'W',
    '0058' => 'X',
    '0059' => 'Y',
    '005A' => 'Z',
    '005B' => 'bracketleft',
    '005C' => 'backslash',
    '005D' => 'bracketright',
    '005E' => 'asciicircum',
    '005F' => 'underscore',
    '0060' => 'grave',
    '0061' => 'a',
    '0062' => 'b',
    '0063' => 'c',
    '0064' => 'd',
    '0065' => 'e',
    '0066' => 'f',
    '0067' => 'g',
    '0068' => 'h',
    '0069' => 'i',
    '006A' => 'j',
    '006B' => 'k',
    '006C' => 'l',
    '006D' => 'm',
    '006E' => 'n',
    '006F' => 'o',
    '0070' => 'p',
    '0071' => 'q',
    '0072' => 'r',
    '0073' => 's',
    '0074' => 't',
    '0075' => 'u',
    '0076' => 'v',
    '0077' => 'w',
    '0078' => 'x',
    '0079' => 'y',
    '007A' => 'z',
    '007B' => 'braceleft',
    '007C' => 'bar',
    '007D' => 'braceright',
    '007E' => 'asciitilde',
#    '00A0' => 'space',
    '00A1' => 'exclamdown',
    '00A2' => 'cent',
    '00A3' => 'sterling',
    '00A4' => 'currency',
    '00A5' => 'yen',
    '00A6' => 'brokenbar',
    '00A7' => 'section',
    '00A8' => 'dieresis',
    '00A9' => 'copyright',
    '00AA' => 'ordfeminine',
    '00AB' => 'guillemotleft',
    '00AC' => 'logicalnot',
#    '00AD' => 'hyphen',
    '00AE' => 'registered',
    '00AF' => 'macron',
    '00B0' => 'degree',
    '00B1' => 'plusminus',
    '00B2' => 'twosuperior',
    '00B3' => 'threesuperior',
    '00B4' => 'acute',
    '00B5' => 'mu',
    '00B6' => 'paragraph',
    '00B7' => 'periodcentered',
    '00B8' => 'cedilla',
    '00B9' => 'onesuperior',
    '00BA' => 'ordmasculine',
    '00BB' => 'guillemotright',
    '00BC' => 'onequarter',
    '00BD' => 'onehalf',
    '00BE' => 'threequarters',
    '00BF' => 'questiondown',
    '00C0' => 'Agrave',
    '00C1' => 'Aacute',
    '00C2' => 'Acircumflex',
    '00C3' => 'Atilde',
    '00C4' => 'Adieresis',
    '00C5' => 'Aring',
    '00C6' => 'AE',
    '00C7' => 'Ccedilla',
    '00C8' => 'Egrave',
    '00C9' => 'Eacute',
    '00CA' => 'Ecircumflex',
    '00CB' => 'Edieresis',
    '00CC' => 'Igrave',
    '00CD' => 'Iacute',
    '00CE' => 'Icircumflex',
    '00CF' => 'Idieresis',
    '00D0' => 'Eth',
    '00D1' => 'Ntilde',
    '00D2' => 'Ograve',
    '00D3' => 'Oacute',
    '00D4' => 'Ocircumflex',
    '00D5' => 'Otilde',
    '00D6' => 'Odieresis',
    '00D7' => 'multiply',
    '00D8' => 'Oslash',
    '00D9' => 'Ugrave',
    '00DA' => 'Uacute',
    '00DB' => 'Ucircumflex',
    '00DC' => 'Udieresis',
    '00DD' => 'Yacute',
    '00DE' => 'Thorn',
    '00DF' => 'germandbls',
    '00E0' => 'agrave',
    '00E1' => 'aacute',
    '00E2' => 'acircumflex',
    '00E3' => 'atilde',
    '00E4' => 'adieresis',
    '00E5' => 'aring',
    '00E6' => 'ae',
    '00E7' => 'ccedilla',
    '00E8' => 'egrave',
    '00E9' => 'eacute',
    '00EA' => 'ecircumflex',
    '00EB' => 'edieresis',
    '00EC' => 'igrave',
    '00ED' => 'iacute',
    '00EE' => 'icircumflex',
    '00EF' => 'idieresis',
    '00F0' => 'eth',
    '00F1' => 'ntilde',
    '00F2' => 'ograve',
    '00F3' => 'oacute',
    '00F4' => 'ocircumflex',
    '00F5' => 'otilde',
    '00F6' => 'odieresis',
    '00F7' => 'divide',
    '00F8' => 'oslash',
    '00F9' => 'ugrave',
    '00FA' => 'uacute',
    '00FB' => 'ucircumflex',
    '00FC' => 'udieresis',
    '00FD' => 'yacute',
    '00FE' => 'thorn',
    '00FF' => 'ydieresis',
    '0100' => 'Amacron',
    '0101' => 'amacron',
    '0102' => 'Abreve',
    '0103' => 'abreve',
    '0104' => 'Aogonek',
    '0105' => 'aogonek',
    '0106' => 'Cacute',
    '0107' => 'cacute',
    '0108' => 'Ccircumflex',
    '0109' => 'ccircumflex',
    '010A' => 'Cdotaccent',
    '010B' => 'cdotaccent',
    '010C' => 'Ccaron',
    '010D' => 'ccaron',
    '010E' => 'Dcaron',
    '010F' => 'dcaron',
    '0110' => 'Dcroat',
    '0111' => 'dcroat',
    '0112' => 'Emacron',
    '0113' => 'emacron',
    '0114' => 'Ebreve',
    '0115' => 'ebreve',
    '0116' => 'Edotaccent',
    '0117' => 'edotaccent',
    '0118' => 'Eogonek',
    '0119' => 'eogonek',
    '011A' => 'Ecaron',
    '011B' => 'ecaron',
    '011C' => 'Gcircumflex',
    '011D' => 'gcircumflex',
    '011E' => 'Gbreve',
    '011F' => 'gbreve',
    '0120' => 'Gdotaccent',
    '0121' => 'gdotaccent',
    '0122' => 'Gcommaaccent',
    '0123' => 'gcommaaccent',
    '0124' => 'Hcircumflex',
    '0125' => 'hcircumflex',
    '0126' => 'Hbar',
    '0127' => 'hbar',
    '0128' => 'Itilde',
    '0129' => 'itilde',
    '012A' => 'Imacron',
    '012B' => 'imacron',
    '012C' => 'Ibreve',
    '012D' => 'ibreve',
    '012E' => 'Iogonek',
    '012F' => 'iogonek',
    '0130' => 'Idotaccent',
    '0131' => 'dotlessi',
    '0132' => 'IJ',
    '0133' => 'ij',
    '0134' => 'Jcircumflex',
    '0135' => 'jcircumflex',
    '0136' => 'Kcommaaccent',
    '0137' => 'kcommaaccent',
    '0138' => 'kgreenlandic',
    '0139' => 'Lacute',
    '013A' => 'lacute',
    '013B' => 'Lcommaaccent',
    '013C' => 'lcommaaccent',
    '013D' => 'Lcaron',
    '013E' => 'lcaron',
    '013F' => 'Ldot',
    '0140' => 'ldot',
    '0141' => 'Lslash',
    '0142' => 'lslash',
    '0143' => 'Nacute',
    '0144' => 'nacute',
    '0145' => 'Ncommaaccent',
    '0146' => 'ncommaaccent',
    '0147' => 'Ncaron',
    '0148' => 'ncaron',
    '0149' => 'napostrophe',
    '014A' => 'Eng',
    '014B' => 'eng',
    '014C' => 'Omacron',
    '014D' => 'omacron',
    '014E' => 'Obreve',
    '014F' => 'obreve',
    '0150' => 'Ohungarumlaut',
    '0151' => 'ohungarumlaut',
    '0152' => 'OE',
    '0153' => 'oe',
    '0154' => 'Racute',
    '0155' => 'racute',
    '0156' => 'Rcommaaccent',
    '0157' => 'rcommaaccent',
    '0158' => 'Rcaron',
    '0159' => 'rcaron',
    '015A' => 'Sacute',
    '015B' => 'sacute',
    '015C' => 'Scircumflex',
    '015D' => 'scircumflex',
    '015E' => 'Scedilla',
    '015F' => 'scedilla',
    '0160' => 'Scaron',
    '0161' => 'scaron',
    '0162' => 'Tcommaaccent',
    '0163' => 'tcommaaccent',
    '0164' => 'Tcaron',
    '0165' => 'tcaron',
    '0166' => 'Tbar',
    '0167' => 'tbar',
    '0168' => 'Utilde',
    '0169' => 'utilde',
    '016A' => 'Umacron',
    '016B' => 'umacron',
    '016C' => 'Ubreve',
    '016D' => 'ubreve',
    '016E' => 'Uring',
    '016F' => 'uring',
    '0170' => 'Uhungarumlaut',
    '0171' => 'uhungarumlaut',
    '0172' => 'Uogonek',
    '0173' => 'uogonek',
    '0174' => 'Wcircumflex',
    '0175' => 'wcircumflex',
    '0176' => 'Ycircumflex',
    '0177' => 'ycircumflex',
    '0178' => 'Ydieresis',
    '0179' => 'Zacute',
    '017A' => 'zacute',
    '017B' => 'Zdotaccent',
    '017C' => 'zdotaccent',
    '017D' => 'Zcaron',
    '017E' => 'zcaron',
    '017F' => 'longs',
    '0192' => 'florin',
    '01A0' => 'Ohorn',
    '01A1' => 'ohorn',
    '01AF' => 'Uhorn',
    '01B0' => 'uhorn',
    '01E6' => 'Gcaron',
    '01E7' => 'gcaron',
    '01FA' => 'Aringacute',
    '01FB' => 'aringacute',
    '01FC' => 'AEacute',
    '01FD' => 'aeacute',
    '01FE' => 'Oslashacute',
    '01FF' => 'oslashacute',
    '0218' => 'Scommaaccent',
    '0219' => 'scommaaccent',
#    '021A' => 'Tcommaaccent',
#    '021B' => 'tcommaaccent',
    '02BC' => 'afii57929',
    '02BD' => 'afii64937',
    '02C6' => 'circumflex',
    '02C7' => 'caron',
#    '02C9' => 'macron',
    '02D8' => 'breve',
    '02D9' => 'dotaccent',
    '02DA' => 'ring',
    '02DB' => 'ogonek',
    '02DC' => 'tilde',
    '02DD' => 'hungarumlaut',
    '0300' => 'gravecomb',
    '0301' => 'acutecomb',
    '0303' => 'tildecomb',
    '0309' => 'hookabovecomb',
    '0323' => 'dotbelowcomb',
    '0384' => 'tonos',
    '0385' => 'dieresistonos',
    '0386' => 'Alphatonos',
    '0387' => 'anoteleia',
    '0388' => 'Epsilontonos',
    '0389' => 'Etatonos',
    '038A' => 'Iotatonos',
    '038C' => 'Omicrontonos',
    '038E' => 'Upsilontonos',
    '038F' => 'Omegatonos',
    '0390' => 'iotadieresistonos',
    '0391' => 'Alpha',
    '0392' => 'Beta',
    '0393' => 'Gamma',
#    '0394' => 'Delta',
    '0395' => 'Epsilon',
    '0396' => 'Zeta',
    '0397' => 'Eta',
    '0398' => 'Theta',
    '0399' => 'Iota',
    '039A' => 'Kappa',
    '039B' => 'Lambda',
    '039C' => 'Mu',
    '039D' => 'Nu',
    '039E' => 'Xi',
    '039F' => 'Omicron',
    '03A0' => 'Pi',
    '03A1' => 'Rho',
    '03A3' => 'Sigma',
    '03A4' => 'Tau',
    '03A5' => 'Upsilon',
    '03A6' => 'Phi',
    '03A7' => 'Chi',
    '03A8' => 'Psi',
#    '03A9' => 'Omega',
    '03AA' => 'Iotadieresis',
    '03AB' => 'Upsilondieresis',
    '03AC' => 'alphatonos',
    '03AD' => 'epsilontonos',
    '03AE' => 'etatonos',
    '03AF' => 'iotatonos',
    '03B0' => 'upsilondieresistonos',
    '03B1' => 'alpha',
    '03B2' => 'beta',
    '03B3' => 'gamma',
    '03B4' => 'delta',
    '03B5' => 'epsilon',
    '03B6' => 'zeta',
    '03B7' => 'eta',
    '03B8' => 'theta',
    '03B9' => 'iota',
    '03BA' => 'kappa',
    '03BB' => 'lambda',
#    '03BC' => 'mu',
    '03BD' => 'nu',
    '03BE' => 'xi',
    '03BF' => 'omicron',
    '03C0' => 'pi',
    '03C1' => 'rho',
    '03C2' => 'sigma1',
    '03C3' => 'sigma',
    '03C4' => 'tau',
    '03C5' => 'upsilon',
    '03C6' => 'phi',
    '03C7' => 'chi',
    '03C8' => 'psi',
    '03C9' => 'omega',
    '03CA' => 'iotadieresis',
    '03CB' => 'upsilondieresis',
    '03CC' => 'omicrontonos',
    '03CD' => 'upsilontonos',
    '03CE' => 'omegatonos',
    '03D1' => 'theta1',
    '03D2' => 'Upsilon1',
    '03D5' => 'phi1',
    '03D6' => 'omega1',
    '0401' => 'afii10023',
    '0402' => 'afii10051',
    '0403' => 'afii10052',
    '0404' => 'afii10053',
    '0405' => 'afii10054',
    '0406' => 'afii10055',
    '0407' => 'afii10056',
    '0408' => 'afii10057',
    '0409' => 'afii10058',
    '040A' => 'afii10059',
    '040B' => 'afii10060',
    '040C' => 'afii10061',
    '040E' => 'afii10062',
    '040F' => 'afii10145',
    '0410' => 'afii10017',
    '0411' => 'afii10018',
    '0412' => 'afii10019',
    '0413' => 'afii10020',
    '0414' => 'afii10021',
    '0415' => 'afii10022',
    '0416' => 'afii10024',
    '0417' => 'afii10025',
    '0418' => 'afii10026',
    '0419' => 'afii10027',
    '041A' => 'afii10028',
    '041B' => 'afii10029',
    '041C' => 'afii10030',
    '041D' => 'afii10031',
    '041E' => 'afii10032',
    '041F' => 'afii10033',
    '0420' => 'afii10034',
    '0421' => 'afii10035',
    '0422' => 'afii10036',
    '0423' => 'afii10037',
    '0424' => 'afii10038',
    '0425' => 'afii10039',
    '0426' => 'afii10040',
    '0427' => 'afii10041',
    '0428' => 'afii10042',
    '0429' => 'afii10043',
    '042A' => 'afii10044',
    '042B' => 'afii10045',
    '042C' => 'afii10046',
    '042D' => 'afii10047',
    '042E' => 'afii10048',
    '042F' => 'afii10049',
    '0430' => 'afii10065',
    '0431' => 'afii10066',
    '0432' => 'afii10067',
    '0433' => 'afii10068',
    '0434' => 'afii10069',
    '0435' => 'afii10070',
    '0436' => 'afii10072',
    '0437' => 'afii10073',
    '0438' => 'afii10074',
    '0439' => 'afii10075',
    '043A' => 'afii10076',
    '043B' => 'afii10077',
    '043C' => 'afii10078',
    '043D' => 'afii10079',
    '043E' => 'afii10080',
    '043F' => 'afii10081',
    '0440' => 'afii10082',
    '0441' => 'afii10083',
    '0442' => 'afii10084',
    '0443' => 'afii10085',
    '0444' => 'afii10086',
    '0445' => 'afii10087',
    '0446' => 'afii10088',
    '0447' => 'afii10089',
    '0448' => 'afii10090',
    '0449' => 'afii10091',
    '044A' => 'afii10092',
    '044B' => 'afii10093',
    '044C' => 'afii10094',
    '044D' => 'afii10095',
    '044E' => 'afii10096',
    '044F' => 'afii10097',
    '0451' => 'afii10071',
    '0452' => 'afii10099',
    '0453' => 'afii10100',
    '0454' => 'afii10101',
    '0455' => 'afii10102',
    '0456' => 'afii10103',
    '0457' => 'afii10104',
    '0458' => 'afii10105',
    '0459' => 'afii10106',
    '045A' => 'afii10107',
    '045B' => 'afii10108',
    '045C' => 'afii10109',
    '045E' => 'afii10110',
    '045F' => 'afii10193',
    '0462' => 'afii10146',
    '0463' => 'afii10194',
    '0472' => 'afii10147',
    '0473' => 'afii10195',
    '0474' => 'afii10148',
    '0475' => 'afii10196',
    '0490' => 'afii10050',
    '0491' => 'afii10098',
    '04D9' => 'afii10846',
    '05B0' => 'afii57799',
    '05B1' => 'afii57801',
    '05B2' => 'afii57800',
    '05B3' => 'afii57802',
    '05B4' => 'afii57793',
    '05B5' => 'afii57794',
    '05B6' => 'afii57795',
    '05B7' => 'afii57798',
    '05B8' => 'afii57797',
    '05B9' => 'afii57806',
    '05BB' => 'afii57796',
    '05BC' => 'afii57807',
    '05BD' => 'afii57839',
    '05BE' => 'afii57645',
    '05BF' => 'afii57841',
    '05C0' => 'afii57842',
    '05C1' => 'afii57804',
    '05C2' => 'afii57803',
    '05C3' => 'afii57658',
    '05D0' => 'afii57664',
    '05D1' => 'afii57665',
    '05D2' => 'afii57666',
    '05D3' => 'afii57667',
    '05D4' => 'afii57668',
    '05D5' => 'afii57669',
    '05D6' => 'afii57670',
    '05D7' => 'afii57671',
    '05D8' => 'afii57672',
    '05D9' => 'afii57673',
    '05DA' => 'afii57674',
    '05DB' => 'afii57675',
    '05DC' => 'afii57676',
    '05DD' => 'afii57677',
    '05DE' => 'afii57678',
    '05DF' => 'afii57679',
    '05E0' => 'afii57680',
    '05E1' => 'afii57681',
    '05E2' => 'afii57682',
    '05E3' => 'afii57683',
    '05E4' => 'afii57684',
    '05E5' => 'afii57685',
    '05E6' => 'afii57686',
    '05E7' => 'afii57687',
    '05E8' => 'afii57688',
    '05E9' => 'afii57689',
    '05EA' => 'afii57690',
    '05F0' => 'afii57716',
    '05F1' => 'afii57717',
    '05F2' => 'afii57718',
    '060C' => 'afii57388',
    '061B' => 'afii57403',
    '061F' => 'afii57407',
    '0621' => 'afii57409',
    '0622' => 'afii57410',
    '0623' => 'afii57411',
    '0624' => 'afii57412',
    '0625' => 'afii57413',
    '0626' => 'afii57414',
    '0627' => 'afii57415',
    '0628' => 'afii57416',
    '0629' => 'afii57417',
    '062A' => 'afii57418',
    '062B' => 'afii57419',
    '062C' => 'afii57420',
    '062D' => 'afii57421',
    '062E' => 'afii57422',
    '062F' => 'afii57423',
    '0630' => 'afii57424',
    '0631' => 'afii57425',
    '0632' => 'afii57426',
    '0633' => 'afii57427',
    '0634' => 'afii57428',
    '0635' => 'afii57429',
    '0636' => 'afii57430',
    '0637' => 'afii57431',
    '0638' => 'afii57432',
    '0639' => 'afii57433',
    '063A' => 'afii57434',
    '0640' => 'afii57440',
    '0641' => 'afii57441',
    '0642' => 'afii57442',
    '0643' => 'afii57443',
    '0644' => 'afii57444',
    '0645' => 'afii57445',
    '0646' => 'afii57446',
    '0647' => 'afii57470',
    '0648' => 'afii57448',
    '0649' => 'afii57449',
    '064A' => 'afii57450',
    '064B' => 'afii57451',
    '064C' => 'afii57452',
    '064D' => 'afii57453',
    '064E' => 'afii57454',
    '064F' => 'afii57455',
    '0650' => 'afii57456',
    '0651' => 'afii57457',
    '0652' => 'afii57458',
    '0660' => 'afii57392',
    '0661' => 'afii57393',
    '0662' => 'afii57394',
    '0663' => 'afii57395',
    '0664' => 'afii57396',
    '0665' => 'afii57397',
    '0666' => 'afii57398',
    '0667' => 'afii57399',
    '0668' => 'afii57400',
    '0669' => 'afii57401',
    '066A' => 'afii57381',
    '066D' => 'afii63167',
    '0679' => 'afii57511',
    '067E' => 'afii57506',
    '0686' => 'afii57507',
    '0688' => 'afii57512',
    '0691' => 'afii57513',
    '0698' => 'afii57508',
    '06A4' => 'afii57505',
    '06AF' => 'afii57509',
    '06BA' => 'afii57514',
    '06D2' => 'afii57519',
    '06D5' => 'afii57534',
    '1E80' => 'Wgrave',
    '1E81' => 'wgrave',
    '1E82' => 'Wacute',
    '1E83' => 'wacute',
    '1E84' => 'Wdieresis',
    '1E85' => 'wdieresis',
    '1EF2' => 'Ygrave',
    '1EF3' => 'ygrave',
    '200C' => 'afii61664',
    '200D' => 'afii301',
    '200E' => 'afii299',
    '200F' => 'afii300',
    '2012' => 'figuredash',
    '2013' => 'endash',
    '2014' => 'emdash',
    '2015' => 'afii00208',
    '2017' => 'underscoredbl',
    '2018' => 'quoteleft',
    '2019' => 'quoteright',
    '201A' => 'quotesinglbase',
    '201B' => 'quotereversed',
    '201C' => 'quotedblleft',
    '201D' => 'quotedblright',
    '201E' => 'quotedblbase',
    '2020' => 'dagger',
    '2021' => 'daggerdbl',
    '2022' => 'bullet',
    '2024' => 'onedotenleader',
    '2025' => 'twodotenleader',
    '2026' => 'ellipsis',
    '202C' => 'afii61573',
    '202D' => 'afii61574',
    '202E' => 'afii61575',
    '2030' => 'perthousand',
    '2032' => 'minute',
    '2033' => 'second',
    '2039' => 'guilsinglleft',
    '203A' => 'guilsinglright',
    '203C' => 'exclamdbl',
    '2044' => 'fraction',
#    '2070' => 'zerosuperior',
#    '2074' => 'foursuperior',
#    '2075' => 'fivesuperior',
#    '2076' => 'sixsuperior',
#    '2077' => 'sevensuperior',
#    '2078' => 'eightsuperior',
#    '2079' => 'ninesuperior',
#    '207D' => 'parenleftsuperior',
#    '207E' => 'parenrightsuperior',
#    '207F' => 'nsuperior',
#    '2080' => 'zeroinferior',
#    '2081' => 'oneinferior',
#    '2082' => 'twoinferior',
#    '2083' => 'threeinferior',
#    '2084' => 'fourinferior',
#    '2085' => 'fiveinferior',
#    '2086' => 'sixinferior',
#    '2087' => 'seveninferior',
#    '2088' => 'eightinferior',
#    '2089' => 'nineinferior',
#    '208D' => 'parenleftinferior',
#    '208E' => 'parenrightinferior',
    '20A1' => 'colonmonetary',
    '20A3' => 'franc',
    '20A4' => 'lira',
    '20A7' => 'peseta',
    '20AA' => 'afii57636',
    '20AB' => 'dong',
    '20AC' => 'Euro',
    '2105' => 'afii61248',
    '2111' => 'Ifraktur',
    '2113' => 'afii61289',
    '2116' => 'afii61352',
    '2118' => 'weierstrass',
    '211C' => 'Rfraktur',
    '211E' => 'prescription',
    '2122' => 'trademark',
    '2126' => 'Omega',
    '212E' => 'estimated',
    '2135' => 'aleph',
    '2153' => 'onethird',
    '2154' => 'twothirds',
    '215B' => 'oneeighth',
    '215C' => 'threeeighths',
    '215D' => 'fiveeighths',
    '215E' => 'seveneighths',
    '2190' => 'arrowleft',
    '2191' => 'arrowup',
    '2192' => 'arrowright',
    '2193' => 'arrowdown',
    '2194' => 'arrowboth',
    '2195' => 'arrowupdn',
    '21A8' => 'arrowupdnbse',
    '21B5' => 'carriagereturn',
    '21D0' => 'arrowdblleft',
    '21D1' => 'arrowdblup',
    '21D2' => 'arrowdblright',
    '21D3' => 'arrowdbldown',
    '21D4' => 'arrowdblboth',
    '2200' => 'universal',
    '2202' => 'partialdiff',
    '2203' => 'existential',
    '2205' => 'emptyset',
    '2206' => 'Delta',
    '2207' => 'gradient',
    '2208' => 'element',
    '2209' => 'notelement',
    '220B' => 'suchthat',
    '220F' => 'product',
    '2211' => 'summation',
    '2212' => 'minus',
#    '2215' => 'fraction',
    '2217' => 'asteriskmath',
#    '2219' => 'periodcentered',
    '221A' => 'radical',
    '221D' => 'proportional',
    '221E' => 'infinity',
    '221F' => 'orthogonal',
    '2220' => 'angle',
    '2227' => 'logicaland',
    '2228' => 'logicalor',
    '2229' => 'intersection',
    '222A' => 'union',
    '222B' => 'integral',
    '2234' => 'therefore',
    '223C' => 'similar',
    '2245' => 'congruent',
    '2248' => 'approxequal',
    '2260' => 'notequal',
    '2261' => 'equivalence',
    '2264' => 'lessequal',
    '2265' => 'greaterequal',
    '2282' => 'propersubset',
    '2283' => 'propersuperset',
    '2284' => 'notsubset',
    '2286' => 'reflexsubset',
    '2287' => 'reflexsuperset',
    '2295' => 'circleplus',
    '2297' => 'circlemultiply',
    '22A5' => 'perpendicular',
    '22C5' => 'dotmath',
    '2302' => 'house',
    '2310' => 'revlogicalnot',
    '2320' => 'integraltp',
    '2321' => 'integralbt',
    '2329' => 'angleleft',
    '232A' => 'angleright',
    '2500' => 'SF100000',
    '2502' => 'SF110000',
    '250C' => 'SF010000',
    '2510' => 'SF030000',
    '2514' => 'SF020000',
    '2518' => 'SF040000',
    '251C' => 'SF080000',
    '2524' => 'SF090000',
    '252C' => 'SF060000',
    '2534' => 'SF070000',
    '253C' => 'SF050000',
    '2550' => 'SF430000',
    '2551' => 'SF240000',
    '2552' => 'SF510000',
    '2553' => 'SF520000',
    '2554' => 'SF390000',
    '2555' => 'SF220000',
    '2556' => 'SF210000',
    '2557' => 'SF250000',
    '2558' => 'SF500000',
    '2559' => 'SF490000',
    '255A' => 'SF380000',
    '255B' => 'SF280000',
    '255C' => 'SF270000',
    '255D' => 'SF260000',
    '255E' => 'SF360000',
    '255F' => 'SF370000',
    '2560' => 'SF420000',
    '2561' => 'SF190000',
    '2562' => 'SF200000',
    '2563' => 'SF230000',
    '2564' => 'SF470000',
    '2565' => 'SF480000',
    '2566' => 'SF410000',
    '2567' => 'SF450000',
    '2568' => 'SF460000',
    '2569' => 'SF400000',
    '256A' => 'SF540000',
    '256B' => 'SF530000',
    '256C' => 'SF440000',
    '2580' => 'upblock',
    '2584' => 'dnblock',
    '2588' => 'block',
    '258C' => 'lfblock',
    '2590' => 'rtblock',
    '2591' => 'ltshade',
    '2592' => 'shade',
    '2593' => 'dkshade',
    '25A0' => 'filledbox',
    '25A1' => 'H22073',
    '25AA' => 'H18543',
    '25AB' => 'H18551',
    '25AC' => 'filledrect',
    '25B2' => 'triagup',
    '25BA' => 'triagrt',
    '25BC' => 'triagdn',
    '25C4' => 'triaglf',
    '25CA' => 'lozenge',
    '25CB' => 'circle',
    '25CF' => 'H18533',
    '25D8' => 'invbullet',
    '25D9' => 'invcircle',
    '25E6' => 'openbullet',
    '263A' => 'smileface',
    '263B' => 'invsmileface',
    '263C' => 'sun',
    '2640' => 'female',
    '2642' => 'male',
    '2660' => 'spade',
    '2663' => 'club',
    '2665' => 'heart',
    '2666' => 'diamond',
    '266A' => 'musicalnote',
    '266B' => 'musicalnotedbl',
    'FB00' => 'ff',
    'FB01' => 'fi',
    'FB02' => 'fl',
    'FB03' => 'ffi',
    'FB04' => 'ffl',
    'FB1F' => 'afii57705',
    'FB2A' => 'afii57694',
    'FB2B' => 'afii57695',
    'FB35' => 'afii57723',
    'FB4B' => 'afii57700',
);

# Adobe Glyph List 2.0 (sans those in glyph list for *new* fonts) -- thus
# these are all historic names that could occur in fonts
# from http://partners.adobe.com/asn/tech/type/glyphlist.txt

%agl = (
	'AEmacron' => "\x{01E2}",
	'AEsmall' => "\x{F7E6}",
	'Aacutesmall' => "\x{F7E1}",
	'Abreveacute' => "\x{1EAE}",
	'Abrevecyrillic' => "\x{04D0}",
	'Abrevedotbelow' => "\x{1EB6}",
	'Abrevegrave' => "\x{1EB0}",
	'Abrevehookabove' => "\x{1EB2}",
	'Abrevetilde' => "\x{1EB4}",
	'Acaron' => "\x{01CD}",
	'Acircle' => "\x{24B6}",
	'Acircumflexacute' => "\x{1EA4}",
	'Acircumflexdotbelow' => "\x{1EAC}",
	'Acircumflexgrave' => "\x{1EA6}",
	'Acircumflexhookabove' => "\x{1EA8}",
	'Acircumflexsmall' => "\x{F7E2}",
	'Acircumflextilde' => "\x{1EAA}",
	'Acute' => "\x{F6C9}",
	'Acutesmall' => "\x{F7B4}",
	'Acyrillic' => "\x{0410}",
	'Adblgrave' => "\x{0200}",
	'Adieresiscyrillic' => "\x{04D2}",
	'Adieresismacron' => "\x{01DE}",
	'Adieresissmall' => "\x{F7E4}",
	'Adotbelow' => "\x{1EA0}",
	'Adotmacron' => "\x{01E0}",
	'Agravesmall' => "\x{F7E0}",
	'Ahookabove' => "\x{1EA2}",
	'Aiecyrillic' => "\x{04D4}",
	'Ainvertedbreve' => "\x{0202}",
	'Amonospace' => "\x{FF21}",
	'Aringbelow' => "\x{1E00}",
	'Aringsmall' => "\x{F7E5}",
	'Asmall' => "\x{F761}",
	'Atildesmall' => "\x{F7E3}",
	'Aybarmenian' => "\x{0531}",
	'Bcircle' => "\x{24B7}",
	'Bdotaccent' => "\x{1E02}",
	'Bdotbelow' => "\x{1E04}",
	'Becyrillic' => "\x{0411}",
	'Benarmenian' => "\x{0532}",
	'Bhook' => "\x{0181}",
	'Blinebelow' => "\x{1E06}",
	'Bmonospace' => "\x{FF22}",
	'Brevesmall' => "\x{F6F4}",
	'Bsmall' => "\x{F762}",
	'Btopbar' => "\x{0182}",
	'Caarmenian' => "\x{053E}",
	'Caron' => "\x{F6CA}",
	'Caronsmall' => "\x{F6F5}",
	'Ccedillaacute' => "\x{1E08}",
	'Ccedillasmall' => "\x{F7E7}",
	'Ccircle' => "\x{24B8}",
	'Cdot' => "\x{010A}",
	'Cedillasmall' => "\x{F7B8}",
	'Chaarmenian' => "\x{0549}",
	'Cheabkhasiancyrillic' => "\x{04BC}",
	'Checyrillic' => "\x{0427}",
	'Chedescenderabkhasiancyrillic' => "\x{04BE}",
	'Chedescendercyrillic' => "\x{04B6}",
	'Chedieresiscyrillic' => "\x{04F4}",
	'Cheharmenian' => "\x{0543}",
	'Chekhakassiancyrillic' => "\x{04CB}",
	'Cheverticalstrokecyrillic' => "\x{04B8}",
	'Chook' => "\x{0187}",
	'Circumflexsmall' => "\x{F6F6}",
	'Cmonospace' => "\x{FF23}",
	'Coarmenian' => "\x{0551}",
	'Csmall' => "\x{F763}",
	'DZ' => "\x{01F1}",
	'DZcaron' => "\x{01C4}",
	'Daarmenian' => "\x{0534}",
	'Dafrican' => "\x{0189}",
	'Dcedilla' => "\x{1E10}",
	'Dcircle' => "\x{24B9}",
	'Dcircumflexbelow' => "\x{1E12}",
	'Ddotaccent' => "\x{1E0A}",
	'Ddotbelow' => "\x{1E0C}",
	'Decyrillic' => "\x{0414}",
	'Deicoptic' => "\x{03EE}",
	'Deltagreek' => "\x{0394}",
	'Dhook' => "\x{018A}",
	'Dieresis' => "\x{F6CB}",
	'DieresisAcute' => "\x{F6CC}",
	'DieresisGrave' => "\x{F6CD}",
	'Dieresissmall' => "\x{F7A8}",
	'Digammagreek' => "\x{03DC}",
	'Djecyrillic' => "\x{0402}",
	'Dlinebelow' => "\x{1E0E}",
	'Dmonospace' => "\x{FF24}",
	'Dotaccentsmall' => "\x{F6F7}",
	'Dslash' => "\x{0110}",
	'Dsmall' => "\x{F764}",
	'Dtopbar' => "\x{018B}",
	'Dz' => "\x{01F2}",
	'Dzcaron' => "\x{01C5}",
	'Dzeabkhasiancyrillic' => "\x{04E0}",
	'Dzecyrillic' => "\x{0405}",
	'Dzhecyrillic' => "\x{040F}",
	'Eacutesmall' => "\x{F7E9}",
	'Ecedillabreve' => "\x{1E1C}",
	'Echarmenian' => "\x{0535}",
	'Ecircle' => "\x{24BA}",
	'Ecircumflexacute' => "\x{1EBE}",
	'Ecircumflexbelow' => "\x{1E18}",
	'Ecircumflexdotbelow' => "\x{1EC6}",
	'Ecircumflexgrave' => "\x{1EC0}",
	'Ecircumflexhookabove' => "\x{1EC2}",
	'Ecircumflexsmall' => "\x{F7EA}",
	'Ecircumflextilde' => "\x{1EC4}",
	'Ecyrillic' => "\x{0404}",
	'Edblgrave' => "\x{0204}",
	'Edieresissmall' => "\x{F7EB}",
	'Edot' => "\x{0116}",
	'Edotbelow' => "\x{1EB8}",
	'Efcyrillic' => "\x{0424}",
	'Egravesmall' => "\x{F7E8}",
	'Eharmenian' => "\x{0537}",
	'Ehookabove' => "\x{1EBA}",
	'Eightroman' => "\x{2167}",
	'Einvertedbreve' => "\x{0206}",
	'Eiotifiedcyrillic' => "\x{0464}",
	'Elcyrillic' => "\x{041B}",
	'Elevenroman' => "\x{216A}",
	'Emacronacute' => "\x{1E16}",
	'Emacrongrave' => "\x{1E14}",
	'Emcyrillic' => "\x{041C}",
	'Emonospace' => "\x{FF25}",
	'Encyrillic' => "\x{041D}",
	'Endescendercyrillic' => "\x{04A2}",
	'Enghecyrillic' => "\x{04A4}",
	'Enhookcyrillic' => "\x{04C7}",
	'Eopen' => "\x{0190}",
	'Ercyrillic' => "\x{0420}",
	'Ereversed' => "\x{018E}",
	'Ereversedcyrillic' => "\x{042D}",
	'Escyrillic' => "\x{0421}",
	'Esdescendercyrillic' => "\x{04AA}",
	'Esh' => "\x{01A9}",
	'Esmall' => "\x{F765}",
	'Etarmenian' => "\x{0538}",
	'Ethsmall' => "\x{F7F0}",
	'Etilde' => "\x{1EBC}",
	'Etildebelow' => "\x{1E1A}",
	'Ezh' => "\x{01B7}",
	'Ezhcaron' => "\x{01EE}",
	'Ezhreversed' => "\x{01B8}",
	'Fcircle' => "\x{24BB}",
	'Fdotaccent' => "\x{1E1E}",
	'Feharmenian' => "\x{0556}",
	'Feicoptic' => "\x{03E4}",
	'Fhook' => "\x{0191}",
	'Fitacyrillic' => "\x{0472}",
	'Fiveroman' => "\x{2164}",
	'Fmonospace' => "\x{FF26}",
	'Fourroman' => "\x{2163}",
	'Fsmall' => "\x{F766}",
	'GBsquare' => "\x{3387}",
	'Gacute' => "\x{01F4}",
	'Gammaafrican' => "\x{0194}",
	'Gangiacoptic' => "\x{03EA}",
	'Gcedilla' => "\x{0122}",
	'Gcircle' => "\x{24BC}",
	'Gdot' => "\x{0120}",
	'Gecyrillic' => "\x{0413}",
	'Ghadarmenian' => "\x{0542}",
	'Ghemiddlehookcyrillic' => "\x{0494}",
	'Ghestrokecyrillic' => "\x{0492}",
	'Gheupturncyrillic' => "\x{0490}",
	'Ghook' => "\x{0193}",
	'Gimarmenian' => "\x{0533}",
	'Gjecyrillic' => "\x{0403}",
	'Gmacron' => "\x{1E20}",
	'Gmonospace' => "\x{FF27}",
	'Grave' => "\x{F6CE}",
	'Gravesmall' => "\x{F760}",
	'Gsmall' => "\x{F767}",
	'Gsmallhook' => "\x{029B}",
	'Gstroke' => "\x{01E4}",
	'HPsquare' => "\x{33CB}",
	'Haabkhasiancyrillic' => "\x{04A8}",
	'Hadescendercyrillic' => "\x{04B2}",
	'Hardsigncyrillic' => "\x{042A}",
	'Hbrevebelow' => "\x{1E2A}",
	'Hcedilla' => "\x{1E28}",
	'Hcircle' => "\x{24BD}",
	'Hdieresis' => "\x{1E26}",
	'Hdotaccent' => "\x{1E22}",
	'Hdotbelow' => "\x{1E24}",
	'Hmonospace' => "\x{FF28}",
	'Hoarmenian' => "\x{0540}",
	'Horicoptic' => "\x{03E8}",
	'Hsmall' => "\x{F768}",
	'Hungarumlaut' => "\x{F6CF}",
	'Hungarumlautsmall' => "\x{F6F8}",
	'Hzsquare' => "\x{3390}",
	'IAcyrillic' => "\x{042F}",
	'IUcyrillic' => "\x{042E}",
	'Iacutesmall' => "\x{F7ED}",
	'Icaron' => "\x{01CF}",
	'Icircle' => "\x{24BE}",
	'Icircumflexsmall' => "\x{F7EE}",
	'Icyrillic' => "\x{0406}",
	'Idblgrave' => "\x{0208}",
	'Idieresisacute' => "\x{1E2E}",
	'Idieresiscyrillic' => "\x{04E4}",
	'Idieresissmall' => "\x{F7EF}",
	'Idot' => "\x{0130}",
	'Idotbelow' => "\x{1ECA}",
	'Iebrevecyrillic' => "\x{04D6}",
	'Iecyrillic' => "\x{0415}",
	'Igravesmall' => "\x{F7EC}",
	'Ihookabove' => "\x{1EC8}",
	'Iicyrillic' => "\x{0418}",
	'Iinvertedbreve' => "\x{020A}",
	'Iishortcyrillic' => "\x{0419}",
	'Imacroncyrillic' => "\x{04E2}",
	'Imonospace' => "\x{FF29}",
	'Iniarmenian' => "\x{053B}",
	'Iocyrillic' => "\x{0401}",
	'Iotaafrican' => "\x{0196}",
	'Ismall' => "\x{F769}",
	'Istroke' => "\x{0197}",
	'Itildebelow' => "\x{1E2C}",
	'Izhitsacyrillic' => "\x{0474}",
	'Izhitsadblgravecyrillic' => "\x{0476}",
	'Jaarmenian' => "\x{0541}",
	'Jcircle' => "\x{24BF}",
	'Jecyrillic' => "\x{0408}",
	'Jheharmenian' => "\x{054B}",
	'Jmonospace' => "\x{FF2A}",
	'Jsmall' => "\x{F76A}",
	'KBsquare' => "\x{3385}",
	'KKsquare' => "\x{33CD}",
	'Kabashkircyrillic' => "\x{04A0}",
	'Kacute' => "\x{1E30}",
	'Kacyrillic' => "\x{041A}",
	'Kadescendercyrillic' => "\x{049A}",
	'Kahookcyrillic' => "\x{04C3}",
	'Kastrokecyrillic' => "\x{049E}",
	'Kaverticalstrokecyrillic' => "\x{049C}",
	'Kcaron' => "\x{01E8}",
	'Kcedilla' => "\x{0136}",
	'Kcircle' => "\x{24C0}",
	'Kdotbelow' => "\x{1E32}",
	'Keharmenian' => "\x{0554}",
	'Kenarmenian' => "\x{053F}",
	'Khacyrillic' => "\x{0425}",
	'Kheicoptic' => "\x{03E6}",
	'Khook' => "\x{0198}",
	'Kjecyrillic' => "\x{040C}",
	'Klinebelow' => "\x{1E34}",
	'Kmonospace' => "\x{FF2B}",
	'Koppacyrillic' => "\x{0480}",
	'Koppagreek' => "\x{03DE}",
	'Ksicyrillic' => "\x{046E}",
	'Ksmall' => "\x{F76B}",
	'LJ' => "\x{01C7}",
	'LL' => "\x{F6BF}",
	'Lcedilla' => "\x{013B}",
	'Lcircle' => "\x{24C1}",
	'Lcircumflexbelow' => "\x{1E3C}",
	'Ldotaccent' => "\x{013F}",
	'Ldotbelow' => "\x{1E36}",
	'Ldotbelowmacron' => "\x{1E38}",
	'Liwnarmenian' => "\x{053C}",
	'Lj' => "\x{01C8}",
	'Ljecyrillic' => "\x{0409}",
	'Llinebelow' => "\x{1E3A}",
	'Lmonospace' => "\x{FF2C}",
	'Lslashsmall' => "\x{F6F9}",
	'Lsmall' => "\x{F76C}",
	'MBsquare' => "\x{3386}",
	'Macron' => "\x{F6D0}",
	'Macronsmall' => "\x{F7AF}",
	'Macute' => "\x{1E3E}",
	'Mcircle' => "\x{24C2}",
	'Mdotaccent' => "\x{1E40}",
	'Mdotbelow' => "\x{1E42}",
	'Menarmenian' => "\x{0544}",
	'Mmonospace' => "\x{FF2D}",
	'Msmall' => "\x{F76D}",
	'Mturned' => "\x{019C}",
	'NJ' => "\x{01CA}",
	'Ncedilla' => "\x{0145}",
	'Ncircle' => "\x{24C3}",
	'Ncircumflexbelow' => "\x{1E4A}",
	'Ndotaccent' => "\x{1E44}",
	'Ndotbelow' => "\x{1E46}",
	'Nhookleft' => "\x{019D}",
	'Nineroman' => "\x{2168}",
	'Nj' => "\x{01CB}",
	'Njecyrillic' => "\x{040A}",
	'Nlinebelow' => "\x{1E48}",
	'Nmonospace' => "\x{FF2E}",
	'Nowarmenian' => "\x{0546}",
	'Nsmall' => "\x{F76E}",
	'Ntildesmall' => "\x{F7F1}",
	'OEsmall' => "\x{F6FA}",
	'Oacutesmall' => "\x{F7F3}",
	'Obarredcyrillic' => "\x{04E8}",
	'Obarreddieresiscyrillic' => "\x{04EA}",
	'Ocaron' => "\x{01D1}",
	'Ocenteredtilde' => "\x{019F}",
	'Ocircle' => "\x{24C4}",
	'Ocircumflexacute' => "\x{1ED0}",
	'Ocircumflexdotbelow' => "\x{1ED8}",
	'Ocircumflexgrave' => "\x{1ED2}",
	'Ocircumflexhookabove' => "\x{1ED4}",
	'Ocircumflexsmall' => "\x{F7F4}",
	'Ocircumflextilde' => "\x{1ED6}",
	'Ocyrillic' => "\x{041E}",
	'Odblacute' => "\x{0150}",
	'Odblgrave' => "\x{020C}",
	'Odieresiscyrillic' => "\x{04E6}",
	'Odieresissmall' => "\x{F7F6}",
	'Odotbelow' => "\x{1ECC}",
	'Ogoneksmall' => "\x{F6FB}",
	'Ogravesmall' => "\x{F7F2}",
	'Oharmenian' => "\x{0555}",
	'Ohm' => "\x{2126}",
	'Ohookabove' => "\x{1ECE}",
	'Ohornacute' => "\x{1EDA}",
	'Ohorndotbelow' => "\x{1EE2}",
	'Ohorngrave' => "\x{1EDC}",
	'Ohornhookabove' => "\x{1EDE}",
	'Ohorntilde' => "\x{1EE0}",
	'Oi' => "\x{01A2}",
	'Oinvertedbreve' => "\x{020E}",
	'Omacronacute' => "\x{1E52}",
	'Omacrongrave' => "\x{1E50}",
	'Omegacyrillic' => "\x{0460}",
	'Omegagreek' => "\x{03A9}",
	'Omegaroundcyrillic' => "\x{047A}",
	'Omegatitlocyrillic' => "\x{047C}",
	'Omonospace' => "\x{FF2F}",
	'Oneroman' => "\x{2160}",
	'Oogonek' => "\x{01EA}",
	'Oogonekmacron' => "\x{01EC}",
	'Oopen' => "\x{0186}",
	'Oslashsmall' => "\x{F7F8}",
	'Osmall' => "\x{F76F}",
	'Ostrokeacute' => "\x{01FE}",
	'Otcyrillic' => "\x{047E}",
	'Otildeacute' => "\x{1E4C}",
	'Otildedieresis' => "\x{1E4E}",
	'Otildesmall' => "\x{F7F5}",
	'Pacute' => "\x{1E54}",
	'Pcircle' => "\x{24C5}",
	'Pdotaccent' => "\x{1E56}",
	'Pecyrillic' => "\x{041F}",
	'Peharmenian' => "\x{054A}",
	'Pemiddlehookcyrillic' => "\x{04A6}",
	'Phook' => "\x{01A4}",
	'Piwrarmenian' => "\x{0553}",
	'Pmonospace' => "\x{FF30}",
	'Psicyrillic' => "\x{0470}",
	'Psmall' => "\x{F770}",
	'Qcircle' => "\x{24C6}",
	'Qmonospace' => "\x{FF31}",
	'Qsmall' => "\x{F771}",
	'Raarmenian' => "\x{054C}",
	'Rcedilla' => "\x{0156}",
	'Rcircle' => "\x{24C7}",
	'Rdblgrave' => "\x{0210}",
	'Rdotaccent' => "\x{1E58}",
	'Rdotbelow' => "\x{1E5A}",
	'Rdotbelowmacron' => "\x{1E5C}",
	'Reharmenian' => "\x{0550}",
	'Ringsmall' => "\x{F6FC}",
	'Rinvertedbreve' => "\x{0212}",
	'Rlinebelow' => "\x{1E5E}",
	'Rmonospace' => "\x{FF32}",
	'Rsmall' => "\x{F772}",
	'Rsmallinverted' => "\x{0281}",
	'Rsmallinvertedsuperior' => "\x{02B6}",
	'Sacutedotaccent' => "\x{1E64}",
	'Sampigreek' => "\x{03E0}",
	'Scarondotaccent' => "\x{1E66}",
	'Scaronsmall' => "\x{F6FD}",
	'Schwa' => "\x{018F}",
	'Schwacyrillic' => "\x{04D8}",
	'Schwadieresiscyrillic' => "\x{04DA}",
	'Scircle' => "\x{24C8}",
	'Sdotaccent' => "\x{1E60}",
	'Sdotbelow' => "\x{1E62}",
	'Sdotbelowdotaccent' => "\x{1E68}",
	'Seharmenian' => "\x{054D}",
	'Sevenroman' => "\x{2166}",
	'Shaarmenian' => "\x{0547}",
	'Shacyrillic' => "\x{0428}",
	'Shchacyrillic' => "\x{0429}",
	'Sheicoptic' => "\x{03E2}",
	'Shhacyrillic' => "\x{04BA}",
	'Shimacoptic' => "\x{03EC}",
	'Sixroman' => "\x{2165}",
	'Smonospace' => "\x{FF33}",
	'Softsigncyrillic' => "\x{042C}",
	'Ssmall' => "\x{F773}",
	'Stigmagreek' => "\x{03DA}",
	'Tcedilla' => "\x{0162}",
	'Tcircle' => "\x{24C9}",
	'Tcircumflexbelow' => "\x{1E70}",
	'Tdotaccent' => "\x{1E6A}",
	'Tdotbelow' => "\x{1E6C}",
	'Tecyrillic' => "\x{0422}",
	'Tedescendercyrillic' => "\x{04AC}",
	'Tenroman' => "\x{2169}",
	'Tetsecyrillic' => "\x{04B4}",
	'Thook' => "\x{01AC}",
	'Thornsmall' => "\x{F7FE}",
	'Threeroman' => "\x{2162}",
	'Tildesmall' => "\x{F6FE}",
	'Tiwnarmenian' => "\x{054F}",
	'Tlinebelow' => "\x{1E6E}",
	'Tmonospace' => "\x{FF34}",
	'Toarmenian' => "\x{0539}",
	'Tonefive' => "\x{01BC}",
	'Tonesix' => "\x{0184}",
	'Tonetwo' => "\x{01A7}",
	'Tretroflexhook' => "\x{01AE}",
	'Tsecyrillic' => "\x{0426}",
	'Tshecyrillic' => "\x{040B}",
	'Tsmall' => "\x{F774}",
	'Twelveroman' => "\x{216B}",
	'Tworoman' => "\x{2161}",
	'Uacutesmall' => "\x{F7FA}",
	'Ucaron' => "\x{01D3}",
	'Ucircle' => "\x{24CA}",
	'Ucircumflexbelow' => "\x{1E76}",
	'Ucircumflexsmall' => "\x{F7FB}",
	'Ucyrillic' => "\x{0423}",
	'Udblacute' => "\x{0170}",
	'Udblgrave' => "\x{0214}",
	'Udieresisacute' => "\x{01D7}",
	'Udieresisbelow' => "\x{1E72}",
	'Udieresiscaron' => "\x{01D9}",
	'Udieresiscyrillic' => "\x{04F0}",
	'Udieresisgrave' => "\x{01DB}",
	'Udieresismacron' => "\x{01D5}",
	'Udieresissmall' => "\x{F7FC}",
	'Udotbelow' => "\x{1EE4}",
	'Ugravesmall' => "\x{F7F9}",
	'Uhookabove' => "\x{1EE6}",
	'Uhornacute' => "\x{1EE8}",
	'Uhorndotbelow' => "\x{1EF0}",
	'Uhorngrave' => "\x{1EEA}",
	'Uhornhookabove' => "\x{1EEC}",
	'Uhorntilde' => "\x{1EEE}",
	'Uhungarumlautcyrillic' => "\x{04F2}",
	'Uinvertedbreve' => "\x{0216}",
	'Ukcyrillic' => "\x{0478}",
	'Umacroncyrillic' => "\x{04EE}",
	'Umacrondieresis' => "\x{1E7A}",
	'Umonospace' => "\x{FF35}",
	'Upsilonacutehooksymbolgreek' => "\x{03D3}",
	'Upsilonafrican' => "\x{01B1}",
	'Upsilondieresishooksymbolgreek' => "\x{03D4}",
	'Upsilonhooksymbol' => "\x{03D2}",
	'Ushortcyrillic' => "\x{040E}",
	'Usmall' => "\x{F775}",
	'Ustraightcyrillic' => "\x{04AE}",
	'Ustraightstrokecyrillic' => "\x{04B0}",
	'Utildeacute' => "\x{1E78}",
	'Utildebelow' => "\x{1E74}",
	'Vcircle' => "\x{24CB}",
	'Vdotbelow' => "\x{1E7E}",
	'Vecyrillic' => "\x{0412}",
	'Vewarmenian' => "\x{054E}",
	'Vhook' => "\x{01B2}",
	'Vmonospace' => "\x{FF36}",
	'Voarmenian' => "\x{0548}",
	'Vsmall' => "\x{F776}",
	'Vtilde' => "\x{1E7C}",
	'Wcircle' => "\x{24CC}",
	'Wdotaccent' => "\x{1E86}",
	'Wdotbelow' => "\x{1E88}",
	'Wmonospace' => "\x{FF37}",
	'Wsmall' => "\x{F777}",
	'Xcircle' => "\x{24CD}",
	'Xdieresis' => "\x{1E8C}",
	'Xdotaccent' => "\x{1E8A}",
	'Xeharmenian' => "\x{053D}",
	'Xmonospace' => "\x{FF38}",
	'Xsmall' => "\x{F778}",
	'Yacutesmall' => "\x{F7FD}",
	'Yatcyrillic' => "\x{0462}",
	'Ycircle' => "\x{24CE}",
	'Ydieresissmall' => "\x{F7FF}",
	'Ydotaccent' => "\x{1E8E}",
	'Ydotbelow' => "\x{1EF4}",
	'Yericyrillic' => "\x{042B}",
	'Yerudieresiscyrillic' => "\x{04F8}",
	'Yhook' => "\x{01B3}",
	'Yhookabove' => "\x{1EF6}",
	'Yiarmenian' => "\x{0545}",
	'Yicyrillic' => "\x{0407}",
	'Yiwnarmenian' => "\x{0552}",
	'Ymonospace' => "\x{FF39}",
	'Ysmall' => "\x{F779}",
	'Ytilde' => "\x{1EF8}",
	'Yusbigcyrillic' => "\x{046A}",
	'Yusbigiotifiedcyrillic' => "\x{046C}",
	'Yuslittlecyrillic' => "\x{0466}",
	'Yuslittleiotifiedcyrillic' => "\x{0468}",
	'Zaarmenian' => "\x{0536}",
	'Zcaronsmall' => "\x{F6FF}",
	'Zcircle' => "\x{24CF}",
	'Zcircumflex' => "\x{1E90}",
	'Zdot' => "\x{017B}",
	'Zdotbelow' => "\x{1E92}",
	'Zecyrillic' => "\x{0417}",
	'Zedescendercyrillic' => "\x{0498}",
	'Zedieresiscyrillic' => "\x{04DE}",
	'Zhearmenian' => "\x{053A}",
	'Zhebrevecyrillic' => "\x{04C1}",
	'Zhecyrillic' => "\x{0416}",
	'Zhedescendercyrillic' => "\x{0496}",
	'Zhedieresiscyrillic' => "\x{04DC}",
	'Zlinebelow' => "\x{1E94}",
	'Zmonospace' => "\x{FF3A}",
	'Zsmall' => "\x{F77A}",
	'Zstroke' => "\x{01B5}",
	'aabengali' => "\x{0986}",
	'aadeva' => "\x{0906}",
	'aagujarati' => "\x{0A86}",
	'aagurmukhi' => "\x{0A06}",
	'aamatragurmukhi' => "\x{0A3E}",
	'aarusquare' => "\x{3303}",
	'aavowelsignbengali' => "\x{09BE}",
	'aavowelsigndeva' => "\x{093E}",
	'aavowelsigngujarati' => "\x{0ABE}",
	'abbreviationmarkarmenian' => "\x{055F}",
	'abbreviationsigndeva' => "\x{0970}",
	'abengali' => "\x{0985}",
	'abopomofo' => "\x{311A}",
	'abreveacute' => "\x{1EAF}",
	'abrevecyrillic' => "\x{04D1}",
	'abrevedotbelow' => "\x{1EB7}",
	'abrevegrave' => "\x{1EB1}",
	'abrevehookabove' => "\x{1EB3}",
	'abrevetilde' => "\x{1EB5}",
	'acaron' => "\x{01CE}",
	'acircle' => "\x{24D0}",
	'acircumflexacute' => "\x{1EA5}",
	'acircumflexdotbelow' => "\x{1EAD}",
	'acircumflexgrave' => "\x{1EA7}",
	'acircumflexhookabove' => "\x{1EA9}",
	'acircumflextilde' => "\x{1EAB}",
	'acutebelowcmb' => "\x{0317}",
	'acutecmb' => "\x{0301}",
	'acutedeva' => "\x{0954}",
	'acutelowmod' => "\x{02CF}",
	'acutetonecmb' => "\x{0341}",
	'acyrillic' => "\x{0430}",
	'adblgrave' => "\x{0201}",
	'addakgurmukhi' => "\x{0A71}",
	'adeva' => "\x{0905}",
	'adieresiscyrillic' => "\x{04D3}",
	'adieresismacron' => "\x{01DF}",
	'adotbelow' => "\x{1EA1}",
	'adotmacron' => "\x{01E1}",
	'aekorean' => "\x{3150}",
	'aemacron' => "\x{01E3}",
	'afii08941' => "\x{20A4}",
	'afii10063' => "\x{F6C4}",
	'afii10064' => "\x{F6C5}",
	'afii10192' => "\x{F6C6}",
	'afii10831' => "\x{F6C7}",
	'afii10832' => "\x{F6C8}",
	'agujarati' => "\x{0A85}",
	'agurmukhi' => "\x{0A05}",
	'ahiragana' => "\x{3042}",
	'ahookabove' => "\x{1EA3}",
	'aibengali' => "\x{0990}",
	'aibopomofo' => "\x{311E}",
	'aideva' => "\x{0910}",
	'aiecyrillic' => "\x{04D5}",
	'aigujarati' => "\x{0A90}",
	'aigurmukhi' => "\x{0A10}",
	'aimatragurmukhi' => "\x{0A48}",
	'ainarabic' => "\x{0639}",
	'ainfinalarabic' => "\x{FECA}",
	'aininitialarabic' => "\x{FECB}",
	'ainmedialarabic' => "\x{FECC}",
	'ainvertedbreve' => "\x{0203}",
	'aivowelsignbengali' => "\x{09C8}",
	'aivowelsigndeva' => "\x{0948}",
	'aivowelsigngujarati' => "\x{0AC8}",
	'akatakana' => "\x{30A2}",
	'akatakanahalfwidth' => "\x{FF71}",
	'akorean' => "\x{314F}",
	'alef' => "\x{05D0}",
	'alefarabic' => "\x{0627}",
	'alefdageshhebrew' => "\x{FB30}",
	'aleffinalarabic' => "\x{FE8E}",
	'alefhamzaabovearabic' => "\x{0623}",
	'alefhamzaabovefinalarabic' => "\x{FE84}",
	'alefhamzabelowarabic' => "\x{0625}",
	'alefhamzabelowfinalarabic' => "\x{FE88}",
	'alefhebrew' => "\x{05D0}",
	'aleflamedhebrew' => "\x{FB4F}",
	'alefmaddaabovearabic' => "\x{0622}",
	'alefmaddaabovefinalarabic' => "\x{FE82}",
	'alefmaksuraarabic' => "\x{0649}",
	'alefmaksurafinalarabic' => "\x{FEF0}",
	'alefmaksurainitialarabic' => "\x{FEF3}",
	'alefmaksuramedialarabic' => "\x{FEF4}",
	'alefpatahhebrew' => "\x{FB2E}",
	'alefqamatshebrew' => "\x{FB2F}",
	'allequal' => "\x{224C}",
	'amonospace' => "\x{FF41}",
	'ampersandmonospace' => "\x{FF06}",
	'ampersandsmall' => "\x{F726}",
	'amsquare' => "\x{33C2}",
	'anbopomofo' => "\x{3122}",
	'angbopomofo' => "\x{3124}",
	'angkhankhuthai' => "\x{0E5A}",
	'anglebracketleft' => "\x{3008}",
	'anglebracketleftvertical' => "\x{FE3F}",
	'anglebracketright' => "\x{3009}",
	'anglebracketrightvertical' => "\x{FE40}",
	'angstrom' => "\x{212B}",
	'anudattadeva' => "\x{0952}",
	'anusvarabengali' => "\x{0982}",
	'anusvaradeva' => "\x{0902}",
	'anusvaragujarati' => "\x{0A82}",
	'apaatosquare' => "\x{3300}",
	'aparen' => "\x{249C}",
	'apostrophearmenian' => "\x{055A}",
	'apostrophemod' => "\x{02BC}",
	'apple' => "\x{F8FF}",
	'approaches' => "\x{2250}",
	'approxequalorimage' => "\x{2252}",
	'approximatelyequal' => "\x{2245}",
	'araeaekorean' => "\x{318E}",
	'araeakorean' => "\x{318D}",
	'arc' => "\x{2312}",
	'arighthalfring' => "\x{1E9A}",
	'aringbelow' => "\x{1E01}",
	'arrowdashdown' => "\x{21E3}",
	'arrowdashleft' => "\x{21E0}",
	'arrowdashright' => "\x{21E2}",
	'arrowdashup' => "\x{21E1}",
	'arrowdownleft' => "\x{2199}",
	'arrowdownright' => "\x{2198}",
	'arrowdownwhite' => "\x{21E9}",
	'arrowheaddownmod' => "\x{02C5}",
	'arrowheadleftmod' => "\x{02C2}",
	'arrowheadrightmod' => "\x{02C3}",
	'arrowheadupmod' => "\x{02C4}",
	'arrowhorizex' => "\x{F8E7}",
	'arrowleftdbl' => "\x{21D0}",
	'arrowleftdblstroke' => "\x{21CD}",
	'arrowleftoverright' => "\x{21C6}",
	'arrowleftwhite' => "\x{21E6}",
	'arrowrightdblstroke' => "\x{21CF}",
	'arrowrightheavy' => "\x{279E}",
	'arrowrightoverleft' => "\x{21C4}",
	'arrowrightwhite' => "\x{21E8}",
	'arrowtableft' => "\x{21E4}",
	'arrowtabright' => "\x{21E5}",
	'arrowupdownbase' => "\x{21A8}",
	'arrowupleft' => "\x{2196}",
	'arrowupleftofdown' => "\x{21C5}",
	'arrowupright' => "\x{2197}",
	'arrowupwhite' => "\x{21E7}",
	'arrowvertex' => "\x{F8E6}",
	'asciicircummonospace' => "\x{FF3E}",
	'asciitildemonospace' => "\x{FF5E}",
	'ascript' => "\x{0251}",
	'ascriptturned' => "\x{0252}",
	'asmallhiragana' => "\x{3041}",
	'asmallkatakana' => "\x{30A1}",
	'asmallkatakanahalfwidth' => "\x{FF67}",
	'asteriskaltonearabic' => "\x{066D}",
	'asteriskarabic' => "\x{066D}",
	'asteriskmonospace' => "\x{FF0A}",
	'asterisksmall' => "\x{FE61}",
	'asterism' => "\x{2042}",
	'asuperior' => "\x{F6E9}",
	'asymptoticallyequal' => "\x{2243}",
	'atmonospace' => "\x{FF20}",
	'atsmall' => "\x{FE6B}",
	'aturned' => "\x{0250}",
	'aubengali' => "\x{0994}",
	'aubopomofo' => "\x{3120}",
	'audeva' => "\x{0914}",
	'augujarati' => "\x{0A94}",
	'augurmukhi' => "\x{0A14}",
	'aulengthmarkbengali' => "\x{09D7}",
	'aumatragurmukhi' => "\x{0A4C}",
	'auvowelsignbengali' => "\x{09CC}",
	'auvowelsigndeva' => "\x{094C}",
	'auvowelsigngujarati' => "\x{0ACC}",
	'avagrahadeva' => "\x{093D}",
	'aybarmenian' => "\x{0561}",
	'ayin' => "\x{05E2}",
	'ayinaltonehebrew' => "\x{FB20}",
	'ayinhebrew' => "\x{05E2}",
	'babengali' => "\x{09AC}",
	'backslashmonospace' => "\x{FF3C}",
	'badeva' => "\x{092C}",
	'bagujarati' => "\x{0AAC}",
	'bagurmukhi' => "\x{0A2C}",
	'bahiragana' => "\x{3070}",
	'bahtthai' => "\x{0E3F}",
	'bakatakana' => "\x{30D0}",
	'barmonospace' => "\x{FF5C}",
	'bbopomofo' => "\x{3105}",
	'bcircle' => "\x{24D1}",
	'bdotaccent' => "\x{1E03}",
	'bdotbelow' => "\x{1E05}",
	'beamedsixteenthnotes' => "\x{266C}",
	'because' => "\x{2235}",
	'becyrillic' => "\x{0431}",
	'beharabic' => "\x{0628}",
	'behfinalarabic' => "\x{FE90}",
	'behinitialarabic' => "\x{FE91}",
	'behiragana' => "\x{3079}",
	'behmedialarabic' => "\x{FE92}",
	'behmeeminitialarabic' => "\x{FC9F}",
	'behmeemisolatedarabic' => "\x{FC08}",
	'behnoonfinalarabic' => "\x{FC6D}",
	'bekatakana' => "\x{30D9}",
	'benarmenian' => "\x{0562}",
	'bet' => "\x{05D1}",
	'betasymbolgreek' => "\x{03D0}",
	'betdagesh' => "\x{FB31}",
	'betdageshhebrew' => "\x{FB31}",
	'bethebrew' => "\x{05D1}",
	'betrafehebrew' => "\x{FB4C}",
	'bhabengali' => "\x{09AD}",
	'bhadeva' => "\x{092D}",
	'bhagujarati' => "\x{0AAD}",
	'bhagurmukhi' => "\x{0A2D}",
	'bhook' => "\x{0253}",
	'bihiragana' => "\x{3073}",
	'bikatakana' => "\x{30D3}",
	'bilabialclick' => "\x{0298}",
	'bindigurmukhi' => "\x{0A02}",
	'birusquare' => "\x{3331}",
	'blackcircle' => "\x{25CF}",
	'blackdiamond' => "\x{25C6}",
	'blackdownpointingtriangle' => "\x{25BC}",
	'blackleftpointingpointer' => "\x{25C4}",
	'blackleftpointingtriangle' => "\x{25C0}",
	'blacklenticularbracketleft' => "\x{3010}",
	'blacklenticularbracketleftvertical' => "\x{FE3B}",
	'blacklenticularbracketright' => "\x{3011}",
	'blacklenticularbracketrightvertical' => "\x{FE3C}",
	'blacklowerlefttriangle' => "\x{25E3}",
	'blacklowerrighttriangle' => "\x{25E2}",
	'blackrectangle' => "\x{25AC}",
	'blackrightpointingpointer' => "\x{25BA}",
	'blackrightpointingtriangle' => "\x{25B6}",
	'blacksmallsquare' => "\x{25AA}",
	'blacksmilingface' => "\x{263B}",
	'blacksquare' => "\x{25A0}",
	'blackstar' => "\x{2605}",
	'blackupperlefttriangle' => "\x{25E4}",
	'blackupperrighttriangle' => "\x{25E5}",
	'blackuppointingsmalltriangle' => "\x{25B4}",
	'blackuppointingtriangle' => "\x{25B2}",
	'blank' => "\x{2423}",
	'blinebelow' => "\x{1E07}",
	'bmonospace' => "\x{FF42}",
	'bobaimaithai' => "\x{0E1A}",
	'bohiragana' => "\x{307C}",
	'bokatakana' => "\x{30DC}",
	'bparen' => "\x{249D}",
	'bqsquare' => "\x{33C3}",
	'braceex' => "\x{F8F4}",
	'braceleftbt' => "\x{F8F3}",
	'braceleftmid' => "\x{F8F2}",
	'braceleftmonospace' => "\x{FF5B}",
	'braceleftsmall' => "\x{FE5B}",
	'bracelefttp' => "\x{F8F1}",
	'braceleftvertical' => "\x{FE37}",
	'bracerightbt' => "\x{F8FE}",
	'bracerightmid' => "\x{F8FD}",
	'bracerightmonospace' => "\x{FF5D}",
	'bracerightsmall' => "\x{FE5C}",
	'bracerighttp' => "\x{F8FC}",
	'bracerightvertical' => "\x{FE38}",
	'bracketleftbt' => "\x{F8F0}",
	'bracketleftex' => "\x{F8EF}",
	'bracketleftmonospace' => "\x{FF3B}",
	'bracketlefttp' => "\x{F8EE}",
	'bracketrightbt' => "\x{F8FB}",
	'bracketrightex' => "\x{F8FA}",
	'bracketrightmonospace' => "\x{FF3D}",
	'bracketrighttp' => "\x{F8F9}",
	'brevebelowcmb' => "\x{032E}",
	'brevecmb' => "\x{0306}",
	'breveinvertedbelowcmb' => "\x{032F}",
	'breveinvertedcmb' => "\x{0311}",
	'breveinverteddoublecmb' => "\x{0361}",
	'bridgebelowcmb' => "\x{032A}",
	'bridgeinvertedbelowcmb' => "\x{033A}",
	'bstroke' => "\x{0180}",
	'bsuperior' => "\x{F6EA}",
	'btopbar' => "\x{0183}",
	'buhiragana' => "\x{3076}",
	'bukatakana' => "\x{30D6}",
	'bulletinverse' => "\x{25D8}",
	'bulletoperator' => "\x{2219}",
	'bullseye' => "\x{25CE}",
	'caarmenian' => "\x{056E}",
	'cabengali' => "\x{099A}",
	'cadeva' => "\x{091A}",
	'cagujarati' => "\x{0A9A}",
	'cagurmukhi' => "\x{0A1A}",
	'calsquare' => "\x{3388}",
	'candrabindubengali' => "\x{0981}",
	'candrabinducmb' => "\x{0310}",
	'candrabindudeva' => "\x{0901}",
	'candrabindugujarati' => "\x{0A81}",
	'capslock' => "\x{21EA}",
	'careof' => "\x{2105}",
	'caronbelowcmb' => "\x{032C}",
	'caroncmb' => "\x{030C}",
	'cbopomofo' => "\x{3118}",
	'ccedillaacute' => "\x{1E09}",
	'ccircle' => "\x{24D2}",
	'ccurl' => "\x{0255}",
	'cdot' => "\x{010B}",
	'cdsquare' => "\x{33C5}",
	'cedillacmb' => "\x{0327}",
	'centigrade' => "\x{2103}",
	'centinferior' => "\x{F6DF}",
	'centmonospace' => "\x{FFE0}",
	'centoldstyle' => "\x{F7A2}",
	'centsuperior' => "\x{F6E0}",
	'chaarmenian' => "\x{0579}",
	'chabengali' => "\x{099B}",
	'chadeva' => "\x{091B}",
	'chagujarati' => "\x{0A9B}",
	'chagurmukhi' => "\x{0A1B}",
	'chbopomofo' => "\x{3114}",
	'cheabkhasiancyrillic' => "\x{04BD}",
	'checkmark' => "\x{2713}",
	'checyrillic' => "\x{0447}",
	'chedescenderabkhasiancyrillic' => "\x{04BF}",
	'chedescendercyrillic' => "\x{04B7}",
	'chedieresiscyrillic' => "\x{04F5}",
	'cheharmenian' => "\x{0573}",
	'chekhakassiancyrillic' => "\x{04CC}",
	'cheverticalstrokecyrillic' => "\x{04B9}",
	'chieuchacirclekorean' => "\x{3277}",
	'chieuchaparenkorean' => "\x{3217}",
	'chieuchcirclekorean' => "\x{3269}",
	'chieuchkorean' => "\x{314A}",
	'chieuchparenkorean' => "\x{3209}",
	'chochangthai' => "\x{0E0A}",
	'chochanthai' => "\x{0E08}",
	'chochingthai' => "\x{0E09}",
	'chochoethai' => "\x{0E0C}",
	'chook' => "\x{0188}",
	'cieucacirclekorean' => "\x{3276}",
	'cieucaparenkorean' => "\x{3216}",
	'cieuccirclekorean' => "\x{3268}",
	'cieuckorean' => "\x{3148}",
	'cieucparenkorean' => "\x{3208}",
	'cieucuparenkorean' => "\x{321C}",
	'circleot' => "\x{2299}",
	'circlepostalmark' => "\x{3036}",
	'circlewithlefthalfblack' => "\x{25D0}",
	'circlewithrighthalfblack' => "\x{25D1}",
	'circumflexbelowcmb' => "\x{032D}",
	'circumflexcmb' => "\x{0302}",
	'clear' => "\x{2327}",
	'clickalveolar' => "\x{01C2}",
	'clickdental' => "\x{01C0}",
	'clicklateral' => "\x{01C1}",
	'clickretroflex' => "\x{01C3}",
	'clubsuitblack' => "\x{2663}",
	'clubsuitwhite' => "\x{2667}",
	'cmcubedsquare' => "\x{33A4}",
	'cmonospace' => "\x{FF43}",
	'cmsquaredsquare' => "\x{33A0}",
	'coarmenian' => "\x{0581}",
	'colonmonospace' => "\x{FF1A}",
	'colonsign' => "\x{20A1}",
	'colonsmall' => "\x{FE55}",
	'colontriangularhalfmod' => "\x{02D1}",
	'colontriangularmod' => "\x{02D0}",
	'commaabovecmb' => "\x{0313}",
	'commaaboverightcmb' => "\x{0315}",
	'commaaccent' => "\x{F6C3}",
	'commaarabic' => "\x{060C}",
	'commaarmenian' => "\x{055D}",
	'commainferior' => "\x{F6E1}",
	'commamonospace' => "\x{FF0C}",
	'commareversedabovecmb' => "\x{0314}",
	'commareversedmod' => "\x{02BD}",
	'commasmall' => "\x{FE50}",
	'commasuperior' => "\x{F6E2}",
	'commaturnedabovecmb' => "\x{0312}",
	'commaturnedmod' => "\x{02BB}",
	'compass' => "\x{263C}",
	'contourintegral' => "\x{222E}",
	'control' => "\x{2303}",
	'controlACK' => "\x{0006}",
	'controlBEL' => "\x{0007}",
	'controlBS' => "\x{0008}",
	'controlCAN' => "\x{0018}",
	'controlCR' => "\x{000D}",
	'controlDC1' => "\x{0011}",
	'controlDC2' => "\x{0012}",
	'controlDC3' => "\x{0013}",
	'controlDC4' => "\x{0014}",
	'controlDEL' => "\x{007F}",
	'controlDLE' => "\x{0010}",
	'controlEM' => "\x{0019}",
	'controlENQ' => "\x{0005}",
	'controlEOT' => "\x{0004}",
	'controlESC' => "\x{001B}",
	'controlETB' => "\x{0017}",
	'controlETX' => "\x{0003}",
	'controlFF' => "\x{000C}",
	'controlFS' => "\x{001C}",
	'controlGS' => "\x{001D}",
	'controlHT' => "\x{0009}",
	'controlLF' => "\x{000A}",
	'controlNAK' => "\x{0015}",
	'controlRS' => "\x{001E}",
	'controlSI' => "\x{000F}",
	'controlSO' => "\x{000E}",
	'controlSOT' => "\x{0002}",
	'controlSTX' => "\x{0001}",
	'controlSUB' => "\x{001A}",
	'controlSYN' => "\x{0016}",
	'controlUS' => "\x{001F}",
	'controlVT' => "\x{000B}",
	'copyrightsans' => "\x{F8E9}",
	'copyrightserif' => "\x{F6D9}",
	'cornerbracketleft' => "\x{300C}",
	'cornerbracketlefthalfwidth' => "\x{FF62}",
	'cornerbracketleftvertical' => "\x{FE41}",
	'cornerbracketright' => "\x{300D}",
	'cornerbracketrighthalfwidth' => "\x{FF63}",
	'cornerbracketrightvertical' => "\x{FE42}",
	'corporationsquare' => "\x{337F}",
	'cosquare' => "\x{33C7}",
	'coverkgsquare' => "\x{33C6}",
	'cparen' => "\x{249E}",
	'cruzeiro' => "\x{20A2}",
	'cstretched' => "\x{0297}",
	'curlyand' => "\x{22CF}",
	'curlyor' => "\x{22CE}",
	'cyrBreve' => "\x{F6D1}",
	'cyrFlex' => "\x{F6D2}",
	'cyrbreve' => "\x{F6D4}",
	'cyrflex' => "\x{F6D5}",
	'daarmenian' => "\x{0564}",
	'dabengali' => "\x{09A6}",
	'dadarabic' => "\x{0636}",
	'dadeva' => "\x{0926}",
	'dadfinalarabic' => "\x{FEBE}",
	'dadinitialarabic' => "\x{FEBF}",
	'dadmedialarabic' => "\x{FEC0}",
	'dagesh' => "\x{05BC}",
	'dageshhebrew' => "\x{05BC}",
	'dagujarati' => "\x{0AA6}",
	'dagurmukhi' => "\x{0A26}",
	'dahiragana' => "\x{3060}",
	'dakatakana' => "\x{30C0}",
	'dalarabic' => "\x{062F}",
	'dalet' => "\x{05D3}",
	'daletdagesh' => "\x{FB33}",
	'daletdageshhebrew' => "\x{FB33}",
	'dalethatafpatah' => "\x{05D3}\x{05B2}",
	'dalethatafpatahhebrew' => "\x{05D3}\x{05B2}",
	'dalethatafsegol' => "\x{05D3}\x{05B1}",
	'dalethatafsegolhebrew' => "\x{05D3}\x{05B1}",
	'dalethebrew' => "\x{05D3}",
	'dalethiriq' => "\x{05D3}\x{05B4}",
	'dalethiriqhebrew' => "\x{05D3}\x{05B4}",
	'daletholam' => "\x{05D3}\x{05B9}",
	'daletholamhebrew' => "\x{05D3}\x{05B9}",
	'daletpatah' => "\x{05D3}\x{05B7}",
	'daletpatahhebrew' => "\x{05D3}\x{05B7}",
	'daletqamats' => "\x{05D3}\x{05B8}",
	'daletqamatshebrew' => "\x{05D3}\x{05B8}",
	'daletqubuts' => "\x{05D3}\x{05BB}",
	'daletqubutshebrew' => "\x{05D3}\x{05BB}",
	'daletsegol' => "\x{05D3}\x{05B6}",
	'daletsegolhebrew' => "\x{05D3}\x{05B6}",
	'daletsheva' => "\x{05D3}\x{05B0}",
	'daletshevahebrew' => "\x{05D3}\x{05B0}",
	'dalettsere' => "\x{05D3}\x{05B5}",
	'dalettserehebrew' => "\x{05D3}\x{05B5}",
	'dalfinalarabic' => "\x{FEAA}",
	'dammaarabic' => "\x{064F}",
	'dammalowarabic' => "\x{064F}",
	'dammatanaltonearabic' => "\x{064C}",
	'dammatanarabic' => "\x{064C}",
	'danda' => "\x{0964}",
	'dargahebrew' => "\x{05A7}",
	'dargalefthebrew' => "\x{05A7}",
	'dasiapneumatacyrilliccmb' => "\x{0485}",
	'dblGrave' => "\x{F6D3}",
	'dblanglebracketleft' => "\x{300A}",
	'dblanglebracketleftvertical' => "\x{FE3D}",
	'dblanglebracketright' => "\x{300B}",
	'dblanglebracketrightvertical' => "\x{FE3E}",
	'dblarchinvertedbelowcmb' => "\x{032B}",
	'dblarrowleft' => "\x{21D4}",
	'dblarrowright' => "\x{21D2}",
	'dbldanda' => "\x{0965}",
	'dblgrave' => "\x{F6D6}",
	'dblgravecmb' => "\x{030F}",
	'dblintegral' => "\x{222C}",
	'dbllowline' => "\x{2017}",
	'dbllowlinecmb' => "\x{0333}",
	'dbloverlinecmb' => "\x{033F}",
	'dblprimemod' => "\x{02BA}",
	'dblverticalbar' => "\x{2016}",
	'dblverticallineabovecmb' => "\x{030E}",
	'dbopomofo' => "\x{3109}",
	'dbsquare' => "\x{33C8}",
	'dcedilla' => "\x{1E11}",
	'dcircle' => "\x{24D3}",
	'dcircumflexbelow' => "\x{1E13}",
	'ddabengali' => "\x{09A1}",
	'ddadeva' => "\x{0921}",
	'ddagujarati' => "\x{0AA1}",
	'ddagurmukhi' => "\x{0A21}",
	'ddalarabic' => "\x{0688}",
	'ddalfinalarabic' => "\x{FB89}",
	'dddhadeva' => "\x{095C}",
	'ddhabengali' => "\x{09A2}",
	'ddhadeva' => "\x{0922}",
	'ddhagujarati' => "\x{0AA2}",
	'ddhagurmukhi' => "\x{0A22}",
	'ddotaccent' => "\x{1E0B}",
	'ddotbelow' => "\x{1E0D}",
	'decimalseparatorarabic' => "\x{066B}",
	'decimalseparatorpersian' => "\x{066B}",
	'decyrillic' => "\x{0434}",
	'dehihebrew' => "\x{05AD}",
	'dehiragana' => "\x{3067}",
	'deicoptic' => "\x{03EF}",
	'dekatakana' => "\x{30C7}",
	'deleteleft' => "\x{232B}",
	'deleteright' => "\x{2326}",
	'deltaturned' => "\x{018D}",
	'denominatorminusonenumeratorbengali' => "\x{09F8}",
	'dezh' => "\x{02A4}",
	'dhabengali' => "\x{09A7}",
	'dhadeva' => "\x{0927}",
	'dhagujarati' => "\x{0AA7}",
	'dhagurmukhi' => "\x{0A27}",
	'dhook' => "\x{0257}",
	'dialytikatonos' => "\x{0385}",
	'dialytikatonoscmb' => "\x{0344}",
	'diamondsuitwhite' => "\x{2662}",
	'dieresisacute' => "\x{F6D7}",
	'dieresisbelowcmb' => "\x{0324}",
	'dieresiscmb' => "\x{0308}",
	'dieresisgrave' => "\x{F6D8}",
	'dihiragana' => "\x{3062}",
	'dikatakana' => "\x{30C2}",
	'dittomark' => "\x{3003}",
	'divides' => "\x{2223}",
	'divisionslash' => "\x{2215}",
	'djecyrillic' => "\x{0452}",
	'dlinebelow' => "\x{1E0F}",
	'dlsquare' => "\x{3397}",
	'dmacron' => "\x{0111}",
	'dmonospace' => "\x{FF44}",
	'dochadathai' => "\x{0E0E}",
	'dodekthai' => "\x{0E14}",
	'dohiragana' => "\x{3069}",
	'dokatakana' => "\x{30C9}",
	'dollarinferior' => "\x{F6E3}",
	'dollarmonospace' => "\x{FF04}",
	'dollaroldstyle' => "\x{F724}",
	'dollarsmall' => "\x{FE69}",
	'dollarsuperior' => "\x{F6E4}",
	'dorusquare' => "\x{3326}",
	'dotaccentcmb' => "\x{0307}",
	'dotbelowcmb' => "\x{0323}",
	'dotkatakana' => "\x{30FB}",
	'dotlessj' => "\x{F6BE}",
	'dotlessjstrokehook' => "\x{0284}",
	'dottedcircle' => "\x{25CC}",
	'doubleyodpatah' => "\x{FB1F}",
	'doubleyodpatahhebrew' => "\x{FB1F}",
	'downtackbelowcmb' => "\x{031E}",
	'downtackmod' => "\x{02D5}",
	'dparen' => "\x{249F}",
	'dsuperior' => "\x{F6EB}",
	'dtail' => "\x{0256}",
	'dtopbar' => "\x{018C}",
	'duhiragana' => "\x{3065}",
	'dukatakana' => "\x{30C5}",
	'dz' => "\x{01F3}",
	'dzaltone' => "\x{02A3}",
	'dzcaron' => "\x{01C6}",
	'dzcurl' => "\x{02A5}",
	'dzeabkhasiancyrillic' => "\x{04E1}",
	'dzecyrillic' => "\x{0455}",
	'dzhecyrillic' => "\x{045F}",
	'earth' => "\x{2641}",
	'ebengali' => "\x{098F}",
	'ebopomofo' => "\x{311C}",
	'ecandradeva' => "\x{090D}",
	'ecandragujarati' => "\x{0A8D}",
	'ecandravowelsigndeva' => "\x{0945}",
	'ecandravowelsigngujarati' => "\x{0AC5}",
	'ecedillabreve' => "\x{1E1D}",
	'echarmenian' => "\x{0565}",
	'echyiwnarmenian' => "\x{0587}",
	'ecircle' => "\x{24D4}",
	'ecircumflexacute' => "\x{1EBF}",
	'ecircumflexbelow' => "\x{1E19}",
	'ecircumflexdotbelow' => "\x{1EC7}",
	'ecircumflexgrave' => "\x{1EC1}",
	'ecircumflexhookabove' => "\x{1EC3}",
	'ecircumflextilde' => "\x{1EC5}",
	'ecyrillic' => "\x{0454}",
	'edblgrave' => "\x{0205}",
	'edeva' => "\x{090F}",
	'edot' => "\x{0117}",
	'edotbelow' => "\x{1EB9}",
	'eegurmukhi' => "\x{0A0F}",
	'eematragurmukhi' => "\x{0A47}",
	'efcyrillic' => "\x{0444}",
	'egujarati' => "\x{0A8F}",
	'eharmenian' => "\x{0567}",
	'ehbopomofo' => "\x{311D}",
	'ehiragana' => "\x{3048}",
	'ehookabove' => "\x{1EBB}",
	'eibopomofo' => "\x{311F}",
	'eightarabic' => "\x{0668}",
	'eightbengali' => "\x{09EE}",
	'eightcircle' => "\x{2467}",
	'eightcircleinversesansserif' => "\x{2791}",
	'eightdeva' => "\x{096E}",
	'eighteencircle' => "\x{2471}",
	'eighteenparen' => "\x{2485}",
	'eighteenperiod' => "\x{2499}",
	'eightgujarati' => "\x{0AEE}",
	'eightgurmukhi' => "\x{0A6E}",
	'eighthackarabic' => "\x{0668}",
	'eighthangzhou' => "\x{3028}",
	'eighthnotebeamed' => "\x{266B}",
	'eightideographicparen' => "\x{3227}",
	'eightinferior' => "\x{2088}",
	'eightmonospace' => "\x{FF18}",
	'eightoldstyle' => "\x{F738}",
	'eightparen' => "\x{247B}",
	'eightperiod' => "\x{248F}",
	'eightpersian' => "\x{06F8}",
	'eightroman' => "\x{2177}",
	'eightsuperior' => "\x{2078}",
	'eightthai' => "\x{0E58}",
	'einvertedbreve' => "\x{0207}",
	'eiotifiedcyrillic' => "\x{0465}",
	'ekatakana' => "\x{30A8}",
	'ekatakanahalfwidth' => "\x{FF74}",
	'ekonkargurmukhi' => "\x{0A74}",
	'ekorean' => "\x{3154}",
	'elcyrillic' => "\x{043B}",
	'elevencircle' => "\x{246A}",
	'elevenparen' => "\x{247E}",
	'elevenperiod' => "\x{2492}",
	'elevenroman' => "\x{217A}",
	'ellipsisvertical' => "\x{22EE}",
	'emacronacute' => "\x{1E17}",
	'emacrongrave' => "\x{1E15}",
	'emcyrillic' => "\x{043C}",
	'emdashvertical' => "\x{FE31}",
	'emonospace' => "\x{FF45}",
	'emphasismarkarmenian' => "\x{055B}",
	'enbopomofo' => "\x{3123}",
	'encyrillic' => "\x{043D}",
	'endashvertical' => "\x{FE32}",
	'endescendercyrillic' => "\x{04A3}",
	'engbopomofo' => "\x{3125}",
	'enghecyrillic' => "\x{04A5}",
	'enhookcyrillic' => "\x{04C8}",
	'enspace' => "\x{2002}",
	'eokorean' => "\x{3153}",
	'eopen' => "\x{025B}",
	'eopenclosed' => "\x{029A}",
	'eopenreversed' => "\x{025C}",
	'eopenreversedclosed' => "\x{025E}",
	'eopenreversedhook' => "\x{025D}",
	'eparen' => "\x{24A0}",
	'equalmonospace' => "\x{FF1D}",
	'equalsmall' => "\x{FE66}",
	'equalsuperior' => "\x{207C}",
	'erbopomofo' => "\x{3126}",
	'ercyrillic' => "\x{0440}",
	'ereversed' => "\x{0258}",
	'ereversedcyrillic' => "\x{044D}",
	'escyrillic' => "\x{0441}",
	'esdescendercyrillic' => "\x{04AB}",
	'esh' => "\x{0283}",
	'eshcurl' => "\x{0286}",
	'eshortdeva' => "\x{090E}",
	'eshortvowelsigndeva' => "\x{0946}",
	'eshreversedloop' => "\x{01AA}",
	'eshsquatreversed' => "\x{0285}",
	'esmallhiragana' => "\x{3047}",
	'esmallkatakana' => "\x{30A7}",
	'esmallkatakanahalfwidth' => "\x{FF6A}",
	'esuperior' => "\x{F6EC}",
	'etarmenian' => "\x{0568}",
	'etilde' => "\x{1EBD}",
	'etildebelow' => "\x{1E1B}",
	'etnahtafoukhhebrew' => "\x{0591}",
	'etnahtafoukhlefthebrew' => "\x{0591}",
	'etnahtahebrew' => "\x{0591}",
	'etnahtalefthebrew' => "\x{0591}",
	'eturned' => "\x{01DD}",
	'eukorean' => "\x{3161}",
	'euro' => "\x{20AC}",
	'evowelsignbengali' => "\x{09C7}",
	'evowelsigndeva' => "\x{0947}",
	'evowelsigngujarati' => "\x{0AC7}",
	'exclamarmenian' => "\x{055C}",
	'exclamdownsmall' => "\x{F7A1}",
	'exclammonospace' => "\x{FF01}",
	'exclamsmall' => "\x{F721}",
	'ezh' => "\x{0292}",
	'ezhcaron' => "\x{01EF}",
	'ezhcurl' => "\x{0293}",
	'ezhreversed' => "\x{01B9}",
	'ezhtail' => "\x{01BA}",
	'fadeva' => "\x{095E}",
	'fagurmukhi' => "\x{0A5E}",
	'fahrenheit' => "\x{2109}",
	'fathaarabic' => "\x{064E}",
	'fathalowarabic' => "\x{064E}",
	'fathatanarabic' => "\x{064B}",
	'fbopomofo' => "\x{3108}",
	'fcircle' => "\x{24D5}",
	'fdotaccent' => "\x{1E1F}",
	'feharabic' => "\x{0641}",
	'feharmenian' => "\x{0586}",
	'fehfinalarabic' => "\x{FED2}",
	'fehinitialarabic' => "\x{FED3}",
	'fehmedialarabic' => "\x{FED4}",
	'feicoptic' => "\x{03E5}",
	'fifteencircle' => "\x{246E}",
	'fifteenparen' => "\x{2482}",
	'fifteenperiod' => "\x{2496}",
	'finalkaf' => "\x{05DA}",
	'finalkafdagesh' => "\x{FB3A}",
	'finalkafdageshhebrew' => "\x{FB3A}",
	'finalkafhebrew' => "\x{05DA}",
	'finalkafqamats' => "\x{05DA}\x{05B8}",
	'finalkafqamatshebrew' => "\x{05DA}\x{05B8}",
	'finalkafsheva' => "\x{05DA}\x{05B0}",
	'finalkafshevahebrew' => "\x{05DA}\x{05B0}",
	'finalmem' => "\x{05DD}",
	'finalmemhebrew' => "\x{05DD}",
	'finalnun' => "\x{05DF}",
	'finalnunhebrew' => "\x{05DF}",
	'finalpe' => "\x{05E3}",
	'finalpehebrew' => "\x{05E3}",
	'finaltsadi' => "\x{05E5}",
	'finaltsadihebrew' => "\x{05E5}",
	'firsttonechinese' => "\x{02C9}",
	'fisheye' => "\x{25C9}",
	'fitacyrillic' => "\x{0473}",
	'fivearabic' => "\x{0665}",
	'fivebengali' => "\x{09EB}",
	'fivecircle' => "\x{2464}",
	'fivecircleinversesansserif' => "\x{278E}",
	'fivedeva' => "\x{096B}",
	'fivegujarati' => "\x{0AEB}",
	'fivegurmukhi' => "\x{0A6B}",
	'fivehackarabic' => "\x{0665}",
	'fivehangzhou' => "\x{3025}",
	'fiveideographicparen' => "\x{3224}",
	'fiveinferior' => "\x{2085}",
	'fivemonospace' => "\x{FF15}",
	'fiveoldstyle' => "\x{F735}",
	'fiveparen' => "\x{2478}",
	'fiveperiod' => "\x{248C}",
	'fivepersian' => "\x{06F5}",
	'fiveroman' => "\x{2174}",
	'fivesuperior' => "\x{2075}",
	'fivethai' => "\x{0E55}",
	'fmonospace' => "\x{FF46}",
	'fmsquare' => "\x{3399}",
	'fofanthai' => "\x{0E1F}",
	'fofathai' => "\x{0E1D}",
	'fongmanthai' => "\x{0E4F}",
	'forall' => "\x{2200}",
	'fourarabic' => "\x{0664}",
	'fourbengali' => "\x{09EA}",
	'fourcircle' => "\x{2463}",
	'fourcircleinversesansserif' => "\x{278D}",
	'fourdeva' => "\x{096A}",
	'fourgujarati' => "\x{0AEA}",
	'fourgurmukhi' => "\x{0A6A}",
	'fourhackarabic' => "\x{0664}",
	'fourhangzhou' => "\x{3024}",
	'fourideographicparen' => "\x{3223}",
	'fourinferior' => "\x{2084}",
	'fourmonospace' => "\x{FF14}",
	'fournumeratorbengali' => "\x{09F7}",
	'fouroldstyle' => "\x{F734}",
	'fourparen' => "\x{2477}",
	'fourperiod' => "\x{248B}",
	'fourpersian' => "\x{06F4}",
	'fourroman' => "\x{2173}",
	'foursuperior' => "\x{2074}",
	'fourteencircle' => "\x{246D}",
	'fourteenparen' => "\x{2481}",
	'fourteenperiod' => "\x{2495}",
	'fourthai' => "\x{0E54}",
	'fourthtonechinese' => "\x{02CB}",
	'fparen' => "\x{24A1}",
	'gabengali' => "\x{0997}",
	'gacute' => "\x{01F5}",
	'gadeva' => "\x{0917}",
	'gafarabic' => "\x{06AF}",
	'gaffinalarabic' => "\x{FB93}",
	'gafinitialarabic' => "\x{FB94}",
	'gafmedialarabic' => "\x{FB95}",
	'gagujarati' => "\x{0A97}",
	'gagurmukhi' => "\x{0A17}",
	'gahiragana' => "\x{304C}",
	'gakatakana' => "\x{30AC}",
	'gammalatinsmall' => "\x{0263}",
	'gammasuperior' => "\x{02E0}",
	'gangiacoptic' => "\x{03EB}",
	'gbopomofo' => "\x{310D}",
	'gcedilla' => "\x{0123}",
	'gcircle' => "\x{24D6}",
	'gdot' => "\x{0121}",
	'gecyrillic' => "\x{0433}",
	'gehiragana' => "\x{3052}",
	'gekatakana' => "\x{30B2}",
	'geometricallyequal' => "\x{2251}",
	'gereshaccenthebrew' => "\x{059C}",
	'gereshhebrew' => "\x{05F3}",
	'gereshmuqdamhebrew' => "\x{059D}",
	'gershayimaccenthebrew' => "\x{059E}",
	'gershayimhebrew' => "\x{05F4}",
	'getamark' => "\x{3013}",
	'ghabengali' => "\x{0998}",
	'ghadarmenian' => "\x{0572}",
	'ghadeva' => "\x{0918}",
	'ghagujarati' => "\x{0A98}",
	'ghagurmukhi' => "\x{0A18}",
	'ghainarabic' => "\x{063A}",
	'ghainfinalarabic' => "\x{FECE}",
	'ghaininitialarabic' => "\x{FECF}",
	'ghainmedialarabic' => "\x{FED0}",
	'ghemiddlehookcyrillic' => "\x{0495}",
	'ghestrokecyrillic' => "\x{0493}",
	'gheupturncyrillic' => "\x{0491}",
	'ghhadeva' => "\x{095A}",
	'ghhagurmukhi' => "\x{0A5A}",
	'ghook' => "\x{0260}",
	'ghzsquare' => "\x{3393}",
	'gihiragana' => "\x{304E}",
	'gikatakana' => "\x{30AE}",
	'gimarmenian' => "\x{0563}",
	'gimel' => "\x{05D2}",
	'gimeldagesh' => "\x{FB32}",
	'gimeldageshhebrew' => "\x{FB32}",
	'gimelhebrew' => "\x{05D2}",
	'gjecyrillic' => "\x{0453}",
	'glottalinvertedstroke' => "\x{01BE}",
	'glottalstop' => "\x{0294}",
	'glottalstopinverted' => "\x{0296}",
	'glottalstopmod' => "\x{02C0}",
	'glottalstopreversed' => "\x{0295}",
	'glottalstopreversedmod' => "\x{02C1}",
	'glottalstopreversedsuperior' => "\x{02E4}",
	'glottalstopstroke' => "\x{02A1}",
	'glottalstopstrokereversed' => "\x{02A2}",
	'gmacron' => "\x{1E21}",
	'gmonospace' => "\x{FF47}",
	'gohiragana' => "\x{3054}",
	'gokatakana' => "\x{30B4}",
	'gparen' => "\x{24A2}",
	'gpasquare' => "\x{33AC}",
	'gravebelowcmb' => "\x{0316}",
	'gravecmb' => "\x{0300}",
	'gravedeva' => "\x{0953}",
	'gravelowmod' => "\x{02CE}",
	'gravemonospace' => "\x{FF40}",
	'gravetonecmb' => "\x{0340}",
	'greaterequalorless' => "\x{22DB}",
	'greatermonospace' => "\x{FF1E}",
	'greaterorequivalent' => "\x{2273}",
	'greaterorless' => "\x{2277}",
	'greateroverequal' => "\x{2267}",
	'greatersmall' => "\x{FE65}",
	'gscript' => "\x{0261}",
	'gstroke' => "\x{01E5}",
	'guhiragana' => "\x{3050}",
	'gukatakana' => "\x{30B0}",
	'guramusquare' => "\x{3318}",
	'gysquare' => "\x{33C9}",
	'haabkhasiancyrillic' => "\x{04A9}",
	'haaltonearabic' => "\x{06C1}",
	'habengali' => "\x{09B9}",
	'hadescendercyrillic' => "\x{04B3}",
	'hadeva' => "\x{0939}",
	'hagujarati' => "\x{0AB9}",
	'hagurmukhi' => "\x{0A39}",
	'haharabic' => "\x{062D}",
	'hahfinalarabic' => "\x{FEA2}",
	'hahinitialarabic' => "\x{FEA3}",
	'hahiragana' => "\x{306F}",
	'hahmedialarabic' => "\x{FEA4}",
	'haitusquare' => "\x{332A}",
	'hakatakana' => "\x{30CF}",
	'hakatakanahalfwidth' => "\x{FF8A}",
	'halantgurmukhi' => "\x{0A4D}",
	'hamzaarabic' => "\x{0621}",
	'hamzadammaarabic' => "\x{0621}\x{064F}",
	'hamzadammatanarabic' => "\x{0621}\x{064C}",
	'hamzafathaarabic' => "\x{0621}\x{064E}",
	'hamzafathatanarabic' => "\x{0621}\x{064B}",
	'hamzalowarabic' => "\x{0621}",
	'hamzalowkasraarabic' => "\x{0621}\x{0650}",
	'hamzalowkasratanarabic' => "\x{0621}\x{064D}",
	'hamzasukunarabic' => "\x{0621}\x{0652}",
	'hangulfiller' => "\x{3164}",
	'hardsigncyrillic' => "\x{044A}",
	'harpoonleftbarbup' => "\x{21BC}",
	'harpoonrightbarbup' => "\x{21C0}",
	'hasquare' => "\x{33CA}",
	'hatafpatah' => "\x{05B2}",
	'hatafpatah16' => "\x{05B2}",
	'hatafpatah23' => "\x{05B2}",
	'hatafpatah2f' => "\x{05B2}",
	'hatafpatahhebrew' => "\x{05B2}",
	'hatafpatahnarrowhebrew' => "\x{05B2}",
	'hatafpatahquarterhebrew' => "\x{05B2}",
	'hatafpatahwidehebrew' => "\x{05B2}",
	'hatafqamats' => "\x{05B3}",
	'hatafqamats1b' => "\x{05B3}",
	'hatafqamats28' => "\x{05B3}",
	'hatafqamats34' => "\x{05B3}",
	'hatafqamatshebrew' => "\x{05B3}",
	'hatafqamatsnarrowhebrew' => "\x{05B3}",
	'hatafqamatsquarterhebrew' => "\x{05B3}",
	'hatafqamatswidehebrew' => "\x{05B3}",
	'hatafsegol' => "\x{05B1}",
	'hatafsegol17' => "\x{05B1}",
	'hatafsegol24' => "\x{05B1}",
	'hatafsegol30' => "\x{05B1}",
	'hatafsegolhebrew' => "\x{05B1}",
	'hatafsegolnarrowhebrew' => "\x{05B1}",
	'hatafsegolquarterhebrew' => "\x{05B1}",
	'hatafsegolwidehebrew' => "\x{05B1}",
	'hbopomofo' => "\x{310F}",
	'hbrevebelow' => "\x{1E2B}",
	'hcedilla' => "\x{1E29}",
	'hcircle' => "\x{24D7}",
	'hdieresis' => "\x{1E27}",
	'hdotaccent' => "\x{1E23}",
	'hdotbelow' => "\x{1E25}",
	'he' => "\x{05D4}",
	'heartsuitblack' => "\x{2665}",
	'heartsuitwhite' => "\x{2661}",
	'hedagesh' => "\x{FB34}",
	'hedageshhebrew' => "\x{FB34}",
	'hehaltonearabic' => "\x{06C1}",
	'heharabic' => "\x{0647}",
	'hehebrew' => "\x{05D4}",
	'hehfinalaltonearabic' => "\x{FBA7}",
	'hehfinalalttwoarabic' => "\x{FEEA}",
	'hehfinalarabic' => "\x{FEEA}",
	'hehhamzaabovefinalarabic' => "\x{FBA5}",
	'hehhamzaaboveisolatedarabic' => "\x{FBA4}",
	'hehinitialaltonearabic' => "\x{FBA8}",
	'hehinitialarabic' => "\x{FEEB}",
	'hehiragana' => "\x{3078}",
	'hehmedialaltonearabic' => "\x{FBA9}",
	'hehmedialarabic' => "\x{FEEC}",
	'heiseierasquare' => "\x{337B}",
	'hekatakana' => "\x{30D8}",
	'hekatakanahalfwidth' => "\x{FF8D}",
	'hekutaarusquare' => "\x{3336}",
	'henghook' => "\x{0267}",
	'herutusquare' => "\x{3339}",
	'het' => "\x{05D7}",
	'hethebrew' => "\x{05D7}",
	'hhook' => "\x{0266}",
	'hhooksuperior' => "\x{02B1}",
	'hieuhacirclekorean' => "\x{327B}",
	'hieuhaparenkorean' => "\x{321B}",
	'hieuhcirclekorean' => "\x{326D}",
	'hieuhkorean' => "\x{314E}",
	'hieuhparenkorean' => "\x{320D}",
	'hihiragana' => "\x{3072}",
	'hikatakana' => "\x{30D2}",
	'hikatakanahalfwidth' => "\x{FF8B}",
	'hiriq' => "\x{05B4}",
	'hiriq14' => "\x{05B4}",
	'hiriq21' => "\x{05B4}",
	'hiriq2d' => "\x{05B4}",
	'hiriqhebrew' => "\x{05B4}",
	'hiriqnarrowhebrew' => "\x{05B4}",
	'hiriqquarterhebrew' => "\x{05B4}",
	'hiriqwidehebrew' => "\x{05B4}",
	'hlinebelow' => "\x{1E96}",
	'hmonospace' => "\x{FF48}",
	'hoarmenian' => "\x{0570}",
	'hohipthai' => "\x{0E2B}",
	'hohiragana' => "\x{307B}",
	'hokatakana' => "\x{30DB}",
	'hokatakanahalfwidth' => "\x{FF8E}",
	'holam' => "\x{05B9}",
	'holam19' => "\x{05B9}",
	'holam26' => "\x{05B9}",
	'holam32' => "\x{05B9}",
	'holamhebrew' => "\x{05B9}",
	'holamnarrowhebrew' => "\x{05B9}",
	'holamquarterhebrew' => "\x{05B9}",
	'holamwidehebrew' => "\x{05B9}",
	'honokhukthai' => "\x{0E2E}",
	'hookcmb' => "\x{0309}",
	'hookpalatalizedbelowcmb' => "\x{0321}",
	'hookretroflexbelowcmb' => "\x{0322}",
	'hoonsquare' => "\x{3342}",
	'horicoptic' => "\x{03E9}",
	'horizontalbar' => "\x{2015}",
	'horncmb' => "\x{031B}",
	'hotsprings' => "\x{2668}",
	'hparen' => "\x{24A3}",
	'hsuperior' => "\x{02B0}",
	'hturned' => "\x{0265}",
	'huhiragana' => "\x{3075}",
	'huiitosquare' => "\x{3333}",
	'hukatakana' => "\x{30D5}",
	'hukatakanahalfwidth' => "\x{FF8C}",
	'hungarumlautcmb' => "\x{030B}",
	'hv' => "\x{0195}",
	'hypheninferior' => "\x{F6E5}",
	'hyphenmonospace' => "\x{FF0D}",
	'hyphensmall' => "\x{FE63}",
	'hyphensuperior' => "\x{F6E6}",
	'hyphentwo' => "\x{2010}",
	'iacyrillic' => "\x{044F}",
	'ibengali' => "\x{0987}",
	'ibopomofo' => "\x{3127}",
	'icaron' => "\x{01D0}",
	'icircle' => "\x{24D8}",
	'icyrillic' => "\x{0456}",
	'idblgrave' => "\x{0209}",
	'ideographearthcircle' => "\x{328F}",
	'ideographfirecircle' => "\x{328B}",
	'ideographicallianceparen' => "\x{323F}",
	'ideographiccallparen' => "\x{323A}",
	'ideographiccentrecircle' => "\x{32A5}",
	'ideographicclose' => "\x{3006}",
	'ideographiccomma' => "\x{3001}",
	'ideographiccommaleft' => "\x{FF64}",
	'ideographiccongratulationparen' => "\x{3237}",
	'ideographiccorrectcircle' => "\x{32A3}",
	'ideographicearthparen' => "\x{322F}",
	'ideographicenterpriseparen' => "\x{323D}",
	'ideographicexcellentcircle' => "\x{329D}",
	'ideographicfestivalparen' => "\x{3240}",
	'ideographicfinancialcircle' => "\x{3296}",
	'ideographicfinancialparen' => "\x{3236}",
	'ideographicfireparen' => "\x{322B}",
	'ideographichaveparen' => "\x{3232}",
	'ideographichighcircle' => "\x{32A4}",
	'ideographiciterationmark' => "\x{3005}",
	'ideographiclaborcircle' => "\x{3298}",
	'ideographiclaborparen' => "\x{3238}",
	'ideographicleftcircle' => "\x{32A7}",
	'ideographiclowcircle' => "\x{32A6}",
	'ideographicmedicinecircle' => "\x{32A9}",
	'ideographicmetalparen' => "\x{322E}",
	'ideographicmoonparen' => "\x{322A}",
	'ideographicnameparen' => "\x{3234}",
	'ideographicperiod' => "\x{3002}",
	'ideographicprintcircle' => "\x{329E}",
	'ideographicreachparen' => "\x{3243}",
	'ideographicrepresentparen' => "\x{3239}",
	'ideographicresourceparen' => "\x{323E}",
	'ideographicrightcircle' => "\x{32A8}",
	'ideographicsecretcircle' => "\x{3299}",
	'ideographicselfparen' => "\x{3242}",
	'ideographicsocietyparen' => "\x{3233}",
	'ideographicspace' => "\x{3000}",
	'ideographicspecialparen' => "\x{3235}",
	'ideographicstockparen' => "\x{3231}",
	'ideographicstudyparen' => "\x{323B}",
	'ideographicsunparen' => "\x{3230}",
	'ideographicsuperviseparen' => "\x{323C}",
	'ideographicwaterparen' => "\x{322C}",
	'ideographicwoodparen' => "\x{322D}",
	'ideographiczero' => "\x{3007}",
	'ideographmetalcircle' => "\x{328E}",
	'ideographmooncircle' => "\x{328A}",
	'ideographnamecircle' => "\x{3294}",
	'ideographsuncircle' => "\x{3290}",
	'ideographwatercircle' => "\x{328C}",
	'ideographwoodcircle' => "\x{328D}",
	'ideva' => "\x{0907}",
	'idieresisacute' => "\x{1E2F}",
	'idieresiscyrillic' => "\x{04E5}",
	'idotbelow' => "\x{1ECB}",
	'iebrevecyrillic' => "\x{04D7}",
	'iecyrillic' => "\x{0435}",
	'ieungacirclekorean' => "\x{3275}",
	'ieungaparenkorean' => "\x{3215}",
	'ieungcirclekorean' => "\x{3267}",
	'ieungkorean' => "\x{3147}",
	'ieungparenkorean' => "\x{3207}",
	'igujarati' => "\x{0A87}",
	'igurmukhi' => "\x{0A07}",
	'ihiragana' => "\x{3044}",
	'ihookabove' => "\x{1EC9}",
	'iibengali' => "\x{0988}",
	'iicyrillic' => "\x{0438}",
	'iideva' => "\x{0908}",
	'iigujarati' => "\x{0A88}",
	'iigurmukhi' => "\x{0A08}",
	'iimatragurmukhi' => "\x{0A40}",
	'iinvertedbreve' => "\x{020B}",
	'iishortcyrillic' => "\x{0439}",
	'iivowelsignbengali' => "\x{09C0}",
	'iivowelsigndeva' => "\x{0940}",
	'iivowelsigngujarati' => "\x{0AC0}",
	'ikatakana' => "\x{30A4}",
	'ikatakanahalfwidth' => "\x{FF72}",
	'ikorean' => "\x{3163}",
	'ilde' => "\x{02DC}",
	'iluyhebrew' => "\x{05AC}",
	'imacroncyrillic' => "\x{04E3}",
	'imageorapproximatelyequal' => "\x{2253}",
	'imatragurmukhi' => "\x{0A3F}",
	'imonospace' => "\x{FF49}",
	'increment' => "\x{2206}",
	'iniarmenian' => "\x{056B}",
	'integralbottom' => "\x{2321}",
	'integralex' => "\x{F8F5}",
	'integraltop' => "\x{2320}",
	'intisquare' => "\x{3305}",
	'iocyrillic' => "\x{0451}",
	'iotalatin' => "\x{0269}",
	'iparen' => "\x{24A4}",
	'irigurmukhi' => "\x{0A72}",
	'ismallhiragana' => "\x{3043}",
	'ismallkatakana' => "\x{30A3}",
	'ismallkatakanahalfwidth' => "\x{FF68}",
	'issharbengali' => "\x{09FA}",
	'istroke' => "\x{0268}",
	'isuperior' => "\x{F6ED}",
	'iterationhiragana' => "\x{309D}",
	'iterationkatakana' => "\x{30FD}",
	'itildebelow' => "\x{1E2D}",
	'iubopomofo' => "\x{3129}",
	'iucyrillic' => "\x{044E}",
	'ivowelsignbengali' => "\x{09BF}",
	'ivowelsigndeva' => "\x{093F}",
	'ivowelsigngujarati' => "\x{0ABF}",
	'izhitsacyrillic' => "\x{0475}",
	'izhitsadblgravecyrillic' => "\x{0477}",
	'jaarmenian' => "\x{0571}",
	'jabengali' => "\x{099C}",
	'jadeva' => "\x{091C}",
	'jagujarati' => "\x{0A9C}",
	'jagurmukhi' => "\x{0A1C}",
	'jbopomofo' => "\x{3110}",
	'jcaron' => "\x{01F0}",
	'jcircle' => "\x{24D9}",
	'jcrossedtail' => "\x{029D}",
	'jdotlessstroke' => "\x{025F}",
	'jecyrillic' => "\x{0458}",
	'jeemarabic' => "\x{062C}",
	'jeemfinalarabic' => "\x{FE9E}",
	'jeeminitialarabic' => "\x{FE9F}",
	'jeemmedialarabic' => "\x{FEA0}",
	'jeharabic' => "\x{0698}",
	'jehfinalarabic' => "\x{FB8B}",
	'jhabengali' => "\x{099D}",
	'jhadeva' => "\x{091D}",
	'jhagujarati' => "\x{0A9D}",
	'jhagurmukhi' => "\x{0A1D}",
	'jheharmenian' => "\x{057B}",
	'jis' => "\x{3004}",
	'jmonospace' => "\x{FF4A}",
	'jparen' => "\x{24A5}",
	'jsuperior' => "\x{02B2}",
	'kabashkircyrillic' => "\x{04A1}",
	'kabengali' => "\x{0995}",
	'kacute' => "\x{1E31}",
	'kacyrillic' => "\x{043A}",
	'kadescendercyrillic' => "\x{049B}",
	'kadeva' => "\x{0915}",
	'kaf' => "\x{05DB}",
	'kafarabic' => "\x{0643}",
	'kafdagesh' => "\x{FB3B}",
	'kafdageshhebrew' => "\x{FB3B}",
	'kaffinalarabic' => "\x{FEDA}",
	'kafhebrew' => "\x{05DB}",
	'kafinitialarabic' => "\x{FEDB}",
	'kafmedialarabic' => "\x{FEDC}",
	'kafrafehebrew' => "\x{FB4D}",
	'kagujarati' => "\x{0A95}",
	'kagurmukhi' => "\x{0A15}",
	'kahiragana' => "\x{304B}",
	'kahookcyrillic' => "\x{04C4}",
	'kakatakana' => "\x{30AB}",
	'kakatakanahalfwidth' => "\x{FF76}",
	'kappasymbolgreek' => "\x{03F0}",
	'kapyeounmieumkorean' => "\x{3171}",
	'kapyeounphieuphkorean' => "\x{3184}",
	'kapyeounpieupkorean' => "\x{3178}",
	'kapyeounssangpieupkorean' => "\x{3179}",
	'karoriisquare' => "\x{330D}",
	'kashidaautoarabic' => "\x{0640}",
	'kashidaautonosidebearingarabic' => "\x{0640}",
	'kasmallkatakana' => "\x{30F5}",
	'kasquare' => "\x{3384}",
	'kasraarabic' => "\x{0650}",
	'kasratanarabic' => "\x{064D}",
	'kastrokecyrillic' => "\x{049F}",
	'katahiraprolongmarkhalfwidth' => "\x{FF70}",
	'kaverticalstrokecyrillic' => "\x{049D}",
	'kbopomofo' => "\x{310E}",
	'kcalsquare' => "\x{3389}",
	'kcaron' => "\x{01E9}",
	'kcedilla' => "\x{0137}",
	'kcircle' => "\x{24DA}",
	'kdotbelow' => "\x{1E33}",
	'keharmenian' => "\x{0584}",
	'kehiragana' => "\x{3051}",
	'kekatakana' => "\x{30B1}",
	'kekatakanahalfwidth' => "\x{FF79}",
	'kenarmenian' => "\x{056F}",
	'kesmallkatakana' => "\x{30F6}",
	'khabengali' => "\x{0996}",
	'khacyrillic' => "\x{0445}",
	'khadeva' => "\x{0916}",
	'khagujarati' => "\x{0A96}",
	'khagurmukhi' => "\x{0A16}",
	'khaharabic' => "\x{062E}",
	'khahfinalarabic' => "\x{FEA6}",
	'khahinitialarabic' => "\x{FEA7}",
	'khahmedialarabic' => "\x{FEA8}",
	'kheicoptic' => "\x{03E7}",
	'khhadeva' => "\x{0959}",
	'khhagurmukhi' => "\x{0A59}",
	'khieukhacirclekorean' => "\x{3278}",
	'khieukhaparenkorean' => "\x{3218}",
	'khieukhcirclekorean' => "\x{326A}",
	'khieukhkorean' => "\x{314B}",
	'khieukhparenkorean' => "\x{320A}",
	'khokhaithai' => "\x{0E02}",
	'khokhonthai' => "\x{0E05}",
	'khokhuatthai' => "\x{0E03}",
	'khokhwaithai' => "\x{0E04}",
	'khomutthai' => "\x{0E5B}",
	'khook' => "\x{0199}",
	'khorakhangthai' => "\x{0E06}",
	'khzsquare' => "\x{3391}",
	'kihiragana' => "\x{304D}",
	'kikatakana' => "\x{30AD}",
	'kikatakanahalfwidth' => "\x{FF77}",
	'kiroguramusquare' => "\x{3315}",
	'kiromeetorusquare' => "\x{3316}",
	'kirosquare' => "\x{3314}",
	'kiyeokacirclekorean' => "\x{326E}",
	'kiyeokaparenkorean' => "\x{320E}",
	'kiyeokcirclekorean' => "\x{3260}",
	'kiyeokkorean' => "\x{3131}",
	'kiyeokparenkorean' => "\x{3200}",
	'kiyeoksioskorean' => "\x{3133}",
	'kjecyrillic' => "\x{045C}",
	'klinebelow' => "\x{1E35}",
	'klsquare' => "\x{3398}",
	'kmcubedsquare' => "\x{33A6}",
	'kmonospace' => "\x{FF4B}",
	'kmsquaredsquare' => "\x{33A2}",
	'kohiragana' => "\x{3053}",
	'kohmsquare' => "\x{33C0}",
	'kokaithai' => "\x{0E01}",
	'kokatakana' => "\x{30B3}",
	'kokatakanahalfwidth' => "\x{FF7A}",
	'kooposquare' => "\x{331E}",
	'koppacyrillic' => "\x{0481}",
	'koreanstandardsymbol' => "\x{327F}",
	'koroniscmb' => "\x{0343}",
	'kparen' => "\x{24A6}",
	'kpasquare' => "\x{33AA}",
	'ksicyrillic' => "\x{046F}",
	'ktsquare' => "\x{33CF}",
	'kturned' => "\x{029E}",
	'kuhiragana' => "\x{304F}",
	'kukatakana' => "\x{30AF}",
	'kukatakanahalfwidth' => "\x{FF78}",
	'kvsquare' => "\x{33B8}",
	'kwsquare' => "\x{33BE}",
	'labengali' => "\x{09B2}",
	'ladeva' => "\x{0932}",
	'lagujarati' => "\x{0AB2}",
	'lagurmukhi' => "\x{0A32}",
	'lakkhangyaothai' => "\x{0E45}",
	'lamaleffinalarabic' => "\x{FEFC}",
	'lamalefhamzaabovefinalarabic' => "\x{FEF8}",
	'lamalefhamzaaboveisolatedarabic' => "\x{FEF7}",
	'lamalefhamzabelowfinalarabic' => "\x{FEFA}",
	'lamalefhamzabelowisolatedarabic' => "\x{FEF9}",
	'lamalefisolatedarabic' => "\x{FEFB}",
	'lamalefmaddaabovefinalarabic' => "\x{FEF6}",
	'lamalefmaddaaboveisolatedarabic' => "\x{FEF5}",
	'lamarabic' => "\x{0644}",
	'lambdastroke' => "\x{019B}",
	'lamed' => "\x{05DC}",
	'lameddagesh' => "\x{FB3C}",
	'lameddageshhebrew' => "\x{FB3C}",
	'lamedhebrew' => "\x{05DC}",
	'lamedholam' => "\x{05DC}\x{05B9}",
	'lamedholamdagesh' => "\x{05DC}\x{05B9}\x{05BC}",
	'lamedholamdageshhebrew' => "\x{05DC}\x{05B9}\x{05BC}",
	'lamedholamhebrew' => "\x{05DC}\x{05B9}",
	'lamfinalarabic' => "\x{FEDE}",
	'lamhahinitialarabic' => "\x{FCCA}",
	'laminitialarabic' => "\x{FEDF}",
	'lamjeeminitialarabic' => "\x{FCC9}",
	'lamkhahinitialarabic' => "\x{FCCB}",
	'lamlamhehisolatedarabic' => "\x{FDF2}",
	'lammedialarabic' => "\x{FEE0}",
	'lammeemhahinitialarabic' => "\x{FD88}",
	'lammeeminitialarabic' => "\x{FCCC}",
	'lammeemjeeminitialarabic' => "\x{FEDF}\x{FEE4}\x{FEA0}",
	'lammeemkhahinitialarabic' => "\x{FEDF}\x{FEE4}\x{FEA8}",
	'largecircle' => "\x{25EF}",
	'lbar' => "\x{019A}",
	'lbelt' => "\x{026C}",
	'lbopomofo' => "\x{310C}",
	'lcedilla' => "\x{013C}",
	'lcircle' => "\x{24DB}",
	'lcircumflexbelow' => "\x{1E3D}",
	'ldotaccent' => "\x{0140}",
	'ldotbelow' => "\x{1E37}",
	'ldotbelowmacron' => "\x{1E39}",
	'leftangleabovecmb' => "\x{031A}",
	'lefttackbelowcmb' => "\x{0318}",
	'lessequalorgreater' => "\x{22DA}",
	'lessmonospace' => "\x{FF1C}",
	'lessorequivalent' => "\x{2272}",
	'lessorgreater' => "\x{2276}",
	'lessoverequal' => "\x{2266}",
	'lesssmall' => "\x{FE64}",
	'lezh' => "\x{026E}",
	'lhookretroflex' => "\x{026D}",
	'liwnarmenian' => "\x{056C}",
	'lj' => "\x{01C9}",
	'ljecyrillic' => "\x{0459}",
	'll' => "\x{F6C0}",
	'lladeva' => "\x{0933}",
	'llagujarati' => "\x{0AB3}",
	'llinebelow' => "\x{1E3B}",
	'llladeva' => "\x{0934}",
	'llvocalicbengali' => "\x{09E1}",
	'llvocalicdeva' => "\x{0961}",
	'llvocalicvowelsignbengali' => "\x{09E3}",
	'llvocalicvowelsigndeva' => "\x{0963}",
	'lmiddletilde' => "\x{026B}",
	'lmonospace' => "\x{FF4C}",
	'lmsquare' => "\x{33D0}",
	'lochulathai' => "\x{0E2C}",
	'logicalnotreversed' => "\x{2310}",
	'lolingthai' => "\x{0E25}",
	'lowlinecenterline' => "\x{FE4E}",
	'lowlinecmb' => "\x{0332}",
	'lowlinedashed' => "\x{FE4D}",
	'lparen' => "\x{24A7}",
	'lsquare' => "\x{2113}",
	'lsuperior' => "\x{F6EE}",
	'luthai' => "\x{0E26}",
	'lvocalicbengali' => "\x{098C}",
	'lvocalicdeva' => "\x{090C}",
	'lvocalicvowelsignbengali' => "\x{09E2}",
	'lvocalicvowelsigndeva' => "\x{0962}",
	'lxsquare' => "\x{33D3}",
	'mabengali' => "\x{09AE}",
	'macronbelowcmb' => "\x{0331}",
	'macroncmb' => "\x{0304}",
	'macronlowmod' => "\x{02CD}",
	'macronmonospace' => "\x{FFE3}",
	'macute' => "\x{1E3F}",
	'madeva' => "\x{092E}",
	'magujarati' => "\x{0AAE}",
	'magurmukhi' => "\x{0A2E}",
	'mahapakhhebrew' => "\x{05A4}",
	'mahapakhlefthebrew' => "\x{05A4}",
	'mahiragana' => "\x{307E}",
	'maichattawalowleftthai' => "\x{F895}",
	'maichattawalowrightthai' => "\x{F894}",
	'maichattawathai' => "\x{0E4B}",
	'maichattawaupperleftthai' => "\x{F893}",
	'maieklowleftthai' => "\x{F88C}",
	'maieklowrightthai' => "\x{F88B}",
	'maiekthai' => "\x{0E48}",
	'maiekupperleftthai' => "\x{F88A}",
	'maihanakatleftthai' => "\x{F884}",
	'maihanakatthai' => "\x{0E31}",
	'maitaikhuleftthai' => "\x{F889}",
	'maitaikhuthai' => "\x{0E47}",
	'maitholowleftthai' => "\x{F88F}",
	'maitholowrightthai' => "\x{F88E}",
	'maithothai' => "\x{0E49}",
	'maithoupperleftthai' => "\x{F88D}",
	'maitrilowleftthai' => "\x{F892}",
	'maitrilowrightthai' => "\x{F891}",
	'maitrithai' => "\x{0E4A}",
	'maitriupperleftthai' => "\x{F890}",
	'maiyamokthai' => "\x{0E46}",
	'makatakana' => "\x{30DE}",
	'makatakanahalfwidth' => "\x{FF8F}",
	'mansyonsquare' => "\x{3347}",
	'maqafhebrew' => "\x{05BE}",
	'mars' => "\x{2642}",
	'masoracirclehebrew' => "\x{05AF}",
	'masquare' => "\x{3383}",
	'mbopomofo' => "\x{3107}",
	'mbsquare' => "\x{33D4}",
	'mcircle' => "\x{24DC}",
	'mcubedsquare' => "\x{33A5}",
	'mdotaccent' => "\x{1E41}",
	'mdotbelow' => "\x{1E43}",
	'meemarabic' => "\x{0645}",
	'meemfinalarabic' => "\x{FEE2}",
	'meeminitialarabic' => "\x{FEE3}",
	'meemmedialarabic' => "\x{FEE4}",
	'meemmeeminitialarabic' => "\x{FCD1}",
	'meemmeemisolatedarabic' => "\x{FC48}",
	'meetorusquare' => "\x{334D}",
	'mehiragana' => "\x{3081}",
	'meizierasquare' => "\x{337E}",
	'mekatakana' => "\x{30E1}",
	'mekatakanahalfwidth' => "\x{FF92}",
	'mem' => "\x{05DE}",
	'memdagesh' => "\x{FB3E}",
	'memdageshhebrew' => "\x{FB3E}",
	'memhebrew' => "\x{05DE}",
	'menarmenian' => "\x{0574}",
	'merkhahebrew' => "\x{05A5}",
	'merkhakefulahebrew' => "\x{05A6}",
	'merkhakefulalefthebrew' => "\x{05A6}",
	'merkhalefthebrew' => "\x{05A5}",
	'mhook' => "\x{0271}",
	'mhzsquare' => "\x{3392}",
	'middledotkatakanahalfwidth' => "\x{FF65}",
	'middot' => "\x{00B7}",
	'mieumacirclekorean' => "\x{3272}",
	'mieumaparenkorean' => "\x{3212}",
	'mieumcirclekorean' => "\x{3264}",
	'mieumkorean' => "\x{3141}",
	'mieumpansioskorean' => "\x{3170}",
	'mieumparenkorean' => "\x{3204}",
	'mieumpieupkorean' => "\x{316E}",
	'mieumsioskorean' => "\x{316F}",
	'mihiragana' => "\x{307F}",
	'mikatakana' => "\x{30DF}",
	'mikatakanahalfwidth' => "\x{FF90}",
	'minusbelowcmb' => "\x{0320}",
	'minuscircle' => "\x{2296}",
	'minusmod' => "\x{02D7}",
	'minusplus' => "\x{2213}",
	'miribaarusquare' => "\x{334A}",
	'mirisquare' => "\x{3349}",
	'mlonglegturned' => "\x{0270}",
	'mlsquare' => "\x{3396}",
	'mmcubedsquare' => "\x{33A3}",
	'mmonospace' => "\x{FF4D}",
	'mmsquaredsquare' => "\x{339F}",
	'mohiragana' => "\x{3082}",
	'mohmsquare' => "\x{33C1}",
	'mokatakana' => "\x{30E2}",
	'mokatakanahalfwidth' => "\x{FF93}",
	'molsquare' => "\x{33D6}",
	'momathai' => "\x{0E21}",
	'moverssquare' => "\x{33A7}",
	'moverssquaredsquare' => "\x{33A8}",
	'mparen' => "\x{24A8}",
	'mpasquare' => "\x{33AB}",
	'mssquare' => "\x{33B3}",
	'msuperior' => "\x{F6EF}",
	'mturned' => "\x{026F}",
	'mu1' => "\x{00B5}",
	'muasquare' => "\x{3382}",
	'muchgreater' => "\x{226B}",
	'muchless' => "\x{226A}",
	'mufsquare' => "\x{338C}",
	'mugreek' => "\x{03BC}",
	'mugsquare' => "\x{338D}",
	'muhiragana' => "\x{3080}",
	'mukatakana' => "\x{30E0}",
	'mukatakanahalfwidth' => "\x{FF91}",
	'mulsquare' => "\x{3395}",
	'mumsquare' => "\x{339B}",
	'munahhebrew' => "\x{05A3}",
	'munahlefthebrew' => "\x{05A3}",
	'musicflatsign' => "\x{266D}",
	'musicsharpsign' => "\x{266F}",
	'mussquare' => "\x{33B2}",
	'muvsquare' => "\x{33B6}",
	'muwsquare' => "\x{33BC}",
	'mvmegasquare' => "\x{33B9}",
	'mvsquare' => "\x{33B7}",
	'mwmegasquare' => "\x{33BF}",
	'mwsquare' => "\x{33BD}",
	'nabengali' => "\x{09A8}",
	'nabla' => "\x{2207}",
	'nadeva' => "\x{0928}",
	'nagujarati' => "\x{0AA8}",
	'nagurmukhi' => "\x{0A28}",
	'nahiragana' => "\x{306A}",
	'nakatakana' => "\x{30CA}",
	'nakatakanahalfwidth' => "\x{FF85}",
	'nasquare' => "\x{3381}",
	'nbopomofo' => "\x{310B}",
	'nbspace' => "\x{00A0}",
	'ncedilla' => "\x{0146}",
	'ncircle' => "\x{24DD}",
	'ncircumflexbelow' => "\x{1E4B}",
	'ndotaccent' => "\x{1E45}",
	'ndotbelow' => "\x{1E47}",
	'nehiragana' => "\x{306D}",
	'nekatakana' => "\x{30CD}",
	'nekatakanahalfwidth' => "\x{FF88}",
	'newsheqelsign' => "\x{20AA}",
	'nfsquare' => "\x{338B}",
	'ngabengali' => "\x{0999}",
	'ngadeva' => "\x{0919}",
	'ngagujarati' => "\x{0A99}",
	'ngagurmukhi' => "\x{0A19}",
	'ngonguthai' => "\x{0E07}",
	'nhiragana' => "\x{3093}",
	'nhookleft' => "\x{0272}",
	'nhookretroflex' => "\x{0273}",
	'nieunacirclekorean' => "\x{326F}",
	'nieunaparenkorean' => "\x{320F}",
	'nieuncieuckorean' => "\x{3135}",
	'nieuncirclekorean' => "\x{3261}",
	'nieunhieuhkorean' => "\x{3136}",
	'nieunkorean' => "\x{3134}",
	'nieunpansioskorean' => "\x{3168}",
	'nieunparenkorean' => "\x{3201}",
	'nieunsioskorean' => "\x{3167}",
	'nieuntikeutkorean' => "\x{3166}",
	'nihiragana' => "\x{306B}",
	'nikatakana' => "\x{30CB}",
	'nikatakanahalfwidth' => "\x{FF86}",
	'nikhahitleftthai' => "\x{F899}",
	'nikhahitthai' => "\x{0E4D}",
	'ninearabic' => "\x{0669}",
	'ninebengali' => "\x{09EF}",
	'ninecircle' => "\x{2468}",
	'ninecircleinversesansserif' => "\x{2792}",
	'ninedeva' => "\x{096F}",
	'ninegujarati' => "\x{0AEF}",
	'ninegurmukhi' => "\x{0A6F}",
	'ninehackarabic' => "\x{0669}",
	'ninehangzhou' => "\x{3029}",
	'nineideographicparen' => "\x{3228}",
	'nineinferior' => "\x{2089}",
	'ninemonospace' => "\x{FF19}",
	'nineoldstyle' => "\x{F739}",
	'nineparen' => "\x{247C}",
	'nineperiod' => "\x{2490}",
	'ninepersian' => "\x{06F9}",
	'nineroman' => "\x{2178}",
	'ninesuperior' => "\x{2079}",
	'nineteencircle' => "\x{2472}",
	'nineteenparen' => "\x{2486}",
	'nineteenperiod' => "\x{249A}",
	'ninethai' => "\x{0E59}",
	'nj' => "\x{01CC}",
	'njecyrillic' => "\x{045A}",
	'nkatakana' => "\x{30F3}",
	'nkatakanahalfwidth' => "\x{FF9D}",
	'nlegrightlong' => "\x{019E}",
	'nlinebelow' => "\x{1E49}",
	'nmonospace' => "\x{FF4E}",
	'nmsquare' => "\x{339A}",
	'nnabengali' => "\x{09A3}",
	'nnadeva' => "\x{0923}",
	'nnagujarati' => "\x{0AA3}",
	'nnagurmukhi' => "\x{0A23}",
	'nnnadeva' => "\x{0929}",
	'nohiragana' => "\x{306E}",
	'nokatakana' => "\x{30CE}",
	'nokatakanahalfwidth' => "\x{FF89}",
	'nonbreakingspace' => "\x{00A0}",
	'nonenthai' => "\x{0E13}",
	'nonuthai' => "\x{0E19}",
	'noonarabic' => "\x{0646}",
	'noonfinalarabic' => "\x{FEE6}",
	'noonghunnaarabic' => "\x{06BA}",
	'noonghunnafinalarabic' => "\x{FB9F}",
	'noonhehinitialarabic' => "\x{FEE7}\x{FEEC}",
	'nooninitialarabic' => "\x{FEE7}",
	'noonjeeminitialarabic' => "\x{FCD2}",
	'noonjeemisolatedarabic' => "\x{FC4B}",
	'noonmedialarabic' => "\x{FEE8}",
	'noonmeeminitialarabic' => "\x{FCD5}",
	'noonmeemisolatedarabic' => "\x{FC4E}",
	'noonnoonfinalarabic' => "\x{FC8D}",
	'notcontains' => "\x{220C}",
	'notelementof' => "\x{2209}",
	'notgreater' => "\x{226F}",
	'notgreaternorequal' => "\x{2271}",
	'notgreaternorless' => "\x{2279}",
	'notidentical' => "\x{2262}",
	'notless' => "\x{226E}",
	'notlessnorequal' => "\x{2270}",
	'notparallel' => "\x{2226}",
	'notprecedes' => "\x{2280}",
	'notsucceeds' => "\x{2281}",
	'notsuperset' => "\x{2285}",
	'nowarmenian' => "\x{0576}",
	'nparen' => "\x{24A9}",
	'nssquare' => "\x{33B1}",
	'nsuperior' => "\x{207F}",
	'nuhiragana' => "\x{306C}",
	'nukatakana' => "\x{30CC}",
	'nukatakanahalfwidth' => "\x{FF87}",
	'nuktabengali' => "\x{09BC}",
	'nuktadeva' => "\x{093C}",
	'nuktagujarati' => "\x{0ABC}",
	'nuktagurmukhi' => "\x{0A3C}",
	'numbersignmonospace' => "\x{FF03}",
	'numbersignsmall' => "\x{FE5F}",
	'numeralsigngreek' => "\x{0374}",
	'numeralsignlowergreek' => "\x{0375}",
	'numero' => "\x{2116}",
	'nun' => "\x{05E0}",
	'nundagesh' => "\x{FB40}",
	'nundageshhebrew' => "\x{FB40}",
	'nunhebrew' => "\x{05E0}",
	'nvsquare' => "\x{33B5}",
	'nwsquare' => "\x{33BB}",
	'nyabengali' => "\x{099E}",
	'nyadeva' => "\x{091E}",
	'nyagujarati' => "\x{0A9E}",
	'nyagurmukhi' => "\x{0A1E}",
	'oangthai' => "\x{0E2D}",
	'obarred' => "\x{0275}",
	'obarredcyrillic' => "\x{04E9}",
	'obarreddieresiscyrillic' => "\x{04EB}",
	'obengali' => "\x{0993}",
	'obopomofo' => "\x{311B}",
	'ocandradeva' => "\x{0911}",
	'ocandragujarati' => "\x{0A91}",
	'ocandravowelsigndeva' => "\x{0949}",
	'ocandravowelsigngujarati' => "\x{0AC9}",
	'ocaron' => "\x{01D2}",
	'ocircle' => "\x{24DE}",
	'ocircumflexacute' => "\x{1ED1}",
	'ocircumflexdotbelow' => "\x{1ED9}",
	'ocircumflexgrave' => "\x{1ED3}",
	'ocircumflexhookabove' => "\x{1ED5}",
	'ocircumflextilde' => "\x{1ED7}",
	'ocyrillic' => "\x{043E}",
	'odblacute' => "\x{0151}",
	'odblgrave' => "\x{020D}",
	'odeva' => "\x{0913}",
	'odieresiscyrillic' => "\x{04E7}",
	'odotbelow' => "\x{1ECD}",
	'oekorean' => "\x{315A}",
	'ogonekcmb' => "\x{0328}",
	'ogujarati' => "\x{0A93}",
	'oharmenian' => "\x{0585}",
	'ohiragana' => "\x{304A}",
	'ohookabove' => "\x{1ECF}",
	'ohornacute' => "\x{1EDB}",
	'ohorndotbelow' => "\x{1EE3}",
	'ohorngrave' => "\x{1EDD}",
	'ohornhookabove' => "\x{1EDF}",
	'ohorntilde' => "\x{1EE1}",
	'oi' => "\x{01A3}",
	'oinvertedbreve' => "\x{020F}",
	'okatakana' => "\x{30AA}",
	'okatakanahalfwidth' => "\x{FF75}",
	'okorean' => "\x{3157}",
	'olehebrew' => "\x{05AB}",
	'omacronacute' => "\x{1E53}",
	'omacrongrave' => "\x{1E51}",
	'omdeva' => "\x{0950}",
	'omegacyrillic' => "\x{0461}",
	'omegalatinclosed' => "\x{0277}",
	'omegaroundcyrillic' => "\x{047B}",
	'omegatitlocyrillic' => "\x{047D}",
	'omgujarati' => "\x{0AD0}",
	'omonospace' => "\x{FF4F}",
	'onearabic' => "\x{0661}",
	'onebengali' => "\x{09E7}",
	'onecircle' => "\x{2460}",
	'onecircleinversesansserif' => "\x{278A}",
	'onedeva' => "\x{0967}",
	'onefitted' => "\x{F6DC}",
	'onegujarati' => "\x{0AE7}",
	'onegurmukhi' => "\x{0A67}",
	'onehackarabic' => "\x{0661}",
	'onehangzhou' => "\x{3021}",
	'oneideographicparen' => "\x{3220}",
	'oneinferior' => "\x{2081}",
	'onemonospace' => "\x{FF11}",
	'onenumeratorbengali' => "\x{09F4}",
	'oneoldstyle' => "\x{F731}",
	'oneparen' => "\x{2474}",
	'oneperiod' => "\x{2488}",
	'onepersian' => "\x{06F1}",
	'oneroman' => "\x{2170}",
	'onethai' => "\x{0E51}",
	'oogonek' => "\x{01EB}",
	'oogonekmacron' => "\x{01ED}",
	'oogurmukhi' => "\x{0A13}",
	'oomatragurmukhi' => "\x{0A4B}",
	'oopen' => "\x{0254}",
	'oparen' => "\x{24AA}",
	'option' => "\x{2325}",
	'oshortdeva' => "\x{0912}",
	'oshortvowelsigndeva' => "\x{094A}",
	'osmallhiragana' => "\x{3049}",
	'osmallkatakana' => "\x{30A9}",
	'osmallkatakanahalfwidth' => "\x{FF6B}",
	'ostrokeacute' => "\x{01FF}",
	'osuperior' => "\x{F6F0}",
	'otcyrillic' => "\x{047F}",
	'otildeacute' => "\x{1E4D}",
	'otildedieresis' => "\x{1E4F}",
	'oubopomofo' => "\x{3121}",
	'overline' => "\x{203E}",
	'overlinecenterline' => "\x{FE4A}",
	'overlinecmb' => "\x{0305}",
	'overlinedashed' => "\x{FE49}",
	'overlinedblwavy' => "\x{FE4C}",
	'overlinewavy' => "\x{FE4B}",
	'overscore' => "\x{00AF}",
	'ovowelsignbengali' => "\x{09CB}",
	'ovowelsigndeva' => "\x{094B}",
	'ovowelsigngujarati' => "\x{0ACB}",
	'paampssquare' => "\x{3380}",
	'paasentosquare' => "\x{332B}",
	'pabengali' => "\x{09AA}",
	'pacute' => "\x{1E55}",
	'padeva' => "\x{092A}",
	'pagedown' => "\x{21DF}",
	'pageup' => "\x{21DE}",
	'pagujarati' => "\x{0AAA}",
	'pagurmukhi' => "\x{0A2A}",
	'pahiragana' => "\x{3071}",
	'paiyannoithai' => "\x{0E2F}",
	'pakatakana' => "\x{30D1}",
	'palatalizationcyrilliccmb' => "\x{0484}",
	'palochkacyrillic' => "\x{04C0}",
	'pansioskorean' => "\x{317F}",
	'parallel' => "\x{2225}",
	'parenleftaltonearabic' => "\x{FD3E}",
	'parenleftbt' => "\x{F8ED}",
	'parenleftex' => "\x{F8EC}",
	'parenleftinferior' => "\x{208D}",
	'parenleftmonospace' => "\x{FF08}",
	'parenleftsmall' => "\x{FE59}",
	'parenleftsuperior' => "\x{207D}",
	'parenlefttp' => "\x{F8EB}",
	'parenleftvertical' => "\x{FE35}",
	'parenrightaltonearabic' => "\x{FD3F}",
	'parenrightbt' => "\x{F8F8}",
	'parenrightex' => "\x{F8F7}",
	'parenrightinferior' => "\x{208E}",
	'parenrightmonospace' => "\x{FF09}",
	'parenrightsmall' => "\x{FE5A}",
	'parenrightsuperior' => "\x{207E}",
	'parenrighttp' => "\x{F8F6}",
	'parenrightvertical' => "\x{FE36}",
	'paseqhebrew' => "\x{05C0}",
	'pashtahebrew' => "\x{0599}",
	'pasquare' => "\x{33A9}",
	'patah' => "\x{05B7}",
	'patah11' => "\x{05B7}",
	'patah1d' => "\x{05B7}",
	'patah2a' => "\x{05B7}",
	'patahhebrew' => "\x{05B7}",
	'patahnarrowhebrew' => "\x{05B7}",
	'patahquarterhebrew' => "\x{05B7}",
	'patahwidehebrew' => "\x{05B7}",
	'pazerhebrew' => "\x{05A1}",
	'pbopomofo' => "\x{3106}",
	'pcircle' => "\x{24DF}",
	'pdotaccent' => "\x{1E57}",
	'pe' => "\x{05E4}",
	'pecyrillic' => "\x{043F}",
	'pedagesh' => "\x{FB44}",
	'pedageshhebrew' => "\x{FB44}",
	'peezisquare' => "\x{333B}",
	'pefinaldageshhebrew' => "\x{FB43}",
	'peharabic' => "\x{067E}",
	'peharmenian' => "\x{057A}",
	'pehebrew' => "\x{05E4}",
	'pehfinalarabic' => "\x{FB57}",
	'pehinitialarabic' => "\x{FB58}",
	'pehiragana' => "\x{307A}",
	'pehmedialarabic' => "\x{FB59}",
	'pekatakana' => "\x{30DA}",
	'pemiddlehookcyrillic' => "\x{04A7}",
	'perafehebrew' => "\x{FB4E}",
	'percentarabic' => "\x{066A}",
	'percentmonospace' => "\x{FF05}",
	'percentsmall' => "\x{FE6A}",
	'periodarmenian' => "\x{0589}",
	'periodhalfwidth' => "\x{FF61}",
	'periodinferior' => "\x{F6E7}",
	'periodmonospace' => "\x{FF0E}",
	'periodsmall' => "\x{FE52}",
	'periodsuperior' => "\x{F6E8}",
	'perispomenigreekcmb' => "\x{0342}",
	'pfsquare' => "\x{338A}",
	'phabengali' => "\x{09AB}",
	'phadeva' => "\x{092B}",
	'phagujarati' => "\x{0AAB}",
	'phagurmukhi' => "\x{0A2B}",
	'phieuphacirclekorean' => "\x{327A}",
	'phieuphaparenkorean' => "\x{321A}",
	'phieuphcirclekorean' => "\x{326C}",
	'phieuphkorean' => "\x{314D}",
	'phieuphparenkorean' => "\x{320C}",
	'philatin' => "\x{0278}",
	'phinthuthai' => "\x{0E3A}",
	'phisymbolgreek' => "\x{03D5}",
	'phook' => "\x{01A5}",
	'phophanthai' => "\x{0E1E}",
	'phophungthai' => "\x{0E1C}",
	'phosamphaothai' => "\x{0E20}",
	'pieupacirclekorean' => "\x{3273}",
	'pieupaparenkorean' => "\x{3213}",
	'pieupcieuckorean' => "\x{3176}",
	'pieupcirclekorean' => "\x{3265}",
	'pieupkiyeokkorean' => "\x{3172}",
	'pieupkorean' => "\x{3142}",
	'pieupparenkorean' => "\x{3205}",
	'pieupsioskiyeokkorean' => "\x{3174}",
	'pieupsioskorean' => "\x{3144}",
	'pieupsiostikeutkorean' => "\x{3175}",
	'pieupthieuthkorean' => "\x{3177}",
	'pieuptikeutkorean' => "\x{3173}",
	'pihiragana' => "\x{3074}",
	'pikatakana' => "\x{30D4}",
	'pisymbolgreek' => "\x{03D6}",
	'piwrarmenian' => "\x{0583}",
	'plusbelowcmb' => "\x{031F}",
	'pluscircle' => "\x{2295}",
	'plusmod' => "\x{02D6}",
	'plusmonospace' => "\x{FF0B}",
	'plussmall' => "\x{FE62}",
	'plussuperior' => "\x{207A}",
	'pmonospace' => "\x{FF50}",
	'pmsquare' => "\x{33D8}",
	'pohiragana' => "\x{307D}",
	'pointingindexdownwhite' => "\x{261F}",
	'pointingindexleftwhite' => "\x{261C}",
	'pointingindexrightwhite' => "\x{261E}",
	'pointingindexupwhite' => "\x{261D}",
	'pokatakana' => "\x{30DD}",
	'poplathai' => "\x{0E1B}",
	'postalmark' => "\x{3012}",
	'postalmarkface' => "\x{3020}",
	'pparen' => "\x{24AB}",
	'precedes' => "\x{227A}",
	'primemod' => "\x{02B9}",
	'primereversed' => "\x{2035}",
	'projective' => "\x{2305}",
	'prolongedkana' => "\x{30FC}",
	'propellor' => "\x{2318}",
	'proportion' => "\x{2237}",
	'psicyrillic' => "\x{0471}",
	'psilipneumatacyrilliccmb' => "\x{0486}",
	'pssquare' => "\x{33B0}",
	'puhiragana' => "\x{3077}",
	'pukatakana' => "\x{30D7}",
	'pvsquare' => "\x{33B4}",
	'pwsquare' => "\x{33BA}",
	'qadeva' => "\x{0958}",
	'qadmahebrew' => "\x{05A8}",
	'qafarabic' => "\x{0642}",
	'qaffinalarabic' => "\x{FED6}",
	'qafinitialarabic' => "\x{FED7}",
	'qafmedialarabic' => "\x{FED8}",
	'qamats' => "\x{05B8}",
	'qamats10' => "\x{05B8}",
	'qamats1a' => "\x{05B8}",
	'qamats1c' => "\x{05B8}",
	'qamats27' => "\x{05B8}",
	'qamats29' => "\x{05B8}",
	'qamats33' => "\x{05B8}",
	'qamatsde' => "\x{05B8}",
	'qamatshebrew' => "\x{05B8}",
	'qamatsnarrowhebrew' => "\x{05B8}",
	'qamatsqatanhebrew' => "\x{05B8}",
	'qamatsqatannarrowhebrew' => "\x{05B8}",
	'qamatsqatanquarterhebrew' => "\x{05B8}",
	'qamatsqatanwidehebrew' => "\x{05B8}",
	'qamatsquarterhebrew' => "\x{05B8}",
	'qamatswidehebrew' => "\x{05B8}",
	'qarneyparahebrew' => "\x{059F}",
	'qbopomofo' => "\x{3111}",
	'qcircle' => "\x{24E0}",
	'qhook' => "\x{02A0}",
	'qmonospace' => "\x{FF51}",
	'qof' => "\x{05E7}",
	'qofdagesh' => "\x{FB47}",
	'qofdageshhebrew' => "\x{FB47}",
	'qofhatafpatah' => "\x{05E7}\x{05B2}",
	'qofhatafpatahhebrew' => "\x{05E7}\x{05B2}",
	'qofhatafsegol' => "\x{05E7}\x{05B1}",
	'qofhatafsegolhebrew' => "\x{05E7}\x{05B1}",
	'qofhebrew' => "\x{05E7}",
	'qofhiriq' => "\x{05E7}\x{05B4}",
	'qofhiriqhebrew' => "\x{05E7}\x{05B4}",
	'qofholam' => "\x{05E7}\x{05B9}",
	'qofholamhebrew' => "\x{05E7}\x{05B9}",
	'qofpatah' => "\x{05E7}\x{05B7}",
	'qofpatahhebrew' => "\x{05E7}\x{05B7}",
	'qofqamats' => "\x{05E7}\x{05B8}",
	'qofqamatshebrew' => "\x{05E7}\x{05B8}",
	'qofqubuts' => "\x{05E7}\x{05BB}",
	'qofqubutshebrew' => "\x{05E7}\x{05BB}",
	'qofsegol' => "\x{05E7}\x{05B6}",
	'qofsegolhebrew' => "\x{05E7}\x{05B6}",
	'qofsheva' => "\x{05E7}\x{05B0}",
	'qofshevahebrew' => "\x{05E7}\x{05B0}",
	'qoftsere' => "\x{05E7}\x{05B5}",
	'qoftserehebrew' => "\x{05E7}\x{05B5}",
	'qparen' => "\x{24AC}",
	'quarternote' => "\x{2669}",
	'qubuts' => "\x{05BB}",
	'qubuts18' => "\x{05BB}",
	'qubuts25' => "\x{05BB}",
	'qubuts31' => "\x{05BB}",
	'qubutshebrew' => "\x{05BB}",
	'qubutsnarrowhebrew' => "\x{05BB}",
	'qubutsquarterhebrew' => "\x{05BB}",
	'qubutswidehebrew' => "\x{05BB}",
	'questionarabic' => "\x{061F}",
	'questionarmenian' => "\x{055E}",
	'questiondownsmall' => "\x{F7BF}",
	'questiongreek' => "\x{037E}",
	'questionmonospace' => "\x{FF1F}",
	'questionsmall' => "\x{F73F}",
	'quotedblmonospace' => "\x{FF02}",
	'quotedblprime' => "\x{301E}",
	'quotedblprimereversed' => "\x{301D}",
	'quoteleftreversed' => "\x{201B}",
	'quoterightn' => "\x{0149}",
	'quotesinglemonospace' => "\x{FF07}",
	'raarmenian' => "\x{057C}",
	'rabengali' => "\x{09B0}",
	'radeva' => "\x{0930}",
	'radicalex' => "\x{F8E5}",
	'radoverssquare' => "\x{33AE}",
	'radoverssquaredsquare' => "\x{33AF}",
	'radsquare' => "\x{33AD}",
	'rafe' => "\x{05BF}",
	'rafehebrew' => "\x{05BF}",
	'ragujarati' => "\x{0AB0}",
	'ragurmukhi' => "\x{0A30}",
	'rahiragana' => "\x{3089}",
	'rakatakana' => "\x{30E9}",
	'rakatakanahalfwidth' => "\x{FF97}",
	'ralowerdiagonalbengali' => "\x{09F1}",
	'ramiddlediagonalbengali' => "\x{09F0}",
	'ramshorn' => "\x{0264}",
	'ratio' => "\x{2236}",
	'rbopomofo' => "\x{3116}",
	'rcedilla' => "\x{0157}",
	'rcircle' => "\x{24E1}",
	'rdblgrave' => "\x{0211}",
	'rdotaccent' => "\x{1E59}",
	'rdotbelow' => "\x{1E5B}",
	'rdotbelowmacron' => "\x{1E5D}",
	'referencemark' => "\x{203B}",
	'registersans' => "\x{F8E8}",
	'registerserif' => "\x{F6DA}",
	'reharabic' => "\x{0631}",
	'reharmenian' => "\x{0580}",
	'rehfinalarabic' => "\x{FEAE}",
	'rehiragana' => "\x{308C}",
	'rehyehaleflamarabic' => "\x{0631}\x{FEF3}\x{FE8E}\x{0644}",
	'rekatakana' => "\x{30EC}",
	'rekatakanahalfwidth' => "\x{FF9A}",
	'resh' => "\x{05E8}",
	'reshdageshhebrew' => "\x{FB48}",
	'reshhatafpatah' => "\x{05E8}\x{05B2}",
	'reshhatafpatahhebrew' => "\x{05E8}\x{05B2}",
	'reshhatafsegol' => "\x{05E8}\x{05B1}",
	'reshhatafsegolhebrew' => "\x{05E8}\x{05B1}",
	'reshhebrew' => "\x{05E8}",
	'reshhiriq' => "\x{05E8}\x{05B4}",
	'reshhiriqhebrew' => "\x{05E8}\x{05B4}",
	'reshholam' => "\x{05E8}\x{05B9}",
	'reshholamhebrew' => "\x{05E8}\x{05B9}",
	'reshpatah' => "\x{05E8}\x{05B7}",
	'reshpatahhebrew' => "\x{05E8}\x{05B7}",
	'reshqamats' => "\x{05E8}\x{05B8}",
	'reshqamatshebrew' => "\x{05E8}\x{05B8}",
	'reshqubuts' => "\x{05E8}\x{05BB}",
	'reshqubutshebrew' => "\x{05E8}\x{05BB}",
	'reshsegol' => "\x{05E8}\x{05B6}",
	'reshsegolhebrew' => "\x{05E8}\x{05B6}",
	'reshsheva' => "\x{05E8}\x{05B0}",
	'reshshevahebrew' => "\x{05E8}\x{05B0}",
	'reshtsere' => "\x{05E8}\x{05B5}",
	'reshtserehebrew' => "\x{05E8}\x{05B5}",
	'reversedtilde' => "\x{223D}",
	'reviahebrew' => "\x{0597}",
	'reviamugrashhebrew' => "\x{0597}",
	'rfishhook' => "\x{027E}",
	'rfishhookreversed' => "\x{027F}",
	'rhabengali' => "\x{09DD}",
	'rhadeva' => "\x{095D}",
	'rhook' => "\x{027D}",
	'rhookturned' => "\x{027B}",
	'rhookturnedsuperior' => "\x{02B5}",
	'rhosymbolgreek' => "\x{03F1}",
	'rhotichookmod' => "\x{02DE}",
	'rieulacirclekorean' => "\x{3271}",
	'rieulaparenkorean' => "\x{3211}",
	'rieulcirclekorean' => "\x{3263}",
	'rieulhieuhkorean' => "\x{3140}",
	'rieulkiyeokkorean' => "\x{313A}",
	'rieulkiyeoksioskorean' => "\x{3169}",
	'rieulkorean' => "\x{3139}",
	'rieulmieumkorean' => "\x{313B}",
	'rieulpansioskorean' => "\x{316C}",
	'rieulparenkorean' => "\x{3203}",
	'rieulphieuphkorean' => "\x{313F}",
	'rieulpieupkorean' => "\x{313C}",
	'rieulpieupsioskorean' => "\x{316B}",
	'rieulsioskorean' => "\x{313D}",
	'rieulthieuthkorean' => "\x{313E}",
	'rieultikeutkorean' => "\x{316A}",
	'rieulyeorinhieuhkorean' => "\x{316D}",
	'rightangle' => "\x{221F}",
	'righttackbelowcmb' => "\x{0319}",
	'righttriangle' => "\x{22BF}",
	'rihiragana' => "\x{308A}",
	'rikatakana' => "\x{30EA}",
	'rikatakanahalfwidth' => "\x{FF98}",
	'ringbelowcmb' => "\x{0325}",
	'ringcmb' => "\x{030A}",
	'ringhalfleft' => "\x{02BF}",
	'ringhalfleftarmenian' => "\x{0559}",
	'ringhalfleftbelowcmb' => "\x{031C}",
	'ringhalfleftcentered' => "\x{02D3}",
	'ringhalfright' => "\x{02BE}",
	'ringhalfrightbelowcmb' => "\x{0339}",
	'ringhalfrightcentered' => "\x{02D2}",
	'rinvertedbreve' => "\x{0213}",
	'rittorusquare' => "\x{3351}",
	'rlinebelow' => "\x{1E5F}",
	'rlongleg' => "\x{027C}",
	'rlonglegturned' => "\x{027A}",
	'rmonospace' => "\x{FF52}",
	'rohiragana' => "\x{308D}",
	'rokatakana' => "\x{30ED}",
	'rokatakanahalfwidth' => "\x{FF9B}",
	'roruathai' => "\x{0E23}",
	'rparen' => "\x{24AD}",
	'rrabengali' => "\x{09DC}",
	'rradeva' => "\x{0931}",
	'rragurmukhi' => "\x{0A5C}",
	'rreharabic' => "\x{0691}",
	'rrehfinalarabic' => "\x{FB8D}",
	'rrvocalicbengali' => "\x{09E0}",
	'rrvocalicdeva' => "\x{0960}",
	'rrvocalicgujarati' => "\x{0AE0}",
	'rrvocalicvowelsignbengali' => "\x{09C4}",
	'rrvocalicvowelsigndeva' => "\x{0944}",
	'rrvocalicvowelsigngujarati' => "\x{0AC4}",
	'rsuperior' => "\x{F6F1}",
	'rturned' => "\x{0279}",
	'rturnedsuperior' => "\x{02B4}",
	'ruhiragana' => "\x{308B}",
	'rukatakana' => "\x{30EB}",
	'rukatakanahalfwidth' => "\x{FF99}",
	'rupeemarkbengali' => "\x{09F2}",
	'rupeesignbengali' => "\x{09F3}",
	'rupiah' => "\x{F6DD}",
	'ruthai' => "\x{0E24}",
	'rvocalicbengali' => "\x{098B}",
	'rvocalicdeva' => "\x{090B}",
	'rvocalicgujarati' => "\x{0A8B}",
	'rvocalicvowelsignbengali' => "\x{09C3}",
	'rvocalicvowelsigndeva' => "\x{0943}",
	'rvocalicvowelsigngujarati' => "\x{0AC3}",
	'sabengali' => "\x{09B8}",
	'sacutedotaccent' => "\x{1E65}",
	'sadarabic' => "\x{0635}",
	'sadeva' => "\x{0938}",
	'sadfinalarabic' => "\x{FEBA}",
	'sadinitialarabic' => "\x{FEBB}",
	'sadmedialarabic' => "\x{FEBC}",
	'sagujarati' => "\x{0AB8}",
	'sagurmukhi' => "\x{0A38}",
	'sahiragana' => "\x{3055}",
	'sakatakana' => "\x{30B5}",
	'sakatakanahalfwidth' => "\x{FF7B}",
	'sallallahoualayhewasallamarabic' => "\x{FDFA}",
	'samekh' => "\x{05E1}",
	'samekhdagesh' => "\x{FB41}",
	'samekhdageshhebrew' => "\x{FB41}",
	'samekhhebrew' => "\x{05E1}",
	'saraaathai' => "\x{0E32}",
	'saraaethai' => "\x{0E41}",
	'saraaimaimalaithai' => "\x{0E44}",
	'saraaimaimuanthai' => "\x{0E43}",
	'saraamthai' => "\x{0E33}",
	'saraathai' => "\x{0E30}",
	'saraethai' => "\x{0E40}",
	'saraiileftthai' => "\x{F886}",
	'saraiithai' => "\x{0E35}",
	'saraileftthai' => "\x{F885}",
	'saraithai' => "\x{0E34}",
	'saraothai' => "\x{0E42}",
	'saraueeleftthai' => "\x{F888}",
	'saraueethai' => "\x{0E37}",
	'saraueleftthai' => "\x{F887}",
	'sarauethai' => "\x{0E36}",
	'sarauthai' => "\x{0E38}",
	'sarauuthai' => "\x{0E39}",
	'sbopomofo' => "\x{3119}",
	'scarondotaccent' => "\x{1E67}",
	'schwa' => "\x{0259}",
	'schwacyrillic' => "\x{04D9}",
	'schwadieresiscyrillic' => "\x{04DB}",
	'schwahook' => "\x{025A}",
	'scircle' => "\x{24E2}",
	'sdotaccent' => "\x{1E61}",
	'sdotbelow' => "\x{1E63}",
	'sdotbelowdotaccent' => "\x{1E69}",
	'seagullbelowcmb' => "\x{033C}",
	'secondtonechinese' => "\x{02CA}",
	'seenarabic' => "\x{0633}",
	'seenfinalarabic' => "\x{FEB2}",
	'seeninitialarabic' => "\x{FEB3}",
	'seenmedialarabic' => "\x{FEB4}",
	'segol' => "\x{05B6}",
	'segol13' => "\x{05B6}",
	'segol1f' => "\x{05B6}",
	'segol2c' => "\x{05B6}",
	'segolhebrew' => "\x{05B6}",
	'segolnarrowhebrew' => "\x{05B6}",
	'segolquarterhebrew' => "\x{05B6}",
	'segoltahebrew' => "\x{0592}",
	'segolwidehebrew' => "\x{05B6}",
	'seharmenian' => "\x{057D}",
	'sehiragana' => "\x{305B}",
	'sekatakana' => "\x{30BB}",
	'sekatakanahalfwidth' => "\x{FF7E}",
	'semicolonarabic' => "\x{061B}",
	'semicolonmonospace' => "\x{FF1B}",
	'semicolonsmall' => "\x{FE54}",
	'semivoicedmarkkana' => "\x{309C}",
	'semivoicedmarkkanahalfwidth' => "\x{FF9F}",
	'sentisquare' => "\x{3322}",
	'sentosquare' => "\x{3323}",
	'sevenarabic' => "\x{0667}",
	'sevenbengali' => "\x{09ED}",
	'sevencircle' => "\x{2466}",
	'sevencircleinversesansserif' => "\x{2790}",
	'sevendeva' => "\x{096D}",
	'sevengujarati' => "\x{0AED}",
	'sevengurmukhi' => "\x{0A6D}",
	'sevenhackarabic' => "\x{0667}",
	'sevenhangzhou' => "\x{3027}",
	'sevenideographicparen' => "\x{3226}",
	'seveninferior' => "\x{2087}",
	'sevenmonospace' => "\x{FF17}",
	'sevenoldstyle' => "\x{F737}",
	'sevenparen' => "\x{247A}",
	'sevenperiod' => "\x{248E}",
	'sevenpersian' => "\x{06F7}",
	'sevenroman' => "\x{2176}",
	'sevensuperior' => "\x{2077}",
	'seventeencircle' => "\x{2470}",
	'seventeenparen' => "\x{2484}",
	'seventeenperiod' => "\x{2498}",
	'seventhai' => "\x{0E57}",
	'sfthyphen' => "\x{00AD}",
	'shaarmenian' => "\x{0577}",
	'shabengali' => "\x{09B6}",
	'shacyrillic' => "\x{0448}",
	'shaddaarabic' => "\x{0651}",
	'shaddadammaarabic' => "\x{FC61}",
	'shaddadammatanarabic' => "\x{FC5E}",
	'shaddafathaarabic' => "\x{FC60}",
	'shaddafathatanarabic' => "\x{0651}\x{064B}",
	'shaddakasraarabic' => "\x{FC62}",
	'shaddakasratanarabic' => "\x{FC5F}",
	'shadedark' => "\x{2593}",
	'shadelight' => "\x{2591}",
	'shademedium' => "\x{2592}",
	'shadeva' => "\x{0936}",
	'shagujarati' => "\x{0AB6}",
	'shagurmukhi' => "\x{0A36}",
	'shalshelethebrew' => "\x{0593}",
	'shbopomofo' => "\x{3115}",
	'shchacyrillic' => "\x{0449}",
	'sheenarabic' => "\x{0634}",
	'sheenfinalarabic' => "\x{FEB6}",
	'sheeninitialarabic' => "\x{FEB7}",
	'sheenmedialarabic' => "\x{FEB8}",
	'sheicoptic' => "\x{03E3}",
	'sheqel' => "\x{20AA}",
	'sheqelhebrew' => "\x{20AA}",
	'sheva' => "\x{05B0}",
	'sheva115' => "\x{05B0}",
	'sheva15' => "\x{05B0}",
	'sheva22' => "\x{05B0}",
	'sheva2e' => "\x{05B0}",
	'shevahebrew' => "\x{05B0}",
	'shevanarrowhebrew' => "\x{05B0}",
	'shevaquarterhebrew' => "\x{05B0}",
	'shevawidehebrew' => "\x{05B0}",
	'shhacyrillic' => "\x{04BB}",
	'shimacoptic' => "\x{03ED}",
	'shin' => "\x{05E9}",
	'shindagesh' => "\x{FB49}",
	'shindageshhebrew' => "\x{FB49}",
	'shindageshshindot' => "\x{FB2C}",
	'shindageshshindothebrew' => "\x{FB2C}",
	'shindageshsindot' => "\x{FB2D}",
	'shindageshsindothebrew' => "\x{FB2D}",
	'shindothebrew' => "\x{05C1}",
	'shinhebrew' => "\x{05E9}",
	'shinshindot' => "\x{FB2A}",
	'shinshindothebrew' => "\x{FB2A}",
	'shinsindot' => "\x{FB2B}",
	'shinsindothebrew' => "\x{FB2B}",
	'shook' => "\x{0282}",
	'sigmafinal' => "\x{03C2}",
	'sigmalunatesymbolgreek' => "\x{03F2}",
	'sihiragana' => "\x{3057}",
	'sikatakana' => "\x{30B7}",
	'sikatakanahalfwidth' => "\x{FF7C}",
	'siluqhebrew' => "\x{05BD}",
	'siluqlefthebrew' => "\x{05BD}",
	'sindothebrew' => "\x{05C2}",
	'siosacirclekorean' => "\x{3274}",
	'siosaparenkorean' => "\x{3214}",
	'sioscieuckorean' => "\x{317E}",
	'sioscirclekorean' => "\x{3266}",
	'sioskiyeokkorean' => "\x{317A}",
	'sioskorean' => "\x{3145}",
	'siosnieunkorean' => "\x{317B}",
	'siosparenkorean' => "\x{3206}",
	'siospieupkorean' => "\x{317D}",
	'siostikeutkorean' => "\x{317C}",
	'sixarabic' => "\x{0666}",
	'sixbengali' => "\x{09EC}",
	'sixcircle' => "\x{2465}",
	'sixcircleinversesansserif' => "\x{278F}",
	'sixdeva' => "\x{096C}",
	'sixgujarati' => "\x{0AEC}",
	'sixgurmukhi' => "\x{0A6C}",
	'sixhackarabic' => "\x{0666}",
	'sixhangzhou' => "\x{3026}",
	'sixideographicparen' => "\x{3225}",
	'sixinferior' => "\x{2086}",
	'sixmonospace' => "\x{FF16}",
	'sixoldstyle' => "\x{F736}",
	'sixparen' => "\x{2479}",
	'sixperiod' => "\x{248D}",
	'sixpersian' => "\x{06F6}",
	'sixroman' => "\x{2175}",
	'sixsuperior' => "\x{2076}",
	'sixteencircle' => "\x{246F}",
	'sixteencurrencydenominatorbengali' => "\x{09F9}",
	'sixteenparen' => "\x{2483}",
	'sixteenperiod' => "\x{2497}",
	'sixthai' => "\x{0E56}",
	'slashmonospace' => "\x{FF0F}",
	'slong' => "\x{017F}",
	'slongdotaccent' => "\x{1E9B}",
	'smonospace' => "\x{FF53}",
	'sofpasuqhebrew' => "\x{05C3}",
	'softhyphen' => "\x{00AD}",
	'softsigncyrillic' => "\x{044C}",
	'sohiragana' => "\x{305D}",
	'sokatakana' => "\x{30BD}",
	'sokatakanahalfwidth' => "\x{FF7F}",
	'soliduslongoverlaycmb' => "\x{0338}",
	'solidusshortoverlaycmb' => "\x{0337}",
	'sorusithai' => "\x{0E29}",
	'sosalathai' => "\x{0E28}",
	'sosothai' => "\x{0E0B}",
	'sosuathai' => "\x{0E2A}",
	'spacehackarabic' => "\x{0020}",
	'spadesuitblack' => "\x{2660}",
	'spadesuitwhite' => "\x{2664}",
	'sparen' => "\x{24AE}",
	'squarebelowcmb' => "\x{033B}",
	'squarecc' => "\x{33C4}",
	'squarecm' => "\x{339D}",
	'squarediagonalcrosshatchfill' => "\x{25A9}",
	'squarehorizontalfill' => "\x{25A4}",
	'squarekg' => "\x{338F}",
	'squarekm' => "\x{339E}",
	'squarekmcapital' => "\x{33CE}",
	'squareln' => "\x{33D1}",
	'squarelog' => "\x{33D2}",
	'squaremg' => "\x{338E}",
	'squaremil' => "\x{33D5}",
	'squaremm' => "\x{339C}",
	'squaremsquared' => "\x{33A1}",
	'squareorthogonalcrosshatchfill' => "\x{25A6}",
	'squareupperlefttolowerrightfill' => "\x{25A7}",
	'squareupperrighttolowerleftfill' => "\x{25A8}",
	'squareverticalfill' => "\x{25A5}",
	'squarewhitewithsmallblack' => "\x{25A3}",
	'srsquare' => "\x{33DB}",
	'ssabengali' => "\x{09B7}",
	'ssadeva' => "\x{0937}",
	'ssagujarati' => "\x{0AB7}",
	'ssangcieuckorean' => "\x{3149}",
	'ssanghieuhkorean' => "\x{3185}",
	'ssangieungkorean' => "\x{3180}",
	'ssangkiyeokkorean' => "\x{3132}",
	'ssangnieunkorean' => "\x{3165}",
	'ssangpieupkorean' => "\x{3143}",
	'ssangsioskorean' => "\x{3146}",
	'ssangtikeutkorean' => "\x{3138}",
	'ssuperior' => "\x{F6F2}",
	'sterlingmonospace' => "\x{FFE1}",
	'strokelongoverlaycmb' => "\x{0336}",
	'strokeshortoverlaycmb' => "\x{0335}",
	'subset' => "\x{2282}",
	'subsetnotequal' => "\x{228A}",
	'subsetorequal' => "\x{2286}",
	'succeeds' => "\x{227B}",
	'suhiragana' => "\x{3059}",
	'sukatakana' => "\x{30B9}",
	'sukatakanahalfwidth' => "\x{FF7D}",
	'sukunarabic' => "\x{0652}",
	'superset' => "\x{2283}",
	'supersetnotequal' => "\x{228B}",
	'supersetorequal' => "\x{2287}",
	'svsquare' => "\x{33DC}",
	'syouwaerasquare' => "\x{337C}",
	'tabengali' => "\x{09A4}",
	'tackdown' => "\x{22A4}",
	'tackleft' => "\x{22A3}",
	'tadeva' => "\x{0924}",
	'tagujarati' => "\x{0AA4}",
	'tagurmukhi' => "\x{0A24}",
	'taharabic' => "\x{0637}",
	'tahfinalarabic' => "\x{FEC2}",
	'tahinitialarabic' => "\x{FEC3}",
	'tahiragana' => "\x{305F}",
	'tahmedialarabic' => "\x{FEC4}",
	'taisyouerasquare' => "\x{337D}",
	'takatakana' => "\x{30BF}",
	'takatakanahalfwidth' => "\x{FF80}",
	'tatweelarabic' => "\x{0640}",
	'tav' => "\x{05EA}",
	'tavdages' => "\x{FB4A}",
	'tavdagesh' => "\x{FB4A}",
	'tavdageshhebrew' => "\x{FB4A}",
	'tavhebrew' => "\x{05EA}",
	'tbopomofo' => "\x{310A}",
	'tccurl' => "\x{02A8}",
	'tcedilla' => "\x{0163}",
	'tcheharabic' => "\x{0686}",
	'tchehfinalarabic' => "\x{FB7B}",
	'tchehinitialarabic' => "\x{FB7C}",
	'tchehmedialarabic' => "\x{FB7D}",
	'tchehmeeminitialarabic' => "\x{FB7C}\x{FEE4}",
	'tcircle' => "\x{24E3}",
	'tcircumflexbelow' => "\x{1E71}",
	'tdieresis' => "\x{1E97}",
	'tdotaccent' => "\x{1E6B}",
	'tdotbelow' => "\x{1E6D}",
	'tecyrillic' => "\x{0442}",
	'tedescendercyrillic' => "\x{04AD}",
	'teharabic' => "\x{062A}",
	'tehfinalarabic' => "\x{FE96}",
	'tehhahinitialarabic' => "\x{FCA2}",
	'tehhahisolatedarabic' => "\x{FC0C}",
	'tehinitialarabic' => "\x{FE97}",
	'tehiragana' => "\x{3066}",
	'tehjeeminitialarabic' => "\x{FCA1}",
	'tehjeemisolatedarabic' => "\x{FC0B}",
	'tehmarbutaarabic' => "\x{0629}",
	'tehmarbutafinalarabic' => "\x{FE94}",
	'tehmedialarabic' => "\x{FE98}",
	'tehmeeminitialarabic' => "\x{FCA4}",
	'tehmeemisolatedarabic' => "\x{FC0E}",
	'tehnoonfinalarabic' => "\x{FC73}",
	'tekatakana' => "\x{30C6}",
	'tekatakanahalfwidth' => "\x{FF83}",
	'telephone' => "\x{2121}",
	'telephoneblack' => "\x{260E}",
	'telishagedolahebrew' => "\x{05A0}",
	'telishaqetanahebrew' => "\x{05A9}",
	'tencircle' => "\x{2469}",
	'tenideographicparen' => "\x{3229}",
	'tenparen' => "\x{247D}",
	'tenperiod' => "\x{2491}",
	'tenroman' => "\x{2179}",
	'tesh' => "\x{02A7}",
	'tet' => "\x{05D8}",
	'tetdagesh' => "\x{FB38}",
	'tetdageshhebrew' => "\x{FB38}",
	'tethebrew' => "\x{05D8}",
	'tetsecyrillic' => "\x{04B5}",
	'tevirhebrew' => "\x{059B}",
	'tevirlefthebrew' => "\x{059B}",
	'thabengali' => "\x{09A5}",
	'thadeva' => "\x{0925}",
	'thagujarati' => "\x{0AA5}",
	'thagurmukhi' => "\x{0A25}",
	'thalarabic' => "\x{0630}",
	'thalfinalarabic' => "\x{FEAC}",
	'thanthakhatlowleftthai' => "\x{F898}",
	'thanthakhatlowrightthai' => "\x{F897}",
	'thanthakhatthai' => "\x{0E4C}",
	'thanthakhatupperleftthai' => "\x{F896}",
	'theharabic' => "\x{062B}",
	'thehfinalarabic' => "\x{FE9A}",
	'thehinitialarabic' => "\x{FE9B}",
	'thehmedialarabic' => "\x{FE9C}",
	'thereexists' => "\x{2203}",
	'thetasymbolgreek' => "\x{03D1}",
	'thieuthacirclekorean' => "\x{3279}",
	'thieuthaparenkorean' => "\x{3219}",
	'thieuthcirclekorean' => "\x{326B}",
	'thieuthkorean' => "\x{314C}",
	'thieuthparenkorean' => "\x{320B}",
	'thirteencircle' => "\x{246C}",
	'thirteenparen' => "\x{2480}",
	'thirteenperiod' => "\x{2494}",
	'thonangmonthothai' => "\x{0E11}",
	'thook' => "\x{01AD}",
	'thophuthaothai' => "\x{0E12}",
	'thothahanthai' => "\x{0E17}",
	'thothanthai' => "\x{0E10}",
	'thothongthai' => "\x{0E18}",
	'thothungthai' => "\x{0E16}",
	'thousandcyrillic' => "\x{0482}",
	'thousandsseparatorarabic' => "\x{066C}",
	'thousandsseparatorpersian' => "\x{066C}",
	'threearabic' => "\x{0663}",
	'threebengali' => "\x{09E9}",
	'threecircle' => "\x{2462}",
	'threecircleinversesansserif' => "\x{278C}",
	'threedeva' => "\x{0969}",
	'threegujarati' => "\x{0AE9}",
	'threegurmukhi' => "\x{0A69}",
	'threehackarabic' => "\x{0663}",
	'threehangzhou' => "\x{3023}",
	'threeideographicparen' => "\x{3222}",
	'threeinferior' => "\x{2083}",
	'threemonospace' => "\x{FF13}",
	'threenumeratorbengali' => "\x{09F6}",
	'threeoldstyle' => "\x{F733}",
	'threeparen' => "\x{2476}",
	'threeperiod' => "\x{248A}",
	'threepersian' => "\x{06F3}",
	'threequartersemdash' => "\x{F6DE}",
	'threeroman' => "\x{2172}",
	'threethai' => "\x{0E53}",
	'thzsquare' => "\x{3394}",
	'tihiragana' => "\x{3061}",
	'tikatakana' => "\x{30C1}",
	'tikatakanahalfwidth' => "\x{FF81}",
	'tikeutacirclekorean' => "\x{3270}",
	'tikeutaparenkorean' => "\x{3210}",
	'tikeutcirclekorean' => "\x{3262}",
	'tikeutkorean' => "\x{3137}",
	'tikeutparenkorean' => "\x{3202}",
	'tildebelowcmb' => "\x{0330}",
	'tildecmb' => "\x{0303}",
	'tildedoublecmb' => "\x{0360}",
	'tildeoperator' => "\x{223C}",
	'tildeoverlaycmb' => "\x{0334}",
	'tildeverticalcmb' => "\x{033E}",
	'timescircle' => "\x{2297}",
	'tipehahebrew' => "\x{0596}",
	'tipehalefthebrew' => "\x{0596}",
	'tippigurmukhi' => "\x{0A70}",
	'titlocyrilliccmb' => "\x{0483}",
	'tiwnarmenian' => "\x{057F}",
	'tlinebelow' => "\x{1E6F}",
	'tmonospace' => "\x{FF54}",
	'toarmenian' => "\x{0569}",
	'tohiragana' => "\x{3068}",
	'tokatakana' => "\x{30C8}",
	'tokatakanahalfwidth' => "\x{FF84}",
	'tonebarextrahighmod' => "\x{02E5}",
	'tonebarextralowmod' => "\x{02E9}",
	'tonebarhighmod' => "\x{02E6}",
	'tonebarlowmod' => "\x{02E8}",
	'tonebarmidmod' => "\x{02E7}",
	'tonefive' => "\x{01BD}",
	'tonesix' => "\x{0185}",
	'tonetwo' => "\x{01A8}",
	'tonsquare' => "\x{3327}",
	'topatakthai' => "\x{0E0F}",
	'tortoiseshellbracketleft' => "\x{3014}",
	'tortoiseshellbracketleftsmall' => "\x{FE5D}",
	'tortoiseshellbracketleftvertical' => "\x{FE39}",
	'tortoiseshellbracketright' => "\x{3015}",
	'tortoiseshellbracketrightsmall' => "\x{FE5E}",
	'tortoiseshellbracketrightvertical' => "\x{FE3A}",
	'totaothai' => "\x{0E15}",
	'tpalatalhook' => "\x{01AB}",
	'tparen' => "\x{24AF}",
	'trademarksans' => "\x{F8EA}",
	'trademarkserif' => "\x{F6DB}",
	'tretroflexhook' => "\x{0288}",
	'ts' => "\x{02A6}",
	'tsadi' => "\x{05E6}",
	'tsadidagesh' => "\x{FB46}",
	'tsadidageshhebrew' => "\x{FB46}",
	'tsadihebrew' => "\x{05E6}",
	'tsecyrillic' => "\x{0446}",
	'tsere' => "\x{05B5}",
	'tsere12' => "\x{05B5}",
	'tsere1e' => "\x{05B5}",
	'tsere2b' => "\x{05B5}",
	'tserehebrew' => "\x{05B5}",
	'tserenarrowhebrew' => "\x{05B5}",
	'tserequarterhebrew' => "\x{05B5}",
	'tserewidehebrew' => "\x{05B5}",
	'tshecyrillic' => "\x{045B}",
	'tsuperior' => "\x{F6F3}",
	'ttabengali' => "\x{099F}",
	'ttadeva' => "\x{091F}",
	'ttagujarati' => "\x{0A9F}",
	'ttagurmukhi' => "\x{0A1F}",
	'tteharabic' => "\x{0679}",
	'ttehfinalarabic' => "\x{FB67}",
	'ttehinitialarabic' => "\x{FB68}",
	'ttehmedialarabic' => "\x{FB69}",
	'tthabengali' => "\x{09A0}",
	'tthadeva' => "\x{0920}",
	'tthagujarati' => "\x{0AA0}",
	'tthagurmukhi' => "\x{0A20}",
	'tturned' => "\x{0287}",
	'tuhiragana' => "\x{3064}",
	'tukatakana' => "\x{30C4}",
	'tukatakanahalfwidth' => "\x{FF82}",
	'tusmallhiragana' => "\x{3063}",
	'tusmallkatakana' => "\x{30C3}",
	'tusmallkatakanahalfwidth' => "\x{FF6F}",
	'twelvecircle' => "\x{246B}",
	'twelveparen' => "\x{247F}",
	'twelveperiod' => "\x{2493}",
	'twelveroman' => "\x{217B}",
	'twentycircle' => "\x{2473}",
	'twentyhangzhou' => "\x{5344}",
	'twentyparen' => "\x{2487}",
	'twentyperiod' => "\x{249B}",
	'twoarabic' => "\x{0662}",
	'twobengali' => "\x{09E8}",
	'twocircle' => "\x{2461}",
	'twocircleinversesansserif' => "\x{278B}",
	'twodeva' => "\x{0968}",
	'twodotleader' => "\x{2025}",
	'twodotleadervertical' => "\x{FE30}",
	'twogujarati' => "\x{0AE8}",
	'twogurmukhi' => "\x{0A68}",
	'twohackarabic' => "\x{0662}",
	'twohangzhou' => "\x{3022}",
	'twoideographicparen' => "\x{3221}",
	'twoinferior' => "\x{2082}",
	'twomonospace' => "\x{FF12}",
	'twonumeratorbengali' => "\x{09F5}",
	'twooldstyle' => "\x{F732}",
	'twoparen' => "\x{2475}",
	'twoperiod' => "\x{2489}",
	'twopersian' => "\x{06F2}",
	'tworoman' => "\x{2171}",
	'twostroke' => "\x{01BB}",
	'twothai' => "\x{0E52}",
	'ubar' => "\x{0289}",
	'ubengali' => "\x{0989}",
	'ubopomofo' => "\x{3128}",
	'ucaron' => "\x{01D4}",
	'ucircle' => "\x{24E4}",
	'ucircumflexbelow' => "\x{1E77}",
	'ucyrillic' => "\x{0443}",
	'udattadeva' => "\x{0951}",
	'udblacute' => "\x{0171}",
	'udblgrave' => "\x{0215}",
	'udeva' => "\x{0909}",
	'udieresisacute' => "\x{01D8}",
	'udieresisbelow' => "\x{1E73}",
	'udieresiscaron' => "\x{01DA}",
	'udieresiscyrillic' => "\x{04F1}",
	'udieresisgrave' => "\x{01DC}",
	'udieresismacron' => "\x{01D6}",
	'udotbelow' => "\x{1EE5}",
	'ugujarati' => "\x{0A89}",
	'ugurmukhi' => "\x{0A09}",
	'uhiragana' => "\x{3046}",
	'uhookabove' => "\x{1EE7}",
	'uhornacute' => "\x{1EE9}",
	'uhorndotbelow' => "\x{1EF1}",
	'uhorngrave' => "\x{1EEB}",
	'uhornhookabove' => "\x{1EED}",
	'uhorntilde' => "\x{1EEF}",
	'uhungarumlautcyrillic' => "\x{04F3}",
	'uinvertedbreve' => "\x{0217}",
	'ukatakana' => "\x{30A6}",
	'ukatakanahalfwidth' => "\x{FF73}",
	'ukcyrillic' => "\x{0479}",
	'ukorean' => "\x{315C}",
	'umacroncyrillic' => "\x{04EF}",
	'umacrondieresis' => "\x{1E7B}",
	'umatragurmukhi' => "\x{0A41}",
	'umonospace' => "\x{FF55}",
	'underscoremonospace' => "\x{FF3F}",
	'underscorevertical' => "\x{FE33}",
	'underscorewavy' => "\x{FE4F}",
	'uparen' => "\x{24B0}",
	'upperdothebrew' => "\x{05C4}",
	'upsilonlatin' => "\x{028A}",
	'uptackbelowcmb' => "\x{031D}",
	'uptackmod' => "\x{02D4}",
	'uragurmukhi' => "\x{0A73}",
	'ushortcyrillic' => "\x{045E}",
	'usmallhiragana' => "\x{3045}",
	'usmallkatakana' => "\x{30A5}",
	'usmallkatakanahalfwidth' => "\x{FF69}",
	'ustraightcyrillic' => "\x{04AF}",
	'ustraightstrokecyrillic' => "\x{04B1}",
	'utildeacute' => "\x{1E79}",
	'utildebelow' => "\x{1E75}",
	'uubengali' => "\x{098A}",
	'uudeva' => "\x{090A}",
	'uugujarati' => "\x{0A8A}",
	'uugurmukhi' => "\x{0A0A}",
	'uumatragurmukhi' => "\x{0A42}",
	'uuvowelsignbengali' => "\x{09C2}",
	'uuvowelsigndeva' => "\x{0942}",
	'uuvowelsigngujarati' => "\x{0AC2}",
	'uvowelsignbengali' => "\x{09C1}",
	'uvowelsigndeva' => "\x{0941}",
	'uvowelsigngujarati' => "\x{0AC1}",
	'vadeva' => "\x{0935}",
	'vagujarati' => "\x{0AB5}",
	'vagurmukhi' => "\x{0A35}",
	'vakatakana' => "\x{30F7}",
	'vav' => "\x{05D5}",
	'vavdagesh' => "\x{FB35}",
	'vavdagesh65' => "\x{FB35}",
	'vavdageshhebrew' => "\x{FB35}",
	'vavhebrew' => "\x{05D5}",
	'vavholam' => "\x{FB4B}",
	'vavholamhebrew' => "\x{FB4B}",
	'vavvavhebrew' => "\x{05F0}",
	'vavyodhebrew' => "\x{05F1}",
	'vcircle' => "\x{24E5}",
	'vdotbelow' => "\x{1E7F}",
	'vecyrillic' => "\x{0432}",
	'veharabic' => "\x{06A4}",
	'vehfinalarabic' => "\x{FB6B}",
	'vehinitialarabic' => "\x{FB6C}",
	'vehmedialarabic' => "\x{FB6D}",
	'vekatakana' => "\x{30F9}",
	'venus' => "\x{2640}",
	'verticalbar' => "\x{007C}",
	'verticallineabovecmb' => "\x{030D}",
	'verticallinebelowcmb' => "\x{0329}",
	'verticallinelowmod' => "\x{02CC}",
	'verticallinemod' => "\x{02C8}",
	'vewarmenian' => "\x{057E}",
	'vhook' => "\x{028B}",
	'vikatakana' => "\x{30F8}",
	'viramabengali' => "\x{09CD}",
	'viramadeva' => "\x{094D}",
	'viramagujarati' => "\x{0ACD}",
	'visargabengali' => "\x{0983}",
	'visargadeva' => "\x{0903}",
	'visargagujarati' => "\x{0A83}",
	'vmonospace' => "\x{FF56}",
	'voarmenian' => "\x{0578}",
	'voicediterationhiragana' => "\x{309E}",
	'voicediterationkatakana' => "\x{30FE}",
	'voicedmarkkana' => "\x{309B}",
	'voicedmarkkanahalfwidth' => "\x{FF9E}",
	'vokatakana' => "\x{30FA}",
	'vparen' => "\x{24B1}",
	'vtilde' => "\x{1E7D}",
	'vturned' => "\x{028C}",
	'vuhiragana' => "\x{3094}",
	'vukatakana' => "\x{30F4}",
	'waekorean' => "\x{3159}",
	'wahiragana' => "\x{308F}",
	'wakatakana' => "\x{30EF}",
	'wakatakanahalfwidth' => "\x{FF9C}",
	'wakorean' => "\x{3158}",
	'wasmallhiragana' => "\x{308E}",
	'wasmallkatakana' => "\x{30EE}",
	'wattosquare' => "\x{3357}",
	'wavedash' => "\x{301C}",
	'wavyunderscorevertical' => "\x{FE34}",
	'wawarabic' => "\x{0648}",
	'wawfinalarabic' => "\x{FEEE}",
	'wawhamzaabovearabic' => "\x{0624}",
	'wawhamzaabovefinalarabic' => "\x{FE86}",
	'wbsquare' => "\x{33DD}",
	'wcircle' => "\x{24E6}",
	'wdotaccent' => "\x{1E87}",
	'wdotbelow' => "\x{1E89}",
	'wehiragana' => "\x{3091}",
	'wekatakana' => "\x{30F1}",
	'wekorean' => "\x{315E}",
	'weokorean' => "\x{315D}",
	'whitebullet' => "\x{25E6}",
	'whitecircle' => "\x{25CB}",
	'whitecircleinverse' => "\x{25D9}",
	'whitecornerbracketleft' => "\x{300E}",
	'whitecornerbracketleftvertical' => "\x{FE43}",
	'whitecornerbracketright' => "\x{300F}",
	'whitecornerbracketrightvertical' => "\x{FE44}",
	'whitediamond' => "\x{25C7}",
	'whitediamondcontainingblacksmalldiamond' => "\x{25C8}",
	'whitedownpointingsmalltriangle' => "\x{25BF}",
	'whitedownpointingtriangle' => "\x{25BD}",
	'whiteleftpointingsmalltriangle' => "\x{25C3}",
	'whiteleftpointingtriangle' => "\x{25C1}",
	'whitelenticularbracketleft' => "\x{3016}",
	'whitelenticularbracketright' => "\x{3017}",
	'whiterightpointingsmalltriangle' => "\x{25B9}",
	'whiterightpointingtriangle' => "\x{25B7}",
	'whitesmallsquare' => "\x{25AB}",
	'whitesmilingface' => "\x{263A}",
	'whitesquare' => "\x{25A1}",
	'whitestar' => "\x{2606}",
	'whitetelephone' => "\x{260F}",
	'whitetortoiseshellbracketleft' => "\x{3018}",
	'whitetortoiseshellbracketright' => "\x{3019}",
	'whiteuppointingsmalltriangle' => "\x{25B5}",
	'whiteuppointingtriangle' => "\x{25B3}",
	'wihiragana' => "\x{3090}",
	'wikatakana' => "\x{30F0}",
	'wikorean' => "\x{315F}",
	'wmonospace' => "\x{FF57}",
	'wohiragana' => "\x{3092}",
	'wokatakana' => "\x{30F2}",
	'wokatakanahalfwidth' => "\x{FF66}",
	'won' => "\x{20A9}",
	'wonmonospace' => "\x{FFE6}",
	'wowaenthai' => "\x{0E27}",
	'wparen' => "\x{24B2}",
	'wring' => "\x{1E98}",
	'wsuperior' => "\x{02B7}",
	'wturned' => "\x{028D}",
	'wynn' => "\x{01BF}",
	'xabovecmb' => "\x{033D}",
	'xbopomofo' => "\x{3112}",
	'xcircle' => "\x{24E7}",
	'xdieresis' => "\x{1E8D}",
	'xdotaccent' => "\x{1E8B}",
	'xeharmenian' => "\x{056D}",
	'xmonospace' => "\x{FF58}",
	'xparen' => "\x{24B3}",
	'xsuperior' => "\x{02E3}",
	'yaadosquare' => "\x{334E}",
	'yabengali' => "\x{09AF}",
	'yadeva' => "\x{092F}",
	'yaekorean' => "\x{3152}",
	'yagujarati' => "\x{0AAF}",
	'yagurmukhi' => "\x{0A2F}",
	'yahiragana' => "\x{3084}",
	'yakatakana' => "\x{30E4}",
	'yakatakanahalfwidth' => "\x{FF94}",
	'yakorean' => "\x{3151}",
	'yamakkanthai' => "\x{0E4E}",
	'yasmallhiragana' => "\x{3083}",
	'yasmallkatakana' => "\x{30E3}",
	'yasmallkatakanahalfwidth' => "\x{FF6C}",
	'yatcyrillic' => "\x{0463}",
	'ycircle' => "\x{24E8}",
	'ydotaccent' => "\x{1E8F}",
	'ydotbelow' => "\x{1EF5}",
	'yeharabic' => "\x{064A}",
	'yehbarreearabic' => "\x{06D2}",
	'yehbarreefinalarabic' => "\x{FBAF}",
	'yehfinalarabic' => "\x{FEF2}",
	'yehhamzaabovearabic' => "\x{0626}",
	'yehhamzaabovefinalarabic' => "\x{FE8A}",
	'yehhamzaaboveinitialarabic' => "\x{FE8B}",
	'yehhamzaabovemedialarabic' => "\x{FE8C}",
	'yehinitialarabic' => "\x{FEF3}",
	'yehmedialarabic' => "\x{FEF4}",
	'yehmeeminitialarabic' => "\x{FCDD}",
	'yehmeemisolatedarabic' => "\x{FC58}",
	'yehnoonfinalarabic' => "\x{FC94}",
	'yehthreedotsbelowarabic' => "\x{06D1}",
	'yekorean' => "\x{3156}",
	'yenmonospace' => "\x{FFE5}",
	'yeokorean' => "\x{3155}",
	'yeorinhieuhkorean' => "\x{3186}",
	'yerahbenyomohebrew' => "\x{05AA}",
	'yerahbenyomolefthebrew' => "\x{05AA}",
	'yericyrillic' => "\x{044B}",
	'yerudieresiscyrillic' => "\x{04F9}",
	'yesieungkorean' => "\x{3181}",
	'yesieungpansioskorean' => "\x{3183}",
	'yesieungsioskorean' => "\x{3182}",
	'yetivhebrew' => "\x{059A}",
	'yhook' => "\x{01B4}",
	'yhookabove' => "\x{1EF7}",
	'yiarmenian' => "\x{0575}",
	'yicyrillic' => "\x{0457}",
	'yikorean' => "\x{3162}",
	'yinyang' => "\x{262F}",
	'yiwnarmenian' => "\x{0582}",
	'ymonospace' => "\x{FF59}",
	'yod' => "\x{05D9}",
	'yoddagesh' => "\x{FB39}",
	'yoddageshhebrew' => "\x{FB39}",
	'yodhebrew' => "\x{05D9}",
	'yodyodhebrew' => "\x{05F2}",
	'yodyodpatahhebrew' => "\x{FB1F}",
	'yohiragana' => "\x{3088}",
	'yoikorean' => "\x{3189}",
	'yokatakana' => "\x{30E8}",
	'yokatakanahalfwidth' => "\x{FF96}",
	'yokorean' => "\x{315B}",
	'yosmallhiragana' => "\x{3087}",
	'yosmallkatakana' => "\x{30E7}",
	'yosmallkatakanahalfwidth' => "\x{FF6E}",
	'yotgreek' => "\x{03F3}",
	'yoyaekorean' => "\x{3188}",
	'yoyakorean' => "\x{3187}",
	'yoyakthai' => "\x{0E22}",
	'yoyingthai' => "\x{0E0D}",
	'yparen' => "\x{24B4}",
	'ypogegrammeni' => "\x{037A}",
	'ypogegrammenigreekcmb' => "\x{0345}",
	'yr' => "\x{01A6}",
	'yring' => "\x{1E99}",
	'ysuperior' => "\x{02B8}",
	'ytilde' => "\x{1EF9}",
	'yturned' => "\x{028E}",
	'yuhiragana' => "\x{3086}",
	'yuikorean' => "\x{318C}",
	'yukatakana' => "\x{30E6}",
	'yukatakanahalfwidth' => "\x{FF95}",
	'yukorean' => "\x{3160}",
	'yusbigcyrillic' => "\x{046B}",
	'yusbigiotifiedcyrillic' => "\x{046D}",
	'yuslittlecyrillic' => "\x{0467}",
	'yuslittleiotifiedcyrillic' => "\x{0469}",
	'yusmallhiragana' => "\x{3085}",
	'yusmallkatakana' => "\x{30E5}",
	'yusmallkatakanahalfwidth' => "\x{FF6D}",
	'yuyekorean' => "\x{318B}",
	'yuyeokorean' => "\x{318A}",
	'yyabengali' => "\x{09DF}",
	'yyadeva' => "\x{095F}",
	'zaarmenian' => "\x{0566}",
	'zadeva' => "\x{095B}",
	'zagurmukhi' => "\x{0A5B}",
	'zaharabic' => "\x{0638}",
	'zahfinalarabic' => "\x{FEC6}",
	'zahinitialarabic' => "\x{FEC7}",
	'zahiragana' => "\x{3056}",
	'zahmedialarabic' => "\x{FEC8}",
	'zainarabic' => "\x{0632}",
	'zainfinalarabic' => "\x{FEB0}",
	'zakatakana' => "\x{30B6}",
	'zaqefgadolhebrew' => "\x{0595}",
	'zaqefqatanhebrew' => "\x{0594}",
	'zarqahebrew' => "\x{0598}",
	'zayin' => "\x{05D6}",
	'zayindagesh' => "\x{FB36}",
	'zayindageshhebrew' => "\x{FB36}",
	'zayinhebrew' => "\x{05D6}",
	'zbopomofo' => "\x{3117}",
	'zcircle' => "\x{24E9}",
	'zcircumflex' => "\x{1E91}",
	'zcurl' => "\x{0291}",
	'zdot' => "\x{017C}",
	'zdotbelow' => "\x{1E93}",
	'zecyrillic' => "\x{0437}",
	'zedescendercyrillic' => "\x{0499}",
	'zedieresiscyrillic' => "\x{04DF}",
	'zehiragana' => "\x{305C}",
	'zekatakana' => "\x{30BC}",
	'zeroarabic' => "\x{0660}",
	'zerobengali' => "\x{09E6}",
	'zerodeva' => "\x{0966}",
	'zerogujarati' => "\x{0AE6}",
	'zerogurmukhi' => "\x{0A66}",
	'zerohackarabic' => "\x{0660}",
	'zeroinferior' => "\x{2080}",
	'zeromonospace' => "\x{FF10}",
	'zerooldstyle' => "\x{F730}",
	'zeropersian' => "\x{06F0}",
	'zerosuperior' => "\x{2070}",
	'zerothai' => "\x{0E50}",
	'zerowidthjoiner' => "\x{FEFF}",
	'zerowidthnonjoiner' => "\x{200C}",
	'zerowidthspace' => "\x{200B}",
	'zhbopomofo' => "\x{3113}",
	'zhearmenian' => "\x{056A}",
	'zhebrevecyrillic' => "\x{04C2}",
	'zhecyrillic' => "\x{0436}",
	'zhedescendercyrillic' => "\x{0497}",
	'zhedieresiscyrillic' => "\x{04DD}",
	'zihiragana' => "\x{3058}",
	'zikatakana' => "\x{30B8}",
	'zinorhebrew' => "\x{05AE}",
	'zlinebelow' => "\x{1E95}",
	'zmonospace' => "\x{FF5A}",
	'zohiragana' => "\x{305E}",
	'zokatakana' => "\x{30BE}",
	'zparen' => "\x{24B5}",
	'zretroflexhook' => "\x{0290}",
	'zstroke' => "\x{01B6}",
	'zuhiragana' => "\x{305A}",
	'zukatakana' => "\x{30BA}",
	);

# Add to this list the glyphs for new fonts (from aglfn13):

map { $agl{$names{$_}} = pack('U',hex ($_))} (keys %names);


# %doubles = (map{$_ => "uni$_"} qw(0394 03A9 0162 2215 00AD 02C9 03BC 2219 00A0 0163));

=head2 lookup ( $usv [, $noAlt [, $noUni] ])

return the Adobe-recommended glyph name for a specific Unicode codepoint (integer). By default
returns C<uniXXXX> names rather than C<afiiNNNNN> or C<SFnnnnnn> names

If C<$noAlt> is true, C<afii> and C<SF> names are returned rather than C<uniXXXX>.

if C<$noUni> is true, returns undef if it would have to resort to C<uniXXXX> or C<uXXXXXX> 
style names. Essentially this represents a straight lookup in the Adobe-recommended list.

=cut

sub lookup
{
    my ($num, $noalt, $noUni) = @_;
    my ($val) = sprintf("%04X", $num);

    if (defined $names{$val})
    {
        return $names{$val} if ($noalt || $names{$val} !~ m/^(?:afii|SF)/o);
    }
    return undef if $noUni;
    if ($num > 0xFFFF)
    { return "u$val"; }
    elsif ($num)
    { return "uni$val"; }
    else
    { return ".notdef"; }
}

=head2 parse ( $glyphname )

Parse an Adobe-conformant glyph name, generating a Unicode codepoint sequence equivalent to the glyph (or
glyph components, should the name represent a ligature). In scalar context, returns a reference to an
array of Unicodes (decimal). Array is empty if the glyph name is non-conformant.
In list context, the first item returned is the same array reference as above. The second item
is a reference to an array containing the extensions (if any) present on the glyph name. 
The '.' that precedes each extension is not included.

=cut

sub parse
{
	my ($gname, @USVs, @extensions);
	($gname, @extensions) = split('\.', $_[0]);
	# if name originally started with . (e.g., .null) then $gname will now be '' ... need to fix that up:
	$gname = '.' . shift(@extensions) if $gname eq '';
	if (defined $gname)
	{
		foreach $gname (split('_', $gname))
		{
			if ($gname =~ /^u[0-9a-fA-F]{4,6}$/)
			{
				push @USVs, hex(substr($gname, 1));
			}
			elsif ($gname =~ /^uni([0-9a-fA-F]{4,4})+$/)
			{
				push @USVs, map {hex($_)} ($gname =~ /([0-9a-fA-F]{4,4})/g)
			}
			elsif (exists $agl{$gname})
			{
				push @USVs, unpack ('U*', $agl{$gname});
			}
		}
	}
	return \@USVs unless wantarray;
	my @res = (\@USVs, \@extensions);
	return @res;	
}

#Code used to parse Adobe's agl file and generate text for %agl initialization:
#while (<ARGV>) {
#	chomp;
#	next if m/^#/;
#	my ($gname, @nums) = split(/[; ]/);
#	if ($#nums > 0 or !defined ($Font::TTF::PSNames::names{$nums[0]}) or $Font::TTF::PSNames::names{$nums[0]} ne $gname)
#	{
#		print "\t'$gname' => \"";
#		map {print "\\x{$_}" } @nums;
#		print  "\",\n";
#	}
# }

=head1 AUTHOR

Martin Hosken Martin_Hosken@sil.org. See L<Font::TTF::Font> for copyright and
licensing.

=cut

1;
