// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
/*
 * popcon test
 *
 * Copyright (C) 2007  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/tests/test-utils.h>
#include <ept/textsearch/textsearch.h>
#include <ept/textsearch/maint/path.h>
#include <ept/apt/apt.h>
#include <set>

namespace ept {
namespace textsearch {
extern size_t max_index;
}
}

using namespace std;
using namespace ept;
using namespace ept::textsearch;
using namespace ept::apt;

namespace tut {

struct ept_textsearch_textsearch_shar
{
	Path::OverrideIndexDir oid;
	Apt apt;
	TextSearch textsearch;

	ept_textsearch_textsearch_shar()
		: oid("./xapian")
	{
		try {
			ept::textsearch::max_index = 1000;
			textsearch.rebuildIfNeeded(apt);
		} catch (Xapian::Error& e) {
			cerr << e.get_type() << " " << e.get_msg() << " " << e.get_context() << endl;
			throw;
		}
	}
};
TESTGRP(ept_textsearch_textsearch);

// Access an empty index
template<> template<>
void to::test< 1 >()
{
	Path::OverrideIndexDir oid("./empty");
	TextSearch empty;
	ensure_equals(empty.timestamp(), 0);
	ensure(!empty.hasData());
	ensure(empty.needsRebuild(apt));
	/*
	Xapian::Enquire enq(empty.db());
	empty.search(enq, "apt");
	Xapian::MSet matches = enq.get_mset(0, 100);
	ensure_equals(matches.size(), 0u);
	*/
}

// Very basic access
template<> template<>
void to::test< 2 >()
{
	ensure(textsearch.hasData());
	ensure(textsearch.timestamp() > 0);
	ensure(!textsearch.needsRebuild(apt));

	Xapian::Enquire enq(textsearch.db());
	enq.set_query(textsearch.makeORQuery("apt"));
	Xapian::MSet matches = enq.get_mset(0, 100);
	ensure(matches.size() > 0);

	// See if the apt package is among the results
	set<string> results;
	for (Xapian::MSetIterator i = matches.begin(); i != matches.end(); ++i)
		results.insert(i.get_document().get_data());
	ensure(results.find("apt") != results.end());
}

// Alternate access using intermediate Xapian::Query objects
template<> template<>
void to::test< 3 >()
{
	Xapian::Enquire enq(textsearch.db());
	enq.set_query(textsearch.makeORQuery("apt"));
	Xapian::MSet matches = enq.get_mset(0, 100);
	ensure(matches.size() > 0);

	// See if the apt package is among the results
	set<string> results;
	for (Xapian::MSetIterator i = matches.begin(); i != matches.end(); ++i)
		results.insert(i.get_document().get_data());
	ensure(results.find("apt") != results.end());
}

// Try makePartialORQuery
template<> template<>
void to::test< 4 >()
{
	Xapian::Enquire enq(textsearch.db());
	enq.set_query(textsearch.makePartialORQuery("apt"));
	Xapian::MSet matches = enq.get_mset(0, 100);
	ensure(matches.size() > 0);

	// See if the apt package is among the results
	set<string> results;
	for (Xapian::MSetIterator i = matches.begin(); i != matches.end(); ++i)
		results.insert(i.get_document().get_data());
	ensure(results.find("apt") != results.end());
}

// Try docidByName
template<> template<>
void to::test< 5 >()
{
	ensure(textsearch.docidByName("apt") != 0);
	ensure_equals(textsearch.docidByName("thereisnopackagewiththisname"), 0u);
}

}

// vim:set ts=4 sw=4:
