/*
 * Copyright (C) 2007  Enrico Zini <enrico@enricozini.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <ept/apt/version.h>

namespace tut {
using namespace std;
using namespace ept::apt;

struct ept_apt_version_shar {
};
TESTGRP(ept_apt_version);

// Basic test for invalid version
template<> template<>
void to::test<1>()
{
	Version test;

	ensure_equals(test.name(), "");
	ensure_equals(test.version(), "");
	ensure_equals(test.isValid(), false);

	string p = test.name();

	ensure_equals(p, string());
}

// Basic test for version
template<> template<>
void to::test<2>()
{
	Version test("test", "1.0");

	ensure_equals(test.name(), "test");
	ensure_equals(test.version(), "1.0");
	ensure_equals(test.isValid(), true);

	string p = test.name();

	ensure_equals(p, "test");

	Version v(p, "1.1");
	ensure_equals(v.name(), "test");
	ensure_equals(v.version(), "1.1");
	ensure_equals(v.isValid(), true);
}

// Comparison semanthics
template<> template<>
void to::test<3>()
{
	Version test("test", "1.0");
	Version test1("test", "1.0");

	ensure(test == test1);
	ensure(! (test != test1));
	ensure(! (test < test1));
	ensure(! (test > test1));
	ensure(test <= test1);
	ensure(test >= test1);


	Version test2("test2", "1.0");

	ensure(test != test2);
	ensure(test != test2);
	ensure(test < test2);
	ensure(! (test > test2));
	ensure(test <= test2);
	ensure(! (test >= test2));


	Version test3("test", "2.0");

	ensure(test != test3);
	ensure(test != test3);
	ensure(test < test3);
	ensure(! (test > test3));
	ensure(test <= test3);
	ensure(! (test >= test3));
}

// Value-copy semanthics
template<> template<>
void to::test<4>()
{
	Version test("test", "1.0");
	Version test1 = test;

	ensure(test == test1);

	Version test2;
	test2 = test;
	ensure(test == test2);
	ensure(test1 == test2);

	Version test3("test", "1.0");
	ensure(test == test3);
	ensure(test1 == test3);
	ensure(test2 == test3);
}

// Extraction of upstream version
template<> template<>
void to::test<5>()
{
	ensure_equals(Version("a", "10.0").upstreamVersion(), "10.0");
	ensure_equals(Version("a", "10.0-1").upstreamVersion(), "10.0");
	ensure_equals(Version("a", "10.0~foo.1-1.0").upstreamVersion(), "10.0~foo.1");
	ensure_equals(Version("a", "1.0:10.0~foo.1-1.0").upstreamVersion(), "10.0~foo.1");
}

// Debian policy comparison semanthics
template<> template<>
void to::test<6>()
{
	ensure(Version("a", "10.0") > Version("a", "2.1"));
	ensure(Version("a", "1:10.0") < Version("a", "2:2.1"));
	ensure(Version("a", "10.0-1") < Version("a", "10.0-2"));
	ensure(Version("a", "10.0-2") > Version("a", "10.0-1"));
	ensure(Version("a", "1:10.0-1") <= Version("a", "1:10.0-1"));
	ensure(Version("a", "1:10.0-1") >= Version("a", "1:10.0-1"));
	// TODO: add more
}

}

// vim:set ts=4 sw=4:
