// Author: Enrico Zini with help from Peter Rockai
// License: GPL

#include <ept/forward.h>
#include <ept/init.h>
#include <ept/configuration/apt.h>
#include <ept/cache/apt/packages.h>
#include <ept/cache/apt/packages.tcc>

#include <iostream>
#include <ctype.h>
#include <time.h>

// benchmarking stuff, ignore
void printClocks(const char *msg) {
    static clock_t t = 0;
    clock_t x = clock();
    std::cerr << msg << "; last = " << t / 1000.0
              << ", current = " << x / 1000.0
              << ", diff = " << (x - t) / 1000.0 << std::endl;
    t = x;
}

using namespace ept;
using namespace configuration::apt;
using namespace std;

// here starts the fun
int main(int argc, char* argv[])
{
	using namespace ept::configuration;
	using namespace std;

    ept::init();

	// Get access to the package cache
	cache::Aggregator agg;

    printClocks( "vector initialised" );
	for ( cache::Index::iterator i = agg.index().begin();
          i != agg.index().end(); ++i )
	{
        cache::Version v = i->anyVersion();
		if (!v.valid())
		{
			cout << "Name: " << i->name() << endl;
			cout << "Section: " << i->section() << endl;
		} else {
			string record = v.completeRecord();
            cout << record << endl;
		}
		cout << endl;
	}
	printClocks( "done" );

	return 0;
}

