/** -*- C++ -*-
   @file cache/apt/packages.tcc
   @author Peter Rockai <me@mornfall.net>
*/

#include <ept/cache/apt/packages.h>
#include <ept/cache/apt/state.h>
#include <ept/cache/debtags/vocabulary.h>
#include <ept/cache/debtags/tagmap.h>
#include <ept/error.h>

#ifndef EPT_CACHE_APT_PACKAGES_TCC
#define EPT_CACHE_APT_PACKAGES_TCC
namespace ept {
namespace t {
namespace cache {

namespace apt {

template< typename P >
void Aggregator< P >::reload() {
    if ( m_index ) m_index->reload();
    if ( m_state ) m_state->reload();
    // if ( m_records ) m_records->reload();
    // if ( m_vocabulary ) m_vocabulary->reload();
    worldChanged.emit();
}

template< typename P >
void Aggregator< P >::invalidate() {
    // preInvalidate.emit();
    delete m_index;
    delete m_state;
    delete m_records;
    delete m_vocabulary;
    m_index = 0; m_records = 0; m_state = 0; m_vocabulary = 0;
    // postInvalidate.emit();
}

template< typename P >
Aggregator< P >::Aggregator()
    : m_index( 0 ), m_state( 0 ), m_records( 0 ),
      m_vocabulary( 0 ), m_tagMap( 0 )
{
}

}
}
}
}

#include <ept/cache/apt/records.tcc>
#include <ept/cache/apt/state.tcc>
#include <ept/cache/apt/index.tcc>
#endif
