#ifndef APTFRONT_CACHE_COMPONENT_DEBTAGS_UPDATE_H
#define APTFRONT_CACHE_COMPONENT_DEBTAGS_UPDATE_H

#include <apt-front/forward.h>
#include <apt-front/utils/vocabularymerger.h>
#include <tagcoll/Consumer.h>
#include <string>
#include <vector>

class pkgAcquireStatus;

namespace aptFront {
namespace cache {
namespace component {
namespace debtags {

struct source
{
	enum type_t { TAGS };

	type_t type;
	std::string uri;
	source(type_t type, const std::string& uri) : type(type), uri(uri) {}

	std::string tagFile() const;
	std::string vocFile() const;
	time_t timestamp() const;
	time_t timestamp(Cache& c) const;
	bool canBeUsed() const;
};

std::vector<source> readSources();
bool dbNeedsReindex(Cache& c);
bool vocNeedsReindex(Cache& c);
int readTags(Cache& c, Tagcoll::Consumer<entity::Package, entity::Tag>& consumer, const source& source);
int readBasicVocabularies(utils::VocabularyMerger& systemvoc);
int readVocabulary(utils::VocabularyMerger& merger, const source& source);

void fetchNewData();
void fetchNewData(pkgAcquireStatus* status);

}
}
}
}

// vim:set ts=4 sw=4:
#endif
