#!/usr/bin/env python

import aptfront
import sys

aptfront.aptFrontInit()
cache = aptfront.CacheGlobal_cache()
if not cache.openCacheFile(aptfront.OpProgress(), aptfront.Cache.OpenReadOnly):
    print "Error opening cache file"
    error = aptfront.getGlobalError()
    error.DumpErrors()
cache.openRecordsCache()

pc = cache.pkgCache()

plist = pc.packageList()
it = plist.begin()

while not it.end():
    print "Package: " + it.name()
    V = it.versionList().begin()
    while not V.end():
        print "Version: " + V.versionString()
        print "Section: " + V.section()
        print "Architecture: " + V.architecture()
        print "Description: " + V.shortDescription() + V.longDescription()
        V.next()
    print
    it.next()
