#include <apt-front/cache/entity/tag.h>
#include <apt-front/cache/component/tags.h>

using namespace std;
using namespace aptFront;
using namespace cache;
using namespace entity;

std::string Facet::name() const
{
	if (valid())
		return tagsCache().facetData(index).name;
	throw std::out_of_range( "No name for this facet" );
}
std::string Facet::name(const std::string& d) const
{
	return valid() ? tagsCache().facetData(index).name : d;
}

std::string Facet::shortDescription() const
{
	if (valid())
		return tagsCache().facetData(index).shortDesc;
	throw std::out_of_range( "No short description for this facet" );
}
std::string Facet::shortDescription(const std::string& d) const
{
	return valid() ? tagsCache().facetData(index).shortDesc : d;
}

std::string Facet::longDescription() const
{
	if (valid())
		return tagsCache().facetData(index).longDesc;
	throw std::out_of_range( "No long description for this facet" );
}
std::string Facet::longDescription(const std::string& d) const
{
	return valid() ? tagsCache().facetData(index).longDesc : d;
}

bool Facet::hasTag(const std::string& name) const
{
	return tagsCache().hasTag(this->name() + "::" + name);
}

Tagcoll::OpSet<Tag> Facet::tags() const
{
	return tagsCache().tags(name());
}


Facet Tag::facet() const
{
	if (valid())
		return Facet(m_cache, tagsCache().tagData(index).facet);
	throw std::out_of_range( "No facet for this tag" );
}

std::string Tag::name() const
{
	if (valid())
		return tagsCache().tagData(index).name;
	throw std::out_of_range( "No name for this tag" );
}
std::string Tag::name(const std::string& d) const
{
	return valid() ? tagsCache().tagData(index).name : d;
}

std::string Tag::fullname() const
{
	if (valid())
		return facet().name() + "::" + tagsCache().tagData(index).name;
	throw std::out_of_range( "No full name for this facet" );
}
std::string Tag::fullname(const std::string& d) const
{
	return valid() ? facet().name() + "::" + tagsCache().tagData(index).name : d;
}

std::string Tag::shortDescription() const
{
	if (valid())
		return tagsCache().tagData(index).shortDesc;
	throw std::out_of_range( "No short description for this tag" );
}
std::string Tag::shortDescription(const std::string& d) const
{
	return valid() ? tagsCache().tagData(index).shortDesc : d;
}

std::string Tag::longDescription() const
{
	if (valid())
		return tagsCache().tagData(index).longDesc;
	throw std::out_of_range( "No long description for this tag" );
}
std::string Tag::longDescription(const std::string& d) const
{
	return valid() ? tagsCache().tagData(index).longDesc : d;
}


// hmmm bah this is pita, maybe we can come up with better solution?
// maybe raname COMPILE_TESTSUITE to APTFRONT_COMPILE_TESTSUITE?
/* Instantiate templates */
#ifdef COMPILE_TESTSUITE
#define SAVED_COMPILE_TESTSUITE
#undef COMPILE_TESTSUITE
#endif

#define INSTANTIATING_TEMPLATES

#include <tagcoll/OpSet.cc>

template class OpSet<entity::Facet>;
template class OpSet<entity::Tag>;

#ifdef SAVED_COMPILE_TESTSUITE
#define COMPILE_TESTSUITE
#endif




#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {

struct cache_entity_tag_shar {
    cache_entity_tag_shar() {
        aptInit();
        c.open( Cache::OpenDefault | Cache::OpenTags | Cache::OpenReadOnly );
    }
    Cache c;
};
TESTGRP(cache_entity_tag);

template<> template<>
void to::test<1>()
{
    entity::Tag a, b;
    ensure( a == b );
    ensure( !a.valid() );
    ensure( !b.valid() );
}

template<> template<>
void to::test<2>()
{
    entity::Tag a;
    int x = 1;
    try {
        a.shortDescription();
        x = 2;
    } catch (...) {
        x = 3;
    }
    ensure_equals( x, 3 );
}

template<> template<>
void to::test< 3 >()
{
    entity::Facet f = c.tags().facetByName( "works-with" );
    entity::Tag t = c.tags().tagByName( "works-with::people" );
    ensure( t.valid() );
    ensure( f.valid() );
    ensure( t.facet() == f );
    ensure( f.tags().contains( t ) );
}

template<> template<>
void to::test< 4 >()
{
    entity::Facet f = c.tags().facetByName( "works-with" );
    entity::Tag t = c.tags().tagByName( "works-with::people" );
    ensure( t.valid() );
    ensure( f.valid() );
    ensure( f.hasTag( t.name() ) );
}

template<> template<>
void to::test< 5 >()
{
    entity::Tag t = c.tags().tagByName( "works-with::people" );
    ensure( t.valid() );
    ensure( t.facet().hasTag( t.name() ) );
    ensure( t.facet().tags().contains( t ) );
}

}

#endif

// vim:set ts=3 sw=3:
