/* simple-client-vala.c generated by valac 0.11.6, the Vala compiler
 * generated from simple-client-vala.vala, do not modify */

/*
A small piece of sample code demonstrating a very simple application
with an indicator.

Copyright 2011 Canonical Ltd.

Authors:
    Marco Trevisan <mail@3v1n0.net>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include <gobject/gvaluecollector.h>


#define TYPE_SIMPLE_CLIENT (simple_client_get_type ())
#define SIMPLE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_CLIENT, SimpleClient))
#define SIMPLE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_CLIENT, SimpleClientClass))
#define IS_SIMPLE_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_CLIENT))
#define IS_SIMPLE_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_CLIENT))
#define SIMPLE_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_CLIENT, SimpleClientClass))

typedef struct _SimpleClient SimpleClient;
typedef struct _SimpleClientClass SimpleClientClass;
#define _simple_client_unref0(var) ((var == NULL) ? NULL : (var = (simple_client_unref (var), NULL)))
typedef struct _SimpleClientPrivate SimpleClientPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _ParamSpecSimpleClient ParamSpecSimpleClient;

struct _SimpleClient {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SimpleClientPrivate * priv;
};

struct _SimpleClientClass {
	GTypeClass parent_class;
	void (*finalize) (SimpleClient *self);
};

struct _SimpleClientPrivate {
	GtkMenu* menu;
	AppIndicator* ci;
	gint percentage;
	gboolean active;
	gboolean can_haz_label;
};

struct _Block1Data {
	int _ref_count_;
	SimpleClient * self;
	GtkMenuItem* prev_mi;
};

struct _Block2Data {
	int _ref_count_;
	SimpleClient * self;
	GtkMenuItem* submenu;
	GtkImageMenuItem* imgitem;
	GtkMenuItem* att;
	GtkMenuItem* show;
	GtkCheckMenuItem* icon;
};

struct _ParamSpecSimpleClient {
	GParamSpec parent_instance;
};


static gpointer simple_client_parent_class = NULL;

gint _vala_main (gchar** args, int args_length1);
SimpleClient* simple_client_new (gchar** args, int args_length1);
SimpleClient* simple_client_construct (GType object_type, gchar** args, int args_length1);
gpointer simple_client_ref (gpointer instance);
void simple_client_unref (gpointer instance);
GParamSpec* param_spec_simple_client (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_simple_client (GValue* value, gpointer v_object);
void value_take_simple_client (GValue* value, gpointer v_object);
gpointer value_get_simple_client (const GValue* value);
GType simple_client_get_type (void) G_GNUC_CONST;
void simple_client_run (SimpleClient* self);
#define SIMPLE_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_CLIENT, SimpleClientPrivate))
enum  {
	SIMPLE_CLIENT_DUMMY_PROPERTY
};
static void simple_client_toggle_sensitivity (SimpleClient* self, GtkWidget* widget);
static void simple_client_append_submenu (SimpleClient* self, GtkMenuItem* item);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (SimpleClient* self);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda1_ (Block1Data* _data1_);
static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda2_ (SimpleClient* self);
static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_client_label_toggle (SimpleClient* self, GtkMenuItem* item);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda3_ (gint delta, guint direction, SimpleClient* self);
static void __lambda3__app_indicator_scroll_event (AppIndicator* _sender, gint indicator, guint delta, gpointer self);
static gboolean _lambda4_ (SimpleClient* self);
static gboolean __lambda4__gsource_func (gpointer self);
static void _lambda5_ (SimpleClient* self);
static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void _lambda6_ (SimpleClient* self);
static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda7_ (Block2Data* _data2_);
static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda8_ (Block2Data* _data2_);
static void __lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda9_ (Block2Data* _data2_);
static void __lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda10_ (Block2Data* _data2_);
static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda11_ (Block2Data* _data2_);
static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void simple_client_finalize (SimpleClient* obj);


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	SimpleClient* _tmp0_ = NULL;
	SimpleClient* sc;
	_tmp0_ = simple_client_new (args, args_length1);
	sc = _tmp0_;
	simple_client_run (sc);
	result = 0;
	_simple_client_unref0 (sc);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


SimpleClient* simple_client_construct (GType object_type, gchar** args, int args_length1) {
	SimpleClient* self = NULL;
	AppIndicator* _tmp0_ = NULL;
	AppIndicator* _tmp1_;
	self = (SimpleClient*) g_type_create_instance (object_type);
	gtk_init (&args_length1, &args);
	_tmp0_ = app_indicator_new ("example-simple-client", "indicator-messages", APP_INDICATOR_CATEGORY_APPLICATION_STATUS);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->ci);
	self->priv->ci = _tmp1_;
	app_indicator_set_status (self->priv->ci, APP_INDICATOR_STATUS_ACTIVE);
	app_indicator_set_attention_icon (self->priv->ci, "indicator-messages-new");
	app_indicator_set_label (self->priv->ci, "1%", "100%");
	self->priv->active = TRUE;
	self->priv->can_haz_label = TRUE;
	return self;
}


SimpleClient* simple_client_new (gchar** args, int args_length1) {
	return simple_client_construct (TYPE_SIMPLE_CLIENT, args, args_length1);
}


static void simple_client_toggle_sensitivity (SimpleClient* self, GtkWidget* widget) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_is_sensitive (widget);
	gtk_widget_set_sensitive (widget, !_tmp0_);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_simple_client_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->prev_mi);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (SimpleClient* self) {
	g_print ("Sub1\n");
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda1_ (Block1Data* _data1_) {
	SimpleClient * self;
	self = _data1_->self;
	simple_client_toggle_sensitivity (self, (GtkWidget*) _data1_->prev_mi);
}


static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda1_ (self);
}


static void _lambda2_ (SimpleClient* self) {
	g_print ("Sub3\n");
}


static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda2_ (self);
}


static void simple_client_append_submenu (SimpleClient* self, GtkMenuItem* item) {
	Block1Data* _data1_;
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* menu;
	GtkMenuItem* mi = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_ = NULL;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* _tmp6_ = NULL;
	GtkMenuItem* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = simple_client_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	menu = g_object_ref_sink (_tmp0_);
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Sub 1");
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (mi);
	mi = _tmp2_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	g_signal_connect (mi, "activate", (GCallback) __lambda0__gtk_menu_item_activate, self);
	_tmp3_ = _g_object_ref0 (mi);
	_data1_->prev_mi = _tmp3_;
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Sub 2");
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (mi);
	mi = _tmp5_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	g_signal_connect_data (mi, "activate", (GCallback) __lambda1__gtk_menu_item_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Sub 3");
	_tmp7_ = g_object_ref_sink (_tmp6_);
	_g_object_unref0 (mi);
	mi = _tmp7_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkWidget*) mi);
	g_signal_connect (mi, "activate", (GCallback) __lambda2__gtk_menu_item_activate, self);
	gtk_widget_show_all ((GtkWidget*) menu);
	gtk_menu_item_set_submenu (item, (GtkWidget*) menu);
	_g_object_unref0 (mi);
	_g_object_unref0 (menu);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void simple_client_label_toggle (SimpleClient* self, GtkMenuItem* item) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	self->priv->can_haz_label = !self->priv->can_haz_label;
	if (self->priv->can_haz_label) {
		gtk_menu_item_set_label (item, "Hide label");
	} else {
		gtk_menu_item_set_label (item, "Show label");
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_simple_client_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->icon);
		_g_object_unref0 (_data2_->show);
		_g_object_unref0 (_data2_->att);
		_g_object_unref0 (_data2_->imgitem);
		_g_object_unref0 (_data2_->submenu);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda3_ (gint delta, guint direction, SimpleClient* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	_tmp0_ = g_strdup_printf ("%i", delta);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%u", direction);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Got scroll event! delta: ", _tmp1_, ", direction: ", _tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	g_print ("%s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}


static void __lambda3__app_indicator_scroll_event (AppIndicator* _sender, gint indicator, guint delta, gpointer self) {
	_lambda3_ (indicator, delta, self);
}


static gboolean _lambda4_ (SimpleClient* self) {
	gboolean result = FALSE;
	self->priv->percentage = (self->priv->percentage + 1) % 100;
	if (self->priv->can_haz_label) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp0_ = g_strdup_printf ("%i", self->priv->percentage + 1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat (_tmp1_, "%", NULL);
		_tmp3_ = _tmp2_;
		app_indicator_set_label (self->priv->ci, _tmp3_, "");
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
	} else {
		app_indicator_set_label (self->priv->ci, "", "");
	}
	result = TRUE;
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void _lambda5_ (SimpleClient* self) {
	g_print ("1\n");
}


static void __lambda5__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda5_ (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void _lambda6_ (SimpleClient* self) {
	g_print ("2\n");
}


static void __lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda6_ (self);
}


static void _lambda7_ (Block2Data* _data2_) {
	SimpleClient * self;
	self = _data2_->self;
	simple_client_toggle_sensitivity (self, (GtkWidget*) _data2_->submenu);
}


static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda7_ (self);
}


static void _lambda8_ (Block2Data* _data2_) {
	SimpleClient * self;
	GtkWidget* _tmp0_ = NULL;
	GtkImage* _tmp1_;
	GtkImage* img;
	self = _data2_->self;
	_tmp0_ = gtk_image_menu_item_get_image (_data2_->imgitem);
	_tmp1_ = _g_object_ref0 (GTK_IMAGE (_tmp0_));
	img = _tmp1_;
	gtk_image_set_from_stock (img, GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
	_g_object_unref0 (img);
}


static void __lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda8_ (self);
}


static void _lambda9_ (Block2Data* _data2_) {
	SimpleClient * self;
	self = _data2_->self;
	if (self->priv->active) {
		app_indicator_set_status (self->priv->ci, APP_INDICATOR_STATUS_ATTENTION);
		gtk_menu_item_set_label (_data2_->att, "I'm okay now");
		self->priv->active = FALSE;
	} else {
		app_indicator_set_status (self->priv->ci, APP_INDICATOR_STATUS_ACTIVE);
		gtk_menu_item_set_label (_data2_->att, "Get Attention");
		self->priv->active = FALSE;
	}
}


static void __lambda9__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda9_ (self);
}


static void _lambda10_ (Block2Data* _data2_) {
	SimpleClient * self;
	self = _data2_->self;
	simple_client_label_toggle (self, _data2_->show);
}


static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda10_ (self);
}


static void _lambda11_ (Block2Data* _data2_) {
	SimpleClient * self;
	gboolean _tmp0_;
	self = _data2_->self;
	_tmp0_ = gtk_check_menu_item_get_active (_data2_->icon);
	if (_tmp0_) {
		app_indicator_set_icon (self->priv->ci, "simple-client-test-icon.png");
	} else {
		app_indicator_set_icon (self->priv->ci, "indicator-messages");
	}
}


static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda11_ (self);
}


void simple_client_run (SimpleClient* self) {
	Block2Data* _data2_;
	GtkMenu* _tmp0_ = NULL;
	GtkMenu* _tmp1_;
	GtkCheckMenuItem* _tmp2_ = NULL;
	GtkCheckMenuItem* chk;
	GSList* _tmp3_;
	GtkRadioMenuItem* _tmp4_ = NULL;
	GtkRadioMenuItem* _tmp5_;
	GtkRadioMenuItem* radio;
	GtkMenuItem* _tmp6_ = NULL;
	GtkMenuItem* _tmp7_ = NULL;
	GtkMenuItem* toggle_item;
	GtkImageMenuItem* _tmp8_ = NULL;
	GtkMenuItem* _tmp9_ = NULL;
	GtkMenuItem* _tmp10_ = NULL;
	GtkCheckMenuItem* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = simple_client_ref (self);
	g_signal_connect (self->priv->ci, "scroll-event", (GCallback) __lambda3__app_indicator_scroll_event, self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda4__gsource_func, simple_client_ref (self), simple_client_unref);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp1_;
	_tmp2_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("1");
	chk = g_object_ref_sink (_tmp2_);
	g_signal_connect ((GtkMenuItem*) chk, "activate", (GCallback) __lambda5__gtk_menu_item_activate, self);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) chk));
	gtk_widget_show ((GtkWidget*) chk);
	_tmp3_ = NULL;
	_tmp4_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_label (_tmp3_, "2");
	radio = (_tmp5_ = g_object_ref_sink (_tmp4_), __g_slist_free__g_object_unref0_0 (_tmp3_), _tmp5_);
	g_signal_connect ((GtkMenuItem*) radio, "activate", (GCallback) __lambda6__gtk_menu_item_activate, self);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) radio));
	gtk_widget_show ((GtkWidget*) radio);
	_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("3");
	_data2_->submenu = g_object_ref_sink (_tmp6_);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) _data2_->submenu);
	simple_client_append_submenu (self, _data2_->submenu);
	gtk_widget_show ((GtkWidget*) _data2_->submenu);
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Toggle 3");
	toggle_item = g_object_ref_sink (_tmp7_);
	g_signal_connect_data (toggle_item, "activate", (GCallback) __lambda7__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) toggle_item);
	gtk_widget_show ((GtkWidget*) toggle_item);
	_tmp8_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_NEW, NULL);
	_data2_->imgitem = g_object_ref_sink (_tmp8_);
	g_signal_connect_data ((GtkMenuItem*) _data2_->imgitem, "activate", (GCallback) __lambda8__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) _data2_->imgitem));
	gtk_widget_show ((GtkWidget*) _data2_->imgitem);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Get Attention");
	_data2_->att = g_object_ref_sink (_tmp9_);
	g_signal_connect_data (_data2_->att, "activate", (GCallback) __lambda9__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) _data2_->att);
	gtk_widget_show ((GtkWidget*) _data2_->att);
	_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Show Label");
	_data2_->show = g_object_ref_sink (_tmp10_);
	simple_client_label_toggle (self, _data2_->show);
	g_signal_connect_data (_data2_->show, "activate", (GCallback) __lambda10__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) _data2_->show);
	gtk_widget_show ((GtkWidget*) _data2_->show);
	_tmp11_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label ("Set Local Icon");
	_data2_->icon = g_object_ref_sink (_tmp11_);
	g_signal_connect_data ((GtkMenuItem*) _data2_->icon, "activate", (GCallback) __lambda11__gtk_menu_item_activate, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) _data2_->icon));
	gtk_widget_show ((GtkWidget*) _data2_->icon);
	app_indicator_set_menu (self->priv->ci, self->priv->menu);
	gtk_main ();
	_g_object_unref0 (toggle_item);
	_g_object_unref0 (radio);
	_g_object_unref0 (chk);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void value_simple_client_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_simple_client_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		simple_client_unref (value->data[0].v_pointer);
	}
}


static void value_simple_client_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = simple_client_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_simple_client_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_simple_client_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SimpleClient* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = simple_client_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_simple_client_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SimpleClient** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = simple_client_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_simple_client (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSimpleClient* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SIMPLE_CLIENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_simple_client (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_CLIENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_simple_client (GValue* value, gpointer v_object) {
	SimpleClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		simple_client_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_client_unref (old);
	}
}


void value_take_simple_client (GValue* value, gpointer v_object) {
	SimpleClient* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SIMPLE_CLIENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SIMPLE_CLIENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		simple_client_unref (old);
	}
}


static void simple_client_class_init (SimpleClientClass * klass) {
	simple_client_parent_class = g_type_class_peek_parent (klass);
	SIMPLE_CLIENT_CLASS (klass)->finalize = simple_client_finalize;
	g_type_class_add_private (klass, sizeof (SimpleClientPrivate));
}


static void simple_client_instance_init (SimpleClient * self) {
	self->priv = SIMPLE_CLIENT_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void simple_client_finalize (SimpleClient* obj) {
	SimpleClient * self;
	self = SIMPLE_CLIENT (obj);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->ci);
}


GType simple_client_get_type (void) {
	static volatile gsize simple_client_type_id__volatile = 0;
	if (g_once_init_enter (&simple_client_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_simple_client_init, value_simple_client_free_value, value_simple_client_copy_value, value_simple_client_peek_pointer, "p", value_simple_client_collect_value, "p", value_simple_client_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SimpleClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleClient), 0, (GInstanceInitFunc) simple_client_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType simple_client_type_id;
		simple_client_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SimpleClient", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&simple_client_type_id__volatile, simple_client_type_id);
	}
	return simple_client_type_id__volatile;
}


gpointer simple_client_ref (gpointer instance) {
	SimpleClient* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void simple_client_unref (gpointer instance) {
	SimpleClient* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SIMPLE_CLIENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



