//===- BlackfinSubtarget.h - Define Subtarget for the Blackfin -*- C++ -*-====//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file declares the BLACKFIN specific subclass of TargetSubtarget.
//
//===----------------------------------------------------------------------===//

#ifndef BLACKFIN_SUBTARGET_H
#define BLACKFIN_SUBTARGET_H

#include "llvm/Target/TargetSubtarget.h"
#include <string>

namespace llvm {

  class BlackfinSubtarget : public TargetSubtarget {
    bool sdram;
    bool icplb;
    bool wa_mi_shift;
    bool wa_csync;
    bool wa_specld;
    bool wa_mmr_stall;
    bool wa_lcregs;
    bool wa_hwloop;
    bool wa_ind_call;
    bool wa_killed_mmr;
    bool wa_rets;
  public:
    BlackfinSubtarget(const std::string &TT, const std::string &FS);

    /// ParseSubtargetFeatures - Parses features string setting specified
    /// subtarget options.  Definition of function is auto generated by tblgen.
    std::string ParseSubtargetFeatures(const std::string &FS,
                                       const std::string &CPU);
  };

} // end namespace llvm

#endif
