\
/*
 * OMAP5 pin mux definition
 *
 * Copyright (C) 2011 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * - Based on mux34xx.c done by Tony Lindgren <tony@atomide.com>
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/module.h>
#include <linux/init.h>

#include "mux.h"

#ifdef CONFIG_OMAP_MUX

#define _OMAP5_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)	\
{									\
	.reg_offset	= (OMAP5_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.gpio		= (g),						\
	.muxnames	= { m0, m1, m2, m3, m4, m5, m6, m7 },		\
}

#else

#define _OMAP5_MUXENTRY(M0, g, m0, m1, m2, m3, m4, m5, m6, m7)	\
{									\
	.reg_offset	= (OMAP5_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.gpio		= (g),						\
}

#endif

#define _OMAP5_BALLENTRY(M0, bb, bt)				\
{									\
	.reg_offset	= (OMAP5_CTRL_MODULE_PAD_##M0##_OFFSET),	\
	.balls		= { bb, bt },					\
}

/*
 * Superset of all mux modes for omap5
 */
static struct omap_mux __initdata omap5_core_muxmodes[] = {
	_OMAP5_MUXENTRY(EMMC_CLK, 46, "emmc_clk", NULL, NULL, NULL, NULL, NULL,
			"gpio2_46", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_CMD, 47, "emmc_cmd", NULL, NULL, NULL, NULL, NULL,
			"gpio2_47", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA0, 48, "emmc_data0", NULL, NULL, NULL, NULL,
			NULL, "gpio2_48", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA1, 49, "emmc_data1", NULL, NULL, NULL, NULL,
			NULL, "gpio2_49", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA2, 50, "emmc_data2", NULL, NULL, NULL, NULL,
			NULL, "gpio2_50", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA3, 51, "emmc_data3", NULL, NULL, NULL, NULL,
			NULL, "gpio2_51", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA4, 52, "emmc_data4", NULL, NULL, NULL, NULL,
			NULL, "gpio2_52", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA5, 53, "emmc_data5", NULL, NULL, NULL, NULL,
			NULL, "gpio2_53", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA6, 54, "emmc_data6", NULL, NULL, NULL, NULL,
			NULL, "gpio2_54", "safe_mode"),
	_OMAP5_MUXENTRY(EMMC_DATA7, 55, "emmc_data7", NULL, NULL, NULL, NULL,
			NULL, "gpio2_55", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_CLKOUT0, 33, "c2c_clkout0", NULL, NULL, NULL,
			"gpmc_nadv_ale", NULL, "gpio2_33", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_CLKOUT1, 34, "c2c_clkout1", NULL, NULL, "kbd_col8",
			"gpmc_nbe0_cle", NULL, "gpio2_34", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_CLKIN0, 35, "c2c_clkin0", NULL, NULL, NULL,
			"gpmc_nwp", "gpmc_nbe1", "gpio2_35", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_CLKIN1, 36, "c2c_clkin1", NULL, NULL, "kbd_row8",
			"gpmc_clk", NULL, "gpio2_36", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN0, 37, "c2c_datain0", NULL, NULL, "kbd_row0",
			"gpmc_ad0", NULL, "gpio2_37", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN1, 38, "c2c_datain1", NULL, NULL, "kbd_row1",
			"gpmc_ad1", NULL, "gpio2_38", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN2, 39, "c2c_datain2", NULL, NULL, "kbd_row2",
			"gpmc_ad2", NULL, "gpio2_39", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN3, 40, "c2c_datain3", NULL, NULL, "kbd_row3",
			"gpmc_ad3", NULL, "gpio2_40", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN4, 41, "c2c_datain4", NULL, NULL, "kbd_row4",
			"gpmc_ad4", NULL, "gpio2_41", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN5, 42, "c2c_datain5", NULL, NULL, "kbd_row5",
			"gpmc_ad5", NULL, "gpio2_42", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN6, 43, "c2c_datain6", NULL, NULL, "kbd_row6",
			"gpmc_ad6", NULL, "gpio2_43", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAIN7, 44, "c2c_datain7", NULL, NULL, "kbd_row7",
			"gpmc_ad7", NULL, "gpio2_44", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT0, 56, "c2c_dataout0", NULL, NULL,
			"kbd_col0", "gpmc_ad8", "hw_dbg16", "gpio2_56",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT1, 57, "c2c_dataout1", NULL, NULL,
			"kbd_col1", "gpmc_ad9", "hw_dbg17", "gpio2_57",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT2, 58, "c2c_dataout2", NULL, NULL,
			"kbd_col2", "gpmc_ad10", "hw_dbg18", "gpio2_58",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT3, 59, "c2c_dataout3", NULL, NULL,
			"kbd_col3", "gpmc_ad11", "hw_dbg19", "gpio2_59",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT4, 60, "c2c_dataout4", NULL, NULL,
			"kbd_col4", "gpmc_ad12", "hw_dbg20", "gpio2_60",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT5, 61, "c2c_dataout5", NULL, NULL,
			"kbd_col5", "gpmc_ad13", "hw_dbg21", "gpio2_61",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT6, 62, "c2c_dataout6", NULL, NULL,
			"kbd_col6", "gpmc_ad14", "hw_dbg22", "gpio2_62",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATAOUT7, 63, "c2c_dataout7", NULL, NULL,
			"kbd_col7", "gpmc_ad15", "hw_dbg23", "gpio2_63",
			"safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA8, 113, "c2c_data8", NULL, NULL, NULL,
			"gpmc_a16", "hw_dbg24", "gpio4_113", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA9, 114, "c2c_data9", NULL, NULL, NULL,
			"gpmc_a17", "hw_dbg25", "gpio4_114", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA10, 115, "c2c_data10", NULL, NULL, NULL,
			"gpmc_a18", "hw_dbg26", "gpio4_115", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA11, 116, "c2c_data11", NULL, NULL, NULL,
			"gpmc_a19", "hw_dbg27", "gpio4_116", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA12, 117, "c2c_data12", NULL, NULL, NULL,
			"gpmc_a20", "hw_dbg28", "gpio4_117", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA13, 118, "c2c_data13", NULL, NULL, NULL,
			"gpmc_a21", "hw_dbg29", "gpio4_118", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA14, 119, "c2c_data14", NULL, NULL, NULL,
			"gpmc_a22", "hw_dbg30", "gpio4_119", "safe_mode"),
	_OMAP5_MUXENTRY(C2C_DATA15, 120, "c2c_data15", NULL, NULL, NULL,
			"gpmc_a23", "hw_dbg31", "gpio4_120", "safe_mode"),
	_OMAP5_MUXENTRY(LLIA_WAKEREQOUT, 45, "llia_wakereqout",
			"c2c_wakereqout", NULL, NULL, "gpmc_wait0", NULL,
			"gpio2_45", "safe_mode"),
	_OMAP5_MUXENTRY(LLIB_WAKEREQOUT, 32, "llib_wakereqout", NULL, NULL,
			NULL, "gpmc_ncs0", NULL, "gpio2_32", "safe_mode"),
	_OMAP5_MUXENTRY(HSI1_ACREADY, 64, "hsi1_acready", NULL, NULL,
			"usbb2_ulpitll_clk", NULL, NULL, "gpio3_64",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_CAREADY, 65, "hsi1_caready", NULL, NULL,
			"usbb2_ulpitll_nxt", NULL, NULL, "gpio3_65",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_ACWAKE, 66, "hsi1_acwake", NULL, NULL,
			"usbb2_ulpitll_dir", NULL, NULL, "gpio3_66",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_CAWAKE, 67, "hsi1_cawake", NULL, NULL,
			"usbb2_ulpitll_stp", NULL, NULL, "gpio3_67",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_ACFLAG, 68, "hsi1_acflag", NULL, NULL,
			"usbb2_ulpitll_data0", NULL, NULL, "gpio3_68",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_ACDATA, 69, "hsi1_acdata", NULL, NULL,
			"usbb2_ulpitll_data1", NULL, NULL, "gpio3_69",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_CAFLAG, 70, "hsi1_caflag", NULL, NULL,
			"usbb2_ulpitll_data2", NULL, NULL, "gpio3_70",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI1_CADATA, 71, "hsi1_cadata", NULL, NULL,
			"usbb2_ulpitll_data3", NULL, NULL, "gpio3_71",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART1_TX, 72, "uart1_tx", NULL, NULL,
			"usbb2_ulpitll_data4", NULL, NULL, "gpio3_72",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART1_CTS, 73, "uart1_cts", NULL, NULL,
			"usbb2_ulpitll_data5", "gpmc_wait3", NULL, "gpio3_73",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART1_RX, 74, "uart1_rx", NULL, NULL,
			"usbb2_ulpitll_data6", NULL, NULL, "gpio3_74",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART1_RTS, 75, "uart1_rts", NULL, NULL,
			"usbb2_ulpitll_data7", "gpmc_ncs7", NULL, "gpio3_75",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_CAREADY, 76, "hsi2_caready", NULL, NULL,
			"usbb1_ulpiphy_clk", "gpmc_wait1", NULL, "gpio3_76",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_ACREADY, 77, "hsi2_acready", NULL, NULL,
			"usbb1_ulpiphy_nxt", "gpmc_ncs1", NULL, "gpio3_77",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_CAWAKE, 78, "hsi2_cawake", NULL, NULL,
			"usbb1_ulpiphy_dir", "gpmc_a24", NULL, "gpio3_78",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_ACWAKE, 79, "hsi2_acwake", NULL, NULL,
			"usbb1_ulpiphy_stp", "gpmc_a25", NULL, "gpio3_79",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_CAFLAG, 80, "hsi2_caflag", NULL, NULL,
			"usbb1_ulpiphy_data0", "gpmc_wait2", NULL, "gpio3_80",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_CADATA, 81, "hsi2_cadata", NULL, NULL,
			"usbb1_ulpiphy_data1", "gpmc_ncs2", NULL, "gpio3_81",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_ACFLAG, 82, "hsi2_acflag", NULL, NULL,
			"usbb1_ulpiphy_data2", "gpmc_ncs3", NULL, "gpio3_82",
			"safe_mode"),
	_OMAP5_MUXENTRY(HSI2_ACDATA, 83, "hsi2_acdata", NULL, NULL,
			"usbb1_ulpiphy_data3", "gpmc_ncs4", NULL, "gpio3_83",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART2_RTS, 84, "uart2_rts", "mcspi3_somi", NULL,
			"usbb1_ulpiphy_data4", "gpmc_nwe", "hw_dbg16",
			"gpio3_84", "safe_mode"),
	_OMAP5_MUXENTRY(UART2_CTS, 85, "uart2_cts", "mcspi3_cs0", NULL,
			"usbb1_ulpiphy_data5", "gpmc_noe_nre", "hw_dbg17",
			"gpio3_85", "safe_mode"),
	_OMAP5_MUXENTRY(UART2_RX, 86, "uart2_rx", "mcspi3_simo", NULL,
			"usbb1_ulpiphy_data6", "gpmc_ncs5", "hw_dbg18",
			"gpio3_86", "safe_mode"),
	_OMAP5_MUXENTRY(UART2_TX, 87, "uart2_tx", "mcspi3_clk", NULL,
			"usbb1_ulpiphy_data7", "gpmc_ncs6", "hw_dbg19",
			"gpio3_87", "safe_mode"),
	_OMAP5_MUXENTRY(USBB1_HSIC_STROBE, 92, "usbb1_hsic_strobe", NULL, NULL,
			NULL, NULL, NULL, "gpio3_92", "safe_mode"),
	_OMAP5_MUXENTRY(USBB1_HSIC_DATA, 93, "usbb1_hsic_data", NULL, NULL,
			NULL, NULL, NULL, "gpio3_93", "safe_mode"),
	_OMAP5_MUXENTRY(USBB2_HSIC_STROBE, 94, "usbb2_hsic_strobe", NULL, NULL,
			NULL, NULL, NULL, "gpio3_94", "safe_mode"),
	_OMAP5_MUXENTRY(USBB2_HSIC_DATA, 95, "usbb2_hsic_data", NULL, NULL,
			NULL, NULL, NULL, "gpio3_95", "safe_mode"),
	_OMAP5_MUXENTRY(TIMER10_PWM_EVT, 188, "timer10_pwm_evt", NULL, NULL,
			NULL, NULL, NULL, "gpio6_188", "safe_mode"),
	_OMAP5_MUXENTRY(DSIPORTA_TE0, 189, "dsiporta_te0", NULL, NULL, NULL,
			NULL, NULL, "gpio6_189", "safe_mode"),
	_OMAP5_MUXENTRY(DSIPORTA_LANE0X, 0, "dsiporta_lane0x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE0Y, 0, "dsiporta_lane0y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE1X, 0, "dsiporta_lane1x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE1Y, 0, "dsiporta_lane1y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE2X, 0, "dsiporta_lane2x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE2Y, 0, "dsiporta_lane2y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE3X, 0, "dsiporta_lane3x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE3Y, 0, "dsiporta_lane3y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE4X, 0, "dsiporta_lane4x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTA_LANE4Y, 0, "dsiporta_lane4y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE0X, 0, "dsiportc_lane0x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE0Y, 0, "dsiportc_lane0y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE1X, 0, "dsiportc_lane1x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE1Y, 0, "dsiportc_lane1y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE2X, 0, "dsiportc_lane2x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE2Y, 0, "dsiportc_lane2y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE3X, 0, "dsiportc_lane3x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE3Y, 0, "dsiportc_lane3y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE4X, 0, "dsiportc_lane4x", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_LANE4Y, 0, "dsiportc_lane4y", NULL, NULL,
			NULL, NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(DSIPORTC_TE0, 191, "dsiportc_te0", NULL, NULL, NULL,
			NULL, NULL, "gpio6_191", "safe_mode"),
	_OMAP5_MUXENTRY(TIMER9_PWM_EVT, 190, "timer9_pwm_evt", NULL, NULL, NULL,
			NULL, NULL, "gpio6_190", "safe_mode"),
	_OMAP5_MUXENTRY(I2C4_SCL, 200, "i2c4_scl", NULL, NULL, NULL, NULL, NULL,
			"gpio7_200", "safe_mode"),
	_OMAP5_MUXENTRY(I2C4_SDA, 201, "i2c4_sda", NULL, NULL, NULL, NULL, NULL,
			"gpio7_201", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI2_CLK, 197, "mcspi2_clk", NULL, NULL, NULL, NULL,
			NULL, "gpio7_197", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI2_SIMO, 198, "mcspi2_simo", NULL, NULL, NULL, NULL,
			"hw_dbg20", "gpio7_198", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI2_SOMI, 199, "mcspi2_somi", NULL, NULL, NULL, NULL,
			"hw_dbg21", "gpio7_199", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI2_CS0, 196, "mcspi2_cs0", NULL, NULL, "dispc_fid",
			NULL, NULL, "gpio7_196", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA15, 181, "rfbi_data15", "mcspi2_cs1", NULL,
			"dispc_data15", "kbd_col6", "drm_emu19", "gpio6_181",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA14, 180, "rfbi_data14", NULL, NULL,
			"dispc_data14", "kbd_col7", "drm_emu18", "gpio6_180",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA13, 179, "rfbi_data13", NULL, NULL,
			"dispc_data13", "kbd_col8", "drm_emu17", "gpio6_179",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA12, 178, "rfbi_data12", NULL, NULL,
			"dispc_data12", "kbd_row6", "drm_emu16", "gpio6_178",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA11, 177, "rfbi_data11", NULL, NULL,
			"dispc_data11", "kbd_row7", "drm_emu15", "gpio6_177",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA10, 176, "rfbi_data10", NULL, NULL,
			"dispc_data10", "kbd_row8", "drm_emu14", "gpio6_176",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA9, 175, "rfbi_data9", NULL, NULL,
			"dispc_data9", "kbd_row3", "drm_emu13", "gpio6_175",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA8, 174, "rfbi_data8", NULL, NULL,
			"dispc_data8", "kbd_col3", "drm_emu12", "gpio6_174",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA7, 173, "rfbi_data7", NULL, NULL,
			"dispc_data7", NULL, "drm_emu11", "gpio6_173",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA6, 172, "rfbi_data6", NULL, NULL,
			"dispc_data6", NULL, "drm_emu10", "gpio6_172",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA5, 171, "rfbi_data5", NULL, NULL,
			"dispc_data5", NULL, "drm_emu9", "gpio6_171",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA4, 170, "rfbi_data4", NULL, NULL,
			"dispc_data4", NULL, "drm_emu8", "gpio6_170",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA3, 169, "rfbi_data3", NULL, NULL,
			"dispc_data3", NULL, "drm_emu7", "gpio6_169",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA2, 168, "rfbi_data2", NULL, NULL,
			"dispc_data2", "uart3_tx_irtx", "drm_emu6",
			"gpio6_168", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA1, 167, "rfbi_data1", NULL, NULL,
			"dispc_data1", "uart3_rx_irrx", "drm_emu5",
			"gpio6_167", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_DATA0, 166, "rfbi_data0", NULL, NULL,
			"dispc_data0", NULL, "drm_emu4", "gpio6_166",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_WE, 162, "rfbi_we", NULL, NULL, "dispc_vsync",
			NULL, "drm_emu2", "gpio6_162", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_CS0, 163, "rfbi_cs0", NULL, NULL, "dispc_hsync",
			NULL, "drm_emu3", "gpio6_163", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_A0, 165, "rfbi_a0", NULL, NULL, "dispc_de",
			"kbd_row4", NULL, "gpio6_165", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_RE, 164, "rfbi_re", NULL, NULL, "dispc_pclk",
			"kbd_col4", NULL, "gpio6_164", "safe_mode"),
	_OMAP5_MUXENTRY(RFBI_HSYNC0, 160, "rfbi_hsync0", NULL, NULL,
			"dispc_data17", "kbd_col5", NULL, "gpio6_160",
			"safe_mode"),
	_OMAP5_MUXENTRY(RFBI_TE_VSYNC0, 161, "rfbi_te_vsync0", NULL, NULL,
			"dispc_data16", "kbd_row5", "jtag_sel", "gpio6_161",
			"safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_182, 182, "gpio6_182", NULL, NULL, "dispc_data18",
			"kbd_col0", NULL, "gpio6_182", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_183, 183, "gpio6_183", NULL, NULL, "dispc_data19",
			"kbd_col1", NULL, "gpio6_183", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_184, 184, "gpio6_184", NULL, NULL, "dispc_data20",
			"kbd_col2", "hw_dbg22", "gpio6_184", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_185, 185, "gpio6_185", NULL, NULL, "dispc_data21",
			"kbd_row0", "hw_dbg23", "gpio6_185", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_186, 186, "gpio6_186", NULL, NULL, "dispc_data22",
			"kbd_row1", "hw_dbg24", "gpio6_186", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO6_187, 187, "gpio6_187", NULL, NULL, "dispc_data23",
			"kbd_row2", "hw_dbg25", "gpio6_187", "safe_mode"),
	_OMAP5_MUXENTRY(HDMI_CEC, 192, "hdmi_cec", NULL, NULL, NULL, NULL, NULL,
			"gpio7_192", "safe_mode"),
	_OMAP5_MUXENTRY(HDMI_HPD, 193, "hdmi_hpd", NULL, NULL, NULL, NULL, NULL,
			"gpio7_193", "safe_mode"),
	_OMAP5_MUXENTRY(HDMI_DDC_SCL, 194, "hdmi_ddc_scl", NULL, NULL, NULL,
			NULL, NULL, "gpio7_194", "safe_mode"),
	_OMAP5_MUXENTRY(HDMI_DDC_SDA, 195, "hdmi_ddc_sda", NULL, NULL, NULL,
			NULL, NULL, "gpio7_195", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTC_LANE0X, 253, "csiportc_lane0x", NULL, NULL,
			"cpi_data9", NULL, NULL, "gpio8_in253", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTC_LANE0Y, 252, "csiportc_lane0y", NULL, NULL,
			"cpi_data8", NULL, NULL, "gpio8_in252", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTC_LANE1X, 255, "csiportc_lane1x", NULL, NULL,
			"cpi_data11", NULL, NULL, "gpio8_in255", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTC_LANE1Y, 254, "csiportc_lane1y", NULL, NULL,
			"cpi_data10", NULL, NULL, "gpio8_in254", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE0X, 246, "csiportb_lane0x", NULL, NULL,
			NULL, "cpi_data12", NULL, "gpio8_in246", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE0Y, 247, "csiportb_lane0y", NULL, NULL,
			NULL, "cpi_data13", NULL, "gpio8_in247", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE1X, 249, "csiportb_lane1x", NULL, NULL,
			NULL, "cpi_data15", NULL, "gpio8_in249", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE1Y, 248, "csiportb_lane1y", NULL, NULL,
			NULL, "cpi_data14", NULL, "gpio8_in248", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE2X, 251, "csiportb_lane2x", NULL, NULL,
			NULL, "cpi_vsyncin", NULL, "gpio8_in251",
			"safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTB_LANE2Y, 250, "csiportb_lane2y", NULL, NULL,
			NULL, "cpi_hsyncin", NULL, "gpio8_in250",
			"safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE0X, 236, "csiporta_lane0x", NULL, NULL,
			"cpi_pclk", NULL, NULL, "gpio8_in236", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE0Y, 237, "csiporta_lane0y", NULL, NULL,
			"cpi_wen", NULL, NULL, "gpio8_in237", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE1X, 239, "csiporta_lane1x", NULL, NULL,
			"cpi_data1", NULL, NULL, "gpio8_in239", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE1Y, 238, "csiporta_lane1y", NULL, NULL,
			"cpi_data0", NULL, NULL, "gpio8_in238", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE2X, 241, "csiporta_lane2x", NULL, NULL,
			"cpi_data3", NULL, NULL, "gpio8_in241", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE2Y, 240, "csiporta_lane2y", NULL, NULL,
			"cpi_data2", NULL, NULL, "gpio8_in240", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE3X, 242, "csiporta_lane3x", NULL, NULL,
			"cpi_data4", NULL, NULL, "gpio8_in242", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE3Y, 243, "csiporta_lane3y", NULL, NULL,
			"cpi_data5", NULL, NULL, "gpio8_in243", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE4X, 244, "csiporta_lane4x", NULL, NULL,
			"cpi_data6", NULL, NULL, "gpio8_in244", "safe_mode"),
	_OMAP5_MUXENTRY(CSIPORTA_LANE4Y, 245, "csiporta_lane4y", NULL, NULL,
			"cpi_data7", NULL, NULL, "gpio8_in245", "safe_mode"),
	_OMAP5_MUXENTRY(CAM_SHUTTER, 224, "cam_shutter", NULL, NULL, NULL, NULL,
			"sys_nodeid0", "gpio8_224", "safe_mode"),
	_OMAP5_MUXENTRY(CAM_STROBE, 225, "cam_strobe", NULL, NULL, NULL, NULL,
			"sys_nodeid1", "gpio8_225", "safe_mode"),
	_OMAP5_MUXENTRY(CAM_GLOBALRESET, 226, "cam_globalreset", NULL, NULL,
			"cpi_fid", NULL, NULL, "gpio8_226", "safe_mode"),
	_OMAP5_MUXENTRY(TIMER11_PWM_EVT, 227, "timer11_pwm_evt", NULL, NULL,
			"cpi_data12", NULL, "hw_dbg26", "gpio8_227",
			"safe_mode"),
	_OMAP5_MUXENTRY(TIMER5_PWM_EVT, 228, "timer5_pwm_evt", NULL, NULL,
			"cpi_data13", NULL, NULL, "gpio8_228", "safe_mode"),
	_OMAP5_MUXENTRY(TIMER6_PWM_EVT, 229, "timer6_pwm_evt", NULL, NULL,
			"cpi_data14", NULL, NULL, "gpio8_229", "safe_mode"),
	_OMAP5_MUXENTRY(TIMER8_PWM_EVT, 230, "timer8_pwm_evt", NULL, NULL,
			"cpi_data15", NULL, "hw_dbg27", "gpio8_230",
			"safe_mode"),
	_OMAP5_MUXENTRY(I2C3_SCL, 231, "i2c3_scl", NULL, NULL, NULL, NULL, NULL,
			"gpio8_231", "safe_mode"),
	_OMAP5_MUXENTRY(I2C3_SDA, 232, "i2c3_sda", NULL, NULL, NULL, NULL, NULL,
			"gpio8_232", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO8_233, 233, "gpio8_233", "sys_secure_indicator",
			"timer8_pwm_evt", "cpi_hsync", NULL, NULL,
			"gpio8_233", "safe_mode"),
	_OMAP5_MUXENTRY(GPIO8_234, 234, "gpio8_234", "sys_drm_msecure", NULL,
			"cpi_vsync", NULL, NULL, "gpio8_234", "safe_mode"),
	_OMAP5_MUXENTRY(ABE_CLKS, 96, "abe_clks", NULL, NULL, NULL, NULL, NULL,
			"gpio4_96", "safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_DIN1, 97, "abedmic_din1", NULL, NULL, NULL,
			"abemcbsp3_fsx", NULL, "gpio4_97", "safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_DIN2, 98, "abedmic_din2", NULL, NULL, NULL,
			"abemcbsp3_dx", NULL, "gpio4_98", "safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_DIN3, 99, "abedmic_din3", NULL, NULL, NULL,
			"abemcbsp3_dr", NULL, "gpio4_99", "safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_CLK1, 100, "abedmic_clk1", NULL, NULL, NULL,
			"abemcbsp3_clkx", NULL, "gpio4_100", "safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_CLK2, 101, "abedmic_clk2", "abemcbsp1_fsx",
			NULL, "abemcasp_amutein", NULL, NULL, "gpio4_101",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEDMIC_CLK3, 102, "abedmic_clk3", "abemcbsp1_dx", NULL,
			"abemcasp_aclkx", NULL, NULL, "gpio4_102",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABESLIMBUS1_CLOCK, 103, "abeslimbus1_clock",
			"abemcbsp1_clkx", NULL, NULL, NULL, NULL, "gpio4_103",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABESLIMBUS1_DATA, 104, "abeslimbus1_data",
			"abemcbsp1_dr", NULL, NULL, NULL, NULL, "gpio4_104",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCBSP2_DR, 105, "abemcbsp2_dr", NULL, NULL,
			"abemcasp_axr", NULL, NULL, "gpio4_105", "safe_mode"),
	_OMAP5_MUXENTRY(ABEMCBSP2_DX, 106, "abemcbsp2_dx", NULL, NULL,
			"abemcasp_amuteout", NULL, NULL, "gpio4_106",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCBSP2_FSX, 107, "abemcbsp2_fsx", NULL, NULL,
			"abemcasp_afsx", NULL, NULL, "gpio4_107",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCBSP2_CLKX, 108, "abemcbsp2_clkx", NULL, NULL,
			"abemcasp_ahclkx", NULL, NULL, "gpio4_108",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCPDM_UL_DATA, 109, "abemcpdm_ul_data",
			"abemcbsp3_dr", NULL, NULL, NULL, NULL, "gpio4_109",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCPDM_DL_DATA, 110, "abemcpdm_dl_data",
			"abemcbsp3_dx", NULL, NULL, NULL, NULL, "gpio4_110",
			"safe_mode"),
	_OMAP5_MUXENTRY(ABEMCPDM_FRAME, 111, "abemcpdm_frame", "abemcbsp3_clkx",
			NULL, NULL, NULL, NULL, "gpio4_111", "safe_mode"),
	_OMAP5_MUXENTRY(ABEMCPDM_LB_CLK, 112, "abemcpdm_lb_clk",
			"abemcbsp3_fsx", NULL, NULL, NULL, NULL, "gpio4_112",
			"safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_CLK, 128, "wlsdio_clk", "mcspi4_clk", NULL, NULL,
			NULL, NULL, "gpio5_128", "safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_CMD, 129, "wlsdio_cmd", NULL, NULL, NULL, NULL,
			NULL, "gpio5_129", "safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_DATA0, 130, "wlsdio_data0", "mcspi4_simo", NULL,
			NULL, NULL, NULL, "gpio5_130", "safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_DATA1, 131, "wlsdio_data1", "mcspi4_somi", NULL,
			NULL, NULL, NULL, "gpio5_131", "safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_DATA2, 132, "wlsdio_data2", "mcspi4_cs0", NULL,
			NULL, NULL, NULL, "gpio5_132", "safe_mode"),
	_OMAP5_MUXENTRY(WLSDIO_DATA3, 133, "wlsdio_data3", NULL, NULL, NULL,
			NULL, NULL, "gpio5_133", "safe_mode"),
	_OMAP5_MUXENTRY(UART5_RX, 134, "uart5_rx", NULL, NULL, NULL,
			"sdio4_data1", "hw_dbg28", "gpio5_134", "safe_mode"),
	_OMAP5_MUXENTRY(UART5_TX, 135, "uart5_tx", NULL, NULL, NULL,
			"sdio4_data2", "hw_dbg29", "gpio5_135", "safe_mode"),
	_OMAP5_MUXENTRY(UART5_CTS, 136, "uart5_cts", NULL, NULL, NULL,
			"sdio4_data0", "hw_dbg30", "gpio5_136", "safe_mode"),
	_OMAP5_MUXENTRY(UART5_RTS, 137, "uart5_rts", NULL, NULL, NULL,
			"sdio4_data3", "hw_dbg31", "gpio5_137", "safe_mode"),
	_OMAP5_MUXENTRY(I2C2_SCL, 138, "i2c2_scl", NULL, NULL, NULL, NULL, NULL,
			"gpio5_138", "safe_mode"),
	_OMAP5_MUXENTRY(I2C2_SDA, 139, "i2c2_sda", NULL, NULL, NULL, NULL, NULL,
			"gpio5_139", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI1_CLK, 140, "mcspi1_clk", NULL, NULL, NULL, NULL,
			"usbd0_ulpiphy_clk", "gpio5_140", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI1_SOMI, 141, "mcspi1_somi", NULL, NULL, NULL, NULL,
			"usbd0_ulpiphy_nxt", "gpio5_141", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI1_SIMO, 142, "mcspi1_simo", NULL, NULL, NULL, NULL,
			"usbd0_ulpiphy_dir", "gpio5_142", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI1_CS0, 143, "mcspi1_cs0", NULL, NULL, NULL, NULL,
			"usbd0_ulpiphy_data0", "gpio5_143", "safe_mode"),
	_OMAP5_MUXENTRY(MCSPI1_CS1, 144, "mcspi1_cs1", NULL, NULL, NULL, NULL,
			"usbd0_ulpiphy_data1", "gpio5_144", "safe_mode"),
	_OMAP5_MUXENTRY(I2C5_SCL, 147, "i2c5_scl", NULL, "uart4_rx", NULL, NULL,
			NULL, "gpio5_147", "safe_mode"),
	_OMAP5_MUXENTRY(I2C5_SDA, 148, "i2c5_sda", NULL, "uart4_tx", NULL, NULL,
			NULL, "gpio5_148", "safe_mode"),
	_OMAP5_MUXENTRY(PERSLIMBUS2_CLOCK, 145, "perslimbus2_clock",
			"mcspi1_cs2", "uart4_cts", "sdio5_clk", NULL,
			"usbd0_ulpiphy_data2", "gpio5_145", "safe_mode"),
	_OMAP5_MUXENTRY(PERSLIMBUS2_DATA, 146, "perslimbus2_data", "mcspi1_cs3",
			"uart4_rts", "sdio5_cmd", NULL,
			"usbd0_ulpiphy_data3", "gpio5_146", "safe_mode"),
	_OMAP5_MUXENTRY(UART6_TX, 149, "uart6_tx", NULL, NULL, "sdio5_data3",
			"usbb2_mm_rxdp", NULL, "gpio5_149", "safe_mode"),
	_OMAP5_MUXENTRY(UART6_RX, 150, "uart6_rx", NULL, NULL, "sdio5_data2",
			"usbb2_mm_rxdm", NULL, "gpio5_150", "safe_mode"),
	_OMAP5_MUXENTRY(UART6_CTS, 151, "uart6_cts", NULL, NULL, "sdio5_data1",
			"usbb2_mm_rxrcv", NULL, "gpio5_151", "safe_mode"),
	_OMAP5_MUXENTRY(UART6_RTS, 152, "uart6_rts", NULL, NULL, "sdio5_data0",
			"usbb2_mm_txse0", "usbd0_ulpiphy_stp", "gpio5_152",
			"safe_mode"),
	_OMAP5_MUXENTRY(UART3_CTS_RCTX, 153, "uart3_cts_rctx", "sata_actled",
			NULL, "sdio5_data7", "usbb2_mm_txen",
			"usbd0_ulpiphy_data4", "gpio5_153", "safe_mode"),
	_OMAP5_MUXENTRY(UART3_RTS_IRSD, 154, "uart3_rts_irsd", "hdq_sio", NULL,
			"sdio5_data6", "usbb2_mm_txdat",
			"usbd0_ulpiphy_data5", "gpio5_154", "safe_mode"),
	_OMAP5_MUXENTRY(UART3_TX_IRTX, 155, "uart3_tx_irtx", NULL, NULL,
			"sdio5_data5", "sdio4_clk", "usbd0_ulpiphy_data6",
			"gpio5_155", "safe_mode"),
	_OMAP5_MUXENTRY(UART3_RX_IRRX, 156, "uart3_rx_irrx", NULL, NULL,
			"sdio5_data4", "sdio4_cmd", "usbd0_ulpiphy_data7",
			"gpio5_156", "safe_mode"),
	_OMAP5_MUXENTRY(USBB3_HSIC_STROBE, 158, "usbb3_hsic_strobe", NULL, NULL,
			NULL, NULL, NULL, "gpio5_158", "safe_mode"),
	_OMAP5_MUXENTRY(USBB3_HSIC_DATA, 159, "usbb3_hsic_data", NULL, NULL,
			NULL, NULL, NULL, "gpio5_159", "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_CLK, 0, "sdcard_clk", NULL, NULL, "jtag_rtck",
			NULL, "drm_emu2", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_CMD, 0, "sdcard_cmd", NULL, NULL, "jtag_tdo",
			"uart6_rx", "drm_emu4", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_DATA2, 0, "sdcard_data2", NULL, NULL,
			"jtag_tmsc", NULL, "drm_emu3", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_DATA3, 0, "sdcard_data3", NULL, NULL,
			"jtag_tck", NULL, "drm_emu5", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_DATA0, 0, "sdcard_data0", NULL, NULL,
			"jtag_tdi", NULL, "drm_emu0", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SDCARD_DATA1, 0, "sdcard_data1", NULL, NULL,
			"jtag_ntrst", NULL, "drm_emu1", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(USBD0_HS_DP, 0, "usbd0_hs_dp", NULL, NULL, NULL,
			"uart3_rx_irrx", NULL, NULL, "safe_mode"),
	_OMAP5_MUXENTRY(USBD0_HS_DM, 0, "usbd0_hs_dm", NULL, NULL, NULL,
			"uart3_tx_irtx", NULL, NULL, "safe_mode"),
	_OMAP5_MUXENTRY(I2C1_PMIC_SCL, 0, "i2c1_pmic_scl", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(I2C1_PMIC_SDA, 0, "i2c1_pmic_sda", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(USBD0_SS_RX, 0, "usbd0_ss_rx", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Balls for 44XX CBL package
 * 547-pin CBL ES1.0 S-FPGA-N547, 0.40mm Ball Pitch (Top),
 * 0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBL)
struct omap_ball __initdata omap5_core_cbl_ball[] = {
	_OMAP5_BALLENTRY(EMMC_CLK, "al2", NULL),
	_OMAP5_BALLENTRY(EMMC_CMD, "ak4", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA0, "ak3", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA1, "aj4", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA2, "ak2", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA3, "aj3", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA4, "ah2", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA5, "aj2", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA6, "ah3", NULL),
	_OMAP5_BALLENTRY(EMMC_DATA7, "ah4", NULL),
	_OMAP5_BALLENTRY(C2C_CLKOUT0, "e22", NULL),
	_OMAP5_BALLENTRY(C2C_CLKOUT1, "d22", NULL),
	_OMAP5_BALLENTRY(C2C_CLKIN0, "b22", NULL),
	_OMAP5_BALLENTRY(C2C_CLKIN1, "c22", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN0, "b21", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN1, "c21", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN2, "b20", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN3, "c20", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN4, "b19", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN5, "c19", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN6, "b18", NULL),
	_OMAP5_BALLENTRY(C2C_DATAIN7, "c18", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT0, "e26", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT1, "d26", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT2, "e25", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT3, "d25", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT4, "e24", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT5, "d24", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT6, "e23", NULL),
	_OMAP5_BALLENTRY(C2C_DATAOUT7, "d23", NULL),
	_OMAP5_BALLENTRY(C2C_DATA8, "e21", NULL),
	_OMAP5_BALLENTRY(C2C_DATA9, "d21", NULL),
	_OMAP5_BALLENTRY(C2C_DATA10, "e20", NULL),
	_OMAP5_BALLENTRY(C2C_DATA11, "d20", NULL),
	_OMAP5_BALLENTRY(C2C_DATA12, "e19", NULL),
	_OMAP5_BALLENTRY(C2C_DATA13, "d19", NULL),
	_OMAP5_BALLENTRY(C2C_DATA14, "e18", NULL),
	_OMAP5_BALLENTRY(C2C_DATA15, "d18", NULL),
	_OMAP5_BALLENTRY(LLIA_WAKEREQOUT, "c29", NULL),
	_OMAP5_BALLENTRY(LLIB_WAKEREQOUT, "e29", NULL),
	_OMAP5_BALLENTRY(HSI1_ACREADY, "e13", NULL),
	_OMAP5_BALLENTRY(HSI1_CAREADY, "e14", NULL),
	_OMAP5_BALLENTRY(HSI1_ACWAKE, "d13", NULL),
	_OMAP5_BALLENTRY(HSI1_CAWAKE, "e15", NULL),
	_OMAP5_BALLENTRY(HSI1_ACFLAG, "d15", NULL),
	_OMAP5_BALLENTRY(HSI1_ACDATA, "d14", NULL),
	_OMAP5_BALLENTRY(HSI1_CAFLAG, "d12", NULL),
	_OMAP5_BALLENTRY(HSI1_CADATA, "e12", NULL),
	_OMAP5_BALLENTRY(UART1_TX, "d10", NULL),
	_OMAP5_BALLENTRY(UART1_CTS, "e9", NULL),
	_OMAP5_BALLENTRY(UART1_RX, "d9", NULL),
	_OMAP5_BALLENTRY(UART1_RTS, "e10", NULL),
	_OMAP5_BALLENTRY(HSI2_CAREADY, "c7", NULL),
	_OMAP5_BALLENTRY(HSI2_ACREADY, "c10", NULL),
	_OMAP5_BALLENTRY(HSI2_CAWAKE, "b8", NULL),
	_OMAP5_BALLENTRY(HSI2_ACWAKE, "c8", NULL),
	_OMAP5_BALLENTRY(HSI2_CAFLAG, "b7", NULL),
	_OMAP5_BALLENTRY(HSI2_CADATA, "b10", NULL),
	_OMAP5_BALLENTRY(HSI2_ACFLAG, "b9", NULL),
	_OMAP5_BALLENTRY(HSI2_ACDATA, "c9", NULL),
	_OMAP5_BALLENTRY(UART2_RTS, "c5", NULL),
	_OMAP5_BALLENTRY(UART2_CTS, "b5", NULL),
	_OMAP5_BALLENTRY(UART2_RX, "c6", NULL),
	_OMAP5_BALLENTRY(UART2_TX, "b6", NULL),
	_OMAP5_BALLENTRY(USBB1_HSIC_STROBE, "b26", NULL),
	_OMAP5_BALLENTRY(USBB1_HSIC_DATA, "c26", NULL),
	_OMAP5_BALLENTRY(USBB2_HSIC_STROBE, "b25", NULL),
	_OMAP5_BALLENTRY(USBB2_HSIC_DATA, "c25", NULL),
	_OMAP5_BALLENTRY(TIMER10_PWM_EVT, "v30", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_TE0, "w30", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE0X, "y32", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE0Y, "y31", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE1X, "w32", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE1Y, "w31", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE2X, "v32", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE2Y, "v31", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE3X, "t32", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE3Y, "t31", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE4X, "r32", NULL),
	_OMAP5_BALLENTRY(DSIPORTA_LANE4Y, "r31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE0X, "af32", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE0Y, "af31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE1X, "ae32", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE1Y, "ae31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE2X, "ad32", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE2Y, "ad31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE3X, "ac32", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE3Y, "ac31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE4X, "ab32", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_LANE4Y, "ab31", NULL),
	_OMAP5_BALLENTRY(DSIPORTC_TE0, "ab29", NULL),
	_OMAP5_BALLENTRY(TIMER9_PWM_EVT, "ac29", NULL),
	_OMAP5_BALLENTRY(I2C4_SCL, "ak22", NULL),
	_OMAP5_BALLENTRY(I2C4_SDA, "aj20", NULL),
	_OMAP5_BALLENTRY(MCSPI2_CLK, "ak21", NULL),
	_OMAP5_BALLENTRY(MCSPI2_SIMO, "aj18", NULL),
	_OMAP5_BALLENTRY(MCSPI2_SOMI, "ak23", NULL),
	_OMAP5_BALLENTRY(MCSPI2_CS0, "ak20", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA15, "aj9", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA14, "al9", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA13, "am9", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA12, "aj8", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA11, "al6", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA10, "al5", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA9, "aj5", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA8, "ak5", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA7, "al10", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA6, "am10", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA5, "al8", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA4, "am8", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA3, "am7", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA2, "aj6", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA1, "al7", NULL),
	_OMAP5_BALLENTRY(RFBI_DATA0, "am6", NULL),
	_OMAP5_BALLENTRY(RFBI_WE, "ak8", NULL),
	_OMAP5_BALLENTRY(RFBI_CS0, "ak6", NULL),
	_OMAP5_BALLENTRY(RFBI_A0, "am5", NULL),
	_OMAP5_BALLENTRY(RFBI_RE, "ak9", NULL),
	_OMAP5_BALLENTRY(RFBI_HSYNC0, "ak7", NULL),
	_OMAP5_BALLENTRY(RFBI_TE_VSYNC0, "aj7", NULL),
	_OMAP5_BALLENTRY(GPIO6_182, "aj10", NULL),
	_OMAP5_BALLENTRY(GPIO6_183, "ak10", NULL),
	_OMAP5_BALLENTRY(GPIO6_184, "aj11", NULL),
	_OMAP5_BALLENTRY(GPIO6_185, "ak11", NULL),
	_OMAP5_BALLENTRY(GPIO6_186, "aj12", NULL),
	_OMAP5_BALLENTRY(GPIO6_187, "ak12", NULL),
	_OMAP5_BALLENTRY(HDMI_CEC, "ak25", NULL),
	_OMAP5_BALLENTRY(HDMI_HPD, "aj25", NULL),
	_OMAP5_BALLENTRY(HDMI_DDC_SCL, "ak24", NULL),
	_OMAP5_BALLENTRY(HDMI_DDC_SDA, "aj24", NULL),
	_OMAP5_BALLENTRY(CSIPORTC_LANE0X, "k2", NULL),
	_OMAP5_BALLENTRY(CSIPORTC_LANE0Y, "k3", NULL),
	_OMAP5_BALLENTRY(CSIPORTC_LANE1X, "j2", NULL),
	_OMAP5_BALLENTRY(CSIPORTC_LANE1Y, "j3", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE0X, "v3", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE0Y, "v2", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE1X, "w3", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE1Y, "w2", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE2X, "y3", NULL),
	_OMAP5_BALLENTRY(CSIPORTB_LANE2Y, "y2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE0X, "r2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE0Y, "r3", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE1X, "p2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE1Y, "p3", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE2X, "n2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE2Y, "n3", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE3X, "m2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE3Y, "m3", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE4X, "l2", NULL),
	_OMAP5_BALLENTRY(CSIPORTA_LANE4Y, "l3", NULL),
	_OMAP5_BALLENTRY(CAM_SHUTTER, "ad3", NULL),
	_OMAP5_BALLENTRY(CAM_STROBE, "ad4", NULL),
	_OMAP5_BALLENTRY(CAM_GLOBALRESET, "ad2", NULL),
	_OMAP5_BALLENTRY(TIMER11_PWM_EVT, "af3", NULL),
	_OMAP5_BALLENTRY(TIMER5_PWM_EVT, "af2", NULL),
	_OMAP5_BALLENTRY(TIMER6_PWM_EVT, "ae3", NULL),
	_OMAP5_BALLENTRY(TIMER8_PWM_EVT, "ae2", NULL),
	_OMAP5_BALLENTRY(I2C3_SCL, "ab3", NULL),
	_OMAP5_BALLENTRY(I2C3_SDA, "ab2", NULL),
	_OMAP5_BALLENTRY(GPIO8_233, "ac2", NULL),
	_OMAP5_BALLENTRY(GPIO8_234, "ac3", NULL),
	_OMAP5_BALLENTRY(ABE_CLKS, "n30", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_DIN1, "r30", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_DIN2, "p32", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_DIN3, "p31", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_CLK1, "p29", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_CLK2, "p30", NULL),
	_OMAP5_BALLENTRY(ABEDMIC_CLK3, "n29", NULL),
	_OMAP5_BALLENTRY(ABESLIMBUS1_CLOCK, "t30", NULL),
	_OMAP5_BALLENTRY(ABESLIMBUS1_DATA, "t29", NULL),
	_OMAP5_BALLENTRY(ABEMCBSP2_DR, "n31", NULL),
	_OMAP5_BALLENTRY(ABEMCBSP2_DX, "n32", NULL),
	_OMAP5_BALLENTRY(ABEMCBSP2_FSX, "m31", NULL),
	_OMAP5_BALLENTRY(ABEMCBSP2_CLKX, "m32", NULL),
	_OMAP5_BALLENTRY(ABEMCPDM_UL_DATA, "m29", NULL),
	_OMAP5_BALLENTRY(ABEMCPDM_DL_DATA, "m30", NULL),
	_OMAP5_BALLENTRY(ABEMCPDM_FRAME, "l30", NULL),
	_OMAP5_BALLENTRY(ABEMCPDM_LB_CLK, "l29", NULL),
	_OMAP5_BALLENTRY(WLSDIO_CLK, "ak29", NULL),
	_OMAP5_BALLENTRY(WLSDIO_CMD, "aj29", NULL),
	_OMAP5_BALLENTRY(WLSDIO_DATA0, "aj30", NULL),
	_OMAP5_BALLENTRY(WLSDIO_DATA1, "ak30", NULL),
	_OMAP5_BALLENTRY(WLSDIO_DATA2, "aj31", NULL),
	_OMAP5_BALLENTRY(WLSDIO_DATA3, "ak31", NULL),
	_OMAP5_BALLENTRY(UART5_RX, "ad30", NULL),
	_OMAP5_BALLENTRY(UART5_TX, "ae29", NULL),
	_OMAP5_BALLENTRY(UART5_CTS, "ae30", NULL),
	_OMAP5_BALLENTRY(UART5_RTS, "ad29", NULL),
	_OMAP5_BALLENTRY(I2C2_SCL, "af30", NULL),
	_OMAP5_BALLENTRY(I2C2_SDA, "af29", NULL),
	_OMAP5_BALLENTRY(MCSPI1_CLK, "ah32", NULL),
	_OMAP5_BALLENTRY(MCSPI1_SOMI, "ag32", NULL),
	_OMAP5_BALLENTRY(MCSPI1_SIMO, "ah31", NULL),
	_OMAP5_BALLENTRY(MCSPI1_CS0, "ag31", NULL),
	_OMAP5_BALLENTRY(MCSPI1_CS1, "ah30", NULL),
	_OMAP5_BALLENTRY(I2C5_SCL, "al32", NULL),
	_OMAP5_BALLENTRY(I2C5_SDA, "al31", NULL),
	_OMAP5_BALLENTRY(PERSLIMBUS2_CLOCK, "aj32", NULL),
	_OMAP5_BALLENTRY(PERSLIMBUS2_DATA, "ak32", NULL),
	_OMAP5_BALLENTRY(UART6_TX, "aj27", NULL),
	_OMAP5_BALLENTRY(UART6_RX, "aj26", NULL),
	_OMAP5_BALLENTRY(UART6_CTS, "ak26", NULL),
	_OMAP5_BALLENTRY(UART6_RTS, "ak27", NULL),
	_OMAP5_BALLENTRY(UART3_CTS_RCTX, "aj28", NULL),
	_OMAP5_BALLENTRY(UART3_RTS_IRSD, "ak28", NULL),
	_OMAP5_BALLENTRY(UART3_TX_IRTX, "al28", NULL),
	_OMAP5_BALLENTRY(UART3_RX_IRRX, "am28", NULL),
	_OMAP5_BALLENTRY(USBB3_HSIC_STROBE, "d29", NULL),
	_OMAP5_BALLENTRY(USBB3_HSIC_DATA, "d30", NULL),
	_OMAP5_BALLENTRY(SDCARD_CLK, "e3", NULL),
	_OMAP5_BALLENTRY(SDCARD_CMD, "e2", NULL),
	_OMAP5_BALLENTRY(SDCARD_DATA2, "f2", NULL),
	_OMAP5_BALLENTRY(SDCARD_DATA3, "f3", NULL),
	_OMAP5_BALLENTRY(SDCARD_DATA0, "g3", NULL),
	_OMAP5_BALLENTRY(SDCARD_DATA1, "g2", NULL),
	_OMAP5_BALLENTRY(USBD0_HS_DP, "am20", NULL),
	_OMAP5_BALLENTRY(USBD0_HS_DM, "al20", NULL),
	_OMAP5_BALLENTRY(I2C1_PMIC_SCL, "k29", NULL),
	_OMAP5_BALLENTRY(I2C1_PMIC_SDA, "h30", NULL),
	_OMAP5_BALLENTRY(USBD0_SS_RX, "am22", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap5_core_cbl_ball  NULL
#endif

/*
 * Superset of all mux modes for omap5
 */
static struct omap_mux __initdata omap5_wkup_muxmodes[] = {
	_OMAP5_MUXENTRY(LLIA_WAKEREQIN, 14, "llia_wakereqin", "c2c_wakereqin",
			NULL, NULL, NULL, "hw_wkdbg14", "gpio1_wk14",
			"safe_mode"),
	_OMAP5_MUXENTRY(LLIB_WAKEREQIN, 15, "llib_wakereqin", "sys_c2c_pwkup",
			NULL, NULL, NULL, "hw_wkdbg13", "gpio1_wk15",
			"safe_mode"),
	_OMAP5_MUXENTRY(DRM_EMU0, 6, "drm_emu0", NULL, NULL, NULL, NULL,
			"hw_wkdbg6", "gpio1_wk6", "safe_mode"),
	_OMAP5_MUXENTRY(DRM_EMU1, 7, "drm_emu1", NULL, NULL, NULL, NULL,
			"hw_wkdbg7", "gpio1_wk7", "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_NTRST, 0, "jtag_ntrst", NULL, NULL, NULL, NULL,
			NULL, NULL, "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_TCK, 0, "jtag_tck", NULL, NULL, NULL, NULL, NULL,
			NULL, "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_RTCK, 0, "jtag_rtck", NULL, NULL, NULL, NULL,
			NULL, NULL, "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_TMSC, 0, "jtag_tmsc", NULL, NULL, NULL, NULL,
			NULL, NULL, "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_TDI, 0, "jtag_tdi", NULL, NULL, NULL, NULL, NULL,
			NULL, "safe_mode"),
	_OMAP5_MUXENTRY(JTAG_TDO, 0, "jtag_tdo", NULL, NULL, NULL, NULL, NULL,
			NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SYS_32K, 0, "sys_32k", NULL, NULL, NULL, NULL, NULL,
			NULL, NULL),
	_OMAP5_MUXENTRY(FREF_CLK_IOREQ, 13, "fref_clk_ioreq", NULL, NULL, NULL,
			NULL, NULL, "gpio1_wk13", "safe_mode"),
	_OMAP5_MUXENTRY(FREF_CLK0_OUT, 12, "fref_clk0_out", NULL, NULL, NULL,
			NULL, "hw_wkdbg9", "gpio1_wk12", "safe_mode"),
	_OMAP5_MUXENTRY(FREF_CLK1_OUT, 11, "fref_clk1_out", NULL, NULL, NULL,
			NULL, "hw_wkdbg5", "gpio1_wk11", "safe_mode"),
	_OMAP5_MUXENTRY(FREF_CLK2_OUT, 10, "fref_clk2_out", NULL, NULL, NULL,
			NULL, "hw_wkdbg10", "gpio1_wk10", "safe_mode"),
	_OMAP5_MUXENTRY(FREF_CLK2_REQ, 9, "fref_clk2_req", "fref_clk3_out",
			NULL, "sys_ndmareq0", NULL, "hw_wkdbg11", "gpio1_wk9",
			"safe_mode"),
	_OMAP5_MUXENTRY(FREF_CLK1_REQ, 8, "fref_clk1_req", NULL, NULL,
			"sys_ndmareq1", NULL, "hw_wkdbg12", "gpio1_wk8",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_NRESPWRON, 0, "sys_nrespwron", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SYS_NRESWARM, 0, "sys_nreswarm", NULL, NULL, NULL,
			NULL, NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SYS_PWR_REQ, 0, "sys_pwr_req", NULL, NULL, NULL, NULL,
			"hw_wkdbg15", NULL, "safe_mode"),
	_OMAP5_MUXENTRY(SYS_NIRQ1, 0, "sys_nirq1", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SYS_NIRQ2, 0, "sys_nirq2", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SR_PMIC_SCL, 0, "sr_pmic_scl", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SR_PMIC_SDA, 0, "sr_pmic_sda", NULL, NULL, NULL, NULL,
			NULL, NULL, NULL),
	_OMAP5_MUXENTRY(SYS_BOOT0, 0, "sys_boot0", NULL, NULL, NULL,
			"drm_emu15", "hw_wkdbg0", "gpio1_wkout0",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_BOOT1, 1, "sys_boot1", NULL, NULL, NULL,
			"drm_emu16", "hw_wkdbg1", "gpio1_wkout1",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_BOOT2, 2, "sys_boot2", NULL, NULL, NULL,
			"drm_emu17", "hw_wkdbg2", "gpio1_wkout2",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_BOOT3, 3, "sys_boot3", NULL, NULL, NULL,
			"drm_emu18", "hw_wkdbg3", "gpio1_wkout3",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_BOOT4, 4, "sys_boot4", NULL, NULL, NULL,
			"drm_emu19", "hw_wkdbg4", "gpio1_wkout4",
			"safe_mode"),
	_OMAP5_MUXENTRY(SYS_BOOT5, 5, "sys_boot5", "sys_aux_msecure", NULL,
			NULL, NULL, "hw_wkdbg8", "gpio1_wkout5", "safe_mode"),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};

/*
 * Balls for 44XX CBL package
 * 547-pin CBL ES1.0 S-FPGA-N547, 0.40mm Ball Pitch (Top),
 * 0.40mm Ball Pitch (Bottom)
 */
#if defined(CONFIG_OMAP_MUX) && defined(CONFIG_DEBUG_FS)		\
		&& defined(CONFIG_OMAP_PACKAGE_CBL)
struct omap_ball __initdata omap5_wkup_cbl_ball[] = {
	_OMAP5_BALLENTRY(LLIA_WAKEREQIN, "c30", NULL),
	_OMAP5_BALLENTRY(LLIB_WAKEREQIN, "e30", NULL),
	_OMAP5_BALLENTRY(DRM_EMU0, "b30", NULL),
	_OMAP5_BALLENTRY(DRM_EMU1, "b31", NULL),
	_OMAP5_BALLENTRY(JTAG_NTRST, "c32", NULL),
	_OMAP5_BALLENTRY(JTAG_TCK, "c31", NULL),
	_OMAP5_BALLENTRY(JTAG_RTCK, "a33", NULL),
	_OMAP5_BALLENTRY(JTAG_TMSC, "b32", NULL),
	_OMAP5_BALLENTRY(JTAG_TDI, "a32", NULL),
	_OMAP5_BALLENTRY(JTAG_TDO, "b33", NULL),
	_OMAP5_BALLENTRY(SYS_32K, "f32", NULL),
	_OMAP5_BALLENTRY(FREF_CLK_IOREQ, "h32", NULL),
	_OMAP5_BALLENTRY(FREF_CLK0_OUT, "f30", NULL),
	_OMAP5_BALLENTRY(FREF_CLK1_OUT, "g32", NULL),
	_OMAP5_BALLENTRY(FREF_CLK2_OUT, "g31", NULL),
	_OMAP5_BALLENTRY(FREF_CLK2_REQ, "g29", NULL),
	_OMAP5_BALLENTRY(FREF_CLK1_REQ, "g30", NULL),
	_OMAP5_BALLENTRY(SYS_NRESPWRON, "f31", NULL),
	_OMAP5_BALLENTRY(SYS_NRESWARM, "f29", NULL),
	_OMAP5_BALLENTRY(SYS_PWR_REQ, "l31", NULL),
	_OMAP5_BALLENTRY(SYS_NIRQ1, "k30", NULL),
	_OMAP5_BALLENTRY(SYS_NIRQ2, "j30", NULL),
	_OMAP5_BALLENTRY(SR_PMIC_SCL, "h29", NULL),
	_OMAP5_BALLENTRY(SR_PMIC_SDA, "j29", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT0, "j31", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT1, "k31", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT2, "l32", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT3, "k32", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT4, "j32", NULL),
	_OMAP5_BALLENTRY(SYS_BOOT5, "h31", NULL),
	{ .reg_offset = OMAP_MUX_TERMINATOR },
};
#else
#define omap5_wkup_cbl_ball  NULL
#endif


int __init omap5_mux_init(struct omap_board_mux *board_subset,
	struct omap_board_mux *board_wkup_subset, int flags)
{
	struct omap_ball *package_balls_core, *package_balls_wkup;
	int ret;

	switch (flags & OMAP_PACKAGE_MASK) {
	case OMAP_PACKAGE_CBL:
		package_balls_core = omap5_core_cbl_ball;
		package_balls_wkup = omap5_wkup_cbl_ball;
		break;
	default:
		pr_err("mux: Unknown omap package, mux disabled\n");
		return -EINVAL;
	}

	ret = omap_mux_init("core", OMAP_MUX_GPIO_IN_MODE6,
			    OMAP5_CTRL_MODULE_PAD_CORE_MUX_PBASE,
			    OMAP5_CTRL_MODULE_PAD_CORE_MUX_SIZE,
			    omap5_core_muxmodes, NULL, board_subset,
			    package_balls_core);

	ret = omap_mux_init("wkup", OMAP_MUX_GPIO_IN_MODE6,
			    OMAP5_CTRL_MODULE_PAD_WKUP_MUX_PBASE,
			    OMAP5_CTRL_MODULE_PAD_WKUP_MUX_SIZE,
			    omap5_wkup_muxmodes, NULL, board_subset,
			    package_balls_wkup);

	return ret;
}
