#include "ad9889_macros.h"

#define ADI89_GET_CHIP_REVISION			adi_get_i2c_reg(AD9889_ADDRESS,0x0, 0xff, 0)
#define ADI89_GET_N_HIGH_BYTE			adi_get_i2c_reg(AD9889_ADDRESS,0x1, 0xf, 0)
#define ADI89_SET_N_HIGH_BYTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x1, 0xf, 0, val)
#define ADI89_GET_N_MID_BYTE			adi_get_i2c_reg(AD9889_ADDRESS,0x2, 0xff, 0)
#define ADI89_SET_N_MID_BYTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x2, 0xff, 0, val)
#define ADI89_GET_N_LOW_BYTE			adi_get_i2c_reg(AD9889_ADDRESS,0x3, 0xff, 0)
#define ADI89_SET_N_LOW_BYTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3, 0xff, 0, val)
#define ADI89_GET_SPDIF_SF			adi_get_i2c_reg(AD9889_ADDRESS,0x4, 0xf0, 4)
#define ADI89_GET_INT_CTS_HIGH_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x4, 0xf, 0)
#define ADI89_GET_INT_CTS_MID_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x5, 0xff, 0)
#define ADI89_GET_INT_CTS_LOW_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x6, 0xff, 0)
#define ADI89_GET_EXT_CTS_HIGH_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x7, 0xf, 0)
#define ADI89_SET_EXT_CTS_HIGH_BYTE(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x7, 0xf, 0, val)
#define ADI89_GET_EXT_CTS_MID_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x8, 0xff, 0)
#define ADI89_SET_EXT_CTS_MID_BYTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8, 0xff, 0, val)
#define ADI89_GET_EXT_CTS_LOW_BYTE		adi_get_i2c_reg(AD9889_ADDRESS,0x9, 0xff, 0)
#define ADI89_SET_EXT_CTS_LOW_BYTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9, 0xff, 0, val)
#define ADI89_GET_CTS_SEL			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x80, 7)
#define ADI89_SET_CTS_SEL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x80, 7, val)
#define ADI89_GET_AVE_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x60, 5)
#define ADI89_SET_AVE_MODE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x60, 5, val)
#define ADI89_GET_AUDIO_SEL			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x10, 4)
#define ADI89_SET_AUDIO_SEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x10, 4, val)
#define ADI89_GET_MCLK_ON_SPDIF			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x8, 3)
#define ADI89_SET_MCLK_ON_SPDIF(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x8, 3, val)
#define ADI89_GET_MCLK_ON_I2S			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x4, 2)
#define ADI89_SET_MCLK_ON_I2S(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x4, 2, val)
#define ADI89_GET_MCLK_RATIO			adi_get_i2c_reg(AD9889_ADDRESS,0xa, 0x3, 0)
#define ADI89_SET_MCLK_RATIO(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa, 0x3, 0, val)
#define ADI89_GET_MCLK_POL			adi_get_i2c_reg(AD9889_ADDRESS,0xb, 0x40, 6)
#define ADI89_SET_MCLK_POL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xb, 0x40, 6, val)
#define ADI89_GET_FLAT_LINE			adi_get_i2c_reg(AD9889_ADDRESS,0xb, 0x20, 5)
#define ADI89_SET_FLAT_LINE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xb, 0x20, 5, val)
#define ADI89_GET_DELTA				adi_get_i2c_reg(AD9889_ADDRESS,0xb, 0x18, 3)
#define ADI89_SET_DELTA(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xb, 0x18, 3, val)
#define ADI89_GET_P_RANGE			adi_get_i2c_reg(AD9889_ADDRESS,0xb, 0x6, 1)
#define ADI89_SET_P_RANGE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xb, 0x6, 1, val)
#define ADI89_GET_I2S3_ENABLE			adi_get_i2c_reg(AD9889_ADDRESS,0xc, 0x20, 5)
#define ADI89_SET_I2S3_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc, 0x20, 5, val)
#define ADI89_GET_I2S2_ENABLE			adi_get_i2c_reg(AD9889_ADDRESS,0xc, 0x10, 4)
#define ADI89_SET_I2S2_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc, 0x10, 4, val)
#define ADI89_GET_I2S1_ENABLE			adi_get_i2c_reg(AD9889_ADDRESS,0xc, 0x8, 3)
#define ADI89_SET_I2S1_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc, 0x8, 3, val)
#define ADI89_GET_I2S0_ENABLE			adi_get_i2c_reg(AD9889_ADDRESS,0xc, 0x4, 2)
#define ADI89_SET_I2S0_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc, 0x4, 2, val)
#define ADI89_GET_I2S_FORMAT			adi_get_i2c_reg(AD9889_ADDRESS,0xc, 0x3, 0)
#define ADI89_SET_I2S_FORMAT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc, 0x3, 0, val)
#define ADI89_GET_I2S_BIT_WIDTH			adi_get_i2c_reg(AD9889_ADDRESS,0xd, 0x1f, 0)
#define ADI89_SET_I2S_BIT_WIDTH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xd, 0x1f, 0, val)
#define ADI89_GET_SUBPKT0_L_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0xe, 0x38, 3)
#define ADI89_SET_SUBPKT0_L_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xe, 0x38, 3, val)
#define ADI89_GET_SUBPKT0_R_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0xe, 0x7, 0)
#define ADI89_SET_SUBPKT0_R_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xe, 0x7, 0, val)
#define ADI89_GET_SUBPKT1_L_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0xf, 0x38, 3)
#define ADI89_SET_SUBPKT1_L_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xf, 0x38, 3, val)
#define ADI89_GET_SUBPKT1_R_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0xf, 0x7, 0)
#define ADI89_SET_SUBPKT1_R_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xf, 0x7, 0, val)
#define ADI89_GET_SUBPKT2_L_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0x10, 0x38, 3)
#define ADI89_SET_SUBPKT2_L_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x10, 0x38, 3, val)
#define ADI89_GET_SUBPKT2_R_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0x10, 0x7, 0)
#define ADI89_SET_SUBPKT2_R_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x10, 0x7, 0, val)
#define ADI89_GET_SUBPKT3_L_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0x11, 0x38, 3)
#define ADI89_SET_SUBPKT3_L_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x11, 0x38, 3, val)
#define ADI89_GET_SUBPKT3_R_SRC			adi_get_i2c_reg(AD9889_ADDRESS,0x11, 0x7, 0)
#define ADI89_SET_SUBPKT3_R_SRC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x11, 0x7, 0, val)
#define ADI89_GET_CR_BIT			adi_get_i2c_reg(AD9889_ADDRESS,0x12, 0x20, 5)
#define ADI89_SET_CR_BIT(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x12, 0x20, 5, val)
#define ADI89_GET_A_INFO			adi_get_i2c_reg(AD9889_ADDRESS,0x12, 0x1c, 2)
#define ADI89_SET_A_INFO(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x12, 0x1c, 2, val)
#define ADI89_GET_CLK_ACC			adi_get_i2c_reg(AD9889_ADDRESS,0x12, 0x3, 0)
#define ADI89_SET_CLK_ACC(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x12, 0x3, 0, val)
#define ADI89_GET_CATEGORY_CODE			adi_get_i2c_reg(AD9889_ADDRESS,0x13, 0xff, 0)
#define ADI89_SET_CATEGORY_CODE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x13, 0xff, 0, val)
#define ADI89_GET_SOURCE_NUMBER			adi_get_i2c_reg(AD9889_ADDRESS,0x14, 0xf0, 4)
#define ADI89_SET_SOURCE_NUMBER(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x14, 0xf0, 4, val)
#define ADI89_GET_WORD_LENGTH			adi_get_i2c_reg(AD9889_ADDRESS,0x14, 0xf, 0)
#define ADI89_SET_WORD_LENGTH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x14, 0xf, 0, val)
#define ADI89_GET_I2S_SF			adi_get_i2c_reg(AD9889_ADDRESS,0x15, 0xf0, 4)
#define ADI89_SET_I2S_SF(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x15, 0xf0, 4, val)
#define ADI89_GET_VFE_INPUT_ID			adi_get_i2c_reg(AD9889_ADDRESS,0x15, 0xe, 1)
#define ADI89_SET_VFE_INPUT_ID(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x15, 0xe, 1, val)
#define ADI89_GET_LOW_FRQ_VIDEO			adi_get_i2c_reg(AD9889_ADDRESS,0x15, 0x1, 0)
#define ADI89_SET_LOW_FRQ_VIDEO(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x15, 0x1, 0, val)
#define ADI89_GET_VFE_OUT_FMT			adi_get_i2c_reg(AD9889_ADDRESS,0x16, 0xc0, 6)
#define ADI89_SET_VFE_OUT_FMT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x16, 0xc0, 6, val)
#define ADI89_GET_VFE_422_WIDTH			adi_get_i2c_reg(AD9889_ADDRESS,0x16, 0x30, 4)
#define ADI89_SET_VFE_422_WIDTH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x16, 0x30, 4, val)
#define ADI89_GET_VFE_INPUT_STYLE		adi_get_i2c_reg(AD9889_ADDRESS,0x16, 0xc, 2)
#define ADI89_SET_VFE_INPUT_STYLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x16, 0xc, 2, val)
#define ADI89_GET_VFE_INPUT_EDGE		adi_get_i2c_reg(AD9889_ADDRESS,0x16, 0x2, 1)
#define ADI89_SET_VFE_INPUT_EDGE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x16, 0x2, 1, val)
#define ADI89_GET_VFE_INPUT_CS			adi_get_i2c_reg(AD9889_ADDRESS,0x16, 0x1, 0)
#define ADI89_SET_VFE_INPUT_CS(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x16, 0x1, 0, val)
#define ADI89_GET_ITU_ERROR_CORRECT_EN		adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x80, 7)
#define ADI89_SET_ITU_ERROR_CORRECT_EN(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x80, 7, val)
#define ADI89_GET_ITU_VSYNC_POL			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x40, 6)
#define ADI89_SET_ITU_VSYNC_POL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x40, 6, val)
#define ADI89_GET_ITU_HYSNC_POL			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x20, 5)
#define ADI89_SET_ITU_HYSNC_POL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x20, 5, val)
#define ADI89_GET_CSC_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x18, 3)
#define ADI89_SET_CSC_MODE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x18, 3, val)
#define ADI89_GET_GEN_444_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x4, 2)
#define ADI89_SET_GEN_444_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x4, 2, val)
#define ADI89_GET_ASP_RATIO			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x2, 1)
#define ADI89_SET_ASP_RATIO(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x2, 1, val)
#define ADI89_GET_DEGEN_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x17, 0x1, 0)
#define ADI89_SET_DEGEN_EN(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x17, 0x1, 0, val)
#define ADI89_GET_CSC_COEFF_A1			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x18, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_A1(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x18, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_A2			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x1a, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_A2(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x1a, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_A3			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x1c, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_A3(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x1c, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_A4			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x1e, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_A4(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x1e, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_B1			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x20, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_B1(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x20, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_B2			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x22, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_B2(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x22, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_B3			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x24, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_B3(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x24, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_B4			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x26, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_B4(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x26, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_C1			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x28, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_C1(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x28, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_C2			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x2a, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_C2(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x2a, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_C3			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x2c, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_C3(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x2c, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_CSC_COEFF_C4			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x2e, 0x1f, 0xff, 0, 2)
#define ADI89_SET_CSC_COEFF_C4(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x2e, 0x1f, 0xff, 0, 2, val)
#define ADI89_GET_VFE_HS_PLA			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0xff, 0xc0, 6, 2)
#define ADI89_SET_VFE_HS_PLA(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0xff, 0xc0, 6, 2, val)
#define ADI89_GET_VFE_HS_DUR			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0x3f, 0xf0, 4, 2)
#define ADI89_SET_VFE_HS_DUR(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0x3f, 0xf0, 4, 2, val)
#define ADI89_GET_VFE_VS_PLA			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0xf, 0xfc, 2, 2)
#define ADI89_SET_VFE_VS_PLA(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0xf, 0xfc, 2, 2, val)
#define ADI89_GET_VFE_VS_DUR			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0x3, 0xff, 0, 2)
#define ADI89_SET_VFE_VS_DUR(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x30, 0x3, 0xff, 0, 2, val)
#define ADI89_GET_VFE_HSYNCDELAYIN		adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x35, 0xff, 0xc0, 6, 2)
#define ADI89_SET_VFE_HSYNCDELAYIN(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x35, 0xff, 0xc0, 6, 2, val)
#define ADI89_GET_VFE_VSYNCDELAYIN		adi_get_i2c_reg(AD9889_ADDRESS,0x35, 0x3f, 0)
#define ADI89_SET_VFE_VSYNCDELAYIN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x35, 0x3f, 0, val)
#define ADI89_GET_VFE_OFFSET			adi_get_i2c_reg(AD9889_ADDRESS,0x37, 0xe0, 5)
#define ADI89_SET_VFE_OFFSET(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x37, 0xe0, 5, val)
#define ADI89_GET_VFE_WIDTH			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x37, 0x1f, 0xfe, 1, 2)
#define ADI89_SET_VFE_WIDTH(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x37, 0x1f, 0xfe, 1, 2, val)
#define ADI89_GET_VFE_HEIGHT			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0x39, 0xff, 0xf0, 4, 2)
#define ADI89_SET_VFE_HEIGHT(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x39, 0xff, 0xf0, 4, 2, val)
#define ADI89_GET_EXT_AUDIOSF_SEL		adi_get_i2c_reg(AD9889_ADDRESS,0x3b, 0x80, 7)
#define ADI89_SET_EXT_AUDIOSF_SEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3b, 0x80, 7, val)
#define ADI89_GET_PR_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0x3b, 0x60, 5)
#define ADI89_SET_PR_MODE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x3b, 0x60, 5, val)
#define ADI89_GET_EXT_PLL_PR			adi_get_i2c_reg(AD9889_ADDRESS,0x3b, 0x18, 3)
#define ADI89_SET_EXT_PLL_PR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3b, 0x18, 3, val)
#define ADI89_GET_EXT_TARGET_PR			adi_get_i2c_reg(AD9889_ADDRESS,0x3b, 0x6, 1)
#define ADI89_SET_EXT_TARGET_PR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3b, 0x6, 1, val)
#define ADI89_GET_CSC_ENABLE			adi_get_i2c_reg(AD9889_ADDRESS,0x3b, 0x1, 0)
#define ADI89_SET_CSC_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3b, 0x1, 0, val)
#define ADI89_GET_EXT_VID_TO_RX			adi_get_i2c_reg(AD9889_ADDRESS,0x3c, 0x3f, 0)
#define ADI89_SET_EXT_VID_TO_RX(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x3c, 0x3f, 0, val)
#define ADI89_GET_PR_TO_RX			adi_get_i2c_reg(AD9889_ADDRESS,0x3d, 0xc0, 6)
#define ADI89_GET_VID_TO_RX			adi_get_i2c_reg(AD9889_ADDRESS,0x3d, 0x3f, 0)
#define ADI89_GET_VFE_FMT_VID			adi_get_i2c_reg(AD9889_ADDRESS,0x3e, 0xfc, 2)
#define ADI89_GET_VFE_AUX_VID			adi_get_i2c_reg(AD9889_ADDRESS,0x3f, 0xe0, 5)
#define ADI89_GET_VFE_PROG_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0x3f, 0x18, 3)
#define ADI89_GET_GC_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x40, 0x80, 7)
#define ADI89_SET_GC_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x40, 0x80, 7, val)
#define ADI89_GET_SPD_PKT_EN adi		get_i2c_reg(AD9889_ADDRESS,0x40, 0x40, 6)
#define ADI89_SET_SPD_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x40, 0x40, 6, val)
#define ADI89_GET_MPEG_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x40, 0x20, 5)
#define ADI89_SET_MPEG_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x40, 0x20, 5, val)
#define ADI89_GET_ACP_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x40, 0x10, 4)
#define ADI89_SET_ACP_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x40, 0x10, 4, val)
#define ADI89_GET_ISRC_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x40, 0x8, 3)
#define ADI89_SET_ISRC_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x40, 0x8, 3, val)
#define ADI89_GET_POWER_DOWN			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x40, 6)
#define ADI89_SET_POWER_DOWN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x40, 6, val)
#define ADI89_GET_LOGIC_RESET			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x20, 5)
#define ADI89_SET_LOGIC_RESET(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x20, 5, val)
#define ADI89_GET_INTR_POL			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x10, 4)
#define ADI89_SET_INTR_POL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x10, 4, val)
#define ADI89_GET_INITIATE_SCAN			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x8, 3)
#define ADI89_SET_INITIATE_SCAN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x8, 3, val)
#define ADI89_GET_AUDIOFIFO_TESTEN		adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x4, 2)
#define ADI89_SET_AUDIOFIFO_TESTEN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x4, 2, val)
#define ADI89_GET_SYNC_GEN_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x2, 1)
#define ADI89_SET_SYNC_GEN_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x2, 1, val)
#define ADI89_GET_MAIN_OPEN_1			adi_get_i2c_reg(AD9889_ADDRESS,0x41, 0x1, 0)
#define ADI89_SET_MAIN_OPEN_1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x41, 0x1, 0, val)
#define ADI89_GET_PD_POL			adi_get_i2c_reg(AD9889_ADDRESS,0x42, 0x80, 7)
#define ADI89_GET_HPD_STATE			adi_get_i2c_reg(AD9889_ADDRESS,0x42, 0x40, 6)
#define ADI89_GET_MSEN_STATE 			adi_get_i2c_reg(AD9889_ADDRESS,0x42, 0x20, 5)
#define ADI89_GET_AUDIOFIFO_TESTERROR		adi_get_i2c_reg(AD9889_ADDRESS,0x42, 0x10, 4)
#define ADI89_GET_EDID_ID			adi_get_i2c_reg(AD9889_ADDRESS,0x43, 0xff, 0)
#define ADI89_SET_EDID_ID(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x43, 0xff, 0, val)
#define ADI89_GET_SPDIF_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x80, 7)
#define ADI89_SET_SPDIF_EN(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x80, 7, val)
#define ADI89_GET_N_CTS_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x40, 6)
#define ADI89_SET_N_CTS_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x40, 6, val)
#define ADI89_GET_AUDIO_SAMPLE_PKT_EN		adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x20, 5)
#define ADI89_SET_AUDIO_SAMPLE_PKT_EN(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x20, 5, val)
#define ADI89_GET_AVIIF_PKT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x10, 4)
#define ADI89_SET_AVIIF_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x10, 4, val)
#define ADI89_GET_AUDIOIF_PKT_EN		adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x8, 3)
#define ADI89_SET_AUDIOIF_PKT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x8, 3, val)
#define ADI89_GET_IO_RING_FILT_OFF		adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x4, 2)
#define ADI89_SET_IO_RING_FILT_OFF(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x4, 2, val)
#define ADI89_GET_MAIN_OPEN_2			adi_get_i2c_reg(AD9889_ADDRESS,0x44, 0x3, 0)
#define ADI89_SET_MAIN_OPEN_2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x44, 0x3, 0, val)
#define ADI89_GET_CLEAR_AVMUTE			adi_get_i2c_reg(AD9889_ADDRESS,0x45, 0x80, 7)
#define ADI89_SET_CLEAR_AVMUTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x45, 0x80, 7, val)
#define ADI89_GET_SET_AVMUTE			adi_get_i2c_reg(AD9889_ADDRESS,0x45, 0x40, 6)
#define ADI89_SET_SET_AVMUTE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x45, 0x40, 6, val)
#define ADI89_GET_Y1Y0				adi_get_i2c_reg(AD9889_ADDRESS,0x45, 0x30, 4)
#define ADI89_SET_Y1Y0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x45, 0x30, 4, val)
#define ADI89_GET_A0				adi_get_i2c_reg(AD9889_ADDRESS,0x45, 0x8, 3)
#define ADI89_SET_A0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x45, 0x8, 3, val)
#define ADI89_GET_B1B0				adi_get_i2c_reg(AD9889_ADDRESS,0x45, 0x6, 1)
#define ADI89_SET_B1B0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x45, 0x6, 1, val)
#define ADI89_GET_S1S0				adi_get_i2c_reg(AD9889_ADDRESS,0x46, 0xc0, 6)
#define ADI89_SET_S1S0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x46, 0xc0, 6, val)
#define ADI89_GET_C1C0				adi_get_i2c_reg(AD9889_ADDRESS,0x46, 0x30, 4)
#define ADI89_SET_C1C0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x46, 0x30, 4, val)
#define ADI89_GET_M1M0				adi_get_i2c_reg(AD9889_ADDRESS,0x46, 0xc, 2)
#define ADI89_SET_M1M0(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x46, 0xc, 2, val)
#define ADI89_GET_SC				adi_get_i2c_reg(AD9889_ADDRESS,0x46, 0x3, 0)
#define ADI89_SET_SC(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x46, 0x3, 0, val)
#define ADI89_GET_R30				adi_get_i2c_reg(AD9889_ADDRESS,0x47, 0xf0, 4)
#define ADI89_SET_R30(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x47, 0xf0, 4, val)
#define ADI89_SET_AVI_LINE_START(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x48, 0xff, 0xff, 0, 2, val)
#define ADI89_SET_AVI_LINE_END(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x4A, 0xff, 0xff, 0, 2, val)
#define ADI89_SET_AVI_PIXEL_START(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x4C, 0xff, 0xff, 0, 2, val)
#define ADI89_SET_AVI_PIXEL_END(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0x4E, 0xff, 0xff, 0, 2, val)
#define ADI89_GET_AVI_BYTE6			adi_get_i2c_reg(AD9889_ADDRESS,0x48, 0xff, 0)
#define ADI89_SET_AVI_BYTE6(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x48, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE7			adi_get_i2c_reg(AD9889_ADDRESS,0x49, 0xff, 0)
#define ADI89_SET_AVI_BYTE7(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x49, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE8			adi_get_i2c_reg(AD9889_ADDRESS,0x4a, 0xff, 0)
#define ADI89_SET_AVI_BYTE8(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4a, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE9			adi_get_i2c_reg(AD9889_ADDRESS,0x4b, 0xff, 0)
#define ADI89_SET_AVI_BYTE9(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4b, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE10			adi_get_i2c_reg(AD9889_ADDRESS,0x4c, 0xff, 0)
#define ADI89_SET_AVI_BYTE10(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4c, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE11			adi_get_i2c_reg(AD9889_ADDRESS,0x4d, 0xff, 0)
#define ADI89_SET_AVI_BYTE11(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4d, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE12			adi_get_i2c_reg(AD9889_ADDRESS,0x4e, 0xff, 0)
#define ADI89_SET_AVI_BYTE12(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4e, 0xff, 0, val)
#define ADI89_GET_AVI_BYTE13			adi_get_i2c_reg(AD9889_ADDRESS,0x4f, 0xff, 0)
#define ADI89_SET_AVI_BYTE13(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x4f, 0xff, 0, val)
#define ADI89_GET_AUDIO_IF_CC			adi_get_i2c_reg(AD9889_ADDRESS,0x50, 0xe0, 5)
#define ADI89_SET_AUDIO_IF_CC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x50, 0xe0, 5, val)
#define ADI89_GET_AUDIO_IF_DM_INH		adi_get_i2c_reg(AD9889_ADDRESS,0x50, 0x10, 4)
#define ADI89_SET_AUDIO_IF_DM_INH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x50, 0x10, 4, val)
#define ADI89_GET_AUDIO_IF_LSV			adi_get_i2c_reg(AD9889_ADDRESS,0x50, 0xf, 0)
#define ADI89_SET_AUDIO_IF_LSV(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x50, 0xf, 0, val)
#define ADI89_GET_SPEAKER_MAPPING		adi_get_i2c_reg(AD9889_ADDRESS,0x51, 0x1f, 0)
#define ADI89_SET_SPEAKER_MAPPING(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x51, 0x1f, 0, val)
#define ADI89_GET_SPD_BYTE1			adi_get_i2c_reg(AD9889_ADDRESS,0x52, 0xff, 0)
#define ADI89_SET_SPD_BYTE1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x52, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE2			adi_get_i2c_reg(AD9889_ADDRESS,0x53, 0xff, 0)
#define ADI89_SET_SPD_BYTE2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x53, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE3			adi_get_i2c_reg(AD9889_ADDRESS,0x54, 0xff, 0)
#define ADI89_SET_SPD_BYTE3(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x54, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE4			adi_get_i2c_reg(AD9889_ADDRESS,0x55, 0xff, 0)
#define ADI89_SET_SPD_BYTE4(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x55, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE5			adi_get_i2c_reg(AD9889_ADDRESS,0x56, 0xff, 0)
#define ADI89_SET_SPD_BYTE5(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x56, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE6			adi_get_i2c_reg(AD9889_ADDRESS,0x57, 0xff, 0)
#define ADI89_SET_SPD_BYTE6(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x57, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE7			adi_get_i2c_reg(AD9889_ADDRESS,0x58, 0xff, 0)
#define ADI89_SET_SPD_BYTE7(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x58, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE8			adi_get_i2c_reg(AD9889_ADDRESS,0x59, 0xff, 0)
#define ADI89_SET_SPD_BYTE8(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x59, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE9			adi_get_i2c_reg(AD9889_ADDRESS,0x5a, 0xff, 0)
#define ADI89_SET_SPD_BYTE9(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5a, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE10			adi_get_i2c_reg(AD9889_ADDRESS,0x5b, 0xff, 0)
#define ADI89_SET_SPD_BYTE10(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5b, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE11			adi_get_i2c_reg(AD9889_ADDRESS,0x5c, 0xff, 0)
#define ADI89_SET_SPD_BYTE11(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5c, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE12			adi_get_i2c_reg(AD9889_ADDRESS,0x5d, 0xff, 0)
#define ADI89_SET_SPD_BYTE12(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5d, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE13			adi_get_i2c_reg(AD9889_ADDRESS,0x5e, 0xff, 0)
#define ADI89_SET_SPD_BYTE13(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5e, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE14			adi_get_i2c_reg(AD9889_ADDRESS,0x5f, 0xff, 0)
#define ADI89_SET_SPD_BYTE14(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x5f, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE15			adi_get_i2c_reg(AD9889_ADDRESS,0x60, 0xff, 0)
#define ADI89_SET_SPD_BYTE15(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x60, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE16			adi_get_i2c_reg(AD9889_ADDRESS,0x61, 0xff, 0)
#define ADI89_SET_SPD_BYTE16(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x61, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE17			adi_get_i2c_reg(AD9889_ADDRESS,0x62, 0xff, 0)
#define ADI89_SET_SPD_BYTE17(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x62, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE18			adi_get_i2c_reg(AD9889_ADDRESS,0x63, 0xff, 0)
#define ADI89_SET_SPD_BYTE18(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x63, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE19			adi_get_i2c_reg(AD9889_ADDRESS,0x64, 0xff, 0)
#define ADI89_SET_SPD_BYTE19(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x64, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE20			adi_get_i2c_reg(AD9889_ADDRESS,0x65, 0xff, 0)
#define ADI89_SET_SPD_BYTE20(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x65, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE21			adi_get_i2c_reg(AD9889_ADDRESS,0x66, 0xff, 0)
#define ADI89_SET_SPD_BYTE21(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x66, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE22			adi_get_i2c_reg(AD9889_ADDRESS,0x67, 0xff, 0)
#define ADI89_SET_SPD_BYTE22(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x67, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE23			adi_get_i2c_reg(AD9889_ADDRESS,0x68, 0xff, 0)
#define ADI89_SET_SPD_BYTE23(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x68, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE24			adi_get_i2c_reg(AD9889_ADDRESS,0x69, 0xff, 0)
#define ADI89_SET_SPD_BYTE24(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x69, 0xff, 0, val)
#define ADI89_GET_SPD_BYTE25			adi_get_i2c_reg(AD9889_ADDRESS,0x6a, 0xff, 0)
#define ADI89_SET_SPD_BYTE25(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x6a, 0xff, 0, val)
#define ADI89_GET_MPEG_BYTE1			adi_get_i2c_reg(AD9889_ADDRESS,0x6b, 0xff, 0)
#define ADI89_SET_MPEG_BYTE1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x6b, 0xff, 0, val)
#define ADI89_GET_MPEG_BYTE2			adi_get_i2c_reg(AD9889_ADDRESS,0x6c, 0xff, 0)
#define ADI89_SET_MPEG_BYTE2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x6c, 0xff, 0, val)
#define ADI89_GET_MPEG_BYTE3			adi_get_i2c_reg(AD9889_ADDRESS,0x6d, 0xff, 0)
#define ADI89_SET_MPEG_BYTE3(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x6d, 0xff, 0, val)
#define ADI89_GET_MPEG_BYTE4			adi_get_i2c_reg(AD9889_ADDRESS,0x6e, 0xff, 0)
#define ADI89_SET_MPEG_BYTE4(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x6e, 0xff, 0, val)
#define ADI89_GET_MPEG_FR			adi_get_i2c_reg(AD9889_ADDRESS,0x6f, 0x80, 7)
#define ADI89_SET_MPEG_FR(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x6f, 0x80, 7, val)
#define ADI89_GET_MPEG_MF			adi_get_i2c_reg(AD9889_ADDRESS,0x70, 0x60, 5)
#define ADI89_SET_MPEG_MF(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x70, 0x60, 5, val)
#define ADI89_GET_ACP_TYPE			adi_get_i2c_reg(AD9889_ADDRESS,0x71, 0xff, 0)
#define ADI89_SET_ACP_TYPE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x71, 0xff, 0, val)
#define ADI89_GET_ACP_BYTE1			adi_get_i2c_reg(AD9889_ADDRESS,0x72, 0xff, 0)
#define ADI89_SET_ACP_BYTE1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x72, 0xff, 0, val)
#define ADI89_GET_ISRC_CONT			adi_get_i2c_reg(AD9889_ADDRESS,0x73, 0x80, 7)
#define ADI89_SET_ISRC_CONT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x73, 0x80, 7, val)
#define ADI89_GET_ISRC_VALID			adi_get_i2c_reg(AD9889_ADDRESS,0x73, 0x40, 6)
#define ADI89_SET_ISRC_VALID(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x73, 0x40, 6, val)
#define ADI89_GET_ISRC_STATUS			adi_get_i2c_reg(AD9889_ADDRESS,0x73, 0x38, 3)
#define ADI89_SET_ISRC_STATUS(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x73, 0x38, 3, val)
#define ADI89_GET_ISRC1_BYTE0			adi_get_i2c_reg(AD9889_ADDRESS,0x74, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE0(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x74, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE1			adi_get_i2c_reg(AD9889_ADDRESS,0x75, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x75, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE2			adi_get_i2c_reg(AD9889_ADDRESS,0x76, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x76, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE3			adi_get_i2c_reg(AD9889_ADDRESS,0x77, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE3(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x77, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE4			adi_get_i2c_reg(AD9889_ADDRESS,0x78, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE4(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x78, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE5			adi_get_i2c_reg(AD9889_ADDRESS,0x79, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE5(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x79, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE6			adi_get_i2c_reg(AD9889_ADDRESS,0x7a, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE6(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7a, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE7			adi_get_i2c_reg(AD9889_ADDRESS,0x7b, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE7(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7b, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE8			adi_get_i2c_reg(AD9889_ADDRESS,0x7c, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE8(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7c, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE9			adi_get_i2c_reg(AD9889_ADDRESS,0x7d, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE9(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7d, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE10			adi_get_i2c_reg(AD9889_ADDRESS,0x7e, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE10(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7e, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE11			adi_get_i2c_reg(AD9889_ADDRESS,0x7f, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE11(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x7f, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE12			adi_get_i2c_reg(AD9889_ADDRESS,0x80, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE12(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x80, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE13			adi_get_i2c_reg(AD9889_ADDRESS,0x81, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE13(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x81, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE14			adi_get_i2c_reg(AD9889_ADDRESS,0x82, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE14(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x82, 0xff, 0, val)
#define ADI89_GET_ISRC1_BYTE15			adi_get_i2c_reg(AD9889_ADDRESS,0x83, 0xff, 0)
#define ADI89_SET_ISRC1_BYTE15(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x83, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE0			adi_get_i2c_reg(AD9889_ADDRESS,0x84, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE0(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x84, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE1			adi_get_i2c_reg(AD9889_ADDRESS,0x85, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x85, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE2			adi_get_i2c_reg(AD9889_ADDRESS,0x86, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x86, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE3			adi_get_i2c_reg(AD9889_ADDRESS,0x87, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE3(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x87, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE4			adi_get_i2c_reg(AD9889_ADDRESS,0x88, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE4(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x88, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE5			adi_get_i2c_reg(AD9889_ADDRESS,0x89, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE5(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x89, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE6			adi_get_i2c_reg(AD9889_ADDRESS,0x8a, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE6(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8a, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE7			adi_get_i2c_reg(AD9889_ADDRESS,0x8b, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE7(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8b, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE8			adi_get_i2c_reg(AD9889_ADDRESS,0x8c, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE8(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8c, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE9			adi_get_i2c_reg(AD9889_ADDRESS,0x8d, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE9(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8d, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE10			adi_get_i2c_reg(AD9889_ADDRESS,0x8e, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE10(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8e, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE11			adi_get_i2c_reg(AD9889_ADDRESS,0x8f, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE11(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x8f, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE12			adi_get_i2c_reg(AD9889_ADDRESS,0x90, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE12(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x90, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE13			adi_get_i2c_reg(AD9889_ADDRESS,0x91, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE13(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x91, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE14			adi_get_i2c_reg(AD9889_ADDRESS,0x92, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE14(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x92, 0xff, 0, val)
#define ADI89_GET_ISRC2_BYTE15			adi_get_i2c_reg(AD9889_ADDRESS,0x93, 0xff, 0)
#define ADI89_SET_ISRC2_BYTE15(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x93, 0xff, 0, val)
#define ADI89_GET_MASK1				adi_get_i2c_reg(AD9889_ADDRESS,0x94, 0xff, 0)
#define ADI89_SET_MASK1(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x94, 0xff, 0, val)
#define ADI89_GET_MASK2				adi_get_i2c_reg(AD9889_ADDRESS,0x95, 0xC0, 6)
#define ADI89_SET_MASK2(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x95, 0xc0, 6, val)
#define ADI89_GET_HPD_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x80, 7)
#define ADI89_SET_HPD_INTR(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x80, 7, val)
#define ADI89_GET_MSEN_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x40, 6)
#define ADI89_SET_MSEN_INTR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x40, 6, val)
#define ADI89_GET_VS_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x20, 5)
#define ADI89_SET_VS_INTR(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x20, 5, val)
#define ADI89_GET_AUDIOFIFO_FULL_INT		adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x10, 4)
#define ADI89_SET_AUDIOFIFO_FULL_INT(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x10, 4, val)
#define ADI89_GET_ITU656_ERROR_INTR		adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x8, 3)
#define ADI89_SET_ITU656_ERROR_INTR(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x8, 3, val)
#define ADI89_GET_EDID_RDY_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x4, 2)
#define ADI89_SET_EDID_RDY_INTR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x4, 2, val)
#define ADI89_GET_RI_RDY_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x2, 1)
#define ADI89_SET_RI_RDY_INTR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x2, 1, val)
#define ADI89_GET_PJ_RDY_INTR			adi_get_i2c_reg(AD9889_ADDRESS,0x96, 0x1, 0)
#define ADI89_SET_PJ_RDY_INTR(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x96, 0x1, 0, val)
#define ADI89_GET_HDCP_ERROR_INT		adi_get_i2c_reg(AD9889_ADDRESS,0x97, 0x80, 7)
#define ADI89_SET_HDCP_ERROR_INT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x97, 0x80, 7, val)
#define ADI89_GET_BKSV_FLAG			adi_get_i2c_reg(AD9889_ADDRESS,0x97, 0x40, 6)
#define ADI89_SET_BKSV_FLAG(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x97, 0x40, 6, val)
#define ADI89_GET_SET_BIT_TO_1			adi_get_i2c_reg(AD9889_ADDRESS,0x97, 0x4, 2)
#define ADI89_SET_SET_BIT_TO_1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x97, 0x4, 2, val)
#define ADI89_GET_EXTERNAL_GEAR_I2C		adi_get_i2c_reg(AD9889_ADDRESS,0x98, 0x80, 7)
#define ADI89_SET_EXTERNAL_GEAR_I2C(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x98, 0x80, 7, val)
#define ADI89_GET_VCO_GEAR_FROM_I2C		adi_get_i2c_reg(AD9889_ADDRESS,0x98, 0x70, 4)
#define ADI89_SET_VCO_GEAR_FROM_I2C(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x98, 0x70, 4, val)
#define ADI89_GET_CHARGE_PUMP_SETTING		adi_get_i2c_reg(AD9889_ADDRESS,0x98, 0xf, 0)
#define ADI89_SET_CHARGE_PUMP_SETTING(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x98, 0xf, 0, val)
#define ADI89_GET_LOCKCOUNTLIMIT		adi_get_i2c_reg(AD9889_ADDRESS,0x99, 0xff, 0)
#define ADI89_SET_LOCKCOUNTLIMIT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x99, 0xff, 0, val)
#define ADI89_GET_LOCK_FILT_EN			adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x80, 7)
#define ADI89_SET_LOCK_FILT_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x80, 7, val)
#define ADI89_GET_WAIT_TIME_SEL			adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x60, 5)
#define ADI89_SET_WAIT_TIME_SEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x60, 5, val)
#define ADI89_GET_HALFLSB_DATADRIVER		adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x10, 4)
#define ADI89_SET_HALFLSB_DATADRIVER(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x10, 4, val)
#define ADI89_GET_QTRLSB_DATADRIVER		adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x8, 3)
#define ADI89_SET_QTRLSB_DATADRIVER(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x8, 3, val)
#define ADI89_GET_HALFLSB_CLKDRIVER		adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x4, 2)
#define ADI89_SET_HALFLSB_CLKDRIVER(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x4, 2, val)
#define ADI89_GET_QTRLSB_CLKDRIVER		adi_get_i2c_reg(AD9889_ADDRESS,0x9a, 0x2, 1)
#define ADI89_SET_QTRLSB_CLKDRIVER(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9a, 0x2, 1, val)
#define ADI89_GET_SERICTRLI2C			adi_get_i2c_reg(AD9889_ADDRESS,0x9b, 0x38, 3)
#define ADI89_SET_SERICTRLI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9b, 0x38, 3, val)
#define ADI89_GET_FORCEFILTERNODEI2C		adi_get_i2c_reg(AD9889_ADDRESS,0x9b, 0x4, 2)
#define ADI89_SET_FORCEFILTERNODEI2C(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9b, 0x4, 2, val)
#define ADI89_GET_LOCK_SEL			adi_get_i2c_reg(AD9889_ADDRESS,0x9b, 0x3, 0)
#define ADI89_SET_LOCK_SEL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x9b, 0x3, 0, val)
#define ADI89_GET_PLL_FILTER_R1_VALUE		adi_get_i2c_reg(AD9889_ADDRESS,0x9c, 0xe0, 5)
#define ADI89_SET_PLL_FILTER_R1_VALUE(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9c, 0xe0, 5, val)
#define ADI89_GET_PLL_FILTER_C1_VALUE		adi_get_i2c_reg(AD9889_ADDRESS,0x9c, 0x1c, 2)
#define ADI89_SET_PLL_FILTER_C1_VALUE(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9c, 0x1c, 2, val)
#define ADI89_GET_PLL_FILTER_C2_VALUE		adi_get_i2c_reg(AD9889_ADDRESS,0x9c, 0x3, 0)
#define ADI89_SET_PLL_FILTER_C2_VALUE(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9c, 0x3, 0, val)
#define ADI89_GET_CLKICTRL			adi_get_i2c_reg(AD9889_ADDRESS,0x9d, 0xe0, 5)
#define ADI89_SET_CLKICTRL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0x9d, 0xe0, 5, val)
#define ADI89_GET_I2CAGFORCE_CP_OFF		adi_get_i2c_reg(AD9889_ADDRESS,0x9d, 0x10, 4)
#define ADI89_SET_I2CAGFORCE_CP_OFF(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9d, 0x10, 4, val)
#define ADI89_GET_ANALOG_OPEN110		adi_get_i2c_reg(AD9889_ADDRESS,0x9d, 0xc, 2)
#define ADI89_SET_ANALOG_OPEN110(val)		adi_set_i2c_reg(AD9889_ADDRESS,0x9d, 0xc, 2, val)
#define ADI89_GET_IREFINCREASE_MSB10		adi_get_i2c_reg(AD9889_ADDRESS,0x9d, 0x3, 0)
#define ADI89_SET_IREFINCREASE_MSB10(val)	adi_set_i2c_reg(AD9889_ADDRESS,0x9d, 0x3, 0, val)
#define ADI89_GET_PLLLOCKED			adi_get_i2c_reg(AD9889_ADDRESS,0x9e, 0x10, 4)
#define ADI89_GET_GEAR_SELECTED			adi_get_i2c_reg(AD9889_ADDRESS,0x9e, 0xe, 1)
#define ADI89_GET_LEADLAG			adi_get_i2c_reg(AD9889_ADDRESS,0x9e, 0x1, 0)
#define ADI89_GET_IREFINCREASE_LSB		adi_get_i2c_reg(AD9889_ADDRESS,0x9f, 0xff, 0)
#define ADI89_GET_LOCKCOUNTDIFF			adi_get_i2c_reg(AD9889_ADDRESS,0xa0, 0xff, 0)
#define ADI89_GET_TERMMONRESET			adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x80, 7)
#define ADI89_SET_TERMMONRESET(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x80, 7, val)
#define ADI89_GET_TERMPWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x40, 6)
#define ADI89_SET_TERMPWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x40, 6, val)
#define ADI89_GET_CH0PWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x20, 5)
#define ADI89_SET_CH0PWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x20, 5, val)
#define ADI89_GET_CH1PWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x10, 4)
#define ADI89_SET_CH1PWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x10, 4, val)
#define ADI89_GET_CH2PWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x8, 3)
#define ADI89_SET_CH2PWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x8, 3, val)
#define ADI89_GET_CLKDRVPWRDWNI2C		adi_get_i2c_reg(AD9889_ADDRESS,0xa1, 0x4, 2)
#define ADI89_SET_CLKDRVPWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa1, 0x4, 2, val)
#define ADI89_GET_TXOUTPUTLVL			adi_get_i2c_reg(AD9889_ADDRESS,0xa2, 0xf8, 3)
#define ADI89_SET_TXOUTPUTLVL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa2, 0xf8, 3, val)
#define ADI89_GET_TXDRVLVL			adi_get_i2c_reg(AD9889_ADDRESS,0xa2, 0x4, 2)
#define ADI89_SET_TXDRVLVL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xa2, 0x4, 2, val)
#define ADI89_GET_IDRIVE			adi_get_i2c_reg(AD9889_ADDRESS,0xa2, 0x3, 0)
#define ADI89_SET_IDRIVE(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xa2, 0x3, 0, val)
#define ADI89_GET_CLKTXOUTPUTLVL		adi_get_i2c_reg(AD9889_ADDRESS,0xa3, 0xf8, 3)
#define ADI89_SET_CLKTXOUTPUTLVL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa3, 0xf8, 3, val)
#define ADI89_GET_CLKTXDRVLVL			adi_get_i2c_reg(AD9889_ADDRESS,0xa3, 0x4, 2)
#define ADI89_SET_CLKTXDRVLVL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa3, 0x4, 2, val)
#define ADI89_GET_CLKIDRIVE			adi_get_i2c_reg(AD9889_ADDRESS,0xa3, 0x3, 0)
#define ADI89_SET_CLKIDRIVE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa3, 0x3, 0, val)
#define ADI89_GET_CHANSELLBKI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa4, 0xe0, 5)
#define ADI89_SET_CHANSELLBKI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa4, 0xe0, 5, val)
#define ADI89_GET_LBKLOGICRESETI2C		adi_get_i2c_reg(AD9889_ADDRESS,0xa4, 0x10, 4)
#define ADI89_SET_LBKLOGICRESETI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa4, 0x10, 4, val)
#define ADI89_GET_LBKPWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa4, 0x8, 3)
#define ADI89_SET_LBKPWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa4, 0x8, 3, val)
#define ADI89_GET_OSCPWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa4, 0x4, 2)
#define ADI89_SET_OSCPWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa4, 0x4, 2, val)
#define ADI89_GET_PLLPWRDWNI2C			adi_get_i2c_reg(AD9889_ADDRESS,0xa4, 0x2, 1)
#define ADI89_SET_PLLPWRDWNI2C(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa4, 0x2, 1, val)
#define ADI89_GET_LBCHANSEL			adi_get_i2c_reg(AD9889_ADDRESS,0xa5, 0xc0, 6)
#define ADI89_SET_LBCHANSEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa5, 0xc0, 6, val)
#define ADI89_GET_LBTESTSTART			adi_get_i2c_reg(AD9889_ADDRESS,0xa5, 0x20, 5)
#define ADI89_SET_LBTESTSTART(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa5, 0x20, 5, val)
#define ADI89_GET_LBRUNCNTSEL			adi_get_i2c_reg(AD9889_ADDRESS,0xa5, 0x18, 3)
#define ADI89_SET_LBRUNCNTSEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa5, 0x18, 3, val)
#define ADI89_GET_LBPATDATAMODE			adi_get_i2c_reg(AD9889_ADDRESS,0xa5, 0x6, 1)
#define ADI89_SET_LBPATDATAMODE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa5, 0x6, 1, val)
#define ADI89_GET_LBTESTPAT_MSB			adi_get_i2c_reg(AD9889_ADDRESS,0xa6, 0xff, 0)
#define ADI89_SET_LBTESTPAT_MSB(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa6, 0xff, 0, val)
#define ADI89_GET_LBTESTPAT_MID_1		adi_get_i2c_reg(AD9889_ADDRESS,0xa7, 0xff, 0)
#define ADI89_SET_LBTESTPAT_MID_1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa7, 0xff, 0, val)
#define ADI89_GET_LBTESTPAT_MID_2		adi_get_i2c_reg(AD9889_ADDRESS,0xa8, 0xff, 0)
#define ADI89_SET_LBTESTPAT_MID_2(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa8, 0xff, 0, val)
#define ADI89_GET_LBTESTPAT_LSB			adi_get_i2c_reg(AD9889_ADDRESS,0xa9, 0xfc, 2)
#define ADI89_SET_LBTESTPAT_LSB(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa9, 0xfc, 2, val)
#define ADI89_GET_LB_FORCE_BITLOC		adi_get_i2c_reg(AD9889_ADDRESS,0xa9, 0x2, 1)
#define ADI89_SET_LB_FORCE_BITLOC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xa9, 0x2, 1, val)
#define ADI89_GET_LBFORCEPH			adi_get_i2c_reg(AD9889_ADDRESS,0xaa, 0x80, 7)
#define ADI89_SET_LBFORCEPH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaa, 0x80, 7, val)
#define ADI89_GET_LBFORCEPHSEL			adi_get_i2c_reg(AD9889_ADDRESS,0xaa, 0x60, 5)
#define ADI89_SET_LBFORCEPHSEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaa, 0x60, 5, val)
#define ADI89_GET_LBBITLOCSEL			adi_get_i2c_reg(AD9889_ADDRESS,0xaa, 0x1f, 0)
#define ADI89_SET_LBBITLOCSEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaa, 0x1f, 0, val)
#define ADI89_GET_LBERRCNTMODE			adi_get_i2c_reg(AD9889_ADDRESS,0xab, 0x80, 7)
#define ADI89_SET_LBERRCNTMODE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xab, 0x80, 7, val)
#define ADI89_GET_LBREFDLYNUM			adi_get_i2c_reg(AD9889_ADDRESS,0xab, 0x70, 4)
#define ADI89_SET_LBREFDLYNUM(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xab, 0x70, 4, val)
#define ADI89_GET_ERR_NUM_MSB			adi_get_i2c_reg(AD9889_ADDRESS,0xac, 0xff, 0)
#define ADI89_GET_ERR_NUM_LSB			adi_get_i2c_reg(AD9889_ADDRESS,0xad, 0xff, 0)
#define ADI89_GET_TEST_OVER			adi_get_i2c_reg(AD9889_ADDRESS,0xae, 0x80, 7)
#define ADI89_GET_TEST_FAIL			adi_get_i2c_reg(AD9889_ADDRESS,0xae, 0x40, 6)
#define ADI89_GET_LB_GOODPHASE			adi_get_i2c_reg(AD9889_ADDRESS,0xae, 0x20, 5)
#define ADI89_GET_HDCP_DESIRED			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x80, 7)
#define ADI89_SET_HDCP_DESIRED(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x80, 7, val)
#define ADI89_GET_SIG_CHECK_EN			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x20, 5)
#define ADI89_SET_SIG_CHECK_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x20, 5, val)
#define ADI89_GET_FRAME_ENC			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x10, 4)
#define ADI89_SET_FRAME_ENC(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x10, 4, val)
#define ADI89_GET_EPP_PROG_EN			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x8, 3)
#define ADI89_SET_EPP_PROG_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x8, 3, val)
#define ADI89_GET_HDMI_MODE_SEL			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x4, 2)
#define ADI89_SET_HDMI_MODE_SEL(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x4, 2, val)
#define ADI89_GET_EXT_HDMI_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x2, 1)
#define ADI89_SET_EXT_HDMI_MODE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x2, 1, val)
#define ADI89_GET_HDCPVUMASK			adi_get_i2c_reg(AD9889_ADDRESS,0xaf, 0x1, 0)
#define ADI89_SET_HDCPVUMASK(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xaf, 0x1, 0, val)
#define ADI89_GET_AN_0				adi_get_i2c_reg(AD9889_ADDRESS,0xb0, 0xff, 0)
#define ADI89_GET_AN_1				adi_get_i2c_reg(AD9889_ADDRESS,0xb1, 0xff, 0)
#define ADI89_GET_AN_2				adi_get_i2c_reg(AD9889_ADDRESS,0xb2, 0xff, 0)
#define ADI89_GET_AN_3				adi_get_i2c_reg(AD9889_ADDRESS,0xb3, 0xff, 0)
#define ADI89_GET_AN_4				adi_get_i2c_reg(AD9889_ADDRESS,0xb4, 0xff, 0)
#define ADI89_GET_AN_5				adi_get_i2c_reg(AD9889_ADDRESS,0xb5, 0xff, 0)
#define ADI89_GET_AN_6				adi_get_i2c_reg(AD9889_ADDRESS,0xb6, 0xff, 0)
#define ADI89_GET_AN_7				adi_get_i2c_reg(AD9889_ADDRESS,0xb7, 0xff, 0)
#define ADI89_GET_SIG_CHECK_FAIL		adi_get_i2c_reg(AD9889_ADDRESS,0xb8, 0x80, 7)
#define ADI89_GET_ENC_ON			adi_get_i2c_reg(AD9889_ADDRESS,0xb8, 0x40, 6)
#define ADI89_GET_INT_HDMI_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0xb8, 0x20, 5)
#define ADI89_GET_KEYS_READ_ERR			adi_get_i2c_reg(AD9889_ADDRESS,0xb8, 0x10, 4)
#define ADI89_GET_OUTPUT_TEST_EN		adi_get_i2c_reg(AD9889_ADDRESS,0xb9, 0x80, 7)
#define ADI89_SET_OUTPUT_TEST_EN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xb9, 0x80, 7, val)
#define ADI89_GET_INPUTTESTEN			adi_get_i2c_reg(AD9889_ADDRESS,0xb9, 0x40, 6)
#define ADI89_SET_INPUTTESTEN(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xb9, 0x40, 6, val)
#define ADI89_GET_INPUTTESTGP			adi_get_i2c_reg(AD9889_ADDRESS,0xb9, 0x20, 5)
#define ADI89_SET_INPUTTESTGP(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xb9, 0x20, 5, val)
#define ADI89_GET_TESTSEL			adi_get_i2c_reg(AD9889_ADDRESS,0xb9, 0x1f, 0)
#define ADI89_SET_TESTSEL(val)			adi_set_i2c_reg(AD9889_ADDRESS,0xb9, 0x1f, 0, val)
#define ADI89_GET_CLK_DELAY			adi_get_i2c_reg(AD9889_ADDRESS,0xba, 0xe0, 5)
#define ADI89_SET_CLK_DELAY(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xba, 0xe0, 5, val)
#define ADI89_GET_INT_EPP_ON			adi_get_i2c_reg(AD9889_ADDRESS,0xba, 0x10, 4)
#define ADI89_SET_INT_EPP_ON(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xba, 0x10, 4, val)
#define ADI89_GET_EPP_CONFIG			adi_get_i2c_reg(AD9889_ADDRESS,0xba, 0x8, 3)
#define ADI89_SET_EPP_CONFIG(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xba, 0x8, 3, val)
#define ADI89_GET_EPP_PROG_PWD			adi_get_i2c_reg(AD9889_ADDRESS,0xbb, 0xff, 0)
#define ADI89_SET_EPP_PROG_PWD(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xbb, 0xff, 0, val)
#define ADI89_GET_EPP_SIG_MSB			adi_get_i2c_reg(AD9889_ADDRESS,0xbc, 0xff, 0)
#define ADI89_GET_EPP_SIG_LSB			adi_get_i2c_reg(AD9889_ADDRESS,0xbd, 0xff, 0)
#define ADI89_GET_BCAPS				adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x80, 7)
#define ADI89_GET_REPEATER			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x40, 6)
#define ADI89_GET_KSV_READY			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x20, 5)
#define ADI89_GET_TEST_BIT			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x10, 4)
#define ADI89_GET_TEST_BITS			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0xc, 2)
#define ADI89_GET_HDCP_SUPPORT			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x2, 1)
#define ADI89_GET_FAST_HDCP			adi_get_i2c_reg(AD9889_ADDRESS,0xbe, 0x1, 0)
#define ADI89_GET_BKSV1				adi_get_i2c_reg(AD9889_ADDRESS,0xbf, 0xff, 0)
#define ADI89_GET_BKSV2				adi_get_i2c_reg(AD9889_ADDRESS,0xbf, 0xff, 0)
#define ADI89_GET_BKSV3				adi_get_i2c_reg(AD9889_ADDRESS,0xbf, 0xff, 0)
#define ADI89_GET_BKSV4				adi_get_i2c_reg(AD9889_ADDRESS,0xbf, 0xff, 0)
#define ADI89_GET_BKSV5				adi_get_i2c_reg(AD9889_ADDRESS,0xbf, 0xff, 0)
#define ADI89_GET_EDID_SEGMENT			adi_get_i2c_reg(AD9889_ADDRESS,0xc4, 0xff, 0)
#define ADI89_SET_EDID_SEGMENT(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc4, 0xff, 0, val)
#define ADI89_GET_ERR_FLAG			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x80, 7)
#define ADI89_GET_AN_STOP			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x40, 6)
#define ADI89_GET_HDCP_ENABLED			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x20, 5)
#define ADI89_GET_EDID_READY_FLAG		adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x10, 4)
#define ADI89_GET_I2C_INTERRUPT			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x8, 3)
#define ADI89_GET_RI_FLAG			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x4, 2)
#define ADI89_GET_BKSV_UPDATE_FLAG		adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x2, 1)
#define ADI89_GET_PJ_FLAG			adi_get_i2c_reg(AD9889_ADDRESS,0xc5, 0x1, 0)
#define ADI89_GET_FREE_FLAGS			adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0xe0, 5)
#define ADI89_GET_HDMI_MODE			adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0x10, 4)
#define ADI89_GET_HDCP_REQUESTED		adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0x8, 3)
#define ADI89_GET_RX_SENSE			adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0x4, 2)
#define ADI89_GET_EEPROM_READ_OK		adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0x2, 1)
#define ADI89_GET_TMDS_OUTPUT_ENABLED		adi_get_i2c_reg(AD9889_ADDRESS,0xc6, 0x1, 0)
#define ADI89_GET_BKSV_FLAG2			adi_get_i2c_reg(AD9889_ADDRESS,0xc7, 0x80, 7)
#define ADI89_GET_BKSV_COUNT			adi_get_i2c_reg(AD9889_ADDRESS,0xc7, 0x7f, 0)
#define ADI89_GET_HDCP_CONTROLLER_ERROR		adi_get_i2c_reg(AD9889_ADDRESS,0xc8, 0xf0, 4)
#define ADI89_GET_HDCP_CONTROLLER_STATE		adi_get_i2c_reg(AD9889_ADDRESS,0xc8, 0xf, 0)
#define ADI89_GET_EDID_TRYS			adi_get_i2c_reg(AD9889_ADDRESS,0xc9, 0xf, 0)
#define ADI89_SET_EDID_TRYS(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xc9, 0xf, 0, val)
#define ADI89_GET_FREE_REGISTER_0		adi_get_i2c_reg(AD9889_ADDRESS,0xca, 0xff, 0)
#define ADI89_SET_FREE_REGISTER_0(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xca, 0xff, 0, val)
#define ADI89_GET_FREE_REGISTER_1		adi_get_i2c_reg(AD9889_ADDRESS,0xcb, 0xff, 0)
#define ADI89_SET_FREE_REGISTER_1(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xcb, 0xff, 0, val)
#define ADI89_GET_IROM_BIST_PASS		adi_get_i2c_reg(AD9889_ADDRESS,0xcc, 0x4, 2)
#define ADI89_SET_IROM_BIST_PASS(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xcc, 0x4, 2, val)
#define ADI89_GET_IROM_BIST_DONE		adi_get_i2c_reg(AD9889_ADDRESS,0xcc, 0x2, 1)
#define ADI89_SET_IROM_BIST_DONE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xcc, 0x2, 1, val)
#define ADI89_GET_IROM_BIST_ENABLE		adi_get_i2c_reg(AD9889_ADDRESS,0xcc, 0x1, 0)
#define ADI89_SET_IROM_BIST_ENABLE(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xcc, 0x1, 0, val)
#define ADI89_GET_LBAUTOTRYNUM			adi_get_i2c_reg(AD9889_ADDRESS,0xfa, 0xf0, 4)
#define ADI89_SET_LBAUTOTRYNUM(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xfa, 0xf0, 4, val)
#define ADI89_GET_LBFIFO_WRITE_ADDR		adi_get_i2c_reg(AD9889_ADDRESS,0xfa, 0xc, 2)
#define ADI89_SET_LBFIFO_WRITE_ADDR(val)	adi_set_i2c_reg(AD9889_ADDRESS,0xfa, 0xc, 2, val)
#define ADI89_GET_LBALIGN_LENGTH		adi_get_i2c_reg(AD9889_ADDRESS,0xfa, 0x3, 0)
#define ADI89_SET_LBALIGN_LENGTH(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xfa, 0x3, 0, val)
#define ADI89_GET_LBSTARTDELAY			adi_get_i2c_reg_mult(AD9889_ADDRESS, 0xfb, 0xff, 0x80, 7, 2)
#define ADI89_SET_LBSTARTDELAY(val)		adi_set_i2c_reg_mult(AD9889_ADDRESS, 0xfb, 0xff, 0x80, 7, 2, val)
#define ADI89_GET_LBALIGN_START			adi_get_i2c_reg(AD9889_ADDRESS,0xfb, 0x70, 4)
#define ADI89_SET_LBALIGN_START(val)		adi_set_i2c_reg(AD9889_ADDRESS,0xfb, 0x70, 4, val)
#define ADI89_GET_LBPHASECHANGEMARGIN		adi_get_i2c_reg(AD9889_ADDRESS,0xfb, 0xf, 0)
#define ADI89_SET_LBPHASECHANGEMARGIN(val)	adi_set_i2c_reg(AD9889_ADDRESS,0xfb, 0xf, 0, val)
#define ADI89_GET_LBCURRENTPHASE		adi_get_i2c_reg(AD9889_ADDRESS,0xfd, 0xc0, 6)
#define ADI89_GET_LBPHASERESULT			adi_get_i2c_reg(AD9889_ADDRESS,0xfd, 0x3c, 2)
#define ADI89_GET_LBCURRENTBITLOC		adi_get_i2c_reg(AD9889_ADDRESS,0xfe, 0xf8, 3)
#define ADI89_GET_LBNOWTRYNUM			adi_get_i2c_reg(AD9889_ADDRESS,0xff, 0xf0, 4)
