/****************************************************************************
 * Copyright 2002-2005: Level 5 Networks Inc.
 * Copyright 2005-2008: Solarflare Communications Inc,
 *                      9501 Jeronimo Road, Suite 250,
 *                      Irvine, CA 92618, USA
 *
 * Maintained by Solarflare Communications
 *  <linux-xen-drivers@solarflare.com>
 *  <onload-dev@solarflare.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation, incorporated herein by reference.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 ****************************************************************************
 */

/*
 * \author  slp
 *  \brief  Falcon specific definitions
 *   \date  2004/08
 */

#ifndef __EF_VI_FALCON_H__
#define __EF_VI_FALCON_H__    

#define EFHW_4K		0x00001000u
#define EFHW_8K		0x00002000u

/* include the autogenerated register definitions */

#include "ef_vi_falcon_core.h"
#include "ef_vi_falcon_desc.h"
#include "ef_vi_falcon_event.h"


/*----------------------------------------------------------------------------
 *
 * Helpers to turn bit shifts into dword shifts and check that the bit fields 
 * haven't overflown the dword etc. Aim is to preserve consistency with the 
 * autogenerated headers - once stable we could hard code.
 *
 *---------------------------------------------------------------------------*/

/* mask constructors */
#define __FALCON_MASK(WIDTH,T)  ((((T)1) << (WIDTH)) - 1)
#define __EFVI_MASK32(WIDTH)  __FALCON_MASK((WIDTH),uint32_t)
#define __EFVI_MASK64(WIDTH)  __FALCON_MASK((WIDTH),uint64_t)

#define __EFVI_FALCON_MASKFIELD32(LBN, WIDTH)   ((uint32_t)  \
                             (__EFVI_MASK32(WIDTH) << (LBN)))

/* constructors for fields which span the first and second dwords */
#define __LW(LBN) (32 - LBN)
#define LOW(v, LBN, WIDTH)   ((uint32_t)  \
                               (((v) & __EFVI_MASK64(__LW((LBN)))) << (LBN)))
#define HIGH(v, LBN, WIDTH)  ((uint32_t)(((v) >> __LW((LBN))) & \
                                       __EFVI_MASK64((WIDTH - __LW((LBN))))))
/* constructors for fields within the second dword */
#define __DW2(LBN) 	  ((LBN) - 32)

/* constructors for fields which span the second and third dwords */
#define __LW2(LBN) (64 - LBN)
#define LOW2(v, LBN, WIDTH) ((uint32_t) \
                       (((v) & __EFVI_MASK64(__LW2((LBN)))) << ((LBN) - 32)))
#define HIGH2(v, LBN, WIDTH)  ((uint32_t) \
             (((v) >> __LW2((LBN))) & __EFVI_MASK64((WIDTH - __LW2((LBN))))))

/* constructors for fields within the third dword */
#define __DW3(LBN) 	  ((LBN) - 64)

				
/* constructors for fields which span the third and fourth dwords */
#define __LW3(LBN) (96 - LBN)
#define LOW3(v, LBN, WIDTH)   ((uint32_t)    \
              (((v) & __EFVI_MASK64(__LW3((LBN)))) << ((LBN) - 64)))
#define HIGH3(v, LBN, WIDTH)  ((unit32_t)    \
             (((v) >> __LW3((LBN))) & __EFVI_MASK64((WIDTH - __LW3((LBN))))))

/* constructors for fields within the fourth dword */
#define __DW4(LBN) 	  ((LBN) - 96)

/* checks that the autogenerated headers our consistent with our model */
#define WIDTHCHCK(a, b) ef_assert((a) == (b))
#define RANGECHCK(v, WIDTH) \
                ef_assert(((uint64_t)(v) & ~(__EFVI_MASK64((WIDTH)))) == 0)

/* fields within the first dword */
#define DWCHCK(LBN, WIDTH) ef_assert(((LBN) >= 0) &&(((LBN)+(WIDTH)) <= 32))

/* fields which span the first and second dwords */
#define LWCHK(LBN, WIDTH)  ef_assert(WIDTH >= __LW(LBN))

/*----------------------------------------------------------------------------
 *
 * Buffer virtual addresses (4K buffers) 
 *
 *---------------------------------------------------------------------------*/

/* Form a buffer virtual address from buffer ID and offset.  If the offset
** is larger than the buffer size, then the buffer indexed will be
** calculated appropriately.  It is the responsibility of the caller to
** ensure that they have valid buffers programmed at that address.
*/
#define EFVI_FALCON_VADDR_4K_S   	(12)	     
#define EFVI_FALCON_VADDR_M       0xfffff		/* post shift mask  */


#define EFVI_FALCON_BUFFER_4K_ADDR(id,off)      \
  (((id) << EFVI_FALCON_VADDR_4K_S) + (off))

#define EFVI_FALCON_BUFFER_4K_PAGE(vaddr)                       \
  (((vaddr) >> EFVI_FALCON_VADDR_4K_S) & EFVI_FALCON_VADDR_M)

#define EFVI_FALCON_BUFFER_4K_OFF(vaddr)                \
  ((vaddr) & __EFVI_MASK32(EFVI_FALCON_VADDR_4K_S))


/*----------------------------------------------------------------------------
 *
 * Masks
 *
 *---------------------------------------------------------------------------*/

#define EFVI_FALCON_CLOCK_ASIC_HZ    (125000)
#define EFVI_FALCON_CLOCK_FPGA_HZ    (62500)
#define EFVI_FALCON_CLOCK_HZ         EFVI_FALCON_CLOCK_ASIC_HZ


/*----------------------------------------------------------------------------
 *
 * Timers
 *
 *---------------------------------------------------------------------------*/

/* Event-Queue Timer granularity - measured in us 
   Given by: 4096 * 3 cycle * clock period */

#define EFVI_FALCON_EVQTIMER_PERIOD_US   ((4096 * 3 * 1000) / EFVI_FALCON_CLOCK_HZ)

/* mode bits */
#define EFVI_FALCON_TIMER_MODE_DIS     0     /* disabled */
#define EFVI_FALCON_TIMER_MODE_RUN     1     /* started counting right away */
#define EFVI_FALCON_TIMER_MODE_HOLD    2     /* trigger mode (user queues) */

#define EFVI_FALCON_EVQTIMER_HOLD     (EFVI_FALCON_TIMER_MODE_HOLD << TIMER_MODE_LBN)
#define EFVI_FALCON_EVQTIMER_RUN      (EFVI_FALCON_TIMER_MODE_RUN  << TIMER_MODE_LBN)
#define EFVI_FALCON_EVQTIMER_DISABLE  (EFVI_FALCON_TIMER_MODE_DIS  << TIMER_MODE_LBN) 


/* ---- ef_vi_event helpers --- */

#define EFVI_FALCON_EVENT_CODE(evp) \
       ((evp)->u64 & EFVI_FALCON_EVENT_CODE_MASK)

#define EFVI_FALCON_EVENT_SW_DATA_MASK    0x0000ffff

#define __EFVI_FALCON_OPEN_MASK(WIDTH)  ((((uint64_t)1) << (WIDTH)) - 1)

#define EFVI_FALCON_EVENT_CODE_MASK \
           (__EFVI_FALCON_OPEN_MASK(EV_CODE_WIDTH) << EV_CODE_LBN)


#endif  /* __EF_VI_FALCON_H__ */
