/* drivers/message/fusion/linux_compat.h */

#ifndef FUSION_LINUX_COMPAT_H
#define FUSION_LINUX_COMPAT_H

#include <linux/version.h>
#include <scsi/scsi_device.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,6))
static int inline scsi_device_online(struct scsi_device *sdev)
{
	return sdev->online;
}
#endif

/* Begin UBUNTU added compatibility for 2.6.15 */
#include <asm/semaphore.h>
struct mutex {
	struct semaphore sem;
};
static inline void mutex_lock(struct mutex *lock)
{
	down(&lock->sem);
}
static inline void mutex_unlock(struct mutex *lock)
{
	up(&lock->sem);
}
static inline void mutex_init(struct mutex *lock)
{
	sema_init(&lock->sem, 1);
}
static inline int mutex_trylock(struct mutex *lock)
{
	return down_trylock(&lock->sem);
}
static inline int mutex_lock_interruptible(struct mutex *lock)
{
	return down_interruptible(&lock->sem);
}

#define PCI_DEVICE_ID_LSI_FC949ES	0x0646


/*}-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
#endif /* _LINUX_COMPAT_H */
