/*
** Copyright (c) 2007 by Silicon Laboratories
**
** $Id: si324x_intf.h 556 2009-03-25 23:15:17Z cdp@SILABS.COM $
**
** Si324x_Intf.h
** Si324x ProSLIC interface header file
**
** Author(s):
** laj
**
** Distributed by:
** Silicon Laboratories, Inc
**
** This file contains proprietary information.
** No dissemination allowed without prior written permission from
** Silicon Laboratories, Inc.
**
** File Description:
** This is the header file for the ProSLIC driver.
**
** Dependancies:
** proslic_datatypes.h, Si324x_registers.h, ProSLIC.h
**
*/
#ifndef SI324X_INTF_H
#define SI324X_INTF_H

/*
**
** PROSLIC INITIALIZATION FUNCTIONS
**
*/

/*
** Function: PROSLIC_Reset
**
** Description:
** Resets the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
**
** Return:
** none
*/
int Si324x_Reset (proslicChanType_ptr hProslic);


/*
** Function: PROSLIC_Init
**
** Description:
** Initializes the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
**
** Return:
** none
*/
int Si324x_Init (proslicChanType_ptr *hProslic,int size);

/*
** Function: PROSLIC_Init
**
** Description:
** Initializes the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
**
** Return:
** none
*/
int Si324x_InitBroadcast (proslicChanType_ptr *hProslic);

/*
** Function: PROSLIC_Cal
**
** Description:
** Calibrates the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
**
** Return:
** none
*/
int Si324x_Cal (proslicChanType_ptr *hProslic, int size);

/*
** Function: PROSLIC_LoadRegTables
**
** Description:
** Loads registers and ram in the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
** pRamTable: pointer to ram values to load
** pRegTable: pointer to register values to load
**
**
** Return:
** none
*/
int Si324x_LoadRegTables (proslicChanType_ptr *hProslic, ProslicRAMInit *pRamTable, ProslicRegInit *pRegTable,int size);

/*
** Function: PROSLIC_LoadPatch
**
** Description:
** Loads patch to the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
** pPatch: pointer to patch data
**
** Return:
** none
*/
int Si324x_LoadPatch (proslicChanType_ptr hProslic, const proslicPatch *pPatch);

/*
** Function: PROSLIC_VerifyPatch
**
** Description:
** Verifies patch to the ProSLIC
**
** Input Parameters:
** pProslic: pointer to PROSLIC object
** pPatch: pointer to patch data
**
** Return:
** none
*/
int Si324x_VerifyPatch (proslicChanType_ptr hProslic, const proslicPatch *pPatch);

/*
** Function: PROSLIC_EnableInterrupts
**
** Description:
** Enables interrupts
**
** Input Parameters:
** hProslic: pointer to Proslic object
**
** Return:
**
*/
int Si324x_EnableInterrupts (proslicChanType_ptr hProslic);


int Si324x_SetLoopbackMode (proslicChanType_ptr hProslic, ProslicLoopbackModes newMode);

int Si324x_SetMuteStatus (proslicChanType_ptr hProslic, ProslicMuteModes muteEn);

/*
**
** PROSLIC CONFIGURATION FUNCTIONS
**
*/

/*
** Function: PROSLIC_RingSetup
**
** Description:
** configure ringing
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pRingSetup: pointer to ringing config structure
**
** Return:
** none
*/
int Si324x_RingSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_ToneGenSetup
**
** Description:
** configure tone generators
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pTone: pointer to tones config structure
**
** Return:
** none
*/
int Si324x_ToneGenSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_FSKSetup
**
** Description:
** configure fsk
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pFsk: pointer to fsk config structure
**
** Return:
** none
*/
int Si324x_FSKSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_DTMFDecodeSetup
**
** Description:
** configure dtmf decode
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pDTMFDec: pointer to dtmf decoder config structure
**
** Return:
** none
*/
int Si324x_DTMFDecodeSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_SetProfile
**
** Description:
** set country profile of the proslic
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pCountryData: pointer to country config structure
**
** Return:
** none
*/
int Si324x_SetProfile (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_ZsynthSetup
**
** Description:
** configure impedence synthesis
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pZynth: pointer to zsynth config structure
**
** Return:
** none
*/
int Si324x_ZsynthSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_GciCISetup
**
** Description:
** configure CI bits (GCI mode)
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pCI: pointer to ringing config structure
**
** Return:
** none
*/
int Si324x_GciCISetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_ModemDetSetup
**
** Description:
** configure modem detector
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pModemDet: pointer to modem det config structure
**
** Return:
** none
*/
int Si324x_ModemDetSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_AudioGainSetup
**
** Description:
** configure audio gains
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pAudio: pointer to audio gains config structure
**
** Return:
** none
*/
int Si324x_TXAudioGainSetup (proslicChanType *pProslic, int preset);
int Si324x_RXAudioGainSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_HybridSetup
**
** Description:
** configure Proslic hybrid
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pHybridCfg: pointer to ringing config structure
**
** Return:
** none
*/
int Si324x_HybridSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_AudioEQSetup
**
** Description:
** configure audio equalizers
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pAudioEQ: pointer to ringing config structure
**
** Return:
** none
*/
int Si324x_AudioEQSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_DCFeedSetup
**
** Description:
** configure dc feed
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pDcFeed: pointer to dc feed config structure
**
** Return:
** none
*/
int Si324x_DCFeedSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_GPIOSetup
**
** Description:
** configure gpio
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pGpio: pointer to gpio config structure
**
** Return:
** none
*/
int Si324x_GPIOSetup (proslicChanType *pProslic);

/*
** Function: PROSLIC_PulseMeterSetup
**
** Description:
** configure pulse metering
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pPulseCfg: pointer to pulse metering config structure
**
** Return:
** none
*/
int Si324x_PulseMeterSetup (proslicChanType *pProslic, int preset);

/*
** Function: PROSLIC_PCMSetup
**
** Description:
** configure pcm
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pPcm: pointer to pcm config structure
**
** Return:
** none
*/
int Si324x_PCMSetup (proslicChanType *pProslic, int preset);
int Si324x_PCMTimeSlotSetup (proslicChanType *pProslic, uInt16 rxcount, uInt16 txcount);

/*
**
** PROSLIC CONTROL FUNCTIONS
**
*/

/*
** Function: PROSLIC_FindInterruptChannels
**
** Description:
** Finds channels needing serviced
**
** Input Parameters:
** hProslic: pointer to Proslic object
** pChannelNumbers: pointer to channel numbers
**
** Return:
**
*/
int Si324x_FindInterruptChannels (proslicChanType_ptr hProslic, uInt8 *pChannelNumbers);

/*
** Function: PROSLIC_GetInterrupts
**
** Description:
** Enables interrupts
**
** Input Parameters:
** hProslic: pointer to Proslic object
** pIntData: pointer to interrupt info retrieved
**
** Return:
**
*/
int Si324x_GetInterrupts (proslicChanType_ptr hProslic, proslicIntType *pIntData);

/*
** Function: PROSLIC_ClearInterrupts
**
** Description:
** Clears interrupts (GCI only)
**
** Input Parameters:
** hProslic: pointer to Proslic object
**
** Return:
**
*/
int Si324x_ClearInterrupts (proslicChanType_ptr hProslic);

/*
** Function: PROSLIC_ReadHookStatus
**
** Description:
** Determine hook status
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pHookStat: current hook status
**
** Return:
** none
*/
int Si324x_ReadHookStatus (proslicChanType *pProslic,uInt8 *pHookStat);

/*
** Function: PROSLIC_WriteLinefeed
**
** Description:
** Sets linefeed state
**
** Input Parameters:
** pProslic: pointer to Proslic object
** newLinefeed: new linefeed state
**
** Return:
** none
*/
int Si324x_SetLinefeedStatus (proslicChanType *pProslic, uInt8 newLinefeed);

/*
** Function: PROSLIC_WriteLinefeed
**
** Description:
** Sets linefeed state
**
** Input Parameters:
** pProslic: pointer to Proslic object
** newLinefeed: new linefeed state
**
** Return:
** none
*/
int Si324x_SetLinefeedStatusBroadcast (proslicChanType *pProslic, uInt8 newLinefeed);

/*
** Function: PROSLIC_PolRev
**
** Description:
** Sets polarity reversal state
**
** Input Parameters:
** pProslic: pointer to Proslic object
** abrupt: set this to 1 for abrupt pol rev
** newPolRevState: new pol rev state
**
** Return:
** none
*/
int Si324x_PolRev (proslicChanType *pProslic,uInt8 abrupt, uInt8 newPolRevState);

/*
** Function: PROSLIC_GPIOControl
**
** Description:
** Sets gpio of the proslic
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pGpioData: pointer to gpio status
** read: set to 1 to read status, 0 to write
**
** Return:
** none
*/
int Si324x_GPIOControl (proslicChanType *pProslic,uInt8 *pGpioData, uInt8 read);

/*
** Function: PROSLIC_MWI
**
** Description:
** implements message waiting indicator
**
** Input Parameters:
** pProslic: pointer to Proslic object
** lampOn: 0 = turn lamp off, 1 = turn lamp on
**
** Return:
** none
*/
int Si324x_MWI (proslicChanType *pProslic,uInt8 lampOn);

/*
** Function: PROSLIC_StartGenericTone
**
** Description:
** Initializes and start tone generators
**
** Input Parameters:
** pProslic: pointer to Proslic object
** timerEn: specifies whether to enable the tone generator timers
**
** Return:
** none
*/
int Si324x_ToneGenStart (proslicChanType *pProslic, uInt8 timerEn);


/*
** Function: PROSLIC_StopTone
**
** Description:
** Stops tone generators
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_ToneGenStop (proslicChanType *pProslic);


/*
** Function: PROSLIC_StartRing
**
** Description:
** Initializes and start ring generator
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_RingStart (proslicChanType *pProslic);


/*
** Function: PROSLIC_StopRing
**
** Description:
** Stops ring generator
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_RingStop (proslicChanType *pProslic);

/*
** Function: PROSLIC_EnableCID
**
** Description:
** enable fsk
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_EnableCID (proslicChanType *pProslic);

/*
** Function: PROSLIC_DisableCID
**
** Description:
** disable fsk
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_DisableCID (proslicChanType *pProslic);

/*
** Function: PROSLIC_SendCID
**
** Description:
** send fsk data
**
** Input Parameters:
** pProslic: pointer to Proslic object
** buffer: buffer to send
** numBytes: num of bytes in the buffer
**
** Return:
** none
*/
int Si324x_SendCID (proslicChanType *pProslic, uInt8 *buffer, uInt8 numBytes);

int Si324x_CheckCIDBuffer (proslicChanType *pProslic, uInt8 *fsk_buf_avail);

/*
** Function: PROSLIC_StartPCM
**
** Description:
** Starts PCM
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PCMStart (proslicChanType *pProslic);


/*
** Function: PROSLIC_StopPCM
**
** Description:
** Disables PCM
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PCMStop (proslicChanType *pProslic);

/*
** Function: PROSLIC_DialPulseDetect
**
** Description:
** implements pulse dial detection and should be called at every off/on hook transistion
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pPulsedialCfg: pointer to pulse dial config
** pPulseDialData: pointer to pulse dial state for current channel
**
** Return:
** none
*/
int Si324x_DialPulseDetect (proslicChanType *pProslic, pulseDial_Cfg *pPulsedialCfg, pulseDialType *pPulseDialData);

/*
** Function: PROSLIC_ReadDTMFDigit
**
** Description:
** Read DTMF digit (would be called after DTMF interrupt to collect digit)
**
** Input Parameters:
** pProslic: pointer to Proslic object
** pDigit: digit read
**
** Return:
** none
*/
int Si324x_DTMFReadDigit (proslicChanType *pProslic,uInt8 *pDigit);

/*
** Function: PROSLIC_PLLFreeRunStart
**
** Description:
** initiates pll free run mode
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PLLFreeRunStart (proslicChanType *pProslic);

int Si324x_VerifyControlInterface (proslicChanType_ptr pProslic);
int Si324x_PrintDebugData (proslicChanType *pProslic);
/*
** Function: PROSLIC_PLLFreeRunStop
**
** Description:
** exit pll free run mode
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PLLFreeRunStop (proslicChanType *pProslic);

/*
** Function: PROSLIC_PulseMeterStart
**
** Description:
** start pulse meter tone
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PulseMeterStart (proslicChanType *pProslic);

/*
** Function: PROSLIC_PulseMeterStop
**
** Description:
** stop pulse meter tone
**
** Input Parameters:
** pProslic: pointer to Proslic object
**
** Return:
** none
*/
int Si324x_PulseMeterStop (proslicChanType *pProslic);

int Si324x_LBCal (proslicChanType_ptr *pProslic, int size);
int Si324x_LBCalBroadcast (proslicChanType *pProslic);
int Si324x_GetLBCalResult (proslicChanType *pProslic,int32*result1,int32*result2,int32 *result3,int32 *result4);
int Si324x_GetLBCalResultPacked (proslicChanType *pProslic,int32 *result);
int Si324x_LoadPreviousLBCal (proslicChanType *pProslic,int32 result1,int32 result2,int32 result3,int32 result4);
int Si324x_LoadPreviousLBCalPacked (proslicChanType *pProslic,int32 *result);
#endif
