/*
 * Copyright (c) Likewise Software.  All rights Reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewise.com
 */

#ifndef __LW_MAP_SECURITY_PLUGIN_H__
#define __LW_MAP_SECURITY_PLUGIN_H__

#include <lw/security-types.h>
#include <lw/ntstatus.h>
#include <lw/mapsecurity.h>
#include <lw/mapsecurity-types.h>

NTSTATUS
LwMapSecurityInitializeSidFromUnmappedId(
    IN ULONG SidSize,
    OUT PSID Sid,
    IN BOOLEAN IsUser,
    IN ULONG Id
    );

typedef struct _ACCESS_TOKEN_CREATE_INFORMATION {
    PTOKEN_USER User;
    PTOKEN_GROUPS Groups;
#if 0
    TOKEN_PRIVILEGES Privileges;
#endif
    PTOKEN_OWNER Owner;
    PTOKEN_PRIMARY_GROUP PrimaryGroup;
    PTOKEN_DEFAULT_DACL DefaultDacl;
    PTOKEN_UNIX Unix;
} ACCESS_TOKEN_CREATE_INFORMATION, *PACCESS_TOKEN_CREATE_INFORMATION;

typedef struct _LW_MAP_SECURITY_PLUGIN_CONTEXT *PLW_MAP_SECURITY_PLUGIN_CONTEXT;

// LWMSP = LW_MAP_SECURITY_PLUGIN

typedef
VOID
(*LWMSP_FREE_CONTEXT_CALLBACK)(
    IN OUT PLW_MAP_SECURITY_PLUGIN_CONTEXT* Context
    );

typedef
NTSTATUS
(*LWMSP_GET_ID_FROM_SID_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PBOOLEAN IsUser,
    OUT PULONG Id,
    IN PSID Sid
    );

typedef
NTSTATUS
(*LWMSP_GET_SID_FROM_ID_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PSID* Sid,
    IN BOOLEAN IsUser,
    IN ULONG Id
    );

typedef
NTSTATUS
(*LWMSP_GET_SID_FROM_NAME_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PSID* Sid,
    IN BOOLEAN IsUser,
    IN PCSTR Name
    );

typedef
NTSTATUS
(*LWMSP_DUPLICATE_SID_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    IN OUT PSID* Sid,
    IN PSID OriginalSid
    );

typedef
VOID
(*LWMSP_FREE_SID_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    IN OUT PSID* Sid
    );

typedef
NTSTATUS
(*LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_UID_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PACCESS_TOKEN_CREATE_INFORMATION* CreateInformation,
    IN ULONG Uid,
    IN OPTIONAL PULONG Gid
    );

typedef
NTSTATUS
(*LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_USERNAME_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PACCESS_TOKEN_CREATE_INFORMATION* CreateInformation,
    IN PUNICODE_STRING Username
    );

typedef
NTSTATUS
(*LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_GSS_CONTEXT_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PACCESS_TOKEN_CREATE_INFORMATION* CreateInformation,
    IN LW_MAP_SECURITY_GSS_CONTEXT GssContext
    );

typedef
VOID
(*LWMSP_FREE_ACCESS_TOKEN_CREATE_INFORMATION_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    IN OUT PACCESS_TOKEN_CREATE_INFORMATION* CreateInformation
    );

typedef
NTSTATUS
(*LWMSP_GET_ACCESS_TOKE_CREATE_INFORMATION_FROM_NTLM_LOGON_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    OUT PACCESS_TOKEN_CREATE_INFORMATION* CreateInformation,
    IN PLW_MAP_SECURITY_NTLM_LOGON_INFO pNtlmInfo,
    OUT PLW_MAP_SECURITY_NTLM_LOGON_RESULT* ppNtlmResult
    );

typedef
VOID
(*LWMSP_FREE_NTLM_LOGON_RESULT_CALLBACK)(
    IN PLW_MAP_SECURITY_PLUGIN_CONTEXT Context,
    IN OUT PLW_MAP_SECURITY_NTLM_LOGON_RESULT* ppNtlmResult
    );

typedef struct _LW_MAP_SECURITY_PLUGIN_INTERFACE {
    LWMSP_FREE_CONTEXT_CALLBACK FreeContext;
    LWMSP_GET_ID_FROM_SID_CALLBACK GetIdFromSid;
    LWMSP_GET_SID_FROM_ID_CALLBACK GetSidFromId;
    LWMSP_GET_SID_FROM_NAME_CALLBACK GetSidFromName;
    LWMSP_DUPLICATE_SID_CALLBACK DuplicateSid;
    LWMSP_FREE_SID_CALLBACK FreeSid;
    LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_UID_CALLBACK GetAccessTokenCreateInformationFromUid;
    LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_USERNAME_CALLBACK GetAccessTokenCreateInformationFromUsername;
    LWMSP_GET_ACCESS_TOKEN_CREATE_INFORMATION_FROM_GSS_CONTEXT_CALLBACK GetAccessTokenCreateInformationFromGssContext;
    LWMSP_FREE_ACCESS_TOKEN_CREATE_INFORMATION_CALLBACK FreeAccessTokenCreateInformation;
    LWMSP_GET_ACCESS_TOKE_CREATE_INFORMATION_FROM_NTLM_LOGON_CALLBACK GetAccessTokenCreateInformationFromNtlmLogon;
    LWMSP_FREE_NTLM_LOGON_RESULT_CALLBACK FreeNtlmLogonResult;
} LW_MAP_SECURITY_PLUGIN_INTERFACE, *PLW_MAP_SECURITY_PLUGIN_INTERFACE;

#define LWMSP_CREATE_CONTEXT_FUNCTION_NAME \
    "MapSecurityPluginCreateContext"

typedef
NTSTATUS
(*LWMSP_CREATE_CONTEXT_CALLBACK)(
    OUT PLW_MAP_SECURITY_PLUGIN_CONTEXT* Context,
    OUT PLW_MAP_SECURITY_PLUGIN_INTERFACE* Interface
    );


VOID
LwMapSecurityUseInternalPlugin(
    IN LWMSP_CREATE_CONTEXT_CALLBACK pCreateContextCallback
    );


#endif /* __LW_SECURITY_TOKEN_CREATE_INFO_H__ */
