/*
 * Copyright Likewise Software    2004-2009
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the license, or (at
 * your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
 * General Public License for more details.  You should have received a copy
 * of the GNU Lesser General Public License along with this program.  If
 * not, see <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * LESSER GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

#ifndef __KRB5ERROR_TABLE_H__
#define __KRB5ERROR_TABLE_H__

#include <krb5.h>
#include <profile.h>
#include <lwdef.h>

struct krb5err_lwerr {
    krb5_error_code krb5err;
    DWORD lwerr;
    PCSTR pszKrb5errStr;
};

#define LWERR(krb5err, lwerr) { krb5err, lwerr, #krb5err }

static const struct krb5err_lwerr krb5err_lwerr_map[] = {
    LWERR(ASN1_BAD_TIMEFORMAT, LW_ERROR_KRB5_ASN1_BAD_TIMEFORMAT),
    LWERR(ASN1_MISSING_FIELD, LW_ERROR_KRB5_ASN1_MISSING_FIELD),
    LWERR(ASN1_MISPLACED_FIELD, LW_ERROR_KRB5_ASN1_MISPLACED_FIELD),
    LWERR(ASN1_TYPE_MISMATCH, LW_ERROR_KRB5_ASN1_TYPE_MISMATCH),
    LWERR(ASN1_OVERFLOW, LW_ERROR_KRB5_ASN1_OVERFLOW),
    LWERR(ASN1_OVERRUN, LW_ERROR_KRB5_ASN1_OVERRUN),
    LWERR(ASN1_BAD_ID, LW_ERROR_KRB5_ASN1_BAD_ID),
    LWERR(ASN1_BAD_LENGTH, LW_ERROR_KRB5_ASN1_BAD_LENGTH),
    LWERR(ASN1_BAD_FORMAT, LW_ERROR_KRB5_ASN1_BAD_FORMAT),
    LWERR(ASN1_PARSE_ERROR, LW_ERROR_KRB5_ASN1_PARSE_ERROR),
    LWERR(ASN1_BAD_GMTIME, LW_ERROR_KRB5_ASN1_BAD_GMTIME),
    LWERR(ASN1_MISMATCH_INDEF, LW_ERROR_KRB5_ASN1_MISMATCH_INDEF),
    LWERR(ASN1_MISSING_EOC, LW_ERROR_KRB5_ASN1_MISSING_EOC),

    LWERR(KRB524_KRB4_DISABLED, LW_ERROR_KRB524_KRB4_DISABLED),

    LWERR(KRB5KDC_ERR_NONE, LW_ERROR_KRB5KDC_ERR_NONE),
    LWERR(KRB5KDC_ERR_NAME_EXP, LW_ERROR_KRB5KDC_ERR_NAME_EXP),
    LWERR(KRB5KDC_ERR_SERVICE_EXP, LW_ERROR_KRB5KDC_ERR_SERVICE_EXP),
    LWERR(KRB5KDC_ERR_BAD_PVNO, LW_ERROR_KRB5KDC_ERR_BAD_PVNO),
    LWERR(KRB5KDC_ERR_C_OLD_MAST_KVNO, LW_ERROR_KRB5KDC_ERR_C_OLD_MAST_KVNO),
    LWERR(KRB5KDC_ERR_S_OLD_MAST_KVNO, LW_ERROR_KRB5KDC_ERR_S_OLD_MAST_KVNO),
    LWERR(KRB5KDC_ERR_C_PRINCIPAL_UNKNOWN, LW_ERROR_INVALID_ACCOUNT),
    LWERR(KRB5KDC_ERR_S_PRINCIPAL_UNKNOWN, LW_ERROR_KRB5_S_PRINCIPAL_UNKNOWN),
    LWERR(KRB5KDC_ERR_PRINCIPAL_NOT_UNIQUE, LW_ERROR_KRB5KDC_ERR_PRINCIPAL_NOT_UNIQUE),
    LWERR(KRB5KDC_ERR_NULL_KEY, LW_ERROR_KRB5KDC_ERR_NULL_KEY),
    LWERR(KRB5KDC_ERR_CANNOT_POSTDATE, LW_ERROR_KRB5KDC_ERR_CANNOT_POSTDATE),
    LWERR(KRB5KDC_ERR_POLICY, LW_ERROR_KRB5KDC_ERR_POLICY),
    LWERR(KRB5KDC_ERR_BADOPTION, LW_ERROR_KRB5KDC_ERR_BADOPTION),
    LWERR(KRB5KDC_ERR_ETYPE_NOSUPP, LW_ERROR_KRB5KDC_ERR_ETYPE_NOSUPP),
    LWERR(KRB5KDC_ERR_SUMTYPE_NOSUPP, LW_ERROR_KRB5KDC_ERR_SUMTYPE_NOSUPP),
    LWERR(KRB5KDC_ERR_PADATA_TYPE_NOSUPP, LW_ERROR_KRB5KDC_ERR_PADATA_TYPE_NOSUPP),
    LWERR(KRB5KDC_ERR_TRTYPE_NOSUPP, LW_ERROR_KRB5KDC_ERR_TRTYPE_NOSUPP),
    LWERR(KRB5KDC_ERR_CLIENT_REVOKED, LW_ERROR_ACCOUNT_DISABLED),
    LWERR(KRB5KDC_ERR_SERVICE_REVOKED, LW_ERROR_KRB5KDC_ERR_SERVICE_REVOKED),
    LWERR(KRB5KDC_ERR_TGT_REVOKED, LW_ERROR_KRB5KDC_ERR_TGT_REVOKED),
    LWERR(KRB5KDC_ERR_CLIENT_NOTYET, LW_ERROR_KRB5KDC_ERR_CLIENT_NOTYET),
    LWERR(KRB5KDC_ERR_SERVICE_NOTYET, LW_ERROR_KRB5KDC_ERR_SERVICE_NOTYET),
    LWERR(KRB5KDC_ERR_KEY_EXP, LW_ERROR_PASSWORD_EXPIRED),
    LWERR(KRB5KDC_ERR_PREAUTH_FAILED, LW_ERROR_PASSWORD_MISMATCH),
    LWERR(KRB5KDC_ERR_PREAUTH_REQUIRED, LW_ERROR_KRB5KDC_ERR_PREAUTH_REQUIRED),
    LWERR(KRB5KDC_ERR_SERVER_NOMATCH, LW_ERROR_KRB5KDC_ERR_SERVER_NOMATCH),

    LWERR(KRB5KDC_ERR_SVC_UNAVAILABLE, LW_ERROR_KRB5KDC_ERR_SVC_UNAVAILABLE),

    LWERR(KRB5KRB_AP_ERR_BAD_INTEGRITY, LW_ERROR_PASSWORD_MISMATCH),
    LWERR(KRB5KRB_AP_ERR_TKT_EXPIRED, LW_ERROR_KRB5KRB_AP_ERR_TKT_EXPIRED),
    LWERR(KRB5KRB_AP_ERR_TKT_NYV, LW_ERROR_KRB5KRB_AP_ERR_TKT_NYV),
    LWERR(KRB5KRB_AP_ERR_REPEAT, LW_ERROR_KRB5KRB_AP_ERR_REPEAT),
    LWERR(KRB5KRB_AP_ERR_NOT_US, LW_ERROR_KRB5KRB_AP_ERR_NOT_US),
    LWERR(KRB5KRB_AP_ERR_BADMATCH, LW_ERROR_KRB5KRB_AP_ERR_BADMATCH),
    LWERR(KRB5KRB_AP_ERR_SKEW, LW_ERROR_CLOCK_SKEW),
    LWERR(KRB5KRB_AP_ERR_BADADDR, LW_ERROR_KRB5KRB_AP_ERR_BADADDR),
    LWERR(KRB5KRB_AP_ERR_BADVERSION, LW_ERROR_KRB5KRB_AP_ERR_BADVERSION),
    LWERR(KRB5KRB_AP_ERR_MSG_TYPE, LW_ERROR_KRB5KRB_AP_ERR_MSG_TYPE),
    LWERR(KRB5KRB_AP_ERR_MODIFIED, LW_ERROR_KRB5KRB_AP_ERR_MODIFIED),
    LWERR(KRB5KRB_AP_ERR_BADORDER, LW_ERROR_KRB5KRB_AP_ERR_BADORDER),
    LWERR(KRB5KRB_AP_ERR_ILL_CR_TKT, LW_ERROR_KRB5KRB_AP_ERR_ILL_CR_TKT),
    LWERR(KRB5KRB_AP_ERR_BADKEYVER, LW_ERROR_KRB5KRB_AP_ERR_BADKEYVER),
    LWERR(KRB5KRB_AP_ERR_NOKEY, LW_ERROR_KRB5KRB_AP_ERR_NOKEY),
    LWERR(KRB5KRB_AP_ERR_MUT_FAIL, LW_ERROR_KRB5KRB_AP_ERR_MUT_FAIL),
    LWERR(KRB5KRB_AP_ERR_BADDIRECTION, LW_ERROR_KRB5KRB_AP_ERR_BADDIRECTION),
    LWERR(KRB5KRB_AP_ERR_METHOD, LW_ERROR_KRB5KRB_AP_ERR_METHOD),
    LWERR(KRB5KRB_AP_ERR_BADSEQ, LW_ERROR_KRB5KRB_AP_ERR_BADSEQ),
    LWERR(KRB5KRB_AP_ERR_INAPP_CKSUM, LW_ERROR_KRB5KRB_AP_ERR_INAPP_CKSUM),
    LWERR(KRB5KRB_AP_PATH_NOT_ACCEPTED, LW_ERROR_KRB5KRB_AP_PATH_NOT_ACCEPTED),
    LWERR(KRB5KRB_ERR_RESPONSE_TOO_BIG, LW_ERROR_KRB5KRB_ERR_RESPONSE_TOO_BIG),

    LWERR(KRB5KRB_ERR_GENERIC, LW_ERROR_KRB5KRB_ERR_GENERIC),
    LWERR(KRB5KRB_ERR_FIELD_TOOLONG, LW_ERROR_KRB5KRB_ERR_FIELD_TOOLONG),
    LWERR(KRB5KDC_ERR_CLIENT_NOT_TRUSTED, LW_ERROR_KRB5KDC_ERR_CLIENT_NOT_TRUSTED),
    LWERR(KRB5KDC_ERR_KDC_NOT_TRUSTED, LW_ERROR_KRB5KDC_ERR_KDC_NOT_TRUSTED),
    LWERR(KRB5KDC_ERR_INVALID_SIG, LW_ERROR_KRB5KDC_ERR_INVALID_SIG),
    LWERR(KRB5KDC_ERR_DH_KEY_PARAMETERS_NOT_ACCEPTED, LW_ERROR_KRB5KDC_ERR_DH_KEY_PARAMETERS_NOT_ACCEPTED),
    LWERR(KRB5KDC_ERR_CERTIFICATE_MISMATCH, LW_ERROR_KRB5KDC_ERR_CERTIFICATE_MISMATCH),

    LWERR(KRB5KDC_ERR_CANT_VERIFY_CERTIFICATE, LW_ERROR_KRB5KDC_ERR_CANT_VERIFY_CERTIFICATE),
    LWERR(KRB5KDC_ERR_INVALID_CERTIFICATE, LW_ERROR_KRB5KDC_ERR_INVALID_CERTIFICATE),
    LWERR(KRB5KDC_ERR_REVOKED_CERTIFICATE, LW_ERROR_KRB5KDC_ERR_REVOKED_CERTIFICATE),
    LWERR(KRB5KDC_ERR_REVOCATION_STATUS_UNKNOWN, LW_ERROR_KRB5KDC_ERR_REVOCATION_STATUS_UNKNOWN),
    LWERR(KRB5KDC_ERR_REVOCATION_STATUS_UNAVAILABLE, LW_ERROR_KRB5KDC_ERR_REVOCATION_STATUS_UNAVAILABLE),
    LWERR(KRB5KDC_ERR_CLIENT_NAME_MISMATCH, LW_ERROR_KRB5KDC_ERR_CLIENT_NAME_MISMATCH),
    LWERR(KRB5KDC_ERR_KDC_NAME_MISMATCH, LW_ERROR_KRB5KDC_ERR_KDC_NAME_MISMATCH),
    LWERR(KRB5KDC_ERR_INCONSISTENT_KEY_PURPOSE, LW_ERROR_KRB5KDC_ERR_INCONSISTENT_KEY_PURPOSE),
    LWERR(KRB5KDC_ERR_DIGEST_IN_CERT_NOT_ACCEPTED, LW_ERROR_KRB5KDC_ERR_DIGEST_IN_CERT_NOT_ACCEPTED),
    LWERR(KRB5KDC_ERR_PA_CHECKSUM_MUST_BE_INCLUDED, LW_ERROR_KRB5KDC_ERR_PA_CHECKSUM_MUST_BE_INCLUDED),
    LWERR(KRB5KDC_ERR_DIGEST_IN_SIGNED_DATA_NOT_ACCEPTED, LW_ERROR_KRB5KDC_ERR_DIGEST_IN_SIGNED_DATA_NOT_ACCEPTED),
    LWERR(KRB5KDC_ERR_PUBLIC_KEY_ENCRYPTION_NOT_SUPPORTED, LW_ERROR_KRB5KDC_ERR_PUBLIC_KEY_ENCRYPTION_NOT_SUPPORTED),

    LWERR(KRB5_ERR_RCSID, LW_ERROR_KRB5_ERR_RCSID),
    LWERR(KRB5_LIBOS_BADLOCKFLAG, LW_ERROR_KRB5_LIBOS_BADLOCKFLAG),
    LWERR(KRB5_LIBOS_CANTREADPWD, LW_ERROR_KRB5_LIBOS_CANTREADPWD),
    LWERR(KRB5_LIBOS_BADPWDMATCH, LW_ERROR_PASSWORD_MISMATCH),
    LWERR(KRB5_LIBOS_PWDINTR, LW_ERROR_KRB5_LIBOS_PWDINTR),
    LWERR(KRB5_PARSE_ILLCHAR, LW_ERROR_KRB5_PARSE_ILLCHAR),
    LWERR(KRB5_PARSE_MALFORMED, LW_ERROR_KRB5_PARSE_MALFORMED),
    LWERR(KRB5_CONFIG_CANTOPEN, LW_ERROR_KRB5_CONFIG_CANTOPEN),
    LWERR(KRB5_CONFIG_BADFORMAT, LW_ERROR_KRB5_CONFIG_BADFORMAT),
    LWERR(KRB5_CONFIG_NOTENUFSPACE, LW_ERROR_KRB5_CONFIG_NOTENUFSPACE),
    LWERR(KRB5_BADMSGTYPE, LW_ERROR_KRB5_BADMSGTYPE),
    LWERR(KRB5_CC_BADNAME, LW_ERROR_KRB5_CC_BADNAME),
    LWERR(KRB5_CC_UNKNOWN_TYPE, LW_ERROR_KRB5_CC_UNKNOWN_TYPE),
    LWERR(KRB5_CC_NOTFOUND, LW_ERROR_KRB5_CC_NOTFOUND),
    LWERR(KRB5_CC_END, LW_ERROR_KRB5_CC_END),
    LWERR(KRB5_NO_TKT_SUPPLIED, LW_ERROR_KRB5_NO_TKT_SUPPLIED),
    LWERR(KRB5KRB_AP_WRONG_PRINC, LW_ERROR_KRB5KRB_AP_WRONG_PRINC),
    LWERR(KRB5KRB_AP_ERR_TKT_INVALID, LW_ERROR_KRB5KRB_AP_ERR_TKT_INVALID),
    LWERR(KRB5_PRINC_NOMATCH, LW_ERROR_KRB5_PRINC_NOMATCH),
    LWERR(KRB5_KDCREP_MODIFIED, LW_ERROR_KRB5_KDCREP_MODIFIED),
    LWERR(KRB5_KDCREP_SKEW, LW_ERROR_KRB5_KDCREP_SKEW),
    LWERR(KRB5_IN_TKT_REALM_MISMATCH, LW_ERROR_KRB5_IN_TKT_REALM_MISMATCH),
    LWERR(KRB5_PROG_ETYPE_NOSUPP, LW_ERROR_KRB5_PROG_ETYPE_NOSUPP),
    LWERR(KRB5_PROG_KEYTYPE_NOSUPP, LW_ERROR_KRB5_PROG_KEYTYPE_NOSUPP),
    LWERR(KRB5_WRONG_ETYPE, LW_ERROR_KRB5_WRONG_ETYPE),
    LWERR(KRB5_PROG_SUMTYPE_NOSUPP, LW_ERROR_KRB5_PROG_SUMTYPE_NOSUPP),
    LWERR(KRB5_REALM_UNKNOWN, LW_ERROR_KRB5_REALM_UNKNOWN),
    LWERR(KRB5_SERVICE_UNKNOWN, LW_ERROR_KRB5_SERVICE_UNKNOWN),
    LWERR(KRB5_KDC_UNREACH, LW_ERROR_DOMAIN_IS_OFFLINE),
    LWERR(KRB5_NO_LOCALNAME, LW_ERROR_KRB5_NO_LOCALNAME),
    LWERR(KRB5_MUTUAL_FAILED, LW_ERROR_KRB5_MUTUAL_FAILED),
    LWERR(KRB5_RC_TYPE_EXISTS, LW_ERROR_KRB5_RC_TYPE_EXISTS),
    LWERR(KRB5_RC_MALLOC, LW_ERROR_KRB5_RC_MALLOC),
    LWERR(KRB5_RC_TYPE_NOTFOUND, LW_ERROR_KRB5_RC_TYPE_NOTFOUND),
    LWERR(KRB5_RC_UNKNOWN, LW_ERROR_KRB5_RC_UNKNOWN),
    LWERR(KRB5_RC_REPLAY, LW_ERROR_KRB5_RC_REPLAY),
    LWERR(KRB5_RC_IO, LW_ERROR_KRB5_RC_IO),
    LWERR(KRB5_RC_NOIO, LW_ERROR_KRB5_RC_NOIO),
    LWERR(KRB5_RC_PARSE, LW_ERROR_KRB5_RC_PARSE),
    LWERR(KRB5_RC_IO_EOF, LW_ERROR_KRB5_RC_IO_EOF),
    LWERR(KRB5_RC_IO_MALLOC, LW_ERROR_KRB5_RC_IO_MALLOC),
    LWERR(KRB5_RC_IO_PERM, LW_ERROR_KRB5_RC_IO_PERM),
    LWERR(KRB5_RC_IO_IO, LW_ERROR_KRB5_RC_IO_IO),
    LWERR(KRB5_RC_IO_UNKNOWN, LW_ERROR_KRB5_RC_IO_UNKNOWN),
    LWERR(KRB5_RC_IO_SPACE, LW_ERROR_KRB5_RC_IO_SPACE),
    LWERR(KRB5_TRANS_CANTOPEN, LW_ERROR_KRB5_TRANS_CANTOPEN),
    LWERR(KRB5_TRANS_BADFORMAT, LW_ERROR_KRB5_TRANS_BADFORMAT),
    LWERR(KRB5_LNAME_CANTOPEN, LW_ERROR_KRB5_LNAME_CANTOPEN),
    LWERR(KRB5_LNAME_NOTRANS, LW_ERROR_KRB5_LNAME_NOTRANS),
    LWERR(KRB5_LNAME_BADFORMAT, LW_ERROR_KRB5_LNAME_BADFORMAT),
    LWERR(KRB5_CRYPTO_INTERNAL, LW_ERROR_KRB5_CRYPTO_INTERNAL),
    LWERR(KRB5_KT_BADNAME, LW_ERROR_KRB5_KT_BADNAME),
    LWERR(KRB5_KT_UNKNOWN_TYPE, LW_ERROR_KRB5_KT_UNKNOWN_TYPE),
    LWERR(KRB5_KT_NOTFOUND, LW_ERROR_KRB5_KT_NOTFOUND),
    LWERR(KRB5_KT_END, LW_ERROR_KRB5_KT_END),
    LWERR(KRB5_KT_NOWRITE, LW_ERROR_KRB5_KT_NOWRITE),
    LWERR(KRB5_KT_IOERR, LW_ERROR_KRB5_KT_IOERR),
    LWERR(KRB5_NO_TKT_IN_RLM, LW_ERROR_KRB5_NO_TKT_IN_RLM),
    LWERR(KRB5DES_BAD_KEYPAR, LW_ERROR_KRB5DES_BAD_KEYPAR),
    LWERR(KRB5DES_WEAK_KEY, LW_ERROR_KRB5DES_WEAK_KEY),
    LWERR(KRB5_BAD_ENCTYPE, LW_ERROR_KRB5_BAD_ENCTYPE),
    LWERR(KRB5_BAD_KEYSIZE, LW_ERROR_KRB5_BAD_KEYSIZE),
    LWERR(KRB5_BAD_MSIZE, LW_ERROR_KRB5_BAD_MSIZE),
    LWERR(KRB5_CC_TYPE_EXISTS, LW_ERROR_KRB5_CC_TYPE_EXISTS),
    LWERR(KRB5_KT_TYPE_EXISTS, LW_ERROR_KRB5_KT_TYPE_EXISTS),
    LWERR(KRB5_CC_IO, LW_ERROR_KRB5_CC_IO),
    LWERR(KRB5_FCC_PERM, LW_ERROR_KRB5_FCC_PERM),
    LWERR(KRB5_FCC_NOFILE, LW_ERROR_KRB5_FCC_NOFILE),
    LWERR(KRB5_FCC_INTERNAL, LW_ERROR_KRB5_FCC_INTERNAL),
    LWERR(KRB5_CC_WRITE, LW_ERROR_KRB5_CC_WRITE),
    LWERR(KRB5_CC_NOMEM, LW_ERROR_KRB5_CC_NOMEM),
    LWERR(KRB5_CC_FORMAT, LW_ERROR_KRB5_CC_FORMAT),
    LWERR(KRB5_CC_NOT_KTYPE, LW_ERROR_KRB5_CC_NOT_KTYPE),
    LWERR(KRB5_INVALID_FLAGS, LW_ERROR_KRB5_INVALID_FLAGS),
    LWERR(KRB5_NO_2ND_TKT, LW_ERROR_KRB5_NO_2ND_TKT),
    LWERR(KRB5_NOCREDS_SUPPLIED, LW_ERROR_KRB5_NOCREDS_SUPPLIED),
    LWERR(KRB5_SENDAUTH_BADAUTHVERS, LW_ERROR_KRB5_SENDAUTH_BADAUTHVERS),
    LWERR(KRB5_SENDAUTH_BADAPPLVERS, LW_ERROR_KRB5_SENDAUTH_BADAPPLVERS),
    LWERR(KRB5_SENDAUTH_BADRESPONSE, LW_ERROR_KRB5_SENDAUTH_BADRESPONSE),
    LWERR(KRB5_SENDAUTH_REJECTED, LW_ERROR_KRB5_SENDAUTH_REJECTED),
    LWERR(KRB5_PREAUTH_BAD_TYPE, LW_ERROR_KRB5_PREAUTH_BAD_TYPE),
    LWERR(KRB5_PREAUTH_NO_KEY, LW_ERROR_KRB5_PREAUTH_NO_KEY),
    LWERR(KRB5_PREAUTH_FAILED, LW_ERROR_KRB5_PREAUTH_FAILED),
    LWERR(KRB5_RCACHE_BADVNO, LW_ERROR_KRB5_RCACHE_BADVNO),
    LWERR(KRB5_CCACHE_BADVNO, LW_ERROR_KRB5_CCACHE_BADVNO),
    LWERR(KRB5_KEYTAB_BADVNO, LW_ERROR_KRB5_KEYTAB_BADVNO),
    LWERR(KRB5_PROG_ATYPE_NOSUPP, LW_ERROR_KRB5_PROG_ATYPE_NOSUPP),
    LWERR(KRB5_RC_REQUIRED, LW_ERROR_KRB5_RC_REQUIRED),
    LWERR(KRB5_ERR_BAD_HOSTNAME, LW_ERROR_KRB5_ERR_BAD_HOSTNAME),
    LWERR(KRB5_ERR_HOST_REALM_UNKNOWN, LW_ERROR_KRB5_ERR_HOST_REALM_UNKNOWN),
    LWERR(KRB5_SNAME_UNSUPP_NAMETYPE, LW_ERROR_KRB5_SNAME_UNSUPP_NAMETYPE),
    LWERR(KRB5KRB_AP_ERR_V4_REPLY, LW_ERROR_KRB5KRB_AP_ERR_V4_REPLY),
    LWERR(KRB5_REALM_CANT_RESOLVE, LW_ERROR_KRB5_REALM_CANT_RESOLVE),
    LWERR(KRB5_TKT_NOT_FORWARDABLE, LW_ERROR_KRB5_TKT_NOT_FORWARDABLE),
    LWERR(KRB5_FWD_BAD_PRINCIPAL, LW_ERROR_KRB5_FWD_BAD_PRINCIPAL),
    LWERR(KRB5_GET_IN_TKT_LOOP, LW_ERROR_KRB5_GET_IN_TKT_LOOP),
    LWERR(KRB5_CONFIG_NODEFREALM, LW_ERROR_KRB5_CONFIG_NODEFREALM),
    LWERR(KRB5_SAM_UNSUPPORTED, LW_ERROR_KRB5_SAM_UNSUPPORTED),
    LWERR(KRB5_SAM_INVALID_ETYPE, LW_ERROR_KRB5_SAM_INVALID_ETYPE),
    LWERR(KRB5_SAM_NO_CHECKSUM, LW_ERROR_KRB5_SAM_NO_CHECKSUM),
    LWERR(KRB5_SAM_BAD_CHECKSUM, LW_ERROR_KRB5_SAM_BAD_CHECKSUM),
    LWERR(KRB5_KT_NAME_TOOLONG, LW_ERROR_KRB5_KT_NAME_TOOLONG),
    LWERR(KRB5_KT_KVNONOTFOUND, LW_ERROR_KRB5_KT_KVNONOTFOUND),
    LWERR(KRB5_APPL_EXPIRED, LW_ERROR_KRB5_APPL_EXPIRED),
    LWERR(KRB5_LIB_EXPIRED, LW_ERROR_KRB5_LIB_EXPIRED),
    LWERR(KRB5_CHPW_PWDNULL, LW_ERROR_KRB5_CHPW_PWDNULL),
    LWERR(KRB5_CHPW_FAIL, LW_ERROR_KRB5_CHPW_FAIL),
    LWERR(KRB5_KT_FORMAT, LW_ERROR_KRB5_KT_FORMAT),
    LWERR(KRB5_NOPERM_ETYPE, LW_ERROR_KRB5_NOPERM_ETYPE),
    LWERR(KRB5_CONFIG_ETYPE_NOSUPP, LW_ERROR_KRB5_CONFIG_ETYPE_NOSUPP),
    LWERR(KRB5_OBSOLETE_FN, LW_ERROR_KRB5_OBSOLETE_FN),
    LWERR(KRB5_EAI_FAIL, LW_ERROR_KRB5_EAI_FAIL),
    LWERR(KRB5_EAI_NODATA, LW_ERROR_KRB5_EAI_NODATA),
    LWERR(KRB5_EAI_NONAME, LW_ERROR_KRB5_EAI_NONAME),
    LWERR(KRB5_EAI_SERVICE, LW_ERROR_KRB5_EAI_SERVICE),
    LWERR(KRB5_ERR_NUMERIC_REALM, LW_ERROR_KRB5_ERR_NUMERIC_REALM),
    LWERR(KRB5_ERR_BAD_S2K_PARAMS, LW_ERROR_KRB5_ERR_BAD_S2K_PARAMS),
    LWERR(KRB5_ERR_NO_SERVICE, LW_ERROR_KRB5_ERR_NO_SERVICE),
    LWERR(KRB5_CC_READONLY, LW_ERROR_KRB5_CC_READONLY),
    LWERR(KRB5_CC_NOSUPP, LW_ERROR_KRB5_CC_NOSUPP),
    LWERR(KRB5_DELTAT_BADFORMAT, LW_ERROR_KRB5_DELTAT_BADFORMAT),
    LWERR(KRB5_PLUGIN_NO_HANDLE, LW_ERROR_KRB5_PLUGIN_NO_HANDLE),
    LWERR(KRB5_PLUGIN_OP_NOTSUPP, LW_ERROR_KRB5_PLUGIN_OP_NOTSUPP),

    LWERR(KV5M_NONE, LW_ERROR_KRB5_KV5M_NONE),
    LWERR(KV5M_PRINCIPAL, LW_ERROR_KRB5_KV5M_PRINCIPAL),
    LWERR(KV5M_DATA, LW_ERROR_KRB5_KV5M_DATA),
    LWERR(KV5M_KEYBLOCK, LW_ERROR_KRB5_KV5M_KEYBLOCK),
    LWERR(KV5M_CHECKSUM, LW_ERROR_KRB5_KV5M_CHECKSUM),
    LWERR(KV5M_ENCRYPT_BLOCK, LW_ERROR_KRB5_KV5M_ENCRYPT_BLOCK),
    LWERR(KV5M_ENC_DATA, LW_ERROR_KRB5_KV5M_ENC_DATA),
    LWERR(KV5M_CRYPTOSYSTEM_ENTRY, LW_ERROR_KRB5_KV5M_CRYPTOSYSTEM_ENTRY),
    LWERR(KV5M_CS_TABLE_ENTRY, LW_ERROR_KRB5_KV5M_CS_TABLE_ENTRY),
    LWERR(KV5M_CHECKSUM_ENTRY, LW_ERROR_KRB5_KV5M_CHECKSUM_ENTRY),
    LWERR(KV5M_AUTHDATA, LW_ERROR_KRB5_KV5M_AUTHDATA),
    LWERR(KV5M_TRANSITED, LW_ERROR_KRB5_KV5M_TRANSITED),
    LWERR(KV5M_ENC_TKT_PART, LW_ERROR_KRB5_KV5M_ENC_TKT_PART),
    LWERR(KV5M_TICKET, LW_ERROR_KRB5_KV5M_TICKET),
    LWERR(KV5M_AUTHENTICATOR, LW_ERROR_KRB5_KV5M_AUTHENTICATOR),
    LWERR(KV5M_TKT_AUTHENT, LW_ERROR_KRB5_KV5M_TKT_AUTHENT),
    LWERR(KV5M_CREDS, LW_ERROR_KRB5_KV5M_CREDS),
    LWERR(KV5M_LAST_REQ_ENTRY, LW_ERROR_KRB5_KV5M_LAST_REQ_ENTRY),
    LWERR(KV5M_PA_DATA, LW_ERROR_KRB5_KV5M_PA_DATA),
    LWERR(KV5M_KDC_REQ, LW_ERROR_KRB5_KV5M_KDC_REQ),
    LWERR(KV5M_ENC_KDC_REP_PART, LW_ERROR_KRB5_KV5M_ENC_KDC_REP_PART),
    LWERR(KV5M_KDC_REP, LW_ERROR_KRB5_KV5M_KDC_REP),
    LWERR(KV5M_ERROR, LW_ERROR_KRB5_KV5M_ERROR),
    LWERR(KV5M_AP_REQ, LW_ERROR_KRB5_KV5M_AP_REQ),
    LWERR(KV5M_AP_REP, LW_ERROR_KRB5_KV5M_AP_REP),
    LWERR(KV5M_AP_REP_ENC_PART, LW_ERROR_KRB5_KV5M_AP_REP_ENC_PART),
    LWERR(KV5M_RESPONSE, LW_ERROR_KRB5_KV5M_RESPONSE),
    LWERR(KV5M_SAFE, LW_ERROR_KRB5_KV5M_SAFE),
    LWERR(KV5M_PRIV, LW_ERROR_KRB5_KV5M_PRIV),
    LWERR(KV5M_PRIV_ENC_PART, LW_ERROR_KRB5_KV5M_PRIV_ENC_PART),
    LWERR(KV5M_CRED, LW_ERROR_KRB5_KV5M_CRED),
    LWERR(KV5M_CRED_INFO, LW_ERROR_KRB5_KV5M_CRED_INFO),
    LWERR(KV5M_CRED_ENC_PART, LW_ERROR_KRB5_KV5M_CRED_ENC_PART),
    LWERR(KV5M_PWD_DATA, LW_ERROR_KRB5_KV5M_PWD_DATA),
    LWERR(KV5M_ADDRESS, LW_ERROR_KRB5_KV5M_ADDRESS),
    LWERR(KV5M_KEYTAB_ENTRY, LW_ERROR_KRB5_KV5M_KEYTAB_ENTRY),
    LWERR(KV5M_CONTEXT, LW_ERROR_KRB5_KV5M_CONTEXT),
    LWERR(KV5M_OS_CONTEXT, LW_ERROR_KRB5_KV5M_OS_CONTEXT),
    LWERR(KV5M_ALT_METHOD, LW_ERROR_KRB5_KV5M_ALT_METHOD),
    LWERR(KV5M_ETYPE_INFO_ENTRY, LW_ERROR_KRB5_KV5M_ETYPE_INFO_ENTRY),
    LWERR(KV5M_DB_CONTEXT, LW_ERROR_KRB5_KV5M_DB_CONTEXT),
    LWERR(KV5M_AUTH_CONTEXT, LW_ERROR_KRB5_KV5M_AUTH_CONTEXT),
    LWERR(KV5M_KEYTAB, LW_ERROR_KRB5_KV5M_KEYTAB),
    LWERR(KV5M_RCACHE, LW_ERROR_KRB5_KV5M_RCACHE),
    LWERR(KV5M_CCACHE, LW_ERROR_KRB5_KV5M_CCACHE),
    LWERR(KV5M_PREAUTH_OPS, LW_ERROR_KRB5_KV5M_PREAUTH_OPS),
    LWERR(KV5M_SAM_CHALLENGE, LW_ERROR_KRB5_KV5M_SAM_CHALLENGE),
    LWERR(KV5M_SAM_CHALLENGE_2, LW_ERROR_KRB5_KV5M_SAM_CHALLENGE_2),
    LWERR(KV5M_SAM_KEY, LW_ERROR_KRB5_KV5M_SAM_KEY),
    LWERR(KV5M_ENC_SAM_RESPONSE_ENC, LW_ERROR_KRB5_KV5M_ENC_SAM_RESPONSE_ENC),
    LWERR(KV5M_ENC_SAM_RESPONSE_ENC_2, LW_ERROR_KRB5_KV5M_ENC_SAM_RESPONSE_ENC_2),
    LWERR(KV5M_SAM_RESPONSE, LW_ERROR_KRB5_KV5M_SAM_RESPONSE),
    LWERR(KV5M_SAM_RESPONSE_2, LW_ERROR_KRB5_KV5M_SAM_RESPONSE_2),
    LWERR(KV5M_PREDICTED_SAM_RESPONSE, LW_ERROR_KRB5_KV5M_PREDICTED_SAM_RESPONSE),
    LWERR(KV5M_PASSWD_PHRASE_ELEMENT, LW_ERROR_KRB5_KV5M_PASSWD_PHRASE_ELEMENT),
    LWERR(KV5M_GSS_OID, LW_ERROR_KRB5_KV5M_GSS_OID),
    LWERR(KV5M_GSS_QUEUE, LW_ERROR_KRB5_KV5M_GSS_QUEUE),

    LWERR(PROF_VERSION, LW_ERROR_KRB5_PROF_VERSION),
    LWERR(PROF_MAGIC_NODE, LW_ERROR_KRB5_PROF_MAGIC_NODE),
    LWERR(PROF_NO_SECTION, LW_ERROR_KRB5_PROF_NO_SECTION),
    LWERR(PROF_NO_RELATION, LW_ERROR_KRB5_PROF_NO_RELATION),
    LWERR(PROF_ADD_NOT_SECTION, LW_ERROR_KRB5_PROF_ADD_NOT_SECTION),
    LWERR(PROF_SECTION_WITH_VALUE, LW_ERROR_KRB5_PROF_SECTION_WITH_VALUE),
    LWERR(PROF_BAD_LINK_LIST, LW_ERROR_KRB5_PROF_BAD_LINK_LIST),
    LWERR(PROF_BAD_GROUP_LVL, LW_ERROR_KRB5_PROF_BAD_GROUP_LVL),
    LWERR(PROF_BAD_PARENT_PTR, LW_ERROR_KRB5_PROF_BAD_PARENT_PTR),
    LWERR(PROF_MAGIC_ITERATOR, LW_ERROR_KRB5_PROF_MAGIC_ITERATOR),
    LWERR(PROF_SET_SECTION_VALUE, LW_ERROR_KRB5_PROF_SET_SECTION_VALUE),
    LWERR(PROF_EINVAL, LW_ERROR_KRB5_PROF_EINVAL),
    LWERR(PROF_READ_ONLY, LW_ERROR_KRB5_PROF_READ_ONLY),
    LWERR(PROF_SECTION_NOTOP, LW_ERROR_KRB5_PROF_SECTION_NOTOP),
    LWERR(PROF_SECTION_SYNTAX, LW_ERROR_KRB5_PROF_SECTION_SYNTAX),
    LWERR(PROF_RELATION_SYNTAX, LW_ERROR_KRB5_PROF_RELATION_SYNTAX),
    LWERR(PROF_EXTRA_CBRACE, LW_ERROR_KRB5_PROF_EXTRA_CBRACE),
    LWERR(PROF_MISSING_OBRACE, LW_ERROR_KRB5_PROF_MISSING_OBRACE),
    LWERR(PROF_MAGIC_PROFILE, LW_ERROR_KRB5_PROF_MAGIC_PROFILE),
    LWERR(PROF_MAGIC_SECTION, LW_ERROR_KRB5_PROF_MAGIC_SECTION),
    LWERR(PROF_TOPSECTION_ITER_NOSUPP, LW_ERROR_KRB5_PROF_TOPSECTION_ITER_NOSUPP),
    LWERR(PROF_INVALID_SECTION, LW_ERROR_KRB5_PROF_INVALID_SECTION),
    LWERR(PROF_END_OF_SECTIONS, LW_ERROR_KRB5_PROF_END_OF_SECTIONS),
    LWERR(PROF_BAD_NAMESET, LW_ERROR_KRB5_PROF_BAD_NAMESET),
    LWERR(PROF_NO_PROFILE, LW_ERROR_KRB5_PROF_NO_PROFILE),
    LWERR(PROF_MAGIC_FILE, LW_ERROR_KRB5_PROF_MAGIC_FILE),
    LWERR(PROF_FAIL_OPEN, LW_ERROR_KRB5_PROF_FAIL_OPEN),
    LWERR(PROF_EXISTS, LW_ERROR_KRB5_PROF_EXISTS),
    LWERR(PROF_BAD_BOOLEAN, LW_ERROR_KRB5_PROF_BAD_BOOLEAN),
    LWERR(PROF_BAD_INTEGER, LW_ERROR_KRB5_PROF_BAD_INTEGER),
    LWERR(PROF_MAGIC_FILE_DATA, LW_ERROR_KRB5_PROF_MAGIC_FILE_DATA),

    /* termination  */
    { 0, 0, NULL }
};

#undef LWERR

#endif /* __KRB5ERROR_TABLE_H__ */
