/* -*- mode: C; c-basic-offset: 4 -*- */

#include <gtk/gtk.h>

G_BEGIN_DECLS

/* set the source package name to point the menu items at.
 * If this is not set, then the source package name will be
 * inferred from the process ID and dpkg database (if possible).
 */
void            launchpad_integration_set_sourcepackagename (const char *name);

/* callbacks to invoke launchpad on the given URLs */
void            launchpad_integration_show_info         (void);
void            launchpad_integration_show_translations (void);
void            launchpad_integration_show_bugs         (void);

/* returns an action group containing actions for the above */
GtkActionGroup *launchpad_integration_get_action_group  (void);

/* adds the action group to the UI, and creates UI nodes at the given
 * UI path */
void            launchpad_integration_add_ui            (GtkUIManager *ui,
							 const char *path);

/* Add launchpad integration menu items to the given menu at the given
 * position.  If the position is negative, then it is used as an index
 * from the end of the menu.
 * The 3rd and 4th arguments are used to say whether to add a separator
 * before and/or after the items. */
void            launchpad_integration_add_items (GtkWidget *helpmenu,
						 int position,
						 gboolean separator_before,
						 gboolean separator_after);

void launchpad_integration_add_item_factory ();

G_END_DECLS
