/***************************************************************************
 *   Copyright © 2009-2010 Harald Sitter <apachelogger@ubuntu.com>         *
 *   Copyright © 2009-2010 Jonathan Thomas <echidnaman@kubuntu.org>        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License as        *
 *   published by the Free Software Foundation; either version 2 of        *
 *   the License or (at your option) version 3 or any later version        *
 *   accepted by the membership of KDE e.V. (or its successor approved     *
 *   by the membership of KDE e.V.), which shall act as a proxy            *
 *   defined in Section 14 of version 3 of the license.                    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "kubuntufirefoxinstaller.h"

#include <QtCore/QTextStream>
#include <QtCore/QFile>

#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>
#include <KDE/KLocale>
#include <KProcess>

static const char description[] =
    I18N_NOOP("Mozilla Firefox Installer");

static const char version[] = "0.5";

int main(int argc, char **argv)
{
    KAboutData about("kubuntu-firefox-installer", 0,
                     ki18n("Mozilla Firefox Installer"), version,
                     ki18n(description), KAboutData::License_GPL,
                     ki18n("(C) 2010 Harald Sitter"), KLocalizedString(), 0,
                     "https://bugs.launchpad.net/ubuntu/+source/kubuntu-firefox-installer/+filebug");

    about.addAuthor(ki18n("Harald Sitter"),
                    KLocalizedString(),
                    "apachelogger@ubuntu.com");
    about.addAuthor(ki18n("Jonathan Thomas"),
                    KLocalizedString(),
                    "echidnaman@kubuntu.org");

    KCmdLineArgs::init(argc, argv, &about);

    KCmdLineOptions options;
    options.add("i", ki18nc("This is the description of a command line argument",
                            "Directly install Mozilla Firefox"));
    KCmdLineArgs::addCmdLineOptions(options);

    KApplication app;

    if (KCmdLineArgs::parsedArgs()->isSet("i")) {
        KProcess::execute("/usr/bin/qapt-batch",
                          QStringList() << "--install" << "firefox" << "firefox-kde-support");
        return 0;
    }

    QFile styleSheet("/usr/share/kubuntu-firefox-installer/style/style.qss");
    if (styleSheet.open(QFile::ReadOnly)) {
        QTextStream stream(&styleSheet);
        QString styleSheetContents = stream.readAll();
        app.setStyleSheet(styleSheetContents);
    }

    KubuntuFirefoxInstaller *dialog = new KubuntuFirefoxInstaller;
    dialog->show();

    return app.exec();
}
