/***************************************************************************
 *
 * vpn_tray_componenet.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>

// Qt DBus
#include <dbus/qdbusobjectpath.h>


// KNM includes
#include "vpn_tray_component.h"
#include "knetworkmanager-menuitem.h"
#include "knetworkmanager-menu_subhead.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-nm_proxy.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_vpn.h"
#include "knetworkmanager-connection_settings_dialog.h"

using namespace ConnectionSettings;

void VPNTrayComponent::slotShowNewConnectionDialog()
{
	// create a new VPN connection
	Connection* conn = new VPNConnection();

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, NULL, tray(), "connect_something", false, Qt::WDestructiveClose);
	dlg->show();
}


void VPNTrayComponent::addMenuItems(KPopupMenu* menu)
{
	ConnectionStore* connectionStore = ConnectionStore::getInstance();
	

	// get all available VPN Connections
	QValueList<Connection*> connections = connectionStore->getConnections(NM_SETTING_VPN_SETTING_NAME);
	if (!connections.empty())
	{
		QPopupMenu* popup = new QPopupMenu(menu);
		for (QValueList<Connection*>::iterator it = connections.begin(); it != connections.end(); ++it)
		{
			VPNConnection* vpnconn = dynamic_cast<VPNConnection*>(*it);
			if (vpnconn)
			{
				// VPN connection found :)
				Info* info = vpnconn->getInfoSetting();

				// lets create a nice name for this connection
				if (info)
				{
					QString title = info->getName();
	
					NetworkMenuItem* item = new NetworkMenuItem(NULL, vpnconn, menu);

					int id = popup->insertItem(SmallIcon ("encrypted",  QIconSet::Automatic), title, item, SLOT(slotActivate()));
//				menu->setItemChecked(id, ((*it) == active_conn));
				}
			}
		}
		menu->insertItem(SmallIcon ("encrypted",  QIconSet::Automatic), i18n("Start VPN connection"), popup);
		menu->insertSeparator();
	}
}

VPNTrayComponent::VPNTrayComponent (KSystemTray * parent, const char * name )
	: TrayComponent (parent, name)
{
	//Actions used for plugging into the menu
	new KAction (i18n ("New connection ..."),
					     SmallIcon ("encrypted",  QIconSet::Automatic), 0,
					     this, SLOT (slotShowNewConnectionDialog()), parent->actionCollection (), "create_new_vpn_connection");
}

VPNTrayComponent::~VPNTrayComponent ()
{

}


#include "vpn_tray_component.moc"
