/***************************************************************************
 *
 * knetworkmanager-nminfo_dbus.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_NMSETTINGS_H
#define KNETWORKMANAGER_NMSETTINGS_H

#include <qobject.h>

#include "knetworkmanager-connection_setting.h"
#include "dbus/networkmanagersettings.h"

class Network;
class QDBusObjectPath;
class NMSettingsPrivate;

class NMSettings : public QObject, DBus::SettingsInterface
{
	Q_OBJECT
	public:
		/* get singleton */
		static NMSettings* getInstance();

		~NMSettings();
		/* request the required interface from the DBus */
//		void         requestName          (DBusMessage*);

		/* functions for handling method calls sended _by_ NetworkManager */
//		void         getConnections       (DBusMessage*);
    bool handleSignalSend(const QDBusMessage& reply);
    QString objectPath() const;
    bool ListConnections(QValueList<QDBusObjectPath>& connections, QDBusError& error);
    void handleMethodReply(const QDBusMessage& reply);

		/* get Connection from obj_path */
		QDBusObjectPath getObjPathForConnection();

	public slots:	
		/* notification about new connections */
		void         slotNewConnection    (ConnectionSettings::Connection*);

	private:
		NMSettingsPrivate* d;

		/* private constructor -> singleton */
		NMSettings();

		/* functions for sending signals/methodcalls _to_ NetworkManager */
		void         signalNewConnection  (const char*);

		/* pointer to the singleton class */
		static NMSettings* _instance;

};

#endif /* KNETWORKMANAGER_NMSETTINGS_H */
