/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa        <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <qwidget.h>
#include <qcombobox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qwidgetstack.h>
#include <qapplication.h>
#include <qlabel.h>

// kde headers
#include <kiconloader.h>
#include <kdebug.h>
#include <kpushbutton.h>

// Qt DBus headers
#include <dbus/qdbuserror.h>
#include <dbus/qdbusobjectpath.h>

// NM headers
#include <NetworkManager.h>

// knm headers
#include "knetworkmanager-connection_setting_widget_interface.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_setting_cdma.h"
#include "knetworkmanager-connection_setting_gsm.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-wired_connection.h"
#include "knetworkmanager-wireless_connection.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-connection_settings_dialog.h"
#include "knetworkmanager-connection_setting_cdma_widget.h"
#include "knetworkmanager-connection_setting_gsm_widget.h"
#include "knetworkmanager-connection_setting_ppp_widget.h"
#include "knetworkmanager-connection_setting_serial_widget.h"
#include "knetworkmanager-connection_setting_wireless_widget.h"
#include "knetworkmanager-connection_setting_wireless_security_widget.h"
#include "knetworkmanager-connection_setting_ipv4_widget.h"
#include "knetworkmanager-connection_setting_info_widget.h"
#include "knetworkmanager-connection_setting_vpn_widget.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-storage.h"

ConnectionSettingsDialogImpl::ConnectionSettingsDialogImpl(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting, QWidget* parent, const char* name, bool modal, WFlags fl)
	: ConnectionSettingsDialog(parent, name, modal, fl)
	, _conn(conn)
	, _setting(setting)
	, _new_conn(new_conn)
{
	updateDialogForDeviceType();
	
	// get notified if device combo changes
	connect(btnConnect, SIGNAL(clicked()), this, SLOT( slotConnect()) );
	connect(pbNext, SIGNAL(clicked()), this, SLOT( slotNext()) );
	connect(pbBack, SIGNAL(clicked()), this, SLOT( slotBack()) );
	connect(pbCancel, SIGNAL(clicked()), this, SLOT(close()) );
	connect(pbSave, SIGNAL(clicked()), this, SLOT(slotSave()) );

	// nice images for the buttons
	btnConnect->setIconSet(SmallIcon ("connect_creating", QIconSet::Automatic));
	pbNext->setIconSet(SmallIcon ("1rightarrow", QIconSet::Automatic));
	pbBack->setIconSet(SmallIcon ("1leftarrow", QIconSet::Automatic));
	pbCancel->setIconSet(SmallIcon("cancel", QIconSet::Automatic));
	pbSave->setIconSet(SmallIcon("ok", QIconSet::Automatic));

	// enable or disable buttons accroding to the current state
	slotEnableButtons();
}

ConnectionSettingsDialogImpl::~ConnectionSettingsDialogImpl()
{
	printf("ConnectionSettingsDialogImpl::~ConnectionSettingsDialogImpl\n");
}

/*
void
ConnectionSettingsDialogImpl::comboDeviceFill (Device* dev, ConnectionSettings::Connection* conn)
{
	DeviceStore* store = DeviceStore::getInstance();
	QValueList<Device*> deviceList = store->getDevices();
	Device* devit;
	QValueList<Device*>::iterator i;
	int id = 0;

	for (i = deviceList.begin (); i != deviceList.end (); ++i) {
		devit = *i;
		if ( dev && dev != devit)
			continue;

		QString item;
		QPixmap pixmap = devit->getDeviceType() == DEVICE_TYPE_802_11_WIRELESS  ? SmallIcon("wireless") : SmallIcon ("wired");
		item = QString("%1 %2 (%3)").arg( devit->getVendor () )
					.arg( devit->getProduct () )
					.arg( devit->getInterface () );

		// map the current device to the combobox entry
		_deviceMap     [id] = devit;
		// if we should work on an existing connection map it to its combobox entry
		_connectionMap [id] = (conn && dev) ? conn : NULL;

		cboDevice->insertItem (pixmap, item, id++);
	}

	// preselect the first one
	if (cboDevice->count() > 0)
	{
		slotComboDeviceActivated(0);
	}
}
*/

QValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForWireless(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	QValueList<WidgetInterface*> ret;

	// widgetlist for wireless connection
	ret.append(new ConnectionSettings::WirelessWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::WirelessSecurityWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	if (ret.isEmpty())
	{
		// we have a problem here, NetworkManager asked for a setting we do not have
		kdError() << k_funcinfo << "Unexpected setting requested" << endl;
	}

	return ret;
}

QValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForWired(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	QValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

QValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForVPN(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	QValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::VPNWidgetImpl(conn, new_conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

QValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForCDMA(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	QValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::CDMAWidgetImpl(conn));
	ret.append(new ConnectionSettings::SerialWidgetImpl(conn));
	ret.append(new ConnectionSettings::PPPWidgetImpl(conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

QValueList<WidgetInterface*>
ConnectionSettingsDialogImpl::createWidgetsForGSM(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	QValueList<WidgetInterface*> ret;

	// widgetlist for wired connection
	ret.append(new ConnectionSettings::GSMWidgetImpl(conn));
	ret.append(new ConnectionSettings::PPPWidgetImpl(conn));
	ret.append(new ConnectionSettings::SerialWidgetImpl(conn));
	ret.append(new ConnectionSettings::IPv4WidgetImpl(conn));
	ret.append(new ConnectionSettings::InfoWidgetImpl(conn));

	return ret;
}

void
ConnectionSettingsDialogImpl::createWidgetsForConnection(ConnectionSettings::Connection* conn, bool new_conn, ConnectionSettings::ConnectionSetting* setting)
{
	/*
	  Currently two modes:
	    * dev == NULL -> Connection should be edited without the wish to start a connection
	    * dev != NULL -> A connection should be edited for connection on this device
	*/
	// TODO: Third mode: Secret request

	if (!conn)
	{
		// TODO: create an empty widget and show an error
		kdWarning() << k_funcinfo << "Not handled yet" << endl;
	}
	else
	{
		QValueList<WidgetInterface*> widgets;
		// TODO: move to a factory class
		if (conn->getType() == NM_SETTING_WIRELESS_SETTING_NAME)
			widgets = createWidgetsForWireless(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_WIRED_SETTING_NAME)
			widgets = createWidgetsForWired(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_CDMA_SETTING_NAME)
			widgets = createWidgetsForCDMA(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_GSM_SETTING_NAME)
			widgets = createWidgetsForGSM(conn, new_conn, setting);
		else if (conn->getType() == NM_SETTING_VPN_SETTING_NAME)
			widgets = createWidgetsForVPN(conn, new_conn, setting);
		else
		{
			kdWarning() << k_funcinfo << "Not handled yet" << endl;
		}

		int id;
		for (QValueList<WidgetInterface*>::Iterator it = widgets.begin(); it != widgets.end(); ++it)
		{
			id = wstackSettings->addWidget(*it);
			_widgetIds.append(id);
		}

		if (widgets.begin() != widgets.end())
			activateWidget(*widgets.begin());
	}
}

void
ConnectionSettingsDialogImpl::updateDialogForDeviceType()
{
	// clear our tabview first
	QWidget *page = NULL;
	while ( (page = wstackSettings->visibleWidget()) != NULL)
	{
		wstackSettings->removeWidget(page);
		delete page;
	}

	if (_conn)
	{
		connect(_conn, SIGNAL(validityChanged()), this, SLOT(slotEnableButtons()));
		createWidgetsForConnection(_conn, _new_conn, _setting);
	}
	else
	{
		// this should never happen
		QLabel* lbl = new QLabel(wstackSettings, "Unknown Device Type");
		wstackSettings->addWidget(lbl);

		wstackSettings->raiseWidget(lbl);
	}
}

int
ConnectionSettingsDialogImpl::getDeviceTypeFromConnection(Connection* conn)
{
	if (conn->getType() == NM_SETTING_WIRELESS_SETTING_NAME)
		return DEVICE_TYPE_802_11_WIRELESS;
	else if (conn->getType() == NM_SETTING_WIRED_SETTING_NAME)
		return DEVICE_TYPE_802_3_ETHERNET;
	else if (conn->getType() == NM_SETTING_GSM_SETTING_NAME)
		return DEVICE_TYPE_GSM;
	else if (conn->getType() == NM_SETTING_CDMA_SETTING_NAME)
		return DEVICE_TYPE_CDMA;
	return DEVICE_TYPE_UNKNOWN;
}

void
ConnectionSettingsDialogImpl::slotConnect()
{
	DeviceStore*     dstore   = DeviceStore::getInstance();
	Device*          dev      = dstore->getDevices(getDeviceTypeFromConnection(_conn)).first();
	ConnectionStore* cstore   = ConnectionStore::getInstance();
	NMProxy*         nm       = NMProxy::getInstance();
	QDBusError       err;

	// add the connection to the store
	cstore->addConnection(_conn);

	// activate device
	if (dev && _conn && nm)
	{
		int id;
		// VPN connection needs a special specific object
		if (_conn->getType() == NM_SETTING_VPN_SETTING_NAME)
		{
			QDBusObjectPath act_conn = nm->getDefaultActiveConnection();
			QDBusObjectPath device   = nm->getDeviceForActiveConnection(act_conn);
			nm->ActivateConnectionAsync(id,NM_DBUS_SERVICE_USER_SETTINGS, _conn->getObjectPath(), device, act_conn, err);
		}
		else
		{
			// we need to call ActivateDevice async
			if (nm->ActivateConnectionAsync(id, NM_DBUS_SERVICE_USER_SETTINGS, _conn->getObjectPath(), QDBusObjectPath(QCString(dev->getObjectPath())), _conn->getObjectPath(), err))
			{
	
			}
			else
			{
				printf("ActivateConnection failed\n");
			}
		}
	}

	emit connectionSaved();
	this->close(true);
}

void
ConnectionSettingsDialogImpl::slotSave()
{
	ConnectionStore* cstore   = ConnectionStore::getInstance();
	NMProxy*         nm       = NMProxy::getInstance();
	QDBusError       err;

	// add the connection to the store
	cstore->addConnection(_conn);

	emit connectionSaved();
	this->close(true);
}

void
ConnectionSettingsDialogImpl::slotNext()
{
	QValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	if (current != _widgetIds.fromLast())
	{
		WidgetInterface* widget = NULL;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			deactivateWidget(widget);

		// next widget
		current++;
	
		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			activateWidget(widget);
	}
	slotEnableButtons();
}

void
ConnectionSettingsDialogImpl::slotBack()
{
	QValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	if (current != _widgetIds.begin())
	{
		WidgetInterface* widget = NULL;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			deactivateWidget(widget);

		// one back
		current--;

		// let the widget know about it being the active one
		widget = dynamic_cast<WidgetInterface*>(wstackSettings->widget(*current));
		if (widget)
			activateWidget(widget);
	}
	slotEnableButtons();
}

void
ConnectionSettingsDialogImpl::activateWidget(WidgetInterface* widget)
{
	// allow the widget to press next
	connect(widget, SIGNAL(next()), this, SLOT(slotNext()));

	// allow the widget to do some initialization
	widget->Activate();

	// show the widget
	wstackSettings->raiseWidget(widget);

}

void
ConnectionSettingsDialogImpl::deactivateWidget(WidgetInterface* widget)
{
	// allow the widget to press next
	disconnect(widget, SIGNAL(next()), this, SLOT(slotNext()));

	// allow the widget to do some initialization
	widget->Deactivate();
}

void
ConnectionSettingsDialogImpl::slotEnableButtons()
{
	// enable the buttons according to the current state
	
	QValueList<int>::Iterator current = _widgetIds.find(wstackSettings->id(wstackSettings->visibleWidget()));
	bool enabled;

	/*
	  Next: enabled if another widget is available
	*/
	enabled = true;
	if (current == _widgetIds.fromLast())
		enabled = false;
	pbNext->setEnabled(enabled);

	/*
		Back: enabled if the current widget has a predecessor
	*/
	enabled = true;
	if (current == _widgetIds.begin())
		enabled = false;
	pbBack->setEnabled(enabled);

	/*
		Connect: only show connect if the connection is valid
	*/
	if (_conn)
	{
		btnConnect->setEnabled(_conn->isValid());
		pbSave->setEnabled(_conn->isValid());

	}
}

#include "knetworkmanager-connection_settings_dialog.moc"
