/***************************************************************************
 *
 * knetworkmanager-connection_setting_serial_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <limits.h>
// qt headers
#include <qwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qiconset.h>
#include <kiconloader.h>
#include <qwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_serial.h"
#include "knetworkmanager-connection_setting_serial_widget.h"
#include "knetworkmanager-device.h"

#include "connection_setting_serial.h"

using namespace ConnectionSettings;

SerialWidgetImpl::SerialWidgetImpl(Connection* conn, QWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_serialsetting = dynamic_cast<ConnectionSettings::Serial*> (conn->getSetting(NM_SETTING_SERIAL_SETTING_NAME));

	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingSerialWidget(this);
	layout->addWidget(_mainWid);
    _mainWid->mBaudRate->setMaxValue(INT_MAX);
	Init();
}

void
SerialWidgetImpl::Init()
{
    _mainWid->mBaudRate->setValue(_serialsetting->getBaud());
    _mainWid->mDataBits->setCurrentItem(_serialsetting->getBits() - 7);
    _mainWid->mParity->setCurrentItem(_serialsetting->getParity());
    _mainWid->mStopBits->setCurrentItem(_serialsetting->getStopBits());
    _mainWid->mSendDelay->setValue(_serialsetting->getSendDelay());

    connect( _mainWid->mBaudRate, SIGNAL(valueChanged(int)), SLOT(dirty()));
    connect( _mainWid->mDataBits, SIGNAL(activated(int)), SLOT(dirty()));
    connect( _mainWid->mParity, SIGNAL(activated(int)), SLOT(dirty()));
    connect( _mainWid->mStopBits, SIGNAL(activated(int)), SLOT(dirty()));
    connect( _mainWid->mSendDelay, SIGNAL(valueChanged(int)), SLOT(dirty()));
}

void
SerialWidgetImpl::Deactivate()
{
}

void
SerialWidgetImpl::Activate()
{

}

void
SerialWidgetImpl::dirty()
{
    _serialsetting->setBaud( _mainWid->mBaudRate->value() );
    _serialsetting->setBits( _mainWid->mDataBits->currentItem() + 7 );
    _serialsetting->setParity( (ConnectionSettings::Serial::PARITY_MODE)_mainWid->mParity->currentItem() );
    _serialsetting->setStopBits( _mainWid->mStopBits->currentItem() );
    _serialsetting->setSendDelay( _mainWid->mSendDelay->value() );
}

#include "knetworkmanager-connection_setting_serial_widget.moc"
