/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_CONNECTION_SECRETS_DBUS_H
#define KNETWORKMANAGER_CONNECTION_SECRETS_DBUS_H

#include <hal/libhal.h>
#include <stdint.h>
#include <qhostaddress.h>
#include <qmap.h>
#include <qvariant.h>
#include <qobject.h>

#include "knetworkmanager-connection_setting.h"
#include "dbus/connection.h"
#include "dbus/connectionnode.h"

class AccessPoint;
class QDBusObjectPath;
namespace ConnectionSettings
{

	class WirelessSecurity;
	class Connection;
	class ConnectionSetting;
	class ConnectionSecretsDBusPrivate;

	// a connection wraps multiple settings
	class ConnectionSecretsDBus : public QObject, public DBus::Secrets
	{
		Q_OBJECT
		public:
			ConnectionSecretsDBus(ConnectionSettings::Connection* parent);
			virtual ~ConnectionSecretsDBus();

			void SendGetSecretsReply(ConnectionSettings::ConnectionSetting* setting);
			void SendGetSecretsError();

		protected:
			// implementation of the Secrets DBus-interface
			void GetSecretsAsync(int, const QString&, const QStringList&, bool);
			void handleMethodReply(const QDBusMessage& reply);
			bool handleSignalSend(const QDBusMessage& reply);
			QString objectPath() const;

		signals:
			void SecretsNeeded(const QString& setting_name, const QStringList& hints, bool request_new);

		private:
			ConnectionSecretsDBusPrivate* d;
	};

}
#endif /* KNETWORKMANAGER_CONNECTION_SECRETS_DBUS_H */
