/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>
#include <qvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatalist.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>
#include <dbus/qdbuserror.h>
#include <dbus/qdbusmessage.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_secrets_dbus.h"
#include "knetworkmanager-connection_dbus.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_wired.h"
#include "knetworkmanager-connection_setting_wireless.h"
#include "knetworkmanager-connection_setting_wireless_security.h"
#include "knetworkmanager-accesspoint.h"
#include "knetworkmanager-nmsettings.h"
#include "xmlmarshaller.h"

using namespace ConnectionSettings;

namespace ConnectionSettings
{

class ConnectionSecretsDBusPrivate
{
	public:
		ConnectionSecretsDBusPrivate(Connection* par)
			: parent(par)
      , currentRequest(-1)
    {}
		~ConnectionSecretsDBusPrivate() {}

		Connection* parent;
		int         currentRequest;
};

}

/*
	class Connection
*/
ConnectionSecretsDBus::ConnectionSecretsDBus(Connection* parent)
	: QObject(parent)
{
	d = new ConnectionSecretsDBusPrivate(parent);
}

ConnectionSecretsDBus::~ConnectionSecretsDBus()
{
	delete d;
}

void
ConnectionSecretsDBus::SendGetSecretsError()
{
	GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is empty"));
}

void
ConnectionSecretsDBus::SendGetSecretsReply(ConnectionSettings::ConnectionSetting* setting)
{
	QDBusMessage reply;

	printf("SendGetSecretsReply1 id %i\n", d->currentRequest);

	// if no secret is needed we should not send one, right?
	if (d->currentRequest < 0)
		return;
	printf("SendGetSecretsReply2\n");
/*
	// no such setting
	if (!setting)
	{
		GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is unknown"));
	}
	else
	{
	printf("SendGetSecretsReply3\n");
		// copy the settingsmap over to a variantmap
		QMap<QString, QDBusData> map = setting->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
	printf("SendGetSecretsReply4\n");
			GetSecretsAsyncError(d->currentRequest, QDBusError::stdFailed("Requested setting is empty"));
		}
		else
		{
	printf("SendGetSecretsReply5\n");
			QDBusDataMap<QString> secrets(map);
			
			QMap<QString, QDBusVariant> secrets;
			for (QMap<QString, QDBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
			{
				QDBusVariant var;
				var.value = it2.data();
				var.signature = var.value.buildDBusSignature();
				secrets.insert(it2.key(), var);
			}
	printf("SendGetSecretsReply6\n");

			GetSecretsAsyncReply(d->currentRequest, secrets);
		}
	}*/

	QDBusDataMap<QString> settings;
	QValueList<ConnectionSetting*> all_settings = d->parent->getSettings();

	// FIXME: ugly conversions, ask Kevin on how to make it better
	for (QValueList<ConnectionSetting*>::Iterator it = all_settings.begin(); it != all_settings.end(); ++it)
	{
		printf("  Processing Setting '%s'\n", (*it)->getType().ascii());
		if (!(*it)->isValid())
		{
			printf("  Setting '%s' is not valid, discarding\n", (*it)->getType().ascii());
			continue;
		}

		// copy the settingsmap over to a variantmap
		QMap<QString, QDBusData> map = (*it)->toSecretsMap();

		// only take used settings
		if (map.size() == 0)
		{
			printf("  Setting '%s' is empty, discarding\n", (*it)->getType().ascii());
			continue;
		}

		printf("  Attach setting '%s'\n", (*it)->getType().ascii());

		QMap<QString, QDBusVariant> variant_map;

		for (QMap<QString, QDBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
		{
			QString dataxml = XMLMarshaller::fromQDBusData(it2.data());
			printf("    %s: %s\n", it2.key().ascii(), dataxml.replace('\n', ' ').ascii());
			QDBusVariant var;
			var.value = it2.data();
			var.signature = var.value.buildDBusSignature();
			variant_map.insert(it2.key(), var);
		}

		// convert the variantma
		QDBusDataMap<QString> map2 = QDBusDataMap<QString>(variant_map);
		QDBusData data = QDBusData::fromStringKeyMap(map2);

		// insert this setting
		settings.insert((*it)->getType(), data);
	}
	
	GetSecretsAsyncReply(d->currentRequest, settings);
	d->currentRequest = -1;

}
	
void
ConnectionSecretsDBus::GetSecretsAsync(int id, const QString& setting_name, const QStringList& hints, bool request_new)
{
	printf("Connection::GetSecretsAsync for setting %s, id %i\n", setting_name.ascii(), id);
	d->currentRequest = id;
	emit SecretsNeeded(setting_name, hints, request_new);
}

void
ConnectionSecretsDBus::handleMethodReply(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
}

bool
ConnectionSecretsDBus::handleSignalSend(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
	return true;
}

QString
ConnectionSecretsDBus::objectPath() const
{
	return QString(d->parent->getObjectPath());
}


#include "knetworkmanager-connection_secrets_dbus.moc"
