/***************************************************************************
 *
 * knetworkmanager-devicestore_dbus.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>
#include <dbus/qdbuserror.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_dbus.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-nmsettings.h"
#include "xmlmarshaller.h"

using namespace ConnectionSettings;

namespace ConnectionSettings
{

class ConnectionDBusPrivate
{
	public:
		ConnectionDBusPrivate() {}
		~ConnectionDBusPrivate() {}

		ConnectionSettings::Connection* parent;
};
}

/*
	class Connection
*/
ConnectionDBus::ConnectionDBus(ConnectionSettings::Connection* parent)
	: QObject(parent)
{
	d = new ConnectionDBusPrivate();
	d->parent = parent;
}

ConnectionDBus::~ConnectionDBus()
{
	delete d;
}

bool
ConnectionDBus::GetID(QString& id, QDBusError& /*error*/)
{
	printf("Connection::GetID\n");
	id = d->parent->getID();

	return true;
}

bool
ConnectionDBus::GetSettings(QDBusDataMap<QString>& settings, QDBusError& /*error*/)
{
	printf("Connection::GetSettings, obj: %s\n", objectPath().ascii());

	QValueList<ConnectionSetting*> all_settings = d->parent->getSettings();

	// FIXME: ugly conversions, ask Kevin on how to make it better
	for (QValueList<ConnectionSetting*>::Iterator it = all_settings.begin(); it != all_settings.end(); ++it)
	{
		printf("  Processing Setting '%s'\n", (*it)->getType().ascii());
		// only append this setting if it is really used
		if (!(*it)->getEnabled())
		{
			printf("  Setting '%s' is not enabled, discarding\n", (*it)->getType().ascii());
			continue;
		}

		if (!(*it)->isValid())
		{
			printf("  Setting '%s' is not valid, discarding\n", (*it)->getType().ascii());
			continue;
		}

		// copy the settingsmap over to a variantmap
		QMap<QString, QDBusData> map = (*it)->toMap();

		// only take used settings
		if (map.size() == 0)
		{
			printf("  Setting '%s' is empty, discarding\n", (*it)->getType().ascii());
			continue;
		}

		printf("  Attach setting '%s'\n", (*it)->getType().ascii());

		QMap<QString, QDBusVariant> variant_map;

		for (QMap<QString, QDBusData>::Iterator it2 = map.begin(); it2 != map.end(); ++it2)
		{
			QString dataxml = XMLMarshaller::fromQDBusData(it2.data());
			printf("    %s: %s\n", it2.key().ascii(), dataxml.replace('\n', ' ').ascii());
			QDBusVariant var;
			var.value = it2.data();
			var.signature = var.value.buildDBusSignature();
			variant_map.insert(it2.key(), var);
		}

		// convert the variantma
		QDBusDataMap<QString> map2 = QDBusDataMap<QString>(variant_map);
		QDBusData data = QDBusData::fromStringKeyMap(map2);

		// insert this setting
		settings.insert((*it)->getType(), data);
	}
	
	return true;
}

bool
ConnectionDBus::Update(const QDBusDataMap<QString>& properties, QDBusError& error)
{
	// FIXME
	return true;
}

bool
ConnectionDBus::Delete(QDBusError& error)
{
	// FIXME
	return true;
}


void
ConnectionDBus::handleMethodReply(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
}

bool
ConnectionDBus::handleSignalSend(const QDBusMessage& reply)
{
	QDBusConnection::systemBus().send(reply);
	return true;
}


QString
ConnectionDBus::objectPath() const
{
	return QString(d->parent->getObjectPath());
}

void
ConnectionDBus::slotAboutToBeRemoved()
{
	// tell NM about us being removed
	emitRemoved();
}

void
ConnectionDBus::slotUpdated()
{
	QDBusDataMap<QString> settings;
	QDBusError error;
	if (GetSettings(settings, error))
		emitUpdated(settings);
}

#include "knetworkmanager-connection_dbus.moc"
