/***************************************************************************
 *
 * knetworkmanager-device.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_ACCESSPOINT_H
#define KNETWORKMANAGER_ACCESSPOINT_H

#include "knetworkmanager.h"
#include <dbus/qdbusvariant.h>

class AccessPointPrivate;
namespace DBus
{
	class AccessPointProxy;
};

class AccessPoint : public QObject
{
	Q_OBJECT
	public:
		AccessPoint (const AccessPoint&);
	  AccessPoint (QString objpath = QString::null, QObject * parent = 0, const char * name = 0);
	  ~AccessPoint ();

		AccessPoint& operator= (const AccessPoint& other);
		bool operator== (const AccessPoint& other) const;

    Q_UINT32   getFlags() const;
    Q_UINT32   getWpaFlags() const;
    Q_UINT32   getRsnFlags() const;
    QValueList<Q_UINT8> getSsid() const;
    Q_UINT32   getFrequency() const;
    QString    getHwAddress() const;
    Q_INT32    getMode() const;
    Q_UINT32   getRate() const;
    Q_UINT8    getStrength() const;
		QString    getDisplaySsid() const;
		const QByteArray getSsidByteArray() const;
		bool       isEncrypted() const;
		QString    getObjectPath() const;
		bool       isValid() const;
	signals:
		void strengthChanged(Q_UINT8);
	private slots:
		void slotPropertiesChanged(const QMap<QString, QDBusVariant>& properties);
		void updateProperties();

	private:

	  AccessPointPrivate * d;
};

#endif /* KNETWORKMANAGER_DEVICE_H */
