/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <kmessagebox.h>
#include <klineedit.h>

#include "kaddressvalidator.h"
#include "kadddevicedlgextension.h"
//#include "kadddevicewifiext.h"

bool _modified;
bool _advanced;

void KAddDeviceDlg::init()
{
  _modified = false;   
  _advanced = false;
  setExtension( new KAddDeviceDlgExtension( this ) );
  setOrientation( Vertical );

  KAddDeviceDlgLayout->setResizeMode(QLayout::Auto);
  connect((KAddDeviceDlgExtension*)extension(),SIGNAL(valueChangedSignal(int)),this,SLOT(toggleApplyButtonSlot(int)));
}
void KAddDeviceDlg::toggleApplyButtonSlot( const QString & )
{
  toggleApplyButtonSlot(0);
}

void KAddDeviceDlg::toggleApplyButtonSlot( int )
{
  _modified = true;
  kpbApply->setEnabled(true);
}

void KAddDeviceDlg::toggleWifiSettingsSlot(bool enabled )
{  
/*  if (enabled)
  {
    setExtension( new KAddDeviceWifiExt( this ) );
    setOrientation( Vertical );
    KAddDeviceWifiExt *wifiSettings = (KAddDeviceWifiExt *)this->extension();
    showExtension(enabled);
  }
  setExtension( new KAddDeviceDlgExtension( this ) );
  setOrientation( Vertical );
  connect((KAddDeviceDlgExtension*)extension(),SIGNAL(valueChangedSignal(int)),this,SLOT(toggleApplyButtonSlot(int)));  
  */
}

void KAddDeviceDlg::toggleAdvancedOptionsSlot(bool enabled )
{
   //setExtension( new KAddDeviceDlgExtension( this ) );
   //setOrientation( Vertical );
  
   KAddDeviceDlgExtension *advancedOptions = (KAddDeviceDlgExtension *)this->extension();

  if (enabled)
  {
    advancedOptions->gbAdvancedDeviceInfo->setEnabled(false);
  }
  else
  {
    advancedOptions->gbAdvancedDeviceInfo->setEnabled(true);
  }
  _modified = true;
  kpbApply->setEnabled(true);
}

void KAddDeviceDlg::verifyDeviceInfoSlot()
{
    if (rbBootProtoManual->isChecked())
    {	
      if (!_advanced)
      {
        if (kcbstartAtBoot->isChecked()) 
        {
          if (KAddressValidator::isValidIPAddress(kleIPAddress->text()))
          {
            _modified = true;
      	    close();
          }
          else
          {
            KMessageBox::error(this,i18n("The format of the specified IP address is not valid."),i18n("Invalid IP address "));
          }
        }
        else
        {
          if (kleIPAddress->text().length() > 0 &&
               KAddressValidator::isValidIPAddress(kleIPAddress->text()))
          {
            _modified = true;
      	    close();
          }
          else if (kleIPAddress->text().length() > 0)
          {
            KMessageBox::error(this,i18n("The format of the specified IP address is not valid."),i18n("Invalid IP address "));
          }
          else 
          {
            _modified = true;
          	close();
          }
        }
      }  
      if (_advanced)
      {
         KAddDeviceDlgExtension *advancedOptions = (KAddDeviceDlgExtension *)this->extension();

        if (kcbNetmask->currentText().length() == 0 && advancedOptions->kleBroadcast->text().length() == 0)
        {
          _modified = true;
          close();
        }
    
        else if (!(KAddressValidator::isNetmaskValid(kcbNetmask->currentText())))
          KMessageBox::error(this,i18n("The format of the specified Netmask is not valid."),i18n("Invalid IP address "));
        
        else if ((!KAddressValidator::isBroadcastValid(advancedOptions->kleBroadcast->text())))
          KMessageBox::error(this,i18n("The format of the specified Broadcast is not valid."),i18n("Invalid IP address"));
        
        else
        {
          _modified = true;
          close();
        }
      }
    }	
    else if (rbBootProtoAuto->isChecked())
    {
      _modified = true;
      close();
    }    
}


void KAddDeviceDlg::makeButtonsResizeable()
{
  kcbAutoBootProto->setAutoResize(true);
  kcbNetmask->setAutoResize(true);

}



bool KAddDeviceDlg::modified()
{
  return _modified;
}
bool KAddDeviceDlg::advanced()
{
  return _advanced;
}


void KAddDeviceDlg::advancedOptionsSlot()
{
    if (!_advanced)
    {
      kpbAdvanced->setText(i18n("Basic Settings..."));
      kcbNetmask->setEditable(true);	
    }
    else
    {
      kpbAdvanced->setText(i18n("Advanced Settings..."));
      kcbNetmask->setEditable(false);      
    }
      _advanced = !_advanced;
     showExtension(_advanced );  
}


void KAddDeviceDlg::cancelSlot()
{
 _modified = false;
 close();
}
