 /***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "quickeditor.h"

//KGRUBEditor
#include "core/path.h"

QuickEditor::QuickEditor( GRUB::ConfigFile::Entry *entry, QWidget *parent ) : KDialog( parent )
{
//SETUP UI
	QWidget *widget = new QWidget( this );
	setupUi( widget );
	setMainWidget( widget );

	setWindowIcon( KIcon( "document-properties" ) );
	setCaption( i18nc( "@title:window", "Quick Editor" ) );
	setAttribute( Qt::WA_DeleteOnClose );
//PROPERTY SETUP
	m_entry = entry;
//SHOW ENTRY
	klineedit_title->setText( entry->title() );
	grubdeviceeditor_root->lineEdit()->setText( entry->root() );
	gruburlrequester_initrd->setPath( entry->initrd() );
	checkBox_lock->setChecked( entry->lock() );
	checkBox_makeactive->setChecked( entry->makeActive() );
	checkBox_savedefault->setChecked( entry->saveDefault() );
	klineedit_chainloader->setText( entry->chainLoader() );
//MISC UI SETUP
	grubdeviceeditor_root->setMode( GRUBDeviceEditor::Partition );
	gruburlrequester_initrd->setAssociatedRootEditor( grubdeviceeditor_root->lineEdit() );
//SETUP CONNECTIONS
	setupConnections();
}
QuickEditor::~QuickEditor()
{
	m_entry = 0;
}

void QuickEditor::setupConnections()
{
	connect( klineedit_title, SIGNAL( textChanged( const QString & ) ), SLOT( checkTitle( const QString & ) ) );
	connect( this, SIGNAL( okClicked() ), SLOT( okClicked() ) );
}

void QuickEditor::checkTitle( const QString &text )
{
	enableButtonOk( !QString( text ).trimmed().isEmpty() );
}
void QuickEditor::okClicked()
{
	m_entry->setTitle( klineedit_title->text() );
	m_entry->setRoot( grubdeviceeditor_root->lineEdit()->text() );
	m_entry->setInitrd( gruburlrequester_initrd->url().path() );
	m_entry->setChainLoader( klineedit_chainloader->text() );
	m_entry->setLock( checkBox_lock->isChecked() );
	m_entry->setMakeActive( checkBox_makeactive->isChecked() );
	m_entry->setSaveDefault( checkBox_savedefault->isChecked() );
}

#include "quickeditor.moc"
