/* 
 *
 * Copyright (C) 2006 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef _K3B_VIDEODVD_RIPPING_TITLE_LISTVIEW_H_
#define _K3B_VIDEODVD_RIPPING_TITLE_LISTVIEW_H_

#include "k3blistview.h"
#include "k3bvideodvd.h"
#include "k3bmedium.h"

#include <QHideEvent>
#include <QtCore/QVector>

namespace K3b {
    class VideoDVDRippingPreview;
}
class QHideEvent;

namespace K3b {
class VideoDVDRippingTitleListView : public ListView
{
  Q_OBJECT

 public:
  VideoDVDRippingTitleListView( QWidget* parent );
  ~VideoDVDRippingTitleListView();

  void setVideoDVD( const VideoDVD::VideoDVD& dvd );

 private Q_SLOTS:
  void slotPreviewDone( bool );

 private:
  void hideEvent( QHideEvent* );

  class TitleViewItem;
  class TitleToolTip;

  TitleToolTip* m_toolTip;

  QVector<TitleViewItem*> m_itemMap;
  VideoDVDRippingPreview* m_previewGen;
  unsigned int m_currentPreviewTitle;

  VideoDVD::VideoDVD m_dvd;
  Medium m_medium;
};
}

#endif
