/*
 * Decompiled with CFR 0.152.
 */
package COM.sun.labs.jjtree;

import COM.sun.labs.jjtree.IO;
import COM.sun.labs.jjtree.JJTreeParser;
import COM.sun.labs.jjtree.JJTreeParserTreeConstants;
import COM.sun.labs.jjtree.Node;
import COM.sun.labs.jjtree.NodeScope;
import COM.sun.labs.jjtree.Token;

public class SimpleNode
implements Node {
    private Node parent;
    private Node[] children;
    private int id;
    private int myOrdinal;
    private Token first;
    private Token last;
    private boolean whitingOut = false;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JJTreeParser jJTreeParser, int n) {
        this(n);
    }

    protected String addUnicodeEscapes(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ((c < ' ' || c > '~') && c != '\t' && c != '\n' && c != '\r' && c != '\f') {
                String string3 = "0000" + Integer.toString(c, 16);
                string2 = String.valueOf(string2) + "\\u" + string3.substring(string3.length() - 4, string3.length());
            } else {
                string2 = String.valueOf(string2) + c;
            }
            ++n;
        }
        return string2;
    }

    static void closeJJTreeComment(IO iO) {
        iO.print("/*@egen*/");
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(String.valueOf(string) + " ");
                }
                ++n;
            }
        }
    }

    public Token getFirstToken() {
        return this.first;
    }

    String getIndentation(SimpleNode simpleNode) {
        return this.getIndentation(simpleNode, 0);
    }

    String getIndentation(SimpleNode simpleNode, int n) {
        String string = "";
        int n2 = n + 1;
        while (n2 < simpleNode.getFirstToken().beginColumn) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    public Token getLastToken() {
        return this.last;
    }

    public int getOrdinal() {
        return this.myOrdinal;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
        ((SimpleNode)node).setOrdinal(n);
    }

    public void jjtClose() {
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtOpen() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    static void openJJTreeComment(IO iO, String string) {
        if (string != null) {
            iO.print("/*@bgen(jjtree) " + string + " */");
        } else {
            iO.print("/*@bgen(jjtree)*/");
        }
    }

    public void print(IO iO) {
        if (this.getLastToken().next == this.getFirstToken()) {
            return;
        }
        Token token = this.getFirstToken();
        Token token2 = new Token();
        token2.next = token;
        int n = 0;
        while (n < this.jjtGetNumChildren()) {
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(n);
            while ((token2 = token2.next) != simpleNode.getFirstToken()) {
                this.print(token2, iO);
            }
            simpleNode.print(iO);
            token2 = simpleNode.getLastToken();
            ++n;
        }
        while (token2 != this.getLastToken()) {
            token2 = token2.next;
            this.print(token2, iO);
        }
    }

    protected void print(Token token, IO iO) {
        NodeScope nodeScope;
        Token token2 = token.specialToken;
        if (token2 != null) {
            while (token2.specialToken != null) {
                token2 = token2.specialToken;
            }
            while (token2 != null) {
                iO.print(this.addUnicodeEscapes(this.translateImage(token2)));
                token2 = token2.next;
            }
        }
        if ((nodeScope = NodeScope.getEnclosingNodeScope(this)) == null) {
            iO.print(this.addUnicodeEscapes(this.translateImage(token)));
            return;
        }
        if (token.image.equals("jjtThis")) {
            iO.print(nodeScope.getNodeVariable());
            return;
        }
        if (token.image.equals("jjtree") && token.next.image.equals(".") && token.next.next.image.equals("currentNode") && token.next.next.next.image.equals("(") && token.next.next.next.next.image.equals(")")) {
            this.whitingOut = true;
        }
        if (this.whitingOut) {
            if (token.image.equals("jjtree")) {
                iO.print(nodeScope.getNodeVariable());
                iO.print(" ");
            } else if (token.image.equals(")")) {
                iO.print(" ");
                this.whitingOut = false;
            } else {
                int n = 0;
                while (n < token.image.length()) {
                    iO.print(" ");
                    ++n;
                }
            }
            return;
        }
        iO.print(this.addUnicodeEscapes(this.translateImage(token)));
    }

    public void setFirstToken(Token token) {
        this.first = token;
    }

    public void setLastToken(Token token) {
        this.last = token;
    }

    public void setOrdinal(int n) {
        this.myOrdinal = n;
    }

    public String toString() {
        return JJTreeParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return String.valueOf(string) + this.toString();
    }

    String translateImage(Token token) {
        return token.image;
    }

    String whiteOut(Token token) {
        String string = "";
        int n = 0;
        while (n < token.image.length()) {
            string = String.valueOf(string) + " ";
            ++n;
        }
        return string;
    }
}

