#!/bin/bash

function jvm_scan_file() {
    file="$1"

    while read jvm; do
        if [ -x "$jvm/bin/java" ]; then
            echo $jvm
            return
        fi
    done < <(grep -v '#' "$file")
}

function jvm_find() {
    program_file="/etc/jvm.d/$1"
    user_program_file="$HOME/.jvm.d/$1"

    if [ -z "$JAVA_HOME" ]; then
        if [ -r "$user_program_file" ]; then
            jvm="$(jvm_scan_file "$user_program_file")"
        fi
    fi

    if [ -z "$JAVA_HOME" ]; then
        if [ -r "$HOME/.jvm" ]; then
            jvm="$(jvm_scan_file "$HOME/.jvm")"
        fi
    fi

    if [ -z "$JAVA_HOME" ]; then
        if [ -r "$program_file" ]; then
            jvm="$(jvm_scan_file "$program_file")"
        fi
    fi

    if [ -z "$JAVA_HOME" ]; then
        if [ -z "$jvm" ]; then
            jvm="$(jvm_scan_file /etc/jvm)"
        fi
    fi

    echo "$jvm"
}
