/* metadata-menu-item.c generated by valac 0.12.0, the Vala compiler
 * generated from metadata-menu-item.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <stdlib.h>
#include <string.h>
#include <common-defs.h>
#include <gee.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <glib/gstdio.h>


#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;
typedef struct _PlayerItemPrivate PlayerItemPrivate;

#define TYPE_METADATA_MENUITEM (metadata_menuitem_get_type ())
#define METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitem))
#define METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))
#define IS_METADATA_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_MENUITEM))
#define IS_METADATA_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_MENUITEM))
#define METADATA_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_MENUITEM, MetadataMenuitemClass))

typedef struct _MetadataMenuitem MetadataMenuitem;
typedef struct _MetadataMenuitemClass MetadataMenuitemClass;
typedef struct _MetadataMenuitemPrivate MetadataMenuitemPrivate;

#define TYPE_FETCH_FILE (fetch_file_get_type ())
#define FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FETCH_FILE, FetchFile))
#define FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FETCH_FILE, FetchFileClass))
#define IS_FETCH_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FETCH_FILE))
#define IS_FETCH_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FETCH_FILE))
#define FETCH_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FETCH_FILE, FetchFileClass))

typedef struct _FetchFile FetchFile;
typedef struct _FetchFileClass FetchFileClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PlayerItem {
	DbusmenuMenuitem parent_instance;
	PlayerItemPrivate * priv;
};

struct _PlayerItemClass {
	DbusmenuMenuitemClass parent_class;
};

struct _MetadataMenuitem {
	PlayerItem parent_instance;
	MetadataMenuitemPrivate * priv;
};

struct _MetadataMenuitemClass {
	PlayerItemClass parent_class;
};

struct _MetadataMenuitemPrivate {
	gchar* previous_temp_album_art_path;
};


static gpointer metadata_menuitem_parent_class = NULL;
extern gchar* metadata_menuitem_album_art_cache_dir;
gchar* metadata_menuitem_album_art_cache_dir = NULL;
static FetchFile* metadata_menuitem_fetcher;
static FetchFile* metadata_menuitem_fetcher = NULL;

GType player_item_get_type (void) G_GNUC_CONST;
GType metadata_menuitem_get_type (void) G_GNUC_CONST;
#define METADATA_MENUITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_METADATA_MENUITEM, MetadataMenuitemPrivate))
enum  {
	METADATA_MENUITEM_DUMMY_PROPERTY
};
GType fetch_file_get_type (void) G_GNUC_CONST;
#define METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX "indicators/sound/album-art-cache"
MetadataMenuitem* metadata_menuitem_new (void);
MetadataMenuitem* metadata_menuitem_construct (GType object_type);
void player_item_reset (PlayerItem* self, GeeHashSet* attrs);
GeeHashSet* metadata_menuitem_attributes_format (void);
static void metadata_menuitem_clean_album_art_temp_dir (void);
static gboolean metadata_menuitem_delete_album_art_contents (GFile* dir);
static gchar* metadata_menuitem_create_album_art_temp_dir (void);
void metadata_menuitem_fetch_art (MetadataMenuitem* self, const gchar* uri, const gchar* prop);
FetchFile* fetch_file_new (const gchar* uri, const gchar* prop);
FetchFile* fetch_file_construct (GType object_type, const gchar* uri, const gchar* prop);
static void _lambda0_ (MetadataMenuitem* self);
static void metadata_menuitem_on_fetcher_failed (MetadataMenuitem* self);
static void __lambda0__fetch_file_failed (FetchFile* _sender, gpointer self);
static void metadata_menuitem_on_fetcher_completed (MetadataMenuitem* self, GByteArray* update, const gchar* property);
static void _metadata_menuitem_on_fetcher_completed_fetch_file_completed (FetchFile* _sender, GByteArray* data, const gchar* property, gpointer self);
void fetch_file_fetch_data (FetchFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void fetch_file_fetch_data_finish (FetchFile* self, GAsyncResult* _res_);
static GObject * metadata_menuitem_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void metadata_menuitem_finalize (GObject* obj);


MetadataMenuitem* metadata_menuitem_construct (GType object_type) {
	MetadataMenuitem * self = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* _tmp1_;
	self = (MetadataMenuitem*) g_object_new (object_type, "item-type", DBUSMENU_METADATA_MENUITEM_TYPE, NULL);
	_tmp0_ = metadata_menuitem_attributes_format ();
	_tmp1_ = _tmp0_;
	player_item_reset ((PlayerItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}


MetadataMenuitem* metadata_menuitem_new (void) {
	return metadata_menuitem_construct (TYPE_METADATA_MENUITEM);
}


static void metadata_menuitem_clean_album_art_temp_dir (void) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	GFile* album_art_dir;
	gboolean _tmp3_;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	album_art_dir = _tmp2_;
	_tmp3_ = metadata_menuitem_delete_album_art_contents (album_art_dir);
	if (_tmp3_ == FALSE) {
		g_warning ("metadata-menu-item.vala:52: could not remove the temp album art files " \
"%s", path);
	}
	_g_object_unref0 (album_art_dir);
	_g_free0 (path);
}


static gchar* metadata_menuitem_create_album_art_temp_dir (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	gint _tmp2_;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, METADATA_MENUITEM_ALBUM_ART_DIR_SUFFIX, NULL);
	path = _tmp1_;
	_tmp2_ = g_mkdir (path, 0700);
	if (_tmp2_ == (-1)) {
		g_warning ("metadata-menu-item.vala:60: could not create a temp dir for remote alb" \
"um art, it must have been created already");
	}
	result = path;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean metadata_menuitem_delete_album_art_contents (GFile* dir) {
	gboolean result = FALSE;
	gboolean _result_;
	GFileEnumerator* _tmp0_ = NULL;
	GFileEnumerator* e;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (dir != NULL, FALSE);
	_result_ = TRUE;
	_tmp0_ = g_file_enumerate_children (dir, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
	e = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	while (TRUE) {
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* file;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* child;
		_tmp1_ = g_file_enumerator_next_file (e, NULL, &_inner_error_);
		file = _tmp1_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (e);
			goto __catch2_g_error;
		}
		_tmp2_ = g_file_info_get_name (file);
		g_debug ("metadata-menu-item.vala:76: file name = %s", _tmp2_);
		if (file == NULL) {
			_g_object_unref0 (file);
			break;
		}
		_tmp3_ = g_file_info_get_name (file);
		_tmp4_ = g_file_get_child (dir, _tmp3_);
		child = _tmp4_;
		g_file_delete (child, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * error_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = g_file_get_basename (child);
			_tmp6_ = _tmp5_;
			_tmp7_ = string_to_string (_tmp6_);
			_tmp8_ = string_to_string (error_->message);
			_tmp9_ = g_strconcat ("Unable to delete file '", _tmp7_, ": ", _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			g_warning ("metadata-menu-item.vala:86: %s", _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp6_);
			_result_ = FALSE;
			_g_error_free0 (error_);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (child);
			_g_object_unref0 (file);
			_g_object_unref0 (e);
			goto __catch2_g_error;
		}
		_g_object_unref0 (child);
		_g_object_unref0 (file);
	}
	_g_object_unref0 (e);
	goto __finally2;
	__catch2_g_error:
	{
		GError * _error_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = g_file_get_basename (dir);
		_tmp12_ = _tmp11_;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("Unable to read files from directory '", _tmp13_, "': %s", NULL);
		_tmp15_ = _tmp14_;
		g_warning (_tmp15_, _error_->message);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		_result_ = FALSE;
		_g_error_free0 (_error_);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _result_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _lambda0_ (MetadataMenuitem* self) {
	metadata_menuitem_on_fetcher_failed (self);
}


static void __lambda0__fetch_file_failed (FetchFile* _sender, gpointer self) {
	_lambda0_ (self);
}


static void _metadata_menuitem_on_fetcher_completed_fetch_file_completed (FetchFile* _sender, GByteArray* data, const gchar* property, gpointer self) {
	metadata_menuitem_on_fetcher_completed (self, data, property);
}


void metadata_menuitem_fetch_art (MetadataMenuitem* self, const gchar* uri, const gchar* prop) {
	GFile* _tmp0_ = NULL;
	GFile* art_file;
	gboolean _tmp1_;
	FetchFile* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	art_file = _tmp0_;
	_tmp1_ = g_file_is_native (art_file);
	if (_tmp1_ == TRUE) {
		gchar* path = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = string_strip (uri);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_filename_from_uri (_tmp3_, NULL, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch4_g_convert_error;
			}
			_g_free0 (path);
			_g_object_unref0 (art_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (path);
		path = _tmp6_;
		dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, prop, path);
		goto __finally4;
		__catch4_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("metadata-menu-item.vala:108: Problem converting URI %s to file path", uri);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (art_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (path);
		_g_object_unref0 (art_file);
		return;
	}
	g_debug ("metadata-menu-item.vala:114: fetch_art -remotely %s", metadata_menuitem_album_art_cache_dir);
	if (metadata_menuitem_album_art_cache_dir == NULL) {
		_g_object_unref0 (art_file);
		return;
	}
	_tmp7_ = fetch_file_new (uri, prop);
	_g_object_unref0 (metadata_menuitem_fetcher);
	metadata_menuitem_fetcher = _tmp7_;
	g_signal_connect_object (metadata_menuitem_fetcher, "failed", (GCallback) __lambda0__fetch_file_failed, self, 0);
	g_signal_connect_object (metadata_menuitem_fetcher, "completed", (GCallback) _metadata_menuitem_on_fetcher_completed_fetch_file_completed, self, 0);
	fetch_file_fetch_data (metadata_menuitem_fetcher, NULL, NULL);
	_g_object_unref0 (art_file);
}


static void metadata_menuitem_on_fetcher_failed (MetadataMenuitem* self) {
	g_return_if_fail (self != NULL);
	g_warning ("metadata-menu-item.vala:129: on_fetcher_failed -> could not fetch artw" \
"ork");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void metadata_menuitem_on_fetcher_completed (MetadataMenuitem* self, GByteArray* update, const gchar* property) {
	GdkPixbufLoader* _tmp0_ = NULL;
	GdkPixbufLoader* loader;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* icon;
	gchar* _tmp3_ = NULL;
	gchar* path;
	gint _tmp4_;
	gint r;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (update != NULL);
	g_return_if_fail (property != NULL);
	_tmp0_ = gdk_pixbuf_loader_new ();
	loader = _tmp0_;
	gdk_pixbuf_loader_write (loader, update->data, (gsize) ((gint) update->len), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (loader);
		goto __catch5_g_error;
	}
	gdk_pixbuf_loader_close (loader, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (loader);
		goto __catch5_g_error;
	}
	_tmp1_ = gdk_pixbuf_loader_get_pixbuf (loader);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	icon = _tmp2_;
	_tmp3_ = g_strconcat (metadata_menuitem_album_art_cache_dir, "/downloaded-coverart-XXXXXX", NULL);
	path = _tmp3_;
	_tmp4_ = g_mkstemp (path);
	r = _tmp4_;
	if (r != (-1)) {
		GdkPixbufFormat* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = gdk_pixbuf_loader_get_format (loader);
		_tmp6_ = gdk_pixbuf_format_get_name (_tmp5_);
		gdk_pixbuf_save (icon, path, _tmp6_, &_inner_error_, NULL);
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			_g_object_unref0 (icon);
			_g_object_unref0 (loader);
			goto __catch5_g_error;
		}
		dbusmenu_menuitem_property_set ((DbusmenuMenuitem*) self, property, path);
		if (self->priv->previous_temp_album_art_path != NULL) {
			g_remove (self->priv->previous_temp_album_art_path);
		}
		_tmp7_ = g_strdup (path);
		_g_free0 (self->priv->previous_temp_album_art_path);
		self->priv->previous_temp_album_art_path = _tmp7_;
	}
	_g_free0 (path);
	_g_object_unref0 (icon);
	_g_object_unref0 (loader);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("metadata-menu-item.vala:151: Problem creating file from bytearray fetc" \
"hed from the interweb - error: %s", e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GeeHashSet* metadata_menuitem_attributes_format (void) {
	GeeHashSet* result = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* attrs;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	attrs = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_TITLE);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTIST);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ALBUM);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_METADATA_MENUITEM_ARTURL);
	result = attrs;
	return result;
}


static GObject * metadata_menuitem_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MetadataMenuitem * self;
	gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (metadata_menuitem_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = METADATA_MENUITEM (obj);
	metadata_menuitem_clean_album_art_temp_dir ();
	_g_free0 (self->priv->previous_temp_album_art_path);
	self->priv->previous_temp_album_art_path = NULL;
	_tmp0_ = metadata_menuitem_create_album_art_temp_dir ();
	_g_free0 (metadata_menuitem_album_art_cache_dir);
	metadata_menuitem_album_art_cache_dir = _tmp0_;
	return obj;
}


static void metadata_menuitem_class_init (MetadataMenuitemClass * klass) {
	metadata_menuitem_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MetadataMenuitemPrivate));
	G_OBJECT_CLASS (klass)->constructor = metadata_menuitem_constructor;
	G_OBJECT_CLASS (klass)->finalize = metadata_menuitem_finalize;
}


static void metadata_menuitem_instance_init (MetadataMenuitem * self) {
	self->priv = METADATA_MENUITEM_GET_PRIVATE (self);
}


static void metadata_menuitem_finalize (GObject* obj) {
	MetadataMenuitem * self;
	self = METADATA_MENUITEM (obj);
	_g_free0 (self->priv->previous_temp_album_art_path);
	G_OBJECT_CLASS (metadata_menuitem_parent_class)->finalize (obj);
}


GType metadata_menuitem_get_type (void) {
	static volatile gsize metadata_menuitem_type_id__volatile = 0;
	if (g_once_init_enter (&metadata_menuitem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MetadataMenuitemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) metadata_menuitem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MetadataMenuitem), 0, (GInstanceInitFunc) metadata_menuitem_instance_init, NULL };
		GType metadata_menuitem_type_id;
		metadata_menuitem_type_id = g_type_register_static (TYPE_PLAYER_ITEM, "MetadataMenuitem", &g_define_type_info, 0);
		g_once_init_leave (&metadata_menuitem_type_id__volatile, metadata_menuitem_type_id);
	}
	return metadata_menuitem_type_id__volatile;
}



