/* transport-menu-item.c generated by valac 0.9.8, the Vala compiler
 * generated from transport-menu-item.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <common-defs.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_PLAYER_ITEM (player_item_get_type ())
#define PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_ITEM, PlayerItem))
#define PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_ITEM, PlayerItemClass))
#define IS_PLAYER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_ITEM))
#define IS_PLAYER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_ITEM))
#define PLAYER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_ITEM, PlayerItemClass))

typedef struct _PlayerItem PlayerItem;
typedef struct _PlayerItemClass PlayerItemClass;
typedef struct _PlayerItemPrivate PlayerItemPrivate;

#define TYPE_TRANSPORT_MENUITEM (transport_menuitem_get_type ())
#define TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitem))
#define TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))
#define IS_TRANSPORT_MENUITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPORT_MENUITEM))
#define IS_TRANSPORT_MENUITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPORT_MENUITEM))
#define TRANSPORT_MENUITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPORT_MENUITEM, TransportMenuitemClass))

typedef struct _TransportMenuitem TransportMenuitem;
typedef struct _TransportMenuitemClass TransportMenuitemClass;
typedef struct _TransportMenuitemPrivate TransportMenuitemPrivate;

#define TRANSPORT_MENUITEM_TYPE_ACTION (transport_menuitem_action_get_type ())

#define TRANSPORT_MENUITEM_TYPE_STATE (transport_menuitem_state_get_type ())

#define TYPE_PLAYER_CONTROLLER (player_controller_get_type ())
#define PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_CONTROLLER, PlayerController))
#define PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))
#define IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_CONTROLLER))
#define IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_CONTROLLER))
#define PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_CONTROLLER, PlayerControllerClass))

typedef struct _PlayerController PlayerController;
typedef struct _PlayerControllerClass PlayerControllerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PlayerControllerPrivate PlayerControllerPrivate;

#define TYPE_MPRIS2_CONTROLLER (mpris2_controller_get_type ())
#define MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2Controller))
#define MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))
#define IS_MPRIS2_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_CONTROLLER))
#define IS_MPRIS2_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_CONTROLLER))
#define MPRIS2_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_CONTROLLER, Mpris2ControllerClass))

typedef struct _Mpris2Controller Mpris2Controller;
typedef struct _Mpris2ControllerClass Mpris2ControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PlayerItem {
	DbusmenuMenuitem parent_instance;
	PlayerItemPrivate * priv;
};

struct _PlayerItemClass {
	DbusmenuMenuitemClass parent_class;
};

struct _TransportMenuitem {
	PlayerItem parent_instance;
	TransportMenuitemPrivate * priv;
};

struct _TransportMenuitemClass {
	PlayerItemClass parent_class;
};

typedef enum  {
	TRANSPORT_MENUITEM_ACTION_PREVIOUS,
	TRANSPORT_MENUITEM_ACTION_PLAY_PAUSE,
	TRANSPORT_MENUITEM_ACTION_NEXT
} TransportMenuitemaction;

typedef enum  {
	TRANSPORT_MENUITEM_STATE_PLAYING,
	TRANSPORT_MENUITEM_STATE_PAUSED
} TransportMenuitemstate;

struct _PlayerController {
	GObject parent_instance;
	PlayerControllerPrivate * priv;
	gint current_state;
	GeeArrayList* custom_items;
	Mpris2Controller* mpris_bridge;
};

struct _PlayerControllerClass {
	GObjectClass parent_class;
};


static gpointer transport_menuitem_parent_class = NULL;

GType player_item_get_type (void) G_GNUC_CONST;
GType transport_menuitem_get_type (void) G_GNUC_CONST;
enum  {
	TRANSPORT_MENUITEM_DUMMY_PROPERTY
};
GType transport_menuitem_action_get_type (void) G_GNUC_CONST;
GType transport_menuitem_state_get_type (void) G_GNUC_CONST;
GType player_controller_get_type (void) G_GNUC_CONST;
TransportMenuitem* transport_menuitem_new (PlayerController* parent);
TransportMenuitem* transport_menuitem_construct (GType object_type, PlayerController* parent);
void transport_menuitem_change_play_state (TransportMenuitem* self, TransportMenuitemstate update);
static void transport_menuitem_real_handle_event (DbusmenuMenuitem* base, const char* name, GValue* input_value, guint timestamp);
PlayerController* player_item_get_owner (PlayerItem* self);
const char* player_controller_get_name (PlayerController* self);
GType mpris2_controller_get_type (void) G_GNUC_CONST;
void mpris2_controller_transport_update (Mpris2Controller* self, TransportMenuitemaction command);
GeeHashSet* transport_menuitem_attributes_format (void);



GType transport_menuitem_action_get_type (void) {
	static volatile gsize transport_menuitem_action_type_id__volatile = 0;
	if (g_once_init_enter (&transport_menuitem_action_type_id__volatile)) {
		static const GEnumValue values[] = {{TRANSPORT_MENUITEM_ACTION_PREVIOUS, "TRANSPORT_MENUITEM_ACTION_PREVIOUS", "previous"}, {TRANSPORT_MENUITEM_ACTION_PLAY_PAUSE, "TRANSPORT_MENUITEM_ACTION_PLAY_PAUSE", "play-pause"}, {TRANSPORT_MENUITEM_ACTION_NEXT, "TRANSPORT_MENUITEM_ACTION_NEXT", "next"}, {0, NULL, NULL}};
		GType transport_menuitem_action_type_id;
		transport_menuitem_action_type_id = g_enum_register_static ("TransportMenuitemaction", values);
		g_once_init_leave (&transport_menuitem_action_type_id__volatile, transport_menuitem_action_type_id);
	}
	return transport_menuitem_action_type_id__volatile;
}


GType transport_menuitem_state_get_type (void) {
	static volatile gsize transport_menuitem_state_type_id__volatile = 0;
	if (g_once_init_enter (&transport_menuitem_state_type_id__volatile)) {
		static const GEnumValue values[] = {{TRANSPORT_MENUITEM_STATE_PLAYING, "TRANSPORT_MENUITEM_STATE_PLAYING", "playing"}, {TRANSPORT_MENUITEM_STATE_PAUSED, "TRANSPORT_MENUITEM_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
		GType transport_menuitem_state_type_id;
		transport_menuitem_state_type_id = g_enum_register_static ("TransportMenuitemstate", values);
		g_once_init_leave (&transport_menuitem_state_type_id__volatile, transport_menuitem_state_type_id);
	}
	return transport_menuitem_state_type_id__volatile;
}


TransportMenuitem* transport_menuitem_construct (GType object_type, PlayerController* parent) {
	TransportMenuitem * self;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (TransportMenuitem*) g_object_new (object_type, "item-type", DBUSMENU_TRANSPORT_MENUITEM_TYPE, "owner", parent, NULL);
	dbusmenu_menuitem_property_set_int ((DbusmenuMenuitem*) self, DBUSMENU_TRANSPORT_MENUITEM_PLAY_STATE, 1);
	return self;
}


TransportMenuitem* transport_menuitem_new (PlayerController* parent) {
	return transport_menuitem_construct (TYPE_TRANSPORT_MENUITEM, parent);
}


void transport_menuitem_change_play_state (TransportMenuitem* self, TransportMenuitemstate update) {
	g_return_if_fail (self != NULL);
	dbusmenu_menuitem_property_set_int ((DbusmenuMenuitem*) self, DBUSMENU_TRANSPORT_MENUITEM_PLAY_STATE, (gint) update);
}


static void transport_menuitem_real_handle_event (DbusmenuMenuitem* base, const char* name, GValue* input_value, guint timestamp) {
	TransportMenuitem * self;
	gint input;
	char* _tmp0_;
	self = (TransportMenuitem*) base;
	g_return_if_fail (name != NULL);
	input = g_value_get_int (input_value);
	g_debug ("transport-menu-item.vala:51: handle_event with value %s", _tmp0_ = g_strdup_printf ("%i", input));
	_g_free0 (_tmp0_);
	g_debug ("transport-menu-item.vala:52: transport owner name = %s", player_controller_get_name (player_item_get_owner ((PlayerItem*) self)));
	mpris2_controller_transport_update (player_item_get_owner ((PlayerItem*) self)->mpris_bridge, (TransportMenuitemaction) input);
}


GeeHashSet* transport_menuitem_attributes_format (void) {
	GeeHashSet* result = NULL;
	GeeHashSet* attrs;
	attrs = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) attrs, DBUSMENU_TRANSPORT_MENUITEM_PLAY_STATE);
	result = attrs;
	return result;
}


static void transport_menuitem_class_init (TransportMenuitemClass * klass) {
	transport_menuitem_parent_class = g_type_class_peek_parent (klass);
	DBUSMENU_MENUITEM_CLASS (klass)->handle_event = transport_menuitem_real_handle_event;
}


static void transport_menuitem_instance_init (TransportMenuitem * self) {
}


GType transport_menuitem_get_type (void) {
	static volatile gsize transport_menuitem_type_id__volatile = 0;
	if (g_once_init_enter (&transport_menuitem_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TransportMenuitemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) transport_menuitem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TransportMenuitem), 0, (GInstanceInitFunc) transport_menuitem_instance_init, NULL };
		GType transport_menuitem_type_id;
		transport_menuitem_type_id = g_type_register_static (TYPE_PLAYER_ITEM, "TransportMenuitem", &g_define_type_info, 0);
		g_once_init_leave (&transport_menuitem_type_id__volatile, transport_menuitem_type_id);
	}
	return transport_menuitem_type_id__volatile;
}




