/*
 * Generated by gdbus-codegen 2.34.0. DO NOT EDIT.
 *
 * The license of this code is the same as for the source it was derived from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "dbus-display-manager.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  gboolean use_gvariant;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.DisplayManager.Seat
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:DisplayManagerSeat
 * @title: DisplayManagerSeat
 * @short_description: Generated C code for the org.freedesktop.DisplayManager.Seat D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.DisplayManager.Seat ---- */

static const _ExtendedGDBusMethodInfo _display_manager_seat_method_info_switch_to_greeter =
{
  {
    -1,
    (gchar *) "SwitchToGreeter",
    NULL,
    NULL,
    NULL
  },
  "handle-switch-to-greeter",
  FALSE
};

static const _ExtendedGDBusArgInfo _display_manager_seat_method_info_switch_to_user_IN_ARG_username =
{
  {
    -1,
    (gchar *) "username",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _display_manager_seat_method_info_switch_to_user_IN_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _display_manager_seat_method_info_switch_to_user_IN_ARG_pointers[] =
{
  &_display_manager_seat_method_info_switch_to_user_IN_ARG_username,
  &_display_manager_seat_method_info_switch_to_user_IN_ARG_session_name,
  NULL
};

static const _ExtendedGDBusMethodInfo _display_manager_seat_method_info_switch_to_user =
{
  {
    -1,
    (gchar *) "SwitchToUser",
    (GDBusArgInfo **) &_display_manager_seat_method_info_switch_to_user_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-switch-to-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _display_manager_seat_method_info_switch_to_guest_IN_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo * const _display_manager_seat_method_info_switch_to_guest_IN_ARG_pointers[] =
{
  &_display_manager_seat_method_info_switch_to_guest_IN_ARG_session_name,
  NULL
};

static const _ExtendedGDBusMethodInfo _display_manager_seat_method_info_switch_to_guest =
{
  {
    -1,
    (gchar *) "SwitchToGuest",
    (GDBusArgInfo **) &_display_manager_seat_method_info_switch_to_guest_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-switch-to-guest",
  FALSE
};

static const _ExtendedGDBusMethodInfo _display_manager_seat_method_info_lock =
{
  {
    -1,
    (gchar *) "Lock",
    NULL,
    NULL,
    NULL
  },
  "handle-lock",
  FALSE
};

static const _ExtendedGDBusMethodInfo * const _display_manager_seat_method_info_pointers[] =
{
  &_display_manager_seat_method_info_switch_to_greeter,
  &_display_manager_seat_method_info_switch_to_user,
  &_display_manager_seat_method_info_switch_to_guest,
  &_display_manager_seat_method_info_lock,
  NULL
};

static const _ExtendedGDBusPropertyInfo _display_manager_seat_property_info_can_switch =
{
  {
    -1,
    (gchar *) "CanSwitch",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-switch",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _display_manager_seat_property_info_has_guest_account =
{
  {
    -1,
    (gchar *) "HasGuestAccount",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-guest-account",
  FALSE
};

static const _ExtendedGDBusPropertyInfo _display_manager_seat_property_info_sessions =
{
  {
    -1,
    (gchar *) "Sessions",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "sessions",
  FALSE
};

static const _ExtendedGDBusPropertyInfo * const _display_manager_seat_property_info_pointers[] =
{
  &_display_manager_seat_property_info_can_switch,
  &_display_manager_seat_property_info_has_guest_account,
  &_display_manager_seat_property_info_sessions,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _display_manager_seat_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.DisplayManager.Seat",
    (GDBusMethodInfo **) &_display_manager_seat_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_display_manager_seat_property_info_pointers,
    NULL
  },
  "display-manager-seat",
};


/**
 * display_manager_seat_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
display_manager_seat_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct;
}

/**
 * display_manager_seat_override_properties:
 * @klass: The class structure for a #GObject<!-- -->-derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #DisplayManagerSeat interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
display_manager_seat_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "can-switch");
  g_object_class_override_property (klass, property_id_begin++, "has-guest-account");
  g_object_class_override_property (klass, property_id_begin++, "sessions");
  return property_id_begin - 1;
}



/**
 * DisplayManagerSeat:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link>.
 */

/**
 * DisplayManagerSeatIface:
 * @parent_iface: The parent interface.
 * @handle_lock: Handler for the #DisplayManagerSeat::handle-lock signal.
 * @handle_switch_to_greeter: Handler for the #DisplayManagerSeat::handle-switch-to-greeter signal.
 * @handle_switch_to_guest: Handler for the #DisplayManagerSeat::handle-switch-to-guest signal.
 * @handle_switch_to_user: Handler for the #DisplayManagerSeat::handle-switch-to-user signal.
 * @get_can_switch: Getter for the #DisplayManagerSeat:can-switch property.
 * @get_has_guest_account: Getter for the #DisplayManagerSeat:has-guest-account property.
 * @get_sessions: Getter for the #DisplayManagerSeat:sessions property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link>.
 */

static void
display_manager_seat_default_init (DisplayManagerSeatIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * DisplayManagerSeat::handle-switch-to-greeter:
   * @object: A #DisplayManagerSeat.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGreeter">SwitchToGreeter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call display_manager_seat_complete_switch_to_greeter() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-to-greeter",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DisplayManagerSeatIface, handle_switch_to_greeter),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * DisplayManagerSeat::handle-switch-to-user:
   * @object: A #DisplayManagerSeat.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_username: Argument passed by remote caller.
   * @arg_session_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToUser">SwitchToUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call display_manager_seat_complete_switch_to_user() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-to-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DisplayManagerSeatIface, handle_switch_to_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * DisplayManagerSeat::handle-switch-to-guest:
   * @object: A #DisplayManagerSeat.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGuest">SwitchToGuest()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call display_manager_seat_complete_switch_to_guest() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-to-guest",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DisplayManagerSeatIface, handle_switch_to_guest),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * DisplayManagerSeat::handle-lock:
   * @object: A #DisplayManagerSeat.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.Lock">Lock()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call display_manager_seat_complete_lock() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lock",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DisplayManagerSeatIface, handle_lock),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * DisplayManagerSeat:can-switch:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.CanSwitch">"CanSwitch"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-switch", "CanSwitch", "CanSwitch", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * DisplayManagerSeat:has-guest-account:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.HasGuestAccount">"HasGuestAccount"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-guest-account", "HasGuestAccount", "HasGuestAccount", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * DisplayManagerSeat:sessions:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.Sessions">"Sessions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("sessions", "Sessions", "Sessions", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

typedef DisplayManagerSeatIface DisplayManagerSeatInterface;
G_DEFINE_INTERFACE (DisplayManagerSeat, display_manager_seat, G_TYPE_OBJECT);

/**
 * display_manager_seat_get_can_switch: (skip)
 * @object: A #DisplayManagerSeat.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.CanSwitch">"CanSwitch"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
display_manager_seat_get_can_switch (DisplayManagerSeat *object)
{
  return DISPLAY_MANAGER_SEAT_GET_IFACE (object)->get_can_switch (object);
}

/**
 * display_manager_seat_set_can_switch: (skip)
 * @object: A #DisplayManagerSeat.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.CanSwitch">"CanSwitch"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
display_manager_seat_set_can_switch (DisplayManagerSeat *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-switch", value, NULL);
}

/**
 * display_manager_seat_get_has_guest_account: (skip)
 * @object: A #DisplayManagerSeat.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.HasGuestAccount">"HasGuestAccount"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
display_manager_seat_get_has_guest_account (DisplayManagerSeat *object)
{
  return DISPLAY_MANAGER_SEAT_GET_IFACE (object)->get_has_guest_account (object);
}

/**
 * display_manager_seat_set_has_guest_account: (skip)
 * @object: A #DisplayManagerSeat.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.HasGuestAccount">"HasGuestAccount"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
display_manager_seat_set_has_guest_account (DisplayManagerSeat *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-guest-account", value, NULL);
}

/**
 * display_manager_seat_get_sessions: (skip)
 * @object: A #DisplayManagerSeat.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.Sessions">"Sessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * <warning>The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use display_manager_seat_dup_sessions() if on another thread.</warning>
 *
 * Returns: (transfer none): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
display_manager_seat_get_sessions (DisplayManagerSeat *object)
{
  return DISPLAY_MANAGER_SEAT_GET_IFACE (object)->get_sessions (object);
}

/**
 * display_manager_seat_dup_sessions: (skip)
 * @object: A #DisplayManagerSeat.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.Sessions">"Sessions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
display_manager_seat_dup_sessions (DisplayManagerSeat *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "sessions", &value, NULL);
  return value;
}

/**
 * display_manager_seat_set_sessions: (skip)
 * @object: A #DisplayManagerSeat.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-DisplayManager-Seat.Sessions">"Sessions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
display_manager_seat_set_sessions (DisplayManagerSeat *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "sessions", value, NULL);
}

/**
 * display_manager_seat_call_switch_to_greeter:
 * @proxy: A #DisplayManagerSeatProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGreeter">SwitchToGreeter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_call_switch_to_greeter_finish() to get the result of the operation.
 *
 * See display_manager_seat_call_switch_to_greeter_sync() for the synchronous, blocking version of this method.
 */
void
display_manager_seat_call_switch_to_greeter (
    DisplayManagerSeat *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchToGreeter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * display_manager_seat_call_switch_to_greeter_finish:
 * @proxy: A #DisplayManagerSeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_call_switch_to_greeter().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with display_manager_seat_call_switch_to_greeter().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_greeter_finish (
    DisplayManagerSeat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_switch_to_greeter_sync:
 * @proxy: A #DisplayManagerSeatProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGreeter">SwitchToGreeter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_call_switch_to_greeter() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_greeter_sync (
    DisplayManagerSeat *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchToGreeter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_switch_to_user:
 * @proxy: A #DisplayManagerSeatProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToUser">SwitchToUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_call_switch_to_user_finish() to get the result of the operation.
 *
 * See display_manager_seat_call_switch_to_user_sync() for the synchronous, blocking version of this method.
 */
void
display_manager_seat_call_switch_to_user (
    DisplayManagerSeat *proxy,
    const gchar *arg_username,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchToUser",
    g_variant_new ("(ss)",
                   arg_username,
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * display_manager_seat_call_switch_to_user_finish:
 * @proxy: A #DisplayManagerSeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_call_switch_to_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with display_manager_seat_call_switch_to_user().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_user_finish (
    DisplayManagerSeat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_switch_to_user_sync:
 * @proxy: A #DisplayManagerSeatProxy.
 * @arg_username: Argument to pass with the method invocation.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToUser">SwitchToUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_call_switch_to_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_user_sync (
    DisplayManagerSeat *proxy,
    const gchar *arg_username,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchToUser",
    g_variant_new ("(ss)",
                   arg_username,
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_switch_to_guest:
 * @proxy: A #DisplayManagerSeatProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGuest">SwitchToGuest()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_call_switch_to_guest_finish() to get the result of the operation.
 *
 * See display_manager_seat_call_switch_to_guest_sync() for the synchronous, blocking version of this method.
 */
void
display_manager_seat_call_switch_to_guest (
    DisplayManagerSeat *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchToGuest",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * display_manager_seat_call_switch_to_guest_finish:
 * @proxy: A #DisplayManagerSeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_call_switch_to_guest().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with display_manager_seat_call_switch_to_guest().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_guest_finish (
    DisplayManagerSeat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_switch_to_guest_sync:
 * @proxy: A #DisplayManagerSeatProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGuest">SwitchToGuest()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_call_switch_to_guest() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_switch_to_guest_sync (
    DisplayManagerSeat *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchToGuest",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_lock:
 * @proxy: A #DisplayManagerSeatProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.Lock">Lock()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_call_lock_finish() to get the result of the operation.
 *
 * See display_manager_seat_call_lock_sync() for the synchronous, blocking version of this method.
 */
void
display_manager_seat_call_lock (
    DisplayManagerSeat *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * display_manager_seat_call_lock_finish:
 * @proxy: A #DisplayManagerSeatProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_call_lock().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with display_manager_seat_call_lock().
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_lock_finish (
    DisplayManagerSeat *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_call_lock_sync:
 * @proxy: A #DisplayManagerSeatProxy.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.Lock">Lock()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_call_lock() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeded, %FALSE if @error is set.
 */
gboolean
display_manager_seat_call_lock_sync (
    DisplayManagerSeat *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lock",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * display_manager_seat_complete_switch_to_greeter:
 * @object: A #DisplayManagerSeat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGreeter">SwitchToGreeter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
display_manager_seat_complete_switch_to_greeter (
    DisplayManagerSeat *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * display_manager_seat_complete_switch_to_user:
 * @object: A #DisplayManagerSeat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToUser">SwitchToUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
display_manager_seat_complete_switch_to_user (
    DisplayManagerSeat *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * display_manager_seat_complete_switch_to_guest:
 * @object: A #DisplayManagerSeat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.SwitchToGuest">SwitchToGuest()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
display_manager_seat_complete_switch_to_guest (
    DisplayManagerSeat *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * display_manager_seat_complete_lock:
 * @object: A #DisplayManagerSeat.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-DisplayManager-Seat.Lock">Lock()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
display_manager_seat_complete_lock (
    DisplayManagerSeat *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * DisplayManagerSeatProxy:
 *
 * The #DisplayManagerSeatProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DisplayManagerSeatProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DisplayManagerSeatProxy.
 */

struct _DisplayManagerSeatProxyPrivate
{
  GData *qdata;
};

static void display_manager_seat_proxy_iface_init (DisplayManagerSeatIface *iface);

G_DEFINE_TYPE_WITH_CODE (DisplayManagerSeatProxy, display_manager_seat_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_DISPLAY_MANAGER_SEAT, display_manager_seat_proxy_iface_init));

static void
display_manager_seat_proxy_finalize (GObject *object)
{
  DisplayManagerSeatProxy *proxy = DISPLAY_MANAGER_SEAT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (display_manager_seat_proxy_parent_class)->finalize (object);
}

static void
display_manager_seat_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _display_manager_seat_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
display_manager_seat_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  error = NULL;
  if (!g_dbus_proxy_call_finish (proxy, res, &error))
    {
      g_warning ("Error setting property `%s' on interface org.freedesktop.DisplayManager.Seat: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
}

static void
display_manager_seat_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = _display_manager_seat_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.DisplayManager.Seat", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) display_manager_seat_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
display_manager_seat_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_DISPLAY_MANAGER_SEAT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DISPLAY_MANAGER_SEAT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
display_manager_seat_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  DisplayManagerSeatProxy *proxy = DISPLAY_MANAGER_SEAT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
display_manager_seat_proxy_get_can_switch (DisplayManagerSeat *object)
{
  DisplayManagerSeatProxy *proxy = DISPLAY_MANAGER_SEAT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSwitch");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
display_manager_seat_proxy_get_has_guest_account (DisplayManagerSeat *object)
{
  DisplayManagerSeatProxy *proxy = DISPLAY_MANAGER_SEAT_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasGuestAccount");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
display_manager_seat_proxy_get_sessions (DisplayManagerSeat *object)
{
  DisplayManagerSeatProxy *proxy = DISPLAY_MANAGER_SEAT_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Sessions");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
display_manager_seat_proxy_init (DisplayManagerSeatProxy *proxy)
{
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_DISPLAY_MANAGER_SEAT_PROXY, DisplayManagerSeatProxyPrivate);
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), display_manager_seat_interface_info ());
}

static void
display_manager_seat_proxy_class_init (DisplayManagerSeatProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  g_type_class_add_private (klass, sizeof (DisplayManagerSeatProxyPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = display_manager_seat_proxy_finalize;
  gobject_class->get_property = display_manager_seat_proxy_get_property;
  gobject_class->set_property = display_manager_seat_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = display_manager_seat_proxy_g_signal;
  proxy_class->g_properties_changed = display_manager_seat_proxy_g_properties_changed;


  display_manager_seat_override_properties (gobject_class, 1);
}

static void
display_manager_seat_proxy_iface_init (DisplayManagerSeatIface *iface)
{
  iface->get_can_switch = display_manager_seat_proxy_get_can_switch;
  iface->get_has_guest_account = display_manager_seat_proxy_get_has_guest_account;
  iface->get_sessions = display_manager_seat_proxy_get_sessions;
}

/**
 * display_manager_seat_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_proxy_new_finish() to get the result of the operation.
 *
 * See display_manager_seat_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
display_manager_seat_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DISPLAY_MANAGER_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
}

/**
 * display_manager_seat_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with display_manager_seat_proxy_new().
 *
 * Returns: (transfer full) (type DisplayManagerSeatProxy): The constructed proxy object or %NULL if @error is set.
 */
DisplayManagerSeat *
display_manager_seat_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DISPLAY_MANAGER_SEAT (ret);
  else
    return NULL;
}

/**
 * display_manager_seat_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (allow-none): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DisplayManagerSeatProxy): The constructed proxy object or %NULL if @error is set.
 */
DisplayManagerSeat *
display_manager_seat_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DISPLAY_MANAGER_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
  if (ret != NULL)
    return DISPLAY_MANAGER_SEAT (ret);
  else
    return NULL;
}


/**
 * display_manager_seat_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like display_manager_seat_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the <link linkend="g-main-context-push-thread-default">thread-default main loop</link> of the thread you are calling this method from.
 * You can then call display_manager_seat_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See display_manager_seat_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
display_manager_seat_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DISPLAY_MANAGER_SEAT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
}

/**
 * display_manager_seat_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to display_manager_seat_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with display_manager_seat_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type DisplayManagerSeatProxy): The constructed proxy object or %NULL if @error is set.
 */
DisplayManagerSeat *
display_manager_seat_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DISPLAY_MANAGER_SEAT (ret);
  else
    return NULL;
}

/**
 * display_manager_seat_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (allow-none): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like display_manager_seat_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See display_manager_seat_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DisplayManagerSeatProxy): The constructed proxy object or %NULL if @error is set.
 */
DisplayManagerSeat *
display_manager_seat_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DISPLAY_MANAGER_SEAT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.DisplayManager.Seat", NULL);
  if (ret != NULL)
    return DISPLAY_MANAGER_SEAT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * DisplayManagerSeatSkeleton:
 *
 * The #DisplayManagerSeatSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DisplayManagerSeatSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DisplayManagerSeatSkeleton.
 */

struct _DisplayManagerSeatSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_display_manager_seat_skeleton_handle_method_call (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  guint num_params;
  guint num_extra;
  guint n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_DISPLAY_MANAGER_SEAT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DISPLAY_MANAGER_SEAT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_display_manager_seat_skeleton_handle_get_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_display_manager_seat_skeleton_handle_set_property (
  GDBusConnection *connection,
  const gchar *sender,
  const gchar *object_path,
  const gchar *interface_name,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_display_manager_seat_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _display_manager_seat_skeleton_vtable =
{
  _display_manager_seat_skeleton_handle_method_call,
  _display_manager_seat_skeleton_handle_get_property,
  _display_manager_seat_skeleton_handle_set_property
};

static GDBusInterfaceInfo *
display_manager_seat_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton)
{
  return display_manager_seat_interface_info ();
}

static GDBusInterfaceVTable *
display_manager_seat_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton)
{
  return (GDBusInterfaceVTable *) &_display_manager_seat_skeleton_vtable;
}

static GVariant *
display_manager_seat_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_display_manager_seat_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _display_manager_seat_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _display_manager_seat_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _display_manager_seat_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.DisplayManager.Seat", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _display_manager_seat_emit_changed (gpointer user_data);

static void
display_manager_seat_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _display_manager_seat_emit_changed (skeleton);
}

static void display_manager_seat_skeleton_iface_init (DisplayManagerSeatIface *iface);
G_DEFINE_TYPE_WITH_CODE (DisplayManagerSeatSkeleton, display_manager_seat_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_DISPLAY_MANAGER_SEAT, display_manager_seat_skeleton_iface_init));

static void
display_manager_seat_skeleton_finalize (GObject *object)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (display_manager_seat_skeleton_parent_class)->finalize (object);
}

static void
display_manager_seat_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_display_manager_seat_emit_changed (gpointer user_data)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.DisplayManager.Seat",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_display_manager_seat_schedule_emit_changed (DisplayManagerSeatSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
display_manager_seat_skeleton_notify (GObject      *object,
  GParamSpec *pspec)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _display_manager_seat_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
display_manager_seat_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL)
        _display_manager_seat_schedule_emit_changed (skeleton, _display_manager_seat_property_info_pointers[prop_id - 1], prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
display_manager_seat_skeleton_init (DisplayManagerSeatSkeleton *skeleton)
{
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_DISPLAY_MANAGER_SEAT_SKELETON, DisplayManagerSeatSkeletonPrivate);
  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
}

static gboolean 
display_manager_seat_skeleton_get_can_switch (DisplayManagerSeat *object)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
display_manager_seat_skeleton_get_has_guest_account (DisplayManagerSeat *object)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
display_manager_seat_skeleton_get_sessions (DisplayManagerSeat *object)
{
  DisplayManagerSeatSkeleton *skeleton = DISPLAY_MANAGER_SEAT_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
display_manager_seat_skeleton_class_init (DisplayManagerSeatSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  g_type_class_add_private (klass, sizeof (DisplayManagerSeatSkeletonPrivate));

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = display_manager_seat_skeleton_finalize;
  gobject_class->get_property = display_manager_seat_skeleton_get_property;
  gobject_class->set_property = display_manager_seat_skeleton_set_property;
  gobject_class->notify       = display_manager_seat_skeleton_notify;


  display_manager_seat_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = display_manager_seat_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = display_manager_seat_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = display_manager_seat_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = display_manager_seat_skeleton_dbus_interface_get_vtable;
}

static void
display_manager_seat_skeleton_iface_init (DisplayManagerSeatIface *iface)
{
  iface->get_can_switch = display_manager_seat_skeleton_get_can_switch;
  iface->get_has_guest_account = display_manager_seat_skeleton_get_has_guest_account;
  iface->get_sessions = display_manager_seat_skeleton_get_sessions;
}

/**
 * display_manager_seat_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-DisplayManager-Seat.top_of_page">org.freedesktop.DisplayManager.Seat</link>.
 *
 * Returns: (transfer full) (type DisplayManagerSeatSkeleton): The skeleton object.
 */
DisplayManagerSeat *
display_manager_seat_skeleton_new (void)
{
  return DISPLAY_MANAGER_SEAT (g_object_new (TYPE_DISPLAY_MANAGER_SEAT_SKELETON, NULL));
}

