/* iconwidget.c generated by valac 0.24.0, the Vala compiler
 * generated from iconwidget.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _IconWidgetPrivate IconWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IconWidget {
	GtkImage parent_instance;
	IconWidgetPrivate * priv;
};

struct _IconWidgetClass {
	GtkImageClass parent_class;
};


static gpointer icon_widget_parent_class = NULL;

GType icon_widget_get_type (void) G_GNUC_CONST;
enum  {
	ICON_WIDGET_DUMMY_PROPERTY
};
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);


/**
     * IconWidget:
     * @icon_name_or_path: Can be a name or path but not stock id
     *     because gtk_icon_theme_load_icon() cannot fallback the
     *     stock id to a real file name against
     *     gtk_image_new_from_stock().
     * @size: #Gtk.IconSize
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size) {
	IconWidget * self = NULL;
	GdkPixbuf* pixbuf = NULL;
	gint fixed_width = 0;
	gint fixed_height = 0;
	GtkIconSize _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp25_ = NULL;
	gfloat width = 0.0F;
	GdkPixbuf* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gfloat height = 0.0F;
	GdkPixbuf* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gfloat _tmp30_ = 0.0F;
	gfloat _tmp31_ = 0.0F;
	gfloat _tmp32_ = 0.0F;
	gfloat scale = 0.0F;
	gint _tmp35_ = 0;
	gfloat _tmp36_ = 0.0F;
	gfloat _tmp37_ = 0.0F;
	gfloat _tmp38_ = 0.0F;
	gfloat _tmp39_ = 0.0F;
	GdkPixbuf* _tmp40_ = NULL;
	gfloat _tmp41_ = 0.0F;
	gfloat _tmp42_ = 0.0F;
	GdkPixbuf* _tmp43_ = NULL;
	GdkPixbuf* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (icon_name_or_path != NULL, NULL);
	self = (IconWidget*) g_object_new (object_type, NULL);
	pixbuf = NULL;
	_tmp0_ = size;
	gtk_icon_size_lookup (_tmp0_, &_tmp1_, &_tmp2_);
	fixed_width = _tmp1_;
	fixed_height = _tmp2_;
	{
		const gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
		_tmp3_ = icon_name_or_path;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		if (_tmp4_ == '/') {
			GdkPixbuf* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_ = NULL;
			GdkPixbuf* _tmp8_ = NULL;
			_tmp6_ = icon_name_or_path;
			_tmp7_ = gdk_pixbuf_new_from_file (_tmp6_, &_inner_error_);
			_tmp5_ = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp8_;
			_g_object_unref0 (_tmp5_);
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp9_ = NULL;
			GtkIconTheme* _tmp10_ = NULL;
			GdkPixbuf* _tmp11_ = NULL;
			GtkIconTheme* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GdkPixbuf* _tmp15_ = NULL;
			GdkPixbuf* _tmp16_ = NULL;
			_tmp9_ = gtk_icon_theme_get_default ();
			_tmp10_ = _g_object_ref0 (_tmp9_);
			theme = _tmp10_;
			_tmp12_ = theme;
			_tmp13_ = icon_name_or_path;
			_tmp14_ = fixed_width;
			_tmp15_ = gtk_icon_theme_load_icon (_tmp12_, _tmp13_, _tmp14_, 0, &_inner_error_);
			_tmp11_ = _tmp15_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch0_g_error;
			}
			_tmp16_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp16_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (theme);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp17_ = NULL;
			GtkIconTheme* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			GtkIconTheme* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			GdkPixbuf* _tmp22_ = NULL;
			GdkPixbuf* _tmp23_ = NULL;
			_tmp17_ = gtk_icon_theme_get_default ();
			_tmp18_ = _g_object_ref0 (_tmp17_);
			theme = _tmp18_;
			_tmp20_ = theme;
			_tmp21_ = fixed_width;
			_tmp22_ = gtk_icon_theme_load_icon (_tmp20_, "ibus-engine", _tmp21_, 0, &_inner_error_);
			_tmp19_ = _tmp22_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch1_g_error;
			}
			_tmp23_ = _tmp19_;
			_tmp19_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp23_;
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (theme);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GtkIconSize _tmp24_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = size;
			gtk_image_set_from_icon_name ((GtkImage*) self, "image-missing", _tmp24_);
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			return self;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = pixbuf;
	if (_tmp25_ == NULL) {
		_g_object_unref0 (pixbuf);
		return self;
	}
	_tmp26_ = pixbuf;
	_tmp27_ = gdk_pixbuf_get_width (_tmp26_);
	width = (gfloat) _tmp27_;
	_tmp28_ = pixbuf;
	_tmp29_ = gdk_pixbuf_get_height (_tmp28_);
	height = (gfloat) _tmp29_;
	_tmp31_ = width;
	_tmp32_ = height;
	if (_tmp31_ > _tmp32_) {
		gfloat _tmp33_ = 0.0F;
		_tmp33_ = width;
		_tmp30_ = _tmp33_;
	} else {
		gfloat _tmp34_ = 0.0F;
		_tmp34_ = height;
		_tmp30_ = _tmp34_;
	}
	_tmp35_ = fixed_width;
	scale = _tmp35_ / _tmp30_;
	_tmp36_ = width;
	_tmp37_ = scale;
	width = _tmp36_ * _tmp37_;
	_tmp38_ = height;
	_tmp39_ = scale;
	height = _tmp38_ * _tmp39_;
	_tmp40_ = pixbuf;
	_tmp41_ = width;
	_tmp42_ = height;
	_tmp43_ = gdk_pixbuf_scale_simple (_tmp40_, (gint) _tmp41_, (gint) _tmp42_, GDK_INTERP_BILINEAR);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp43_;
	_tmp44_ = pixbuf;
	gtk_image_set_from_pixbuf ((GtkImage*) self, _tmp44_);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (pixbuf);
	return self;
}


IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size) {
	return icon_widget_construct (TYPE_ICON_WIDGET, icon_name_or_path, size);
}


static void icon_widget_class_init (IconWidgetClass * klass) {
	icon_widget_parent_class = g_type_class_peek_parent (klass);
}


static void icon_widget_instance_init (IconWidget * self) {
}


GType icon_widget_get_type (void) {
	static volatile gsize icon_widget_type_id__volatile = 0;
	if (g_once_init_enter (&icon_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IconWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconWidget), 0, (GInstanceInitFunc) icon_widget_instance_init, NULL };
		GType icon_widget_type_id;
		icon_widget_type_id = g_type_register_static (GTK_TYPE_IMAGE, "IconWidget", &g_define_type_info, 0);
		g_once_init_leave (&icon_widget_type_id__volatile, icon_widget_type_id);
	}
	return icon_widget_type_id__volatile;
}



