/*
 * wireless extensions compatibility for cfg80211.
 *
 * Lots of code from the original wireless.c:
 * Copyright 1997-2006	Jean Tourrilhes <jt@hpl.hp.com>
 *
 * Copyright 2006,2007	Johannes Berg <johannes@sipsolutions.net>
 *
 * GPLv2.
 *
 * Theory of operation, so to speak:
 *
 * Commit is done some time after the last parameter was changed
 * (with each parameter change simply (re-)schedule a timer) or
 * if explicitly asked for. This is probably not what most people
 * would expect, but perfectly fine in the WE API.
 *
 * NB: Note that each of the wrappers should check if the cfg80211
 * user provides the command, and for configure() it must also check
 * if that parameter can be set or not via get_config_valid()
 *
 * NB2: It's really bad that we can't report an error from the timer-
 * based commit... Hopefully get_config_valid() can catch everything?
 *
 * see set_essid for an example
 *
 * another question I just thought about.. does wext expect to see
 * the new config even if it wasn't committed... if so, we need to
 * look at the pending config in various _get_ calls...
 */

#include <linux/types.h>
#include <linux/netdevice.h>
#include <linux/rtnetlink.h>
#include <linux/if_arp.h>
#include <linux/etherdevice.h>
#include <linux/wireless.h>
#include <net/netlink.h>
#include <asm/uaccess.h>
#include <net/cfg80211.h>

#include "core.h"
#include "wext.h"

/* internal API: use this function when changing
 * some parameter that needs to be committed */
static void cfg80211_wx_start_commit_timer(int ifindex)
{
	/* TODO:
	 * start a timer associate with this interface
	 * and then when it expires commit the pending
	 * data...
	 * This function must be callable when the timer
	 * is already running, and the timer must
	 * be able to deal with an unassigned
	 * dev->cfg80211_wext_pending_config pointer
	 * as well as taking the rtnl lock (due to wext)! */
}

static struct cfg80211_config *get_pending_cfg(struct net_device *dev)
{
	return &((struct wireless_dev *)dev->ieee80211_ptr)->pending_config;
}

static int cfg80211_wx_set_commit(struct cfg80211_registered_device *drv,
				  struct net_device *net_dev,
				  struct iw_request_info *info,
				  union iwreq_data *data,
				  char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_name(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_nwid(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_nwid(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_freq(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_freq(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_mode(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_mode(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_sens(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_sens(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_range(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_range(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_ap(struct cfg80211_registered_device *drv,
			      struct net_device *net_dev,
			      struct iw_request_info *info,
			      union iwreq_data *data,
			      char *extra)
{
	int err = -EOPNOTSUPP;

	/* TODO: DO SOMETHING */
	/* SIOCSIWAP
	 *   -> if bssid is all-ones: set roaming to kernel, reassociate
	 *   -> if bssid is all-zeroes: set roaming to kernel
	 *   -> otherwise: set roaming to userspace, set bssid
	 */

	return err;
}

static int cfg80211_wx_get_ap(struct cfg80211_registered_device *drv,
			      struct net_device *net_dev,
			      struct iw_request_info *info,
			      union iwreq_data *data,
			      char *extra)
{
	int err = -EOPNOTSUPP;

	/* TODO: DO SOMETHING */
	/* SIOCGIWAP
	 *   -> get association parameters and fill return bssid appropriately
	 */

	return err;
}

static int cfg80211_wx_set_mlme(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_waplist(struct cfg80211_registered_device *drv,
				   struct net_device *net_dev,
				   struct iw_request_info *info,
				   union iwreq_data *data,
				   char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_scan(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_scan(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_essid(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;
	struct cfg80211_config *cfg;

	if (!drv->ops->configure || !drv->ops->get_config_valid)
		goto out;
	if (!(drv->ops->get_config_valid(&drv->wiphy, net_dev)
			& CFG80211_CFG_VALID_SSID))
		goto out;

	cfg = get_pending_cfg(net_dev);

	memcpy(cfg->ssid, extra, data->essid.length);
	cfg->ssid_len = data->essid.length;
	cfg->valid |= CFG80211_CFG_VALID_SSID;

	cfg80211_wx_start_commit_timer(net_dev->ifindex);
	err = 0;
 out:
	return err;
}

static int cfg80211_wx_get_essid(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_rate(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_rate(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_rts(struct cfg80211_registered_device *drv,
			       struct net_device *net_dev,
			       struct iw_request_info *info,
			       union iwreq_data *data,
			       char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_rts(struct cfg80211_registered_device *drv,
			       struct net_device *net_dev,
			       struct iw_request_info *info,
			       union iwreq_data *data,
			       char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_frag(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_frag(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_txpow(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_txpow(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_retry(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_retry(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_encode(struct cfg80211_registered_device *drv,
				  struct net_device *net_dev,
				  struct iw_request_info *info,
				  union iwreq_data *data,
				  char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_encode(struct cfg80211_registered_device *drv,
				  struct net_device *net_dev,
				  struct iw_request_info *info,
				  union iwreq_data *data,
				  char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_power(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_power(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_genie(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_genie(struct cfg80211_registered_device *drv,
				 struct net_device *net_dev,
				 struct iw_request_info *info,
				 union iwreq_data *data,
				 char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_auth(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_auth(struct cfg80211_registered_device *drv,
				struct net_device *net_dev,
				struct iw_request_info *info,
				union iwreq_data *data,
				char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_encodeext(struct cfg80211_registered_device *drv,
				     struct net_device *net_dev,
				     struct iw_request_info *info,
				     union iwreq_data *data,
				     char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_get_encodeext(struct cfg80211_registered_device *drv,
				     struct net_device *net_dev,
				     struct iw_request_info *info,
				     union iwreq_data *data,
				     char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}

static int cfg80211_wx_set_wpmksa(struct cfg80211_registered_device *drv,
				  struct net_device *net_dev,
				  struct iw_request_info *info,
				  union iwreq_data *data,
				  char *extra)
{
	int err = -EOPNOTSUPP;

	return err;
}


typedef int (*iw_compat_handler)(struct cfg80211_registered_device *drv,
				 struct net_device *dev,
				 struct iw_request_info *info,
				 union iwreq_data *wrqu,
				 char *extra);

/* operations array */
#ifdef WX
# undef WX
#endif
#define WX(ioctl)  [(ioctl) - SIOCIWFIRST]
static const iw_compat_handler cfg80211_wx_handlers[] = {
	WX(SIOCSIWCOMMIT)	= cfg80211_wx_set_commit,
	WX(SIOCGIWNAME)		= cfg80211_wx_get_name,
	WX(SIOCSIWNWID)		= cfg80211_wx_set_nwid,
	WX(SIOCGIWNWID)		= cfg80211_wx_get_nwid,
	WX(SIOCSIWFREQ)		= cfg80211_wx_set_freq,
	WX(SIOCGIWFREQ)		= cfg80211_wx_get_freq,
	WX(SIOCSIWMODE)		= cfg80211_wx_set_mode,
	WX(SIOCGIWMODE)		= cfg80211_wx_get_mode,
	WX(SIOCSIWSENS)		= cfg80211_wx_set_sens,
	WX(SIOCGIWSENS)		= cfg80211_wx_get_sens,
	WX(SIOCSIWRANGE)	= cfg80211_wx_set_range,
	WX(SIOCGIWRANGE)	= cfg80211_wx_get_range,
	WX(SIOCSIWAP)		= cfg80211_wx_set_ap,
	WX(SIOCGIWAP)		= cfg80211_wx_get_ap,
	WX(SIOCSIWMLME)		= cfg80211_wx_set_mlme,
	WX(SIOCGIWAPLIST)	= cfg80211_wx_get_waplist,
	WX(SIOCSIWSCAN)		= cfg80211_wx_set_scan,
	WX(SIOCGIWSCAN)		= cfg80211_wx_get_scan,
	WX(SIOCSIWESSID)	= cfg80211_wx_set_essid,
	WX(SIOCGIWESSID)	= cfg80211_wx_get_essid,
	WX(SIOCSIWRATE)		= cfg80211_wx_set_rate,
	WX(SIOCGIWRATE)		= cfg80211_wx_get_rate,
	WX(SIOCSIWRTS)		= cfg80211_wx_set_rts,
	WX(SIOCGIWRTS)		= cfg80211_wx_get_rts,
	WX(SIOCSIWFRAG)		= cfg80211_wx_set_frag,
	WX(SIOCGIWFRAG)		= cfg80211_wx_get_frag,
	WX(SIOCSIWTXPOW)	= cfg80211_wx_set_txpow,
	WX(SIOCGIWTXPOW)	= cfg80211_wx_get_txpow,
	WX(SIOCSIWRETRY)	= cfg80211_wx_set_retry,
	WX(SIOCGIWRETRY)	= cfg80211_wx_get_retry,
	WX(SIOCSIWENCODE)	= cfg80211_wx_set_encode,
	WX(SIOCGIWENCODE)	= cfg80211_wx_get_encode,
	WX(SIOCSIWPOWER)	= cfg80211_wx_set_power,
	WX(SIOCGIWPOWER)	= cfg80211_wx_get_power,
	WX(SIOCSIWGENIE)	= cfg80211_wx_set_genie,
	WX(SIOCGIWGENIE)	= cfg80211_wx_get_genie,
	WX(SIOCSIWAUTH)		= cfg80211_wx_set_auth,
	WX(SIOCGIWAUTH)		= cfg80211_wx_get_auth,
	WX(SIOCSIWENCODEEXT)	= cfg80211_wx_set_encodeext,
	WX(SIOCGIWENCODEEXT)	= cfg80211_wx_get_encodeext,
	WX(SIOCSIWPMKSA)	= cfg80211_wx_set_wpmksa,
};

/* dummy so I didn't have to change that much code... */
static iw_compat_handler get_handler(unsigned int cmd)
{
	int idx = cmd - SIOCIWFIRST;
	if (idx < ARRAY_SIZE(cfg80211_wx_handlers))
		return cfg80211_wx_handlers[idx];
	return NULL;
}

/*
 * this is sort of backwards and wouldn't need to call
 * get_wireless_stats, but it was easier to just copy the code...
 */
static int iw_handler_get_iwstats(struct cfg80211_registered_device *drv,
				  struct net_device *dev,
				  struct iw_request_info *info,
				  union iwreq_data *wrqu,
				  char *extra)
{
	/* Get stats from the driver */
	struct iw_statistics stats_buf;
	struct iw_statistics *stats;

	stats = get_wireless_stats(dev, &stats_buf);
	if (stats != (struct iw_statistics *) NULL) {

		/* Copy statistics to extra */
		memcpy(extra, stats, sizeof(struct iw_statistics));
		wrqu->data.length = sizeof(struct iw_statistics);

		/* Check if we need to clear the updated flag */
		if(wrqu->data.flags != 0)
			stats->qual.updated &= ~IW_QUAL_ALL_UPDATED;
		return 0;
	} else
		return -EOPNOTSUPP;
}

/*
 * Wrapper to call a standard Wireless Extension handler.
 * We do various checks and also take care of moving data between
 * user space and kernel space.
 */
static int ioctl_standard_call(struct cfg80211_registered_device *drv,
			       struct net_device *dev,
			       struct ifreq *ifr,
			       unsigned int cmd,
			       iw_compat_handler handler)
{
	struct iwreq *				iwr = (struct iwreq *) ifr;
	const struct iw_ioctl_description *	descr;
	struct iw_request_info			info;
	int					ret = -EINVAL;

	/* Get the description of the IOCTL */
	if((cmd - SIOCIWFIRST) >= wext_standard_ioctl_num)
		return -EOPNOTSUPP;
	descr = &(wext_standard_ioctl[cmd - SIOCIWFIRST]);

	/* Prepare the call */
	info.cmd = cmd;
	info.flags = 0;

	/* Check if we have a pointer to user space data or not */
	if(descr->header_type != IW_HEADER_TYPE_POINT) {

		/* No extra arguments. Trivial to handle */
		ret = handler(drv, dev, &info, &(iwr->u), NULL);

		/* Generate an event to notify listeners of the change */
		if((descr->flags & IW_DESCR_FLAG_EVENT) &&
		   ((ret == 0) || (ret == -EIWCOMMIT)))
			wireless_send_event(dev, cmd, &(iwr->u), NULL);
	} else {
		char *	extra;
		int	extra_size;
		int	user_length = 0;
		int	err;

		/* Calculate space needed by arguments. Always allocate
		 * for max space. Easier, and won't last long... */
		extra_size = descr->max_tokens * descr->token_size;

		/* Check what user space is giving us */
		if(IW_IS_SET(cmd)) {
			/* Check NULL pointer */
			if((iwr->u.data.pointer == NULL) &&
			   (iwr->u.data.length != 0))
				return -EFAULT;
			/* Check if number of token fits within bounds */
			if(iwr->u.data.length > descr->max_tokens)
				return -E2BIG;
			if(iwr->u.data.length < descr->min_tokens)
				return -EINVAL;
		} else {
			/* Check NULL pointer */
			if(iwr->u.data.pointer == NULL)
				return -EFAULT;
			/* Save user space buffer size for checking */
			user_length = iwr->u.data.length;

			/* Don't check if user_length > max to allow forward
			 * compatibility. The test user_length < min is
			 * implied by the test at the end. */

			/* Support for very large requests */
			if((descr->flags & IW_DESCR_FLAG_NOMAX) &&
			   (user_length > descr->max_tokens)) {
				/* Allow userspace to GET more than max so
				 * we can support any size GET requests.
				 * There is still a limit : -ENOMEM. */
				extra_size = user_length * descr->token_size;
				/* Note : user_length is originally a __u16,
				 * and token_size is controlled by us,
				 * so extra_size won't get negative and
				 * won't overflow... */
			}
		}

		/* Create the kernel buffer */
		extra = kmalloc(extra_size, GFP_KERNEL);
		if (extra == NULL) {
			return -ENOMEM;
		}

		/* If it is a SET, get all the extra data in here */
		if(IW_IS_SET(cmd) && (iwr->u.data.length != 0)) {
			err = copy_from_user(extra, iwr->u.data.pointer,
					     iwr->u.data.length *
					     descr->token_size);
			if (err) {
				kfree(extra);
				return -EFAULT;
			}
		}

		/* Call the handler */
		ret = handler(drv, dev, &info, &(iwr->u), extra);

		/* If we have something to return to the user */
		if (!ret && IW_IS_GET(cmd)) {
			/* Check if there is enough buffer up there */
			if(user_length < iwr->u.data.length) {
				kfree(extra);
				return -E2BIG;
			}

			err = copy_to_user(iwr->u.data.pointer, extra,
					   iwr->u.data.length *
					   descr->token_size);
			if (err)
				ret =  -EFAULT;
		}

		/* Generate an event to notify listeners of the change */
		if((descr->flags & IW_DESCR_FLAG_EVENT) &&
		   ((ret == 0) || (ret == -EIWCOMMIT))) {
			if(descr->flags & IW_DESCR_FLAG_RESTRICT)
				/* If the event is restricted, don't
				 * export the payload */
				wireless_send_event(dev, cmd, &(iwr->u), NULL);
			else
				wireless_send_event(dev, cmd, &(iwr->u),
						    extra);
		}

		/* Cleanup - I told you it wasn't that long ;-) */
		kfree(extra);
	}

	return ret;
}

/* and finally the ioctl wrapper */
int cfg80211_wext_ioctl(struct ifreq *ifr, unsigned int cmd)
{
	struct net_device *dev;
	iw_compat_handler handler;
	struct cfg80211_registered_device *drv;
	int err;

	/* Permissions are already checked in dev_ioctl() before calling us.
	 * The copy_to/from_user() of ifr is also dealt with in there */

	dev = dev_get_by_name(ifr->ifr_name);
	if (!dev)
		return -ENODEV;

	drv = cfg80211_get_dev_from_ifindex(dev->ifindex);
	if (IS_ERR(drv)) {
		err = PTR_ERR(drv);
		goto out_put_dev;
	}

	/* A bunch of special cases, then the generic case...
	 * Note that 'cmd' is already filtered in dev_ioctl() with
	 * (cmd >= SIOCIWFIRST && cmd <= SIOCIWLAST) */
	switch(cmd) {
		case SIOCGIWSTATS:
			/* Get Wireless Stats */
			err = ioctl_standard_call(drv, dev, ifr, cmd,
						  &iw_handler_get_iwstats);
			break;
		case SIOCGIWPRIV:
			err = -EOPNOTSUPP;
			break;
		default:
			handler = get_handler(cmd);
			if(cmd < SIOCIWFIRSTPRIV && handler != NULL)
				err = ioctl_standard_call(drv, dev, ifr, cmd,
							  handler);
			else
				err = -EOPNOTSUPP;
	}

	cfg80211_put_dev(drv);
 out_put_dev:
	dev_put(dev);
	return err;
}
