/*
 * mac80211 configuration hooks for cfg80211
 *
 * Copyright 2006	Johannes Berg <johannes@sipsolutions.net>
 *
 * This file is GPLv2 as found in COPYING.
 */

#include <linux/nl80211.h>
#include <linux/rtnetlink.h>
#include <net/cfg80211.h>
#include "ieee80211_i.h"
#include "ieee80211_cfg.h"

/* copied from ieee80211_sysfs.c for now ... */
static inline int rtnl_lock_local(struct ieee80211_local *local)
{
	rtnl_lock();
	if (unlikely(local->reg_state != IEEE80211_DEV_REGISTERED)) {
		rtnl_unlock();
		return -ENODEV;
	}
	return 0;
}


static int ieee80211_add_iface(struct wiphy *wiphy, char *name,
			       unsigned int type)
{
	struct ieee80211_local *local = wiphy_priv(wiphy);
	struct net_device *new_dev;
	int res, itype;

	switch (type) {
	case NL80211_IFTYPE_UNSPECIFIED:
		itype = IEEE80211_IF_TYPE_STA;
		break;
	case NL80211_IFTYPE_ADHOC:
		itype = IEEE80211_IF_TYPE_IBSS;
		break;
	case NL80211_IFTYPE_STATION:
		itype = IEEE80211_IF_TYPE_STA;
		break;
	case NL80211_IFTYPE_AP:
		itype = IEEE80211_IF_TYPE_AP;
		break;
	case NL80211_IFTYPE_WDS:
		itype = IEEE80211_IF_TYPE_WDS;
		break;
	case NL80211_IFTYPE_MONITOR:
		itype = IEEE80211_IF_TYPE_MNTR;
		break;
	default:
		return -EINVAL;
	}

	res = rtnl_lock_local(local);
	if (res)
		return res;

	res = ieee80211_if_add(local->mdev, name, 0, &new_dev);
	if (res == 0)
		ieee80211_if_set_type(new_dev, itype);
	rtnl_unlock();
	return res;
}

static int ieee80211_del_iface(struct wiphy *wiphy, int ifindex)
{
	struct ieee80211_local *local = wiphy_priv(wiphy);
	int res;
	struct net_device *dev;
	char *name;

	res = rtnl_lock_local(local);
	if (res)
		return res;
	dev = dev_get_by_index(ifindex);
	name = dev->name;
	dev_put(dev);

	res = ieee80211_if_remove(local->mdev, name, -1);
	rtnl_unlock();
	return res;
}

struct cfg80211_ops mac80211_config_ops = {
	.add_virtual_intf = ieee80211_add_iface,
	.del_virtual_intf = ieee80211_del_iface,
};
