/*
 *  libata-acpi.h - helper library for ATA ACPI drivers
 *
 *  Copyright 2007 Red Hat, Inc.  All rights reserved.
 *  Copyright 2007 Alan Cox
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  libata documentation is available via 'make {ps|pdf}docs',
 *  as Documentation/DocBook/libata.*
 *
 */

#ifndef __LIBATA_ACPI_H__
#define __LIBATA_ACPI_H__

struct acpi_drive
{
	u32 pio;
	u32 dma;
};

struct acpi_gtm {
	struct acpi_drive drive[2];
	u32 flags;
};

#ifdef CONFIG_SATA_ACPI
struct ata_acpi_port_link {
	int is_pata;
	acpi_handle *handle;
	acpi_integer devfn;
};

extern int ata_acpi_exec_tfs(struct ata_port *ap);
extern int ata_acpi_push_id(struct ata_port *ap, unsigned int ix);
extern int ata_acpi_gtm(const struct ata_port *p, struct acpi_gtm *gtm);
extern int ata_acpi_stm(const struct ata_port *ap, struct acpi_gtm *stm);
extern void *ata_pata_acpi_handle(const struct ata_port *ap);
extern int ata_pata_acpi_present(struct pci_dev *pdev);
extern void ata_acpi_setup(struct ata_port *ap);
#else
static inline int ata_acpi_exec_tfs(struct ata_port *ap)
{
        return 0;
}
static inline int ata_acpi_push_id(struct ata_port *ap, unsigned int ix)
{
        return 0;
}
extern inline int ata_acpi_gtm(const struct ata_port *p, struct acpi_gtm *gtm)
{
	return 0;
}
extern inline int ata_acpi_stm(const struct ata_port *ap, struct acpi_gtm *stm)
{
	return 0;
}
extern inline void *ata_pata_acpi_handle(const struct ata_port *ap)
{
	return 0;
}
extern inline int ata_pata_acpi_present(struct pci_dev *pdev)
{
	return 0;
}
extern inline void ata_acpi_setup(struct ata_port *ap)
{
	return;
}
#endif /* CONFIG_SATA_ACPI */
#endif
