#!/bin/sh -e

set -x 

# Idea borrowed from RedHat's kernel package

if [ ! -d "$1" ]; then
	echo "$1" does not exist, or is not a directory.
	exit 1
fi
root=$1

if [ ! -f "$2" ]; then
	echo "$2" does not exist, or is not a file.
	exit 1
fi
list=$2
list_members=$(cat $list)

top=$(pwd)

# set -ex

cd "$root/usr/include"
mkdir asm

test -d i486-linux/asm
test -d i486-linux/asm-generic
if test -d i486-linux-input; then
	echo "x86_64-linux-input exists; remove it to continue."
	exit 1
fi

mv i486-linux i486-linux-input
mkdir i486-linux
mv i486-linux-input/asm i486-linux/asm

echo 'if [ install = "$1"  ]; then' > $top/debian/create-diversions
echo 'if [ remove = "$1"  ]; then' > $top/debian/remove-diversions
rm -f $top/debian/dirnames.tmp || true

# Some asm files are generated and point to the corresponding
# file in i486-linux/asm or renamed in asm.

for h in `( ls i486-linux-input/asm; ls i486-linux/asm-generic ) | grep '\.h$' | sort -u`; do
	name=`echo $h | tr a-z. A-Z_`
	# common header
	cat > asm/$h << EOF
#ifndef __IA32STUB_ASM_${name}__
#define __IA32STUB_ASM_${name}__

EOF

	# common for i386 and amd64
	if [ -f i486-linux-input/asm/$h -a -f i486-linux/asm/$h ]; then
		cat >> asm/$h <<EOF
#ifdef __i486__
#include <i486-linux/asm/$h>
#else
#include <asm-i386/$h>
#endif
EOF

	# i386 only
	elif [ -f i486-linux-input/asm/$h ]; then
		cat >> asm/$h <<EOF
#ifndef __i486__
#include <asm-i386/$h>
#endif
EOF
	# amd64 only
	else
		cat >> asm/$h <<EOF
#ifdef __i486__
#include <i486-linux/asm/$h>
#endif
EOF
	fi

	# common footer
	cat >> asm/$h <<EOF

#endif /* !__IA32STUB_ASM_${name}__ */
EOF

	if test -f i486-linux-input/asm-generic/$h; then
		echo "dpkg-divert --divert /usr/include/asm-x86_64/$h --quiet --rename --package ia32-libs-dev --add /usr/include/asm/$h" >> $top/debian/create-diversions
		echo "dpkg-divert --divert /usr/include/asm-x86_64/$h --quiet --rename --package ia32-libs-dev --remove /usr/include/asm/$h" >> $top/debian/remove-diversions
		echo $(dirname /usr/include/asm-i386/$h) >> $top/debian/dirnames.tmp
	fi
done

for h in $list_members; do
	name=`echo $h | tr a-z./ A-Z__`
	mkdir -p $(dirname $h)			# For the wrapper
	mkdir -p $(dirname i486-linux/$h)	# For our copy
	newname=i486-linux/$h
	cat > $h << EOF
#ifndef __IA32STUB__${name}__
#define __IA32STUB__${name}__

#ifdef __x86_64__
#include <x86_64-linux/$h>
#else
#include <$newname>
#endif

#endif /* !__IA32STUB__${name}__ */
EOF

	mv i486-linux-input/$h i486-linux/$h
	echo "dpkg-divert --divert /usr/include/$newname --quiet --rename --package amd64-libs-dev --add /usr/include/$h" >> $top/debian/create-diversions
	echo "dpkg-divert --divert /usr/include/$newname --quiet --rename --package amd64-libs-dev --remove /usr/include/$h" >> $top/debian/remove-diversions
	echo $(dirname /usr/include/$newname) >> $top/debian/dirnames.tmp
done

for dir in $(sort $top/debian/dirnames.tmp | uniq); do
	echo "mkdir -p $dir" >> $top/debian/create-diversions.a
	echo "rmdir --parents --ignore-fail-on-non-empty $dir || true" >> $top/debian/remove-diversions
done
cat $top/debian/create-diversions.a $top/debian/create-diversions > $top/debian/create-diversions.b
rm -f $top/debian/create-diversions.a
mv -f $top/debian/create-diversions.b $top/debian/create-diversions
rm -f $top/debian/dirnames.tmp

echo fi >> $top/debian/create-diversions
echo fi >> $top/debian/remove-diversions
