# 사전 데이터 관리

## 국립국어원 사전

- 국립국어원의 한국어기초사전, 표준국어대사전은 다운로드한 XML을 편집 가능한
  형태로 저장해 관리됩니다.

- 가져오기 스크립트를 통해 국립국어원 데이터를 가져와 기록합니다. 이 가져온
  부분은 수동으로 수정하지 않습니다. 만약 원본에서 필요한 정보가 더 있다면
  가져오기 코드를 수정하고, 원본 데이터에 오류가 있다면 가져오는 과정이나
  아니면 재처리하는 과정에서 보완하거나 추가적인 정보를 서술하는 방법으로
  피해갑니다.

- 국립국어원 사전에서 모든 내용을 가져올 필요는 없습니다. 맞춤법 검사에서
  명백히 의미가 없는 정보는 (단어가 아닌 구, 속담 정보 항목. 한국어기초사전의
  다국어 정보) 가져오지 않습니다. 하지만 당장 hunspell 사전에 사용하지
  않더라도 사람이 편집할 때 원본 XML을 참고하지 않아도 되도록 많은 정보를
  가져옵니다. (예: 단어 설명, 단어 관계, 예문)

- FIXME: 유추할 수 있는 정보

## 수동 편집

- 수동으로 추가하는 단어는 최소화하고 가능한한 국립국어원 사전 항목을
  사용합니다. 국립국어원 사전의 편집 방향 때문에 누락된 단어 (고유 명사 등),
  명백히 누락된 단어, 구현의 기술적인 어려움 등 때문에 새로운 단어를 추가할 수
  있지만 표준어 규정에 어긋난 단어를 추가하지는 않습니다.

- FIXME: verify

## 파일의 구조

- 한 폴더의 파일 개수가 너무 많아지지 않도록 저장합니다.
  entries/<첫음절받침제외>/<표제어>_<품사>_<일련번호>.json

- "imports" 아래에는 스크립트를 통해 외부에서 가져온 데이터가 들어 있습니다.

- "processed" 아래에는 스크립트를 통해 "imports" 부분에 들어 있는 단어
  데이터나 다른 단어 사이의 관계를 통해 알아낸 정보가 들어 있습니다.

- 기타 영역은 수동으로 편집이 가능합니다.


```
imported:
  한국어기초사전:
    ID: 123456
    표제어: 단어
    품사: 명사
    ...
processed:
  사전:
    원본: 한국어기초사전
    원본 라이선스: CC-BY-SA 2.0 KR
```
