/* Copyright (C) 2000-2007 by George Williams */
/*
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.

 * The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "pfaeditui.h"
#ifdef FONTFORGE_CONFIG_GDRAW

static GClut magnify0_clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static uint8 magnify0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfa, 0x2, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfb, 0xde, 0xff, 
    0xfd, 0xdd, 0xff, 
    0xfc, 0xf9, 0xff, 
    0xff, 0x6, 0xff, 
    0xff, 0xff, 0x7f, 
    0xff, 0xff, 0xbf, 
    0xff, 0xff, 0xdf, 
    0xff, 0xff, 0xef, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage magnify0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) magnify0_data,
    &magnify0_clut,
    1
};

static uint8 pointer0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x7f, 0xff, 
    0xff, 0x3f, 0xff, 
    0xff, 0x1f, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x7, 0xff, 
    0xff, 0x3, 0xff, 
    0xff, 0xf, 0xff, 
    0xff, 0x4f, 0xff, 
    0xff, 0x67, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf3, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xf9, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xfc, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage pointer0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) pointer0_data,
    &magnify0_clut,
    1
};

static uint8 ruler0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xff, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdf, 0xef, 0xf7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xdb, 0x6d, 0xb7, 
    0xc0, 0x0, 0x7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage ruler0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) ruler0_data,
    &magnify0_clut,
    1
};

static uint8 knife0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xf1, 0xff, 0xdf, 
    0xfe, 0x3f, 0xdf, 
    0xff, 0xc7, 0xc1, 
    0xff, 0xf8, 0xdf, 
    0xff, 0xff, 0x1f, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage knife0_base = {
    it_mono,
    2080,24,24,3,
    (uint8 *) knife0_data,
    &magnify0_clut,
    1
};

static uint8 corner0_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static GClut corner0_clut = { 3, 0, 2,
    0x0, 0xff0000, 0xc0c0c0 };

static struct _GImage corner0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) corner0_data,
    &corner0_clut,
    2
};

static uint8 curve0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage curve0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) curve0_data,
    &corner0_clut,
    2
};

static uint8 hvcurve0_data[] = {
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
    0x3, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x3, 
    0x3, 0x3, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3
};

static GClut hvcurve0_clut = { 5, 0, 0,
    0x0, 0x7f7f7f, 0x0, 0xc0c0c0, 0xff0000 };

static struct _GImage hvcurve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) hvcurve0_data,
    &hvcurve0_clut,
    3
};

static uint8 tangent0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static uint8 corner1_data[] = {
    0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage corner1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) corner1_data,
    &corner0_clut,
    2
};

static uint8 curve1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage curve1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) curve1_data,
    &corner0_clut,
    2
};

static uint8 hvcurve1_data[] = {
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x1, 0x1, 0x1, 0x1, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x4, 0x2, 0x4, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x2, 0x4, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x2, 0x4, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
};

static struct _GImage hvcurve1_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) hvcurve1_data,
    &hvcurve0_clut,
    3
};

static uint8 tangent1_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
};

static struct _GImage tangent1_base = {
    it_index,
    2080,16,16,16,
    (uint8 *) tangent1_data,
    &corner0_clut,
    2
};

static struct _GImage tangent0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) tangent0_data,
    &corner0_clut,
    2
};

static uint8 spirocorner0_data[] = {
    0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x1, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x3, 0x1, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
    0x2, 0x3, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x1, 0x2, 
	0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x2, 0x1, 
	0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x1, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x1, 0x4, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x4, 0x4, 0x1, 0x4, 0x4, 0x2, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x3, 0x3, 0x1, 0x3, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static GClut spirocorner0_clut = { 5, 1, 0,
    0xffffff, 0x0, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage spirocorner0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirocorner0_data,
    &spirocorner0_clut,
    2
};

static uint8 spirocurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spirocurve0_clut = { 5, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 };

static struct _GImage spirocurve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirocurve0_data,
    &spirocurve0_clut,
    1
};

static uint8 spirog2curve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spirog2curve0_clut = { 5, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 };

static struct _GImage spirog2curve0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirog2curve0_data,
    &spirog2curve0_clut,
    1
};

static uint8 spiroright0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spiroright0_clut = { 4, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage spiroright0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroright0_data,
    &spiroright0_clut,
    1
};

static uint8 spiroleft0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut spiroleft0_clut = { 4, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage spiroleft0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroleft0_data,
    &spiroleft0_clut,
    1
};

static uint8 spirodisabled0_data[] = {
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 
	0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x3, 
	0x1, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x3, 0x1, 0x3, 0x1, 0x2, 0x3, 0x2, 0x3, 
	0x1, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x3, 0x1, 
	0x3, 0x2, 0x1, 0x3, 0x3, 0x2, 0x1, 0x3, 
	0x2, 0x3, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 0x3, 0x2, 
	0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 0x3, 0x1, 
	0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 0x3, 
	0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 
	0x3, 0x2, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 0x1, 
	0x3, 0x2, 0x1, 0x2, 0x1, 0x2, 0x2, 0x3, 
	0x2, 0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x2, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 
	0x1, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
	0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
	0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2
};

static GClut spirodisabled0_clut = { 4, 0, 0,
    0x0, 0x9e9e9e, 0xffffff, 0x0 };

static struct _GImage spirodisabled0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirodisabled0_data,
    &spirodisabled0_clut,
    -1
};
static uint8 spirodown0_data[] = {
    0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 
    0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3
};

static GClut spirodown0_clut = { 5, 0, 0,
    0x0, 0xbbbbbb, 0x5b5b5b, 0x0, 0xe2e2e2 };

static struct _GImage spirodown0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spirodown0_data,
    &spirodown0_clut,
    1
};

static uint8 spiroup0_data[] = {
    0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x3, 0x1, 0x1, 0x3, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x3, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 
    0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 
    0x3, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x3
};

static GClut spiroup0_clut = { 5, 0, 0,
    0x0, 0xbbbbbb, 0xe2e2e2, 0x0, 0x5b5b5b };

static struct _GImage spiroup0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) spiroup0_data,
    &spiroup0_clut,
    1
};

static uint8 rotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x3, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut rotate0_clut = { 6, 0, 0,
    0xc0c0c0, 0xff0000, 0x0, 0x00ff00, 0x0000ff, 0x4040ff };

static struct _GImage rotate0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) rotate0_data,
    &rotate0_clut,
    0
};


static uint8 skew0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage skew0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) skew0_data,
    &rotate0_clut,
    0
};


static uint8 flip0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage flip0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) flip0_data,
    &rotate0_clut,
    0
};


static uint8 scale0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage scale0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) scale0_data,
    &rotate0_clut,
    0
};

static uint8 rotate3d0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 0x2, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage rotate3d0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) rotate3d0_data,
    &rotate0_clut,
    0
};


static uint8 perspective0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x3, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 
	0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x3, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, 
	0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x1, 0x3, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
	0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x0, 
	0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x4, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x4, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage perspective0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) perspective0_data,
    &rotate0_clut,
    0
};


static uint8 pen0_data[] = {
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x4, 0x4, 0x4, 0x4, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 
	0x4, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x5, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 
	0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x2, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage pen0_base = {
    it_index,
    2080,24,24,24,
    (uint8 *) pen0_data,
    &rotate0_clut,
    0
};

static uint8 beveljoin0_data[] = {
    0xff, 0xff, 
    0xfe, 0x0, 
    0xfd, 0xff, 
    0xfb, 0xff, 
    0xf7, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage beveljoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) beveljoin0_data,
    &magnify0_clut,
    1
};


static uint8 buttcap0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage buttcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) buttcap0_data,
    &magnify0_clut,
    1
};


static uint8 miterjoin0_data[] = {
    0xff, 0xff, 
    0x80, 0x0, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage miterjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) miterjoin0_data,
    &magnify0_clut,
    1
};


static uint8 roundcap0_data[] = {
    0xff, 0xff, 
    0xf8, 0x3f, 
    0xe7, 0xcf, 
    0xdf, 0xf7, 
    0xdf, 0xf7, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundcap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundcap0_data,
    &magnify0_clut,
    1
};


static uint8 roundjoin0_data[] = {
    0xff, 0xff, 
    0xf8, 0x0, 
    0xe7, 0xff, 
    0xdf, 0xff, 
    0xdf, 0xff, 
    0xbf, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xaa, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xff, 
    0xbe, 0xff, 
    0xbf, 0xf8, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage roundjoin0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) roundjoin0_data,
    &magnify0_clut,
    1
};


static uint8 squarecap0_data[] = {
    0xff, 0xff, 
    0x80, 0x3, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xbf, 0xfb, 
    0xb6, 0xdb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
    0xbf, 0xfb, 
    0xbe, 0xfb, 
};

static struct _GImage squarecap0_base = {
    it_mono,
    2069,16,16,2,
    (uint8 *) squarecap0_data,
    &magnify0_clut,
    1
};

static uint8 rect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0x80, 0x0, 0x1, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0x80, 0x0, 0x1, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rect0_data,
    &magnify0_clut,
    1
};

static uint8 rrect0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xf0, 0x0, 0xf, 
    0xcf, 0xff, 0xf3, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xcf, 0xff, 0xf3, 
    0xf0, 0x0, 0xf, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage rrect0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) rrect0_data,
    &magnify0_clut,
    1
};


static uint8 elipse0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0x81, 0xff, 
    0xf8, 0x7e, 0x1f, 
    0xe7, 0xff, 0xe7, 
    0xdf, 0xff, 0xfb, 
    0xbf, 0xff, 0xfd, 
    0xbf, 0xff, 0xfd, 
    0xdf, 0xff, 0xfb, 
    0xe7, 0xff, 0xe7, 
    0xf8, 0x7e, 0x1f, 
    0xff, 0x81, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage elipse0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) elipse0_data,
    &magnify0_clut,
    1
};


static uint8 poly0_data[] = {
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0x99, 0xff, 
    0xfe, 0x7e, 0x7f, 
    0xf9, 0xff, 0x9f, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xfb, 0xff, 0xdf, 
    0xf9, 0xff, 0x9f, 
    0xfe, 0x7e, 0x7f, 
    0xff, 0x99, 0xff, 
    0xff, 0xe7, 0xff, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage poly0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) poly0_data,
    &magnify0_clut,
    1
};


static uint8 star0_data[] = {
    0xfd, 0xff, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0x99, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfb, 0xff, 0xdf, 
    0xe7, 0xff, 0xe7, 
    0x9f, 0xff, 0xf9, 
    0x7f, 0xff, 0xfe, 
    0x9f, 0xff, 0xf9, 
    0xe7, 0xff, 0xe7, 
    0xfb, 0xff, 0xdf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xff, 0xbf, 
    0xfd, 0xe7, 0xbf, 
    0xfd, 0x99, 0xbf, 
    0xfc, 0x7e, 0x3f, 
    0xfd, 0xff, 0xab, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
    0xff, 0xff, 0xeb, 
    0xff, 0xff, 0xf7, 
    0xff, 0xff, 0xff, 
};

static struct _GImage star0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) star0_data,
    &magnify0_clut,
    1
};

static uint8 shift0_data[] = {
    0xff, 0xef, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xef, 0xd7, 0xef, 
    0xdf, 0xd7, 0xf7, 
    0x80, 0x0, 0x3, 
    0x7f, 0xd7, 0xfd, 
    0x80, 0x0, 0x3, 
    0xdf, 0xd7, 0xf7, 
    0xef, 0xd7, 0xef, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0x55, 0xff, 
    0xff, 0x93, 0xff, 
    0xff, 0xd7, 0xff, 
    0xff, 0xef, 0xff, 
    0xff, 0xff, 0xff, 
};

static struct _GImage shift0_base = {
    it_mono,
    2069,24,24,3,
    (uint8 *) shift0_data,
    &magnify0_clut,
    1
};


static uint8 pencil0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x1, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x2, 0x2, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut pencil0_clut = { 4, 0, 0,
    0xffffff, 0x0, 0xd0d000, 0xeed0d0 };

static struct _GImage pencil0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) pencil0_data,
    &pencil0_clut,
    0
};


static uint8 freehand0_data[] = {
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x0, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x0, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x2, 0x2, 0x2, 0x1, 0x0, 0x1, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x1, 0x0, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x0, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 0x2, 0x2, 
    0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2
};

static struct _GImage freehand0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &corner0_clut,
    2
};

static GClut greyfree0_clut = { 3, 0, 2,
    0x404040, 0xc00000, 0x808080 };

static struct _GImage greyfree0_base = {
    it_index,
    15420,24,24,24,
    (uint8 *) freehand0_data,
    &greyfree0_clut,
    2
};


static uint8 line0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x1, 0x3, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage line0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) line0_data,
    &pencil0_clut,
    0
};


static uint8 hand0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x1, 
	0x0, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x1, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x1, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x1, 0x3, 0x3, 0x1, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x1, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage hand0_base = {
    it_index,
    2069,24,24,24,
    (uint8 *) hand0_data,
    &pencil0_clut,
    0
};

static uint8 press2ptr0_data[] = {
    0xff, 0xf2, 
    0xef, 0x9c, 
    0xec, 0xf8, 
    0xef, 0xf0, 
    0xff, 0xe0, 
    0x11, 0xc0, 
    0xff, 0xf0, 
    0xef, 0xf2, 
    0xef, 0xe6, 
    0xef, 0xe7, 
};

static struct _GImage press2ptr0_base = {
    it_mono,
    2069,16,10,2,
    (uint8 *) press2ptr0_data,
    &magnify0_clut,
    1
};

GImage GIcon_press2ptr = { 0, &press2ptr0_base };
GImage GIcon_hand = { 0, &hand0_base };
GImage GIcon_line = { 0, &line0_base };
GImage GIcon_pencil = { 0, &pencil0_base };
GImage GIcon_shift = { 0, &shift0_base };
GImage GIcon_star = { 0, &star0_base };
GImage GIcon_poly = { 0, &poly0_base };
GImage GIcon_elipse = { 0, &elipse0_base };
GImage GIcon_rrect = { 0, &rrect0_base };
GImage GIcon_rect = { 0, &rect0_base };
GImage GIcon_squarecap = { 0, &squarecap0_base };
GImage GIcon_roundjoin = { 0, &roundjoin0_base };
GImage GIcon_roundcap = { 0, &roundcap0_base };
GImage GIcon_miterjoin = { 0, &miterjoin0_base };
GImage GIcon_buttcap = { 0, &buttcap0_base };
GImage GIcon_beveljoin = { 0, &beveljoin0_base };
GImage GIcon_freehand = { 0, &freehand0_base };
GImage GIcon_greyfree = { 0, &greyfree0_base };
GImage GIcon_pen = { 0, &pen0_base };
GImage GIcon_knife = { 0, &knife0_base };
GImage GIcon_scale = { 0, &scale0_base };
GImage GIcon_flip = { 0, &flip0_base };
GImage GIcon_skew = { 0, &skew0_base };
GImage GIcon_rotate = { 0, &rotate0_base };
GImage GIcon_3drotate = { 0, &rotate3d0_base };
GImage GIcon_perspective = { 0, &perspective0_base };
GImage GIcon_tangent = { 0, &tangent0_base };
GImage GIcon_curve = { 0, &curve0_base };
GImage GIcon_hvcurve = { 0, &hvcurve0_base };
GImage GIcon_corner = { 0, &corner0_base };
GImage GIcon_spirocorner = { 0, &spirocorner0_base };
GImage GIcon_spirocurve = { 0, &spirocurve0_base };
GImage GIcon_spirog2curve = { 0, &spirog2curve0_base };
GImage GIcon_spiroright = { 0, &spiroright0_base };
GImage GIcon_spiroleft = { 0, &spiroleft0_base };
GImage GIcon_spirodisabled = { 0, &spirodisabled0_base };
GImage GIcon_spiroup = { 0, &spiroup0_base };
GImage GIcon_spirodown = { 0, &spirodown0_base };
GImage GIcon_ruler = { 0, &ruler0_base };
GImage GIcon_pointer = { 0, &pointer0_base };
GImage GIcon_magnify = { 0, &magnify0_base };

GImage GIcon_midtangent = { 0, &tangent1_base };
GImage GIcon_midcurve = { 0, &curve1_base };
GImage GIcon_midhvcurve = { 0, &hvcurve1_base };
GImage GIcon_midcorner = { 0, &corner1_base };

/* Small (16x12) images */

static uint8 smallstar0_data[] = {
    0xf7, 0xef, 
    0xf1, 0x8f, 
    0xf6, 0x6f, 
    0xf7, 0xef, 
    0xef, 0xf7, 
    0x9f, 0xf9, 
    0x7f, 0xfe, 
    0x9f, 0xf9, 
    0xef, 0xf7, 
    0xf7, 0xef, 
    0xf6, 0x6f, 
    0xf1, 0x8f, 
};

static struct _GImage smallstar0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallstar0_data,
    &magnify0_clut,
    1
};

static uint8 smallruler0_data[] = {
    0xff, 0xff, 
    0xef, 0xff, 
    0xdf, 0xff, 
    0x81, 0xfe, 
    0xdd, 0xfe, 
    0xed, 0xfe, 
    0xfd, 0xfe, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfd, 0xb6, 
    0xfc, 0x0, 
    0xff, 0xff, 
};

static struct _GImage smallruler0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallruler0_data,
    &magnify0_clut,
    1
};

static uint8 smallrect0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xc0, 0x3, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xdf, 0xfb, 
    0xc0, 0x3, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallrect0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallrect0_data,
    &magnify0_clut,
    1
};

static uint8 smallelipse0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xfc, 0x3f, 
    0xf3, 0xcf, 
    0xef, 0xf7, 
    0xdf, 0xfb, 
    0xef, 0xf7, 
    0xf3, 0xcf, 
    0xfc, 0x3f, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallelipse0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallelipse0_data,
    &magnify0_clut,
    1
};

static uint8 smallpoly0_data[] = {
    0xff, 0xff, 
    0xfd, 0xff, 
    0xf2, 0x7f, 
    0xef, 0xbf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xdf, 0xdf, 
    0xef, 0xbf, 
    0xf2, 0x7f, 
    0xfd, 0xff, 
};

static struct _GImage smallpoly0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpoly0_data,
    &magnify0_clut,
    1
};

static uint8 smallpointer0_data[] = {
    0xdf, 0xff, 
    0xcf, 0xff, 
    0xc7, 0xff, 
    0xc3, 0xff, 
    0xc1, 0xff, 
    0xc0, 0xff, 
    0xc3, 0xff, 
    0xd9, 0xff, 
    0xf9, 0xff, 
    0xfc, 0xff, 
    0xfc, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpointer0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpointer0_data,
    &magnify0_clut,
    1
};

static uint8 smallpen0_data[] = {
    0xff, 0xff, 
    0xff, 0x1f, 
    0xfc, 0xef, 
    0xe3, 0xf0, 
    0x1f, 0xb7, 
    0x0, 0x57, 
    0x1f, 0xb7, 
    0xe3, 0xf0, 
    0xfc, 0xef, 
    0xff, 0x1f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallpen0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpen0_data,
    &magnify0_clut,
    1
};

static uint8 smallpencil0_data[] = {
    0xc7, 0xff, 
    0xcb, 0xff, 
    0xdd, 0xff, 
    0xee, 0xff, 
    0xf7, 0x7f, 
    0xfb, 0xbf, 
    0xfd, 0xdf, 
    0xfe, 0xef, 
    0xff, 0x67, 
    0xff, 0x9b, 
    0xff, 0xd7, 
    0xff, 0xef, 
};

static struct _GImage smallpencil0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallpencil0_data,
    &magnify0_clut,
    1
};

static uint8 smallknife0_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x0, 0x1, 
    0xc7, 0xef, 
    0xf8, 0xe1, 
    0xff, 0xf, 
    0xff, 0xef, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage smallknife0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallknife0_data,
    &magnify0_clut,
    1
};

static uint8 smallmag0_data[] = {
    0xff, 0xff, 
    0xf1, 0xff, 
    0xee, 0xff, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xdf, 0x7f, 
    0xee, 0xff, 
    0xf1, 0x7f, 
    0xff, 0xbf, 
    0xff, 0xdf, 
    0xff, 0xef, 
    0xff, 0xff, 
};

static struct _GImage smallmag0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallmag0_data,
    &magnify0_clut,
    1
};

static uint8 smallhand0_data[] = {
    0xfe, 0x7f, 
    0xfd, 0xbf, 
    0xed, 0x8f, 
    0xd5, 0xb7, 
    0xd5, 0xb5, 
    0xd9, 0xb2, 
    0xe9, 0xb2, 
    0xed, 0xb6, 
    0x97, 0xfe, 
    0x67, 0xfd, 
    0xb7, 0xfd, 
    0xdf, 0xfd, 
};

static struct _GImage smallhand0_base = {
    it_mono,
    15420,16,12,2,
    (uint8 *) smallhand0_data,
    &magnify0_clut,
    1
};

static uint8 smallcurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static GClut smallcurve0_clut = { 3, 0, 1,
    0x0, 0xb0b0b0, 0xff0000 };

static struct _GImage smallcurve0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcurve0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallhvcurve0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x1, 0x1, 0x1, 
    0x0, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 
	0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallhvcurve0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallhvcurve0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallcorner0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smallcorner0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallcorner0_data,
    &smallcurve0_clut,
    1
};

static uint8 smalltangent0_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x2, 
	0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x1, 0x1, 0x1, 0x0, 0x0, 0x1, 0x1, 0x1, 
	0x2, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x2, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage smalltangent0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smalltangent0_data,
    &smallcurve0_clut,
    1
};

static uint8 smallspirocorner0_data[] = {
    0x2, 0x1, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
    0x2, 0x3, 0x1, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x1, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x1, 0x4, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x4, 0x4, 0x1, 0x4, 0x4, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x3, 0x2, 0x2, 0x3, 0x4, 0x4, 0x1, 0x4, 0x4, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x1, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 0x2, 0x3, 
    0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x3, 
    0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x3, 0x3, 0x1, 0x3, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 
    0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 0x2, 0x3, 0x2, 
};

static GClut smallspirocorner0_clut = { 5, 1, 0,
    0xffffff, 0x0, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage smallspirocorner0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirocorner0_data,
    &smallspirocorner0_clut,
    0x2
};

static uint8 smallspirog2curve0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x3, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x3, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x3, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x3, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x3, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x3, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspirog2curve0_clut = { 5, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 };

static struct _GImage smallspirog2curve0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirog2curve0_data,
    &smallspirog2curve0_clut,
    1
};

static uint8 smallspiroright0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspiroright0_clut = { 4, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage smallspiroright0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspiroright0_data,
    &smallspiroright0_clut,
    1
};

static uint8 smallspiroleft0_data[] = {
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspiroleft0_clut = { 4, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0xff0000 };

static struct _GImage smallspiroleft0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspiroleft0_data,
    &smallspiroleft0_clut,
    0x1
};

static uint8 smallspirocurve0_data[] = {
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x3, 0x3, 0x3, 0x2, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x4, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x2, 0x1, 0x1, 0x4, 0x4, 0x4, 0x4, 0x4, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x3, 0x3, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x4, 0x4, 0x4, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 0x1, 0x2, 
    0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x2, 
    0x1, 0x2, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 
    0x1, 0x1, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 0x1, 0x2, 0x1, 
};

static GClut smallspirocurve0_clut = { 5, 1, 0,
    0xffffff, 0xc0c0c0, 0x808080, 0x0, 0xff0000 };

static struct _GImage smallspirocurve0_base = {
    it_index,
    15420,20,14,20,
    (uint8 *) smallspirocurve0_data,
    &smallspirocurve0_clut,
    1
};

static uint8 smallflip0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x2, 0x0, 
	0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x0, 
	0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallflip0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallflip0_data,
    &rotate0_clut,
    0
};

static uint8 smallrotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x2, 0x3, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 
	0x3, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x3, 0x0, 0x2, 0x0, 0x3, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x3, 0x2, 0x3, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallrotate0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallrotate0_data,
    &rotate0_clut,
    0
};

static uint8 smallscale0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x2, 
	0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x3, 0x3, 0x3, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallscale0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallscale0_data,
    &rotate0_clut,
    0
};

static uint8 smallskew0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x3, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallskew0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallskew0_data,
    &rotate0_clut,
    0
};

static uint8 small3drotate0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage small3drotate0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) small3drotate0_data,
    &rotate0_clut,
    0
};

static uint8 smallperspective0_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x0, 0x3, 0x3, 0x0, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x0, 0x3, 0x0, 0x0, 0x3, 
	0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x3, 0x0, 0x0, 0x0, 0x0, 
	0x3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 
	0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};

static struct _GImage smallperspective0_base = {
    it_index,
    15420,16,12,16,
    (uint8 *) smallperspective0_data,
    &rotate0_clut,
    0
};

static uint8 logo_data[] = {
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x1, 0x2, 0x3, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x0, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0x7, 0x8, 0x9, 0xa, 0xb, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 
    0xc, 0xd, 0xe, 0xf, 0x10, 0x0, 0x11, 0x12, 
	0x13, 0x14, 0x15, 0x16, 0x0, 
    0x0, 0x0, 0x0, 0xf, 0x17, 0x18, 0x19, 0x1a, 
	0x1b, 0x1b, 0x1c, 0x1d, 0x1e, 
    0x1f, 0x20, 0x21, 0x1c, 0x22, 0x1b, 0x1b, 0x1b, 
	0x8, 0x23, 0x24, 0x25, 0x26, 
    0x27, 0x28, 0x29, 0x2a, 0x2a, 0x28, 0x2b, 0x2c, 
	0x2d, 0x2e, 0x2f, 0x30, 0x31, 
    0x32, 0x33, 0x34, 0x35, 0x36, 0x5, 0x5, 0x37, 
	0x2d, 0x38, 0x39, 0x0, 0x0, 
    0x0, 0x0, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f, 
	0x40, 0x40, 0x41, 0x0, 0x0, 
    0x0, 0x0, 0x18, 0x42, 0x43, 0x44, 0x45, 0x43, 
	0x46, 0x47, 0x48, 0x0, 0x0, 
    0x0, 0x0, 0x39, 0x49, 0x4a, 0x4b, 0x22, 0x4c, 
	0x38, 0x20, 0x0, 0x0, 0x0, 
    0x0, 0x0, 0x0, 0x0, 0x4d, 0x4e, 0x1f, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0
};

static GClut logo_clut = { 79, 1, 1,
    0xb0b0b0, 0xa8a8a8, 0x777777, 0xb0b0b0, 0x212121, 0xd0d0d, 0x6f6f6f, 0xb0b0b0, 
    0x525252, 0x3c3c3c, 0x2a2a2a, 0x838383, 0x4c4c4c, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 
    0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 
    0x999999, 0x727272, 0x575757, 0x535353, 0x666666, 0x989898, 0xb0b0b0, 0xb0b0b0, 
    0xb0b0b0, 0x9c9c9c, 0x555555, 0x4d4d4d, 0x3d3d3d, 0x2d2d2d, 0x7f7f7f, 0x818181, 
    0x414141, 0x3f3f3f, 0x424242, 0x3e3e3e, 0x2f2f2f, 0x202020, 0x1c1c1c, 0x626262, 
    0xb0b0b0, 0xb0b0b0, 0xb0b0b0, 0x9b9b9b, 0x4b4b4b, 0x161616, 0xe0e0e, 0x111111, 
    0x9e9e9e, 0xb0b0b0, 0xb0b0b0, 0x494949, 0x1e1e1e, 0x272727, 0x333333, 0x383838, 
    0x373737, 0xacacac, 0x1d1d1d, 0x262626, 0x323232, 0x2b2b2b, 0x252525, 0x2e2e2e, 
    0xafafaf, 0x9f9f9f, 0x444444, 0x474747, 0x707070, 0xb0b0b0, 0xb0b0b0 };

static struct _GImage logo_base = {
    it_index,
    15420,13,13,13,
    (uint8 *) logo_data,
    &logo_clut,
    0
};

static GClut logoback_clut = { 2, 0, 1,
    0x808080, 0xb0b0b0 };

static uint8 logoback_data[] = {
    0xff, 0xff, 
    0xfe, 0x7f, 
    0xe5, 0xbf, 
    0xd9, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0x80, 0x7f, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0xdd, 0xff, 
    0x0, 0x3f, 
    0xff, 0xff, 
};

static struct _GImage logoback_base = {
    it_mono,
    15420,11,13,2,
    (uint8 *) logoback_data,
    &logoback_clut,
    1
};

static uint8 logogrid_data[] = {
    0xbf, 0xff, 
    0x3f, 0xff, 
    0xbf, 0xff, 
    0x9f, 0xff, 
    0xaf, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbd, 0xff, 
    0xbe, 0xff, 
    0x0, 0x1f, 
    0xbf, 0xbf, 
    0xbf, 0xdf, 
    0xbf, 0xff, 
};

static GClut def_clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static struct _GImage logogrid_base = {
    it_mono,
    15420,11,13,2,
    (uint8 *) logogrid_data,
    &def_clut,
    1
};

static uint8 image_data[] = {
    0x00, 0x00,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x7f, 0xfe,
    0x00, 0x00,
};

static struct _GImage def_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &def_clut,
    1
};
static GClut red_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0xff0000 };
static struct _GImage red_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &red_clut,
    COLOR_UNKNOWN
};
static GClut blue_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0x0000ff };
static struct _GImage blue_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &blue_clut,
    COLOR_UNKNOWN
};
static GClut green_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0x00ff00 };
static struct _GImage green_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &green_clut,
    COLOR_UNKNOWN
};
static GClut magenta_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0xff00ff };
static struct _GImage magenta_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &magenta_clut,
    COLOR_UNKNOWN
};
static GClut cyan_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0x00ffff };
static struct _GImage cyan_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &cyan_clut,
    COLOR_UNKNOWN
};
static GClut yellow_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0xffff00 };
static struct _GImage yellow_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &yellow_clut,
    COLOR_UNKNOWN
};
static GClut white_clut = { 2, 0, COLOR_UNKNOWN,
    0x0, 0xffffff };
static struct _GImage white_base = {
    it_mono,
    0,16,12,2,
    (uint8 *) image_data,
    &white_clut,
    COLOR_UNKNOWN
};

GImage def_image = { 0, &def_base };
GImage red_image = { 0, &red_base };
GImage blue_image = { 0, &blue_base };
GImage green_image = { 0, &green_base };
GImage magenta_image = { 0, &magenta_base };
GImage yellow_image = { 0, &yellow_base };
GImage cyan_image = { 0, &cyan_base };
GImage white_image = { 0, &white_base };

static uint8 continue_data[] = {
    0xfe, 0xff, 
    0xff, 0x7f, 
    0xf0, 0x3f, 
    0xef, 0x7f, 
    0xfe, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage continue_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) continue_data,
    &magnify0_clut,
    1
};

static uint8 stepout_data[] = {
    0xfe, 0x1f, 
    0xfd, 0xef, 
    0xfd, 0xc7, 
    0xfd, 0xef, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepout_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepout_data,
    &magnify0_clut,
    1
};

static uint8 stepover_data[] = {
    0xf0, 0x1f, 
    0xef, 0xef, 
    0xef, 0xc7, 
    0xef, 0xef, 
    0xff, 0xff, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0x6f, 0xed, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepover_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepover_data,
    &magnify0_clut,
    1
};

static uint8 stepinto_data[] = {
    0xff, 0xff, 
    0xf3, 0xff, 
    0xed, 0xff, 
    0xed, 0xff, 
    0xfd, 0xff, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0x6d, 0xed, 
    0xf8, 0xff, 
    0xfd, 0xff, 
    0xff, 0xff, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
    0xfd, 0xbf, 
};

static struct _GImage stepinto_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) stepinto_data,
    &magnify0_clut,
    1
};

static uint8 watchpnt_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    0, 0, 3, 3, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 0, 0, 3, 3, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 1, 
    1, 1, 1, 1, 0, 1, 1, 1, 
	1, 1, 1, 2, 2, 2, 1, 1, 
    1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1
};

static GClut watchpnt_clut = { 4, 0, 1,
    0x000000, 0xb0b0b0, 0xff0000, 0x0000ff };

static struct _GImage watchpnt_base = {
    it_index,
    15420,16,16,16,
    (uint8 *) watchpnt_data,
    &watchpnt_clut,
    1
};

static uint8 menudelta_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xe0, 0x3, 
    0xef, 0xfb, 
    0xf7, 0xf7, 
    0xf7, 0xf7, 
    0xfb, 0xef, 
    0xfb, 0xef, 
    0xfd, 0xdf, 
    0xfd, 0xdf, 
    0xfe, 0xbf, 
    0xfe, 0xbf, 
    0xff, 0x7f, 
    0xff, 0x7f, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage menudelta_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) menudelta_data,
    &magnify0_clut,
    1
};

static uint8 exit_data[] = {
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0x8a, 0xa3, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0xbd, 0xb7, 
    0x9d, 0xb7, 
    0xbd, 0xb7, 
    0xba, 0xb7, 
    0xba, 0xb7, 
    0x8a, 0xb7, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage exit_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) exit_data,
    &magnify0_clut,
    1
};

static uint8 stopped_data[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 2, 2, 0, 0, 2, 2, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 0, 
	0, 0, 2, 0, 2, 0, 0, 0, 
	0, 0, 1, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 2, 0, 0, 0, 2, 2, 
	2, 0, 2, 2, 0, 0, 0, 0, 
	0, 1, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0, 1, 1, 
	1, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1
};

static GClut stopped_clut = { 3, 0, 1,
    0xff0000, 0xb0b0b0, 0xffffff };

static struct _GImage stopped_base = {
    it_index,
    15420,36,12,36,
    (uint8 *) stopped_data,
    &stopped_clut,
    1
};

static uint8 stop_data[] = {
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 0, 0, 2, 2, 0, 2, 2, 
	2, 0, 0, 2, 0, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 2, 0, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	2, 0, 1, 
    1, 0, 0, 2, 0, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 2, 
	0, 0, 1, 
    1, 0, 0, 0, 2, 0, 0, 2, 
	0, 0, 2, 0, 2, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 2, 2, 0, 0, 0, 2, 
	0, 0, 0, 2, 0, 0, 2, 0, 
	0, 0, 1, 
    1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 1, 
    1, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 
    1, 1, 1, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	1, 1, 1, 
    1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 1, 
	1, 1, 1
};

static struct _GImage stop_base = {
    it_index,
    15420,19,17,19,
    (uint8 *) stop_data,
    &stopped_clut,
    1
};

static uint8 exclude_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xff, 0x81, 
    0xbe, 0xde, 0xfd, 0xff, 0xbd, 
    0xbe, 0xde, 0x83, 0xff, 0xbd, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3d, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage exclude_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) exclude_data,
    &magnify0_clut,
    1
};

static uint8 intersection_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xff, 0xff, 0xff, 
    0xbf, 0xdf, 0xef, 0xff, 0xff, 
    0xbf, 0xdf, 0xf7, 0xff, 0xff, 
    0xbe, 0x0, 0x83, 0xfc, 0x3f, 
    0xbe, 0xde, 0xfd, 0xfd, 0xbf, 
    0xbe, 0xde, 0x83, 0xfd, 0xbf, 
    0x80, 0x1e, 0xf7, 0xfc, 0x3f, 
    0xfe, 0xfe, 0xef, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0xfe, 0xff, 0xff, 0xff, 
    0xfe, 0x0, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage intersection_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) intersection_data,
    &magnify0_clut,
    1
};

static uint8 rmoverlap_data[] = {
    0xff, 0xff, 0xff, 0xff, 0xff, 
    0x80, 0x1f, 0xff, 0x0, 0x3f, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xff, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xef, 0x7f, 0xbf, 
    0xbf, 0xdf, 0xf7, 0x7f, 0xbf, 
    0xbe, 0x0, 0x83, 0x7f, 0x81, 
    0xbe, 0xde, 0xfd, 0x7f, 0xfd, 
    0xbe, 0xde, 0x83, 0x7f, 0xfd, 
    0x80, 0x1e, 0xf7, 0x1, 0xfd, 
    0xfe, 0xfe, 0xef, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0xfe, 0xff, 0xfd, 0xfd, 
    0xfe, 0x0, 0xff, 0xfc, 0x1, 
    0xff, 0xff, 0xff, 0xff, 0xff, 
};

static struct _GImage rmoverlap_base = {
    it_mono,
    15420,40,16,5,
    (uint8 *) rmoverlap_data,
    &magnify0_clut,
    1
};

static uint8 findinter_data[] = {
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x1, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x2, 0x0, 0x2, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 
	0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x0, 0x2, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1
};

static struct _GImage findinter_base = {
    it_index,
    15420,40,16,40,
    (uint8 *) findinter_data,
    &smallcurve0_clut,
    1
};

static uint8 bold_data[] = {
    0xff, 0xff, 
    0x80, 0x7f, 
    0x80, 0x3f, 
    0x80, 0x1f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x3f, 
    0x80, 0x3f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x8f, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x1f, 
    0x80, 0x3f, 
    0xff, 0xff, 
};

static struct _GImage bold_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) bold_data,
    &magnify0_clut,
    1
};


static uint8 oblique_data[] = {
    0xff, 0xff, 
    0xe0, 0xff, 
    0xf7, 0x7f, 
    0xf7, 0xbf, 
    0xf7, 0xbf, 
    0xef, 0x7f, 
    0xee, 0xff, 
    0xe1, 0xff, 
    0xee, 0xff, 
    0xde, 0xff, 
    0xde, 0xff, 
    0xde, 0xff, 
    0xbd, 0xff, 
    0xbb, 0xff, 
    0x7, 0xff, 
    0xff, 0xff, 
};

static struct _GImage oblique_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) oblique_data,
    &magnify0_clut,
    1
};

static uint8 condense_data[] = {
    0xff, 0xff, 
    0x8f, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xb7, 0xff, 
    0x8f, 0xff, 
    0xb7, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xbb, 0xff, 
    0xb7, 0xff, 
    0x8f, 0xff, 
    0xff, 0xff, 
};

static struct _GImage condense_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) condense_data,
    &magnify0_clut,
    1
};

static uint8 outline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x87, 0xf, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0xf7, 0x7f, 
    0x87, 0xf, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage outline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) outline_data,
    &magnify0_clut,
    1
};

static uint8 inline_data[] = {
    0xff, 0xff, 
    0x80, 0xf, 
    0xbf, 0xef, 
    0xa0, 0x2f, 
    0xbd, 0xef, 
    0x85, 0xf, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0xf5, 0x7f, 
    0x85, 0xf, 
    0xbd, 0xef, 
    0xa0, 0x2f, 
    0xbf, 0xef, 
    0x80, 0xf, 
    0xff, 0xff, 
};

static struct _GImage inline_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) inline_data,
    &magnify0_clut,
    1
};

static uint8 shadow_data[] = {
    0xff, 0xff, 
    0xc0, 0x1f, 
    0xdf, 0xcf, 
    0xc2, 0xf, 
    0xfa, 0xf, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xfa, 0x7f, 
    0xc2, 0x1f, 
    0xdf, 0xcf, 
    0xc0, 0xf, 
    0xe0, 0xf, 
    0xff, 0xff, 
    0xff, 0xff, 
};

static struct _GImage shadow_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) shadow_data,
    &magnify0_clut,
    1
};

static unsigned char wireframe_data[] = {
    0xff, 0xff, 
    0x80, 0x3f, 
    0xbf, 0x9f, 
    0x84, 0x2f, 
    0xf4, 0xd7, 
    0xf5, 0x67, 
    0xf5, 0x87, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0xf5, 0xbf, 
    0x84, 0x3f, 
    0xbf, 0x9f, 
    0x80, 0x2f, 
    0xdf, 0xd7, 
    0xef, 0xe7, 
    0xf0, 0x7, 
};

static struct _GImage wireframe_base = {
    it_mono,
    15420,16,16,2,
    (uint8 *) wireframe_data,
    &magnify0_clut,
    1
};

static uint8 menumark_data[] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 
    0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01
};

static GClut menumark_clut = { 6, 0, 1,
    0x0, 0xb0b0b0, 0xf7f7f7, 0xdddddd, 0x808080, 0x666666 };

static struct _GImage menumark_base = {
    it_index,
    15420,16,10,16,
    (uint8 *) menumark_data,
    &menumark_clut,
    0xffffffff
};

static uint8 upicon0_data[] = {
    0xff, 
    0xef, 
    0xef, 
    0xef, 
    0xd7, 
    0xd7, 
    0xd7, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xff, 
};

static struct _GImage upicon0_base = {
    it_mono,
    15420,7,11,1,
    (uint8 *) upicon0_data,
    &magnify0_clut,
    1
};

static uint8 downicon0_data[] = {
    0xff, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xd7, 
    0xd7, 
    0xd7, 
    0xef, 
    0xef, 
    0xef, 
    0xff, 
};

static struct _GImage downicon0_base = {
    it_mono,
    15420,7,11,1,
    (uint8 *) downicon0_data,
    &magnify0_clut,
    1
};

static uint8 lock0_data[] = {
    0xe0, 0xff, 
    0xdf, 0x7f, 
    0xbf, 0xbf, 
    0xbf, 0xbf, 
    0xbf, 0xbf, 
    0xbf, 0xbf, 
    0xbf, 0xbf, 
    0x0, 0x1f, 
    0x0, 0x1f, 
    0x0, 0x1f, 
    0xe, 0x1f, 
    0xe, 0x1f, 
    0x4, 0x1f, 
    0x4, 0x1f, 
    0x84, 0x3f, 
    0x80, 0x3f, 
    0xc0, 0x7f, 
    0xe0, 0xff, 
};

static struct _GImage lock0_base = {
    it_mono,
    15420,12,18,2,
    (uint8 *) lock0_data,
    &magnify0_clut,
    1
};



GImage GIcon_small3drotate = { 0, &small3drotate0_base };
GImage GIcon_smallperspective = { 0, &smallperspective0_base };
GImage GIcon_smallskew = { 0, &smallskew0_base };
GImage GIcon_smallscale = { 0, &smallscale0_base };
GImage GIcon_smallrotate = { 0, &smallrotate0_base };
GImage GIcon_smallflip = { 0, &smallflip0_base };
GImage GIcon_smalltangent = { 0, &smalltangent0_base };
GImage GIcon_smallcorner = { 0, &smallcorner0_base };
GImage GIcon_smallcurve = { 0, &smallcurve0_base };
GImage GIcon_smallhvcurve = { 0, &smallhvcurve0_base };
GImage GIcon_smallspirocorner = { 0, &smallspirocorner0_base };
GImage GIcon_smallspirog2curve = { 0, &smallspirog2curve0_base };
GImage GIcon_smallspirocurve = { 0, &smallspirocurve0_base };
GImage GIcon_smallspiroright = { 0, &smallspiroright0_base };
GImage GIcon_smallspiroleft = { 0, &smallspiroleft0_base };
GImage GIcon_smallmag = { 0, &smallmag0_base };
GImage GIcon_smallknife = { 0, &smallknife0_base };
GImage GIcon_smallhand = { 0, &smallhand0_base };
GImage GIcon_smallpen = { 0, &smallpen0_base };
GImage GIcon_smallpencil = { 0, &smallpencil0_base };
GImage GIcon_smallpointer = { 0, &smallpointer0_base };
GImage GIcon_smallruler = { 0, &smallruler0_base };
GImage GIcon_smallelipse = { 0, &smallelipse0_base };
GImage GIcon_smallrect = { 0, &smallrect0_base };
GImage GIcon_smallpoly = { 0, &smallpoly0_base };
GImage GIcon_smallstar = { 0, &smallstar0_base };
GImage GIcon_FontForgeLogo = { 0, &logo_base };
GImage GIcon_FontForgeBack = { 0, &logoback_base };
GImage GIcon_FontForgeGuide = { 0, &logogrid_base };

GImage GIcon_continue = { 0, &continue_base };
GImage GIcon_stepout = { 0, &stepout_base };
GImage GIcon_stepover = { 0, &stepover_base };
GImage GIcon_stepinto = { 0, &stepinto_base };
GImage GIcon_watchpnt = { 0, &watchpnt_base };
GImage GIcon_menudelta = { 0, &menudelta_base };
GImage GIcon_exit = { 0, &exit_base };

GImage GIcon_Stopped = { 0, &stopped_base };
GImage GIcon_Stop = { 0, &stop_base };

GImage GIcon_exclude = { 0, &exclude_base };
GImage GIcon_intersection = { 0, &intersection_base };
GImage GIcon_rmoverlap = { 0, &rmoverlap_base };
GImage GIcon_findinter = { 0, &findinter_base };

GImage GIcon_bold = { 0, &bold_base };
GImage GIcon_oblique = { 0, &oblique_base };
GImage GIcon_condense = { 0, &condense_base };
GImage GIcon_outline = { 0, &outline_base };
GImage GIcon_inline = { 0, &inline_base };
GImage GIcon_shadow = { 0, &shadow_base };
GImage GIcon_wireframe = { 0, &wireframe_base };

GImage GIcon_menumark = { 0, &menumark_base };

GImage GIcon_up = { 0, &upicon0_base };
GImage GIcon_down = { 0, &downicon0_base };

GImage GIcon_lock = { 0, &lock0_base };

static uint8 OFL_logo0_data[] = {
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0xb, 0x10, 0x2, 0xe, 0x14, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x5, 0x12, 0x19, 0x17, 0x5, 0x1, 0x17, 
	0x19, 0x19, 0x17, 0x1a, 0x7, 0x19, 0x19, 0x19, 
	0x19, 0x5, 0x17, 0x17, 0x3, 0x3, 0x7, 0x19, 
	0xf, 0x3, 0x3, 0x7, 0x19, 0x19, 0x19, 0x19, 
	0x1a, 0x3, 0x1, 0x17, 0x19, 0xf, 0x3, 0x7, 
	0x19, 0x18, 0x3, 0x5, 0x17, 0x17, 0x17, 0x19, 
	0x19, 0x19, 0x19, 0x19, 0x1, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x13, 0xc, 0xa, 0x1e, 0x1c, 0x11, 
	0xd, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x5, 0x19, 0x1, 0x1a, 0x1b, 0x19, 0x1a, 0x19, 
	0xf, 0x1a, 0x19, 0x16, 0x3, 0x11, 0x18, 0x3, 
	0x17, 0x3, 0xf, 0x11, 0x12, 0x3, 0x3, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x12, 
	0x3, 0x1, 0x19, 0x5, 0x18, 0x1c, 0xf, 0x3, 
	0x11, 0x1c, 0x1a, 0x3, 0xf, 0x19, 0x1b, 0x3, 
	0xf, 0x19, 0x3, 0x19, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x13, 0x1c, 0x14, 0x0, 0x0, 0x14, 0x11, 
	0x1c, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x15, 0x17, 0x3, 0x3, 0x7, 0x11, 0x1a, 0x19, 
	0xf, 0x3, 0x18, 0x1c, 0x3, 0x11, 0x18, 0x3, 
	0x3, 0x3, 0xf, 0x1c, 0x11, 0x7, 0x3, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x17, 0x7, 0x3, 0x3, 0x12, 0x16, 0x3, 
	0x11, 0x1c, 0x1b, 0x3, 0xf, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x2, 0xe, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0xc, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x19, 0xf, 0x3, 0x3, 0x3, 0x11, 0x18, 0x19, 
	0x17, 0x18, 0x17, 0x7, 0x3, 0x11, 0x1b, 0x1c, 
	0x7, 0x3, 0xf, 0x19, 0x12, 0x1c, 0x1a, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x1b, 0x16, 0x18, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x18, 0x11, 0x3, 
	0x11, 0x7, 0x1c, 0x12, 0xf, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x13, 0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0x2, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x19, 0x17, 0x3, 0x3, 0x3, 0x11, 0x1a, 0x19, 
	0x19, 0xf, 0x18, 0x3, 0x3, 0x11, 0x18, 0x3, 
	0x3, 0x3, 0xf, 0x19, 0x3, 0x1b, 0x1b, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x11, 0x7, 0x3, 0x3, 0x18, 0x16, 0x3, 
	0x11, 0x18, 0x7, 0x11, 0x1b, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x10, 0x11, 0x14, 0x0, 0x0, 0x0, 0x0, 0x11, 
	0xa, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x15, 0x1c, 0x5, 0x3, 0x7, 0x17, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 
	0x1, 0x1, 0xf, 0x19, 0x3, 0x1a, 0x1c, 0x11, 
	0x18, 0x3, 0x3, 0x3, 0x11, 0x18, 0x3, 0x3, 
	0x3, 0x17, 0x19, 0x3, 0x3, 0x12, 0x15, 0x3, 
	0x11, 0x18, 0x3, 0x12, 0x11, 0x19, 0x3, 0x3, 
	0xf, 0x19, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xe, 0x11, 0x0, 0x0, 0x0, 0x0, 0x14, 0x11, 
	0x4, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x5, 0x1b, 0x16, 0xf, 0x17, 0x5, 0x5, 0x1b, 
	0x17, 0x1a, 0x3, 0x3, 0x1a, 0x11, 0x17, 0xf, 
	0x19, 0x7, 0x17, 0x16, 0x1a, 0x3, 0x7, 0x11, 
	0x18, 0x3, 0x3, 0x1a, 0x11, 0xf, 0x5, 0x3, 
	0x3, 0x1, 0x1c, 0x19, 0x12, 0x12, 0x3, 0x1a, 
	0x11, 0xf, 0x3, 0x5, 0x1b, 0x19, 0x3, 0x5, 
	0x17, 0x16, 0x1, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0xd, 0xe, 0x2, 0xa, 0xb, 0x0, 0xb, 0x4, 
	0x6, 0x11, 0x4, 0x4, 0x4, 0x1d, 0xd, 0x11, 
	0x14, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x18, 0x1, 0x3, 0x3, 0x1a, 0x18, 
	0x18, 0x5, 0x3, 0x3, 0x1, 0x18, 0x18, 0x18, 
	0x18, 0x5, 0x18, 0x18, 0x5, 0x3, 0x3, 0x1, 
	0x3, 0x3, 0x3, 0x1, 0x18, 0x18, 0x3, 0x3, 
	0x3, 0x3, 0x5, 0x18, 0x1a, 0x3, 0x3, 0x1, 
	0x18, 0x1, 0x3, 0x3, 0x5, 0x1a, 0x3, 0x1a, 
	0x18, 0x18, 0x1a, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x2, 
	0x1e, 0x4, 0x2, 0x11, 0x6, 0xb, 0xd, 0x4, 
	0x11, 0x6, 0x4, 0x1e, 0xc, 0xb, 0x4, 0x11, 
	0x1f, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0xb, 0xc, 0xd, 
	0x0, 0x0, 0x0, 0xe, 0x11, 0x10, 0x0, 0x0, 
	0x11, 0x2, 0x0, 0x0, 0x0, 0x0, 0xe, 0x11, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xc, 0x0, 
	0x0, 0x0, 0x0, 0x13, 0x11, 0xe, 0x0, 0x13, 
	0x11, 0x4, 0x0, 0x0, 0x0, 0x0, 0xc, 0x2, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0xb, 0x11, 0x4, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x11, 0x2, 0x0, 0x14, 
	0x11, 0x4, 0x0, 0x0, 0x0, 0x0, 0x11, 0x1e, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x12, 0x19, 0x7, 0x3, 0x3, 0x1, 0x19, 0x17, 
	0x5, 0x3, 0x18, 0x17, 0x19, 0x17, 0x18, 0x19, 
	0x19, 0x19, 0x19, 0x18, 0x17, 0x17, 0x3, 0x3, 
	0x7, 0x19, 0xf, 0x3, 0x7, 0x19, 0x19, 0x7, 
	0x7, 0x19, 0x19, 0x19, 0x19, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x1d, 0x11, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x11, 0xe, 0x0, 0xd, 
	0x11, 0x1d, 0x0, 0x0, 0x0, 0x13, 0x11, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x3, 0x7, 0x17, 0x5, 0x18, 0x15, 0x3, 0x19, 
	0xf, 0x3, 0xf, 0x1a, 0xf, 0x11, 0x12, 0x3, 
	0x3, 0x11, 0x18, 0x7, 0x1b, 0x3, 0x12, 0x1, 
	0x3, 0x11, 0x18, 0x3, 0x17, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x4, 0x11, 0x14, 0x0, 
	0x0, 0x0, 0x0, 0x1f, 0x11, 0x10, 0x0, 0x4, 
	0x11, 0x14, 0x0, 0x0, 0x0, 0x14, 0x11, 0x1d, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x3, 0x1c, 0x1a, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0xf, 0x1c, 0x11, 0x7, 
	0x3, 0x11, 0x18, 0x15, 0x11, 0xf, 0x5, 0x3, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x4, 0x11, 0xd, 0x0, 
	0x0, 0x0, 0x0, 0xd, 0x11, 0x1f, 0x0, 0x1e, 
	0x11, 0x1f, 0x0, 0x0, 0x0, 0x4, 0x11, 0x14, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0x16, 0x16, 0x12, 0x3, 0xf, 0x19, 0x12, 0x1c, 
	0x1a, 0x11, 0x18, 0x5, 0x17, 0x11, 0x1c, 0x7, 
	0x3, 0x11, 0x1b, 0x1c, 0x7, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x1d, 0x11, 0x1e, 0x0, 
	0x0, 0x0, 0x0, 0x2, 0xa, 0x0, 0x0, 0x2, 
	0x11, 0x0, 0x0, 0x0, 0x0, 0xa, 0x11, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x3, 0x3, 0x19, 0xf, 
	0x18, 0x11, 0x5, 0x3, 0x3, 0x3, 0x3, 0x19, 
	0xf, 0x3, 0x3, 0x3, 0xf, 0x19, 0x3, 0x1b, 
	0x1b, 0x11, 0x18, 0x3, 0x3, 0x1a, 0x1b, 0x1c, 
	0x3, 0x11, 0x18, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0xb, 0x1c, 0x11, 0xd, 
	0x0, 0x0, 0x10, 0xc, 0xb, 0x0, 0x0, 0xc, 
	0x6, 0x0, 0x0, 0x0, 0x0, 0x2, 0x11, 0x0, 
	0x13, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x11, 0x3, 0x3, 0x7, 0x5, 0x19, 0xf, 
	0x5, 0x1c, 0xf, 0x3, 0x3, 0x7, 0x5, 0x19, 
	0xf, 0x3, 0x5, 0x7, 0xf, 0x19, 0x3, 0x1a, 
	0x1c, 0x11, 0x18, 0x7, 0x7, 0x3, 0x18, 0x16, 
	0x3, 0x11, 0x18, 0x3, 0x1, 0x1, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0xd, 0x11, 0x11, 
	0xc, 0xc, 0xa, 0xb, 0x0, 0x0, 0x0, 0x11, 
	0xe, 0x0, 0x0, 0x0, 0x0, 0xe, 0x11, 0x1c, 
	0x10, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x7, 0x11, 0x12, 0xf, 0x16, 0x5, 0x1b, 0x17, 
	0x5, 0x7, 0x11, 0x17, 0x17, 0x12, 0x5, 0x1b, 
	0x1b, 0xf, 0x17, 0x17, 0x17, 0x16, 0x1a, 0x3, 
	0x7, 0x11, 0x18, 0xf, 0x1c, 0x12, 0x19, 0x1, 
	0x1a, 0x11, 0x17, 0xf, 0x19, 0x7, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x10, 
	0x4, 0x1f, 0x0, 0x0, 0x0, 0x0, 0x13, 0x11, 
	0xd, 0x0, 0x0, 0x0, 0x0, 0x13, 0xd, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x18, 0x18, 0x18, 0x18, 0x1, 0x1a, 0x18, 0x18, 
	0x3, 0x3, 0x5, 0x18, 0x1a, 0x3, 0x1a, 0x18, 
	0x18, 0x18, 0x18, 0x1a, 0x18, 0x18, 0x5, 0x3, 
	0x3, 0x1, 0x3, 0x3, 0x1, 0x18, 0x5, 0x3, 
	0x1, 0x18, 0x18, 0x18, 0x18, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x1c, 
	0xb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x4, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0x6, 0xb, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x13, 0x6, 0x13, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0xd, 0x13, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
    0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 
	0x0, 0x0, 0x0, 0x0, 0x8, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 
	0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3
};

static GClut OFL_logo0_clut = { 32, 1, -1,
    0x336699, 0x838383, 0xcdd9e6, 0x666666, 0x99b3cc, 0x707070, 0xe6ecf3, 0x999999, 
    0x4d667f, 0x738da6, 0xa6bcd3, 0x40709f, 0xd9e3ec, 0x80a0bf, 0xc0d0df, 0xb3b3b3, 
    0x8da9c6, 0xffffff, 0xbcbcbc, 0x5983ac, 0x668cb3, 0xa9a9a9, 0xececec, 0xcccccc, 
    0x8c8c8c, 0xd9d9d9, 0x797979, 0xe3e3e3, 0xf6f6f6, 0x7396b9, 0xb3c6d9, 0x4d79a6 };

static struct _GImage OFL_logo0_base = {
    it_index,
    15420,88,31,88,
    (uint8 *) OFL_logo0_data,
    &OFL_logo0_clut,
    0xffffffff
};

GImage OFL_logo = { 0, &OFL_logo0_base };

static GClut clut = { 2, 0, 1,
    0x0, 0xb0b0b0 };

static uint8 rightpointer0_data[] = {
    0xfb, 
    0xf3, 
    0xe3, 
    0xc3, 
    0x83, 
    0x3, 
    0xc3, 
    0xcb, 
    0x9b, 
    0x9f, 
};

static struct _GImage rightpointer0_base = {
    it_mono,
    2081,8,10,1,
    (uint8 *) rightpointer0_data,
    &clut,
    1
};

static uint8 sel2ptr0_data[] = {
    0xff, 0xe5, 
    0xff, 0x39, 
    0xf9, 0xf1, 
    0x8f, 0xe1, 
    0x77, 0xc1, 
    0x77, 0x81, 
    0x77, 0xe1, 
    0x8f, 0xe5, 
    0xff, 0xcd, 
    0xff, 0xcf, 
};

static struct _GImage sel2ptr0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) sel2ptr0_data,
    &clut,
    1
};

static uint8 selectedpoint0_data[] = {
    0xdf, 
    0xef, 
    0xef, 
    0xc7, 
    0xbb, 
    0xbb, 
    0xbb, 
    0xc7, 
    0xef, 
    0xef, 
};

static struct _GImage selectedpoint0_base = {
    it_mono,
    2081,8,10,1,
    (uint8 *) selectedpoint0_data,
    &clut,
    1
};

static uint8 distance0_data[] = {
    0xff, 0xff, 
    0xbf, 0xfe, 
    0xbb, 0xee, 
    0xb7, 0xf6, 
    0xaa, 0xaa, 
    0xb7, 0xf6, 
    0xbb, 0xee, 
    0xbf, 0xfe, 
    0xbf, 0xfe, 
    0xff, 0xff, 
};

static struct _GImage distance0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) distance0_data,
    &clut,
    1
};

static uint8 angle0_data[] = {
    0xff, 0xff, 
    0xff, 0xcf, 
    0xff, 0x9f, 
    0xfe, 0x6f, 
    0xfd, 0xef, 
    0xf3, 0xf7, 
    0xef, 0xf7, 
    0x9f, 0xf7, 
    0x0, 0x1, 
    0xff, 0xff, 
};

static struct _GImage angle0_base = {
    it_mono,
    2081,16,10,2,
    (uint8 *) angle0_data,
    &clut,
    1
};

static uint8 magicon0_data[] = {
    0xc7, 
    0xbb, 
    0x6d, 
    0x45, 
    0x6d, 
    0xbb, 
    0xc3, 
    0xfb, 
    0xfd, 
    0xfd, 
};

static struct _GImage magicon0_base = {
    it_mono,
    2069,8,10,1,
    (uint8 *) magicon0_data,
    &clut,
    1
};

GImage GIcon_mag = { 0, &magicon0_base };
GImage GIcon_angle = { 0, &angle0_base };
GImage GIcon_distance = { 0, &distance0_base };
GImage GIcon_selectedpoint = { 0, &selectedpoint0_base };
GImage GIcon_sel2ptr = { 0, &sel2ptr0_base };
GImage GIcon_rightpointer = { 0, &rightpointer0_base };

void InitToolIconClut(Color bg) {
    if ( bg==0x000000 ) {
	magnify0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	rotate0_clut.clut[2] = 0xffffff;
	pencil0_clut.clut[0] = 0x000000;
	pencil0_clut.clut[1] = 0xffffff;
	smallcurve0_clut.clut[0] = 0xffffff;
	watchpnt_clut.clut[0] = 0xffffff;
	menumark_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	corner0_clut.clut[0] = 0xffffff;
	clut.clut[0] = 0xffffff;
    } else if ( COLOR_GREEN(bg)>COLOR_BLUE(bg) ) {
	rotate0_clut.clut[3] = 0x0000ff;
	rotate0_clut.clut[4] = 0x00ff00;
    }
}
#endif
