/* individual-aggregator.c generated by valac 0.25.3, the Vala compiler
 * generated from individual-aggregator.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 * Copyright (C) 2012, 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/small-set.h>
#include <gio/gio.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>
#include <folks/small-set-internal.h>
#include <config.h>


#define FOLKS_TYPE_INDIVIDUAL_AGGREGATOR (folks_individual_aggregator_get_type ())
#define FOLKS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator))
#define FOLKS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_IS_INDIVIDUAL_AGGREGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR))
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorClass))

typedef struct _FolksIndividualAggregator FolksIndividualAggregator;
typedef struct _FolksIndividualAggregatorClass FolksIndividualAggregatorClass;
typedef struct _FolksIndividualAggregatorPrivate FolksIndividualAggregatorPrivate;

#define FOLKS_TYPE_BACKEND_STORE (folks_backend_store_get_type ())
#define FOLKS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStore))
#define FOLKS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))
#define FOLKS_IS_BACKEND_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_IS_BACKEND_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND_STORE))
#define FOLKS_BACKEND_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND_STORE, FolksBackendStoreClass))

typedef struct _FolksBackendStore FolksBackendStore;
typedef struct _FolksBackendStoreClass FolksBackendStoreClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;

#define FOLKS_TYPE_BACKEND (folks_backend_get_type ())
#define FOLKS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_BACKEND, FolksBackend))
#define FOLKS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_BACKEND, FolksBackendClass))
#define FOLKS_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_BACKEND))
#define FOLKS_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_BACKEND))
#define FOLKS_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_BACKEND, FolksBackendClass))

typedef struct _FolksBackend FolksBackend;
typedef struct _FolksBackendClass FolksBackendClass;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;

#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_TRUST_LEVEL (folks_trust_level_get_type ())

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;
typedef struct _FolksIndividualAggregatorPrepareData FolksIndividualAggregatorPrepareData;
typedef struct _FolksIndividualAggregatorUnprepareData FolksIndividualAggregatorUnprepareData;

#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksIndividualAggregatorAddBackendData FolksIndividualAggregatorAddBackendData;
typedef struct _Block4Data Block4Data;

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())
typedef struct _Block6Data Block6Data;

#define FOLKS_TYPE_ANTI_LINKABLE (folks_anti_linkable_get_type ())
#define FOLKS_ANTI_LINKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable))
#define FOLKS_IS_ANTI_LINKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ANTI_LINKABLE))
#define FOLKS_ANTI_LINKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkableIface))

typedef struct _FolksAntiLinkable FolksAntiLinkable;
typedef struct _FolksAntiLinkableIface FolksAntiLinkableIface;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _FolksIndividualAggregatorAddPersonaFromDetailsData FolksIndividualAggregatorAddPersonaFromDetailsData;
typedef struct _Block8Data Block8Data;
typedef struct _FolksIndividualAggregatorRemoveIndividualData FolksIndividualAggregatorRemoveIndividualData;
typedef struct _FolksIndividualAggregatorRemovePersonaData FolksIndividualAggregatorRemovePersonaData;
typedef struct _FolksIndividualAggregatorLinkPersonasData FolksIndividualAggregatorLinkPersonasData;

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;

#define FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS (folks_web_service_field_details_get_type ())
#define FOLKS_WEB_SERVICE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetails))
#define FOLKS_WEB_SERVICE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetailsClass))
#define FOLKS_IS_WEB_SERVICE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS))
#define FOLKS_IS_WEB_SERVICE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS))
#define FOLKS_WEB_SERVICE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, FolksWebServiceFieldDetailsClass))

typedef struct _FolksWebServiceFieldDetails FolksWebServiceFieldDetails;
typedef struct _FolksWebServiceFieldDetailsClass FolksWebServiceFieldDetailsClass;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_WEB_SERVICE_DETAILS (folks_web_service_details_get_type ())
#define FOLKS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails))
#define FOLKS_IS_WEB_SERVICE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS))
#define FOLKS_WEB_SERVICE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetailsIface))

typedef struct _FolksWebServiceDetails FolksWebServiceDetails;
typedef struct _FolksWebServiceDetailsIface FolksWebServiceDetailsIface;

#define FOLKS_TYPE_LOCAL_ID_DETAILS (folks_local_id_details_get_type ())
#define FOLKS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails))
#define FOLKS_IS_LOCAL_ID_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS))
#define FOLKS_LOCAL_ID_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetailsIface))

typedef struct _FolksLocalIdDetails FolksLocalIdDetails;
typedef struct _FolksLocalIdDetailsIface FolksLocalIdDetailsIface;

#define FOLKS_TYPE_PERSONA_DETAIL (folks_persona_detail_get_type ())
typedef struct _FolksIndividualAggregatorUnlinkIndividualData FolksIndividualAggregatorUnlinkIndividualData;
typedef struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData FolksIndividualAggregatorEnsureIndividualPropertyWriteableData;
typedef struct _FolksIndividualAggregatorEnsurePersonasPropertyWriteableData FolksIndividualAggregatorEnsurePersonasPropertyWriteableData;
typedef struct _FolksIndividualAggregatorLookUpIndividualData FolksIndividualAggregatorLookUpIndividualData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
 * Errors from {@link IndividualAggregator}s.
 */
typedef enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_WRITEABLE_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE,
	FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE
} FolksIndividualAggregatorError;
#define FOLKS_INDIVIDUAL_AGGREGATOR_ERROR folks_individual_aggregator_error_quark ()
struct _FolksIndividualAggregator {
	GObject parent_instance;
	FolksIndividualAggregatorPrivate * priv;
};

struct _FolksIndividualAggregatorClass {
	GObjectClass parent_class;
};

struct _FolksIndividualAggregatorPrivate {
	FolksBackendStore* _backend_store;
	GeeHashMap* _stores;
	FolksPersonaStore* _primary_store;
	FolksSmallSet* _backends;
	GSettings* _primary_store_setting;
	GHashTable* _link_map;
	gboolean _linking_enabled;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	gboolean _prepare_pending;
	FolksDebug* _debug;
	gchar* _configured_primary_store_type_id;
	gchar* _configured_primary_store_id;
	guint _non_quiescent_persona_store_count;
	guint _non_quiescent_backend_count;
	gboolean _is_quiescent;
	guint _quiescent_timeout_id;
	gboolean _user_configured_primary_store;
	GeeMap* _individuals;
	GeeMap* _individuals_ro;
	FolksIndividual* _user;
};

typedef enum  {
	FOLKS_TRUST_LEVEL_NONE,
	FOLKS_TRUST_LEVEL_PERSONAS
} FolksTrustLevel;

struct _FolksIndividualAggregatorPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	FolksBackendStore* _tmp4_;
	GeeCollection* backends;
	FolksBackendStore* _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeIterator* _backend_it;
	GeeCollection* _tmp10_;
	GeeIterator* _tmp11_;
	GeeIterator* _tmp12_;
	gboolean _tmp13_;
	FolksBackend* backend;
	GeeIterator* _tmp14_;
	gpointer _tmp15_;
	FolksBackendStore* _tmp16_;
	FolksBackend* _tmp17_;
	FolksBackendStore* _tmp18_;
	guint _tmp19_;
	gboolean _tmp20_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _p_it;
	GeeHashMap* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	GeeIterator* _tmp11_;
	gboolean _tmp12_;
	FolksPersonaStore* p;
	GeeIterator* _tmp13_;
	gpointer _tmp14_;
	FolksPersonaStore* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GError * _inner_error_;
};

typedef enum  {
	FOLKS_MATCH_RESULT_NONE = -1,
	FOLKS_MATCH_RESULT_VERY_LOW = 0,
	FOLKS_MATCH_RESULT_LOW = 1,
	FOLKS_MATCH_RESULT_MEDIUM = 2,
	FOLKS_MATCH_RESULT_HIGH = 3,
	FOLKS_MATCH_RESULT_VERY_HIGH = 4,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_NONE,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksIndividualAggregatorAddBackendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksBackend* backend;
	FolksSmallSet* _tmp0_;
	FolksBackend* _tmp1_;
	gboolean _tmp2_;
	FolksSmallSet* _tmp3_;
	FolksBackend* _tmp4_;
	FolksBackend* _tmp5_;
	FolksBackend* _tmp6_;
	FolksBackend* _tmp7_;
	FolksPersonaStore** stores;
	FolksBackend* _tmp8_;
	GeeMap* _tmp9_;
	GeeMap* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeCollection* _tmp13_;
	gint _tmp14_;
	gpointer* _tmp15_;
	FolksPersonaStore** _tmp16_;
	gint _tmp16__length1;
	gint stores_length1;
	gint _stores_size_;
	FolksPersonaStore** _tmp17_;
	gint _tmp17__length1;
	FolksPersonaStore** persona_store_collection;
	gint persona_store_collection_length1;
	gint _persona_store_collection_size_;
	gint persona_store_it;
	FolksPersonaStore* _tmp18_;
	FolksPersonaStore* persona_store;
	FolksBackend* _tmp19_;
	FolksPersonaStore* _tmp20_;
};

struct _Block4Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	gchar* store_id;
	FolksPersonaStore* store;
};

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;

struct _Block5Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	GeeHashSet* candidate_inds;
};

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	const gchar* prop_name;
};

typedef void (*FolksPersonaLinkablePropertyCallback) (const gchar* link, void* user_data);
typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksAntiLinkableIface {
	GTypeInterface parent_iface;
	void (*change_anti_links) (FolksAntiLinkable* self, GeeSet* anti_links, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_anti_links_finish) (FolksAntiLinkable* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_anti_links) (FolksAntiLinkable* self);
	void (*set_anti_links) (FolksAntiLinkable* self, GeeSet* value);
};

struct _Block7Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
};

typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE,
	FOLKS_PERSONA_STORE_ERROR_READ_ONLY,
	FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED,
	FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
struct _FolksIndividualAggregatorAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* parent;
	FolksPersonaStore* persona_store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* persona;
	GHashTable* details_copy;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	FolksPersona* _tmp2_;
	FolksPersonaStore* _tmp3_;
	GHashTable* _tmp4_;
	FolksPersona* _tmp5_;
	FolksPersona* _tmp6_;
	GError* e;
	GError* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	gchar* full_id;
	FolksPersonaStore* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksPersonaStore* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	gboolean _tmp23_;
	FolksIndividual* _tmp24_;
	FolksPersona* _tmp25_;
	FolksIndividual* _tmp26_;
	GeeSet* _tmp27_;
	GeeSet* _tmp28_;
	FolksPersona* _tmp29_;
	GError * _inner_error_;
};

struct _Block8Data {
	int _ref_count_;
	FolksIndividualAggregator* self;
	GHashTable* retval;
};

struct _FolksIndividualAggregatorRemoveIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	FolksSmallSet* personas;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	FolksSmallSet* _tmp3_;
	FolksSmallSet* _persona_list;
	FolksSmallSet* _tmp4_;
	FolksSmallSet* _tmp5_;
	gint _persona_size;
	FolksSmallSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _persona_index;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	FolksPersona* persona;
	FolksSmallSet* _tmp12_;
	gint _tmp13_;
	gconstpointer _tmp14_;
	FolksPersona* _tmp15_;
	FolksPersona* _tmp16_;
	FolksPersonaStore* _tmp17_;
	FolksPersonaStore* _tmp18_;
	FolksPersona* _tmp19_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersona* _tmp3_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorLinkPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GeeSet* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gboolean _tmp21_;
	GeeIterator* _p_it;
	GeeSet* _tmp22_;
	GeeIterator* _tmp23_;
	GeeIterator* _tmp24_;
	gboolean _tmp25_;
	FolksPersona* p;
	GeeIterator* _tmp26_;
	gpointer _tmp27_;
	FolksAntiLinkable* al;
	FolksPersona* _tmp28_;
	FolksAntiLinkable* _tmp29_;
	FolksAntiLinkable* _tmp30_;
	FolksAntiLinkable* _tmp31_;
	GeeSet* _tmp32_;
	GError* e;
	const gchar* _tmp33_;
	GError* _tmp34_;
	FolksPersonaStore* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GHashTable* details;
	GeeSet* _tmp39_;
	GHashTable* _tmp40_;
	FolksPersonaStore* _tmp41_;
	GHashTable* _tmp42_;
	FolksPersona* _tmp43_;
	FolksPersona* _tmp44_;
	GError * _inner_error_;
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksWebServiceDetailsIface {
	GTypeInterface parent_iface;
	void (*change_web_service_addresses) (FolksWebServiceDetails* self, GeeMultiMap* web_service_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_web_service_addresses_finish) (FolksWebServiceDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_web_service_addresses) (FolksWebServiceDetails* self);
	void (*set_web_service_addresses) (FolksWebServiceDetails* self, GeeMultiMap* value);
};

struct _FolksLocalIdDetailsIface {
	GTypeInterface parent_iface;
	void (*change_local_ids) (FolksLocalIdDetails* self, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_local_ids_finish) (FolksLocalIdDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_local_ids) (FolksLocalIdDetails* self);
	void (*set_local_ids) (FolksLocalIdDetails* self, GeeSet* value);
};

typedef enum  {
	FOLKS_PERSONA_DETAIL_INVALID = -1,
	FOLKS_PERSONA_DETAIL_ALIAS = 0,
	FOLKS_PERSONA_DETAIL_AVATAR,
	FOLKS_PERSONA_DETAIL_BIRTHDAY,
	FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_FULL_NAME,
	FOLKS_PERSONA_DETAIL_GENDER,
	FOLKS_PERSONA_DETAIL_IM_ADDRESSES,
	FOLKS_PERSONA_DETAIL_IS_FAVOURITE,
	FOLKS_PERSONA_DETAIL_LOCAL_IDS,
	FOLKS_PERSONA_DETAIL_LOCATION,
	FOLKS_PERSONA_DETAIL_NICKNAME,
	FOLKS_PERSONA_DETAIL_NOTES,
	FOLKS_PERSONA_DETAIL_PHONE_NUMBERS,
	FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_ROLES,
	FOLKS_PERSONA_DETAIL_STRUCTURED_NAME,
	FOLKS_PERSONA_DETAIL_URLS,
	FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES,
	FOLKS_PERSONA_DETAIL_GROUPS,
	FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT,
	FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME,
	FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT,
	FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME,
	FOLKS_PERSONA_DETAIL_ANTI_LINKS
} FolksPersonaDetail;

struct _FolksIndividualAggregatorUnlinkIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	gboolean _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksSmallSet* individual_personas;
	FolksIndividual* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	FolksSmallSet* _tmp10_;
	FolksSmallSet* _pers_list;
	FolksSmallSet* _tmp11_;
	FolksSmallSet* _tmp12_;
	gint _pers_size;
	FolksSmallSet* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _pers_index;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	FolksPersona* pers;
	FolksSmallSet* _tmp19_;
	gint _tmp20_;
	gconstpointer _tmp21_;
	FolksPersona* _tmp22_;
	FolksSmallSet* personas;
	FolksSmallSet* _tmp23_;
	FolksSmallSet* _tmp24_;
	FolksPersona* _tmp25_;
	FolksPersona* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	FolksPersona* _tmp29_;
	FolksPersona* writeable_persona;
	FolksSmallSet* _tmp30_;
	FolksPersona* _tmp31_;
	FolksPersona* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	FolksPersona* _tmp35_;
	FolksSmallSet* anti_link_personas;
	FolksSmallSet* _tmp36_;
	FolksSmallSet* _tmp37_;
	FolksSmallSet* _tmp38_;
	FolksPersona* _tmp39_;
	FolksAntiLinkable* al;
	FolksPersona* _tmp40_;
	FolksAntiLinkable* _tmp41_;
	FolksAntiLinkable* _tmp42_;
	FolksAntiLinkable* _tmp43_;
	FolksSmallSet* _tmp44_;
	GError* e1;
	GError* _tmp45_;
	const gchar* _tmp46_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorEnsureIndividualPropertyWriteableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	FolksIndividual* individual;
	gchar* property_name;
	FolksPersona* result;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksPersona* p;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	const gchar* _tmp7_;
	FolksPersona* _tmp8_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorEnsurePersonasPropertyWriteableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	GeeSet* personas;
	gchar* property_name;
	FolksPersona* result;
	GeeIterator* _p1_it;
	GeeSet* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
	gboolean _tmp3_;
	FolksPersona* p1;
	GeeIterator* _tmp4_;
	gpointer _tmp5_;
	const gchar* _tmp6_;
	FolksPersona* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	FolksPersona* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GHashTable* details;
	GeeSet* _tmp13_;
	GHashTable* _tmp14_;
	FolksPersona* new_persona;
	gboolean _tmp15_;
	FolksPersonaStore* _tmp16_;
	const gchar* _tmp17_;
	FolksPersonaStore* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	FolksPersona* _tmp21_;
	FolksPersonaStore* _tmp22_;
	GHashTable* _tmp23_;
	FolksPersona* _tmp24_;
	FolksPersona* _tmp25_;
	GError* e1;
	FolksPersona* _tmp26_;
	GeeIterator* _s_it;
	GeeHashMap* _tmp27_;
	GeeCollection* _tmp28_;
	GeeCollection* _tmp29_;
	GeeCollection* _tmp30_;
	GeeIterator* _tmp31_;
	GeeIterator* _tmp32_;
	GeeIterator* _tmp33_;
	gboolean _tmp34_;
	FolksPersonaStore* s;
	GeeIterator* _tmp35_;
	gpointer _tmp36_;
	gboolean _tmp37_;
	FolksPersonaStore* _tmp38_;
	FolksPersonaStore* _tmp39_;
	const gchar* _tmp40_;
	FolksPersonaStore* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar** _tmp43_;
	gint _tmp43__length1;
	FolksPersonaStore* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	FolksPersona* _tmp47_;
	FolksPersonaStore* _tmp48_;
	GHashTable* _tmp49_;
	FolksPersona* _tmp50_;
	FolksPersona* _tmp51_;
	GError* e2;
	gboolean _tmp52_;
	FolksPersona* _tmp53_;
	FolksPersonaStore* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	GError* _tmp70_;
	GError* _tmp71_;
	FolksPersona* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	GError* _tmp75_;
	FolksPersona* _tmp76_;
	FolksPersona* _tmp77_;
	GError * _inner_error_;
};

struct _FolksIndividualAggregatorLookUpIndividualData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksIndividualAggregator* self;
	gchar* id;
	FolksIndividual* result;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	GError * _inner_error_;
};


static gpointer folks_individual_aggregator_parent_class = NULL;
static FolksIndividualAggregator* folks_individual_aggregator__instance;
static GStaticRecMutex __lock_folks_individual_aggregator__instance = {0};
static FolksIndividualAggregator* folks_individual_aggregator__instance = NULL;

GQuark folks_individual_aggregator_error_quark (void);
GType folks_individual_aggregator_get_type (void) G_GNUC_CONST;
GType folks_backend_store_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backend_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregatorPrivate))
enum  {
	FOLKS_INDIVIDUAL_AGGREGATOR_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED,
	FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT,
	FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE,
	FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS,
	FOLKS_INDIVIDUAL_AGGREGATOR_USER
};
static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend);
static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug);
static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
#define FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA "org.freedesktop.folks"
#define FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY "primary-store"
#define FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT ((guint) 30)
FolksIndividualAggregator* folks_individual_aggregator_dup (void);
FolksIndividualAggregator* folks_individual_aggregator_new (void) G_GNUC_DEPRECATED;
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type);
FolksBackendStore* folks_backend_store_dup (void);
FolksIndividualAggregator* folks_individual_aggregator_dup_with_backend_store (FolksBackendStore* store);
FolksIndividualAggregator* folks_individual_aggregator_new_with_backend_store (FolksBackendStore* store) G_GNUC_DEPRECATED;
FolksIndividualAggregator* folks_individual_aggregator_construct_with_backend_store (GType object_type, FolksBackendStore* store);
static void _folks_individual_aggregator_primary_store_setting_changed_cb (FolksIndividualAggregator* self, GSettings* settings, const gchar* key);
static void _folks_individual_aggregator_configure_primary_store (FolksIndividualAggregator* self, const gchar* store_config_ids);
static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id);
static void _folks_individual_aggregator_set_primary_store (FolksIndividualAggregator* self, FolksPersonaStore* store);
#define FOLKS_DEBUG_STATUS_LOG_DOMAIN "folks-status"
void folks_debug_print_heading (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
void folks_debug_print_key_value_pairs (FolksDebug* self, const gchar* domain, GLogLevelFlags level, ...);
void folks_debug_print_line (FolksDebug* self, const gchar* domain, GLogLevelFlags level, const gchar* format, ...);
GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self);
void folks_debug_indent (FolksDebug* self);
GType folks_trust_level_get_type (void) G_GNUC_CONST;
FolksTrustLevel folks_individual_get_trust_level (FolksIndividual* self);
gboolean folks_individual_get_is_user (FolksIndividual* self);
const gchar* folks_individual_get_id (FolksIndividual* self);
GType folks_persona_get_type (void) G_GNUC_CONST;
GeeSet* folks_individual_get_personas (FolksIndividual* self);
gboolean folks_persona_get_is_user (FolksPersona* self);
const gchar* folks_persona_get_uid (FolksPersona* self);
const gchar* folks_persona_get_iid (FolksPersona* self);
const gchar* folks_persona_get_display_id (FolksPersona* self);
void folks_debug_unindent (FolksDebug* self);
static void folks_individual_aggregator_prepare_data_free (gpointer _data);
void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_);
GeeMap* folks_backend_store_get_enabled_backends (FolksBackendStore* self);
void folks_backend_store_load_backends (FolksBackendStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backend_store_load_backends_finish (FolksBackendStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self);
static void folks_individual_aggregator_unprepare_data_free (gpointer _data);
void folks_individual_aggregator_unprepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unprepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unprepare_co (FolksIndividualAggregatorUnprepareData* _data_);
void folks_persona_store_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_);
static void folks_individual_aggregator_unprepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType folks_match_result_get_type (void) G_GNUC_CONST;
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold);
GType folks_potential_match_get_type (void) G_GNUC_CONST;
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold);
static void _folks_individual_aggregator_add_backend_data_free (gpointer _data);
static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_);
static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* _data_);
static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store);
static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void _folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GeeMap* folks_backend_get_persona_stores (FolksBackend* self);
gboolean folks_backend_get_is_quiescent (FolksBackend* self);
static gboolean _folks_individual_aggregator_quiescent_timeout_cb (FolksIndividualAggregator* self);
static gboolean __folks_individual_aggregator_quiescent_timeout_cb_gsource_func (gpointer self);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
void folks_persona_store_set_is_primary_store (FolksPersonaStore* self, gboolean value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
const gchar* folks_backend_get_name (FolksBackend* self);
static gboolean _folks_individual_aggregator_maybe_configure_as_primary (FolksIndividualAggregator* self, FolksPersonaStore* store);
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _folks_individual_aggregator_is_primary_store_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec);
static void __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_persona_store_is_user_set_default_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean folks_persona_store_get_is_quiescent (FolksPersonaStore* self);
GeeMap* folks_persona_store_get_personas (FolksPersonaStore* self);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void __lambda69_ (Block4Data* _data4_, GObject* obj, GAsyncResult* _result_);
static void ___lambda69__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, GeeMultiMap* changes, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
gboolean folks_debug_get_debug_output_enabled (FolksDebug* self);
static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement);
static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self);
static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, FolksIndividual** user, GeeHashMultiMap** individuals_changes);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
gboolean folks_individual_has_anti_link_with_persona (FolksIndividual* self, FolksPersona* p);
gchar** folks_persona_get_linkable_properties (FolksPersona* self, int* result_length1);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
void folks_persona_linkable_property_to_links (FolksPersona* self, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static void _______lambda67_ (Block6Data* _data6_, const gchar* l);
static void ________lambda67__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
FolksIndividual* folks_individual_new (GeeSet* personas);
FolksIndividual* folks_individual_construct (GType object_type, GeeSet* personas);
static void _folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self, FolksPersona* persona, FolksIndividual* individual);
static void _folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self, FolksIndividual* individual);
static void _folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void _folks_individual_aggregator_persona_anti_links_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec);
static void _folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self, FolksPersona* persona);
static void __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GQuark folks_property_error_quark (void);
GType folks_anti_linkable_get_type (void) G_GNUC_CONST;
static void __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self, FolksPersona* persona);
static void _folks_individual_aggregator_link_map_set (FolksIndividualAggregator* self, const gchar* key, FolksIndividual* individual);
static void _g_object_unref0_ (gpointer var);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _____lambda68_ (Block7Data* _data7_, const gchar* l);
static void ______lambda68__folks_persona_linkable_property_callback (const gchar* link, gpointer self);
FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self);
FolksIndividual* folks_persona_get_individual (FolksPersona* self);
void folks_individual_set_personas (FolksIndividual* self, GeeSet* value);
static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value);
void folks_individual_replace (FolksIndividual* self, FolksIndividual* replacement_individual);
gboolean folks_persona_store_get_is_primary_store (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_user_set_default (FolksPersonaStore* self);
static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data);
void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_);
static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
GQuark folks_persona_store_error_quark (void);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void __lambda70_ (Block8Data* _data8_, const gchar* k, GValue* v);
static GValue* _g_value_dup (GValue* self);
static void ___lambda70__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_individual_aggregator_remove_individual_data_free (gpointer _data);
void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_remove_persona_data_free (gpointer _data);
void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_);
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_link_personas_data_free (gpointer _data);
void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_);
void folks_anti_linkable_remove_anti_links (FolksAntiLinkable* self, GeeSet* other_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_anti_linkable_remove_anti_links_finish (FolksAntiLinkable* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GHashTable* _folks_individual_aggregator_build_linking_details (FolksIndividualAggregator* self, GeeSet* personas);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
guint folks_abstract_field_details_hash_static (FolksAbstractFieldDetails* value);
static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean folks_abstract_field_details_equal_static (FolksAbstractFieldDetails* left, FolksAbstractFieldDetails* right);
static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType folks_web_service_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
GType folks_web_service_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_web_service_details_get_web_service_addresses (FolksWebServiceDetails* self);
GType folks_local_id_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_local_id_details_get_local_ids (FolksLocalIdDetails* self);
GType folks_persona_detail_get_type (void) G_GNUC_CONST;
const gchar* folks_persona_store_detail_key (FolksPersonaDetail detail);
static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data);
void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_);
static void _folks_individual_aggregator_ensure_personas_property_writeable (FolksIndividualAggregator* self, GeeSet* personas, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static FolksPersona* _folks_individual_aggregator_ensure_personas_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_anti_linkable_add_anti_links (FolksAntiLinkable* self, GeeSet* other_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_anti_linkable_add_anti_links_finish (FolksAntiLinkable* self, GAsyncResult* _res_, GError** error);
static void folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data);
void folks_individual_aggregator_ensure_individual_property_writeable (FolksIndividualAggregator* self, FolksIndividual* individual, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_individual_aggregator_ensure_individual_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_);
static void folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_individual_aggregator_ensure_personas_property_writeable_data_free (gpointer _data);
static gboolean _folks_individual_aggregator_ensure_personas_property_writeable_co (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_);
gchar** folks_persona_get_writeable_properties (FolksPersona* self, int* result_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gchar** folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self, int* result_length1);
static void _folks_individual_aggregator_ensure_personas_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_individual_aggregator_look_up_individual_data_free (gpointer _data);
void folks_individual_aggregator_look_up_individual (FolksIndividualAggregator* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksIndividual* folks_individual_aggregator_look_up_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error);
static gboolean folks_individual_aggregator_look_up_individual_co (FolksIndividualAggregatorLookUpIndividualData* _data_);
static void folks_individual_aggregator_look_up_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self);
gboolean folks_individual_aggregator_get_is_quiescent (FolksIndividualAggregator* self);
FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self);
FolksBackendStore* folks_individual_aggregator_get_backend_store (FolksIndividualAggregator* self);
static void folks_individual_aggregator_set_backend_store (FolksIndividualAggregator* self, FolksBackendStore* value);
static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * folks_individual_aggregator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_ptr_array_unref0_ (gpointer var);
FolksDebug* folks_debug_dup (void);
static void __folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void folks_individual_aggregator_finalize (GObject* obj);
static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark folks_individual_aggregator_error_quark (void) {
	return g_quark_from_static_string ("folks_individual_aggregator_error-quark");
}


static void __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	_folks_individual_aggregator_backend_available_cb ((FolksIndividualAggregator*) self, _sender, backend);
}


static void __folks_individual_aggregator_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_folks_individual_aggregator_debug_print_status ((FolksIndividualAggregator*) self, _sender);
}


/**
   * Create or return the singleton {@link IndividualAggregator} class instance.
   * If the instance doesn't exist already, it will be created with the
   * default {@link BackendStore}.
   *
   * This function is thread-safe.
   *
   * @return Singleton {@link IndividualAggregator} instance
   * @since 0.9.5
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksIndividualAggregator* folks_individual_aggregator_dup (void) {
	FolksIndividualAggregator* result = NULL;
	GError * _inner_error_ = NULL;
	{
		FolksIndividualAggregator* _tmp0_ = NULL;
		_tmp0_ = folks_individual_aggregator__instance;
		g_static_rec_mutex_lock (&__lock_folks_individual_aggregator__instance);
		{
			FolksIndividualAggregator* _retval = NULL;
			FolksIndividualAggregator* _tmp1_ = NULL;
			FolksIndividualAggregator* _tmp2_ = NULL;
			FolksIndividualAggregator* retval = NULL;
			FolksIndividualAggregator* _tmp3_ = NULL;
			_tmp1_ = folks_individual_aggregator__instance;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_retval = _tmp2_;
			_tmp3_ = _retval;
			if (_tmp3_ == NULL) {
				FolksIndividualAggregator* _tmp4_ = NULL;
				FolksIndividualAggregator* _tmp5_ = NULL;
				_tmp4_ = folks_individual_aggregator_new ();
				_g_object_unref0 (retval);
				retval = _tmp4_;
				_tmp5_ = retval;
				folks_individual_aggregator__instance = _tmp5_;
			} else {
				FolksIndividualAggregator* _tmp6_ = NULL;
				FolksIndividualAggregator* _tmp7_ = NULL;
				_tmp6_ = _retval;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator));
				_g_object_unref0 (retval);
				retval = _tmp7_;
			}
			result = retval;
			_g_object_unref0 (_retval);
			{
				FolksIndividualAggregator* _tmp8_ = NULL;
				_tmp8_ = folks_individual_aggregator__instance;
				g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
			}
			return result;
		}
		__finally16:
		{
			FolksIndividualAggregator* _tmp9_ = NULL;
			_tmp9_ = folks_individual_aggregator__instance;
			g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
   * Create a new IndividualAggregator.
   *
   * Clients should connect to the
   * {@link IndividualAggregator.individuals_changed} signal (or the
   * {@link IndividualAggregator.individuals_changed_detailed} signal), then
   * call {@link IndividualAggregator.prepare} to load the backends and start
   * aggregating individuals.
   *
   * An example of how to set up an IndividualAggregator:
   * {{{
   *   IndividualAggregator agg = new IndividualAggregator ();
   *   agg.individuals_changed_detailed.connect (individuals_changed_cb);
   *   agg.prepare ();
   * }}}
   *
   * Folks does not support having more than one IndividualAggregator
   * instantiated at the same time. So it's recommended to use
   * {@link IndividualAggregator.dup} instead.
   */
FolksIndividualAggregator* folks_individual_aggregator_construct (GType object_type) {
	FolksIndividualAggregator * self = NULL;
	FolksBackendStore* _tmp0_ = NULL;
	FolksBackendStore* _tmp1_ = NULL;
	_tmp0_ = folks_backend_store_dup ();
	_tmp1_ = _tmp0_;
	self = (FolksIndividualAggregator*) g_object_new (object_type, "backend-store", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new (void) {
	return folks_individual_aggregator_construct (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR);
}


/**
   * Create or return the singleton {@link IndividualAggregator} class instance
   * with a custom {@link BackendStore}.
   * If the instance doesn't exist already, it will be created with
   * the given {@link BackendStore} rather than the default one.
   * If the instance already exists but is using another {@link BackendStore}
   * then a warning is raised and null is returned.
   *
   * This function is thread-safe.
   *
   * @param store the {@link BackendStore} to use instead of the default one.

   * @return Singleton {@link IndividualAggregator} instance, or null
   * @since 0.9.5
   */
FolksIndividualAggregator* folks_individual_aggregator_dup_with_backend_store (FolksBackendStore* store) {
	FolksIndividualAggregator* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	{
		FolksIndividualAggregator* _tmp0_ = NULL;
		_tmp0_ = folks_individual_aggregator__instance;
		g_static_rec_mutex_lock (&__lock_folks_individual_aggregator__instance);
		{
			FolksIndividualAggregator* _retval = NULL;
			FolksIndividualAggregator* _tmp1_ = NULL;
			FolksIndividualAggregator* _tmp2_ = NULL;
			FolksIndividualAggregator* retval = NULL;
			FolksIndividualAggregator* _tmp3_ = NULL;
			_tmp1_ = folks_individual_aggregator__instance;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_retval = _tmp2_;
			_tmp3_ = _retval;
			if (_tmp3_ == NULL) {
				FolksBackendStore* _tmp4_ = NULL;
				FolksIndividualAggregator* _tmp5_ = NULL;
				FolksIndividualAggregator* _tmp6_ = NULL;
				_tmp4_ = store;
				_tmp5_ = folks_individual_aggregator_new_with_backend_store (_tmp4_);
				_g_object_unref0 (retval);
				retval = _tmp5_;
				_tmp6_ = retval;
				folks_individual_aggregator__instance = _tmp6_;
			} else {
				FolksIndividualAggregator* _tmp7_ = NULL;
				FolksBackendStore* _tmp8_ = NULL;
				FolksBackendStore* _tmp9_ = NULL;
				_tmp7_ = _retval;
				_tmp8_ = _tmp7_->priv->_backend_store;
				_tmp9_ = store;
				if (_tmp8_ != _tmp9_) {
					g_warning ("individual-aggregator.vala:427: An aggregator already exists using ano" \
"ther backend store");
					result = NULL;
					_g_object_unref0 (retval);
					_g_object_unref0 (_retval);
					{
						FolksIndividualAggregator* _tmp10_ = NULL;
						_tmp10_ = folks_individual_aggregator__instance;
						g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
					}
					return result;
				} else {
					FolksIndividualAggregator* _tmp11_ = NULL;
					FolksIndividualAggregator* _tmp12_ = NULL;
					_tmp11_ = _retval;
					_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator));
					_g_object_unref0 (retval);
					retval = _tmp12_;
				}
			}
			result = retval;
			_g_object_unref0 (_retval);
			{
				FolksIndividualAggregator* _tmp13_ = NULL;
				_tmp13_ = folks_individual_aggregator__instance;
				g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
			}
			return result;
		}
		__finally17:
		{
			FolksIndividualAggregator* _tmp14_ = NULL;
			_tmp14_ = folks_individual_aggregator__instance;
			g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


/**
   * Create a new IndividualAggregator with a custom {@link BackendStore}.
   *
   * This behaves the same as the default constructor for 
   * {@link IndividualAggregator}, but uses the given {@link BackendStore}
   * rather than the default one.
   *
   * @param store the {@link BackendStore} to use instead of the default one.
   *
   * @since 0.9.0
   */
FolksIndividualAggregator* folks_individual_aggregator_construct_with_backend_store (GType object_type, FolksBackendStore* store) {
	FolksIndividualAggregator * self = NULL;
	FolksBackendStore* _tmp0_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = store;
	self = (FolksIndividualAggregator*) g_object_new (object_type, "backend-store", _tmp0_, NULL);
	return self;
}


FolksIndividualAggregator* folks_individual_aggregator_new_with_backend_store (FolksBackendStore* store) {
	return folks_individual_aggregator_construct_with_backend_store (FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, store);
}


static void _folks_individual_aggregator_primary_store_setting_changed_cb (FolksIndividualAggregator* self, GSettings* settings, const gchar* key) {
	gchar* val = NULL;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = g_settings_get_string (_tmp0_, _tmp1_);
	val = _tmp2_;
	_tmp4_ = val;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = val;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		gchar* store_full_id = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GeeHashMap* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		g_debug ("individual-aggregator.vala:550: Setting primary store IDs from GSettin" \
"gs.");
		_tmp6_ = val;
		_folks_individual_aggregator_configure_primary_store (self, (const gchar*) _tmp6_);
		_tmp7_ = self->priv->_configured_primary_store_type_id;
		_tmp8_ = self->priv->_configured_primary_store_id;
		_tmp9_ = _folks_individual_aggregator_get_store_full_id (self, _tmp7_, _tmp8_);
		store_full_id = _tmp9_;
		_tmp10_ = self->priv->_stores;
		_tmp11_ = store_full_id;
		_tmp12_ = gee_map_contains ((GeeMap*) _tmp10_, _tmp11_);
		if (_tmp12_) {
			FolksPersonaStore* selected_store = NULL;
			GeeHashMap* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gpointer _tmp15_ = NULL;
			FolksPersonaStore* _tmp16_ = NULL;
			_tmp13_ = self->priv->_stores;
			_tmp14_ = store_full_id;
			_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
			selected_store = (FolksPersonaStore*) _tmp15_;
			_tmp16_ = selected_store;
			_folks_individual_aggregator_set_primary_store (self, _tmp16_);
			_g_object_unref0 (selected_store);
		}
		_g_free0 (store_full_id);
	}
	_g_free0 (val);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _folks_individual_aggregator_configure_primary_store (FolksIndividualAggregator* self, const gchar* store_config_ids) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store_config_ids != NULL);
	_tmp0_ = store_config_ids;
	g_debug ("individual-aggregator.vala:566: _configure_primary_store to '%s'", _tmp0_);
	self->priv->_user_configured_primary_store = TRUE;
	_tmp1_ = store_config_ids;
	_tmp2_ = string_index_of (_tmp1_, ":", 0);
	if (_tmp2_ != (-1)) {
		gchar** ids = NULL;
		const gchar* _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint ids_length1 = 0;
		gint _ids_size_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp3_ = store_config_ids;
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 2);
		ids = _tmp5_;
		ids_length1 = _vala_array_length (_tmp4_);
		_ids_size_ = ids_length1;
		_tmp6_ = ids;
		_tmp6__length1 = ids_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp8_;
		_tmp9_ = ids;
		_tmp9__length1 = ids_length1;
		_tmp10_ = _tmp9_[1];
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp11_;
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	} else {
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp12_ = store_config_ids;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp13_;
		_tmp14_ = g_strdup ("");
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp14_;
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void _folks_individual_aggregator_debug_print_status (FolksIndividualAggregator* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	FolksDebug* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	FolksPersonaStore* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	FolksDebug* _tmp20_ = NULL;
	GeeMap* _tmp21_ = NULL;
	GeeMap* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	FolksDebug* _tmp25_ = NULL;
	FolksDebug* _tmp93_ = NULL;
	FolksDebug* _tmp94_ = NULL;
	GHashTable* _tmp95_ = NULL;
	guint _tmp96_ = 0U;
	FolksDebug* _tmp97_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp98_ = NULL;
	const gchar* link_key = NULL;
	GPtrArray* individuals = NULL;
	FolksDebug* _tmp118_ = NULL;
	FolksDebug* _tmp119_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "IndividualAggregator (%p)", self);
	_tmp2_ = self->priv->_linking_enabled;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp4_ = self->priv->_is_prepared;
	if (_tmp4_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp6_ = self->priv->_is_quiescent;
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("yes");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp7_;
	} else {
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		gchar* _tmp10_ = NULL;
		_tmp8_ = self->priv->_non_quiescent_backend_count;
		_tmp9_ = self->priv->_non_quiescent_persona_store_count;
		_tmp10_ = g_strdup_printf ("no (%u backends, %u persona stores left)", _tmp8_, _tmp9_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp10_;
	}
	_tmp11_ = debug;
	_tmp12_ = ((GObject*) self)->ref_count;
	_tmp13_ = g_strdup_printf ("%u", _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_primary_store;
	_tmp16_ = g_strdup_printf ("%p", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_configured_primary_store_type_id;
	_tmp19_ = self->priv->_configured_primary_store_id;
	folks_debug_print_key_value_pairs (_tmp11_, domain, level, "Ref. count", _tmp14_, "Primary store", _tmp17_, "Configured store type id", _tmp18_, "Configured store id", _tmp19_, "Linking enabled?", _tmp1_, "Prepared?", _tmp3_, "Quiescent?", _tmp5_, NULL);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp20_ = debug;
	_tmp21_ = folks_individual_aggregator_get_individuals (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_map_get_size (_tmp22_);
	_tmp24_ = _tmp23_;
	folks_debug_print_line (_tmp20_, domain, level, "%u Individuals:", (guint) _tmp24_);
	_tmp25_ = debug;
	folks_debug_indent (_tmp25_);
	{
		GeeIterator* _individual_it = NULL;
		GeeMap* _tmp26_ = NULL;
		GeeMap* _tmp27_ = NULL;
		GeeCollection* _tmp28_ = NULL;
		GeeCollection* _tmp29_ = NULL;
		GeeCollection* _tmp30_ = NULL;
		GeeIterator* _tmp31_ = NULL;
		GeeIterator* _tmp32_ = NULL;
		_tmp26_ = folks_individual_aggregator_get_individuals (self);
		_tmp27_ = _tmp26_;
		_tmp28_ = gee_map_get_values (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
		_tmp32_ = _tmp31_;
		_g_object_unref0 (_tmp30_);
		_individual_it = _tmp32_;
		while (TRUE) {
			GeeIterator* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp35_ = NULL;
			gpointer _tmp36_ = NULL;
			gchar* trust_level = NULL;
			FolksIndividual* _tmp37_ = NULL;
			FolksTrustLevel _tmp38_ = 0;
			FolksTrustLevel _tmp39_ = 0;
			FolksDebug* _tmp42_ = NULL;
			FolksIndividual* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			FolksIndividual* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
			gboolean _tmp47_ = FALSE;
			FolksDebug* _tmp48_ = NULL;
			FolksIndividual* _tmp49_ = NULL;
			guint _tmp50_ = 0U;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			FolksIndividual* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			const gchar* _tmp56_ = NULL;
			FolksDebug* _tmp57_ = NULL;
			FolksIndividual* _tmp58_ = NULL;
			GeeSet* _tmp59_ = NULL;
			GeeSet* _tmp60_ = NULL;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			FolksDebug* _tmp63_ = NULL;
			FolksDebug* _tmp92_ = NULL;
			_tmp33_ = _individual_it;
			_tmp34_ = gee_iterator_next (_tmp33_);
			if (!_tmp34_) {
				break;
			}
			_tmp35_ = _individual_it;
			_tmp36_ = gee_iterator_get (_tmp35_);
			individual = (FolksIndividual*) _tmp36_;
			trust_level = NULL;
			_tmp37_ = individual;
			_tmp38_ = folks_individual_get_trust_level (_tmp37_);
			_tmp39_ = _tmp38_;
			switch (_tmp39_) {
				case FOLKS_TRUST_LEVEL_NONE:
				{
					gchar* _tmp40_ = NULL;
					_tmp40_ = g_strdup ("none");
					_g_free0 (trust_level);
					trust_level = _tmp40_;
					break;
				}
				case FOLKS_TRUST_LEVEL_PERSONAS:
				{
					gchar* _tmp41_ = NULL;
					_tmp41_ = g_strdup ("personas");
					_g_free0 (trust_level);
					trust_level = _tmp41_;
					break;
				}
				default:
				{
					g_assert_not_reached ();
				}
			}
			_tmp42_ = debug;
			_tmp43_ = individual;
			folks_debug_print_heading (_tmp42_, domain, level, "Individual (%p)", _tmp43_);
			_tmp45_ = individual;
			_tmp46_ = folks_individual_get_is_user (_tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_) {
				_tmp44_ = "yes";
			} else {
				_tmp44_ = "no";
			}
			_tmp48_ = debug;
			_tmp49_ = individual;
			_tmp50_ = ((GObject*) _tmp49_)->ref_count;
			_tmp51_ = g_strdup_printf ("%u", _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = individual;
			_tmp54_ = folks_individual_get_id (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = trust_level;
			folks_debug_print_key_value_pairs (_tmp48_, domain, level, "Ref. count", _tmp52_, "ID", _tmp55_, "User?", _tmp44_, "Trust level", _tmp56_, NULL);
			_g_free0 (_tmp52_);
			_tmp57_ = debug;
			_tmp58_ = individual;
			_tmp59_ = folks_individual_get_personas (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			folks_debug_print_line (_tmp57_, domain, level, "%u Personas:", (guint) _tmp62_);
			_tmp63_ = debug;
			folks_debug_indent (_tmp63_);
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp64_ = NULL;
				GeeSet* _tmp65_ = NULL;
				GeeSet* _tmp66_ = NULL;
				GeeIterator* _tmp67_ = NULL;
				_tmp64_ = individual;
				_tmp65_ = folks_individual_get_personas (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = gee_iterable_iterator ((GeeIterable*) _tmp66_);
				_persona_it = _tmp67_;
				while (TRUE) {
					GeeIterator* _tmp68_ = NULL;
					gboolean _tmp69_ = FALSE;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp70_ = NULL;
					gpointer _tmp71_ = NULL;
					FolksDebug* _tmp72_ = NULL;
					FolksPersona* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					FolksPersona* _tmp75_ = NULL;
					gboolean _tmp76_ = FALSE;
					gboolean _tmp77_ = FALSE;
					FolksDebug* _tmp78_ = NULL;
					FolksPersona* _tmp79_ = NULL;
					guint _tmp80_ = 0U;
					gchar* _tmp81_ = NULL;
					gchar* _tmp82_ = NULL;
					FolksPersona* _tmp83_ = NULL;
					const gchar* _tmp84_ = NULL;
					const gchar* _tmp85_ = NULL;
					FolksPersona* _tmp86_ = NULL;
					const gchar* _tmp87_ = NULL;
					const gchar* _tmp88_ = NULL;
					FolksPersona* _tmp89_ = NULL;
					const gchar* _tmp90_ = NULL;
					const gchar* _tmp91_ = NULL;
					_tmp68_ = _persona_it;
					_tmp69_ = gee_iterator_next (_tmp68_);
					if (!_tmp69_) {
						break;
					}
					_tmp70_ = _persona_it;
					_tmp71_ = gee_iterator_get (_tmp70_);
					persona = (FolksPersona*) _tmp71_;
					_tmp72_ = debug;
					_tmp73_ = persona;
					folks_debug_print_heading (_tmp72_, domain, level, "Persona (%p)", _tmp73_);
					_tmp75_ = persona;
					_tmp76_ = folks_persona_get_is_user (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_) {
						_tmp74_ = "yes";
					} else {
						_tmp74_ = "no";
					}
					_tmp78_ = debug;
					_tmp79_ = persona;
					_tmp80_ = ((GObject*) _tmp79_)->ref_count;
					_tmp81_ = g_strdup_printf ("%u", _tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = persona;
					_tmp84_ = folks_persona_get_uid (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = persona;
					_tmp87_ = folks_persona_get_iid (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = persona;
					_tmp90_ = folks_persona_get_display_id (_tmp89_);
					_tmp91_ = _tmp90_;
					folks_debug_print_key_value_pairs (_tmp78_, domain, level, "Ref. count", _tmp82_, "UID", _tmp85_, "IID", _tmp88_, "Display ID", _tmp91_, "User?", _tmp74_, NULL);
					_g_free0 (_tmp82_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp92_ = debug;
			folks_debug_unindent (_tmp92_);
			_g_free0 (trust_level);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp93_ = debug;
	folks_debug_unindent (_tmp93_);
	_tmp94_ = debug;
	_tmp95_ = self->priv->_link_map;
	_tmp96_ = g_hash_table_size (_tmp95_);
	folks_debug_print_line (_tmp94_, domain, level, "%u keys in the link map:", _tmp96_);
	_tmp97_ = debug;
	folks_debug_indent (_tmp97_);
	_tmp98_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp98_);
	while (TRUE) {
		gconstpointer _tmp99_ = NULL;
		gconstpointer _tmp100_ = NULL;
		gboolean _tmp101_ = FALSE;
		FolksDebug* _tmp102_ = NULL;
		const gchar* _tmp103_ = NULL;
		FolksDebug* _tmp104_ = NULL;
		FolksDebug* _tmp116_ = NULL;
		FolksDebug* _tmp117_ = NULL;
		_tmp101_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp99_), (gpointer*) (&_tmp100_));
		link_key = _tmp99_;
		individuals = _tmp100_;
		if (!_tmp101_) {
			break;
		}
		_tmp102_ = debug;
		_tmp103_ = link_key;
		folks_debug_print_line (_tmp102_, domain, level, "%s → {", _tmp103_);
		_tmp104_ = debug;
		folks_debug_indent (_tmp104_);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp105_ = FALSE;
				_tmp105_ = TRUE;
				while (TRUE) {
					guint _tmp107_ = 0U;
					GPtrArray* _tmp108_ = NULL;
					gint _tmp109_ = 0;
					gint _tmp110_ = 0;
					FolksIndividual* ind = NULL;
					GPtrArray* _tmp111_ = NULL;
					guint _tmp112_ = 0U;
					gconstpointer _tmp113_ = NULL;
					FolksDebug* _tmp114_ = NULL;
					FolksIndividual* _tmp115_ = NULL;
					if (!_tmp105_) {
						guint _tmp106_ = 0U;
						_tmp106_ = i;
						i = _tmp106_ + 1;
					}
					_tmp105_ = FALSE;
					_tmp107_ = i;
					_tmp108_ = individuals;
					_tmp109_ = g_ptr_array_get_length (_tmp108_);
					_tmp110_ = _tmp109_;
					if (!(_tmp107_ < ((guint) _tmp110_))) {
						break;
					}
					_tmp111_ = individuals;
					_tmp112_ = i;
					_tmp113_ = g_ptr_array_index (_tmp111_, _tmp112_);
					ind = (FolksIndividual*) _tmp113_;
					_tmp114_ = debug;
					_tmp115_ = ind;
					folks_debug_print_line (_tmp114_, domain, level, "%p", _tmp115_);
				}
			}
		}
		_tmp116_ = debug;
		folks_debug_unindent (_tmp116_);
		_tmp117_ = debug;
		folks_debug_print_line (_tmp117_, domain, level, "}");
	}
	_tmp118_ = debug;
	folks_debug_unindent (_tmp118_);
	_tmp119_ = debug;
	folks_debug_print_line (_tmp119_, domain, level, "");
	_g_free0 (_tmp5_);
}


static void folks_individual_aggregator_prepare_data_free (gpointer _data) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorPrepareData, _data_);
}


void folks_individual_aggregator_prepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_individual_aggregator_prepare_co (_data_);
}


void folks_individual_aggregator_prepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the IndividualAggregator for use.
   *
   * This loads all the available backends and prepares them for use by the
   * IndividualAggregator. This should be called //after// connecting to the
   * {@link IndividualAggregator.individuals_changed} signal (or
   * {@link IndividualAggregator.individuals_changed_detailed} signal), or a
   * race condition could occur, with the signal being emitted before your code
   * has connected to them, and {@link Individual}s getting "lost" as a result.
   *
   * This function is guaranteed to be idempotent (since version 0.3.0).
   *
   * Concurrent calls to this function from different threads will block until
   * preparation has completed. However, concurrent calls to this function from
   * a single thread might not, i.e. the first call will block but subsequent
   * calls might return before the first one. (Though they will be safe in every
   * other respect.)
   *
   * @throws GLib.Error if preparing any of the backends failed — this error
   * will be passed through from {@link BackendStore.load_backends}
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_prepare_co (_data_);
}


static gboolean folks_individual_aggregator_prepare_co (FolksIndividualAggregatorPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing IndividualAggregator", NULL);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp3_ = 0U;
		_data_->_tmp3_ = _data_->self->priv->_non_quiescent_backend_count;
		_data_->self->priv->_non_quiescent_backend_count = _data_->_tmp3_ + 1;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->_backend_store;
		g_signal_connect_object (_data_->_tmp4_, "backend-available", (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, _data_->self, 0);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->_backend_store;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = folks_backend_store_get_enabled_backends (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = gee_map_get_values (_data_->_tmp7_);
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->backends = _data_->_tmp9_;
		{
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->backends;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp10_);
			_data_->_backend_it = _data_->_tmp11_;
			while (TRUE) {
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->_backend_it;
				_data_->_tmp13_ = FALSE;
				_data_->_tmp13_ = gee_iterator_next (_data_->_tmp12_);
				if (!_data_->_tmp13_) {
					break;
				}
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->_backend_it;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = gee_iterator_get (_data_->_tmp14_);
				_data_->backend = (FolksBackend*) _data_->_tmp15_;
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->self->priv->_backend_store;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->backend;
				_folks_individual_aggregator_backend_available_cb (_data_->self, _data_->_tmp16_, _data_->_tmp17_);
				_g_object_unref0 (_data_->backend);
			}
			_g_object_unref0 (_data_->_backend_it);
		}
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->self->priv->_backend_store;
		_data_->_state_ = 1;
		folks_backend_store_load_backends (_data_->_tmp18_, folks_individual_aggregator_prepare_ready, _data_);
		return FALSE;
		_state_1:
		folks_backend_store_load_backends_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->backends);
			goto __finally18;
		}
		_data_->_tmp19_ = 0U;
		_data_->_tmp19_ = _data_->self->priv->_non_quiescent_backend_count;
		_data_->self->priv->_non_quiescent_backend_count = _data_->_tmp19_ - 1;
		_data_->self->priv->_is_prepared = TRUE;
		_data_->self->priv->_prepare_pending = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->_tmp20_ = FALSE;
		_data_->_tmp20_ = _data_->self->priv->_is_quiescent;
		if (_data_->_tmp20_ == FALSE) {
			_folks_individual_aggregator_notify_if_is_quiescent (_data_->self);
		}
		_g_object_unref0 (_data_->backends);
	}
	__finally18:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	folks_internal_profiling_end ("preparing IndividualAggregator", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_unprepare_data_free (gpointer _data) {
	FolksIndividualAggregatorUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorUnprepareData, _data_);
}


void folks_individual_aggregator_unprepare (FolksIndividualAggregator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnprepareData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_individual_aggregator_unprepare_co (_data_);
}


void folks_individual_aggregator_unprepare_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Clean up and release resources used by the aggregator.
   *
   * This will disconnect the aggregator cleanly from any resources it or its
   * persona stores are using. It is recommended to call this method before
   * finalising the individual aggregator, but calling it is not required. If
   * this method is not called then, for example, unsaved changes in backends
   * may not be flushed.
   *
   * Concurrent calls to this function from different threads will block until
   * preparation has completed. However, concurrent calls to this function from
   * a single thread might not, i.e. the first call will block but subsequent
   * calls might return before the first one. (Though they will be safe in every
   * other respect.)
   *
   * @since 0.7.3
   * @throws GLib.Error if unpreparing the backend-specific services failed —
   * this will be a backend-specific error
   */
static void folks_individual_aggregator_unprepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnprepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_unprepare_co (_data_);
}


static gboolean folks_individual_aggregator_unprepare_co (FolksIndividualAggregatorUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = FALSE;
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp2_ = FALSE;
			_data_->_tmp2_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp2_) {
				_data_->_tmp1_ = TRUE;
			} else {
				_data_->_tmp3_ = FALSE;
				_data_->_tmp3_ = _data_->self->priv->_prepare_pending;
				_data_->_tmp1_ = _data_->_tmp3_;
			}
			if (_data_->_tmp1_) {
				{
					_data_->_tmp4_ = FALSE;
					_data_->_tmp4_ = _data_->self->priv->_is_prepared;
					g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
				}
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			{
				{
					_data_->_tmp5_ = NULL;
					_data_->_tmp5_ = _data_->self->priv->_stores;
					_data_->_tmp6_ = NULL;
					_data_->_tmp6_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp5_);
					_data_->_tmp7_ = NULL;
					_data_->_tmp7_ = _data_->_tmp6_;
					_data_->_tmp8_ = NULL;
					_data_->_tmp8_ = _data_->_tmp7_;
					_data_->_tmp9_ = NULL;
					_data_->_tmp9_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp8_);
					_data_->_tmp10_ = NULL;
					_data_->_tmp10_ = _data_->_tmp9_;
					_g_object_unref0 (_data_->_tmp8_);
					_data_->_p_it = _data_->_tmp10_;
					while (TRUE) {
						_data_->_tmp11_ = NULL;
						_data_->_tmp11_ = _data_->_p_it;
						_data_->_tmp12_ = FALSE;
						_data_->_tmp12_ = gee_iterator_next (_data_->_tmp11_);
						if (!_data_->_tmp12_) {
							break;
						}
						_data_->_tmp13_ = NULL;
						_data_->_tmp13_ = _data_->_p_it;
						_data_->_tmp14_ = NULL;
						_data_->_tmp14_ = gee_iterator_get (_data_->_tmp13_);
						_data_->p = (FolksPersonaStore*) _data_->_tmp14_;
						_data_->_tmp15_ = NULL;
						_data_->_tmp15_ = _data_->p;
						_data_->_state_ = 1;
						folks_persona_store_flush (_data_->_tmp15_, folks_individual_aggregator_unprepare_ready, _data_);
						return FALSE;
						_state_1:
						folks_persona_store_flush_finish (_data_->_tmp15_, _data_->_res_);
						_g_object_unref0 (_data_->p);
					}
					_g_object_unref0 (_data_->_p_it);
				}
			}
			__finally20:
			{
				_data_->self->priv->_prepare_pending = FALSE;
			}
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				{
					_data_->_tmp16_ = FALSE;
					_data_->_tmp16_ = _data_->self->priv->_is_prepared;
					g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		__finally19:
		{
			_data_->_tmp17_ = FALSE;
			_data_->_tmp17_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Get all matches for a given {@link Individual}.
   *
   * @param matchee the individual to find matches for
   * @param min_threshold the threshold for accepting a match
   * @return a map from matched individuals to the degree with which they match
   * ``matchee`` (which is guaranteed to at least equal ``min_threshold``);
   * if no matches could be found, an empty map is returned
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_potential_matches (FolksIndividualAggregator* self, FolksIndividual* matchee, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* matches = NULL;
	GeeHashMap* _tmp0_ = NULL;
	FolksPotentialMatch* matchObj = NULL;
	FolksPotentialMatch* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (matchee != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = folks_potential_match_new ();
	matchObj = _tmp1_;
	{
		GeeIterator* _i_it = NULL;
		GeeMap* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		_tmp2_ = self->priv->_individuals;
		_tmp3_ = gee_map_get_values (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_i_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp10_ = NULL;
			gpointer _tmp11_ = NULL;
			FolksIndividual* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			FolksIndividual* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			FolksMatchResult _result_ = 0;
			FolksPotentialMatch* _tmp18_ = NULL;
			FolksIndividual* _tmp19_ = NULL;
			FolksIndividual* _tmp20_ = NULL;
			FolksMatchResult _tmp21_ = 0;
			FolksMatchResult _tmp22_ = 0;
			FolksMatchResult _tmp23_ = 0;
			_tmp8_ = _i_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _i_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			i = (FolksIndividual*) _tmp11_;
			_tmp12_ = i;
			_tmp13_ = folks_individual_get_id (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = matchee;
			_tmp16_ = folks_individual_get_id (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp14_, _tmp17_) == 0) {
				_g_object_unref0 (i);
				continue;
			}
			_tmp18_ = matchObj;
			_tmp19_ = i;
			_tmp20_ = matchee;
			_tmp21_ = folks_potential_match_potential_match (_tmp18_, _tmp19_, _tmp20_);
			_result_ = _tmp21_;
			_tmp22_ = _result_;
			_tmp23_ = min_threshold;
			if (_tmp22_ >= _tmp23_) {
				GeeHashMap* _tmp24_ = NULL;
				FolksIndividual* _tmp25_ = NULL;
				FolksMatchResult _tmp26_ = 0;
				_tmp24_ = matches;
				_tmp25_ = i;
				_tmp26_ = _result_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, _tmp25_, (gpointer) ((gintptr) _tmp26_));
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	return result;
}


/**
   * Get all combinations between all {@link Individual}s.
   *
   * @param min_threshold the threshold for accepting a match
   * @return a map from each individual in the aggregator to a map of the
   * other individuals in the aggregator which can be matched with that
   * individual, mapped to the degree with which they match the original
   * individual (which is guaranteed to at least equal ``min_threshold``)
   *
   * @since 0.5.1
   */
GeeMap* folks_individual_aggregator_get_all_potential_matches (FolksIndividualAggregator* self, FolksMatchResult min_threshold) {
	GeeMap* result = NULL;
	GeeHashMap* matches = NULL;
	GeeHashMap* _tmp0_ = NULL;
	FolksIndividual** individuals = NULL;
	GeeMap* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gpointer* _tmp6_ = NULL;
	FolksIndividual** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint individuals_length1 = 0;
	gint _individuals_size_ = 0;
	FolksPotentialMatch* matchObj = NULL;
	FolksPotentialMatch* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	matches = _tmp0_;
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = gee_map_get_values (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp6_ = gee_collection_to_array (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_g_object_unref0 (_tmp4_);
	individuals = _tmp7_;
	individuals_length1 = _tmp7__length1;
	_individuals_size_ = individuals_length1;
	_tmp8_ = folks_potential_match_new ();
	matchObj = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				FolksIndividual** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				FolksIndividual* a = NULL;
				FolksIndividual** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				FolksIndividual* _tmp15_ = NULL;
				FolksIndividual* _tmp16_ = NULL;
				GeeHashMap* _matches_a = NULL;
				GeeHashMap* _tmp17_ = NULL;
				FolksIndividual* _tmp18_ = NULL;
				gpointer _tmp19_ = NULL;
				GeeHashMap* matches_a = NULL;
				GeeHashMap* _tmp20_ = NULL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = individuals;
				_tmp12__length1 = individuals_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = individuals;
				_tmp13__length1 = individuals_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = _g_object_ref0 (_tmp15_);
				a = _tmp16_;
				_tmp17_ = matches;
				_tmp18_ = a;
				_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
				_matches_a = (GeeHashMap*) _tmp19_;
				_tmp20_ = _matches_a;
				if (_tmp20_ == NULL) {
					GeeHashMap* _tmp21_ = NULL;
					GeeHashMap* _tmp22_ = NULL;
					FolksIndividual* _tmp23_ = NULL;
					GeeHashMap* _tmp24_ = NULL;
					_tmp21_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
					_g_object_unref0 (matches_a);
					matches_a = _tmp21_;
					_tmp22_ = matches;
					_tmp23_ = a;
					_tmp24_ = matches_a;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, _tmp23_, _tmp24_);
				} else {
					GeeHashMap* _tmp25_ = NULL;
					GeeHashMap* _tmp26_ = NULL;
					_tmp25_ = _matches_a;
					_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_HASH_MAP, GeeHashMap));
					_g_object_unref0 (matches_a);
					matches_a = _tmp26_;
				}
				{
					gint f = 0;
					gint _tmp27_ = 0;
					_tmp27_ = i;
					f = _tmp27_ + 1;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gint _tmp30_ = 0;
							FolksIndividual** _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							FolksIndividual* b = NULL;
							FolksIndividual** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp33_ = 0;
							FolksIndividual* _tmp34_ = NULL;
							FolksIndividual* _tmp35_ = NULL;
							GeeHashMap* _matches_b = NULL;
							GeeHashMap* _tmp36_ = NULL;
							FolksIndividual* _tmp37_ = NULL;
							gpointer _tmp38_ = NULL;
							GeeHashMap* matches_b = NULL;
							GeeHashMap* _tmp39_ = NULL;
							FolksMatchResult _result_ = 0;
							FolksPotentialMatch* _tmp46_ = NULL;
							FolksIndividual* _tmp47_ = NULL;
							FolksIndividual* _tmp48_ = NULL;
							FolksMatchResult _tmp49_ = 0;
							FolksMatchResult _tmp50_ = 0;
							FolksMatchResult _tmp51_ = 0;
							if (!_tmp28_) {
								gint _tmp29_ = 0;
								_tmp29_ = f;
								f = _tmp29_ + 1;
							}
							_tmp28_ = FALSE;
							_tmp30_ = f;
							_tmp31_ = individuals;
							_tmp31__length1 = individuals_length1;
							if (!(_tmp30_ < _tmp31__length1)) {
								break;
							}
							_tmp32_ = individuals;
							_tmp32__length1 = individuals_length1;
							_tmp33_ = f;
							_tmp34_ = _tmp32_[_tmp33_];
							_tmp35_ = _g_object_ref0 (_tmp34_);
							b = _tmp35_;
							_tmp36_ = matches;
							_tmp37_ = b;
							_tmp38_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp36_, _tmp37_);
							_matches_b = (GeeHashMap*) _tmp38_;
							_tmp39_ = _matches_b;
							if (_tmp39_ == NULL) {
								GeeHashMap* _tmp40_ = NULL;
								GeeHashMap* _tmp41_ = NULL;
								FolksIndividual* _tmp42_ = NULL;
								GeeHashMap* _tmp43_ = NULL;
								_tmp40_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_MATCH_RESULT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
								_g_object_unref0 (matches_b);
								matches_b = _tmp40_;
								_tmp41_ = matches;
								_tmp42_ = b;
								_tmp43_ = matches_b;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp41_, _tmp42_, _tmp43_);
							} else {
								GeeHashMap* _tmp44_ = NULL;
								GeeHashMap* _tmp45_ = NULL;
								_tmp44_ = _matches_b;
								_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_HASH_MAP, GeeHashMap));
								_g_object_unref0 (matches_b);
								matches_b = _tmp45_;
							}
							_tmp46_ = matchObj;
							_tmp47_ = a;
							_tmp48_ = b;
							_tmp49_ = folks_potential_match_potential_match (_tmp46_, _tmp47_, _tmp48_);
							_result_ = _tmp49_;
							_tmp50_ = _result_;
							_tmp51_ = min_threshold;
							if (_tmp50_ >= _tmp51_) {
								GeeHashMap* _tmp52_ = NULL;
								FolksIndividual* _tmp53_ = NULL;
								FolksMatchResult _tmp54_ = 0;
								GeeHashMap* _tmp55_ = NULL;
								FolksIndividual* _tmp56_ = NULL;
								FolksMatchResult _tmp57_ = 0;
								_tmp52_ = matches_a;
								_tmp53_ = b;
								_tmp54_ = _result_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, _tmp53_, (gpointer) ((gintptr) _tmp54_));
								_tmp55_ = matches_b;
								_tmp56_ = a;
								_tmp57_ = _result_;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp55_, _tmp56_, (gpointer) ((gintptr) _tmp57_));
							}
							_g_object_unref0 (matches_b);
							_g_object_unref0 (_matches_b);
							_g_object_unref0 (b);
						}
					}
				}
				_g_object_unref0 (matches_a);
				_g_object_unref0 (_matches_a);
				_g_object_unref0 (a);
			}
		}
	}
	result = (GeeMap*) matches;
	_g_object_unref0 (matchObj);
	individuals = (_vala_array_free (individuals, individuals_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static void _folks_individual_aggregator_add_backend_data_free (gpointer _data) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->backend);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorAddBackendData, _data_);
}


static void _folks_individual_aggregator_add_backend (FolksIndividualAggregator* self, FolksBackend* backend, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksBackend* _tmp1_ = NULL;
	FolksBackend* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddBackendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_individual_aggregator_add_backend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_individual_aggregator_add_backend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = backend;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->backend);
	_data_->backend = _tmp2_;
	_folks_individual_aggregator_add_backend_co (_data_);
}


static void _folks_individual_aggregator_add_backend_finish (FolksIndividualAggregator* self, GAsyncResult* _res_) {
	FolksIndividualAggregatorAddBackendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_added_cb ((FolksIndividualAggregator*) self, _sender, store);
}


static void __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
	_folks_individual_aggregator_backend_persona_store_removed_cb ((FolksIndividualAggregator*) self, _sender, store);
}


static void __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_backend_is_quiescent_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static gboolean _folks_individual_aggregator_add_backend_co (FolksIndividualAggregatorAddBackendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_backends;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->backend;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data_->_tmp0_, _data_->_tmp1_);
	if (!_data_->_tmp2_) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->_backends;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->backend;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp3_, _data_->_tmp4_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->backend;
		g_signal_connect_object (_data_->_tmp5_, "persona-store-added", (GCallback) __folks_individual_aggregator_backend_persona_store_added_cb_folks_backend_persona_store_added, _data_->self, 0);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->backend;
		g_signal_connect_object (_data_->_tmp6_, "persona-store-removed", (GCallback) __folks_individual_aggregator_backend_persona_store_removed_cb_folks_backend_persona_store_removed, _data_->self, 0);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->backend;
		g_signal_connect_object ((GObject*) _data_->_tmp7_, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_backend_is_quiescent_changed_cb_g_object_notify, _data_->self, 0);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->backend;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = folks_backend_get_persona_stores (_data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = gee_map_get_values (_data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = 0;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = gee_collection_to_array (_data_->_tmp13_, &_data_->_tmp14_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16__length1 = 0;
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp16__length1 = _data_->_tmp14_;
		_g_object_unref0 (_data_->_tmp13_);
		_data_->stores_length1 = 0;
		_data_->_stores_size_ = 0;
		_data_->stores = _data_->_tmp16_;
		_data_->stores_length1 = _data_->_tmp16__length1;
		_data_->_stores_size_ = _data_->stores_length1;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17__length1 = 0;
		_data_->_tmp17_ = _data_->stores;
		_data_->_tmp17__length1 = _data_->stores_length1;
		{
			_data_->persona_store_collection_length1 = 0;
			_data_->_persona_store_collection_size_ = 0;
			_data_->persona_store_collection = _data_->_tmp17_;
			_data_->persona_store_collection_length1 = _data_->_tmp17__length1;
			for (_data_->persona_store_it = 0; _data_->persona_store_it < _data_->_tmp17__length1; _data_->persona_store_it = _data_->persona_store_it + 1) {
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _g_object_ref0 (_data_->persona_store_collection[_data_->persona_store_it]);
				_data_->persona_store = _data_->_tmp18_;
				{
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->backend;
					_data_->_tmp20_ = NULL;
					_data_->_tmp20_ = _data_->persona_store;
					_folks_individual_aggregator_backend_persona_store_added_cb (_data_->self, _data_->_tmp19_, _data_->_tmp20_);
					_g_object_unref0 (_data_->persona_store);
				}
			}
		}
		_data_->stores = (_vala_array_free (_data_->stores, _data_->stores_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean __folks_individual_aggregator_quiescent_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = _folks_individual_aggregator_quiescent_timeout_cb ((FolksIndividualAggregator*) self);
	return result;
}


static void _folks_individual_aggregator_backend_available_cb (FolksIndividualAggregator* self, FolksBackendStore* backend_store, FolksBackend* backend) {
	FolksBackend* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	FolksBackend* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend_store != NULL);
	g_return_if_fail (backend != NULL);
	_tmp0_ = backend;
	_tmp1_ = folks_backend_get_is_quiescent (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp3_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp3_ + 1;
		_tmp4_ = self->priv->_quiescent_timeout_id;
		if (_tmp4_ == ((guint) 0)) {
			guint _tmp5_ = 0U;
			_tmp5_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT, __folks_individual_aggregator_quiescent_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->_quiescent_timeout_id = _tmp5_;
		}
	}
	_tmp6_ = backend;
	_folks_individual_aggregator_add_backend (self, _tmp6_, NULL, NULL);
}


static void _folks_individual_aggregator_set_primary_store (FolksIndividualAggregator* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_debug ("individual-aggregator.vala:957: _set_primary_store()");
	_tmp0_ = self->priv->_primary_store;
	_tmp1_ = store;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = store;
	_tmp3_ = folks_persona_store_get_type_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_configured_primary_store_type_id;
	if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		FolksPersonaStore* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = store;
		_tmp9_ = folks_persona_store_get_type_id (_tmp8_);
		_tmp10_ = _tmp9_;
		if (g_strcmp0 (_tmp10_, "eds") != 0) {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = self->priv->_configured_primary_store_id;
			_tmp7_ = g_strcmp0 (_tmp11_, "") == 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			const gchar* _tmp12_ = NULL;
			FolksPersonaStore* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			_tmp12_ = self->priv->_configured_primary_store_id;
			_tmp13_ = store;
			_tmp14_ = folks_persona_store_get_id (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp6_ = g_strcmp0 (_tmp12_, _tmp15_) == 0;
		}
		if (_tmp6_) {
			FolksPersonaStore* _tmp16_ = NULL;
			FolksPersonaStore* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			FolksPersonaStore* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			FolksPersonaStore* previous_store = NULL;
			FolksPersonaStore* _tmp23_ = NULL;
			FolksPersonaStore* _tmp24_ = NULL;
			FolksPersonaStore* _tmp25_ = NULL;
			FolksPersonaStore* _tmp26_ = NULL;
			FolksPersonaStore* _tmp27_ = NULL;
			FolksPersonaStore* _tmp30_ = NULL;
			FolksPersonaStore* _tmp31_ = NULL;
			FolksPersonaStore* _tmp33_ = NULL;
			_tmp16_ = store;
			_tmp17_ = store;
			_tmp18_ = folks_persona_store_get_type_id (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = store;
			_tmp21_ = folks_persona_store_get_id (_tmp20_);
			_tmp22_ = _tmp21_;
			g_debug ("individual-aggregator.vala:974: Setting primary store to %p (type ID: " \
"%s, ID: %s)", _tmp16_, _tmp19_, _tmp22_);
			_tmp23_ = self->priv->_primary_store;
			_tmp24_ = _g_object_ref0 (_tmp23_);
			previous_store = _tmp24_;
			_tmp25_ = store;
			self->priv->_primary_store = _tmp25_;
			_tmp26_ = store;
			g_object_freeze_notify ((GObject*) _tmp26_);
			_tmp27_ = previous_store;
			if (_tmp27_ != NULL) {
				FolksPersonaStore* _tmp28_ = NULL;
				FolksPersonaStore* _tmp29_ = NULL;
				_tmp28_ = previous_store;
				g_object_freeze_notify ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
				_tmp29_ = previous_store;
				folks_persona_store_set_is_primary_store (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), FALSE);
			}
			_tmp30_ = store;
			folks_persona_store_set_is_primary_store (_tmp30_, TRUE);
			_tmp31_ = previous_store;
			if (_tmp31_ != NULL) {
				FolksPersonaStore* _tmp32_ = NULL;
				_tmp32_ = previous_store;
				g_object_thaw_notify ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
			}
			_tmp33_ = store;
			g_object_thaw_notify ((GObject*) _tmp33_);
			g_object_notify ((GObject*) self, "primary-store");
			_g_object_unref0 (previous_store);
		}
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data4_->self;
		_g_free0 (_data4_->store_id);
		_g_object_unref0 (_data4_->store);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_folks_individual_aggregator_personas_changed_cb ((FolksIndividualAggregator*) self, _sender, added, removed, message, actor, reason);
}


static void __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_is_primary_store_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static void __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_store_is_quiescent_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static void __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_store_is_user_set_default_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static void __lambda69_ (Block4Data* _data4_, GObject* obj, GAsyncResult* _result_) {
	FolksIndividualAggregator* self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (_result_ != NULL);
	{
		FolksPersonaStore* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data4_->store;
		_tmp1_ = _result_;
		folks_persona_store_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Error preparing persona store '%s': %s");
		_tmp3_ = _data4_->store_id;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp2_, _tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda69__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda69_ (self, source_object, res);
	block4_data_unref (self);
}


static void _folks_individual_aggregator_backend_persona_store_added_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	Block4Data* _data4_;
	FolksPersonaStore* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksBackend* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	FolksPersonaStore* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	FolksPersonaStore* _tmp8_ = NULL;
	FolksPersonaStore* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FolksPersonaStore* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	FolksPersonaStore* _tmp16_ = NULL;
	FolksPersonaStore* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	FolksPersonaStore* _tmp20_ = NULL;
	FolksPersonaStore* _tmp21_ = NULL;
	FolksPersonaStore* _tmp22_ = NULL;
	FolksPersonaStore* _tmp23_ = NULL;
	FolksPersonaStore* _tmp24_ = NULL;
	FolksPersonaStore* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	FolksPersonaStore* _tmp31_ = NULL;
	GeeMap* _tmp32_ = NULL;
	GeeMap* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	FolksPersonaStore* _tmp55_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->store);
	_data4_->store = _tmp1_;
	_tmp2_ = backend;
	_tmp3_ = folks_backend_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _data4_->store;
	_tmp6_ = folks_persona_store_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _data4_->store;
	g_debug ("individual-aggregator.vala:999: _backend_persona_store_added_cb(): bac" \
"kend: %s, store: %s (%p)", _tmp4_, _tmp7_, _tmp8_);
	_tmp9_ = _data4_->store;
	_tmp10_ = folks_persona_store_get_type_id (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _data4_->store;
	_tmp13_ = folks_persona_store_get_id (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _folks_individual_aggregator_get_store_full_id (self, _tmp11_, _tmp14_);
	_data4_->store_id = _tmp15_;
	_tmp16_ = _data4_->store;
	_folks_individual_aggregator_maybe_configure_as_primary (self, _tmp16_);
	_tmp17_ = _data4_->store;
	_folks_individual_aggregator_set_primary_store (self, _tmp17_);
	_tmp18_ = self->priv->_stores;
	_tmp19_ = _data4_->store_id;
	_tmp20_ = _data4_->store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = _data4_->store;
	g_signal_connect_object (_tmp21_, "personas-changed", (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	_tmp22_ = _data4_->store;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::is-primary-store", (GCallback) __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify, self, 0);
	_tmp23_ = _data4_->store;
	g_signal_connect_object ((GObject*) _tmp23_, "notify::is-quiescent", (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self, 0);
	_tmp24_ = _data4_->store;
	g_signal_connect_object ((GObject*) _tmp24_, "notify::is-user-set-default", (GCallback) __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify, self, 0);
	_tmp25_ = _data4_->store;
	_tmp26_ = folks_persona_store_get_is_quiescent (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == FALSE) {
		guint _tmp28_ = 0U;
		guint _tmp29_ = 0U;
		_tmp28_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp28_ + 1;
		_tmp29_ = self->priv->_quiescent_timeout_id;
		if (_tmp29_ == ((guint) 0)) {
			guint _tmp30_ = 0U;
			_tmp30_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, FOLKS_INDIVIDUAL_AGGREGATOR__QUIESCENT_TIMEOUT, __folks_individual_aggregator_quiescent_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
			self->priv->_quiescent_timeout_id = _tmp30_;
		}
	}
	_tmp31_ = _data4_->store;
	_tmp32_ = folks_persona_store_get_personas (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = gee_map_get_size (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ > 0) {
		GeeHashSet* persona_set = NULL;
		GeeHashSet* _tmp36_ = NULL;
		FolksPersonaStore* _tmp51_ = NULL;
		GeeHashSet* _tmp52_ = NULL;
		FolksSmallSet* _tmp53_ = NULL;
		FolksSmallSet* _tmp54_ = NULL;
		_tmp36_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		persona_set = _tmp36_;
		{
			GeeIterator* _p_it = NULL;
			FolksPersonaStore* _tmp37_ = NULL;
			GeeMap* _tmp38_ = NULL;
			GeeMap* _tmp39_ = NULL;
			GeeCollection* _tmp40_ = NULL;
			GeeCollection* _tmp41_ = NULL;
			GeeCollection* _tmp42_ = NULL;
			GeeIterator* _tmp43_ = NULL;
			GeeIterator* _tmp44_ = NULL;
			_tmp37_ = _data4_->store;
			_tmp38_ = folks_persona_store_get_personas (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = gee_map_get_values (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _tmp41_;
			_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
			_tmp44_ = _tmp43_;
			_g_object_unref0 (_tmp42_);
			_p_it = _tmp44_;
			while (TRUE) {
				GeeIterator* _tmp45_ = NULL;
				gboolean _tmp46_ = FALSE;
				FolksPersona* p = NULL;
				GeeIterator* _tmp47_ = NULL;
				gpointer _tmp48_ = NULL;
				GeeHashSet* _tmp49_ = NULL;
				FolksPersona* _tmp50_ = NULL;
				_tmp45_ = _p_it;
				_tmp46_ = gee_iterator_next (_tmp45_);
				if (!_tmp46_) {
					break;
				}
				_tmp47_ = _p_it;
				_tmp48_ = gee_iterator_get (_tmp47_);
				p = (FolksPersona*) _tmp48_;
				_tmp49_ = persona_set;
				_tmp50_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		_tmp51_ = _data4_->store;
		_tmp52_ = persona_set;
		_tmp53_ = folks_small_set_empty (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref);
		_tmp54_ = _tmp53_;
		_folks_individual_aggregator_personas_changed_cb (self, _tmp51_, (GeeSet*) _tmp52_, (GeeSet*) _tmp54_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (_tmp54_);
		_g_object_unref0 (persona_set);
	}
	_tmp55_ = _data4_->store;
	folks_persona_store_prepare (_tmp55_, ___lambda69__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void _folks_individual_aggregator_backend_persona_store_removed_cb (FolksIndividualAggregator* self, FolksBackend* backend, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	FolksPersonaStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GQuark _tmp4_ = 0U;
	FolksPersonaStore* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GQuark _tmp7_ = 0U;
	FolksPersonaStore* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GQuark _tmp10_ = 0U;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GeeHashSet* removed_personas = NULL;
	GeeHashSet* _tmp17_ = NULL;
	GeeMapIterator* iter = NULL;
	FolksPersonaStore* _tmp18_ = NULL;
	GeeMap* _tmp19_ = NULL;
	GeeMap* _tmp20_ = NULL;
	GeeMapIterator* _tmp21_ = NULL;
	FolksPersonaStore* _tmp28_ = NULL;
	FolksSmallSet* _tmp29_ = NULL;
	FolksSmallSet* _tmp30_ = NULL;
	GeeHashSet* _tmp31_ = NULL;
	FolksPersonaStore* _tmp32_ = NULL;
	FolksPersonaStore* _tmp33_ = NULL;
	GeeHashMap* _tmp41_ = NULL;
	FolksPersonaStore* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	FolksPersonaStore* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("personas-changed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_individual_aggregator_personas_changed_cb_folks_persona_store_personas_changed, self);
	_tmp2_ = store;
	g_signal_parse_name ("notify::is-quiescent", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) __folks_individual_aggregator_persona_store_is_quiescent_changed_cb_g_object_notify, self);
	_tmp5_ = store;
	g_signal_parse_name ("notify::is-primary-store", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) __folks_individual_aggregator_is_primary_store_changed_cb_g_object_notify, self);
	_tmp8_ = store;
	g_signal_parse_name ("notify::is-user-set-default", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) __folks_individual_aggregator_persona_store_is_user_set_default_changed_cb_g_object_notify, self);
	_tmp12_ = self->priv->_is_quiescent;
	if (_tmp12_ == FALSE) {
		FolksPersonaStore* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = store;
		_tmp14_ = folks_persona_store_get_is_quiescent (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ == FALSE;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		guint _tmp16_ = 0U;
		_tmp16_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp16_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
	_tmp17_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_personas = _tmp17_;
	_tmp18_ = store;
	_tmp19_ = folks_persona_store_get_personas (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_map_map_iterator (_tmp20_);
	iter = _tmp21_;
	while (TRUE) {
		GeeMapIterator* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		GeeHashSet* _tmp24_ = NULL;
		GeeMapIterator* _tmp25_ = NULL;
		gpointer _tmp26_ = NULL;
		FolksPersona* _tmp27_ = NULL;
		_tmp22_ = iter;
		_tmp23_ = gee_map_iterator_next (_tmp22_);
		if (!(_tmp23_ == TRUE)) {
			break;
		}
		_tmp24_ = removed_personas;
		_tmp25_ = iter;
		_tmp26_ = gee_map_iterator_get_value (_tmp25_);
		_tmp27_ = (FolksPersona*) _tmp26_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp27_);
		_g_object_unref0 (_tmp27_);
	}
	_tmp28_ = store;
	_tmp29_ = folks_small_set_empty (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_tmp30_ = _tmp29_;
	_tmp31_ = removed_personas;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp28_, (GeeSet*) _tmp30_, (GeeSet*) _tmp31_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (_tmp30_);
	_tmp32_ = self->priv->_primary_store;
	_tmp33_ = store;
	if (_tmp32_ == _tmp33_) {
		FolksPersonaStore* _tmp34_ = NULL;
		FolksPersonaStore* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		FolksPersonaStore* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		_tmp34_ = store;
		_tmp35_ = store;
		_tmp36_ = folks_persona_store_get_type_id (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = store;
		_tmp39_ = folks_persona_store_get_id (_tmp38_);
		_tmp40_ = _tmp39_;
		g_debug ("Unsetting primary store as store %p (type ID: %s, ID: %s) " "has been removed", _tmp34_, _tmp37_, _tmp40_);
		self->priv->_primary_store = NULL;
		g_object_notify ((GObject*) self, "primary-store");
	}
	_tmp41_ = self->priv->_stores;
	_tmp42_ = store;
	_tmp43_ = folks_persona_store_get_type_id (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = store;
	_tmp46_ = folks_persona_store_get_id (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = _folks_individual_aggregator_get_store_full_id (self, _tmp44_, _tmp47_);
	_tmp49_ = _tmp48_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp41_, _tmp49_, NULL);
	_g_free0 (_tmp49_);
	_g_object_unref0 (iter);
	_g_object_unref0 (removed_personas);
}


static gchar* _folks_individual_aggregator_get_store_full_id (FolksIndividualAggregator* self, const gchar* type_id, const gchar* id) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = type_id;
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = id;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	result = _tmp5_;
	return result;
}


static void _folks_individual_aggregator_emit_individuals_changed (FolksIndividualAggregator* self, GeeSet* added, GeeSet* removed, GeeMultiMap* changes, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeSet* _added = NULL;
	GeeSet* _removed = NULL;
	GeeMultiMap* _changes = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeSet* _tmp3_ = NULL;
	GeeSet* _tmp17_ = NULL;
	GeeSet* _tmp18_ = NULL;
	GeeSet* _tmp22_ = NULL;
	GeeSet* _tmp23_ = NULL;
	GeeSet* _tmp24_ = NULL;
	GeeSet* _tmp28_ = NULL;
	GeeMultiMap* _tmp29_ = NULL;
	FolksDebug* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	GeeSet* _tmp85_ = NULL;
	GeeSet* _tmp86_ = NULL;
	GeeSet* _tmp87_ = NULL;
	GeeSet* _tmp88_ = NULL;
	GeeSet* _tmp89_ = NULL;
	GeeSet* _tmp90_ = NULL;
	GeeSet* _tmp91_ = NULL;
	GeeSet* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	FolksPersona* _tmp94_ = NULL;
	FolksGroupDetailsChangeReason _tmp95_ = 0;
	GeeMultiMap* _tmp96_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp3_ = added;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GeeSet* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = added;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet));
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == 0;
	}
	if (_tmp2_) {
		gboolean _tmp7_ = FALSE;
		GeeSet* _tmp8_ = NULL;
		_tmp8_ = removed;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeSet* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			_tmp9_ = removed;
			_tmp10_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_SET, GeeSet));
			_tmp11_ = _tmp10_;
			_tmp7_ = _tmp11_ == 0;
		}
		_tmp1_ = _tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp12_ = FALSE;
		GeeMultiMap* _tmp13_ = NULL;
		_tmp13_ = changes;
		if (_tmp13_ == NULL) {
			_tmp12_ = TRUE;
		} else {
			GeeMultiMap* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_tmp14_ = changes;
			_tmp15_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == 0;
		}
		_tmp0_ = _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_g_object_unref0 (_changes);
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	}
	folks_internal_profiling_point ("%s", "emitting " "IndividualAggregator::individuals-changed");
	_tmp18_ = added;
	if (_tmp18_ != NULL) {
		GeeSet* _tmp19_ = NULL;
		GeeSet* _tmp20_ = NULL;
		_tmp19_ = added;
		_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_SET, GeeSet));
		_g_object_unref0 (_tmp17_);
		_tmp17_ = _tmp20_;
	} else {
		FolksSmallSet* _tmp21_ = NULL;
		_tmp21_ = folks_small_set_empty (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref);
		_g_object_unref0 (_tmp17_);
		_tmp17_ = (GeeSet*) _tmp21_;
	}
	_tmp22_ = _g_object_ref0 (_tmp17_);
	_g_object_unref0 (_added);
	_added = _tmp22_;
	_tmp24_ = removed;
	if (_tmp24_ != NULL) {
		GeeSet* _tmp25_ = NULL;
		GeeSet* _tmp26_ = NULL;
		_tmp25_ = removed;
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_SET, GeeSet));
		_g_object_unref0 (_tmp23_);
		_tmp23_ = _tmp26_;
	} else {
		FolksSmallSet* _tmp27_ = NULL;
		_tmp27_ = folks_small_set_empty (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref);
		_g_object_unref0 (_tmp23_);
		_tmp23_ = (GeeSet*) _tmp27_;
	}
	_tmp28_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (_removed);
	_removed = _tmp28_;
	_tmp29_ = changes;
	if (_tmp29_ != NULL) {
		GeeMultiMap* _tmp30_ = NULL;
		GeeMultiMap* _tmp31_ = NULL;
		_tmp30_ = changes;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_g_object_unref0 (_changes);
		_changes = _tmp31_;
	} else {
		GeeHashMultiMap* _tmp32_ = NULL;
		_tmp32_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (_changes);
		_changes = (GeeMultiMap*) _tmp32_;
	}
	_tmp33_ = self->priv->_debug;
	_tmp34_ = folks_debug_get_debug_output_enabled (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ == TRUE) {
		GeeMultiMap* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		GeeMapIterator* iter = NULL;
		GeeMultiMap* _tmp39_ = NULL;
		GeeMapIterator* _tmp40_ = NULL;
		_tmp36_ = _changes;
		_tmp37_ = gee_multi_map_get_size (_tmp36_);
		_tmp38_ = _tmp37_;
		g_debug ("individual-aggregator.vala:1162: Emitting individuals-changed-detailed" \
" with %u mappings:", (guint) _tmp38_);
		_tmp39_ = _changes;
		_tmp40_ = gee_multi_map_map_iterator (_tmp39_);
		iter = _tmp40_;
		while (TRUE) {
			GeeMapIterator* _tmp41_ = NULL;
			gboolean _tmp42_ = FALSE;
			FolksIndividual* removed_ind = NULL;
			GeeMapIterator* _tmp43_ = NULL;
			gpointer _tmp44_ = NULL;
			FolksIndividual* added_ind = NULL;
			GeeMapIterator* _tmp45_ = NULL;
			gpointer _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			FolksIndividual* _tmp48_ = NULL;
			const gchar* _tmp52_ = NULL;
			FolksIndividual* _tmp53_ = NULL;
			FolksIndividual* _tmp57_ = NULL;
			FolksIndividual* _tmp58_ = NULL;
			FolksIndividual* _tmp59_ = NULL;
			FolksIndividual* _tmp72_ = NULL;
			_tmp41_ = iter;
			_tmp42_ = gee_map_iterator_next (_tmp41_);
			if (!_tmp42_) {
				break;
			}
			_tmp43_ = iter;
			_tmp44_ = gee_map_iterator_get_key (_tmp43_);
			removed_ind = (FolksIndividual*) _tmp44_;
			_tmp45_ = iter;
			_tmp46_ = gee_map_iterator_get_value (_tmp45_);
			added_ind = (FolksIndividual*) _tmp46_;
			_tmp48_ = removed_ind;
			if (_tmp48_ != NULL) {
				FolksIndividual* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				_tmp49_ = removed_ind;
				_tmp50_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp51_ = _tmp50_;
				_tmp47_ = _tmp51_;
			} else {
				_tmp47_ = "";
			}
			_tmp53_ = added_ind;
			if (_tmp53_ != NULL) {
				FolksIndividual* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				_tmp54_ = added_ind;
				_tmp55_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp56_ = _tmp55_;
				_tmp52_ = _tmp56_;
			} else {
				_tmp52_ = "";
			}
			_tmp57_ = removed_ind;
			_tmp58_ = added_ind;
			g_debug ("individual-aggregator.vala:1172:     %s (%p) → %s (%p)", _tmp47_, _tmp57_, _tmp52_, _tmp58_);
			_tmp59_ = removed_ind;
			if (_tmp59_ != NULL) {
				g_debug ("individual-aggregator.vala:1179:       Removed individual's personas:");
				{
					GeeIterator* _p_it = NULL;
					FolksIndividual* _tmp60_ = NULL;
					GeeSet* _tmp61_ = NULL;
					GeeSet* _tmp62_ = NULL;
					GeeIterator* _tmp63_ = NULL;
					_tmp60_ = removed_ind;
					_tmp61_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
					_tmp62_ = _tmp61_;
					_tmp63_ = gee_iterable_iterator ((GeeIterable*) _tmp62_);
					_p_it = _tmp63_;
					while (TRUE) {
						GeeIterator* _tmp64_ = NULL;
						gboolean _tmp65_ = FALSE;
						FolksPersona* p = NULL;
						GeeIterator* _tmp66_ = NULL;
						gpointer _tmp67_ = NULL;
						FolksPersona* _tmp68_ = NULL;
						const gchar* _tmp69_ = NULL;
						const gchar* _tmp70_ = NULL;
						FolksPersona* _tmp71_ = NULL;
						_tmp64_ = _p_it;
						_tmp65_ = gee_iterator_next (_tmp64_);
						if (!_tmp65_) {
							break;
						}
						_tmp66_ = _p_it;
						_tmp67_ = gee_iterator_get (_tmp66_);
						p = (FolksPersona*) _tmp67_;
						_tmp68_ = p;
						_tmp69_ = folks_persona_get_uid (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = p;
						g_debug ("individual-aggregator.vala:1183:         %s (%p)", _tmp70_, _tmp71_);
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
			}
			_tmp72_ = added_ind;
			if (_tmp72_ != NULL) {
				g_debug ("individual-aggregator.vala:1189:       Added individual's personas:");
				{
					GeeIterator* _p_it = NULL;
					FolksIndividual* _tmp73_ = NULL;
					GeeSet* _tmp74_ = NULL;
					GeeSet* _tmp75_ = NULL;
					GeeIterator* _tmp76_ = NULL;
					_tmp73_ = added_ind;
					_tmp74_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
					_tmp75_ = _tmp74_;
					_tmp76_ = gee_iterable_iterator ((GeeIterable*) _tmp75_);
					_p_it = _tmp76_;
					while (TRUE) {
						GeeIterator* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						FolksPersona* p = NULL;
						GeeIterator* _tmp79_ = NULL;
						gpointer _tmp80_ = NULL;
						FolksPersona* _tmp81_ = NULL;
						const gchar* _tmp82_ = NULL;
						const gchar* _tmp83_ = NULL;
						FolksPersona* _tmp84_ = NULL;
						_tmp77_ = _p_it;
						_tmp78_ = gee_iterator_next (_tmp77_);
						if (!_tmp78_) {
							break;
						}
						_tmp79_ = _p_it;
						_tmp80_ = gee_iterator_get (_tmp79_);
						p = (FolksPersona*) _tmp80_;
						_tmp81_ = p;
						_tmp82_ = folks_persona_get_uid (_tmp81_);
						_tmp83_ = _tmp82_;
						_tmp84_ = p;
						g_debug ("individual-aggregator.vala:1193:         %s (%p)", _tmp83_, _tmp84_);
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
			}
			_g_object_unref0 (added_ind);
			_g_object_unref0 (removed_ind);
		}
		_g_object_unref0 (iter);
	}
	_tmp85_ = _added;
	_tmp86_ = gee_set_get_read_only_view (_tmp85_);
	_tmp87_ = _tmp86_;
	_tmp88_ = _tmp87_;
	_tmp89_ = _removed;
	_tmp90_ = gee_set_get_read_only_view (_tmp89_);
	_tmp91_ = _tmp90_;
	_tmp92_ = _tmp91_;
	_tmp93_ = message;
	_tmp94_ = actor;
	_tmp95_ = reason;
	g_signal_emit_by_name (self, "individuals-changed", _tmp88_, _tmp92_, _tmp93_, _tmp94_, _tmp95_);
	_g_object_unref0 (_tmp92_);
	_g_object_unref0 (_tmp88_);
	_tmp96_ = _changes;
	g_signal_emit_by_name (self, "individuals-changed-detailed", _tmp96_);
	_g_object_unref0 (_tmp23_);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_changes);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}


static void __folks_individual_aggregator_individual_removed_cb_folks_individual_removed (FolksIndividual* _sender, FolksIndividual* replacement_individual, gpointer self) {
	_folks_individual_aggregator_individual_removed_cb ((FolksIndividualAggregator*) self, _sender, replacement_individual);
}


static void _folks_individual_aggregator_connect_to_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	FolksIndividual* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	FolksIndividual* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	g_signal_connect_object (_tmp0_, "removed", (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self, 0);
	_tmp1_ = self->priv->_individuals;
	_tmp2_ = individual;
	_tmp3_ = folks_individual_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = individual;
	gee_map_set (_tmp1_, _tmp4_, _tmp5_);
}


static void _folks_individual_aggregator_disconnect_from_individual (FolksIndividualAggregator* self, FolksIndividual* individual) {
	GeeMap* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksIndividual* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = self->priv->_individuals;
	_tmp1_ = individual;
	_tmp2_ = folks_individual_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	gee_map_unset (_tmp0_, _tmp3_, NULL);
	_tmp4_ = individual;
	g_signal_parse_name ("removed", FOLKS_TYPE_INDIVIDUAL, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __folks_individual_aggregator_individual_removed_cb_folks_individual_removed, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->candidate_inds);
		_g_object_unref0 (_data5_->persona);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data6_->_data5_->self;
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static void _______lambda67_ (Block6Data* _data6_, const gchar* l) {
	Block5Data* _data5_;
	FolksIndividualAggregator* self;
	const gchar* prop_linking_value = NULL;
	const gchar* _tmp0_ = NULL;
	GPtrArray* candidates = NULL;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	prop_linking_value = _tmp0_;
	_tmp1_ = self->priv->_link_map;
	_tmp2_ = prop_linking_value;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	candidates = (GPtrArray*) _tmp3_;
	_tmp4_ = candidates;
	if (_tmp4_ != NULL) {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					guint _tmp7_ = 0U;
					GPtrArray* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					FolksIndividual* candidate_ind = NULL;
					GPtrArray* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					gconstpointer _tmp13_ = NULL;
					FolksIndividual* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					gboolean _tmp16_ = FALSE;
					FolksIndividual* _tmp17_ = NULL;
					FolksTrustLevel _tmp18_ = 0;
					FolksTrustLevel _tmp19_ = 0;
					if (!_tmp5_) {
						guint _tmp6_ = 0U;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = candidates;
					_tmp9_ = g_ptr_array_get_length ((GPtrArray*) _tmp8_);
					_tmp10_ = _tmp9_;
					if (!(_tmp7_ < ((guint) _tmp10_))) {
						break;
					}
					_tmp11_ = candidates;
					_tmp12_ = i;
					_tmp13_ = g_ptr_array_index ((GPtrArray*) _tmp11_, _tmp12_);
					_tmp14_ = _g_object_ref0 ((FolksIndividual*) _tmp13_);
					candidate_ind = _tmp14_;
					_tmp17_ = candidate_ind;
					_tmp18_ = folks_individual_get_trust_level (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ != FOLKS_TRUST_LEVEL_NONE) {
						FolksIndividual* _tmp20_ = NULL;
						FolksPersona* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						_tmp20_ = candidate_ind;
						_tmp21_ = _data5_->persona;
						_tmp22_ = folks_individual_has_anti_link_with_persona (_tmp20_, _tmp21_);
						_tmp16_ = _tmp22_ == FALSE;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						GeeHashSet* _tmp23_ = NULL;
						FolksIndividual* _tmp24_ = NULL;
						gboolean _tmp25_ = FALSE;
						_tmp23_ = _data5_->candidate_inds;
						_tmp24_ = candidate_ind;
						_tmp25_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
						_tmp15_ = _tmp25_;
					} else {
						_tmp15_ = FALSE;
					}
					if (_tmp15_) {
						FolksIndividual* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						const gchar* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						_tmp26_ = candidate_ind;
						_tmp27_ = folks_individual_get_id (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = _data6_->prop_name;
						_tmp30_ = prop_linking_value;
						g_debug ("    Found candidate individual '%s'" " by linkable property '%s' = '%s'.", _tmp28_, _tmp29_, _tmp30_);
					}
					_g_object_unref0 (candidate_ind);
				}
			}
		}
	}
}


static void ________lambda67__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_______lambda67_ (self, link);
}


static void _folks_individual_aggregator_add_personas (FolksIndividualAggregator* self, GeeSet* added, FolksIndividual** user, GeeHashMultiMap** individuals_changes) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (*individuals_changes != NULL);
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_persona_it = _tmp1_;
		while (TRUE) {
			Block5Data* _data5_;
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			FolksPersonaStoreTrust trust_level = 0;
			FolksPersona* _tmp6_ = NULL;
			FolksPersonaStore* _tmp7_ = NULL;
			FolksPersonaStore* _tmp8_ = NULL;
			FolksPersonaStoreTrust _tmp9_ = 0;
			FolksPersonaStoreTrust _tmp10_ = 0;
			GeeHashSet* _tmp11_ = NULL;
			GeeHashSet* final_personas = NULL;
			GeeHashSet* _tmp12_ = NULL;
			FolksPersona* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			FolksPersona* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gboolean _tmp71_ = FALSE;
			gboolean _tmp72_ = FALSE;
			GeeHashSet* _tmp92_ = NULL;
			FolksPersona* _tmp93_ = NULL;
			gboolean _tmp94_ = FALSE;
			gboolean _tmp95_ = FALSE;
			gboolean _tmp99_ = FALSE;
			GeeHashSet* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			gint _tmp102_ = 0;
			FolksIndividual* final_individual = NULL;
			GeeHashSet* _tmp115_ = NULL;
			FolksIndividual* _tmp116_ = NULL;
			FolksIndividual* _tmp117_ = NULL;
			const gchar* _tmp118_ = NULL;
			const gchar* _tmp119_ = NULL;
			FolksIndividual* _tmp120_ = NULL;
			guint num_mappings_added = 0U;
			guint _tmp176_ = 0U;
			FolksIndividual* _tmp179_ = NULL;
			gboolean _tmp180_ = FALSE;
			gboolean _tmp181_ = FALSE;
			_data5_ = g_slice_new0 (Block5Data);
			_data5_->_ref_count_ = 1;
			_data5_->self = g_object_ref (self);
			_tmp2_ = _persona_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				block5_data_unref (_data5_);
				_data5_ = NULL;
				break;
			}
			_tmp4_ = _persona_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			_data5_->persona = (FolksPersona*) _tmp5_;
			_tmp6_ = _data5_->persona;
			_tmp7_ = folks_persona_get_store (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_persona_store_get_trust_level (_tmp8_);
			_tmp10_ = _tmp9_;
			trust_level = _tmp10_;
			_tmp11_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_data5_->candidate_inds = _tmp11_;
			_tmp12_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			final_personas = _tmp12_;
			_tmp13_ = _data5_->persona;
			_tmp14_ = folks_persona_get_uid (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _data5_->persona;
			_tmp17_ = folks_persona_get_iid (_tmp16_);
			_tmp18_ = _tmp17_;
			g_debug ("individual-aggregator.vala:1235: Aggregating persona '%s' on '%s'.", _tmp15_, _tmp18_);
			_tmp22_ = self->priv->_linking_enabled;
			if (_tmp22_ == TRUE) {
				FolksPersona* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				_tmp23_ = _data5_->persona;
				_tmp24_ = folks_persona_get_is_user (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp21_ = _tmp25_ == TRUE;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				FolksIndividual* _tmp26_ = NULL;
				_tmp26_ = *user;
				_tmp20_ = _tmp26_ != NULL;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				FolksIndividual* _tmp27_ = NULL;
				FolksPersona* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				_tmp27_ = *user;
				_tmp28_ = _data5_->persona;
				_tmp29_ = folks_individual_has_anti_link_with_persona (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual), _tmp28_);
				_tmp19_ = _tmp29_ == FALSE;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				FolksIndividual* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				GeeHashSet* _tmp33_ = NULL;
				FolksIndividual* _tmp34_ = NULL;
				_tmp30_ = *user;
				_tmp31_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp32_ = _tmp31_;
				g_debug ("individual-aggregator.vala:1243:     Found candidate individual '%s' a" \
"s user.", _tmp32_);
				_tmp33_ = _data5_->candidate_inds;
				_tmp34_ = *user;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp36_ = self->priv->_linking_enabled;
			if (_tmp36_ == TRUE) {
				FolksPersonaStoreTrust _tmp37_ = 0;
				_tmp37_ = trust_level;
				_tmp35_ = _tmp37_ != FOLKS_PERSONA_STORE_TRUST_NONE;
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				GPtrArray* candidates = NULL;
				GHashTable* _tmp38_ = NULL;
				FolksPersona* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gconstpointer _tmp42_ = NULL;
				GPtrArray* _tmp43_ = NULL;
				_tmp38_ = self->priv->_link_map;
				_tmp39_ = _data5_->persona;
				_tmp40_ = folks_persona_get_iid (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_hash_table_lookup (_tmp38_, _tmp41_);
				candidates = (GPtrArray*) _tmp42_;
				_tmp43_ = candidates;
				if (_tmp43_ != NULL) {
					{
						guint i = 0U;
						i = (guint) 0;
						{
							gboolean _tmp44_ = FALSE;
							_tmp44_ = TRUE;
							while (TRUE) {
								guint _tmp46_ = 0U;
								GPtrArray* _tmp47_ = NULL;
								gint _tmp48_ = 0;
								gint _tmp49_ = 0;
								FolksIndividual* candidate_ind = NULL;
								GPtrArray* _tmp50_ = NULL;
								guint _tmp51_ = 0U;
								gconstpointer _tmp52_ = NULL;
								FolksIndividual* _tmp53_ = NULL;
								gboolean _tmp54_ = FALSE;
								gboolean _tmp55_ = FALSE;
								FolksIndividual* _tmp56_ = NULL;
								FolksTrustLevel _tmp57_ = 0;
								FolksTrustLevel _tmp58_ = 0;
								if (!_tmp44_) {
									guint _tmp45_ = 0U;
									_tmp45_ = i;
									i = _tmp45_ + 1;
								}
								_tmp44_ = FALSE;
								_tmp46_ = i;
								_tmp47_ = candidates;
								_tmp48_ = g_ptr_array_get_length ((GPtrArray*) _tmp47_);
								_tmp49_ = _tmp48_;
								if (!(_tmp46_ < ((guint) _tmp49_))) {
									break;
								}
								_tmp50_ = candidates;
								_tmp51_ = i;
								_tmp52_ = g_ptr_array_index ((GPtrArray*) _tmp50_, _tmp51_);
								_tmp53_ = _g_object_ref0 ((FolksIndividual*) _tmp52_);
								candidate_ind = _tmp53_;
								_tmp56_ = candidate_ind;
								_tmp57_ = folks_individual_get_trust_level (_tmp56_);
								_tmp58_ = _tmp57_;
								if (_tmp58_ != FOLKS_TRUST_LEVEL_NONE) {
									FolksIndividual* _tmp59_ = NULL;
									FolksPersona* _tmp60_ = NULL;
									gboolean _tmp61_ = FALSE;
									_tmp59_ = candidate_ind;
									_tmp60_ = _data5_->persona;
									_tmp61_ = folks_individual_has_anti_link_with_persona (_tmp59_, _tmp60_);
									_tmp55_ = _tmp61_ == FALSE;
								} else {
									_tmp55_ = FALSE;
								}
								if (_tmp55_) {
									GeeHashSet* _tmp62_ = NULL;
									FolksIndividual* _tmp63_ = NULL;
									gboolean _tmp64_ = FALSE;
									_tmp62_ = _data5_->candidate_inds;
									_tmp63_ = candidate_ind;
									_tmp64_ = gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp63_);
									_tmp54_ = _tmp64_;
								} else {
									_tmp54_ = FALSE;
								}
								if (_tmp54_) {
									FolksIndividual* _tmp65_ = NULL;
									const gchar* _tmp66_ = NULL;
									const gchar* _tmp67_ = NULL;
									FolksPersona* _tmp68_ = NULL;
									const gchar* _tmp69_ = NULL;
									const gchar* _tmp70_ = NULL;
									_tmp65_ = candidate_ind;
									_tmp66_ = folks_individual_get_id (_tmp65_);
									_tmp67_ = _tmp66_;
									_tmp68_ = _data5_->persona;
									_tmp69_ = folks_persona_get_iid (_tmp68_);
									_tmp70_ = _tmp69_;
									g_debug ("    Found candidate individual '%s' by " "IID '%s'.", _tmp67_, _tmp70_);
								}
								_g_object_unref0 (candidate_ind);
							}
						}
					}
				}
			}
			_tmp72_ = self->priv->_linking_enabled;
			if (_tmp72_ == TRUE) {
				FolksPersona* _tmp73_ = NULL;
				FolksPersonaStore* _tmp74_ = NULL;
				FolksPersonaStore* _tmp75_ = NULL;
				FolksPersonaStoreTrust _tmp76_ = 0;
				FolksPersonaStoreTrust _tmp77_ = 0;
				_tmp73_ = _data5_->persona;
				_tmp74_ = folks_persona_get_store (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = folks_persona_store_get_trust_level (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp71_ = _tmp77_ == FOLKS_PERSONA_STORE_TRUST_FULL;
			} else {
				_tmp71_ = FALSE;
			}
			if (_tmp71_) {
				FolksPersona* _tmp78_ = NULL;
				gchar** _tmp79_ = NULL;
				gint _tmp79__length1 = 0;
				gchar** _tmp80_ = NULL;
				gint _tmp80__length1 = 0;
				_tmp78_ = _data5_->persona;
				_tmp79_ = folks_persona_get_linkable_properties (_tmp78_, &_tmp79__length1);
				_tmp80_ = _tmp79_;
				_tmp80__length1 = _tmp79__length1;
				{
					gchar** foo_collection = NULL;
					gint foo_collection_length1 = 0;
					gint _foo_collection_size_ = 0;
					gint foo_it = 0;
					foo_collection = _tmp80_;
					foo_collection_length1 = _tmp80__length1;
					for (foo_it = 0; foo_it < _tmp80__length1; foo_it = foo_it + 1) {
						const gchar* foo = NULL;
						foo = foo_collection[foo_it];
						{
							Block6Data* _data6_;
							const gchar* _tmp81_ = NULL;
							const gchar* _tmp82_ = NULL;
							GObjectClass* pclass = NULL;
							FolksPersona* _tmp83_ = NULL;
							GObjectClass* _tmp84_ = NULL;
							GObjectClass* _tmp85_ = NULL;
							const gchar* _tmp86_ = NULL;
							GParamSpec* _tmp87_ = NULL;
							FolksPersona* _tmp90_ = NULL;
							const gchar* _tmp91_ = NULL;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->_data5_ = block5_data_ref (_data5_);
							_tmp81_ = foo;
							if (_tmp81_ == NULL) {
								block6_data_unref (_data6_);
								_data6_ = NULL;
								continue;
							}
							_tmp82_ = foo;
							_data6_->prop_name = _tmp82_;
							_tmp83_ = _data5_->persona;
							_tmp84_ = G_OBJECT_GET_CLASS ((GObject*) _tmp83_);
							pclass = _tmp84_;
							_tmp85_ = pclass;
							_tmp86_ = _data6_->prop_name;
							_tmp87_ = g_object_class_find_property (_tmp85_, _tmp86_);
							if (_tmp87_ == NULL) {
								const gchar* _tmp88_ = NULL;
								const gchar* _tmp89_ = NULL;
								_tmp88_ = _ ("Unknown property '%s' in linkable property list.");
								_tmp89_ = _data6_->prop_name;
								g_warning (_tmp88_, _tmp89_);
								block6_data_unref (_data6_);
								_data6_ = NULL;
								continue;
							}
							_tmp90_ = _data5_->persona;
							_tmp91_ = _data6_->prop_name;
							folks_persona_linkable_property_to_links (_tmp90_, _tmp91_, ________lambda67__folks_persona_linkable_property_callback, _data6_);
							block6_data_unref (_data6_);
							_data6_ = NULL;
						}
					}
				}
			}
			_tmp92_ = final_personas;
			_tmp93_ = _data5_->persona;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp93_);
			_tmp95_ = self->priv->_linking_enabled;
			if (_tmp95_ == TRUE) {
				_tmp94_ = TRUE;
			} else {
				GeeHashSet* _tmp96_ = NULL;
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				_tmp96_ = _data5_->candidate_inds;
				_tmp97_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp96_);
				_tmp98_ = _tmp97_;
				_tmp94_ = _tmp98_ == 0;
			}
			_vala_assert (_tmp94_, "this._linking_enabled == true || candidate_inds.size == 0");
			_tmp100_ = _data5_->candidate_inds;
			_tmp101_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp100_);
			_tmp102_ = _tmp101_;
			if (_tmp102_ > 0) {
				gboolean _tmp103_ = FALSE;
				_tmp103_ = self->priv->_linking_enabled;
				_tmp99_ = _tmp103_ == TRUE;
			} else {
				_tmp99_ = FALSE;
			}
			if (_tmp99_) {
				{
					GeeIterator* _individual_it = NULL;
					GeeHashSet* _tmp104_ = NULL;
					GeeIterator* _tmp105_ = NULL;
					_tmp104_ = _data5_->candidate_inds;
					_tmp105_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp104_);
					_individual_it = _tmp105_;
					while (TRUE) {
						GeeIterator* _tmp106_ = NULL;
						gboolean _tmp107_ = FALSE;
						FolksIndividual* individual = NULL;
						GeeIterator* _tmp108_ = NULL;
						gpointer _tmp109_ = NULL;
						GeeHashSet* _tmp110_ = NULL;
						FolksIndividual* _tmp111_ = NULL;
						GeeSet* _tmp112_ = NULL;
						GeeSet* _tmp113_ = NULL;
						_tmp106_ = _individual_it;
						_tmp107_ = gee_iterator_next (_tmp106_);
						if (!_tmp107_) {
							break;
						}
						_tmp108_ = _individual_it;
						_tmp109_ = gee_iterator_get (_tmp108_);
						individual = (FolksIndividual*) _tmp109_;
						_tmp110_ = final_personas;
						_tmp111_ = individual;
						_tmp112_ = folks_individual_get_personas (_tmp111_);
						_tmp113_ = _tmp112_;
						gee_collection_add_all ((GeeCollection*) _tmp110_, (GeeCollection*) _tmp113_);
						_g_object_unref0 (individual);
					}
					_g_object_unref0 (_individual_it);
				}
			} else {
				gboolean _tmp114_ = FALSE;
				_tmp114_ = self->priv->_linking_enabled;
				if (!_tmp114_) {
					g_debug ("individual-aggregator.vala:1348:     Linking disabled.");
				} else {
					g_debug ("individual-aggregator.vala:1352:     Did not find any candidate indivi" \
"duals.");
				}
			}
			_tmp115_ = final_personas;
			_tmp116_ = folks_individual_new ((GeeSet*) _tmp115_);
			final_individual = _tmp116_;
			_tmp117_ = final_individual;
			_tmp118_ = folks_individual_get_id (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = final_individual;
			g_debug ("individual-aggregator.vala:1357:     Created new individual '%s' (%p) " \
"with personas:", _tmp119_, _tmp120_);
			{
				GeeIterator* _p_it = NULL;
				GeeHashSet* _tmp121_ = NULL;
				GeeIterator* _tmp122_ = NULL;
				_tmp121_ = final_personas;
				_tmp122_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp121_);
				_p_it = _tmp122_;
				while (TRUE) {
					GeeIterator* _tmp123_ = NULL;
					gboolean _tmp124_ = FALSE;
					FolksPersona* p = NULL;
					GeeIterator* _tmp125_ = NULL;
					gpointer _tmp126_ = NULL;
					FolksPersona* _tmp127_ = NULL;
					const gchar* _tmp128_ = NULL;
					const gchar* _tmp129_ = NULL;
					FolksPersona* _tmp130_ = NULL;
					FolksPersona* _tmp131_ = NULL;
					FolksIndividual* _tmp132_ = NULL;
					_tmp123_ = _p_it;
					_tmp124_ = gee_iterator_next (_tmp123_);
					if (!_tmp124_) {
						break;
					}
					_tmp125_ = _p_it;
					_tmp126_ = gee_iterator_get (_tmp125_);
					p = (FolksPersona*) _tmp126_;
					_tmp127_ = p;
					_tmp128_ = folks_persona_get_uid (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = p;
					g_debug ("individual-aggregator.vala:1361:         %s (%p)", _tmp129_, _tmp130_);
					_tmp131_ = p;
					_tmp132_ = final_individual;
					_folks_individual_aggregator_add_persona_to_link_map (self, _tmp131_, _tmp132_);
					_g_object_unref0 (p);
				}
				_g_object_unref0 (_p_it);
			}
			num_mappings_added = (guint) 0;
			{
				GeeIterator* _i_it = NULL;
				GeeHashSet* _tmp133_ = NULL;
				GeeIterator* _tmp134_ = NULL;
				_tmp133_ = _data5_->candidate_inds;
				_tmp134_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp133_);
				_i_it = _tmp134_;
				while (TRUE) {
					GeeIterator* _tmp135_ = NULL;
					gboolean _tmp136_ = FALSE;
					FolksIndividual* i = NULL;
					GeeIterator* _tmp137_ = NULL;
					gpointer _tmp138_ = NULL;
					FolksIndividual* _tmp139_ = NULL;
					GeeHashSet* transitive_updates = NULL;
					GeeHashSet* _tmp140_ = NULL;
					GeeMapIterator* iter = NULL;
					GeeHashMultiMap* _tmp141_ = NULL;
					GeeMapIterator* _tmp142_ = NULL;
					GeeHashSet* _tmp169_ = NULL;
					gint _tmp170_ = 0;
					gint _tmp171_ = 0;
					_tmp135_ = _i_it;
					_tmp136_ = gee_iterator_next (_tmp135_);
					if (!_tmp136_) {
						break;
					}
					_tmp137_ = _i_it;
					_tmp138_ = gee_iterator_get (_tmp137_);
					i = (FolksIndividual*) _tmp138_;
					_tmp139_ = i;
					_folks_individual_aggregator_remove_individual_from_link_map (self, _tmp139_);
					_tmp140_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
					transitive_updates = _tmp140_;
					_tmp141_ = *individuals_changes;
					_tmp142_ = gee_multi_map_map_iterator ((GeeMultiMap*) _tmp141_);
					iter = _tmp142_;
					while (TRUE) {
						GeeMapIterator* _tmp143_ = NULL;
						gboolean _tmp144_ = FALSE;
						FolksIndividual* _tmp145_ = NULL;
						GeeMapIterator* _tmp146_ = NULL;
						gpointer _tmp147_ = NULL;
						FolksIndividual* _tmp148_ = NULL;
						gboolean _tmp149_ = FALSE;
						_tmp143_ = iter;
						_tmp144_ = gee_map_iterator_next (_tmp143_);
						if (!_tmp144_) {
							break;
						}
						_tmp145_ = i;
						_tmp146_ = iter;
						_tmp147_ = gee_map_iterator_get_value (_tmp146_);
						_tmp148_ = (FolksIndividual*) _tmp147_;
						_tmp149_ = _tmp145_ == _tmp148_;
						_g_object_unref0 (_tmp148_);
						if (_tmp149_) {
							GeeHashSet* _tmp150_ = NULL;
							GeeMapIterator* _tmp151_ = NULL;
							gpointer _tmp152_ = NULL;
							FolksIndividual* _tmp153_ = NULL;
							_tmp150_ = transitive_updates;
							_tmp151_ = iter;
							_tmp152_ = gee_map_iterator_get_key (_tmp151_);
							_tmp153_ = (FolksIndividual*) _tmp152_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp150_, _tmp153_);
							_g_object_unref0 (_tmp153_);
						}
					}
					{
						GeeIterator* _k_it = NULL;
						GeeHashSet* _tmp154_ = NULL;
						GeeIterator* _tmp155_ = NULL;
						_tmp154_ = transitive_updates;
						_tmp155_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp154_);
						_k_it = _tmp155_;
						while (TRUE) {
							GeeIterator* _tmp156_ = NULL;
							gboolean _tmp157_ = FALSE;
							FolksIndividual* k = NULL;
							GeeIterator* _tmp158_ = NULL;
							gpointer _tmp159_ = NULL;
							GeeHashMultiMap* _tmp160_ = NULL;
							FolksIndividual* _tmp161_ = NULL;
							FolksIndividual* _tmp162_ = NULL;
							gboolean _tmp163_ = FALSE;
							FolksIndividual* _tmp164_ = NULL;
							_tmp156_ = _k_it;
							_tmp157_ = gee_iterator_next (_tmp156_);
							if (!_tmp157_) {
								break;
							}
							_tmp158_ = _k_it;
							_tmp159_ = gee_iterator_get (_tmp158_);
							k = (FolksIndividual*) _tmp159_;
							_tmp160_ = *individuals_changes;
							_tmp161_ = k;
							_tmp162_ = i;
							_tmp163_ = gee_multi_map_remove ((GeeMultiMap*) _tmp160_, _tmp161_, _tmp162_);
							_vala_assert (_tmp163_ == TRUE, "individuals_changes.remove (k, i) == true");
							_tmp164_ = k;
							if (_tmp164_ != NULL) {
								GeeHashMultiMap* _tmp165_ = NULL;
								FolksIndividual* _tmp166_ = NULL;
								FolksIndividual* _tmp167_ = NULL;
								guint _tmp168_ = 0U;
								_tmp165_ = *individuals_changes;
								_tmp166_ = k;
								_tmp167_ = final_individual;
								gee_multi_map_set ((GeeMultiMap*) _tmp165_, _tmp166_, _tmp167_);
								_tmp168_ = num_mappings_added;
								num_mappings_added = _tmp168_ + 1;
							}
							_g_object_unref0 (k);
						}
						_g_object_unref0 (_k_it);
					}
					_tmp169_ = transitive_updates;
					_tmp170_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp169_);
					_tmp171_ = _tmp170_;
					if (_tmp171_ == 0) {
						GeeHashMultiMap* _tmp172_ = NULL;
						FolksIndividual* _tmp173_ = NULL;
						FolksIndividual* _tmp174_ = NULL;
						guint _tmp175_ = 0U;
						_tmp172_ = *individuals_changes;
						_tmp173_ = i;
						_tmp174_ = final_individual;
						gee_multi_map_set ((GeeMultiMap*) _tmp172_, _tmp173_, _tmp174_);
						_tmp175_ = num_mappings_added;
						num_mappings_added = _tmp175_ + 1;
					}
					_g_object_unref0 (iter);
					_g_object_unref0 (transitive_updates);
					_g_object_unref0 (i);
				}
				_g_object_unref0 (_i_it);
			}
			_tmp176_ = num_mappings_added;
			if (_tmp176_ == ((guint) 0)) {
				GeeHashMultiMap* _tmp177_ = NULL;
				FolksIndividual* _tmp178_ = NULL;
				_tmp177_ = *individuals_changes;
				_tmp178_ = final_individual;
				gee_multi_map_set ((GeeMultiMap*) _tmp177_, NULL, _tmp178_);
			}
			_tmp179_ = final_individual;
			_tmp180_ = folks_individual_get_is_user (_tmp179_);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == TRUE) {
				FolksIndividual* _tmp182_ = NULL;
				FolksIndividual* _tmp183_ = NULL;
				_tmp182_ = final_individual;
				_tmp183_ = _g_object_ref0 (_tmp182_);
				_g_object_unref0 (*user);
				*user = _tmp183_;
			}
			_g_object_unref0 (final_individual);
			_g_object_unref0 (final_personas);
			block5_data_unref (_data5_);
			_data5_ = NULL;
		}
		_g_object_unref0 (_persona_it);
	}
}


static void _folks_individual_aggregator_persona_linkable_property_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	FolksPersona* persona = NULL;
	GObject* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksPersona* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GParamSpec* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	FolksPersona* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FolksPersona* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	FolksSmallSet* persona_set = NULL;
	FolksSmallSet* _tmp15_ = NULL;
	FolksSmallSet* _tmp16_ = NULL;
	FolksPersona* _tmp17_ = NULL;
	FolksPersona* _tmp18_ = NULL;
	FolksPersonaStore* _tmp19_ = NULL;
	FolksPersonaStore* _tmp20_ = NULL;
	FolksSmallSet* _tmp21_ = NULL;
	FolksSmallSet* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_linking_enabled;
	if (_tmp0_ == FALSE) {
		return;
	}
	_tmp1_ = obj;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, FOLKS_TYPE_PERSONA) ? ((FolksPersona*) _tmp1_) : NULL, FOLKS_TYPE_PERSONA, FolksPersona));
	persona = _tmp2_;
	_tmp4_ = persona;
	_tmp5_ = folks_persona_get_is_user (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_tmp3_ = "yes";
	} else {
		_tmp3_ = "no";
	}
	_tmp7_ = pspec;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = persona;
	_tmp10_ = folks_persona_get_uid (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = persona;
	_tmp13_ = folks_persona_get_iid (_tmp12_);
	_tmp14_ = _tmp13_;
	g_debug ("Linkable property '%s' changed for persona '%s' " "(is user: %s, IID: %s).", _tmp8_, _tmp11_, _tmp3_, _tmp14_);
	_tmp15_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	persona_set = _tmp15_;
	_tmp16_ = persona_set;
	_tmp17_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	_tmp18_ = persona;
	_tmp19_ = folks_persona_get_store (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = persona_set;
	_tmp22_ = persona_set;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp20_, (GeeSet*) _tmp21_, (GeeSet*) _tmp22_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (persona_set);
	_g_object_unref0 (persona);
}


static void _folks_individual_aggregator_persona_anti_links_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	FolksPersona* persona = NULL;
	GObject* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FolksPersona* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	FolksPersona* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	FolksPersona* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FolksSmallSet* persona_set = NULL;
	FolksSmallSet* _tmp12_ = NULL;
	FolksPersona* _tmp13_ = NULL;
	FolksPersona* _tmp14_ = NULL;
	FolksPersonaStore* _tmp15_ = NULL;
	FolksPersonaStore* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_PERSONA) ? ((FolksPersona*) _tmp0_) : NULL);
	persona = _tmp1_;
	_tmp3_ = persona;
	_tmp4_ = folks_persona_get_is_user (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "yes";
	} else {
		_tmp2_ = "no";
	}
	_tmp6_ = persona;
	_tmp7_ = folks_persona_get_uid (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = persona;
	_tmp10_ = folks_persona_get_iid (_tmp9_);
	_tmp11_ = _tmp10_;
	g_debug ("individual-aggregator.vala:1461: Anti-links changed for persona '%s' (" \
"is user: %s, IID: %s).", _tmp8_, _tmp2_, _tmp11_);
	_tmp12_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	persona_set = _tmp12_;
	_tmp13_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, _tmp13_);
	_tmp14_ = persona;
	_tmp15_ = folks_persona_get_store (_tmp14_);
	_tmp16_ = _tmp15_;
	_folks_individual_aggregator_personas_changed_cb (self, _tmp16_, (GeeSet*) persona_set, (GeeSet*) persona_set, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (persona_set);
	_g_object_unref0 (persona);
}


static void __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_linkable_property_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static void __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_folks_individual_aggregator_persona_anti_links_changed_cb ((FolksIndividualAggregator*) self, _sender, pspec);
}


static void _folks_individual_aggregator_connect_to_persona (FolksIndividualAggregator* self, FolksPersona* persona) {
	FolksPersona* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	FolksAntiLinkable* al = NULL;
	FolksPersona* _tmp8_ = NULL;
	FolksAntiLinkable* _tmp9_ = NULL;
	FolksAntiLinkable* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_linkable_properties (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp2_;
		prop_name_collection_length1 = _tmp2__length1;
		for (prop_name_it = 0; prop_name_it < _tmp2__length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp3_ = NULL;
			gchar* prop_name = NULL;
			_tmp3_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp3_;
			{
				const gchar* _tmp4_ = NULL;
				FolksPersona* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				_tmp4_ = prop_name;
				if (_tmp4_ == NULL) {
					_g_free0 (prop_name);
					continue;
				}
				_tmp5_ = persona;
				_tmp6_ = prop_name;
				_tmp7_ = g_strconcat ("notify::", _tmp6_, NULL);
				g_signal_connect_object ((GObject*) _tmp5_, _tmp7_, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self, 0);
				_g_free0 (_tmp7_);
				_g_free0 (prop_name);
			}
		}
	}
	_tmp8_ = persona;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, FOLKS_TYPE_ANTI_LINKABLE) ? ((FolksAntiLinkable*) _tmp8_) : NULL);
	al = _tmp9_;
	_tmp10_ = al;
	if (_tmp10_ != NULL) {
		FolksAntiLinkable* _tmp11_ = NULL;
		_tmp11_ = al;
		g_signal_connect_object ((GObject*) _tmp11_, "notify::anti-links", (GCallback) __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify, self, 0);
	}
	_g_object_unref0 (al);
}


static void _folks_individual_aggregator_disconnect_from_persona (FolksIndividualAggregator* self, FolksPersona* persona) {
	FolksAntiLinkable* al = NULL;
	FolksPersona* _tmp0_ = NULL;
	FolksAntiLinkable* _tmp1_ = NULL;
	FolksAntiLinkable* _tmp2_ = NULL;
	FolksPersona* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_ANTI_LINKABLE) ? ((FolksAntiLinkable*) _tmp0_) : NULL);
	al = _tmp1_;
	_tmp2_ = al;
	if (_tmp2_ != NULL) {
		FolksAntiLinkable* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		GQuark _tmp5_ = 0U;
		_tmp3_ = al;
		g_signal_parse_name ("notify::anti-links", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) __folks_individual_aggregator_persona_anti_links_changed_cb_g_object_notify, self);
	}
	_tmp6_ = persona;
	_tmp7_ = folks_persona_get_linkable_properties (_tmp6_, &_tmp7__length1);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp8_;
		prop_name_collection_length1 = _tmp8__length1;
		for (prop_name_it = 0; prop_name_it < _tmp8__length1; prop_name_it = prop_name_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* prop_name = NULL;
			_tmp9_ = g_strdup (prop_name_collection[prop_name_it]);
			prop_name = _tmp9_;
			{
				const gchar* _tmp10_ = NULL;
				FolksPersona* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				guint _tmp14_ = 0U;
				GQuark _tmp15_ = 0U;
				_tmp10_ = prop_name;
				if (_tmp10_ == NULL) {
					_g_free0 (prop_name);
					continue;
				}
				_tmp11_ = persona;
				_tmp12_ = prop_name;
				_tmp13_ = g_strconcat ("notify::", _tmp12_, NULL);
				g_signal_parse_name (_tmp13_, G_TYPE_OBJECT, &_tmp14_, &_tmp15_, TRUE);
				g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, _tmp15_, NULL, (GCallback) __folks_individual_aggregator_persona_linkable_property_changed_cb_g_object_notify, self);
				_g_free0 (_tmp13_);
				_g_free0 (prop_name);
			}
		}
	}
	_g_object_unref0 (al);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _folks_individual_aggregator_link_map_set (FolksIndividualAggregator* self, const gchar* key, FolksIndividual* individual) {
	GPtrArray* inds = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp21_ = NULL;
	FolksIndividual* _tmp22_ = NULL;
	FolksIndividual* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = self->priv->_link_map;
	_tmp1_ = key;
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp2_);
	inds = _tmp3_;
	_tmp4_ = inds;
	if (_tmp4_ == NULL) {
		GPtrArray* _tmp5_ = NULL;
		GHashTable* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GPtrArray* _tmp9_ = NULL;
		GPtrArray* _tmp10_ = NULL;
		_tmp5_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
		_g_ptr_array_unref0 (inds);
		inds = _tmp5_;
		_tmp6_ = self->priv->_link_map;
		_tmp7_ = key;
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = inds;
		_tmp10_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp9_);
		g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
	} else {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					guint _tmp13_ = 0U;
					GPtrArray* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					GPtrArray* _tmp17_ = NULL;
					guint _tmp18_ = 0U;
					gconstpointer _tmp19_ = NULL;
					FolksIndividual* _tmp20_ = NULL;
					if (!_tmp11_) {
						guint _tmp12_ = 0U;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = inds;
					_tmp15_ = g_ptr_array_get_length ((GPtrArray*) _tmp14_);
					_tmp16_ = _tmp15_;
					if (!(_tmp13_ < ((guint) _tmp16_))) {
						break;
					}
					_tmp17_ = inds;
					_tmp18_ = i;
					_tmp19_ = g_ptr_array_index ((GPtrArray*) _tmp17_, _tmp18_);
					_tmp20_ = individual;
					if (((FolksIndividual*) _tmp19_) == _tmp20_) {
						_g_ptr_array_unref0 (inds);
						return;
					}
				}
			}
		}
	}
	_tmp21_ = inds;
	_tmp22_ = individual;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	g_ptr_array_add ((GPtrArray*) _tmp21_, _tmp23_);
	_g_ptr_array_unref0 (inds);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->individual);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void _____lambda68_ (Block7Data* _data7_, const gchar* l) {
	FolksIndividualAggregator* self;
	const gchar* prop_linking_value = NULL;
	const gchar* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	self = _data7_->self;
	g_return_if_fail (l != NULL);
	_tmp0_ = l;
	prop_linking_value = _tmp0_;
	g_debug ("individual-aggregator.vala:1578:             %s", prop_linking_value);
	_tmp1_ = _data7_->individual;
	_folks_individual_aggregator_link_map_set (self, prop_linking_value, _tmp1_);
}


static void ______lambda68__folks_persona_linkable_property_callback (const gchar* link, gpointer self) {
	_____lambda68_ (self, link);
}


static void _folks_individual_aggregator_add_persona_to_link_map (FolksIndividualAggregator* self, FolksPersona* persona, FolksIndividual* individual) {
	Block7Data* _data7_;
	FolksIndividual* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FolksPersona* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	FolksPersona* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	FolksPersona* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	FolksIndividual* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	FolksPersona* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	FolksIndividual* _tmp18_ = NULL;
	FolksPersona* _tmp19_ = NULL;
	FolksPersonaStore* _tmp20_ = NULL;
	FolksPersonaStore* _tmp21_ = NULL;
	FolksPersonaStoreTrust _tmp22_ = 0;
	FolksPersonaStoreTrust _tmp23_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	g_return_if_fail (individual != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = individual;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->individual);
	_data7_->individual = _tmp1_;
	_tmp3_ = persona;
	_tmp4_ = folks_persona_get_is_user (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = "yes";
	} else {
		_tmp2_ = "no";
	}
	_tmp6_ = persona;
	_tmp7_ = folks_persona_get_uid (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = persona;
	_tmp10_ = folks_persona_get_iid (_tmp9_);
	_tmp11_ = _tmp10_;
	g_debug ("individual-aggregator.vala:1538: Connecting to Persona: %s (is user: %" \
"s, IID: %s)", _tmp8_, _tmp2_, _tmp11_);
	_tmp12_ = _data7_->individual;
	_tmp13_ = folks_individual_get_id (_tmp12_);
	_tmp14_ = _tmp13_;
	g_debug ("individual-aggregator.vala:1540:     Mapping to Individual: %s", _tmp14_);
	_tmp15_ = persona;
	_tmp16_ = folks_persona_get_iid (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _data7_->individual;
	_folks_individual_aggregator_link_map_set (self, _tmp17_, _tmp18_);
	_tmp19_ = persona;
	_tmp20_ = folks_persona_get_store (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = folks_persona_store_get_trust_level (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == FOLKS_PERSONA_STORE_TRUST_FULL) {
		FolksPersona* _tmp24_ = NULL;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		g_debug ("individual-aggregator.vala:1551:     Inserting links:");
		_tmp24_ = persona;
		_tmp25_ = folks_persona_get_linkable_properties (_tmp24_, &_tmp25__length1);
		_tmp26_ = _tmp25_;
		_tmp26__length1 = _tmp25__length1;
		{
			gchar** prop_name_collection = NULL;
			gint prop_name_collection_length1 = 0;
			gint _prop_name_collection_size_ = 0;
			gint prop_name_it = 0;
			prop_name_collection = _tmp26_;
			prop_name_collection_length1 = _tmp26__length1;
			for (prop_name_it = 0; prop_name_it < _tmp26__length1; prop_name_it = prop_name_it + 1) {
				const gchar* prop_name = NULL;
				prop_name = prop_name_collection[prop_name_it];
				{
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					GObjectClass* pclass = NULL;
					FolksPersona* _tmp29_ = NULL;
					GObjectClass* _tmp30_ = NULL;
					GObjectClass* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GParamSpec* _tmp33_ = NULL;
					FolksPersona* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					_tmp27_ = prop_name;
					if (_tmp27_ == NULL) {
						continue;
					}
					_tmp28_ = prop_name;
					g_debug ("individual-aggregator.vala:1561:         %s", _tmp28_);
					_tmp29_ = persona;
					_tmp30_ = G_OBJECT_GET_CLASS ((GObject*) _tmp29_);
					pclass = _tmp30_;
					_tmp31_ = pclass;
					_tmp32_ = prop_name;
					_tmp33_ = g_object_class_find_property (_tmp31_, _tmp32_);
					if (_tmp33_ == NULL) {
						const gchar* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						_tmp34_ = _ ("Unknown property '%s' in linkable property list.");
						_tmp35_ = prop_name;
						g_warning (_tmp34_, _tmp35_);
						continue;
					}
					_tmp36_ = persona;
					_tmp37_ = prop_name;
					folks_persona_linkable_property_to_links (_tmp36_, _tmp37_, ______lambda68__folks_persona_linkable_property_callback, _data7_);
				}
			}
		}
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static void _folks_individual_aggregator_remove_individual_from_link_map (FolksIndividualAggregator* self, FolksIndividual* individual) {
	FolksIndividual* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp3_ = NULL;
	const gchar* link_key = NULL;
	GPtrArray* inds = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	_tmp1_ = folks_individual_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("individual-aggregator.vala:1593: Removing Individual '%s' from the lin" \
"k map.", _tmp2_);
	_tmp3_ = self->priv->_link_map;
	g_hash_table_iter_init (&iter, _tmp3_);
	while (TRUE) {
		gconstpointer _tmp4_ = NULL;
		gconstpointer _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp4_), (gpointer*) (&_tmp5_));
		link_key = _tmp4_;
		inds = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					guint _tmp9_ = 0U;
					GPtrArray* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					GPtrArray* _tmp13_ = NULL;
					guint _tmp14_ = 0U;
					gconstpointer _tmp15_ = NULL;
					FolksIndividual* _tmp16_ = NULL;
					if (!_tmp7_) {
						guint _tmp8_ = 0U;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = i;
					_tmp10_ = inds;
					_tmp11_ = g_ptr_array_get_length (_tmp10_);
					_tmp12_ = _tmp11_;
					if (!(_tmp9_ < ((guint) _tmp12_))) {
						break;
					}
					_tmp13_ = inds;
					_tmp14_ = i;
					_tmp15_ = g_ptr_array_index (_tmp13_, _tmp14_);
					_tmp16_ = individual;
					if (((FolksIndividual*) _tmp15_) == _tmp16_) {
						const gchar* _tmp17_ = NULL;
						FolksIndividual* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
						FolksIndividual* _tmp21_ = NULL;
						GPtrArray* _tmp22_ = NULL;
						guint _tmp23_ = 0U;
						GPtrArray* _tmp24_ = NULL;
						gint _tmp25_ = 0;
						gint _tmp26_ = 0;
						_tmp17_ = link_key;
						_tmp18_ = individual;
						_tmp19_ = folks_individual_get_id (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = individual;
						g_debug ("individual-aggregator.vala:1606:     %s → %s (%p)", _tmp17_, _tmp20_, _tmp21_);
						_tmp22_ = inds;
						_tmp23_ = i;
						g_ptr_array_remove_index_fast (_tmp22_, _tmp23_);
						_tmp24_ = inds;
						_tmp25_ = g_ptr_array_get_length (_tmp24_);
						_tmp26_ = _tmp25_;
						if (_tmp26_ == 0) {
							g_hash_table_iter_remove (&iter);
						}
						break;
					}
				}
			}
		}
	}
}


static void _folks_individual_aggregator_personas_changed_cb (FolksIndividualAggregator* self, FolksPersonaStore* store, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeHashSet* removed_individuals = NULL;
	GeeHashSet* _tmp0_ = NULL;
	GeeHashMultiMap* individuals_changes = NULL;
	GeeHashMultiMap* _tmp1_ = NULL;
	GeeHashSet* relinked_personas = NULL;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashMap* replaced_individuals = NULL;
	GeeHashMap* _tmp3_ = NULL;
	FolksIndividual* user = NULL;
	FolksIndividual* _tmp4_ = NULL;
	FolksIndividual* _tmp5_ = NULL;
	GeeSet* _tmp82_ = NULL;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	GeeHashSet* _tmp102_ = NULL;
	FolksIndividual* _tmp137_ = NULL;
	GeeHashMultiMap* _tmp138_ = NULL;
	gint _tmp139_ = 0;
	gint _tmp140_ = 0;
	GeeMapIterator* iter2 = NULL;
	GeeHashMap* _tmp169_ = NULL;
	GeeMapIterator* _tmp170_ = NULL;
	FolksDebug* _tmp187_ = NULL;
	gboolean _tmp188_ = FALSE;
	gboolean _tmp189_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	removed_individuals = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	individuals_changes = _tmp1_;
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	relinked_personas = _tmp2_;
	_tmp3_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	replaced_individuals = _tmp3_;
	_tmp4_ = self->priv->_user;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	user = _tmp5_;
	g_debug ("individual-aggregator.vala:1639: Removing Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		_tmp6_ = removed;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_persona_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp10_ = NULL;
			gpointer _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			FolksPersona* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			FolksPersona* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			FolksPersona* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			FolksIndividual* ind = NULL;
			FolksPersona* _tmp22_ = NULL;
			FolksIndividual* _tmp23_ = NULL;
			FolksIndividual* _tmp24_ = NULL;
			FolksIndividual* _tmp25_ = NULL;
			FolksIndividual* _tmp26_ = NULL;
			FolksPersona* _tmp29_ = NULL;
			_tmp8_ = _persona_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _persona_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			persona = (FolksPersona*) _tmp11_;
			_tmp13_ = persona;
			_tmp14_ = folks_persona_get_is_user (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_) {
				_tmp12_ = "yes";
			} else {
				_tmp12_ = "no";
			}
			_tmp16_ = persona;
			_tmp17_ = folks_persona_get_uid (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = persona;
			_tmp20_ = folks_persona_get_iid (_tmp19_);
			_tmp21_ = _tmp20_;
			g_debug ("individual-aggregator.vala:1643:     %s (is user: %s, IID: %s)", _tmp18_, _tmp12_, _tmp21_);
			_tmp22_ = persona;
			_tmp23_ = folks_persona_get_individual (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			ind = _tmp25_;
			_tmp26_ = ind;
			if (_tmp26_ != NULL) {
				GeeHashSet* _tmp27_ = NULL;
				FolksIndividual* _tmp28_ = NULL;
				_tmp27_ = removed_individuals;
				_tmp28_ = ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp29_ = persona;
			_folks_individual_aggregator_disconnect_from_persona (self, _tmp29_);
			_g_object_unref0 (ind);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	g_debug ("individual-aggregator.vala:1667: Removing Individuals due to removed l" \
"inks:");
	{
		GeeIterator* _individual_it = NULL;
		GeeHashSet* _tmp30_ = NULL;
		GeeIterator* _tmp31_ = NULL;
		_tmp30_ = removed_individuals;
		_tmp31_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp30_);
		_individual_it = _tmp31_;
		while (TRUE) {
			GeeIterator* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp34_ = NULL;
			gpointer _tmp35_ = NULL;
			GeeMap* _tmp36_ = NULL;
			FolksIndividual* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			FolksIndividual* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			FolksIndividual* _tmp61_ = NULL;
			FolksIndividual* _tmp62_ = NULL;
			FolksIndividual* _tmp63_ = NULL;
			FolksIndividual* _tmp64_ = NULL;
			_tmp32_ = _individual_it;
			_tmp33_ = gee_iterator_next (_tmp32_);
			if (!_tmp33_) {
				break;
			}
			_tmp34_ = _individual_it;
			_tmp35_ = gee_iterator_get (_tmp34_);
			individual = (FolksIndividual*) _tmp35_;
			_tmp36_ = self->priv->_individuals;
			_tmp37_ = individual;
			_tmp38_ = folks_individual_get_id (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = gee_map_has_key (_tmp36_, _tmp39_);
			if (_tmp40_ == FALSE) {
				_g_object_unref0 (individual);
				continue;
			}
			_tmp41_ = individual;
			_tmp42_ = folks_individual_get_id (_tmp41_);
			_tmp43_ = _tmp42_;
			g_debug ("individual-aggregator.vala:1674:     %s", _tmp43_);
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp44_ = NULL;
				GeeSet* _tmp45_ = NULL;
				GeeSet* _tmp46_ = NULL;
				GeeIterator* _tmp47_ = NULL;
				_tmp44_ = individual;
				_tmp45_ = folks_individual_get_personas (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
				_persona_it = _tmp47_;
				while (TRUE) {
					GeeIterator* _tmp48_ = NULL;
					gboolean _tmp49_ = FALSE;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp50_ = NULL;
					gpointer _tmp51_ = NULL;
					gboolean _tmp52_ = FALSE;
					GeeSet* _tmp53_ = NULL;
					FolksPersona* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
					GeeHashSet* _tmp59_ = NULL;
					FolksPersona* _tmp60_ = NULL;
					_tmp48_ = _persona_it;
					_tmp49_ = gee_iterator_next (_tmp48_);
					if (!_tmp49_) {
						break;
					}
					_tmp50_ = _persona_it;
					_tmp51_ = gee_iterator_get (_tmp50_);
					persona = (FolksPersona*) _tmp51_;
					_tmp53_ = removed;
					_tmp54_ = persona;
					_tmp55_ = gee_collection_contains ((GeeCollection*) _tmp53_, _tmp54_);
					if (_tmp55_ == TRUE) {
						_tmp52_ = TRUE;
					} else {
						GeeHashSet* _tmp56_ = NULL;
						FolksPersona* _tmp57_ = NULL;
						gboolean _tmp58_ = FALSE;
						_tmp56_ = relinked_personas;
						_tmp57_ = persona;
						_tmp58_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp56_, _tmp57_);
						_tmp52_ = _tmp58_ == TRUE;
					}
					if (_tmp52_) {
						_g_object_unref0 (persona);
						continue;
					}
					_tmp59_ = relinked_personas;
					_tmp60_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, _tmp60_);
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp61_ = user;
			_tmp62_ = individual;
			if (_tmp61_ == _tmp62_) {
				_g_object_unref0 (user);
				user = NULL;
			}
			_tmp63_ = individual;
			_folks_individual_aggregator_disconnect_from_individual (self, _tmp63_);
			_tmp64_ = individual;
			_folks_individual_aggregator_remove_individual_from_link_map (self, _tmp64_);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	g_debug ("individual-aggregator.vala:1696: Adding Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp65_ = NULL;
		GeeIterator* _tmp66_ = NULL;
		_tmp65_ = added;
		_tmp66_ = gee_iterable_iterator ((GeeIterable*) _tmp65_);
		_persona_it = _tmp66_;
		while (TRUE) {
			GeeIterator* _tmp67_ = NULL;
			gboolean _tmp68_ = FALSE;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp69_ = NULL;
			gpointer _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			FolksPersona* _tmp72_ = NULL;
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			FolksPersona* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			const gchar* _tmp77_ = NULL;
			FolksPersona* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			FolksPersona* _tmp81_ = NULL;
			_tmp67_ = _persona_it;
			_tmp68_ = gee_iterator_next (_tmp67_);
			if (!_tmp68_) {
				break;
			}
			_tmp69_ = _persona_it;
			_tmp70_ = gee_iterator_get (_tmp69_);
			persona = (FolksPersona*) _tmp70_;
			_tmp72_ = persona;
			_tmp73_ = folks_persona_get_is_user (_tmp72_);
			_tmp74_ = _tmp73_;
			if (_tmp74_) {
				_tmp71_ = "yes";
			} else {
				_tmp71_ = "no";
			}
			_tmp75_ = persona;
			_tmp76_ = folks_persona_get_uid (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = persona;
			_tmp79_ = folks_persona_get_iid (_tmp78_);
			_tmp80_ = _tmp79_;
			g_debug ("individual-aggregator.vala:1699:     %s (is user: %s, IID: %s)", _tmp77_, _tmp71_, _tmp80_);
			_tmp81_ = persona;
			_folks_individual_aggregator_connect_to_persona (self, _tmp81_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp82_ = added;
	_tmp83_ = gee_collection_get_size ((GeeCollection*) _tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_ > 0) {
		GeeSet* _tmp85_ = NULL;
		_tmp85_ = added;
		_folks_individual_aggregator_add_personas (self, _tmp85_, &user, &individuals_changes);
	}
	g_debug ("individual-aggregator.vala:1712: Relinking Personas:");
	{
		GeeIterator* _persona_it = NULL;
		GeeHashSet* _tmp86_ = NULL;
		GeeIterator* _tmp87_ = NULL;
		_tmp86_ = relinked_personas;
		_tmp87_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp86_);
		_persona_it = _tmp87_;
		while (TRUE) {
			GeeIterator* _tmp88_ = NULL;
			gboolean _tmp89_ = FALSE;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp90_ = NULL;
			gpointer _tmp91_ = NULL;
			const gchar* _tmp92_ = NULL;
			FolksPersona* _tmp93_ = NULL;
			gboolean _tmp94_ = FALSE;
			gboolean _tmp95_ = FALSE;
			FolksPersona* _tmp96_ = NULL;
			const gchar* _tmp97_ = NULL;
			const gchar* _tmp98_ = NULL;
			FolksPersona* _tmp99_ = NULL;
			const gchar* _tmp100_ = NULL;
			const gchar* _tmp101_ = NULL;
			_tmp88_ = _persona_it;
			_tmp89_ = gee_iterator_next (_tmp88_);
			if (!_tmp89_) {
				break;
			}
			_tmp90_ = _persona_it;
			_tmp91_ = gee_iterator_get (_tmp90_);
			persona = (FolksPersona*) _tmp91_;
			_tmp93_ = persona;
			_tmp94_ = folks_persona_get_is_user (_tmp93_);
			_tmp95_ = _tmp94_;
			if (_tmp95_) {
				_tmp92_ = "yes";
			} else {
				_tmp92_ = "no";
			}
			_tmp96_ = persona;
			_tmp97_ = folks_persona_get_uid (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = persona;
			_tmp100_ = folks_persona_get_iid (_tmp99_);
			_tmp101_ = _tmp100_;
			g_debug ("individual-aggregator.vala:1715:     %s (is user: %s, IID: %s)", _tmp98_, _tmp92_, _tmp101_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp102_ = relinked_personas;
	_folks_individual_aggregator_add_personas (self, (GeeSet*) _tmp102_, &user, &individuals_changes);
	{
		GeeIterator* _individual_it = NULL;
		GeeHashSet* _tmp103_ = NULL;
		GeeIterator* _tmp104_ = NULL;
		_tmp103_ = removed_individuals;
		_tmp104_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp103_);
		_individual_it = _tmp104_;
		while (TRUE) {
			GeeIterator* _tmp105_ = NULL;
			gboolean _tmp106_ = FALSE;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp107_ = NULL;
			gpointer _tmp108_ = NULL;
			gboolean added_mapping = FALSE;
			gboolean _tmp133_ = FALSE;
			FolksIndividual* _tmp136_ = NULL;
			_tmp105_ = _individual_it;
			_tmp106_ = gee_iterator_next (_tmp105_);
			if (!_tmp106_) {
				break;
			}
			_tmp107_ = _individual_it;
			_tmp108_ = gee_iterator_get (_tmp107_);
			individual = (FolksIndividual*) _tmp108_;
			added_mapping = FALSE;
			{
				GeeIterator* _persona_it = NULL;
				FolksIndividual* _tmp109_ = NULL;
				GeeSet* _tmp110_ = NULL;
				GeeSet* _tmp111_ = NULL;
				GeeIterator* _tmp112_ = NULL;
				_tmp109_ = individual;
				_tmp110_ = folks_individual_get_personas (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = gee_iterable_iterator ((GeeIterable*) _tmp111_);
				_persona_it = _tmp112_;
				while (TRUE) {
					GeeIterator* _tmp113_ = NULL;
					gboolean _tmp114_ = FALSE;
					FolksPersona* persona = NULL;
					GeeIterator* _tmp115_ = NULL;
					gpointer _tmp116_ = NULL;
					gboolean _tmp117_ = FALSE;
					GeeSet* _tmp118_ = NULL;
					FolksPersona* _tmp119_ = NULL;
					gboolean _tmp120_ = FALSE;
					_tmp113_ = _persona_it;
					_tmp114_ = gee_iterator_next (_tmp113_);
					if (!_tmp114_) {
						break;
					}
					_tmp115_ = _persona_it;
					_tmp116_ = gee_iterator_get (_tmp115_);
					persona = (FolksPersona*) _tmp116_;
					_tmp118_ = removed;
					_tmp119_ = persona;
					_tmp120_ = gee_collection_contains ((GeeCollection*) _tmp118_, _tmp119_);
					if (!_tmp120_) {
						_tmp117_ = TRUE;
					} else {
						GeeSet* _tmp121_ = NULL;
						FolksPersona* _tmp122_ = NULL;
						gboolean _tmp123_ = FALSE;
						_tmp121_ = added;
						_tmp122_ = persona;
						_tmp123_ = gee_collection_contains ((GeeCollection*) _tmp121_, _tmp122_);
						_tmp117_ = _tmp123_;
					}
					if (_tmp117_) {
						GeeHashMultiMap* _tmp124_ = NULL;
						FolksPersona* _tmp125_ = NULL;
						FolksIndividual* _tmp126_ = NULL;
						FolksIndividual* _tmp127_ = NULL;
						GeeHashMultiMap* _tmp128_ = NULL;
						FolksIndividual* _tmp129_ = NULL;
						FolksPersona* _tmp130_ = NULL;
						FolksIndividual* _tmp131_ = NULL;
						FolksIndividual* _tmp132_ = NULL;
						_tmp124_ = individuals_changes;
						_tmp125_ = persona;
						_tmp126_ = folks_persona_get_individual (_tmp125_);
						_tmp127_ = _tmp126_;
						gee_multi_map_remove ((GeeMultiMap*) _tmp124_, NULL, _tmp127_);
						_tmp128_ = individuals_changes;
						_tmp129_ = individual;
						_tmp130_ = persona;
						_tmp131_ = folks_persona_get_individual (_tmp130_);
						_tmp132_ = _tmp131_;
						gee_multi_map_set ((GeeMultiMap*) _tmp128_, _tmp129_, _tmp132_);
						added_mapping = TRUE;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp133_ = added_mapping;
			if (_tmp133_ == FALSE) {
				GeeHashMultiMap* _tmp134_ = NULL;
				FolksIndividual* _tmp135_ = NULL;
				_tmp134_ = individuals_changes;
				_tmp135_ = individual;
				gee_multi_map_set ((GeeMultiMap*) _tmp134_, _tmp135_, NULL);
			}
			_tmp136_ = individual;
			folks_individual_set_personas (_tmp136_, NULL);
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp137_ = user;
	folks_individual_aggregator_set_user (self, _tmp137_);
	_tmp138_ = individuals_changes;
	_tmp139_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp138_);
	_tmp140_ = _tmp139_;
	if (_tmp140_ > 0) {
		GeeHashSet* added_individuals = NULL;
		GeeHashSet* _tmp141_ = NULL;
		GeeMapIterator* iter1 = NULL;
		GeeHashMultiMap* _tmp142_ = NULL;
		GeeMapIterator* _tmp143_ = NULL;
		GeeHashSet* _tmp166_ = NULL;
		GeeHashSet* _tmp167_ = NULL;
		GeeHashMultiMap* _tmp168_ = NULL;
		_tmp141_ = gee_hash_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		added_individuals = _tmp141_;
		_tmp142_ = individuals_changes;
		_tmp143_ = gee_multi_map_map_iterator ((GeeMultiMap*) _tmp142_);
		iter1 = _tmp143_;
		while (TRUE) {
			GeeMapIterator* _tmp144_ = NULL;
			gboolean _tmp145_ = FALSE;
			FolksIndividual* old_ind = NULL;
			GeeMapIterator* _tmp146_ = NULL;
			gpointer _tmp147_ = NULL;
			FolksIndividual* new_ind = NULL;
			GeeMapIterator* _tmp148_ = NULL;
			gpointer _tmp149_ = NULL;
			gboolean _tmp150_ = FALSE;
			FolksIndividual* _tmp151_ = NULL;
			FolksIndividual* _tmp153_ = NULL;
			FolksIndividual* _tmp156_ = NULL;
			gboolean _tmp160_ = FALSE;
			FolksIndividual* _tmp161_ = NULL;
			_tmp144_ = iter1;
			_tmp145_ = gee_map_iterator_next (_tmp144_);
			if (!_tmp145_) {
				break;
			}
			_tmp146_ = iter1;
			_tmp147_ = gee_map_iterator_get_key (_tmp146_);
			old_ind = (FolksIndividual*) _tmp147_;
			_tmp148_ = iter1;
			_tmp149_ = gee_map_iterator_get_value (_tmp148_);
			new_ind = (FolksIndividual*) _tmp149_;
			_tmp151_ = old_ind;
			if (_tmp151_ != NULL) {
				_tmp150_ = TRUE;
			} else {
				FolksIndividual* _tmp152_ = NULL;
				_tmp152_ = new_ind;
				_tmp150_ = _tmp152_ != NULL;
			}
			_vala_assert (_tmp150_, "old_ind != null || new_ind != null");
			_tmp153_ = old_ind;
			if (_tmp153_ != NULL) {
				GeeHashSet* _tmp154_ = NULL;
				FolksIndividual* _tmp155_ = NULL;
				_tmp154_ = removed_individuals;
				_tmp155_ = old_ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp154_, G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp156_ = new_ind;
			if (_tmp156_ != NULL) {
				GeeHashSet* _tmp157_ = NULL;
				FolksIndividual* _tmp158_ = NULL;
				FolksIndividual* _tmp159_ = NULL;
				_tmp157_ = added_individuals;
				_tmp158_ = new_ind;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp157_, G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
				_tmp159_ = new_ind;
				_folks_individual_aggregator_connect_to_individual (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_tmp161_ = old_ind;
			if (_tmp161_ != NULL) {
				FolksIndividual* _tmp162_ = NULL;
				_tmp162_ = new_ind;
				_tmp160_ = _tmp162_ != NULL;
			} else {
				_tmp160_ = FALSE;
			}
			if (_tmp160_) {
				GeeHashMap* _tmp163_ = NULL;
				FolksIndividual* _tmp164_ = NULL;
				FolksIndividual* _tmp165_ = NULL;
				_tmp163_ = replaced_individuals;
				_tmp164_ = old_ind;
				_tmp165_ = new_ind;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp163_, G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual), G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
			}
			_g_object_unref0 (new_ind);
			_g_object_unref0 (old_ind);
		}
		_tmp166_ = added_individuals;
		_tmp167_ = removed_individuals;
		_tmp168_ = individuals_changes;
		_folks_individual_aggregator_emit_individuals_changed (self, (GeeSet*) _tmp166_, (GeeSet*) _tmp167_, (GeeMultiMap*) _tmp168_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (iter1);
		_g_object_unref0 (added_individuals);
	}
	g_debug ("individual-aggregator.vala:1790: Replacing Individuals due to linking:");
	_tmp169_ = replaced_individuals;
	_tmp170_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp169_);
	iter2 = _tmp170_;
	while (TRUE) {
		GeeMapIterator* _tmp171_ = NULL;
		gboolean _tmp172_ = FALSE;
		FolksIndividual* old_ind = NULL;
		GeeMapIterator* _tmp173_ = NULL;
		gpointer _tmp174_ = NULL;
		FolksIndividual* new_ind = NULL;
		GeeMapIterator* _tmp175_ = NULL;
		gpointer _tmp176_ = NULL;
		FolksIndividual* _tmp177_ = NULL;
		const gchar* _tmp178_ = NULL;
		const gchar* _tmp179_ = NULL;
		FolksIndividual* _tmp180_ = NULL;
		FolksIndividual* _tmp181_ = NULL;
		const gchar* _tmp182_ = NULL;
		const gchar* _tmp183_ = NULL;
		FolksIndividual* _tmp184_ = NULL;
		FolksIndividual* _tmp185_ = NULL;
		FolksIndividual* _tmp186_ = NULL;
		_tmp171_ = iter2;
		_tmp172_ = gee_map_iterator_next (_tmp171_);
		if (!(_tmp172_ == TRUE)) {
			break;
		}
		_tmp173_ = iter2;
		_tmp174_ = gee_map_iterator_get_key (_tmp173_);
		old_ind = (FolksIndividual*) _tmp174_;
		_tmp175_ = iter2;
		_tmp176_ = gee_map_iterator_get_value (_tmp175_);
		new_ind = (FolksIndividual*) _tmp176_;
		_tmp177_ = old_ind;
		_tmp178_ = folks_individual_get_id (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = old_ind;
		_tmp181_ = new_ind;
		_tmp182_ = folks_individual_get_id (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = new_ind;
		g_debug ("individual-aggregator.vala:1797:     %s (%p) → %s (%p)", _tmp179_, _tmp180_, _tmp183_, _tmp184_);
		_tmp185_ = old_ind;
		_tmp186_ = new_ind;
		folks_individual_replace (_tmp185_, _tmp186_);
		_g_object_unref0 (new_ind);
		_g_object_unref0 (old_ind);
	}
	_tmp187_ = self->priv->_debug;
	_tmp188_ = folks_debug_get_debug_output_enabled (_tmp187_);
	_tmp189_ = _tmp188_;
	if (_tmp189_ == TRUE) {
		GHashTableIter link_map_iter = {0};
		GHashTable* _tmp190_ = NULL;
		const gchar* link_key = NULL;
		GPtrArray* inds = NULL;
		_tmp190_ = self->priv->_link_map;
		g_hash_table_iter_init (&link_map_iter, _tmp190_);
		while (TRUE) {
			gconstpointer _tmp191_ = NULL;
			gconstpointer _tmp192_ = NULL;
			gboolean _tmp193_ = FALSE;
			_tmp193_ = g_hash_table_iter_next (&link_map_iter, (gpointer*) (&_tmp191_), (gpointer*) (&_tmp192_));
			link_key = _tmp191_;
			inds = _tmp192_;
			if (!_tmp193_) {
				break;
			}
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp194_ = FALSE;
					_tmp194_ = TRUE;
					while (TRUE) {
						guint _tmp196_ = 0U;
						GPtrArray* _tmp197_ = NULL;
						gint _tmp198_ = 0;
						gint _tmp199_ = 0;
						FolksIndividual* individual = NULL;
						GPtrArray* _tmp200_ = NULL;
						guint _tmp201_ = 0U;
						gconstpointer _tmp202_ = NULL;
						FolksIndividual* _tmp203_ = NULL;
						FolksIndividual* _tmp204_ = NULL;
						GeeMap* _tmp205_ = NULL;
						FolksIndividual* _tmp206_ = NULL;
						const gchar* _tmp207_ = NULL;
						const gchar* _tmp208_ = NULL;
						gpointer _tmp209_ = NULL;
						FolksIndividual* _tmp210_ = NULL;
						FolksIndividual* _tmp211_ = NULL;
						gboolean _tmp212_ = FALSE;
						if (!_tmp194_) {
							guint _tmp195_ = 0U;
							_tmp195_ = i;
							i = _tmp195_ + 1;
						}
						_tmp194_ = FALSE;
						_tmp196_ = i;
						_tmp197_ = inds;
						_tmp198_ = g_ptr_array_get_length (_tmp197_);
						_tmp199_ = _tmp198_;
						if (!(_tmp196_ < ((guint) _tmp199_))) {
							break;
						}
						_tmp200_ = inds;
						_tmp201_ = i;
						_tmp202_ = g_ptr_array_index (_tmp200_, _tmp201_);
						_tmp203_ = _g_object_ref0 ((FolksIndividual*) _tmp202_);
						individual = _tmp203_;
						_tmp204_ = individual;
						_vala_assert (_tmp204_ != NULL, "individual != null");
						_tmp205_ = self->priv->_individuals;
						_tmp206_ = individual;
						_tmp207_ = folks_individual_get_id (_tmp206_);
						_tmp208_ = _tmp207_;
						_tmp209_ = gee_map_get (_tmp205_, _tmp208_);
						_tmp210_ = (FolksIndividual*) _tmp209_;
						_tmp211_ = individual;
						_tmp212_ = _tmp210_ != _tmp211_;
						_g_object_unref0 (_tmp210_);
						if (_tmp212_) {
							const gchar* _tmp213_ = NULL;
							FolksIndividual* _tmp214_ = NULL;
							const gchar* _tmp215_ = NULL;
							const gchar* _tmp216_ = NULL;
							FolksIndividual* _tmp217_ = NULL;
							FolksIndividual* _tmp218_ = NULL;
							const gchar* _tmp219_ = NULL;
							const gchar* _tmp220_ = NULL;
							FolksIndividual* _tmp221_ = NULL;
							_tmp213_ = link_key;
							_tmp214_ = individual;
							_tmp215_ = folks_individual_get_id (_tmp214_);
							_tmp216_ = _tmp215_;
							_tmp217_ = individual;
							g_warning ("Link map contains invalid mapping:\n" "    %s → %s (%p)", _tmp213_, _tmp216_, _tmp217_);
							_tmp218_ = individual;
							_tmp219_ = folks_individual_get_id (_tmp218_);
							_tmp220_ = _tmp219_;
							_tmp221_ = individual;
							g_warning ("individual-aggregator.vala:1823: Individual %s (%p) personas:", _tmp220_, _tmp221_);
							{
								GeeIterator* _p_it = NULL;
								FolksIndividual* _tmp222_ = NULL;
								GeeSet* _tmp223_ = NULL;
								GeeSet* _tmp224_ = NULL;
								GeeIterator* _tmp225_ = NULL;
								_tmp222_ = individual;
								_tmp223_ = folks_individual_get_personas (_tmp222_);
								_tmp224_ = _tmp223_;
								_tmp225_ = gee_iterable_iterator ((GeeIterable*) _tmp224_);
								_p_it = _tmp225_;
								while (TRUE) {
									GeeIterator* _tmp226_ = NULL;
									gboolean _tmp227_ = FALSE;
									FolksPersona* p = NULL;
									GeeIterator* _tmp228_ = NULL;
									gpointer _tmp229_ = NULL;
									FolksPersona* _tmp230_ = NULL;
									const gchar* _tmp231_ = NULL;
									const gchar* _tmp232_ = NULL;
									FolksPersona* _tmp233_ = NULL;
									_tmp226_ = _p_it;
									_tmp227_ = gee_iterator_next (_tmp226_);
									if (!_tmp227_) {
										break;
									}
									_tmp228_ = _p_it;
									_tmp229_ = gee_iterator_get (_tmp228_);
									p = (FolksPersona*) _tmp229_;
									_tmp230_ = p;
									_tmp231_ = folks_persona_get_uid (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp233_ = p;
									g_warning ("individual-aggregator.vala:1827:     %s (%p)", _tmp232_, _tmp233_);
									_g_object_unref0 (p);
								}
								_g_object_unref0 (_p_it);
							}
						}
						{
							guint j = 0U;
							guint _tmp234_ = 0U;
							_tmp234_ = i;
							j = _tmp234_ + 1;
							{
								gboolean _tmp235_ = FALSE;
								_tmp235_ = TRUE;
								while (TRUE) {
									guint _tmp237_ = 0U;
									GPtrArray* _tmp238_ = NULL;
									gint _tmp239_ = 0;
									gint _tmp240_ = 0;
									GPtrArray* _tmp241_ = NULL;
									guint _tmp242_ = 0U;
									gconstpointer _tmp243_ = NULL;
									GPtrArray* _tmp244_ = NULL;
									guint _tmp245_ = 0U;
									gconstpointer _tmp246_ = NULL;
									if (!_tmp235_) {
										guint _tmp236_ = 0U;
										_tmp236_ = j;
										j = _tmp236_ + 1;
									}
									_tmp235_ = FALSE;
									_tmp237_ = j;
									_tmp238_ = inds;
									_tmp239_ = g_ptr_array_get_length (_tmp238_);
									_tmp240_ = _tmp239_;
									if (!(_tmp237_ < ((guint) _tmp240_))) {
										break;
									}
									_tmp241_ = inds;
									_tmp242_ = i;
									_tmp243_ = g_ptr_array_index (_tmp241_, _tmp242_);
									_tmp244_ = inds;
									_tmp245_ = j;
									_tmp246_ = g_ptr_array_index (_tmp244_, _tmp245_);
									if (((FolksIndividual*) _tmp243_) == ((FolksIndividual*) _tmp246_)) {
										const gchar* _tmp247_ = NULL;
										FolksIndividual* _tmp248_ = NULL;
										const gchar* _tmp249_ = NULL;
										const gchar* _tmp250_ = NULL;
										FolksIndividual* _tmp251_ = NULL;
										_tmp247_ = link_key;
										_tmp248_ = individual;
										_tmp249_ = folks_individual_get_id (_tmp248_);
										_tmp250_ = _tmp249_;
										_tmp251_ = individual;
										g_warning ("Link map contains non-unique " "Individual: %s → %s (%p) twice", _tmp247_, _tmp250_, _tmp251_);
									}
								}
							}
						}
						_g_object_unref0 (individual);
					}
				}
			}
		}
	}
	_g_object_unref0 (iter2);
	_g_object_unref0 (user);
	_g_object_unref0 (replaced_individuals);
	_g_object_unref0 (relinked_personas);
	_g_object_unref0 (individuals_changes);
	_g_object_unref0 (removed_individuals);
}


static void _folks_individual_aggregator_is_primary_store_changed_cb (FolksIndividualAggregator* self, GObject* object, GParamSpec* pspec) {
	FolksPersonaStore* store = NULL;
	GObject* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	FolksPersonaStore* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
	store = _tmp1_;
	_tmp4_ = store;
	_tmp5_ = folks_persona_store_get_is_primary_store (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == TRUE) {
		FolksPersonaStore* _tmp7_ = NULL;
		FolksPersonaStore* _tmp8_ = NULL;
		_tmp7_ = store;
		_tmp8_ = self->priv->_primary_store;
		_tmp3_ = _tmp7_ == _tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		FolksPersonaStore* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = store;
		_tmp11_ = folks_persona_store_get_is_primary_store (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == FALSE) {
			FolksPersonaStore* _tmp13_ = NULL;
			FolksPersonaStore* _tmp14_ = NULL;
			_tmp13_ = store;
			_tmp14_ = self->priv->_primary_store;
			_tmp9_ = _tmp13_ != _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp2_ = _tmp9_;
	}
	_vala_assert (_tmp2_, "(store.is_primary_store == true &&               store == this._primary_store) ||           (store.is_primary_store == false &&               store != this._primary_store)");
	_g_object_unref0 (store);
}


static void _folks_individual_aggregator_persona_store_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_non_quiescent_persona_store_count;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->_non_quiescent_persona_store_count;
		self->priv->_non_quiescent_persona_store_count = _tmp1_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}


static void _folks_individual_aggregator_backend_is_quiescent_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->_non_quiescent_backend_count;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->_non_quiescent_backend_count;
		self->priv->_non_quiescent_backend_count = _tmp1_ - 1;
		_folks_individual_aggregator_notify_if_is_quiescent (self);
	}
}


static void _folks_individual_aggregator_notify_if_is_quiescent (FolksIndividualAggregator* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->_non_quiescent_backend_count;
	if (_tmp2_ == ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->_non_quiescent_persona_store_count;
		_tmp1_ = _tmp3_ == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->_is_quiescent;
		_tmp0_ = _tmp4_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		guint _tmp12_ = 0U;
		_tmp6_ = self->priv->_configured_primary_store_type_id;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 0) {
			FolksPersonaStore* _tmp9_ = NULL;
			_tmp9_ = self->priv->_primary_store;
			_tmp5_ = _tmp9_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp10_ = self->priv->_configured_primary_store_type_id;
			_tmp11_ = self->priv->_configured_primary_store_id;
			g_warning ("Failed to find primary PersonaStore with type ID " "'%s' and ID '%s'.\n" "Individuals will not be linked properly " "and creating new links between Personas will not work.\n" "The configured primary PersonaStore's backend may not be " "installed. If you are unsure, check with your " "distribution.", _tmp10_, _tmp11_);
		}
		folks_internal_profiling_point ("%s", "reached quiescence in " "IndividualAggregator");
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
		_tmp12_ = self->priv->_quiescent_timeout_id;
		if (_tmp12_ != ((guint) 0)) {
			guint _tmp13_ = 0U;
			_tmp13_ = self->priv->_quiescent_timeout_id;
			g_source_remove (_tmp13_);
			self->priv->_quiescent_timeout_id = (guint) 0;
		}
	}
}


static gboolean _folks_individual_aggregator_quiescent_timeout_cb (FolksIndividualAggregator* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_quiescent;
	if (_tmp0_ == FALSE) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = self->priv->_non_quiescent_backend_count;
		_tmp2_ = self->priv->_non_quiescent_persona_store_count;
		g_warning ("Failed to reach quiescence normally (%u backends and %u " "persona stores still haven't reached quiescence). Forcing " "IndividualAggregator quiescence due to reaching the timeout.", _tmp1_, _tmp2_);
		self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) self, "is-quiescent");
	}
	self->priv->_quiescent_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static void _folks_individual_aggregator_persona_store_is_user_set_default_changed_cb (FolksIndividualAggregator* self, GObject* obj, GParamSpec* pspec) {
	FolksPersonaStore* store = NULL;
	GObject* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	FolksPersonaStore* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	FolksPersonaStore* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = obj;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
	store = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_type_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	g_debug ("PersonaStore.is-user-set-default changed for store %p " "(type ID: %s, ID: %s)", _tmp2_, _tmp5_, _tmp8_);
	_tmp9_ = store;
	_tmp10_ = _folks_individual_aggregator_maybe_configure_as_primary (self, _tmp9_);
	if (_tmp10_) {
		FolksPersonaStore* _tmp11_ = NULL;
		_tmp11_ = store;
		_folks_individual_aggregator_set_primary_store (self, _tmp11_);
	}
	_g_object_unref0 (store);
}


static gboolean _folks_individual_aggregator_maybe_configure_as_primary (FolksIndividualAggregator* self, FolksPersonaStore* store) {
	gboolean result = FALSE;
	gboolean configured = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (store != NULL, FALSE);
	g_debug ("individual-aggregator.vala:1946: _maybe_configure_as_primary()");
	configured = FALSE;
	_tmp1_ = self->priv->_user_configured_primary_store;
	if (!_tmp1_) {
		FolksPersonaStore* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = store;
		_tmp3_ = folks_persona_store_get_is_user_set_default (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FolksPersonaStore* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		FolksPersonaStore* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		FolksPersonaStore* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		FolksPersonaStore* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp5_ = store;
		_tmp6_ = folks_persona_store_get_type_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = store;
		_tmp9_ = folks_persona_store_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		g_debug ("individual-aggregator.vala:1953: Setting primary store IDs to '%s' and" \
" '%s'.", _tmp7_, _tmp10_);
		_tmp11_ = store;
		_tmp12_ = folks_persona_store_get_type_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (self->priv->_configured_primary_store_type_id);
		self->priv->_configured_primary_store_type_id = _tmp14_;
		_tmp15_ = store;
		_tmp16_ = folks_persona_store_get_id (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (self->priv->_configured_primary_store_id);
		self->priv->_configured_primary_store_id = _tmp18_;
		configured = TRUE;
	}
	result = configured;
	return result;
}


static void _folks_individual_aggregator_individual_removed_cb (FolksIndividualAggregator* self, FolksIndividual* i, FolksIndividual* replacement) {
	FolksIndividual* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	FolksIndividual* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	FolksIndividual* _tmp7_ = NULL;
	FolksIndividual* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	FolksIndividual* _tmp10_ = NULL;
	FolksIndividual* _tmp20_ = NULL;
	GeeSet* _tmp21_ = NULL;
	GeeSet* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	FolksIndividual* _tmp34_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = i;
	if (_tmp0_ == _tmp1_) {
		folks_individual_aggregator_set_user (self, NULL);
	}
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = i;
	_tmp4_ = folks_individual_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_map_get (_tmp2_, _tmp5_);
	_tmp7_ = (FolksIndividual*) _tmp6_;
	_tmp8_ = i;
	_tmp9_ = _tmp7_ != _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		return;
	}
	_tmp10_ = replacement;
	if (_tmp10_ != NULL) {
		FolksIndividual* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		FolksIndividual* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp11_ = i;
		_tmp12_ = folks_individual_get_id (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = replacement;
		_tmp15_ = folks_individual_get_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_tmp16_ = _tmp15_;
		g_debug ("individual-aggregator.vala:1975: Individual '%s' removed (replaced by " \
"'%s')", _tmp13_, _tmp16_);
	} else {
		FolksIndividual* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp17_ = i;
		_tmp18_ = folks_individual_get_id (_tmp17_);
		_tmp19_ = _tmp18_;
		g_debug ("individual-aggregator.vala:1980: Individual '%s' removed (not replaced" \
")", _tmp19_);
	}
	_tmp20_ = i;
	_tmp21_ = folks_individual_get_personas (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		GeeHashMultiMap* changes = NULL;
		GeeHashMultiMap* _tmp25_ = NULL;
		FolksSmallSet* individuals = NULL;
		FolksSmallSet* _tmp26_ = NULL;
		FolksSmallSet* _tmp27_ = NULL;
		FolksIndividual* _tmp28_ = NULL;
		GeeHashMultiMap* _tmp29_ = NULL;
		FolksIndividual* _tmp30_ = NULL;
		FolksIndividual* _tmp31_ = NULL;
		FolksSmallSet* _tmp32_ = NULL;
		GeeHashMultiMap* _tmp33_ = NULL;
		_tmp25_ = gee_hash_multi_map_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		changes = _tmp25_;
		_tmp26_ = folks_small_set_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		individuals = _tmp26_;
		_tmp27_ = individuals;
		_tmp28_ = i;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_tmp29_ = changes;
		_tmp30_ = i;
		_tmp31_ = replacement;
		gee_multi_map_set ((GeeMultiMap*) _tmp29_, _tmp30_, _tmp31_);
		_tmp32_ = individuals;
		_tmp33_ = changes;
		_folks_individual_aggregator_emit_individuals_changed (self, NULL, (GeeSet*) _tmp32_, (GeeMultiMap*) _tmp33_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (individuals);
		_g_object_unref0 (changes);
	}
	_tmp34_ = i;
	_folks_individual_aggregator_disconnect_from_individual (self, _tmp34_);
}


static void folks_individual_aggregator_add_persona_from_details_data_free (gpointer _data) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->persona_store);
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void folks_individual_aggregator_add_persona_from_details (FolksIndividualAggregator* self, FolksIndividual* parent, FolksPersonaStore* persona_store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	FolksPersonaStore* _tmp3_ = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = parent;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp2_;
	_tmp3_ = persona_store;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->persona_store);
	_data_->persona_store = _tmp4_;
	_tmp5_ = details;
	_tmp6_ = _g_hash_table_ref0 (_tmp5_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp6_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


FolksPersona* folks_individual_aggregator_add_persona_from_details_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new persona in the given {@link PersonaStore} based on the
   * ``details`` provided.
   *
   * If the target store is offline, this function will throw
   * {@link IndividualAggregatorError.STORE_OFFLINE}. It's the responsibility of
   * the caller to cache details and re-try this function if it wishes to make
   * offline adds work.
   *
   * The details hash is a backend-specific mapping of key, value strings.
   * Common keys include:
   *
   *  * contact - service-specific contact ID
   *  * message - a user-readable message to pass to the persona being added
   *
   * If a {@link Persona} with the given details already exists in the store, no
   * error will be thrown and this function will return ``null``.
   *
   * @param parent an optional {@link Individual} to add the new {@link Persona}
   * to. This persona will be appended to its ordered list of personas.
   * @param persona_store the {@link PersonaStore} to add the persona to
   * @param details a key-value map of details to use in creating the new
   * {@link Persona}
   * @return the new {@link Persona} or ``null`` if the corresponding
   * {@link Persona} already existed. If non-``null``, the new {@link Persona}
   * will also be added to a new or existing {@link Individual} as necessary.
   * @throws IndividualAggregatorError.STORE_OFFLINE if the persona store was
   * offline
   * @throws IndividualAggregatorError.ADD_FAILED if any other error occurred
   * while adding the persona
   *
   * @since 0.3.5
   */
static void folks_individual_aggregator_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_add_persona_from_details_co (_data_);
}


static gboolean folks_individual_aggregator_add_persona_from_details_co (FolksIndividualAggregatorAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->persona = NULL;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->details;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _folks_individual_aggregator_asv_copy (_data_->self, _data_->_tmp0_);
		_data_->details_copy = _data_->_tmp1_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->persona_store;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->details_copy;
		_data_->_state_ = 1;
		folks_persona_store_add_persona_from_details (_data_->_tmp3_, _data_->_tmp4_, folks_individual_aggregator_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_hash_table_unref0 (_data_->details_copy);
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch22_folks_persona_store_error;
			}
			_g_hash_table_unref0 (_data_->details_copy);
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->persona);
		_data_->persona = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp2_);
		_g_hash_table_unref0 (_data_->details_copy);
	}
	goto __finally22;
	__catch22_folks_persona_store_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->e;
		if (g_error_matches (_data_->_tmp7_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->e;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_->message;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_STORE_OFFLINE, _data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp10_;
			_g_error_free0 (_data_->e);
			goto __finally22;
		} else {
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->persona_store;
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = folks_persona_store_get_type_id (_data_->_tmp11_);
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->persona_store;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = folks_persona_store_get_id (_data_->_tmp14_);
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _folks_individual_aggregator_get_store_full_id (_data_->self, _data_->_tmp13_, _data_->_tmp16_);
			_data_->full_id = _data_->_tmp17_;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _ ("Failed to add contact for persona store ID '%s': %s");
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->full_id;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->e;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_tmp20_->message;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_ADD_FAILED, _data_->_tmp18_, _data_->_tmp19_, _data_->_tmp21_);
			_data_->_inner_error_ = _data_->_tmp22_;
			_g_free0 (_data_->full_id);
			_g_error_free0 (_data_->e);
			goto __finally22;
		}
		_g_error_free0 (_data_->e);
	}
	__finally22:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->parent;
	if (_data_->_tmp24_ != NULL) {
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->persona;
		_data_->_tmp23_ = _data_->_tmp25_ != NULL;
	} else {
		_data_->_tmp23_ = FALSE;
	}
	if (_data_->_tmp23_) {
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->parent;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = folks_individual_get_personas (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual));
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->persona;
		gee_collection_add ((GeeCollection*) _data_->_tmp28_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, FOLKS_TYPE_PERSONA, FolksPersona));
	}
	_data_->result = _data_->persona;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		FolksIndividualAggregator* self;
		self = _data8_->self;
		_g_hash_table_unref0 (_data8_->retval);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void __lambda70_ (Block8Data* _data8_, const gchar* k, GValue* v) {
	FolksIndividualAggregator* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	self = _data8_->self;
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
	_tmp2_ = v;
	_tmp3_ = __g_value_dup0 (_tmp2_);
	g_hash_table_insert (_data8_->retval, _tmp1_, _tmp3_);
}


static void ___lambda70__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda70_ (self, (const gchar*) key, (GValue*) value);
}


static GHashTable* _folks_individual_aggregator_asv_copy (FolksIndividualAggregator* self, GHashTable* asv) {
	GHashTable* result = NULL;
	Block8Data* _data8_;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (asv != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_GValue_free0_);
	_data8_->retval = _tmp2_;
	_tmp3_ = asv;
	g_hash_table_foreach (_tmp3_, ___lambda70__gh_func, _data8_);
	_tmp4_ = _g_hash_table_ref0 (_data8_->retval);
	result = _tmp4_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


static void folks_individual_aggregator_remove_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemoveIndividualData, _data_);
}


void folks_individual_aggregator_remove_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemoveIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp2_;
	folks_individual_aggregator_remove_individual_co (_data_);
}


void folks_individual_aggregator_remove_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the individual and all of its personas from their
   * backing stores.
   *
   * This method is safe to call multiple times concurrently (for the same
   * individual or different individuals).
   *
   * @param individual the {@link Individual} to remove
   * @throws GLib.Error if removing the persona failed — this will be passed
   * through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemoveIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_individual_co (_data_);
}


static gboolean folks_individual_aggregator_remove_individual_co (FolksIndividualAggregatorRemoveIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->individual;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_individual_get_personas (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = folks_small_set_copy ((GeeIterable*) _data_->_tmp2_, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->personas = _data_->_tmp3_;
	{
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->personas;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
		_data_->_persona_list = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_persona_list;
		_data_->_tmp7_ = 0;
		_data_->_tmp7_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp6_);
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_persona_size = _data_->_tmp8_;
		_data_->_persona_index = -1;
		while (TRUE) {
			_data_->_tmp9_ = 0;
			_data_->_tmp9_ = _data_->_persona_index;
			_data_->_persona_index = _data_->_tmp9_ + 1;
			_data_->_tmp10_ = 0;
			_data_->_tmp10_ = _data_->_persona_index;
			_data_->_tmp11_ = 0;
			_data_->_tmp11_ = _data_->_persona_size;
			if (!(_data_->_tmp10_ < _data_->_tmp11_)) {
				break;
			}
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->_persona_list;
			_data_->_tmp13_ = 0;
			_data_->_tmp13_ = _data_->_persona_index;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = folks_small_set_get (_data_->_tmp12_, _data_->_tmp13_);
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp14_);
			_data_->persona = _data_->_tmp15_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->persona;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = folks_persona_get_store (_data_->_tmp16_);
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->persona;
			_data_->_state_ = 1;
			folks_persona_store_remove_persona (_data_->_tmp18_, _data_->_tmp19_, folks_individual_aggregator_remove_individual_ready, _data_);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->persona);
				_g_object_unref0 (_data_->_persona_list);
				_g_object_unref0 (_data_->personas);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->persona);
		}
		_g_object_unref0 (_data_->_persona_list);
	}
	_g_object_unref0 (_data_->personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_remove_persona_data_free (gpointer _data) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorRemovePersonaData, _data_);
}


void folks_individual_aggregator_remove_persona (FolksIndividualAggregator* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	folks_individual_aggregator_remove_persona_co (_data_);
}


void folks_individual_aggregator_remove_persona_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Completely remove the persona from its backing store.
   *
   * This will leave other personas in the same individual alone.
   *
   * This method is safe to call multiple times concurrently (for the same
   * persona or different personas).
   *
   * @param persona the {@link Persona} to remove
   * @throws GLib.Error if removing the persona failed — this will be passed
   * through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.11
   */
static void folks_individual_aggregator_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_remove_persona_co (_data_);
}


static gboolean folks_individual_aggregator_remove_persona_co (FolksIndividualAggregatorRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_persona_get_store (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->persona;
	_data_->_state_ = 1;
	folks_persona_store_remove_persona (_data_->_tmp2_, _data_->_tmp3_, folks_individual_aggregator_remove_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_persona_store_remove_persona_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_link_personas_data_free (gpointer _data) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->personas);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorLinkPersonasData, _data_);
}


void folks_individual_aggregator_link_personas (FolksIndividualAggregator* self, GeeSet* personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLinkPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_link_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_link_personas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->personas);
	_data_->personas = _tmp2_;
	folks_individual_aggregator_link_personas_co (_data_);
}


void folks_individual_aggregator_link_personas_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Link the given {@link Persona}s together.
   *
   * Create links between the given {@link Persona}s so that they form a single
   * {@link Individual}. The new {@link Individual} will be returned via the
   * {@link IndividualAggregator.individuals_changed} signal.
   *
   * Removal of the {@link Individual}s which the {@link Persona}s were in
   * before is signalled by {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param personas the {@link Persona}s to be linked
   * @throws IndividualAggregatorError.NO_PRIMARY_STORE if no primary store has
   * been configured for the individual aggregator
   * @throws IndividualAggregatorError if adding the linking persona failed —
   * this will be passed through from
   * {@link IndividualAggregator.add_persona_from_details}
   *
   * @since 0.5.1
   */
static void folks_individual_aggregator_link_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLinkPersonasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_link_personas_co (_data_);
}


static gboolean folks_individual_aggregator_link_personas_co (FolksIndividualAggregatorLinkPersonasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_primary_store;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Can’t link personas with no primary store.");
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_strconcat (_data_->_tmp1_, "\n", NULL);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Persona store ‘%s:%s’ is configured as primary, but could not be found" \
" or failed to load.");
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_strconcat (_data_->_tmp3_, _data_->_tmp4_, NULL);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat (_data_->_tmp6_, "\n", NULL);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _ ("Check the relevant service is running, or change the default store in " \
"that service or using the “%s” GSettings key.");
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strconcat (_data_->_tmp8_, _data_->_tmp9_, NULL);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->_configured_primary_store_type_id;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->_configured_primary_store_id;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_strdup_printf ("%s %s", FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA, FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE, _data_->_tmp11_, _data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_);
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp16_;
		_g_free0 (_data_->_tmp15_);
		_g_free0 (_data_->_tmp11_);
		_g_free0 (_data_->_tmp8_);
		_g_free0 (_data_->_tmp6_);
		_g_free0 (_data_->_tmp3_);
		_data_->_inner_error_ = _data_->_tmp17_;
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->personas;
	_data_->_tmp19_ = 0;
	_data_->_tmp19_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp18_);
	_data_->_tmp20_ = 0;
	_data_->_tmp20_ = _data_->_tmp19_;
	if (_data_->_tmp20_ <= 1) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = FALSE;
	_data_->_tmp21_ = _data_->self->priv->_linking_enabled;
	if (_data_->_tmp21_ == FALSE) {
		g_debug ("individual-aggregator.vala:2168: Can't link Personas: linking disabled" \
".");
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->personas;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp22_);
		_data_->_p_it = _data_->_tmp23_;
		while (TRUE) {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->_p_it;
			_data_->_tmp25_ = FALSE;
			_data_->_tmp25_ = gee_iterator_next (_data_->_tmp24_);
			if (!_data_->_tmp25_) {
				break;
			}
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_p_it;
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = gee_iterator_get (_data_->_tmp26_);
			_data_->p = (FolksPersona*) _data_->_tmp27_;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->p;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp28_, FOLKS_TYPE_ANTI_LINKABLE) ? ((FolksAntiLinkable*) _data_->_tmp28_) : NULL);
			_data_->al = _data_->_tmp29_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->al;
			if (_data_->_tmp30_ != NULL) {
				{
					_data_->_tmp31_ = NULL;
					_data_->_tmp31_ = _data_->al;
					_data_->_tmp32_ = NULL;
					_data_->_tmp32_ = _data_->personas;
					_data_->_state_ = 1;
					folks_anti_linkable_remove_anti_links (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->_tmp32_, folks_individual_aggregator_link_personas_ready, _data_);
					return FALSE;
					_state_1:
					folks_anti_linkable_remove_anti_links_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
							goto __catch23_folks_property_error;
						}
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
				goto __finally23;
				__catch23_folks_property_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp33_ = NULL;
					_data_->_tmp33_ = _ ("Anti-links can't be removed between personas being linked.");
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = g_error_new_literal (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, _data_->_tmp33_);
					_data_->_inner_error_ = _data_->_tmp34_;
					_g_error_free0 (_data_->e);
					goto __finally23;
				}
				__finally23:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->al);
						_g_object_unref0 (_data_->p);
						_g_object_unref0 (_data_->_p_it);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
			}
			_g_object_unref0 (_data_->al);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->self->priv->_primary_store;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = folks_persona_store_get_type_id (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore));
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->self->priv->_configured_primary_store_type_id;
	_vala_assert (g_strcmp0 (_data_->_tmp37_, _data_->_tmp38_) == 0, "((!) this._primary_store).type_id ==           this._configured_primary_store_type_id");
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->personas;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _folks_individual_aggregator_build_linking_details (_data_->self, _data_->_tmp39_);
	_data_->details = _data_->_tmp40_;
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->self->priv->_primary_store;
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = _data_->details;
	_data_->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp41_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), _data_->_tmp42_, folks_individual_aggregator_link_personas_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = _data_->_tmp43_;
	_g_object_unref0 (_data_->_tmp44_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_hash_table_unref0 (_data_->details);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->details);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_hash_table_unref0 (_data_->details);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint _folks_abstract_field_details_hash_static_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = folks_abstract_field_details_hash_static ((FolksAbstractFieldDetails*) v);
	return result;
}


static gboolean _folks_abstract_field_details_equal_static_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = folks_abstract_field_details_equal_static ((FolksAbstractFieldDetails*) a, (FolksAbstractFieldDetails*) b);
	return result;
}


static GHashTable* _folks_individual_aggregator_build_linking_details (FolksIndividualAggregator* self, GeeSet* personas) {
	GHashTable* result = NULL;
	GeeHashMultiMap* protocols_addrs_set = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
	GeeHashMultiMap* web_service_addrs_set = NULL;
	GeeHashMultiMap* _tmp1_ = NULL;
	FolksSmallSet* local_ids = NULL;
	FolksSmallSet* _tmp2_ = NULL;
	GHashTable* details = NULL;
	GHashFunc _tmp52_ = NULL;
	GEqualFunc _tmp53_ = NULL;
	GHashTable* _tmp54_ = NULL;
	GeeHashMultiMap* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	GeeHashMultiMap* _tmp66_ = NULL;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	FolksSmallSet* _tmp77_ = NULL;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (personas != NULL, NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	protocols_addrs_set = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _folks_abstract_field_details_hash_static_gee_hash_data_func, NULL, NULL, _folks_abstract_field_details_equal_static_gee_equal_data_func, NULL, NULL);
	web_service_addrs_set = _tmp1_;
	_tmp2_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	local_ids = _tmp2_;
	{
		GeeIterator* _persona_it = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		_tmp3_ = personas;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_persona_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp7_ = NULL;
			gpointer _tmp8_ = NULL;
			FolksPersona* _tmp9_ = NULL;
			FolksPersona* _tmp25_ = NULL;
			FolksPersona* _tmp41_ = NULL;
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _persona_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			persona = (FolksPersona*) _tmp8_;
			_tmp9_ = persona;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, FOLKS_TYPE_IM_DETAILS)) {
				FolksImDetails* im_details = NULL;
				FolksPersona* _tmp10_ = NULL;
				FolksImDetails* _tmp11_ = NULL;
				GeeMapIterator* iter = NULL;
				FolksImDetails* _tmp12_ = NULL;
				GeeMultiMap* _tmp13_ = NULL;
				GeeMultiMap* _tmp14_ = NULL;
				GeeMapIterator* _tmp15_ = NULL;
				_tmp10_ = persona;
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, FOLKS_TYPE_IM_DETAILS, FolksImDetails));
				im_details = _tmp11_;
				_tmp12_ = im_details;
				_tmp13_ = folks_im_details_get_im_addresses (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_multi_map_map_iterator (_tmp14_);
				iter = _tmp15_;
				while (TRUE) {
					GeeMapIterator* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					GeeHashMultiMap* _tmp18_ = NULL;
					GeeMapIterator* _tmp19_ = NULL;
					gpointer _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					GeeMapIterator* _tmp22_ = NULL;
					gpointer _tmp23_ = NULL;
					FolksImFieldDetails* _tmp24_ = NULL;
					_tmp16_ = iter;
					_tmp17_ = gee_map_iterator_next (_tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = protocols_addrs_set;
					_tmp19_ = iter;
					_tmp20_ = gee_map_iterator_get_key (_tmp19_);
					_tmp21_ = (gchar*) _tmp20_;
					_tmp22_ = iter;
					_tmp23_ = gee_map_iterator_get_value (_tmp22_);
					_tmp24_ = (FolksImFieldDetails*) _tmp23_;
					gee_multi_map_set ((GeeMultiMap*) _tmp18_, _tmp21_, _tmp24_);
					_g_object_unref0 (_tmp24_);
					_g_free0 (_tmp21_);
				}
				_g_object_unref0 (iter);
				_g_object_unref0 (im_details);
			}
			_tmp25_ = persona;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, FOLKS_TYPE_WEB_SERVICE_DETAILS)) {
				FolksWebServiceDetails* ws_details = NULL;
				FolksPersona* _tmp26_ = NULL;
				FolksWebServiceDetails* _tmp27_ = NULL;
				GeeMapIterator* iter = NULL;
				FolksWebServiceDetails* _tmp28_ = NULL;
				GeeMultiMap* _tmp29_ = NULL;
				GeeMultiMap* _tmp30_ = NULL;
				GeeMapIterator* _tmp31_ = NULL;
				_tmp26_ = persona;
				_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, FOLKS_TYPE_WEB_SERVICE_DETAILS, FolksWebServiceDetails));
				ws_details = _tmp27_;
				_tmp28_ = ws_details;
				_tmp29_ = folks_web_service_details_get_web_service_addresses (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = gee_multi_map_map_iterator (_tmp30_);
				iter = _tmp31_;
				while (TRUE) {
					GeeMapIterator* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					GeeHashMultiMap* _tmp34_ = NULL;
					GeeMapIterator* _tmp35_ = NULL;
					gpointer _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					GeeMapIterator* _tmp38_ = NULL;
					gpointer _tmp39_ = NULL;
					FolksWebServiceFieldDetails* _tmp40_ = NULL;
					_tmp32_ = iter;
					_tmp33_ = gee_map_iterator_next (_tmp32_);
					if (!_tmp33_) {
						break;
					}
					_tmp34_ = web_service_addrs_set;
					_tmp35_ = iter;
					_tmp36_ = gee_map_iterator_get_key (_tmp35_);
					_tmp37_ = (gchar*) _tmp36_;
					_tmp38_ = iter;
					_tmp39_ = gee_map_iterator_get_value (_tmp38_);
					_tmp40_ = (FolksWebServiceFieldDetails*) _tmp39_;
					gee_multi_map_set ((GeeMultiMap*) _tmp34_, _tmp37_, _tmp40_);
					_g_object_unref0 (_tmp40_);
					_g_free0 (_tmp37_);
				}
				_g_object_unref0 (iter);
				_g_object_unref0 (ws_details);
			}
			_tmp41_ = persona;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, FOLKS_TYPE_LOCAL_ID_DETAILS)) {
				{
					GeeIterator* _id_it = NULL;
					FolksPersona* _tmp42_ = NULL;
					GeeSet* _tmp43_ = NULL;
					GeeSet* _tmp44_ = NULL;
					GeeIterator* _tmp45_ = NULL;
					_tmp42_ = persona;
					_tmp43_ = folks_local_id_details_get_local_ids (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, FOLKS_TYPE_LOCAL_ID_DETAILS, FolksLocalIdDetails));
					_tmp44_ = _tmp43_;
					_tmp45_ = gee_iterable_iterator ((GeeIterable*) _tmp44_);
					_id_it = _tmp45_;
					while (TRUE) {
						GeeIterator* _tmp46_ = NULL;
						gboolean _tmp47_ = FALSE;
						gchar* id = NULL;
						GeeIterator* _tmp48_ = NULL;
						gpointer _tmp49_ = NULL;
						FolksSmallSet* _tmp50_ = NULL;
						const gchar* _tmp51_ = NULL;
						_tmp46_ = _id_it;
						_tmp47_ = gee_iterator_next (_tmp46_);
						if (!_tmp47_) {
							break;
						}
						_tmp48_ = _id_it;
						_tmp49_ = gee_iterator_get (_tmp48_);
						id = (gchar*) _tmp49_;
						_tmp50_ = local_ids;
						_tmp51_ = id;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
						_g_free0 (id);
					}
					_g_object_unref0 (_id_it);
				}
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp52_ = g_str_hash;
	_tmp53_ = g_str_equal;
	_tmp54_ = g_hash_table_new_full (_tmp52_, _tmp53_, _g_free0_, __vala_GValue_free0_);
	details = _tmp54_;
	_tmp55_ = protocols_addrs_set;
	_tmp56_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp57_ > 0) {
		GValue im_addresses_value = {0};
		GValue _tmp58_ = {0};
		GeeHashMultiMap* _tmp59_ = NULL;
		GHashTable* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		GValue _tmp63_ = {0};
		GValue _tmp64_ = {0};
		GValue* _tmp65_ = NULL;
		g_value_init (&_tmp58_, GEE_TYPE_MULTI_MAP);
		im_addresses_value = _tmp58_;
		_tmp59_ = protocols_addrs_set;
		g_value_set_object (&im_addresses_value, (GObject*) _tmp59_);
		_tmp60_ = details;
		_tmp61_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
		_tmp62_ = g_strdup ((const gchar*) _tmp61_);
		_tmp63_ = im_addresses_value;
		_tmp64_ = _tmp63_;
		_tmp65_ = __g_value_dup0 (&_tmp64_);
		g_hash_table_insert (_tmp60_, _tmp62_, _tmp65_);
		G_IS_VALUE (&im_addresses_value) ? (g_value_unset (&im_addresses_value), NULL) : NULL;
	}
	_tmp66_ = web_service_addrs_set;
	_tmp67_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp66_);
	_tmp68_ = _tmp67_;
	if (_tmp68_ > 0) {
		GValue web_service_addresses_value = {0};
		GValue _tmp69_ = {0};
		GeeHashMultiMap* _tmp70_ = NULL;
		GHashTable* _tmp71_ = NULL;
		const gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		GValue _tmp74_ = {0};
		GValue _tmp75_ = {0};
		GValue* _tmp76_ = NULL;
		g_value_init (&_tmp69_, GEE_TYPE_MULTI_MAP);
		web_service_addresses_value = _tmp69_;
		_tmp70_ = web_service_addrs_set;
		g_value_set_object (&web_service_addresses_value, (GObject*) _tmp70_);
		_tmp71_ = details;
		_tmp72_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
		_tmp73_ = g_strdup ((const gchar*) _tmp72_);
		_tmp74_ = web_service_addresses_value;
		_tmp75_ = _tmp74_;
		_tmp76_ = __g_value_dup0 (&_tmp75_);
		g_hash_table_insert (_tmp71_, _tmp73_, _tmp76_);
		G_IS_VALUE (&web_service_addresses_value) ? (g_value_unset (&web_service_addresses_value), NULL) : NULL;
	}
	_tmp77_ = local_ids;
	_tmp78_ = gee_collection_get_size ((GeeCollection*) _tmp77_);
	_tmp79_ = _tmp78_;
	if (_tmp79_ > 0) {
		GValue local_ids_value = {0};
		GValue _tmp80_ = {0};
		FolksSmallSet* _tmp81_ = NULL;
		GHashTable* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		GValue _tmp85_ = {0};
		GValue _tmp86_ = {0};
		GValue* _tmp87_ = NULL;
		g_value_init (&_tmp80_, GEE_TYPE_SET);
		local_ids_value = _tmp80_;
		_tmp81_ = local_ids;
		g_value_set_object (&local_ids_value, (GObject*) _tmp81_);
		_tmp82_ = details;
		_tmp83_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_LOCAL_IDS);
		_tmp84_ = g_strdup ((const gchar*) _tmp83_);
		_tmp85_ = local_ids_value;
		_tmp86_ = _tmp85_;
		_tmp87_ = __g_value_dup0 (&_tmp86_);
		g_hash_table_insert (_tmp82_, _tmp84_, _tmp87_);
		G_IS_VALUE (&local_ids_value) ? (g_value_unset (&local_ids_value), NULL) : NULL;
	}
	result = details;
	_g_object_unref0 (local_ids);
	_g_object_unref0 (web_service_addrs_set);
	_g_object_unref0 (protocols_addrs_set);
	return result;
}


static void folks_individual_aggregator_unlink_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorUnlinkIndividualData, _data_);
}


void folks_individual_aggregator_unlink_individual (FolksIndividualAggregator* self, FolksIndividual* individual, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorUnlinkIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_unlink_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_unlink_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp2_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}


void folks_individual_aggregator_unlink_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Unlinks the given {@link Individual} into its constituent {@link Persona}s.
   *
   * This completely unlinks the given {@link Individual}, destroying all of
   * its writeable {@link Persona}s.
   *
   * The {@link Individual}'s removal is signalled by
   * {@link IndividualAggregator.individuals_changed} and
   * {@link Individual.removed}.
   *
   * The {@link Persona}s comprising the {@link Individual} will be re-linked
   * into one or more new {@link Individual}s, depending on how much linking
   * data remains (typically only implicit links remain). The addition of these
   * new {@link Individual}s will be signalled by
   * {@link IndividualAggregator.individuals_changed}.
   *
   * This method is safe to call multiple times concurrently, although
   * concurrent calls for the same individual may result in duplicate personas
   * being created.
   *
   * @param individual the {@link Individual} to unlink
   * @throws GLib.Error if removing the linking persona failed — this will be
   * passed through from {@link PersonaStore.remove_persona}
   *
   * @since 0.1.13
   */
static void folks_individual_aggregator_unlink_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorUnlinkIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_unlink_individual_co (_data_);
}


static gboolean folks_individual_aggregator_unlink_individual_co (FolksIndividualAggregatorUnlinkIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->_linking_enabled;
	if (_data_->_tmp0_ == FALSE) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->individual;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = folks_individual_get_id (_data_->_tmp1_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_;
		g_debug ("individual-aggregator.vala:2310: Can't unlink Individual '%s': linking" \
" disabled.", _data_->_tmp3_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->individual;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = folks_individual_get_id (_data_->_tmp4_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	g_debug ("individual-aggregator.vala:2315: Unlinking Individual '%s':", _data_->_tmp6_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->individual;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = folks_individual_get_personas (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = folks_small_set_copy ((GeeIterable*) _data_->_tmp9_, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->individual_personas = _data_->_tmp10_;
	g_debug ("individual-aggregator.vala:2331:     Inserting anti-links:");
	{
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->individual_personas;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _g_object_ref0 (_data_->_tmp11_);
		_data_->_pers_list = _data_->_tmp12_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_pers_list;
		_data_->_tmp14_ = 0;
		_data_->_tmp14_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp13_);
		_data_->_tmp15_ = 0;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_pers_size = _data_->_tmp15_;
		_data_->_pers_index = -1;
		while (TRUE) {
			_data_->_tmp16_ = 0;
			_data_->_tmp16_ = _data_->_pers_index;
			_data_->_pers_index = _data_->_tmp16_ + 1;
			_data_->_tmp17_ = 0;
			_data_->_tmp17_ = _data_->_pers_index;
			_data_->_tmp18_ = 0;
			_data_->_tmp18_ = _data_->_pers_size;
			if (!(_data_->_tmp17_ < _data_->_tmp18_)) {
				break;
			}
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->_pers_list;
			_data_->_tmp20_ = 0;
			_data_->_tmp20_ = _data_->_pers_index;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = folks_small_set_get (_data_->_tmp19_, _data_->_tmp20_);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _g_object_ref0 ((FolksPersona*) _data_->_tmp21_);
			_data_->pers = _data_->_tmp22_;
			{
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_data_->personas = _data_->_tmp23_;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->personas;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->pers;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp24_, _data_->_tmp25_);
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->pers;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = folks_persona_get_uid (_data_->_tmp26_);
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = _data_->_tmp27_;
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->pers;
				g_debug ("individual-aggregator.vala:2338:         Anti-linking persona '%s' (%p" \
")", _data_->_tmp28_, _data_->_tmp29_);
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->personas;
				_data_->_state_ = 1;
				_folks_individual_aggregator_ensure_personas_property_writeable (_data_->self, (GeeSet*) _data_->_tmp30_, "anti-links", folks_individual_aggregator_unlink_individual_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _folks_individual_aggregator_ensure_personas_property_writeable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
				_data_->writeable_persona = _data_->_tmp31_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->personas);
					if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						goto __catch24_folks_individual_aggregator_error;
					}
					_g_object_unref0 (_data_->personas);
					_g_object_unref0 (_data_->pers);
					_g_object_unref0 (_data_->_pers_list);
					_g_object_unref0 (_data_->individual_personas);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->writeable_persona;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = folks_persona_get_uid (_data_->_tmp32_);
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->_tmp33_;
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = _data_->writeable_persona;
				g_debug ("individual-aggregator.vala:2343:         Writeable persona '%s' (%p)", _data_->_tmp34_, _data_->_tmp35_);
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = _data_->individual_personas;
				_data_->_tmp37_ = NULL;
				_data_->_tmp37_ = folks_small_set_copy ((GeeIterable*) _data_->_tmp36_, NULL, NULL, NULL, NULL, NULL, NULL);
				_data_->anti_link_personas = _data_->_tmp37_;
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = _data_->anti_link_personas;
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->pers;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp38_, _data_->_tmp39_);
				_data_->_tmp40_ = NULL;
				_data_->_tmp40_ = _data_->writeable_persona;
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp40_, FOLKS_TYPE_ANTI_LINKABLE) ? ((FolksAntiLinkable*) _data_->_tmp40_) : NULL);
				_data_->al = _data_->_tmp41_;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = _data_->al;
				_vala_assert (_data_->_tmp42_ != NULL, "al != null");
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->al;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->anti_link_personas;
				_data_->_state_ = 2;
				folks_anti_linkable_add_anti_links (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), (GeeSet*) _data_->_tmp44_, folks_individual_aggregator_unlink_individual_ready, _data_);
				return FALSE;
				_state_2:
				folks_anti_linkable_add_anti_links_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, FOLKS_TYPE_ANTI_LINKABLE, FolksAntiLinkable), _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->al);
					_g_object_unref0 (_data_->anti_link_personas);
					_g_object_unref0 (_data_->writeable_persona);
					_g_object_unref0 (_data_->personas);
					if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						goto __catch24_folks_individual_aggregator_error;
					}
					goto __finally24;
				}
				g_debug ("individual-aggregator.vala:2353: ");
				_g_object_unref0 (_data_->al);
				_g_object_unref0 (_data_->anti_link_personas);
				_g_object_unref0 (_data_->writeable_persona);
				_g_object_unref0 (_data_->personas);
			}
			goto __finally24;
			__catch24_folks_individual_aggregator_error:
			{
				_data_->e1 = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = _data_->e1;
				_data_->_tmp46_ = NULL;
				_data_->_tmp46_ = _data_->_tmp45_->message;
				g_debug ("    Failed to ensure anti-links property is writeable " "(continuing anyway): %s", _data_->_tmp46_);
				_g_error_free0 (_data_->e1);
			}
			__finally24:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->pers);
				_g_object_unref0 (_data_->_pers_list);
				_g_object_unref0 (_data_->individual_personas);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->pers);
		}
		_g_object_unref0 (_data_->_pers_list);
	}
	_g_object_unref0 (_data_->individual_personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_ensure_individual_property_writeable_data_free (gpointer _data) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->individual);
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData, _data_);
}


void folks_individual_aggregator_ensure_individual_property_writeable (FolksIndividualAggregator* self, FolksIndividual* individual, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_ensure_individual_property_writeable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_ensure_individual_property_writeable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = individual;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->individual);
	_data_->individual = _tmp2_;
	_tmp3_ = property_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp4_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}


FolksPersona* folks_individual_aggregator_ensure_individual_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Ensure that the given property is writeable for the given
   * {@link Individual}.
   *
   * This makes sure that there is at least one {@link Persona} in the
   * individual which has ``property_name`` in its
   * {@link Persona.writeable_properties}. If no such persona exists in the
   * individual, a new one will be created and linked to the individual. (Note
   * that due to the design of the aggregator, this will result in the previous
   * individual being removed and replaced by a new one with the new persona;
   * listen to the {@link Individual.removed} signal to see the replacement.)
   *
   * It may not be possible to create a new persona which has the given property
   * as writeable. In that case, a
   * {@link IndividualAggregatorError.NO_PRIMARY_STORE} or
   * {@link IndividualAggregatorError.PROPERTY_NOT_WRITEABLE} error will be
   * thrown.
   *
   * This method is safe to call multiple times concurrently, although
   * concurrent calls for the same individual may result in duplicate personas
   * being created.
   *
   * @param individual the individual for which ``property_name`` should be
   * writeable
   * @param property_name the name of the property which needs to be writeable
   * (this should be in lower case using hyphens, e.g. “web-service-addresses”)
   * @return a persona (new or existing) which has the given property as
   * writeable
   * @throws IndividualAggregatorError.NO_PRIMARY_STORE if no primary store was
   * configured for this individual aggregator
   * @throws IndividualAggregatorError.PROPERTY_NOT_WRITEABLE if the given
   * ``property_name`` referred to a non-writeable property
   * @throws IndividualAggregatorError if adding a new persona (using
   * {@link IndividualAggregator.add_persona_from_details}) failed, or if
   * linking personas (using {@link IndividualAggregator.link_personas}) failed
   *
   * @since 0.6.2
   */
static void folks_individual_aggregator_ensure_individual_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_ensure_individual_property_writeable_co (_data_);
}


static gboolean folks_individual_aggregator_ensure_individual_property_writeable_co (FolksIndividualAggregatorEnsureIndividualPropertyWriteableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->individual;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_individual_get_id (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->property_name;
	g_debug ("individual-aggregator.vala:2405: ensure_individual_property_writeable:" \
" %s, %s", _data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->individual;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = folks_individual_get_personas (_data_->_tmp4_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->property_name;
	_data_->_state_ = 1;
	_folks_individual_aggregator_ensure_personas_property_writeable (_data_->self, _data_->_tmp6_, _data_->_tmp7_, folks_individual_aggregator_ensure_individual_property_writeable_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _folks_individual_aggregator_ensure_personas_property_writeable_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->p = _data_->_tmp8_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->result = _data_->p;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->p);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_individual_aggregator_ensure_personas_property_writeable_data_free (gpointer _data) {
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->personas);
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData, _data_);
}


static void _folks_individual_aggregator_ensure_personas_property_writeable (FolksIndividualAggregator* self, GeeSet* personas, const gchar* property_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_individual_aggregator_ensure_personas_property_writeable);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_individual_aggregator_ensure_personas_property_writeable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = personas;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->personas);
	_data_->personas = _tmp2_;
	_tmp3_ = property_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp4_;
	_folks_individual_aggregator_ensure_personas_property_writeable_co (_data_);
}


static FolksPersona* _folks_individual_aggregator_ensure_personas_property_writeable_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _folks_individual_aggregator_ensure_personas_property_writeable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_individual_aggregator_ensure_personas_property_writeable_co (_data_);
}


static gboolean _folks_individual_aggregator_ensure_personas_property_writeable_co (FolksIndividualAggregatorEnsurePersonasPropertyWriteableData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->personas;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp0_);
		_data_->_p1_it = _data_->_tmp1_;
		while (TRUE) {
			_data_->_tmp2_ = NULL;
			_data_->_tmp2_ = _data_->_p1_it;
			_data_->_tmp3_ = FALSE;
			_data_->_tmp3_ = gee_iterator_next (_data_->_tmp2_);
			if (!_data_->_tmp3_) {
				break;
			}
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = _data_->_p1_it;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = gee_iterator_get (_data_->_tmp4_);
			_data_->p1 = (FolksPersona*) _data_->_tmp5_;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->property_name;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->p1;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8__length1 = 0;
			_data_->_tmp8_ = folks_persona_get_writeable_properties (_data_->_tmp7_, &_data_->_tmp8__length1);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9__length1 = 0;
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp9__length1 = _data_->_tmp8__length1;
			if (_vala_string_array_contains (_data_->_tmp9_, _data_->_tmp9__length1, _data_->_tmp6_)) {
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->p1;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = folks_persona_get_uid (_data_->_tmp10_);
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = _data_->_tmp11_;
				g_debug ("individual-aggregator.vala:2425:     Returning existing persona: %s", _data_->_tmp12_);
				_data_->result = _data_->p1;
				_g_object_unref0 (_data_->_p1_it);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->p1);
		}
		_g_object_unref0 (_data_->_p1_it);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->personas;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _folks_individual_aggregator_build_linking_details (_data_->self, _data_->_tmp13_);
	_data_->details = _data_->_tmp14_;
	_data_->new_persona = NULL;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->self->priv->_primary_store;
	if (_data_->_tmp16_ != NULL) {
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->property_name;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->self->priv->_primary_store;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19__length1 = 0;
		_data_->_tmp19_ = folks_persona_store_get_always_writeable_properties (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), &_data_->_tmp19__length1);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20__length1 = 0;
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp20__length1 = _data_->_tmp19__length1;
		_data_->_tmp15_ = _vala_string_array_contains (_data_->_tmp20_, _data_->_tmp20__length1, _data_->_tmp17_);
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		{
			g_debug ("individual-aggregator.vala:2442:     Using writeable store");
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->self->priv->_primary_store;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->details;
			_data_->_state_ = 1;
			folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore), _data_->_tmp23_, _folks_individual_aggregator_ensure_personas_property_writeable_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp21_ = _data_->_tmp24_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
					goto __catch25_folks_individual_aggregator_error;
				}
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->_tmp21_;
			_data_->_tmp21_ = NULL;
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = _data_->_tmp25_;
			_g_object_unref0 (_data_->_tmp21_);
		}
		goto __finally25;
		__catch25_folks_individual_aggregator_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_object_unref0 (_data_->new_persona);
			_data_->new_persona = NULL;
			_g_error_free0 (_data_->e1);
		}
		__finally25:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->new_persona;
	if (_data_->_tmp26_ == NULL) {
		{
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->self->priv->_stores;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp27_);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp30_);
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->_tmp31_;
			_g_object_unref0 (_data_->_tmp30_);
			_data_->_s_it = _data_->_tmp32_;
			while (TRUE) {
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = _data_->_s_it;
				_data_->_tmp34_ = FALSE;
				_data_->_tmp34_ = gee_iterator_next (_data_->_tmp33_);
				if (!_data_->_tmp34_) {
					break;
				}
				_data_->_tmp35_ = NULL;
				_data_->_tmp35_ = _data_->_s_it;
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = gee_iterator_get (_data_->_tmp35_);
				_data_->s = (FolksPersonaStore*) _data_->_tmp36_;
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = _data_->s;
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->self->priv->_primary_store;
				if (_data_->_tmp38_ == _data_->_tmp39_) {
					_data_->_tmp37_ = TRUE;
				} else {
					_data_->_tmp40_ = NULL;
					_data_->_tmp40_ = _data_->property_name;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = _data_->s;
					_data_->_tmp42_ = NULL;
					_data_->_tmp42__length1 = 0;
					_data_->_tmp42_ = folks_persona_store_get_always_writeable_properties (_data_->_tmp41_, &_data_->_tmp42__length1);
					_data_->_tmp43_ = NULL;
					_data_->_tmp43__length1 = 0;
					_data_->_tmp43_ = _data_->_tmp42_;
					_data_->_tmp43__length1 = _data_->_tmp42__length1;
					_data_->_tmp37_ = !_vala_string_array_contains (_data_->_tmp43_, _data_->_tmp43__length1, _data_->_tmp40_);
				}
				if (_data_->_tmp37_) {
					_g_object_unref0 (_data_->s);
					continue;
				}
				{
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = _data_->s;
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = folks_persona_store_get_id (_data_->_tmp44_);
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->_tmp45_;
					g_debug ("individual-aggregator.vala:2466:     Using store %s", _data_->_tmp46_);
					_data_->_tmp48_ = NULL;
					_data_->_tmp48_ = _data_->s;
					_data_->_tmp49_ = NULL;
					_data_->_tmp49_ = _data_->details;
					_data_->_state_ = 2;
					folks_individual_aggregator_add_persona_from_details (_data_->self, NULL, _data_->_tmp48_, _data_->_tmp49_, _folks_individual_aggregator_ensure_personas_property_writeable_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp50_ = NULL;
					_data_->_tmp50_ = folks_individual_aggregator_add_persona_from_details_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
					_data_->_tmp47_ = _data_->_tmp50_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
							goto __catch26_folks_individual_aggregator_error;
						}
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_data_->_tmp51_ = NULL;
					_data_->_tmp51_ = _data_->_tmp47_;
					_data_->_tmp47_ = NULL;
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = _data_->_tmp51_;
					_g_object_unref0 (_data_->_tmp47_);
				}
				goto __finally26;
				__catch26_folks_individual_aggregator_error:
				{
					_data_->e2 = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_object_unref0 (_data_->new_persona);
					_data_->new_persona = NULL;
					_g_error_free0 (_data_->e2);
					_g_object_unref0 (_data_->s);
					continue;
				}
				__finally26:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
						g_error_free (_data_->_inner_error_);
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						if (_data_->_state_ == 0) {
							g_simple_async_result_complete_in_idle (_data_->_async_result);
						} else {
							g_simple_async_result_complete (_data_->_async_result);
						}
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_g_object_unref0 (_data_->s);
						_g_object_unref0 (_data_->_s_it);
						_g_object_unref0 (_data_->new_persona);
						_g_hash_table_unref0 (_data_->details);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->s);
			}
			_g_object_unref0 (_data_->_s_it);
		}
	}
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = _data_->new_persona;
	if (_data_->_tmp53_ == NULL) {
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->self->priv->_primary_store;
		_data_->_tmp52_ = _data_->_tmp54_ == NULL;
	} else {
		_data_->_tmp52_ = FALSE;
	}
	if (_data_->_tmp52_) {
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _ ("Can’t add personas with no primary store.");
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = g_strconcat (_data_->_tmp55_, "\n", NULL);
		_data_->_tmp57_ = NULL;
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->_tmp58_ = NULL;
		_data_->_tmp58_ = _ ("Persona store ‘%s:%s’ is configured as primary, but could not be found" \
" or failed to load.");
		_data_->_tmp59_ = NULL;
		_data_->_tmp59_ = g_strconcat (_data_->_tmp57_, _data_->_tmp58_, NULL);
		_data_->_tmp60_ = NULL;
		_data_->_tmp60_ = _data_->_tmp59_;
		_data_->_tmp61_ = NULL;
		_data_->_tmp61_ = g_strconcat (_data_->_tmp60_, "\n", NULL);
		_data_->_tmp62_ = NULL;
		_data_->_tmp62_ = _data_->_tmp61_;
		_data_->_tmp63_ = NULL;
		_data_->_tmp63_ = _ ("Check the relevant service is running, or change the default store in " \
"that service or using the “%s” GSettings key.");
		_data_->_tmp64_ = NULL;
		_data_->_tmp64_ = g_strconcat (_data_->_tmp62_, _data_->_tmp63_, NULL);
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = _data_->_tmp64_;
		_data_->_tmp66_ = NULL;
		_data_->_tmp66_ = _data_->self->priv->_configured_primary_store_type_id;
		_data_->_tmp67_ = NULL;
		_data_->_tmp67_ = _data_->self->priv->_configured_primary_store_id;
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = g_strdup_printf ("%s %s", FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA, FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY);
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = _data_->_tmp68_;
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_NO_PRIMARY_STORE, _data_->_tmp65_, _data_->_tmp66_, _data_->_tmp67_, _data_->_tmp69_);
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = _data_->_tmp70_;
		_g_free0 (_data_->_tmp69_);
		_g_free0 (_data_->_tmp65_);
		_g_free0 (_data_->_tmp62_);
		_g_free0 (_data_->_tmp60_);
		_g_free0 (_data_->_tmp57_);
		_data_->_inner_error_ = _data_->_tmp71_;
		if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->new_persona);
			_g_hash_table_unref0 (_data_->details);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	} else {
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = _data_->new_persona;
		if (_data_->_tmp72_ == NULL) {
			_data_->_tmp73_ = NULL;
			_data_->_tmp73_ = _ ("Can't write to requested property (“%s”) of the writeable store.");
			_data_->_tmp74_ = NULL;
			_data_->_tmp74_ = _data_->property_name;
			_data_->_tmp75_ = NULL;
			_data_->_tmp75_ = g_error_new (FOLKS_INDIVIDUAL_AGGREGATOR_ERROR, FOLKS_INDIVIDUAL_AGGREGATOR_ERROR_PROPERTY_NOT_WRITEABLE, _data_->_tmp73_, _data_->_tmp74_);
			_data_->_inner_error_ = _data_->_tmp75_;
			if (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->new_persona);
				_g_hash_table_unref0 (_data_->details);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	_data_->_tmp76_ = NULL;
	_data_->_tmp76_ = _data_->new_persona;
	_data_->_tmp77_ = NULL;
	_data_->_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp76_, FOLKS_TYPE_PERSONA, FolksPersona));
	_data_->result = _data_->_tmp77_;
	_g_object_unref0 (_data_->new_persona);
	_g_hash_table_unref0 (_data_->details);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->new_persona);
	_g_hash_table_unref0 (_data_->details);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_individual_aggregator_look_up_individual_data_free (gpointer _data) {
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksIndividualAggregatorLookUpIndividualData, _data_);
}


void folks_individual_aggregator_look_up_individual (FolksIndividualAggregator* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	FolksIndividualAggregator* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksIndividualAggregatorLookUpIndividualData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_individual_aggregator_look_up_individual);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_individual_aggregator_look_up_individual_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	folks_individual_aggregator_look_up_individual_co (_data_);
}


FolksIndividual* folks_individual_aggregator_look_up_individual_finish (FolksIndividualAggregator* self, GAsyncResult* _res_, GError** error) {
	FolksIndividual* result;
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Look up an individual in the aggregator.
   *
   * This returns the {@link Individual} with the given ``id`` if it exists in
   * the aggregator, and ``null`` otherwise.
   *
   * In future, when lazy-loading of individuals' properties is added to folks,
   * this method guarantees to load all properties of the individual, even if
   * the aggregator hasn't lazy-loaded anything else.
   *
   * This method is safe to call before {@link IndividualAggregator.prepare} has
   * been called, and will call {@link IndividualAggregator.prepare} itself in
   * that case.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param id ID of the individual to look up
   * @return individual with ``id``, or ``null`` if no such individual was found
   * @throws GLib.Error from {@link IndividualAggregator.prepare}
   *
   * @since 0.7.0
   */
static void folks_individual_aggregator_look_up_individual_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksIndividualAggregatorLookUpIndividualData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_individual_aggregator_look_up_individual_co (_data_);
}


static gboolean folks_individual_aggregator_look_up_individual_co (FolksIndividualAggregatorLookUpIndividualData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	folks_individual_aggregator_prepare (_data_->self, folks_individual_aggregator_look_up_individual_ready, _data_);
	return FALSE;
	_state_1:
	folks_individual_aggregator_prepare_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_individuals;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = gee_map_get (_data_->_tmp0_, _data_->_tmp1_);
	_data_->result = (FolksIndividual*) _data_->_tmp2_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gboolean folks_individual_aggregator_get_is_prepared (FolksIndividualAggregator* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


gboolean folks_individual_aggregator_get_is_quiescent (FolksIndividualAggregator* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


FolksPersonaStore* folks_individual_aggregator_get_primary_store (FolksIndividualAggregator* self) {
	FolksPersonaStore* result;
	FolksPersonaStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_store;
	result = _tmp0_;
	return result;
}


FolksBackendStore* folks_individual_aggregator_get_backend_store (FolksIndividualAggregator* self) {
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}


static void folks_individual_aggregator_set_backend_store (FolksIndividualAggregator* self, FolksBackendStore* value) {
	FolksBackendStore* _tmp0_ = NULL;
	FolksBackendStore* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp1_;
	g_object_notify ((GObject *) self, "backend-store");
}


GeeMap* folks_individual_aggregator_get_individuals (FolksIndividualAggregator* self) {
	GeeMap* result;
	GeeMap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individuals_ro;
	result = _tmp0_;
	return result;
}


static void folks_individual_aggregator_set_individuals (FolksIndividualAggregator* self, GeeMap* value) {
	GeeMap* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = _tmp1_;
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = gee_map_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp4_;
	g_object_notify ((GObject *) self, "individuals");
}


FolksIndividual* folks_individual_aggregator_get_user (FolksIndividualAggregator* self) {
	FolksIndividual* result;
	FolksIndividual* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}


static void folks_individual_aggregator_set_user (FolksIndividualAggregator* self, FolksIndividual* value) {
	FolksIndividual* _tmp0_ = NULL;
	FolksIndividual* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_user);
	self->priv->_user = _tmp1_;
	g_object_notify ((GObject *) self, "user");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static void _g_ptr_array_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}


static void __folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	_folks_individual_aggregator_primary_store_setting_changed_cb ((FolksIndividualAggregator*) self, _sender, key);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static GObject * folks_individual_aggregator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksIndividualAggregator * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	GHashFunc _tmp5_ = NULL;
	GEqualFunc _tmp6_ = NULL;
	GHashTable* _tmp7_ = NULL;
	FolksSmallSet* _tmp8_ = NULL;
	FolksDebug* _tmp9_ = NULL;
	FolksDebug* _tmp10_ = NULL;
	gchar* store_config_ids = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* disable_linking = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp43_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_individual_aggregator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_stores);
	self->priv->_stores = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_individuals);
	self->priv->_individuals = (GeeMap*) _tmp1_;
	_tmp2_ = self->priv->_individuals;
	_tmp3_ = gee_map_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->_individuals_ro);
	self->priv->_individuals_ro = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->_link_map);
	self->priv->_link_map = _tmp7_;
	_tmp8_ = folks_small_set_new (FOLKS_TYPE_BACKEND, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_backends);
	self->priv->_backends = _tmp8_;
	_tmp9_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp9_;
	_tmp10_ = self->priv->_debug;
	g_signal_connect_object (_tmp10_, "print-status", (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self, 0);
	_tmp11_ = g_getenv ("FOLKS_PRIMARY_STORE");
	_tmp12_ = g_strdup (_tmp11_);
	store_config_ids = _tmp12_;
	_tmp13_ = store_config_ids;
	if (_tmp13_ == NULL) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp14_ = g_getenv ("FOLKS_WRITEABLE_STORE");
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (store_config_ids);
		store_config_ids = _tmp15_;
		_tmp16_ = store_config_ids;
		if (_tmp16_ != NULL) {
			gchar* deprecated_warn = NULL;
			gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			_tmp17_ = g_strdup ("FOLKS_WRITEABLE_STORE is deprecated, ");
			deprecated_warn = _tmp17_;
			_tmp18_ = deprecated_warn;
			_tmp19_ = g_strconcat (_tmp18_, "use FOLKS_PRIMARY_STORE", NULL);
			_g_free0 (deprecated_warn);
			deprecated_warn = _tmp19_;
			_tmp20_ = deprecated_warn;
			g_warning ("individual-aggregator.vala:478: %s", _tmp20_);
			_g_free0 (deprecated_warn);
		}
	}
	_tmp21_ = store_config_ids;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_ = NULL;
		g_debug ("individual-aggregator.vala:484: Setting primary store IDs from environ" \
"ment variable.");
		_tmp22_ = store_config_ids;
		_folks_individual_aggregator_configure_primary_store (self, (const gchar*) _tmp22_);
	} else {
		gboolean _tmp23_ = FALSE;
		GSettings* _tmp28_ = NULL;
		GSettings* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		GSettings* _tmp31_ = NULL;
		g_debug ("individual-aggregator.vala:489: Setting primary store IDs to defaults.");
		_tmp23_ = HAVE_EDS;
		if (_tmp23_) {
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			_tmp24_ = g_strdup ("eds");
			_g_free0 (self->priv->_configured_primary_store_type_id);
			self->priv->_configured_primary_store_type_id = _tmp24_;
			_tmp25_ = g_strdup ("system-address-book");
			_g_free0 (self->priv->_configured_primary_store_id);
			self->priv->_configured_primary_store_id = _tmp25_;
		} else {
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			_tmp26_ = g_strdup ("key-file");
			_g_free0 (self->priv->_configured_primary_store_type_id);
			self->priv->_configured_primary_store_type_id = _tmp26_;
			_tmp27_ = g_strdup ("");
			_g_free0 (self->priv->_configured_primary_store_id);
			self->priv->_configured_primary_store_id = _tmp27_;
		}
		_tmp28_ = g_settings_new (FOLKS_INDIVIDUAL_AGGREGATOR__FOLKS_GSETTINGS_SCHEMA);
		_g_object_unref0 (self->priv->_primary_store_setting);
		self->priv->_primary_store_setting = _tmp28_;
		_tmp29_ = self->priv->_primary_store_setting;
		_tmp30_ = g_strconcat ("changed::", FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY, NULL);
		g_signal_connect_object (_tmp29_, _tmp30_, (GCallback) __folks_individual_aggregator_primary_store_setting_changed_cb_g_settings_changed, self, 0);
		_g_free0 (_tmp30_);
		_tmp31_ = self->priv->_primary_store_setting;
		_folks_individual_aggregator_primary_store_setting_changed_cb (self, _tmp31_, FOLKS_INDIVIDUAL_AGGREGATOR__PRIMARY_STORE_CONFIG_KEY);
	}
	_tmp32_ = self->priv->_configured_primary_store_type_id;
	_tmp33_ = self->priv->_configured_primary_store_id;
	g_debug ("individual-aggregator.vala:509: Primary store IDs are '%s' and '%s'.", _tmp32_, _tmp33_);
	_tmp34_ = g_getenv ("FOLKS_DISABLE_LINKING");
	_tmp35_ = g_strdup (_tmp34_);
	disable_linking = _tmp35_;
	_tmp36_ = disable_linking;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp37_ = disable_linking;
		_tmp38_ = string_strip ((const gchar*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_utf8_strdown (_tmp39_, (gssize) (-1));
		_g_free0 (disable_linking);
		disable_linking = _tmp40_;
		_g_free0 (_tmp39_);
	}
	_tmp43_ = disable_linking;
	if (_tmp43_ == NULL) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp44_ = NULL;
		_tmp44_ = disable_linking;
		_tmp42_ = g_strcmp0 (_tmp44_, "no") == 0;
	}
	if (_tmp42_) {
		_tmp41_ = TRUE;
	} else {
		const gchar* _tmp45_ = NULL;
		_tmp45_ = disable_linking;
		_tmp41_ = g_strcmp0 (_tmp45_, "0") == 0;
	}
	self->priv->_linking_enabled = _tmp41_;
	g_debug ("individual-aggregator.vala:519: Constructing IndividualAggregator %p", self);
	_g_free0 (disable_linking);
	_g_free0 (store_config_ids);
	return obj;
}


static void folks_individual_aggregator_class_init (FolksIndividualAggregatorClass * klass) {
	folks_individual_aggregator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualAggregatorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_individual_aggregator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_individual_aggregator_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_individual_aggregator_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_aggregator_finalize;
	/**
	   * Whether {@link IndividualAggregator.prepare} has successfully completed for
	   * this aggregator.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the aggregator has reached a quiescent state. This will happen at
	   * some point after {@link IndividualAggregator.prepare} has successfully
	   * completed for the aggregator. An aggregator is in a quiescent state when
	   * all the {@link PersonaStore}s listed by its backends have reached a
	   * quiescent state. Once it's reached a quiescent state, this property will
	   * never change again (from ``true`` to ``false``).
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link IndividualAggregator.is_prepared} has changed to ``true``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Our configured primary (writeable) store.
	   *
	   * Which one to use is decided (in order or precedence)
	   * by:
	   *
	   * - the FOLKS_PRIMARY_STORE env var (mostly for debugging)
	   * - the GSettings key set in ``_PRIMARY_STORE_CONFIG_KEY`` (system set store)
	   * - going with the ``key-file`` or ``eds`` store as the fall-back option
	   *
	   * @since 0.5.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE, g_param_spec_object ("primary-store", "primary-store", "primary-store", FOLKS_TYPE_PERSONA_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The backend store providing the persona stores for this aggregator.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE, g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * A map from {@link Individual.id}s to their {@link Individual}s.
	   *
	   * This is the canonical set of {@link Individual}s provided by this
	   * IndividualAggregator.
	   *
	   * {@link Individual}s may be added or removed using
	   * {@link IndividualAggregator.add_persona_from_details} and
	   * {@link IndividualAggregator.remove_individual}, respectively.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS, g_param_spec_object ("individuals", "individuals", "individuals", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The {@link Individual} representing the user.
	   *
	   * If it exists, this holds the {@link Individual} who is the user: the
	   * {@link Individual} containing the {@link Persona}s who are the owners of
	   * the accounts for their respective backends.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AGGREGATOR_USER, g_param_spec_object ("user", "user", "user", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * If more information about the relationships between {@link Individual}s
	   * which have been linked and unlinked is needed, consider connecting to
	   * {@link IndividualAggregator.individuals_changed_detailed} instead, which is
	   * emitted at the same time as this signal.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param added a list of {@link Individual}s which have been added
	   * @param removed a list of {@link Individual}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	g_signal_new ("individuals_changed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when one or more {@link Individual}s are added to or removed from
	   * the aggregator.
	   *
	   * This is emitted at the same time as
	   * {@link IndividualAggregator.individuals_changed}, but includes more
	   * information about the relationships between {@link Individual}s which have
	   * been linked and unlinked.
	   *
	   * Individuals which have been linked will be listed in the multi-map as
	   * mappings from the old individuals to the single new individual which
	   * replaces them (i.e. each of the old individuals will map to the same new
	   * individual). This new individual is the one which will be specified as the
	   * ``replacement_individual`` in the {@link Individual.removed} signal for the
	   * old individuals.
	   *
	   * Individuals which have been unlinked will be listed in the multi-map as
	   * a mapping from the unlinked individual to a set of one or more individuals
	   * which replace it.
	   *
	   * Individuals which have been added will be listed in the multi-map as a
	   * mapping from ``null`` to the set of added individuals. If ``null`` doesn't
	   * map to anything, no individuals have been added to the aggregator.
	   *
	   * Individuals which have been removed will be listed in the multi-map as
	   * mappings from the removed individual to ``null``.
	   *
	   * This will not be emitted until after {@link IndividualAggregator.prepare}
	   * has been called.
	   *
	   * @param changes a mapping of old {@link Individual}s to new
	   * {@link Individual}s for the individuals which have changed in the
	   * aggregator
	   *
	   * @since 0.6.2
	   */
	g_signal_new ("individuals_changed_detailed", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MULTI_MAP);
	g_static_rec_mutex_init (&__lock_folks_individual_aggregator__instance);
}


static void folks_individual_aggregator_instance_init (FolksIndividualAggregator * self) {
	self->priv = FOLKS_INDIVIDUAL_AGGREGATOR_GET_PRIVATE (self);
	self->priv->_primary_store = NULL;
	self->priv->_primary_store_setting = NULL;
	self->priv->_linking_enabled = TRUE;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_non_quiescent_persona_store_count = (guint) 0;
	self->priv->_non_quiescent_backend_count = (guint) 0;
	self->priv->_is_quiescent = FALSE;
	self->priv->_quiescent_timeout_id = (guint) 0;
	self->priv->_user_configured_primary_store = FALSE;
}


static void folks_individual_aggregator_finalize (GObject* obj) {
	FolksIndividualAggregator * self;
	guint _tmp0_ = 0U;
	FolksBackendStore* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	FolksDebug* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	g_debug ("individual-aggregator.vala:524: Destroying IndividualAggregator %p", self);
	_tmp0_ = self->priv->_quiescent_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->_quiescent_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->_quiescent_timeout_id = (guint) 0;
	}
	_tmp2_ = self->priv->_backend_store;
	g_signal_parse_name ("backend-available", FOLKS_TYPE_BACKEND_STORE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) __folks_individual_aggregator_backend_available_cb_folks_backend_store_backend_available, self);
	_tmp4_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __folks_individual_aggregator_debug_print_status_folks_debug_print_status, self);
	{
		FolksIndividualAggregator* _tmp6_ = NULL;
		_tmp6_ = folks_individual_aggregator__instance;
		g_static_rec_mutex_lock (&__lock_folks_individual_aggregator__instance);
		{
			folks_individual_aggregator__instance = NULL;
		}
		__finally15:
		{
			FolksIndividualAggregator* _tmp7_ = NULL;
			_tmp7_ = folks_individual_aggregator__instance;
			g_static_rec_mutex_unlock (&__lock_folks_individual_aggregator__instance);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_stores);
	_g_object_unref0 (self->priv->_backends);
	_g_object_unref0 (self->priv->_primary_store_setting);
	_g_hash_table_unref0 (self->priv->_link_map);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_debug);
	_g_free0 (self->priv->_configured_primary_store_type_id);
	_g_free0 (self->priv->_configured_primary_store_id);
	_g_object_unref0 (self->priv->_individuals);
	_g_object_unref0 (self->priv->_individuals_ro);
	_g_object_unref0 (self->priv->_user);
	G_OBJECT_CLASS (folks_individual_aggregator_parent_class)->finalize (obj);
}


/**
 * Stores {@link Individual}s which have been created through
 * aggregation of all the {@link Persona}s provided by the various
 * {@link Backend}s.
 *
 * This is the main interface for client applications.
 *
 * Linking and unlinking of personas and individuals is performed entirely
 * through the aggregator. Personas may be linked together to form individuals;
 * for example, the personas which form ``individual1`` and ``individual2`` may
 * be linked together with ``another_persona`` to give a new {@link Individual}:
 *
 * {{{
 *   var personas = new HashSet<Persona> ();
 *   personas.add_all (individual1.personas);
 *   personas.add_all (individual2.personas);
 *   personas.add (another_persona);
 *   yield my_individual_aggregator.link_personas (personas);
 * }}}
 *
 * The individuals which contained those personas will be removed when
 * {@link IndividualAggregator.link_personas} is called. Any personas in those
 * individuals which were not included in the linking call may end up implicitly
 * linked to the new individual, or may be aggregated into other new
 * individuals.
 *
 * For example, consider the situation where ``individual1`` contains two
 * personas, ``persona1A`` and ``persona1B``; ``individual2`` contains one
 * persona, ``persona2A``; and ``another_persona`` comes from ``individual3``,
 * which also contains ``persona3A`` and ``persona3B``. Calling
 * {@link IndividualAggregator.link_personas} on ``persona1A``, ``persona1B``,
 * ``persona2A`` and ``another_persona`` will result in ``individual1`` and
 * ``individual2`` being removed. A new {@link Individual} will be created
 * containing all the personas passed to the linking function. It might also
 * contain ``persona3A`` and ``persona3B``; or they might be in one or two other
 * new individuals.
 *
 * An existing individual may be unlinked to form singleton
 * individuals for each of its personas:
 * {{{
 *   yield my_individual_aggregator.unlink_individual (my_individual);
 * }}}
 *
 * Note that to link two individuals together, their two sets of personas must
 * be linked together. There is no API to directly link the individuals
 * themselves, as conceptually folks links {@link Persona}s, not
 * {@link Individual}s.
 *
 * Folks does not support having more than one IndividualAggregator
 * instantiated at the same time. Most clients should use
 * {@link IndividualAggregator.dup} to retrieve the IndividualAggregator
 * singleton.
 *
 */
GType folks_individual_aggregator_get_type (void) {
	static volatile gsize folks_individual_aggregator_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_aggregator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualAggregatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_aggregator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividualAggregator), 0, (GInstanceInitFunc) folks_individual_aggregator_instance_init, NULL };
		GType folks_individual_aggregator_type_id;
		folks_individual_aggregator_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividualAggregator", &g_define_type_info, 0);
		g_once_init_leave (&folks_individual_aggregator_type_id__volatile, folks_individual_aggregator_type_id);
	}
	return folks_individual_aggregator_type_id__volatile;
}


static void _vala_folks_individual_aggregator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_PREPARED:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_prepared (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_IS_QUIESCENT:
		g_value_set_boolean (value, folks_individual_aggregator_get_is_quiescent (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_PRIMARY_STORE:
		g_value_set_object (value, folks_individual_aggregator_get_primary_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE:
		g_value_set_object (value, folks_individual_aggregator_get_backend_store (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		g_value_set_object (value, folks_individual_aggregator_get_individuals (self));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		g_value_set_object (value, folks_individual_aggregator_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_individual_aggregator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividualAggregator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, FolksIndividualAggregator);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AGGREGATOR_BACKEND_STORE:
		folks_individual_aggregator_set_backend_store (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_INDIVIDUALS:
		folks_individual_aggregator_set_individuals (self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_AGGREGATOR_USER:
		folks_individual_aggregator_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



